(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14906,        500]
NotebookOptionsPosition[      9444,        360]
NotebookOutlinePosition[     12250,        413]
CellTagsIndexPosition[     12207,        410]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Graph Utilities Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToCombinatoricaGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/ToCombinatoricaGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox[ButtonBox["Combinatorica",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/CombinatoricaPackage"],
  FontSlant->"Italic"],
 " representation of a graph"
}], "GuideText",
 CellID->708609554],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexList",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/VertexList"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of all vertices in a graph"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["EdgeList",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/EdgeList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of all edges in a graph"
}], "GuideText",
 CellID->691918961],

Cell["\t", "GuideDelimiter",
 CellID->117595006],

Cell[TextData[{
 Cell[TextData[ButtonBox["PseudoDiameter",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/PseudoDiameter"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " pseudo-diameter of an undirected graph and the two vertices used"
}], "GuideText",
 CellID->61410741],

Cell["\t", "GuideDelimiter",
 CellID->58115805],

Cell[TextData[{
 Cell[TextData[ButtonBox["MaximalIndependentVertexSet",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentVertexSet"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " maximal independent vertex set of a graph"
}], "GuideText",
 CellID->236117851],

Cell[TextData[{
 Cell[TextData[ButtonBox["MaximalIndependentEdgeSet",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " maximal independent edge set"
}], "GuideText",
 CellID->309761123],

Cell[TextData[{
 Cell[TextData[ButtonBox["MaximalBipartiteMatching",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/MaximalBipartiteMatching"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " maximal matching of a bipartite graph"
}], "GuideText",
 CellID->416775163],

Cell[TextData[{
 Cell[TextData[ButtonBox["StrongComponents",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/StrongComponents"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of strongly connected components in a graph"
}], "GuideText",
 CellID->606577999],

Cell[TextData[{
 Cell[TextData[ButtonBox["WeakComponents",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/WeakComponents"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of weakly connected components in a graph"
}], "GuideText",
 CellID->1677492618],

Cell[TextData[{
 Cell[TextData[ButtonBox["Bicomponents",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/Bicomponents"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " biconnected components of a graph"
}], "GuideText",
 CellID->199754805],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphCoordinates",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 2D layout of the vertices of a graph"
}], "GuideText",
 CellID->678994244],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphCoordinates3D",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates3D"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 3D layout of the vertices"
}], "GuideText",
 CellID->269143664],

Cell["\t", "GuideDelimiter",
 CellID->46465739],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PageRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRanks"], ",", " ", 
   ButtonBox["PageRankVector",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRankVector"]}]], 
  "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " page rank of a graph"
}], "GuideText",
 CellID->281262704],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/LinkRanks"], ",", " ", 
   ButtonBox["LinkRankMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/LinkRankMatrix"]}]], 
  "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " link rank of a graph"
}], "GuideText",
 CellID->118709440],

Cell["\t", "GuideDelimiter",
 CellID->826955396],

Cell[TextData[{
 Cell[TextData[ButtonBox["MinCut",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/MinCut"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " partition a graph into a given number of parts, minimizing edge cuts"
}], "GuideText",
 CellID->456148775],

Cell["\t", "GuideDelimiter",
 CellID->795018632],

Cell[TextData[{
 Cell[TextData[ButtonBox["CommunityStructureAssignment",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/CommunityStructureAssignment"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " assignment of vertices in a graph into communities"
}], "GuideText",
 CellID->84893046],

Cell[TextData[{
 Cell[TextData[ButtonBox["CommunityStructurePartition",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/CommunityStructurePartition"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " partition of a graph into communities"
}], "GuideText",
 CellID->43204519],

Cell[TextData[{
 Cell[TextData[ButtonBox["CommunityModularity",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/CommunityModularity"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " community modularity of a given partition or assignment"
}], "GuideText",
 CellID->37250459],

Cell["\t", "GuideDelimiter",
 CellID->164842709],

Cell[TextData[{
 Cell[TextData[ButtonBox["MinimumBandwidthOrdering",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/MinimumBandwidthOrdering"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " vertex ordering that minimizes the bandwidth of a graph"
}], "GuideText",
 CellID->189493514],

Cell["\t", "GuideDelimiter",
 CellID->380247058],

Cell[TextData[{
 Cell[TextData[ButtonBox["ClosenessCentrality",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/ClosenessCentrality"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " closeness centrality of a graph"
}], "GuideText",
 CellID->72766],

Cell["\t", "GuideDelimiter",
 CellID->117886419],

Cell[TextData[{
 Cell[TextData[ButtonBox["LineScaledCoordinate",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/LineScaledCoordinate"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " coordinate in a polyline at a given scaled distance from an endpoint"
}], "GuideText",
 CellID->319092199],

Cell["\t", "GuideDelimiter",
 CellID->941784096],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphEdit",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/GraphEdit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " interactive graph editor for inputting and editing graphs"
}], "GuideText",
 CellID->546160470],

Cell["\t", "GuideDelimiter",
 CellID->1957428251],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExpressionTreePlot",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/ExpressionTreePlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot an expression tree"
}], "GuideText",
 CellID->1732122434]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/tutorial/GraphUtilities"]], "GuideTutorial",
 CellID->382995644]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Mathematical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalData"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graph Utilities Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 58.8820226}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Graph Utilities Package Guide", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "AdjacencyMatrix -- SparseArray object representing a graph, \
ToCombinatoricaGraph -- Combinatorica representation of a graph, VertexList \
-- list of all vertices in a graph, EdgeList -- list of all edges in a graph, \
GraphDistance -- distance between two vertices in a graph, GraphPath -- \
shortest path between two vertices, GraphDistanceMatrix -- matrix of shortest \
paths between all vertices, PseudoDiameter -- pseudo-diameter of an \
undirected graph and the two vertices used, MaximalIndependentVertexSet -- \
maximal independent vertex set of a graph, MaximalIndependentEdgeSet -- \
maximal independent edge set, MaximalBipartiteMatching -- maximal matching of \
a bipartite graph, StrongComponents -- list of strongly connected components \
in a graph, WeakComponents -- list of weakly connected components in a graph, \
Bicomponents -- biconnected components of a graph, GraphCoordinates -- 2D \
layout of the vertices of a graph, GraphCoordinates3D -- 3D layout of the \
vertices, PageRanks, PageRankVector -- page rank of a graph, LinkRanks, \
LinkRankMatrix -- link rank of a graph, MinCut -- partition a graph into a \
given number of parts, minimizing edge cuts, CommunityStructureAssignment -- \
assignment of vertices in a graph into communities, \
CommunityStructurePartition -- partition of a graph into communities, \
CommunityModularity -- community modularity of a given partition or \
assignment, MinimumBandwidthOrdering -- vertex ordering that minimizes the \
bandwidth of a graph, ClosenessCentrality -- closeness centrality of a graph, \
LineScaledCoordinate -- coordinate in a polyline at a given scaled distance \
from an endpoint, GraphEdit -- interactive graph editor for inputting and \
editing graphs, ExpressionTreePlot -- plot an expression tree", 
    "synonyms" -> {"GraphUtilities"}, "title" -> "Graph Utilities Package", 
    "type" -> "Guide", "uri" -> 
    "GraphUtilities/guide/GraphUtilitiesPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[687, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[746, 31, 445, 14, 70, "GuideText",
 CellID->708609554],
Cell[1194, 47, 278, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1475, 58, 267, 8, 70, "GuideText",
 CellID->691918961],
Cell[1745, 68, 48, 1, 70, "GuideDelimiter",
 CellID->117595006],
Cell[1796, 71, 317, 9, 70, "GuideText",
 CellID->61410741],
Cell[2116, 82, 47, 1, 70, "GuideDelimiter",
 CellID->58115805],
Cell[2166, 85, 321, 9, 70, "GuideText",
 CellID->236117851],
Cell[2490, 96, 304, 9, 70, "GuideText",
 CellID->309761123],
Cell[2797, 107, 311, 9, 70, "GuideText",
 CellID->416775163],
Cell[3111, 118, 306, 9, 70, "GuideText",
 CellID->606577999],
Cell[3420, 129, 301, 9, 70, "GuideText",
 CellID->1677492618],
Cell[3724, 140, 283, 9, 70, "GuideText",
 CellID->199754805],
Cell[4010, 151, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[4061, 154, 294, 9, 70, "GuideText",
 CellID->678994244],
Cell[4358, 165, 287, 9, 70, "GuideText",
 CellID->269143664],
Cell[4648, 176, 47, 1, 70, "GuideDelimiter",
 CellID->46465739],
Cell[4698, 179, 411, 14, 70, "GuideText",
 CellID->281262704],
Cell[5112, 195, 411, 14, 70, "GuideText",
 CellID->118709440],
Cell[5526, 211, 48, 1, 70, "GuideDelimiter",
 CellID->826955396],
Cell[5577, 214, 303, 8, 70, "GuideText",
 CellID->456148775],
Cell[5883, 224, 48, 1, 70, "GuideDelimiter",
 CellID->795018632],
Cell[5934, 227, 331, 9, 70, "GuideText",
 CellID->84893046],
Cell[6268, 238, 316, 9, 70, "GuideText",
 CellID->43204519],
Cell[6587, 249, 318, 9, 70, "GuideText",
 CellID->37250459],
Cell[6908, 260, 48, 1, 70, "GuideDelimiter",
 CellID->164842709],
Cell[6959, 263, 329, 9, 70, "GuideText",
 CellID->189493514],
Cell[7291, 274, 48, 1, 70, "GuideDelimiter",
 CellID->380247058],
Cell[7342, 277, 291, 9, 70, "GuideText",
 CellID->72766],
Cell[7636, 288, 48, 1, 70, "GuideDelimiter",
 CellID->117886419],
Cell[7687, 291, 334, 9, 70, "GuideText",
 CellID->319092199],
Cell[8024, 302, 48, 1, 70, "GuideDelimiter",
 CellID->941784096],
Cell[8075, 305, 298, 8, 70, "GuideText",
 CellID->546160470],
Cell[8376, 315, 49, 1, 70, "GuideDelimiter",
 CellID->1957428251],
Cell[8428, 318, 286, 9, 70, "GuideText",
 CellID->1732122434]
}, Open  ]],
Cell[CellGroupData[{
Cell[8751, 332, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8816, 335, 174, 4, 70, "GuideTutorial",
 CellID->382995644]
}, Open  ]],
Cell[CellGroupData[{
Cell[9027, 344, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9092, 347, 157, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[9252, 352, 150, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[9417, 358, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

