(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25631,        827]
NotebookOptionsPosition[     20784,        661]
NotebookOutlinePosition[     22243,        699]
CellTagsIndexPosition[     22158,        694]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToCombinatoricaGraph" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/ToCombinatoricaGraph"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ToCombinatoricaGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AdjacencyMatrix", "ObjectName", "GraphToSparseArray",
 CellID->31079],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AdjacencyMatrix", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      ButtonBox["SparseArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
     " object representing the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AdjacencyMatrix", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the ",
     Cell[BoxData[
      ButtonBox["SparseArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
     " object representing the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ", adding additional unconnected vertices, if necessary, to create a \
graph with ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->2703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The graph ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " can be specified by a rule list, an adjacency matrix, or the ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " representation of a graph."
}], "Notes",
 CellID->7376],

Cell[TextData[{
 "The rows/columns of the ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object correspond to vertices in the order returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexList",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/VertexList"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16118]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->515420879],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->243894156],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->547790834],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " representation of a graph specified by a rule list:"
}], "ExampleText",
 CellID->16541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AdjacencyMatrix", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", "b"}], ",", 
     RowBox[{"b", "\[Rule]", "b"}], ",", 
     RowBox[{"b", "\[Rule]", "a"}], ",", 
     RowBox[{"a", "\[Rule]", "b"}], ",", 
     RowBox[{"b", "\[Rule]", "a"}]}], "}"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1040651162],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwaAGxjAQDkP0fyAJj
rf//gTSEZAWRzCBRMGCQRuOzgFWxoIkyAwlWIJcbSIOE2bHIY+pCt4sLLAjn
g/UwMLDR3CxmNFF0VdjNQvcj04g1CxT2TEAu739I7HMQpUt+VBVUFJSWQUHP
BaWJC3VwDsCIMUrjEZnPg8YnLl7RUxa6KcS5BV0VuinotkBMQS8VCJmCrRzD
XroRG9LElVYgPojL8x9feUlcWQwptxkYAbkjMz4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{42, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->632019440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31115],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->560454997],

Cell[TextData[{
 "This gives a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " representation of a graph specified by a ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " object:"
}], "ExampleText",
 CellID->285713496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GridGraph", "[", 
  RowBox[{"2", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9930],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", "\<\"Undirected\"\>", 
   "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
  SequenceForm[
  "\[SkeletonIndicator]Graph:<", 4, ", ", 4, ", ", "Undirected", 
   ">\[SkeletonIndicator]"],
  Editable->False]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->653477375]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AdjacencyMatrix", "[", "%", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126813536],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl71ugzAQgA2U/hCyd8xrdOnYZulDoKhSMlSt0gxsjIyMjDwCIyMjIyMj
IyMjo3v+ARtCWwYjRS1I2MfluM+c7YvvxTntX9+c02HnbJ6Pzsf+sPvcPL0f
QWVoCKEt3A/3CGQMEr23GEMvtyZpjSiKML2QAY0BpivoTegt3q+4/oYaeZ4n
2SN0RcWiKJIk6bTkNdxeICOb/tRpz56t0beu2xHmeT4khmEoj0MpsWka13UF
0Wi1DMpGoIjIour7Prgnot4R9SzLTOUkmCaYrD6JRrOqqnm+TawNmSjWkXoi
hJIt62+IJKoGZ+jQr6We6O/amHB7bdTL4+D5/1qRGZQzhY37meR2khe2936b
4XHtcHUsxIU4J5FkEDlj2LifUaxJXi51Py8Z5HJX3kL8G8Qlg7RWQRBMsBJ1
imwFZ7S6rtt4/lS9sFkpyzKOYyLKJ0M4nvIKQ/1ZNE3TkfM2DJqPQz0R4tmr
Jeasl4Y1oSDqEFGV30Z2qA4xoz557Sq+SVdMOosXJ7IiaR6i8M2I8n/hWJWy
plaslkfaF2avSok=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->82952148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26924],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->280246881],

Cell["\<\
This adds an extra row and column to the adjacency matrix, corresponding to \
unconnected vertices:\
\>", "ExampleText",
 CellID->5097],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"AdjacencyMatrix", "[", 
    RowBox[{
     RowBox[{"GridGraph", "[", 
      RowBox[{"2", ",", "2"}], "]"}], ",", "5"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1125354799],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmDtvgzAQgI0pfSXZO+bXtMqQOTOKKiVD1SrNwJaRMWNGfgIjIyMjIyMj
I2NGen4QG4JaExVIKyOBz9Zhf9ydT/jm9nb1+mZv10t7+rKxP1br5ef0+X0D
Q6aBEFrAPXtCIBcg0XtRFNDKT4s8Tc/zCnqhGe3vdjveN6nWDRWTJAmCgIik
b8KE4x/au3L2OI7rsx0OB3kNi/CVF8josaPRW7rk8Xh0HEcwmeUow2KMvTEx
O7muCwBExCcmHEWRNQALOBrcXWWhPsuybCj7iPiTmUSsDsEEDmOb5yqY7ovq
zjIamUg8qezeh9p7zbPNtVbNriNoLe4ji/fb27U5csZU6zR61m8fLZpDc/wH
DjmrYWgnUquz2uVaxL9NWWxUG1ezK/v7uiwO1GJILVo0h+b4CxwkqzVlsXFt
XGe1dlo6q2kOzaGz2rVo7fd7BS1Rp5O14Lyf53lpV5UTKPNSmqa+7xNRrl0E
QcCrdd3/2bMaShiGDbUm+CRO1xcH+KBSf1OrU/4+h/C64MDgk+7tQPIDBqvT
lXhtWHw/7mX9M4tzDlZ47JNDrMg45F303QlzQrVZfR0ZXy24jT0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->161141763]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"m", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1165417487],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.12876230392520482`, -0.1587023983023974}, {
    1.12885308302866, -0.12876230392520482`}, {
    0.1598852279825011, -1.1587535880816768`}, {
    1.1588078825720103`, -1.1278376001581658`}, {
    0.12876230392520485`, -1.4162781959320865`}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.12876230392520482`, -0.1587023983023974}, {
     1.12885308302866, -0.12876230392520482`}, {
     0.1598852279825011, -1.1587535880816768`}, {
     1.1588078825720103`, -1.1278376001581658`}, {
     0.12876230392520485`, -1.4162781959320865`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{177, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->341745918]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5732],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1251248012],

Cell[TextData[{
 "This shows the ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " of the adjacency matrix of a ",
 Cell[BoxData[
  ButtonBox["GridGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/GridGraph"]], "InlineFormula"],
 ", and its graph drawing:"
}], "ExampleText",
 CellID->1814315463],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"GridGraph", "[", 
    RowBox[{"5", ",", "4"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1085727450],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"AdjacencyMatrix", "[", "g", "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->42326594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->267878510],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWktvEzEQdrKPpKoABfUVEFDEAXFAHBAHhBDiAD2gSiCEOEcVUntAoNIT
B35HD/yS/rnF9tpZ7+fx2pt0s7RxpHgy65nv8/oxs+v4cHZ2/O377OzkaLZ/
cDr7eXxy9Gv//Y9TfikZMMbO+ffvHuO/C/5Lfs+Lgku7nPAy4QZbSk6VHHI5
5HJX6SyV5uqzw5XUsJrIytuiFMaF/EgrUxdYLK300t+02AY9AV20kmWlPi8t
lJsras22F2FVLTERw3tkS43enTD+ykL5TRdmNfVpGHtmsjM1M1lu+jWNwaSo
5rOQe0omcD1VcgfqyxnuWkU3ePmHlVKVRgt8o3m3pY6jv9kjqxkFMrD4Dbpp
m5SDlZsjR48f6p95kV98lPNKyA1xcQNmh1lKBBEWB0LKa0PdnLnDQqxobyHW
Wc0epNaL0IWKXCN1PSP82zO0uSsKr84YsgKDWJ2j4eBVE4gZaxTnn4enqK/w
EhBX0SFg5EqGrcHovYj3gcMbZ2f0vjzvtw7vW9G7M+9Xyvq+kpihr7dXGa71
R5tgDCexajHcfjspIzlmHYw9WP8CxlIz+vxEPfF08d8yC9XFWO/HNIzPyqg4
hq3uj8zPisl6B8iXYbLQ1M0bTxb6bQB7opHHugONIlmt1fIMsHLQw+J3ROkS
5YkHJSzeR5QuUR55UMJyV0TpEuVeUY+X2hv3Gtbbu56FXbsrjZjWE1J936X9
/scusGjWh5SfZx/kKrAL1cX6QNWn1+Reu2IP2aNp5Gu5VzMBLIxRj8GeXqsR
pUuUTQ/K04jSO0rmQXkeUXpF4UYsIzL/y7X2FP2aQIYJRRA/xxJlDDWYH3UU
1IhvEIkY7VWiChXRXhM9U6GI+UdlZrJNVkYezzFMX9wvIbGs/Rf5Li7/7aL2
XHx9pJ9wR0VTZMTV9o6wi96X4505vD9E7068dbRDz09r7Sms5m9rIQjWu3MZ
UUaATsVkE+sr1GPMz1eMqjOAifaF6Js+2rY8qiuLWdYX9n6iuNb2dAy9019m
w/7O/1RnkFwnleKpv2VbE0/9Lcpq6lf71B8b/ANpVcuQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{152, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->205534773]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "None"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->389826493],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{179, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->429444410]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8668],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->92657749],

Cell["\<\
A second argument specifying fewer vertices than those contained in the graph \
is ignored:\
\>", "ExampleText",
 CellID->9161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AdjacencyMatrix", "[", 
   RowBox[{
    RowBox[{"GridGraph", "[", 
     RowBox[{"2", ",", "2"}], "]"}], ",", "3"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18636],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl71ugzAQgA2U/hCyd8xrdOnYZulDoKhSMlSt0gxsjIyMjDwCIyMjIyMj
IyMjo3v+ARtCWwYjRS1I2MfluM+c7YvvxTntX9+c02HnbJ6Pzsf+sPvcPL0f
QWVoCKEt3A/3CGQMEr23GEMvtyZpjSiKML2QAY0BpivoTegt3q+4/oYaeZ4n
2SN0RcWiKJIk6bTkNdxeICOb/tRpz56t0beu2xHmeT4khmEoj0MpsWka13UF
0Wi1DMpGoIjIour7Prgnot4R9SzLTOUkmCaYrD6JRrOqqnm+TawNmSjWkXoi
hJIt62+IJKoGZ+jQr6We6O/amHB7bdTL4+D5/1qRGZQzhY37meR2khe2936b
4XHtcHUsxIU4J5FkEDlj2LifUaxJXi51Py8Z5HJX3kL8G8Qlg7RWQRBMsBJ1
imwFZ7S6rtt4/lS9sFkpyzKOYyLKJ0M4nvIKQ/1ZNE3TkfM2DJqPQz0R4tmr
Jeasl4Y1oSDqEFGV30Z2qA4xoz557Sq+SVdMOosXJ7IiaR6i8M2I8n/hWJWy
plaslkfaF2avSok=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->499828125]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23910],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ToCombinatoricaGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/ToCombinatoricaGraph"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->12707]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18957],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->24801]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AdjacencyMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 59.1007782}", "context" -> 
    "GraphUtilities`", "keywords" -> {"networks graphs sparse matrices"}, 
    "index" -> True, "label" -> "Graph Utilities Package Symbol", "language" -> 
    "en", "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "AdjacencyMatrix[g] gives the SparseArray object representing the graph \
g. AdjacencyMatrix[g, n] gives the SparseArray object representing the graph \
g, adding additional unconnected vertices, if necessary, to create a graph \
with n vertices.", "synonyms" -> {}, "title" -> "AdjacencyMatrix", "type" -> 
    "Symbol", "uri" -> "GraphUtilities/ref/AdjacencyMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4513, 156, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->515420879]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22015, 687}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1254, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1877, 60, 75, 1, 70, "ObjectName",
 CellID->31079],
Cell[1955, 63, 1286, 40, 70, "Usage",
 CellID->2703]
}, Open  ]],
Cell[CellGroupData[{
Cell[3278, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3756, 125, 264, 9, 70, "Notes",
 CellID->7376],
Cell[4023, 136, 453, 15, 70, "Notes",
 CellID->16118]
}, Closed]],
Cell[CellGroupData[{
Cell[4513, 156, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->515420879],
Cell[CellGroupData[{
Cell[4898, 170, 148, 5, 70, "ExampleSection",
 CellID->243894156],
Cell[5049, 177, 139, 4, 70, "Input",
 CellID->547790834],
Cell[5191, 183, 240, 8, 70, "ExampleText",
 CellID->16541],
Cell[CellGroupData[{
Cell[5456, 195, 387, 12, 28, "Input",
 CellID->1040651162],
Cell[5846, 209, 507, 12, 63, "Output",
 Evaluatable->False,
 CellID->632019440]
}, Open  ]],
Cell[6368, 224, 121, 3, 70, "ExampleDelimiter",
 CellID->31115],
Cell[6492, 229, 139, 4, 70, "Input",
 CellID->560454997],
Cell[6634, 235, 307, 11, 70, "ExampleText",
 CellID->285713496],
Cell[CellGroupData[{
Cell[6966, 250, 123, 4, 70, "Input",
 CellID->9930],
Cell[7092, 256, 592, 15, 36, "Output",
 CellID->653477375]
}, Open  ]],
Cell[CellGroupData[{
Cell[7721, 276, 144, 4, 28, "Input",
 CellID->126813536],
Cell[7868, 282, 787, 17, 92, "Output",
 Evaluatable->False,
 CellID->82952148]
}, Open  ]],
Cell[8670, 302, 121, 3, 70, "ExampleDelimiter",
 CellID->26924],
Cell[8794, 307, 139, 4, 70, "Input",
 CellID->280246881],
Cell[8936, 313, 145, 4, 70, "ExampleText",
 CellID->5097],
Cell[9084, 319, 240, 8, 70, "Input",
 CellID->16512],
Cell[CellGroupData[{
Cell[9349, 331, 103, 3, 28, "Input",
 CellID->1125354799],
Cell[9455, 336, 824, 17, 108, "Output",
 Evaluatable->False,
 CellID->161141763]
}, Open  ]],
Cell[CellGroupData[{
Cell[10316, 358, 175, 5, 70, "Input",
 CellID->1165417487],
Cell[10494, 365, 1697, 43, 237, "Output",
 CellID->341745918]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12240, 414, 232, 7, 70, "ExampleSection",
 CellID->5732],
Cell[12475, 423, 140, 4, 70, "Input",
 CellID->1251248012],
Cell[12618, 429, 396, 13, 70, "ExampleText",
 CellID->1814315463],
Cell[13017, 444, 173, 6, 70, "Input",
 CellID->1085727450],
Cell[13193, 452, 152, 5, 70, "Input",
 CellID->42326594],
Cell[CellGroupData[{
Cell[13370, 461, 106, 3, 70, "Input",
 CellID->267878510],
Cell[13479, 466, 1294, 25, 70, "Output",
 Evaluatable->False,
 CellID->205534773]
}, Open  ]],
Cell[CellGroupData[{
Cell[14810, 496, 222, 6, 70, "Input",
 CellID->389826493],
Cell[15035, 504, 2978, 53, 70, "Output",
 Evaluatable->False,
 CellID->429444410]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18062, 563, 225, 7, 70, "ExampleSection",
 CellID->8668],
Cell[18290, 572, 138, 4, 70, "Input",
 CellID->92657749],
Cell[18431, 578, 137, 4, 70, "ExampleText",
 CellID->9161],
Cell[CellGroupData[{
Cell[18593, 586, 231, 8, 70, "Input",
 CellID->18636],
Cell[18827, 596, 788, 17, 70, "Output",
 Evaluatable->False,
 CellID->499828125]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19676, 620, 311, 9, 70, "SeeAlsoSection",
 CellID->23910],
Cell[19990, 631, 235, 6, 70, "SeeAlso",
 CellID->12707]
}, Open  ]],
Cell[CellGroupData[{
Cell[20262, 642, 314, 9, 70, "TutorialsSection",
 CellID->18957],
Cell[20579, 653, 163, 3, 70, "Tutorials",
 CellID->24801]
}, Open  ]],
Cell[20757, 659, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

