(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35675,       1065]
NotebookOptionsPosition[     30482,        887]
NotebookOutlinePosition[     31862,        925]
CellTagsIndexPosition[     31777,        920]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphUtilities" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"GraphUtilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CommunityStructurePartition" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/CommunityStructurePartition"], 
          "CommunityModularity" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/CommunityModularity"], "MinCut" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/MinCut"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"CommunityStructurePartition\"\>", 
       2->"\<\"CommunityModularity\"\>", 
       3->"\<\"MinCut\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CommunityStructureAssignment", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CommunityStructureAssignment", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the assignment of vertices of a graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " into communities. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The assignment groups the vertices into communities, such that there is a \
higher density of edges within communities than between them.\
\>", "Notes",
 CellID->1891110407],

Cell["The following option can be given:", "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Weighted",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Weighted"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether edges with higher weights are preferred during matching\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->230307879]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->243826887],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->607620267],

Cell["This defines a small graph:", "ExampleText",
 CellID->1071124494],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->777723757],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "5"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->352754203],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.945197811745856, 0.36740146076530716`}, {
    0.00010483815689577014`, 0.7347745197853797}, {0., 
    0.00029957617122905456`}, {2.288330695825481, 0.3675178719057222}, {
    3.2343866606398803`, 0.7349856560416538}, {3.234315067430173, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 4}, {2, 3}, {3, 1}, {4, 5}, {5, 6}, {6, 4}}]}, {
      InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.945197811745856, 0.36740146076530716`}, {
     0.00010483815689577014`, 0.7347745197853797}, {0., 
     0.00029957617122905456`}, {2.288330695825481, 0.3675178719057222}, {
     3.2343866606398803`, 0.7349856560416538}, {3.234315067430173, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{318., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{322, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2088158033]
}, Open  ]],

Cell["This finds that the network is grouped into two communities:", \
"ExampleText",
 CellID->1926198728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cs", "=", 
  RowBox[{"CommunityStructureAssignment", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->506162525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "2"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->404515319]
}, Open  ]],

Cell["This shows which vertex is in which community:", "ExampleText",
 CellID->1803887030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"VertexList", "[", "g", "]"}], "\[Rule]", "%"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->709243509],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", "\[Rule]", "1"}], ",", 
   RowBox[{"2", "\[Rule]", "1"}], ",", 
   RowBox[{"1", "\[Rule]", "1"}], ",", 
   RowBox[{"5", "\[Rule]", "2"}], ",", 
   RowBox[{"6", "\[Rule]", "2"}], ",", 
   RowBox[{"7", "\[Rule]", "2"}]}], "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1411227008]
}, Open  ]],

Cell["\<\
This plots the graph, coloring the vertices based on community assignment:\
\>", "ExampleText",
 CellID->303743941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Framed", "[", 
          RowBox[{"#2", ",", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"Hue", "[", 
             RowBox[{
              RowBox[{"cs", "[", 
               RowBox[{"[", "#3", "]"}], "]"}], "/", "4"}], "]"}]}], ",", 
           RowBox[{"FrameStyle", "\[Rule]", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"0.94", ",", "0.85", ",", "0.36"}], "]"}]}]}], "]"}], 
         ",", "#1"}], "]"}], "}"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2145698017],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{329, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->7093830]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->47408070],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Weighted",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5471207],

Cell["This specifies a weighted graph:", "ExampleText",
 CellID->359191262],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1798544291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "3"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", "4"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "6"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], "\[Rule]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1743480554],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "14", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 14, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1759253505]
}, Open  ]],

Cell["This plots the graph with edge weights shown:", "ExampleText",
 CellID->1133957172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Line", "[", "#1", "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#4", "]"}], ",", 
             RowBox[{"Last", "[", "#4", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1096754744],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{323, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->408114021]
}, Open  ]],

Cell["This finds the community structure, ignoring edge weights:", \
"ExampleText",
 CellID->795208938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cs", " ", "=", " ", 
  RowBox[{"CommunityStructureAssignment", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1522779599],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "2"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1977747572]
}, Open  ]],

Cell["\<\
This plots the graph, coloring the vertices based on community assignment:\
\>", "ExampleText",
 CellID->1006413499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Line", "[", "#1", "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#4", "]"}], ",", 
             RowBox[{"Last", "[", "#4", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Framed", "[", 
          RowBox[{"#2", ",", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"Hue", "[", 
             RowBox[{
              RowBox[{"cs", "[", 
               RowBox[{"[", "#3", "]"}], "]"}], "/", "4"}], "]"}]}], ",", 
           RowBox[{"FrameStyle", "\[Rule]", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"0.94", ",", "0.85", ",", "0.36"}], "]"}]}]}], "]"}], 
         ",", "#1"}], "]"}], "}"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->233135815],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{294, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->731359591]
}, Open  ]],

Cell["\<\
This finds the community structure, taking into account the edge weights:\
\>", "ExampleText",
 CellID->714155159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cs", "=", 
  RowBox[{"CommunityStructureAssignment", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Weighted", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->187046627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "2", ",", "3"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->434384304]
}, Open  ]],

Cell["\<\
This plots the graph, coloring the vertices based on community assignment:\
\>", "ExampleText",
 CellID->1183724343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Line", "[", "#1", "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#4", "]"}], ",", 
             RowBox[{"Last", "[", "#4", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Framed", "[", 
          RowBox[{"#2", ",", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"Hue", "[", 
             RowBox[{
              RowBox[{"cs", "[", 
               RowBox[{"[", "#3", "]"}], "]"}], "/", "4"}], "]"}]}], ",", 
           RowBox[{"FrameStyle", "\[Rule]", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"0.94", ",", "0.85", ",", "0.36"}], "]"}]}]}], "]"}], 
         ",", "#1"}], "]"}], "}"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->396997555],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{296, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->111944309]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CommunityStructurePartition",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/CommunityStructurePartition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CommunityModularity",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/CommunityModularity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinCut",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/MinCut"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["GraphUtilities",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CommunityStructureAssignment - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 6.6790972}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {"network analysis graph partition graph partitioning"}, 
    "index" -> True, "label" -> "Graph Utilities Package Symbol", "language" -> 
    "en", "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "CommunityStructureAssignment[g] gives the assignment of vertices of a \
graph g into communities. ", "synonyms" -> {}, "title" -> 
    "CommunityStructureAssignment", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/CommunityStructureAssignment"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4756, 152, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->243826887]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31634, 913}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2157, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2780, 82, 71, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2854, 85, 515, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3406, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3884, 122, 183, 4, 70, "Notes",
 CellID->1891110407],
Cell[4070, 128, 72, 1, 70, "Notes",
 CellID->1067943069],
Cell[4145, 131, 574, 16, 70, "3ColumnTableMod",
 CellID->230307879]
}, Closed]],
Cell[CellGroupData[{
Cell[4756, 152, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->243826887],
Cell[CellGroupData[{
Cell[5141, 166, 148, 5, 70, "ExampleSection",
 CellID->607620267],
Cell[5292, 173, 71, 1, 70, "ExampleText",
 CellID->1071124494],
Cell[5366, 176, 139, 4, 70, "Input",
 CellID->777723757],
Cell[CellGroupData[{
Cell[5530, 184, 567, 16, 47, "Input",
 CellID->352754203],
Cell[6100, 202, 1917, 47, 99, "Output",
 CellID->2088158033]
}, Open  ]],
Cell[8032, 252, 106, 2, 70, "ExampleText",
 CellID->1926198728],
Cell[CellGroupData[{
Cell[8163, 258, 148, 4, 70, "Input",
 CellID->506162525],
Cell[8314, 264, 247, 8, 36, "Output",
 CellID->404515319]
}, Open  ]],
Cell[8576, 275, 90, 1, 70, "ExampleText",
 CellID->1803887030],
Cell[CellGroupData[{
Cell[8691, 280, 169, 5, 70, "Input",
 CellID->709243509],
Cell[8863, 287, 425, 13, 36, "Output",
 CellID->1411227008]
}, Open  ]],
Cell[9303, 303, 125, 3, 70, "ExampleText",
 CellID->303743941],
Cell[CellGroupData[{
Cell[9453, 310, 756, 21, 65, "Input",
 CellID->2145698017],
Cell[10212, 333, 2328, 42, 101, "Output",
 Evaluatable->False,
 CellID->7093830]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12589, 381, 221, 7, 70, "ExampleSection",
 CellID->47408070],
Cell[CellGroupData[{
Cell[12835, 392, 227, 7, 70, "ExampleSubsection",
 CellID->5471207],
Cell[13065, 401, 75, 1, 70, "ExampleText",
 CellID->359191262],
Cell[13143, 404, 140, 4, 70, "Input",
 CellID->1798544291],
Cell[CellGroupData[{
Cell[13308, 412, 1643, 51, 70, "Input",
 CellID->1743480554],
Cell[14954, 465, 482, 17, 36, "Output",
 CellID->1759253505]
}, Open  ]],
Cell[15451, 485, 89, 1, 70, "ExampleText",
 CellID->1133957172],
Cell[CellGroupData[{
Cell[15565, 490, 751, 21, 70, "Input",
 CellID->1096754744],
Cell[16319, 513, 2542, 46, 70, "Output",
 Evaluatable->False,
 CellID->408114021]
}, Open  ]],
Cell[18876, 562, 103, 2, 70, "ExampleText",
 CellID->795208938],
Cell[CellGroupData[{
Cell[19004, 568, 159, 4, 70, "Input",
 CellID->1522779599],
Cell[19166, 574, 248, 8, 36, "Output",
 CellID->1977747572]
}, Open  ]],
Cell[19429, 585, 126, 3, 70, "ExampleText",
 CellID->1006413499],
Cell[CellGroupData[{
Cell[19580, 592, 1354, 37, 70, "Input",
 CellID->233135815],
Cell[20937, 631, 2635, 47, 70, "Output",
 Evaluatable->False,
 CellID->731359591]
}, Open  ]],
Cell[23587, 681, 124, 3, 70, "ExampleText",
 CellID->714155159],
Cell[CellGroupData[{
Cell[23736, 688, 213, 6, 70, "Input",
 CellID->187046627],
Cell[23952, 696, 247, 8, 36, "Output",
 CellID->434384304]
}, Open  ]],
Cell[24214, 707, 126, 3, 70, "ExampleText",
 CellID->1183724343],
Cell[CellGroupData[{
Cell[24365, 714, 1354, 37, 70, "Input",
 CellID->396997555],
Cell[25722, 753, 2477, 45, 70, "Output",
 Evaluatable->False,
 CellID->111944309]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28272, 806, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[28591, 817, 801, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[29429, 848, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[29750, 859, 158, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[29945, 867, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[30266, 878, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[30455, 885, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

