(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22855,        748]
NotebookOptionsPosition[     18622,        605]
NotebookOutlinePosition[     19985,        643]
CellTagsIndexPosition[     19900,        638]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CommunityStructureAssignment" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/CommunityStructureAssignment"], 
          "CommunityModularity" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/CommunityModularity"], "MinCut" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/MinCut"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"CommunityStructureAssignment\"\>", 
       2->"\<\"CommunityModularity\"\>", 
       3->"\<\"MinCut\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CommunityStructurePartition", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CommunityStructurePartition", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the partition of a graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " into communities. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The partition groups the vertices into communities, such that there is a \
higher density of edges within communities than between them.\
\>", "Notes",
 CellID->1134634849],

Cell["The following option can be given:", "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Weighted",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Weighted"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether edges with higher weights are preferred during matching\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->57669549]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->391118836],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->108974137],

Cell["This defines a small graph:", "ExampleText",
 CellID->1071124494],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->777723757],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "5"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->352754203],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.945197811745856, 0.36740146076530716`}, {
    0.00010483815689577014`, 0.7347745197853797}, {0., 
    0.00029957617122905456`}, {2.288330695825481, 0.3675178719057222}, {
    3.2343866606398803`, 0.7349856560416538}, {3.234315067430173, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 4}, {2, 3}, {3, 1}, {4, 5}, {5, 6}, {6, 4}}]}, {
      InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.945197811745856, 0.36740146076530716`}, {
     0.00010483815689577014`, 0.7347745197853797}, {0., 
     0.00029957617122905456`}, {2.288330695825481, 0.3675178719057222}, {
     3.2343866606398803`, 0.7349856560416538}, {3.234315067430173, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{318., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{322, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52468533]
}, Open  ]],

Cell["This finds that the network is grouped into two communities:", \
"ExampleText",
 CellID->1926198728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cs", "=", 
  RowBox[{"CommunityStructurePartition", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->506162525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1271301871]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->205076145],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Weighted",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5471207],

Cell["This specifies a weighted graph:", "ExampleText",
 CellID->359191262],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1798544291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "3"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", "4"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "6"}], "}"}], "\[Rule]", "10"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], "\[Rule]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1743480554],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "14", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 14, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1381402974]
}, Open  ]],

Cell["This plots the graph with edge weights shown:", "ExampleText",
 CellID->1133957172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Line", "[", "#1", "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#4", "]"}], ",", 
             RowBox[{"Last", "[", "#4", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1096754744],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{323, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->119581503]
}, Open  ]],

Cell["This finds the community structure, ignoring edge weights:", \
"ExampleText",
 CellID->795208938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cs", " ", "=", " ", 
  RowBox[{"CommunityStructurePartition", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1522779599],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1111125569]
}, Open  ]],

Cell["\<\
This finds the community structure, taking into account the edge weights:\
\>", "ExampleText",
 CellID->714155159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cs", "=", 
  RowBox[{"CommunityStructurePartition", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Weighted", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->187046627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->830987845]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CommunityStructureAssignment",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/CommunityStructureAssignment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CommunityModularity",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/CommunityModularity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinCut",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/MinCut"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1206296122]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CommunityStructurePartition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 6.9603544}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {"network analysis graph partition graph partitioning"}, 
    "index" -> True, "label" -> "Graph Utilities Package Symbol", "language" -> 
    "en", "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "CommunityStructurePartition[g] gives the partition of a graph g into \
communities. ", "synonyms" -> {}, "title" -> "CommunityStructurePartition", 
    "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/CommunityStructurePartition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4760, 152, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->391118836]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19757, 631}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2178, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2801, 82, 70, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2874, 85, 501, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3412, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3890, 122, 182, 4, 70, "Notes",
 CellID->1134634849],
Cell[4075, 128, 72, 1, 70, "Notes",
 CellID->1067943069],
Cell[4150, 131, 573, 16, 70, "3ColumnTableMod",
 CellID->57669549]
}, Closed]],
Cell[CellGroupData[{
Cell[4760, 152, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->391118836],
Cell[CellGroupData[{
Cell[5145, 166, 148, 5, 70, "ExampleSection",
 CellID->108974137],
Cell[5296, 173, 71, 1, 70, "ExampleText",
 CellID->1071124494],
Cell[5370, 176, 139, 4, 70, "Input",
 CellID->777723757],
Cell[CellGroupData[{
Cell[5534, 184, 567, 16, 47, "Input",
 CellID->352754203],
Cell[6104, 202, 1915, 47, 99, "Output",
 CellID->52468533]
}, Open  ]],
Cell[8034, 252, 106, 2, 70, "ExampleText",
 CellID->1926198728],
Cell[CellGroupData[{
Cell[8165, 258, 147, 4, 70, "Input",
 CellID->506162525],
Cell[8315, 264, 323, 11, 36, "Output",
 CellID->1271301871]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8687, 281, 222, 7, 70, "ExampleSection",
 CellID->205076145],
Cell[CellGroupData[{
Cell[8934, 292, 227, 7, 70, "ExampleSubsection",
 CellID->5471207],
Cell[9164, 301, 75, 1, 70, "ExampleText",
 CellID->359191262],
Cell[9242, 304, 140, 4, 70, "Input",
 CellID->1798544291],
Cell[CellGroupData[{
Cell[9407, 312, 1643, 51, 70, "Input",
 CellID->1743480554],
Cell[11053, 365, 482, 17, 36, "Output",
 CellID->1381402974]
}, Open  ]],
Cell[11550, 385, 89, 1, 70, "ExampleText",
 CellID->1133957172],
Cell[CellGroupData[{
Cell[11664, 390, 751, 21, 70, "Input",
 CellID->1096754744],
Cell[12418, 413, 2542, 46, 70, "Output",
 Evaluatable->False,
 CellID->119581503]
}, Open  ]],
Cell[14975, 462, 103, 2, 70, "ExampleText",
 CellID->795208938],
Cell[CellGroupData[{
Cell[15103, 468, 158, 4, 70, "Input",
 CellID->1522779599],
Cell[15264, 474, 323, 11, 36, "Output",
 CellID->1111125569]
}, Open  ]],
Cell[15602, 488, 124, 3, 70, "ExampleText",
 CellID->714155159],
Cell[CellGroupData[{
Cell[15751, 495, 212, 6, 70, "Input",
 CellID->187046627],
Cell[15966, 503, 361, 13, 36, "Output",
 CellID->830987845]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16400, 524, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[16719, 535, 804, 26, 70, "SeeAlso",
 CellID->1206296122]
}, Open  ]],
Cell[CellGroupData[{
Cell[17560, 566, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[17881, 577, 167, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[18085, 585, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[18406, 596, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[18595, 603, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

