(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     89235,       1972]
NotebookOptionsPosition[     84498,       1814]
NotebookOutlinePosition[     85957,       1854]
CellTagsIndexPosition[     85871,       1849]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphCoordinates" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/GraphCoordinates"], "VertexList" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/VertexList"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphCoordinates\"\>", 
       2->"\<\"VertexList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GraphCoordinates3D", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphCoordinates3D", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]calculates a visually appealing 3D layout of the \
vertices of a graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " and returns the coordinates of the vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GraphCoordinates3D"], "InlineFormula"],
 " returns the coordinates of the vertices as computed using a graph drawing \
algorithm in 3D. It is useful when the coordinates of the vertices are \
needed, rather than a drawing of the graph, or when one needs to draw a graph \
repeatedly using the same layout but different style."
}], "Notes",
 CellID->996693321],

Cell[TextData[{
 Cell[BoxData["GraphCoordinates"], "InlineFormula"],
 " accepts the same options as ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->731363331]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->350187537],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->182927722],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->413431351],

Cell["This plots a graph:", "Notes",
 CellID->300553277],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", "\[Rule]", "11"}], ",", 
     RowBox[{"11", "\[Rule]", "12"}], ",", 
     RowBox[{"12", "\[Rule]", "7"}], ",", 
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"2", "\[Rule]", "8"}], ",", 
     RowBox[{"3", "\[Rule]", "9"}], ",", 
     RowBox[{"4", "\[Rule]", "10"}], ",", 
     RowBox[{"5", "\[Rule]", "11"}], ",", 
     RowBox[{"6", "\[Rule]", "12"}], ",", 
     RowBox[{"7", "\[Rule]", "13"}], ",", 
     RowBox[{"9", "\[Rule]", "13"}], ",", 
     RowBox[{"11", "\[Rule]", "13"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1262698933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", "g", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->933395657],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0., 0.707662036792261, 0.624337830708271}, {
    0.479460657708912, 1.59075017646306, 0.499321225325596}, {
    1.35588030298194, 2.08310424128381, 0.623807414965958}, {1.88163920452416,
     1.22661623712251, 0.49975426816894}, {2.07529116603093, 1.28062656578604,
     1.44624194508532}, {1.8586031273121, 0.234342650208735, 
    1.5015322242032}, {1.87058893901873, 0.221830967394138, 
    0.623034632507644}, {0.815832565472147, 0., 1.44700955701541}, {
    0.865021372475593, 0.194560323214096, 0.500289489448475}, {
    0.0179974854056522, 0.711306805955956, 1.50262820573339}, {
    0.337057971594293, 1.73142342836431, 1.44637720728609}, {1.35178999091568,
     2.06665939646021, 1.50239231409096}, {1.0753193602532, 1.00370547965285, 
    0.}}, {
     {RGBColor[0.647058823529412, 0.121965362020294, 0.], Line3DBox[{1, 2}], 
      Line3DBox[{2, 3}], Line3DBox[{2, 13}], Line3DBox[{3, 4}], 
      Line3DBox[{4, 13}], Line3DBox[{4, 7}], Line3DBox[{5, 4}], 
      Line3DBox[{5, 6}], Line3DBox[{6, 7}], Line3DBox[{6, 8}], 
      Line3DBox[{7, 9}], Line3DBox[{8, 9}], Line3DBox[{8, 10}], 
      Line3DBox[{9, 13}], Line3DBox[{9, 1}], Line3DBox[{10, 1}], 
      Line3DBox[{10, 11}], Line3DBox[{11, 2}], Line3DBox[{11, 12}], 
      Line3DBox[{12, 3}], Line3DBox[{12, 5}]}, 
     {RGBColor[0.447959105821317, 0.084443427176318, 0.], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[6],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[7],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[8],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[10],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[11],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[12],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.707662036792261, 0.624337830708271}, {
     0.479460657708912, 1.59075017646306, 0.499321225325596}, {
     1.35588030298194, 2.08310424128381, 0.623807414965958}, {
     1.88163920452416, 1.22661623712251, 0.49975426816894}, {2.07529116603093,
      1.28062656578604, 1.44624194508532}, {1.8586031273121, 
     0.234342650208735, 1.5015322242032}, {1.87058893901873, 
     0.221830967394138, 0.623034632507644}, {0.815832565472147, 0., 
     1.44700955701541}, {0.865021372475593, 0.194560323214096, 
     0.500289489448475}, {0.0179974854056522, 0.711306805955956, 
     1.50262820573339}, {0.337057971594293, 1.73142342836431, 
     1.44637720728609}, {1.35178999091568, 2.06665939646021, 
     1.50239231409096}, {1.0753193602532, 1.00370547965285, 0.}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2033004894]
}, Open  ]],

Cell["\<\
This gives the coordinates of the vertices in the previous drawing:\
\>", "Notes",
 CellID->1556303008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coords", "=", 
  RowBox[{"GraphCoordinates3D", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1350283272],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.7076620367922606`", ",", "0.6243378307082705`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.4794606577089118`", ",", "1.5907501764630607`", ",", 
     "0.49932122532559575`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.3558803029819395`", ",", "2.0831042412838103`", ",", 
     "0.623807414965958`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.8816392045241561`", ",", "1.2266162371225076`", ",", 
     "0.49975426816894003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2.0752911660309348`", ",", "1.2806265657860398`", ",", 
     "1.4462419450853186`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.858603127312104`", ",", "0.23434265020873457`", ",", 
     "1.5015322242031968`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.8705889390187291`", ",", "0.2218309673941381`", ",", 
     "0.6230346325076443`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8158325654721472`", ",", "0.`", ",", "1.447009557015412`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8650213724755926`", ",", "0.19456032321409578`", ",", 
     "0.5002894894484747`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.017997485405652158`", ",", "0.7113068059559557`", ",", 
     "1.5026282057333935`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.33705797159429296`", ",", "1.7314234283643146`", ",", 
     "1.4463772072860863`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.3517899909156803`", ",", "2.0666593964602065`", ",", 
     "1.5023923140909552`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0753193602531994`", ",", "1.0037054796528468`", ",", "0.`"}], 
    "}"}]}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{584, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1456879690]
}, Open  ]],

Cell["\<\
This plot the graph with two different style, using the layout already \
calculated\
\>", "Notes",
 CellID->2044539646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"GraphPlot3D", "[", 
     RowBox[{"g", ",", 
      RowBox[{"VertexCoordinateRules", "\[Rule]", "coords"}], ",", 
      RowBox[{"VertexRenderingFunction", "->", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Sphere", "[", 
           RowBox[{"#1", ",", "0.1"}], "]"}], "}"}], "&"}], ")"}]}]}], "]"}], 
    ",", 
    RowBox[{"GraphPlot3D", "[", 
     RowBox[{"g", ",", 
      RowBox[{"VertexCoordinateRules", "\[Rule]", "coords"}], ",", 
      RowBox[{"VertexRenderingFunction", "->", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Sphere", "[", 
           RowBox[{"#1", ",", "0.2"}], "]"}], "}"}], "&"}], ")"}]}], ",", 
      RowBox[{"EdgeRenderingFunction", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cylinder", "[", 
          RowBox[{"#1", ",", "0.1"}], "]"}], "&"}], ")"}]}]}], "]"}]}], "}"}],
   "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->893076608],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{0., 0.707662036792261, 0.624337830708271}, {
      0.479460657708912, 1.59075017646306, 0.499321225325596}, {
      1.35588030298194, 2.08310424128381, 0.623807414965958}, {
      1.88163920452416, 1.22661623712251, 0.49975426816894}, {
      2.07529116603093, 1.28062656578604, 1.44624194508532}, {1.8586031273121,
       0.234342650208735, 1.5015322242032}, {1.87058893901873, 
      0.221830967394138, 0.623034632507644}, {0.815832565472147, 0., 
      1.44700955701541}, {0.865021372475593, 0.194560323214096, 
      0.500289489448475}, {0.0179974854056522, 0.711306805955956, 
      1.50262820573339}, {0.337057971594293, 1.73142342836431, 
      1.44637720728609}, {1.35178999091568, 2.06665939646021, 
      1.50239231409096}, {1.0753193602532, 1.00370547965285, 0.}}, {
       {RGBColor[0.647058823529412, 0.121965362020294, 0.], 
        Line3DBox[{{0., 0.707662036792261, 0.624337830708271}, {
         0.479460657708912, 1.59075017646306, 0.499321225325596}}], 
        Line3DBox[{{0.479460657708912, 1.59075017646306, 0.499321225325596}, {
         1.35588030298194, 2.08310424128381, 0.623807414965958}}], 
        Line3DBox[{{0.479460657708912, 1.59075017646306, 0.499321225325596}, {
         1.0753193602532, 1.00370547965285, 0.}}], 
        Line3DBox[{{1.35588030298194, 2.08310424128381, 0.623807414965958}, {
         1.88163920452416, 1.22661623712251, 0.49975426816894}}], 
        Line3DBox[{{1.88163920452416, 1.22661623712251, 0.49975426816894}, {
         1.0753193602532, 1.00370547965285, 0.}}], 
        Line3DBox[{{1.88163920452416, 1.22661623712251, 0.49975426816894}, {
         1.87058893901873, 0.221830967394138, 0.623034632507644}}], 
        Line3DBox[{{2.07529116603093, 1.28062656578604, 1.44624194508532}, {
         1.88163920452416, 1.22661623712251, 0.49975426816894}}], 
        Line3DBox[{{2.07529116603093, 1.28062656578604, 1.44624194508532}, {
         1.8586031273121, 0.234342650208735, 1.5015322242032}}], 
        Line3DBox[{{1.8586031273121, 0.234342650208735, 1.5015322242032}, {
         1.87058893901873, 0.221830967394138, 0.623034632507644}}], 
        Line3DBox[{{1.8586031273121, 0.234342650208735, 1.5015322242032}, {
         0.815832565472147, 0., 1.44700955701541}}], 
        Line3DBox[{{1.87058893901873, 0.221830967394138, 0.623034632507644}, {
         0.865021372475593, 0.194560323214096, 0.500289489448475}}], 
        Line3DBox[{{0.815832565472147, 0., 1.44700955701541}, {
         0.865021372475593, 0.194560323214096, 0.500289489448475}}], 
        Line3DBox[{{0.815832565472147, 0., 1.44700955701541}, {
         0.0179974854056522, 0.711306805955956, 1.50262820573339}}], 
        Line3DBox[{{0.865021372475593, 0.194560323214096, 
         0.500289489448475}, {1.0753193602532, 1.00370547965285, 0.}}], 
        Line3DBox[{{0.865021372475593, 0.194560323214096, 
         0.500289489448475}, {0., 0.707662036792261, 0.624337830708271}}], 
        Line3DBox[{{0.0179974854056522, 0.711306805955956, 
         1.50262820573339}, {0., 0.707662036792261, 0.624337830708271}}], 
        Line3DBox[{{0.0179974854056522, 0.711306805955956, 
         1.50262820573339}, {0.337057971594293, 1.73142342836431, 
         1.44637720728609}}], 
        Line3DBox[{{0.337057971594293, 1.73142342836431, 1.44637720728609}, {
         0.479460657708912, 1.59075017646306, 0.499321225325596}}], 
        Line3DBox[{{0.337057971594293, 1.73142342836431, 1.44637720728609}, {
         1.35178999091568, 2.06665939646021, 1.50239231409096}}], 
        Line3DBox[{{1.35178999091568, 2.06665939646021, 1.50239231409096}, {
         1.35588030298194, 2.08310424128381, 0.623807414965958}}], 
        Line3DBox[{{1.35178999091568, 2.06665939646021, 1.50239231409096}, {
         2.07529116603093, 1.28062656578604, 1.44624194508532}}]}, {
        SphereBox[{0., 0.707662036792261, 0.624337830708271}, 0.1], 
        SphereBox[{0.479460657708912, 1.59075017646306, 0.499321225325596}, 
         0.1], SphereBox[{1.35588030298194, 2.08310424128381, 
         0.623807414965958}, 0.1], 
        SphereBox[{1.88163920452416, 1.22661623712251, 0.49975426816894}, 
         0.1], SphereBox[{2.07529116603093, 1.28062656578604, 
         1.44624194508532}, 0.1], 
        SphereBox[{1.8586031273121, 0.234342650208735, 1.5015322242032}, 0.1],
         SphereBox[{1.87058893901873, 0.221830967394138, 0.623034632507644}, 
         0.1], SphereBox[{0.815832565472147, 0., 1.44700955701541}, 0.1], 
        SphereBox[{0.865021372475593, 0.194560323214096, 0.500289489448475}, 
         0.1], SphereBox[{0.0179974854056522, 0.711306805955956, 
         1.50262820573339}, 0.1], 
        SphereBox[{0.337057971594293, 1.73142342836431, 1.44637720728609}, 
         0.1], SphereBox[{1.35178999091568, 2.06665939646021, 
         1.50239231409096}, 0.1], 
        SphereBox[{1.0753193602532, 1.00370547965285, 0.}, 0.1]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 0.707662036792261, 0.624337830708271}, {
       0.479460657708912, 1.59075017646306, 0.499321225325596}, {
       1.35588030298194, 2.08310424128381, 0.623807414965958}, {
       1.88163920452416, 1.22661623712251, 0.49975426816894}, {
       2.07529116603093, 1.28062656578604, 1.44624194508532}, {
       1.8586031273121, 0.234342650208735, 1.5015322242032}, {
       1.87058893901873, 0.221830967394138, 0.623034632507644}, {
       0.815832565472147, 0., 1.44700955701541}, {0.865021372475593, 
       0.194560323214096, 0.500289489448475}, {0.0179974854056522, 
       0.711306805955956, 1.50262820573339}, {0.337057971594293, 
       1.73142342836431, 1.44637720728609}, {1.35178999091568, 
       2.06665939646021, 1.50239231409096}, {1.0753193602532, 
       1.00370547965285, 0.}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], "\[InvisibleSpace]", 
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{0., 0.707662036792261, 0.624337830708271}, {
      0.479460657708912, 1.59075017646306, 0.499321225325596}, {
      1.35588030298194, 2.08310424128381, 0.623807414965958}, {
      1.88163920452416, 1.22661623712251, 0.49975426816894}, {
      2.07529116603093, 1.28062656578604, 1.44624194508532}, {1.8586031273121,
       0.234342650208735, 1.5015322242032}, {1.87058893901873, 
      0.221830967394138, 0.623034632507644}, {0.815832565472147, 0., 
      1.44700955701541}, {0.865021372475593, 0.194560323214096, 
      0.500289489448475}, {0.0179974854056522, 0.711306805955956, 
      1.50262820573339}, {0.337057971594293, 1.73142342836431, 
      1.44637720728609}, {1.35178999091568, 2.06665939646021, 
      1.50239231409096}, {1.0753193602532, 1.00370547965285, 
      0.}}, {{CylinderBox[{{0., 0.707662036792261, 0.624337830708271}, {
         0.479460657708912, 1.59075017646306, 0.499321225325596}}, 0.1], 
        CylinderBox[{{0.479460657708912, 1.59075017646306, 
         0.499321225325596}, {1.35588030298194, 2.08310424128381, 
         0.623807414965958}}, 0.1], 
        CylinderBox[{{0.479460657708912, 1.59075017646306, 
         0.499321225325596}, {1.0753193602532, 1.00370547965285, 0.}}, 0.1], 
        CylinderBox[{{1.35588030298194, 2.08310424128381, 
         0.623807414965958}, {1.88163920452416, 1.22661623712251, 
         0.49975426816894}}, 0.1], 
        CylinderBox[{{1.88163920452416, 1.22661623712251, 0.49975426816894}, {
         1.0753193602532, 1.00370547965285, 0.}}, 0.1], 
        CylinderBox[{{1.88163920452416, 1.22661623712251, 0.49975426816894}, {
         1.87058893901873, 0.221830967394138, 0.623034632507644}}, 0.1], 
        CylinderBox[{{2.07529116603093, 1.28062656578604, 1.44624194508532}, {
         1.88163920452416, 1.22661623712251, 0.49975426816894}}, 0.1], 
        CylinderBox[{{2.07529116603093, 1.28062656578604, 1.44624194508532}, {
         1.8586031273121, 0.234342650208735, 1.5015322242032}}, 0.1], 
        CylinderBox[{{1.8586031273121, 0.234342650208735, 1.5015322242032}, {
         1.87058893901873, 0.221830967394138, 0.623034632507644}}, 0.1], 
        CylinderBox[{{1.8586031273121, 0.234342650208735, 1.5015322242032}, {
         0.815832565472147, 0., 1.44700955701541}}, 0.1], 
        CylinderBox[{{1.87058893901873, 0.221830967394138, 
         0.623034632507644}, {0.865021372475593, 0.194560323214096, 
         0.500289489448475}}, 0.1], 
        CylinderBox[{{0.815832565472147, 0., 1.44700955701541}, {
         0.865021372475593, 0.194560323214096, 0.500289489448475}}, 0.1], 
        CylinderBox[{{0.815832565472147, 0., 1.44700955701541}, {
         0.0179974854056522, 0.711306805955956, 1.50262820573339}}, 0.1], 
        CylinderBox[{{0.865021372475593, 0.194560323214096, 
         0.500289489448475}, {1.0753193602532, 1.00370547965285, 0.}}, 0.1], 
        CylinderBox[{{0.865021372475593, 0.194560323214096, 
         0.500289489448475}, {0., 0.707662036792261, 0.624337830708271}}, 
         0.1], CylinderBox[{{0.0179974854056522, 0.711306805955956, 
         1.50262820573339}, {0., 0.707662036792261, 0.624337830708271}}, 0.1],
         CylinderBox[{{0.0179974854056522, 0.711306805955956, 
         1.50262820573339}, {0.337057971594293, 1.73142342836431, 
         1.44637720728609}}, 0.1], 
        CylinderBox[{{0.337057971594293, 1.73142342836431, 
         1.44637720728609}, {0.479460657708912, 1.59075017646306, 
         0.499321225325596}}, 0.1], 
        CylinderBox[{{0.337057971594293, 1.73142342836431, 
         1.44637720728609}, {1.35178999091568, 2.06665939646021, 
         1.50239231409096}}, 0.1], 
        CylinderBox[{{1.35178999091568, 2.06665939646021, 1.50239231409096}, {
         1.35588030298194, 2.08310424128381, 0.623807414965958}}, 0.1], 
        CylinderBox[{{1.35178999091568, 2.06665939646021, 1.50239231409096}, {
         2.07529116603093, 1.28062656578604, 1.44624194508532}}, 0.1]}, {
        SphereBox[{0., 0.707662036792261, 0.624337830708271}, 0.2], 
        SphereBox[{0.479460657708912, 1.59075017646306, 0.499321225325596}, 
         0.2], SphereBox[{1.35588030298194, 2.08310424128381, 
         0.623807414965958}, 0.2], 
        SphereBox[{1.88163920452416, 1.22661623712251, 0.49975426816894}, 
         0.2], 
        SphereBox[{2.07529116603093, 1.28062656578604, 1.44624194508532}, 
         0.2], SphereBox[{1.8586031273121, 0.234342650208735, 
         1.5015322242032}, 0.2], 
        SphereBox[{1.87058893901873, 0.221830967394138, 0.623034632507644}, 
         0.2], SphereBox[{0.815832565472147, 0., 1.44700955701541}, 0.2], 
        SphereBox[{0.865021372475593, 0.194560323214096, 0.500289489448475}, 
         0.2], SphereBox[{0.0179974854056522, 0.711306805955956, 
         1.50262820573339}, 0.2], 
        SphereBox[{0.337057971594293, 1.73142342836431, 1.44637720728609}, 
         0.2], SphereBox[{1.35178999091568, 2.06665939646021, 
         1.50239231409096}, 0.2], 
        SphereBox[{1.0753193602532, 1.00370547965285, 0.}, 0.2]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 0.707662036792261, 0.624337830708271}, {
       0.479460657708912, 1.59075017646306, 0.499321225325596}, {
       1.35588030298194, 2.08310424128381, 0.623807414965958}, {
       1.88163920452416, 1.22661623712251, 0.49975426816894}, {
       2.07529116603093, 1.28062656578604, 1.44624194508532}, {
       1.8586031273121, 0.234342650208735, 1.5015322242032}, {
       1.87058893901873, 0.221830967394138, 0.623034632507644}, {
       0.815832565472147, 0., 1.44700955701541}, {0.865021372475593, 
       0.194560323214096, 0.500289489448475}, {0.0179974854056522, 
       0.711306805955956, 1.50262820573339}, {0.337057971594293, 
       1.73142342836431, 1.44637720728609}, {1.35178999091568, 
       2.06665939646021, 1.50239231409096}, {1.0753193602532, 
       1.00370547965285, 0.}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}],
  Row[{
    Graphics3D[
     Annotation[
      GraphicsComplex[{{0., 0.707662036792261, 0.624337830708271}, {
       0.479460657708912, 1.59075017646306, 0.499321225325596}, {
       1.35588030298194, 2.08310424128381, 0.623807414965958}, {
       1.88163920452416, 1.22661623712251, 0.49975426816894}, {
       2.07529116603093, 1.28062656578604, 1.44624194508532}, {
       1.8586031273121, 0.234342650208735, 1.5015322242032}, {
       1.87058893901873, 0.221830967394138, 0.623034632507644}, {
       0.815832565472147, 0., 1.44700955701541}, {0.865021372475593, 
       0.194560323214096, 0.500289489448475}, {0.0179974854056522, 
       0.711306805955956, 1.50262820573339}, {0.337057971594293, 
       1.73142342836431, 1.44637720728609}, {1.35178999091568, 
       2.06665939646021, 1.50239231409096}, {1.0753193602532, 
       1.00370547965285, 0.}}, {{
         RGBColor[0.647058823529412, 0.121965362020294, 0.], 
         Line[{{0., 0.707662036792261, 0.624337830708271}, {0.479460657708912,
           1.59075017646306, 0.499321225325596}}], 
         Line[{{0.479460657708912, 1.59075017646306, 0.499321225325596}, {
          1.35588030298194, 2.08310424128381, 0.623807414965958}}], 
         Line[{{0.479460657708912, 1.59075017646306, 0.499321225325596}, {
          1.0753193602532, 1.00370547965285, 0.}}], 
         Line[{{1.35588030298194, 2.08310424128381, 0.623807414965958}, {
          1.88163920452416, 1.22661623712251, 0.49975426816894}}], 
         Line[{{1.88163920452416, 1.22661623712251, 0.49975426816894}, {
          1.0753193602532, 1.00370547965285, 0.}}], 
         Line[{{1.88163920452416, 1.22661623712251, 0.49975426816894}, {
          1.87058893901873, 0.221830967394138, 0.623034632507644}}], 
         Line[{{2.07529116603093, 1.28062656578604, 1.44624194508532}, {
          1.88163920452416, 1.22661623712251, 0.49975426816894}}], 
         Line[{{2.07529116603093, 1.28062656578604, 1.44624194508532}, {
          1.8586031273121, 0.234342650208735, 1.5015322242032}}], 
         Line[{{1.8586031273121, 0.234342650208735, 1.5015322242032}, {
          1.87058893901873, 0.221830967394138, 0.623034632507644}}], 
         Line[{{1.8586031273121, 0.234342650208735, 1.5015322242032}, {
          0.815832565472147, 0., 1.44700955701541}}], 
         Line[{{1.87058893901873, 0.221830967394138, 0.623034632507644}, {
          0.865021372475593, 0.194560323214096, 0.500289489448475}}], 
         Line[{{0.815832565472147, 0., 1.44700955701541}, {0.865021372475593, 
          0.194560323214096, 0.500289489448475}}], 
         Line[{{0.815832565472147, 0., 1.44700955701541}, {0.0179974854056522,
           0.711306805955956, 1.50262820573339}}], 
         Line[{{0.865021372475593, 0.194560323214096, 0.500289489448475}, {
          1.0753193602532, 1.00370547965285, 0.}}], 
         Line[{{0.865021372475593, 0.194560323214096, 0.500289489448475}, {0.,
           0.707662036792261, 0.624337830708271}}], 
         Line[{{0.0179974854056522, 0.711306805955956, 1.50262820573339}, {0.,
           0.707662036792261, 0.624337830708271}}], 
         Line[{{0.0179974854056522, 0.711306805955956, 1.50262820573339}, {
          0.337057971594293, 1.73142342836431, 1.44637720728609}}], 
         Line[{{0.337057971594293, 1.73142342836431, 1.44637720728609}, {
          0.479460657708912, 1.59075017646306, 0.499321225325596}}], 
         Line[{{0.337057971594293, 1.73142342836431, 1.44637720728609}, {
          1.35178999091568, 2.06665939646021, 1.50239231409096}}], 
         Line[{{1.35178999091568, 2.06665939646021, 1.50239231409096}, {
          1.35588030298194, 2.08310424128381, 0.623807414965958}}], 
         Line[{{1.35178999091568, 2.06665939646021, 1.50239231409096}, {
          2.07529116603093, 1.28062656578604, 1.44624194508532}}]}, {{
          Sphere[{0., 0.707662036792261, 0.624337830708271}, 0.1]}, {
          
          Sphere[{0.479460657708912, 1.59075017646306, 0.499321225325596}, 
           0.1]}, {
          
          Sphere[{1.35588030298194, 2.08310424128381, 0.623807414965958}, 
           0.1]}, {
          
          Sphere[{1.88163920452416, 1.22661623712251, 0.49975426816894}, 
           0.1]}, {
          
          Sphere[{2.07529116603093, 1.28062656578604, 1.44624194508532}, 
           0.1]}, {
          
          Sphere[{1.8586031273121, 0.234342650208735, 1.5015322242032}, 
           0.1]}, {
          
          Sphere[{1.87058893901873, 0.221830967394138, 0.623034632507644}, 
           0.1]}, {
          Sphere[{0.815832565472147, 0., 1.44700955701541}, 0.1]}, {
          
          Sphere[{0.865021372475593, 0.194560323214096, 0.500289489448475}, 
           0.1]}, {
          
          Sphere[{0.0179974854056522, 0.711306805955956, 1.50262820573339}, 
           0.1]}, {
          
          Sphere[{0.337057971594293, 1.73142342836431, 1.44637720728609}, 
           0.1]}, {
          
          Sphere[{1.35178999091568, 2.06665939646021, 1.50239231409096}, 
           0.1]}, {
          Sphere[{1.0753193602532, 1.00370547965285, 0.}, 0.1]}}}], 
      VertexCoordinateRules -> {{0., 0.707662036792261, 0.624337830708271}, {
       0.479460657708912, 1.59075017646306, 0.499321225325596}, {
       1.35588030298194, 2.08310424128381, 0.623807414965958}, {
       1.88163920452416, 1.22661623712251, 0.49975426816894}, {
       2.07529116603093, 1.28062656578604, 1.44624194508532}, {
       1.8586031273121, 0.234342650208735, 1.5015322242032}, {
       1.87058893901873, 0.221830967394138, 0.623034632507644}, {
       0.815832565472147, 0., 1.44700955701541}, {0.865021372475593, 
       0.194560323214096, 0.500289489448475}, {0.0179974854056522, 
       0.711306805955956, 1.50262820573339}, {0.337057971594293, 
       1.73142342836431, 1.44637720728609}, {1.35178999091568, 
       2.06665939646021, 1.50239231409096}, {1.0753193602532, 
       1.00370547965285, 0.}}], PlotRange -> All, PlotRangePadding -> 
     Scaled[0.1], AspectRatio -> Automatic], 
    Graphics3D[
     Annotation[
      GraphicsComplex[{{0., 0.707662036792261, 0.624337830708271}, {
       0.479460657708912, 1.59075017646306, 0.499321225325596}, {
       1.35588030298194, 2.08310424128381, 0.623807414965958}, {
       1.88163920452416, 1.22661623712251, 0.49975426816894}, {
       2.07529116603093, 1.28062656578604, 1.44624194508532}, {
       1.8586031273121, 0.234342650208735, 1.5015322242032}, {
       1.87058893901873, 0.221830967394138, 0.623034632507644}, {
       0.815832565472147, 0., 1.44700955701541}, {0.865021372475593, 
       0.194560323214096, 0.500289489448475}, {0.0179974854056522, 
       0.711306805955956, 1.50262820573339}, {0.337057971594293, 
       1.73142342836431, 1.44637720728609}, {1.35178999091568, 
       2.06665939646021, 1.50239231409096}, {1.0753193602532, 
       1.00370547965285, 0.}}, {{
         Cylinder[{{0., 0.707662036792261, 0.624337830708271}, {
          0.479460657708912, 1.59075017646306, 0.499321225325596}}, 0.1], 
         Cylinder[{{0.479460657708912, 1.59075017646306, 0.499321225325596}, {
          1.35588030298194, 2.08310424128381, 0.623807414965958}}, 0.1], 
         Cylinder[{{0.479460657708912, 1.59075017646306, 0.499321225325596}, {
          1.0753193602532, 1.00370547965285, 0.}}, 0.1], 
         Cylinder[{{1.35588030298194, 2.08310424128381, 0.623807414965958}, {
          1.88163920452416, 1.22661623712251, 0.49975426816894}}, 0.1], 
         Cylinder[{{1.88163920452416, 1.22661623712251, 0.49975426816894}, {
          1.0753193602532, 1.00370547965285, 0.}}, 0.1], 
         Cylinder[{{1.88163920452416, 1.22661623712251, 0.49975426816894}, {
          1.87058893901873, 0.221830967394138, 0.623034632507644}}, 0.1], 
         Cylinder[{{2.07529116603093, 1.28062656578604, 1.44624194508532}, {
          1.88163920452416, 1.22661623712251, 0.49975426816894}}, 0.1], 
         Cylinder[{{2.07529116603093, 1.28062656578604, 1.44624194508532}, {
          1.8586031273121, 0.234342650208735, 1.5015322242032}}, 0.1], 
         Cylinder[{{1.8586031273121, 0.234342650208735, 1.5015322242032}, {
          1.87058893901873, 0.221830967394138, 0.623034632507644}}, 0.1], 
         Cylinder[{{1.8586031273121, 0.234342650208735, 1.5015322242032}, {
          0.815832565472147, 0., 1.44700955701541}}, 0.1], 
         Cylinder[{{1.87058893901873, 0.221830967394138, 0.623034632507644}, {
          0.865021372475593, 0.194560323214096, 0.500289489448475}}, 0.1], 
         Cylinder[{{0.815832565472147, 0., 1.44700955701541}, {
          0.865021372475593, 0.194560323214096, 0.500289489448475}}, 0.1], 
         Cylinder[{{0.815832565472147, 0., 1.44700955701541}, {
          0.0179974854056522, 0.711306805955956, 1.50262820573339}}, 0.1], 
         Cylinder[{{0.865021372475593, 0.194560323214096, 
          0.500289489448475}, {1.0753193602532, 1.00370547965285, 0.}}, 0.1], 
         
         Cylinder[{{0.865021372475593, 0.194560323214096, 
          0.500289489448475}, {0., 0.707662036792261, 0.624337830708271}}, 
          0.1], 
         Cylinder[{{0.0179974854056522, 0.711306805955956, 
          1.50262820573339}, {0., 0.707662036792261, 0.624337830708271}}, 
          0.1], 
         Cylinder[{{0.0179974854056522, 0.711306805955956, 
          1.50262820573339}, {0.337057971594293, 1.73142342836431, 
          1.44637720728609}}, 0.1], 
         Cylinder[{{0.337057971594293, 1.73142342836431, 1.44637720728609}, {
          0.479460657708912, 1.59075017646306, 0.499321225325596}}, 0.1], 
         Cylinder[{{0.337057971594293, 1.73142342836431, 1.44637720728609}, {
          1.35178999091568, 2.06665939646021, 1.50239231409096}}, 0.1], 
         Cylinder[{{1.35178999091568, 2.06665939646021, 1.50239231409096}, {
          1.35588030298194, 2.08310424128381, 0.623807414965958}}, 0.1], 
         Cylinder[{{1.35178999091568, 2.06665939646021, 1.50239231409096}, {
          2.07529116603093, 1.28062656578604, 1.44624194508532}}, 0.1]}, {{
          Sphere[{0., 0.707662036792261, 0.624337830708271}, 0.2]}, {
          
          Sphere[{0.479460657708912, 1.59075017646306, 0.499321225325596}, 
           0.2]}, {
          
          Sphere[{1.35588030298194, 2.08310424128381, 0.623807414965958}, 
           0.2]}, {
          
          Sphere[{1.88163920452416, 1.22661623712251, 0.49975426816894}, 
           0.2]}, {
          
          Sphere[{2.07529116603093, 1.28062656578604, 1.44624194508532}, 
           0.2]}, {
          
          Sphere[{1.8586031273121, 0.234342650208735, 1.5015322242032}, 
           0.2]}, {
          
          Sphere[{1.87058893901873, 0.221830967394138, 0.623034632507644}, 
           0.2]}, {
          Sphere[{0.815832565472147, 0., 1.44700955701541}, 0.2]}, {
          
          Sphere[{0.865021372475593, 0.194560323214096, 0.500289489448475}, 
           0.2]}, {
          
          Sphere[{0.0179974854056522, 0.711306805955956, 1.50262820573339}, 
           0.2]}, {
          
          Sphere[{0.337057971594293, 1.73142342836431, 1.44637720728609}, 
           0.2]}, {
          
          Sphere[{1.35178999091568, 2.06665939646021, 1.50239231409096}, 
           0.2]}, {
          Sphere[{1.0753193602532, 1.00370547965285, 0.}, 0.2]}}}], 
      VertexCoordinateRules -> {{0., 0.707662036792261, 0.624337830708271}, {
       0.479460657708912, 1.59075017646306, 0.499321225325596}, {
       1.35588030298194, 2.08310424128381, 0.623807414965958}, {
       1.88163920452416, 1.22661623712251, 0.49975426816894}, {
       2.07529116603093, 1.28062656578604, 1.44624194508532}, {
       1.8586031273121, 0.234342650208735, 1.5015322242032}, {
       1.87058893901873, 0.221830967394138, 0.623034632507644}, {
       0.815832565472147, 0., 1.44700955701541}, {0.865021372475593, 
       0.194560323214096, 0.500289489448475}, {0.0179974854056522, 
       0.711306805955956, 1.50262820573339}, {0.337057971594293, 
       1.73142342836431, 1.44637720728609}, {1.35178999091568, 
       2.06665939646021, 1.50239231409096}, {1.0753193602532, 
       1.00370547965285, 0.}}], PlotRange -> All, PlotRangePadding -> 
     Scaled[0.1], AspectRatio -> Automatic]}]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{364, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->874214719]
}, Open  ]],

Cell["\<\
The relationship between vertices and coordinates is given by the following.\
\>", "Notes",
 CellID->564073450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"Rule", "[", 
   RowBox[{
    RowBox[{"VertexList", "[", "g", "]"}], ",", "coords"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1247042406],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"10", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.`", ",", "0.7076620367922606`", ",", "0.6243378307082705`"}], 
     "}"}]}], ",", 
   RowBox[{"11", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.4794606577089118`", ",", "1.5907501764630607`", ",", 
      "0.49932122532559575`"}], "}"}]}], ",", 
   RowBox[{"12", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "1.3558803029819395`", ",", "2.0831042412838103`", ",", 
      "0.623807414965958`"}], "}"}]}], ",", 
   RowBox[{"7", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "1.8816392045241561`", ",", "1.2266162371225076`", ",", 
      "0.49975426816894003`"}], "}"}]}], ",", 
   RowBox[{"1", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "2.0752911660309348`", ",", "1.2806265657860398`", ",", 
      "1.4462419450853186`"}], "}"}]}], ",", 
   RowBox[{"2", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "1.858603127312104`", ",", "0.23434265020873457`", ",", 
      "1.5015322242031968`"}], "}"}]}], ",", 
   RowBox[{"8", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "1.8705889390187291`", ",", "0.2218309673941381`", ",", 
      "0.6230346325076443`"}], "}"}]}], ",", 
   RowBox[{"3", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.8158325654721472`", ",", "0.`", ",", "1.447009557015412`"}], 
     "}"}]}], ",", 
   RowBox[{"9", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.8650213724755926`", ",", "0.19456032321409578`", ",", 
      "0.5002894894484747`"}], "}"}]}], ",", 
   RowBox[{"4", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.017997485405652158`", ",", "0.7113068059559557`", ",", 
      "1.5026282057333935`"}], "}"}]}], ",", 
   RowBox[{"5", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.33705797159429296`", ",", "1.7314234283643146`", ",", 
      "1.4463772072860863`"}], "}"}]}], ",", 
   RowBox[{"6", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "1.3517899909156803`", ",", "2.0666593964602065`", ",", 
      "1.5023923140909552`"}], "}"}]}], ",", 
   RowBox[{"13", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.0753193602531994`", ",", "1.0037054796528468`", ",", "0.`"}], 
     "}"}]}]}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{470, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1214829507]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["\<\
This shows a drawing of a small graph, and the coordinates associated with \
the drawing:\
\>", "ExampleText",
 CellID->863329075],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1502879501],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1977973748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->690125725],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0., 0.5258987981659422, 0.3615942842699139}, {
    1.2489076131700623`, 0.525544286476852, 0.36207014874114496`}, {
    0.6246083330617399, 1.1018343880069714`, 0.08722409832521527}, {
    0.6242515745492005, 0., 0.}, {0.6239375541972342, 0.4752828563336832, 
    0.9966153364115204}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 5}, {3, 
       4}, {3, 5}, {4, 5}}]}, {Text3DBox[
       FormBox[
        FrameBox["1",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], TraditionalForm], 1], Text3DBox[
       FormBox[
        FrameBox["2",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], TraditionalForm], 2], Text3DBox[
       FormBox[
        FrameBox["3",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], TraditionalForm], 3], Text3DBox[
       FormBox[
        FrameBox["4",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], TraditionalForm], 4], Text3DBox[
       FormBox[
        FrameBox["5",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], TraditionalForm], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.5258987981659422, 0.3615942842699139}, {
     1.2489076131700623`, 0.525544286476852, 0.36207014874114496`}, {
     0.6246083330617399, 1.1018343880069714`, 0.08722409832521527}, {
     0.6242515745492005, 0., 0.}, {0.6239375541972342, 0.4752828563336832, 
     0.9966153364115204}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1751281720,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coord", "=", 
  RowBox[{"GraphCoordinates3D", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->593343161],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.5258987981659422`", ",", "0.3615942842699139`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.2489076131700623`", ",", "0.525544286476852`", ",", 
     "0.36207014874114496`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.6246083330617399`", ",", "1.1018343880069714`", ",", 
     "0.08722409832521527`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6242515745492005`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.6239375541972342`", ",", "0.4752828563336832`", ",", 
     "0.9966153364115204`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{570, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1955894774]
}, Open  ]],

Cell["\<\
This shows the relationship between vertex labels and their coordinates:\
\>", "ExampleText",
 CellID->488465475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"VertexList", "[", "g", "]"}], "->", "coord"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1404644165],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.`", ",", "0.5258987981659422`", ",", "0.3615942842699139`"}], 
     "}"}]}], ",", 
   RowBox[{"2", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "1.2489076131700623`", ",", "0.525544286476852`", ",", 
      "0.36207014874114496`"}], "}"}]}], ",", 
   RowBox[{"3", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.6246083330617399`", ",", "1.1018343880069714`", ",", 
      "0.08722409832521527`"}], "}"}]}], ",", 
   RowBox[{"4", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.6242515745492005`", ",", "0.`", ",", "0.`"}], "}"}]}], ",", 
   RowBox[{"5", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.6239375541972342`", ",", "0.4752828563336832`", ",", 
      "0.9966153364115204`"}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{470, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->689440111]
}, Open  ]],

Cell["\<\
The coordinates can be reused to create the drawing without recomputing:\
\>", "ExampleText",
 CellID->1759645250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", "coord"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->699172915],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0., 0.5258987981659422, 0.3615942842699139}, {
    1.2489076131700623`, 0.525544286476852, 0.36207014874114496`}, {
    0.6246083330617399, 1.1018343880069714`, 0.08722409832521527}, {
    0.6242515745492005, 0., 0.}, {0.6239375541972342, 0.4752828563336832, 
    0.9966153364115204}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 5}, {3, 
       4}, {3, 5}, {4, 5}}]}, {Text3DBox[
       FormBox[
        FrameBox["1",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], TraditionalForm], 1], Text3DBox[
       FormBox[
        FrameBox["2",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], TraditionalForm], 2], Text3DBox[
       FormBox[
        FrameBox["3",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], TraditionalForm], 3], Text3DBox[
       FormBox[
        FrameBox["4",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], TraditionalForm], 4], Text3DBox[
       FormBox[
        FrameBox["5",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], TraditionalForm], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.5258987981659422, 0.3615942842699139}, {
     1.2489076131700623`, 0.525544286476852, 0.36207014874114496`}, {
     0.6246083330617399, 1.1018343880069714`, 0.08722409832521527}, {
     0.6242515745492005, 0., 0.}, {0.6239375541972342, 0.4752828563336832, 
     0.9966153364115204}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1234642835,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphCoordinates",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexList",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/VertexList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1760130350]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphCoordinates3D - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 7.9916308}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "graph drawing graph plot graph embedding graph layout graph \
visualization network layout draw a graph"}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "GraphCoordinates3D[g, options] calculates a visually appealing 3D layout \
of the vertices of a graph g and returns the coordinates of the vertices.", 
    "synonyms" -> {}, "title" -> "GraphCoordinates3D", "type" -> "Symbol", 
    "uri" -> "GraphUtilities/ref/GraphCoordinates3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4492, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->350187537]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 85728, 1842}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1981, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2604, 78, 61, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2668, 81, 618, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3323, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3801, 121, 390, 7, 70, "Notes",
 CellID->996693321],
Cell[4194, 130, 261, 9, 70, "Notes",
 CellID->731363331]
}, Closed]],
Cell[CellGroupData[{
Cell[4492, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->350187537],
Cell[CellGroupData[{
Cell[4877, 158, 148, 5, 70, "ExampleSection",
 CellID->182927722],
Cell[5028, 165, 139, 4, 70, "Input",
 CellID->413431351],
Cell[5170, 171, 56, 1, 70, "Notes",
 CellID->300553277],
Cell[5229, 174, 1035, 27, 70, "Input",
 CellID->1262698933],
Cell[CellGroupData[{
Cell[6289, 205, 107, 3, 28, "Input",
 CellID->933395657],
Cell[6399, 210, 3763, 95, 195, "Output",
 CellID->2033004894]
}, Open  ]],
Cell[10177, 308, 113, 3, 70, "Notes",
 CellID->1556303008],
Cell[CellGroupData[{
Cell[10315, 315, 143, 4, 70, "Input",
 CellID->1350283272],
Cell[10461, 321, 1915, 58, 105, "Output",
 CellID->1456879690]
}, Open  ]],
Cell[12391, 382, 129, 4, 70, "Notes",
 CellID->2044539646],
Cell[CellGroupData[{
Cell[12545, 390, 1029, 30, 70, "Input",
 CellID->893076608],
Cell[13577, 422, 50217, 840, 200, "Output",
 CellID->874214719]
}, Open  ]],
Cell[63809, 1265, 121, 3, 70, "Notes",
 CellID->564073450],
Cell[CellGroupData[{
Cell[63955, 1272, 205, 7, 70, "Input",
 CellID->1247042406],
Cell[64163, 1281, 2359, 71, 139, "Output",
 CellID->1214829507]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66571, 1358, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[66812, 1367, 140, 4, 70, "ExampleText",
 CellID->863329075],
Cell[66955, 1373, 140, 4, 70, "Input",
 CellID->1502879501],
Cell[67098, 1379, 560, 16, 70, "Input",
 CellID->1977973748],
Cell[CellGroupData[{
Cell[67683, 1399, 176, 5, 70, "Input",
 CellID->690125725],
Cell[67862, 1406, 5990, 115, 200, 1886, 43, "CachedBoxData", "BoxData", \
"Output",
 CellID->1751281720]
}, Open  ]],
Cell[CellGroupData[{
Cell[73889, 1526, 141, 4, 70, "Input",
 CellID->593343161],
Cell[74033, 1532, 791, 24, 54, "Output",
 CellID->1955894774]
}, Open  ]],
Cell[74839, 1559, 123, 3, 70, "ExampleText",
 CellID->488465475],
Cell[CellGroupData[{
Cell[74987, 1566, 169, 5, 70, "Input",
 CellID->1404644165],
Cell[75159, 1573, 957, 29, 71, "Output",
 CellID->689440111]
}, Open  ]],
Cell[76131, 1605, 124, 3, 70, "ExampleText",
 CellID->1759645250],
Cell[CellGroupData[{
Cell[76280, 1612, 240, 6, 70, "Input",
 CellID->699172915],
Cell[76523, 1620, 5990, 115, 200, 1886, 43, "CachedBoxData", "BoxData", \
"Output",
 CellID->1234642835]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82574, 1742, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[82893, 1753, 506, 17, 70, "SeeAlso",
 CellID->1760130350]
}, Open  ]],
Cell[CellGroupData[{
Cell[83436, 1775, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[83757, 1786, 167, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[83961, 1794, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[84282, 1805, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[84471, 1812, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

