(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46287,       1409]
NotebookOptionsPosition[     39546,       1182]
NotebookOutlinePosition[     41208,       1225]
CellTagsIndexPosition[     41122,       1220]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GraphDistanceMatrix", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphDistanceMatrix", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a matrix in which the ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         StyleBox["i", "TI"], ",", " ", 
         StyleBox["j", "TI"]}], ")"}], 
       StyleBox["th", "TI"]]], "InlineFormula"],
     " entry is the length of a shortest path in ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " between vertices ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphDistanceMatrix", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", "Parent"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns a three-dimensional matrix in which the ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", ",", " ", 
         StyleBox["i", "TI"], ",", " ", 
         StyleBox["j", "TI"]}], ")"}], 
       StyleBox["th", "TI"]]], "InlineFormula"],
     " entry is the length of a shortest path from ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " and the ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", ",", " ", 
         StyleBox["i", "TI"], ",", " ", 
         StyleBox["j", "TI"]}], ")"}], 
       StyleBox["th", "TI"]]], "InlineFormula"],
     " entry is the predecessor of ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " in a shortest path from ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->213763687],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method used to compute the shortest path", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Weighted",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Weighted"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether edge weights are to be taken into account", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->464392908]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->261401212],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->310811220],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->777723757],

Cell["This defines a simple directed graph:", "ExampleText",
 CellID->1298501147],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2."}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1060781549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", "0.1"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#2", "]"}], ",", 
             RowBox[{"Last", "[", "#2", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->285926919],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{
       ArrowBox[{{1.2893252649071054`, 1.5485600106322983`}, {
        1.617753747939871, 0.6043445040754697}}, 0.1], 
       InsetBox["1.`", {1.4535395064234882`, 1.076452257353884},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.2893252649071054`, 1.5485600106322983`}, {
        0.2886834314367773, 1.5275030724879717`}}, 0.1], 
       InsetBox["1.`", {0.7890043481719413, 1.538031541560135},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.617753747939871, 0.6043445040754697}, {0.8211445524089258,
         0.}}, 0.1], 
       InsetBox["1.`", {1.2194491501743983`, 0.30217225203773485`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 0.5703652293375701}, {0.8211445524089258, 0.}}, 0.1], 
       InsetBox["1.`", {0.4105722762044629, 0.28518261466878503`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0.2886834314367773, 1.5275030724879717`}, {0., 
        0.5703652293375701}}, 0.1], InsetBox[
        RowBox[{"-", "2.`"}], {0.14434171571838866`, 1.0489341509127708`},
        Background->GrayLevel[1]]}}, 
     GraphicsComplexBox[{{1.2893252649071054`, 1.5485600106322983`}, {
      1.617753747939871, 0.6043445040754697}, {0.8211445524089258, 0.}, {0., 
      0.5703652293375701}, {0.2886834314367773, 
      1.5275030724879717`}}, {InsetBox[
        FrameBox["1",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 1], InsetBox[
        FrameBox["2",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 2], InsetBox[
        FrameBox["3",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 3], InsetBox[
        FrameBox["4",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 4], InsetBox[
        FrameBox["5",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 5]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2893252649071054`, 1.5485600106322983`}, {
     1.617753747939871, 0.6043445040754697}, {0.8211445524089258, 0.}, {0., 
     0.5703652293375701}, {0.2886834314367773, 1.5275030724879717`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1892520116]
}, Open  ]],

Cell["This calculates the distance between the vertices:", "ExampleText",
 CellID->9961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphDistanceMatrix", "[", "g", "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->491],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.`", "1.`", "0.`", 
      RowBox[{"-", "1.`"}], "1.`"},
     {"\[Infinity]", "0.`", "1.`", "\[Infinity]", "\[Infinity]"},
     {"\[Infinity]", "\[Infinity]", "0.`", "\[Infinity]", "\[Infinity]"},
     {"\[Infinity]", "\[Infinity]", "1.`", "0.`", "\[Infinity]"},
     {"\[Infinity]", "\[Infinity]", 
      RowBox[{"-", "1.`"}], 
      RowBox[{"-", "2.`"}], "0.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{142, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->318987521]
}, Open  ]],

Cell["This shows also the predecessors in the shortest path:", "ExampleText",
 CellID->11942],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"prd", "=", 
   RowBox[{
    RowBox[{"GraphDistanceMatrix", "[", 
     RowBox[{"g", ",", "Parent"}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"prd", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->4827],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "4", "5", "1"},
     {"1", "2", "2", "4", "5"},
     {"1", "2", "3", "4", "5"},
     {"1", "2", "4", "4", "5"},
     {"1", "2", "4", "5", "5"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->287768677]
}, Open  ]],

Cell[TextData[{
 "The path from 1 to 3 is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "5", ",", "4", ",", "3"}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1757720855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Drop", "[", 
   RowBox[{
    RowBox[{"FixedPointList", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"prd", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "#"}], "]"}], "]"}], "&"}], ",", "3"}], "]"}], ",",
     
    RowBox[{"-", "1"}]}], "]"}], "//", "Reverse"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1812294677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1896417631]
}, Open  ]],

Cell["This confirms the shortest path:", "ExampleText",
 CellID->751001782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->732872013],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1895775422]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->354623487],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->578947695],

Cell["This defines a small graph:", "ExampleText",
 CellID->1121641158],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->177828262],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g0", "=", 
   RowBox[{"ToCombinatoricaGraph", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"3", "\[Rule]", "1"}], ",", 
      RowBox[{"1", "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"SetEdgeWeights", "[", 
    RowBox[{"g0", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"adj", "=", 
   RowBox[{"AdjacencyMatrix", "[", "g", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1830498631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g0", ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", "0.1"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"adj", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#2", "]"}], ",", 
             RowBox[{"Last", "[", "#2", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2087065062],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{249, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->242341460]
}, Open  ]],

Cell["\<\
Because of the negative edge weight, the Dijkstra algorithm cannot be \
applied:\
\>", "ExampleText",
 CellID->153323372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Dijkstra\>\""}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1369495674],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphDistanceMatrix", "::", "\<\"negw\"\>"}], ":", 
  " ", "\<\"Method->Dijkstra can not be applied to a graph containing \
negative edge weight. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:GraphUtilities/ref/GraphDistanceMatrix\\\", ButtonNote \
-> \\\"GraphUtilities`.`GraphDistanceMatrix::negw\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->38399405],

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "4", 
     "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "3", 
     "\[InvisibleSpace]", "\<\", \"\>", 
     "\[InvisibleSpace]", "\<\"Directed\"\>", 
     "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
    SequenceForm[
    "\[SkeletonIndicator]Graph:<", 4, ", ", 3, ", ", "Directed", 
     ">\[SkeletonIndicator]"],
    Editable->False], ",", 
   RowBox[{"Method", "\[Rule]", "\<\"Dijkstra\"\>"}]}], "]"}]], "Output",
 ImageSize->{445, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->633893666]
}, Open  ]],

Cell["Both the Floyd-Warshall and Johnson algorithms work:", "ExampleText",
 CellID->83071627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<FloydWarshall\>\""}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->356452553],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "3.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`", ",", 
     RowBox[{"-", "2.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "2.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{299, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->481513680]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Johnson\>\""}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->599735504],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "3.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`", ",", 
     RowBox[{"-", "2.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "2.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{299, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->929167950]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1229361853],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->944495584],

Cell["This defines a small graph with negative cycle:", "ExampleText",
 CellID->2091006801],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.0000001", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1295542399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "3"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "4"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "2"}], ",", "0.0000001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "\[Rule]", "1"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "\[Rule]", "3"}], ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", ".05"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#3", ",", 
          RowBox[{"LineScaledCoordinate", "[", 
           RowBox[{"#1", ",", ".3"}], "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->566053345],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{209, 218},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->842636536]
}, Open  ]],

Cell["\<\
The Dijkstra algorithm does not work for negative edge weights:\
\>", "ExampleText",
 CellID->1346217026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Dijkstra\>\""}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1094845671],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphDistanceMatrix", "::", "\<\"negw\"\>"}], ":", 
  " ", "\<\"Method->Dijkstra can not be applied to a graph containing \
negative edge weight. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:GraphUtilities/ref/GraphDistanceMatrix\\\", ButtonNote \
-> \\\"GraphUtilities`.`GraphDistanceMatrix::negw\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->1247999402],

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1.`*^-7", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Method", "\[Rule]", "\<\"Dijkstra\"\>"}]}], "]"}]], "Output",
 ImageSize->{559, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->859639660]
}, Open  ]],

Cell["\<\
The Floyd-Warshall algorithm does not detect any negative weight cycle, and \
gives the wrong answer:\
\>", "ExampleText",
 CellID->134492998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<FloydWarshall\>\""}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->654004373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9999999000000002`"}], ",", "3.0000001999999997`", ",", 
     "3.0000001`", ",", "1.9999999967268423`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5.`"}], ",", 
     RowBox[{"-", "0.9999999000000002`"}], ",", 
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "3.9999999`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4.999999900000001`"}], ",", 
     RowBox[{"-", "0.9999998000000003`"}], ",", 
     RowBox[{"-", "0.9999999000000002`"}], ",", 
     RowBox[{"-", "3.9999998000000003`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.9999999`"}], ",", "1.0000001999999997`", ",", 
     "1.0000000999999998`", ",", 
     RowBox[{"-", "1.9999998000000003`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{311, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1669254033]
}, Open  ]],

Cell["The Johnson algorithm detects negative a weight cycle:", "ExampleText",
 CellID->420227377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Johnson\>\""}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1664491364],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphDistanceMatrix", "::", "\<\"negc\"\>"}], ":", 
  " ", "\<\"Negative cycle found. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:GraphUtilities/ref/GraphDistanceMatrix\\\", ButtonNote \
-> \\\"GraphUtilities`.`GraphDistanceMatrix::negc\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->2071907386],

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1.`*^-7", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Method", "\[Rule]", "\<\"Johnson\"\>"}]}], "]"}]], "Output",
 ImageSize->{552, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->215145650]
}, Open  ]],

Cell["\<\
The default algorithm for graphs with negative edge weights is Johnson:\
\>", "ExampleText",
 CellID->2144256577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", "g", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->465810180],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphDistanceMatrix", "::", "\<\"negc\"\>"}], ":", 
  " ", "\<\"Negative cycle found. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:GraphUtilities/ref/GraphDistanceMatrix\\\", ButtonNote \
-> \\\"GraphUtilities`.`GraphDistanceMatrix::negc\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->1796754334],

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "4", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "3", ",", 
      RowBox[{"-", "3"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1.`*^-7", ",", "0", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0"}], "}"}]}], "}"}], 
  "]"}]], "Output",
 ImageSize->{567, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->434731006]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell["", "SeeAlso",
 CellID->1973294774]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphDistanceMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 8.8354024}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "graph distance graph geodesic all pairs shortest path shortest path \
shortest distance"}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "GraphDistanceMatrix[g] gives a matrix in which the (i, j) th entry is \
the length of a shortest path in g between vertices i and j. \
GraphDistanceMatrix[g, Parent] returns a three-dimensional matrix in which \
the (1, i, j) th entry is the length of a shortest path from i to j and the \
(2, i, j) th entry is the predecessor of j in a shortest path from i to j.", 
    "synonyms" -> {}, "title" -> "GraphDistanceMatrix", "type" -> "Symbol", 
    "uri" -> "GraphUtilities/ref/GraphDistanceMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5560, 183, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->261401212]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40979, 1213}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1267, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1890, 60, 62, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1955, 63, 2120, 67, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4112, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4590, 152, 72, 1, 70, "Notes",
 CellID->213763687],
Cell[4665, 155, 858, 23, 70, "3ColumnTableMod",
 CellID->464392908]
}, Closed]],
Cell[CellGroupData[{
Cell[5560, 183, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->261401212],
Cell[CellGroupData[{
Cell[5945, 197, 148, 5, 70, "ExampleSection",
 CellID->310811220],
Cell[6096, 204, 139, 4, 70, "Input",
 CellID->777723757],
Cell[6238, 210, 81, 1, 70, "ExampleText",
 CellID->1298501147],
Cell[6322, 213, 805, 26, 70, "Input",
 CellID->1060781549],
Cell[CellGroupData[{
Cell[7152, 243, 782, 22, 65, "Input",
 CellID->285926919],
Cell[7937, 267, 2654, 59, 193, "Output",
 CellID->1892520116]
}, Open  ]],
Cell[10606, 329, 88, 1, 70, "ExampleText",
 CellID->9961],
Cell[CellGroupData[{
Cell[10719, 334, 145, 5, 70, "Input",
 CellID->491],
Cell[10867, 341, 1064, 28, 108, "Output",
 CellID->318987521]
}, Open  ]],
Cell[11946, 372, 93, 1, 70, "ExampleText",
 CellID->11942],
Cell[CellGroupData[{
Cell[12064, 377, 304, 9, 70, "Input",
 CellID->4827],
Cell[12371, 388, 851, 25, 108, "Output",
 CellID->287768677]
}, Open  ]],
Cell[13237, 416, 194, 7, 70, "ExampleText",
 CellID->1757720855],
Cell[CellGroupData[{
Cell[13456, 427, 365, 13, 70, "Input",
 CellID->1812294677],
Cell[13824, 442, 224, 7, 36, "Output",
 CellID->1896417631]
}, Open  ]],
Cell[14063, 452, 75, 1, 70, "ExampleText",
 CellID->751001782],
Cell[CellGroupData[{
Cell[14163, 457, 138, 4, 70, "Input",
 CellID->732872013],
Cell[14304, 463, 224, 7, 36, "Output",
 CellID->1895775422]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14577, 476, 222, 7, 70, "ExampleSection",
 CellID->354623487],
Cell[CellGroupData[{
Cell[14824, 487, 227, 7, 70, "ExampleSubsection",
 CellID->578947695],
Cell[15054, 496, 71, 1, 70, "ExampleText",
 CellID->1121641158],
Cell[15128, 499, 139, 4, 70, "Input",
 CellID->177828262],
Cell[15270, 505, 1050, 34, 70, "Input",
 CellID->1830498631],
Cell[CellGroupData[{
Cell[16345, 543, 842, 23, 70, "Input",
 CellID->2087065062],
Cell[17190, 568, 3641, 64, 70, "Output",
 Evaluatable->False,
 CellID->242341460]
}, Open  ]],
Cell[20846, 635, 131, 4, 70, "ExampleText",
 CellID->153323372],
Cell[CellGroupData[{
Cell[21002, 643, 189, 5, 70, "Input",
 CellID->1369495674],
Cell[21194, 650, 461, 9, 70, "Message",
 CellID->38399405],
Cell[21658, 661, 726, 18, 36, "Output",
 CellID->633893666]
}, Open  ]],
Cell[22399, 682, 94, 1, 70, "ExampleText",
 CellID->83071627],
Cell[CellGroupData[{
Cell[22518, 687, 193, 5, 70, "Input",
 CellID->356452553],
Cell[22714, 694, 472, 16, 36, "Output",
 CellID->481513680]
}, Open  ]],
Cell[CellGroupData[{
Cell[23223, 715, 187, 5, 70, "Input",
 CellID->599735504],
Cell[23413, 722, 472, 16, 36, "Output",
 CellID->929167950]
}, Open  ]],
Cell[23900, 741, 126, 3, 70, "ExampleDelimiter",
 CellID->1229361853],
Cell[24029, 746, 139, 4, 70, "Input",
 CellID->944495584],
Cell[24171, 752, 91, 1, 70, "ExampleText",
 CellID->2091006801],
Cell[24265, 755, 552, 18, 70, "Input",
 CellID->1295542399],
Cell[CellGroupData[{
Cell[24842, 777, 1510, 47, 70, "Input",
 CellID->566053345],
Cell[26355, 826, 5995, 102, 70, "Output",
 Evaluatable->False,
 CellID->842636536]
}, Open  ]],
Cell[32365, 931, 115, 3, 70, "ExampleText",
 CellID->1346217026],
Cell[CellGroupData[{
Cell[32505, 938, 189, 5, 70, "Input",
 CellID->1094845671],
Cell[32697, 945, 463, 9, 70, "Message",
 CellID->1247999402],
Cell[33163, 956, 717, 22, 58, "Output",
 CellID->859639660]
}, Open  ]],
Cell[33895, 981, 152, 4, 70, "ExampleText",
 CellID->134492998],
Cell[CellGroupData[{
Cell[34072, 989, 193, 5, 70, "Input",
 CellID->654004373],
Cell[34268, 996, 976, 28, 58, "Output",
 CellID->1669254033]
}, Open  ]],
Cell[35259, 1027, 97, 1, 70, "ExampleText",
 CellID->420227377],
Cell[CellGroupData[{
Cell[35381, 1032, 188, 5, 70, "Input",
 CellID->1664491364],
Cell[35572, 1039, 405, 9, 70, "Message",
 CellID->2071907386],
Cell[35980, 1050, 716, 22, 58, "Output",
 CellID->215145650]
}, Open  ]],
Cell[36711, 1075, 123, 3, 70, "ExampleText",
 CellID->2144256577],
Cell[CellGroupData[{
Cell[36859, 1082, 115, 3, 70, "Input",
 CellID->465810180],
Cell[36977, 1087, 405, 9, 70, "Message",
 CellID->1796754334],
Cell[37385, 1098, 630, 20, 39, "Output",
 CellID->434731006]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38088, 1126, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[38407, 1137, 40, 1, 70, "SeeAlso",
 CellID->1973294774]
}, Open  ]],
Cell[CellGroupData[{
Cell[38484, 1143, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[38805, 1154, 167, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[39009, 1162, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[39330, 1173, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[39519, 1180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

