(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10258,        357]
NotebookOptionsPosition[      7453,        265]
NotebookOutlinePosition[      8861,        305]
CellTagsIndexPosition[      8777,        300]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphPlot" :> 
          Documentation`HelpLookup["paclet:ref/GraphPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GraphPlot\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GraphEdit", "ObjectName",
 CellID->31079],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphEdit", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]opens an interactive graph editor."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphEdit", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " in the interactive graph editor."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->2703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The graph ",
 StyleBox["g", "TI"],
 " may be specified by a rule list, an adjacency matrix, or the ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " representation of a graph. "
}], "Notes",
 CellID->7376],

Cell["\<\
Vertices and edges can be added by clicking and dragging with the mouse. \
Vertices can be moved after setting \"Drawing mode\" to \"Move\" and dragging \
the mouse on the vertices. Vertices can be deleted after setting \"Drawing \
mode\" to \"Delete\" and selecting the vertices to be deleted using a mouse \
click.\
\>", "Notes",
 CellID->2113717424],

Cell[TextData[{
 "Users can hold the ",
 StyleBox["Ctrl", "KeyEvent"],
 " key and click the vertex (using the first mouse button) in the GraphEdit \
window to edit the vertex labels."
}], "Notes",
 CellID->96223269],

Cell["\<\
When the window is closed, a drawing of the graph, a representation of the \
graph as a list of rules, the coordinates, and the vertex labels, are \
returned.\
\>", "Notes",
 CellID->296616681]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38956608],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->490374133],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->550323575],

Cell["Plot a graph in the interactive graph editor:", "ExampleText",
 CellID->5097],

Cell[BoxData[
 RowBox[{"GraphEdit", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"i", "^", "3"}], ",", "27"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "27"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16512]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23910],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->12707]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18957],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->24801]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->615087106],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphEdit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 14.3824194}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "graph drawing graph plot graph embedding graph layout graph \
visualization network layout draw a graph input a graph"}, "index" -> True, 
    "label" -> "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "GraphEdit[] opens an interactive graph editor. GraphEdit[g] plots the \
graph g in the interactive graph editor.", "synonyms" -> {}, "title" -> 
    "GraphEdit", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/GraphEdit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4698, 157, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->38956608]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8635, 293}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1803, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2426, 75, 47, 1, 70, "ObjectName",
 CellID->31079],
Cell[2476, 78, 651, 20, 70, "Usage",
 CellID->2703]
}, Open  ]],
Cell[CellGroupData[{
Cell[3164, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3642, 120, 230, 8, 70, "Notes",
 CellID->7376],
Cell[3875, 130, 362, 7, 70, "Notes",
 CellID->2113717424],
Cell[4240, 139, 215, 6, 70, "Notes",
 CellID->96223269],
Cell[4458, 147, 203, 5, 70, "Notes",
 CellID->296616681]
}, Closed]],
Cell[CellGroupData[{
Cell[4698, 157, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38956608],
Cell[CellGroupData[{
Cell[5082, 171, 148, 5, 70, "ExampleSection",
 CellID->490374133],
Cell[5233, 178, 139, 4, 70, "Input",
 CellID->550323575],
Cell[5375, 184, 83, 1, 70, "ExampleText",
 CellID->5097],
Cell[5461, 187, 339, 11, 70, "Input",
 CellID->16512]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5849, 204, 311, 9, 70, "SeeAlsoSection",
 CellID->23910],
Cell[6163, 215, 198, 6, 70, "SeeAlso",
 CellID->12707]
}, Open  ]],
Cell[CellGroupData[{
Cell[6398, 226, 314, 9, 70, "TutorialsSection",
 CellID->18957],
Cell[6715, 237, 163, 3, 70, "Tutorials",
 CellID->24801]
}, Open  ]],
Cell[CellGroupData[{
Cell[6915, 245, 319, 9, 70, "MoreAboutSection",
 CellID->615087106],
Cell[7237, 256, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[7426, 263, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

