(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54000,       1652]
NotebookOptionsPosition[     46363,       1384]
NotebookOutlinePosition[     47688,       1422]
CellTagsIndexPosition[     47602,       1417]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GraphPath", "ObjectName", "GraphToSparseArray",
 CellID->31079],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphPath", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", " ", 
        StyleBox["start", "TI"], ",", " ", 
        StyleBox["end", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a shortest path between vertices ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["end", "TI"]], "InlineFormula"],
     " in graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be used:", "Notes",
 CellID->146861874],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use to find the shortest path", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Weighted",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Weighted"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
specifies whether edge weight is to be used in calculating distance.\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->281743273]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->695470346],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->397149616],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->24371256],

Cell["This defines a small directed graph:", "ExampleText",
 CellID->70281645],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2."}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1060781549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", "0.1"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#2", "]"}], ",", 
             RowBox[{"Last", "[", "#2", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->285926919],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{
       ArrowBox[{{1.2893252649072209`, 1.5485600106322432`}, {
        1.6177537479398745`, 0.6043445040753757}}, 0.1], 
       InsetBox["1.`", {1.4535395064235477`, 1.0764522573538096`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.2893252649072209`, 1.5485600106322432`}, {
        0.28868343143689057`, 1.527503072488035}}, 0.1], 
       InsetBox["1.`", {0.7890043481720557, 1.538031541560139},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.6177537479398745`, 0.6043445040753757}, {
        0.8211445524088582, 0.}}, 0.1], 
       InsetBox["1.`", {1.2194491501743663`, 0.3021722520376878},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 0.5703652293376675}, {0.8211445524088582, 0.}}, 0.1], 
       InsetBox["1.`", {0.4105722762044291, 0.28518261466883377`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0.28868343143689057`, 1.527503072488035}, {0., 
        0.5703652293376675}}, 0.1], InsetBox[
        RowBox[{"-", "2.`"}], {0.14434171571844528`, 1.0489341509128511`},
        Background->GrayLevel[1]]}}, 
     GraphicsComplexBox[{{1.2893252649072209`, 1.5485600106322432`}, {
      1.6177537479398745`, 0.6043445040753757}, {0.8211445524088582, 0.}, {0.,
       0.5703652293376675}, {0.28868343143689057`, 
      1.527503072488035}}, {InsetBox[
        FrameBox["1",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 1], InsetBox[
        FrameBox["2",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 2], InsetBox[
        FrameBox["3",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 3], InsetBox[
        FrameBox["4",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 4], InsetBox[
        FrameBox["5",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 5]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2893252649072209`, 1.5485600106322432`}, {
     1.6177537479398745`, 0.6043445040753757}, {0.8211445524088582, 0.}, {0., 
     0.5703652293376675}, {0.28868343143689057`, 1.527503072488035}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->523820100]
}, Open  ]],

Cell["This find the shortest path from vertex 1 to vertex 3:", "ExampleText",
 CellID->330723564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->577852788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->11600395]
}, Open  ]],

Cell["\<\
This find the shortest path from vertex 1 to vertex 3, ignoring the edge \
weights:\
\>", "ExampleText",
 CellID->443119426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "3", ",", 
   RowBox[{"Weighted", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1704337900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->178434375]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->647050477],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->578947695],

Cell["This defines a small graph:", "ExampleText",
 CellID->1121641158],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->346499281],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g0", "=", 
   RowBox[{"ToCombinatoricaGraph", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"3", "\[Rule]", "1"}], ",", 
      RowBox[{"1", "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"SetEdgeWeights", "[", 
    RowBox[{"g0", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"adj", "=", 
   RowBox[{"AdjacencyMatrix", "[", "g", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1830498631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g0", ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", "0.1"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"adj", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#2", "]"}], ",", 
             RowBox[{"Last", "[", "#2", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2087065062],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{249, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->429901782]
}, Open  ]],

Cell["\<\
Because of the negative edge weight, the Dijkstra algorithm can not be \
applied:\
\>", "ExampleText",
 CellID->153323372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "3", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Dijkstra\>\""}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1369495674],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPath", "::", "\<\"negw\"\>"}], ":", 
  " ", "\<\"Method->Dijkstra can not be applied to a graph containing \
negative edge weight. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:GraphUtilities/ref/GraphPath\\\", ButtonNote -> \
\\\"GraphUtilities`.`GraphPath::negw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->548126691],

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "4", 
     "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "3", 
     "\[InvisibleSpace]", "\<\", \"\>", 
     "\[InvisibleSpace]", "\<\"Directed\"\>", 
     "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
    SequenceForm[
    "\[SkeletonIndicator]Graph:<", 4, ", ", 3, ", ", "Directed", 
     ">\[SkeletonIndicator]"],
    Editable->False], ",", "1", ",", "3", ",", 
   RowBox[{"Method", "\[Rule]", "\<\"Dijkstra\"\>"}]}], "]"}]], "Output",
 ImageSize->{411, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->252973826]
}, Open  ]],

Cell["The Bellman-Ford algorithm works:", "ExampleText",
 CellID->83071627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "3", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<BellmanFord\>\""}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->356452553],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->281861771]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistanceMatrix", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Johnson\>\""}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->599735504],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "3.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`", ",", 
     RowBox[{"-", "2.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "2.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{299, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->11005278]
}, Open  ]],

Cell["This defines a small graph with negative cycle:", "ExampleText",
 CellID->2091006801],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.0000001", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1295542399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "3"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "4"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "2"}], ",", "0.0000001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "\[Rule]", "1"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "\[Rule]", "3"}], ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", ".05"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#3", ",", 
          RowBox[{"LineScaledCoordinate", "[", 
           RowBox[{"#1", ",", ".3"}], "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->566053345],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{209, 218},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->165207691]
}, Open  ]],

Cell["\<\
The Dijkstra algorithm does not work for negative edge weights:\
\>", "ExampleText",
 CellID->1346217026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "4", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Dijkstra\>\""}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1094845671],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPath", "::", "\<\"negw\"\>"}], ":", 
  " ", "\<\"Method->Dijkstra can not be applied to a graph containing \
negative edge weight. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:GraphUtilities/ref/GraphPath\\\", ButtonNote -> \
\\\"GraphUtilities`.`GraphPath::negw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->229232719],

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1.`*^-7", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0"}], "}"}]}], "}"}], 
   ",", "1", ",", "4", ",", 
   RowBox[{"Method", "\[Rule]", "\<\"Dijkstra\"\>"}]}], "]"}]], "Output",
 ImageSize->{497, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->184967242]
}, Open  ]],

Cell["The Bellman-Ford algorithm detects a negative weight cycle:", \
"ExampleText",
 CellID->420227377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "4", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<BellmanFord\>\""}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1664491364],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPath", "::", "\<\"negc\"\>"}], ":", 
  " ", "\<\"Negative cycle found. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:GraphUtilities/ref/GraphPath\\\", \
ButtonNote -> \\\"GraphUtilities`.`GraphPath::negc\\\"]\\)\"\>"}]], "Message",\
 "MSG",
 CellID->110597292],

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1.`*^-7", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0"}], "}"}]}], "}"}], 
   ",", "1", ",", "4", ",", 
   RowBox[{"Method", "\[Rule]", "\<\"BellmanFord\"\>"}]}], "]"}]], "Output",
 ImageSize->{497, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->987760407]
}, Open  ]],

Cell["\<\
The default algorithm for graphs with negative edge weights is Bellman-Ford:\
\>", "ExampleText",
 CellID->2144256577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->465810180],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPath", "::", "\<\"negc\"\>"}], ":", 
  " ", "\<\"Negative cycle found. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:GraphUtilities/ref/GraphPath\\\", \
ButtonNote -> \\\"GraphUtilities`.`GraphPath::negc\\\"]\\)\"\>"}]], "Message",\
 "MSG",
 CellID->28819117],

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "3", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1.`*^-7", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0"}], "}"}]}], "}"}], 
   ",", "1", ",", "4"}], "]"}]], "Output",
 ImageSize->{533, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->871297310]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5732],

Cell["This defines a small directed graph:", "ExampleText",
 CellID->2074237616],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1995660859],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", 
        RowBox[{"-", "3."}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->747828232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", "0.1"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#2", "]"}], ",", 
             RowBox[{"Last", "[", "#2", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1674854273],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{
       ArrowBox[{{1.2893252649072209`, 1.5485600106322432`}, {
        1.6177537479398745`, 0.6043445040753757}}, 0.1], 
       InsetBox["1.`", {1.4535395064235477`, 1.0764522573538096`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.2893252649072209`, 1.5485600106322432`}, {
        0.28868343143689057`, 1.527503072488035}}, 0.1], 
       InsetBox["1.`", {0.7890043481720557, 1.538031541560139},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.6177537479398745`, 0.6043445040753757}, {
        0.8211445524088582, 0.}}, 0.1], 
       InsetBox["1.`", {1.2194491501743663`, 0.3021722520376878},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 0.5703652293376675}, {0.8211445524088582, 0.}}, 0.1], 
       InsetBox["1.`", {0.4105722762044291, 0.28518261466883377`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0.28868343143689057`, 1.527503072488035}, {0., 
        0.5703652293376675}}, 0.1], InsetBox[
        RowBox[{"-", "3.`"}], {0.14434171571844528`, 1.0489341509128511`},
        Background->GrayLevel[1]]}}, 
     GraphicsComplexBox[{{1.2893252649072209`, 1.5485600106322432`}, {
      1.6177537479398745`, 0.6043445040753757}, {0.8211445524088582, 0.}, {0.,
       0.5703652293376675}, {0.28868343143689057`, 
      1.527503072488035}}, {InsetBox[
        FrameBox["1",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 1], InsetBox[
        FrameBox["2",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 2], InsetBox[
        FrameBox["3",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 3], InsetBox[
        FrameBox["4",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 4], InsetBox[
        FrameBox["5",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 5]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2893252649072209`, 1.5485600106322432`}, {
     1.6177537479398745`, 0.6043445040753757}, {0.8211445524088582, 0.}, {0., 
     0.5703652293376675}, {0.28868343143689057`, 1.527503072488035}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->566974970]
}, Open  ]],

Cell["This finds the shortest path from vertex 1 to 3:", "ExampleText",
 CellID->1943442355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->791804379],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->84241503]
}, Open  ]],

Cell["\<\
This finds the distance of this path, taking into account the edge weights:\
\>", "ExampleText",
 CellID->362737677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"g", ",", "1", ",", "3", ",", 
   RowBox[{"Weighted", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1874018825],

Cell[BoxData[
 RowBox[{"-", "1.`"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->168518911]
}, Open  ]],

Cell["\<\
This finds the distance of this path, ignoring the edge weights:\
\>", "ExampleText",
 CellID->1455282609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"g", ",", "1", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1732256846],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->437709317]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8668],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->500943106],

Cell["This defines a small directed graph:", "ExampleText",
 CellID->1144975443],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2."}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1893948113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#2", "]"}], ",", 
             RowBox[{"Last", "[", "#2", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}]}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", "0.1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1171329876],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{
       InsetBox["1.`", {1.4535395064235477`, 1.0764522573538096`}], 
       ArrowBox[{{1.2893252649072209`, 1.5485600106322432`}, {
        1.6177537479398745`, 0.6043445040753757}}, 0.1]}, {
       InsetBox["1.`", {0.7890043481720557, 1.538031541560139}], 
       ArrowBox[{{1.2893252649072209`, 1.5485600106322432`}, {
        0.28868343143689057`, 1.527503072488035}}, 0.1]}, {
       InsetBox["1.`", {1.2194491501743663`, 0.3021722520376878}], 
       ArrowBox[{{1.6177537479398745`, 0.6043445040753757}, {
        0.8211445524088582, 0.}}, 0.1]}, {
       InsetBox["1.`", {0.4105722762044291, 0.28518261466883377`}], 
       ArrowBox[{{0., 0.5703652293376675}, {0.8211445524088582, 0.}}, 0.1]}, {
       InsetBox[
        RowBox[{"-", "2.`"}], {0.14434171571844528`, 1.0489341509128511`}], 
       ArrowBox[{{0.28868343143689057`, 1.527503072488035}, {0., 
        0.5703652293376675}}, 0.1]}}, 
     GraphicsComplexBox[{{1.2893252649072209`, 1.5485600106322432`}, {
      1.6177537479398745`, 0.6043445040753757}, {0.8211445524088582, 0.}, {0.,
       0.5703652293376675}, {0.28868343143689057`, 
      1.527503072488035}}, {InsetBox[
        FrameBox["1",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 1], InsetBox[
        FrameBox["2",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 2], InsetBox[
        FrameBox["3",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 3], InsetBox[
        FrameBox["4",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 4], InsetBox[
        FrameBox["5",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 5]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2893252649072209`, 1.5485600106322432`}, {
     1.6177537479398745`, 0.6043445040753757}, {0.8211445524088582, 0.}, {0., 
     0.5703652293376675}, {0.28868343143689057`, 1.527503072488035}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->146085880]
}, Open  ]],

Cell[TextData[{
 "If there are negative edge weights, the ",
 Cell[BoxData["\"\<Dijkstra\>\""], "InlineFormula"],
 " method can not be used:"
}], "ExampleText",
 CellID->959865712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "3", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Dijkstra\>\""}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1179150599],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPath", "::", "\<\"negw\"\>"}], ":", 
  " ", "\<\"Method->Dijkstra can not be applied to a graph containing \
negative edge weight. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:GraphUtilities/ref/GraphPath\\\", ButtonNote -> \
\\\"GraphUtilities`.`GraphPath::negw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->159743779],

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 5, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
    False,
    Editable->False], ",", "1", ",", "3", ",", 
   RowBox[{"Method", "\[Rule]", "\<\"Dijkstra\"\>"}]}], "]"}]], "Output",
 ImageSize->{405, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->143816460]
}, Open  ]],

Cell[TextData[{
 "This find the shortest path from vertex 1 to vertex 3 using the ",
 Cell[BoxData["\"\<BellmanFord\>\""], "InlineFormula"],
 " method:"
}], "ExampleText",
 CellID->1331055759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "3", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<BellmanFord\>\""}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->878896283],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->142298288]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23910],

Cell["", "SeeAlso",
 CellID->1575305997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18957],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->24801]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->941931935],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphPath - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 14.6324258}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "graph path shortest path shortest distance graph geodesic"}, "index" -> 
    True, "label" -> "Graph Utilities Package Symbol", "language" -> "en", 
    "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "GraphPath[g, start, end] finds a shortest path between vertices start \
and end in graph g.", "synonyms" -> {}, "title" -> "GraphPath", "type" -> 
    "Symbol", "uri" -> "GraphUtilities/ref/GraphPath"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4204, 141, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->695470346]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47459, 1410}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1267, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1890, 60, 69, 1, 70, "ObjectName",
 CellID->31079],
Cell[1962, 63, 741, 24, 70, "Usage",
 CellID->2703]
}, Open  ]],
Cell[CellGroupData[{
Cell[2740, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3218, 109, 71, 1, 70, "Notes",
 CellID->146861874],
Cell[3292, 112, 875, 24, 70, "3ColumnTableMod",
 CellID->281743273]
}, Closed]],
Cell[CellGroupData[{
Cell[4204, 141, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->695470346],
Cell[CellGroupData[{
Cell[4589, 155, 148, 5, 70, "ExampleSection",
 CellID->397149616],
Cell[4740, 162, 138, 4, 70, "Input",
 CellID->24371256],
Cell[4881, 168, 78, 1, 70, "ExampleText",
 CellID->70281645],
Cell[4962, 171, 805, 26, 70, "Input",
 CellID->1060781549],
Cell[CellGroupData[{
Cell[5792, 201, 782, 22, 65, "Input",
 CellID->285926919],
Cell[6577, 225, 2661, 59, 193, "Output",
 CellID->523820100]
}, Open  ]],
Cell[9253, 287, 97, 1, 70, "ExampleText",
 CellID->330723564],
Cell[CellGroupData[{
Cell[9375, 292, 138, 4, 70, "Input",
 CellID->577852788],
Cell[9516, 298, 222, 7, 36, "Output",
 CellID->11600395]
}, Open  ]],
Cell[9753, 308, 134, 4, 70, "ExampleText",
 CellID->443119426],
Cell[CellGroupData[{
Cell[9912, 316, 190, 5, 70, "Input",
 CellID->1704337900],
Cell[10105, 323, 213, 7, 36, "Output",
 CellID->178434375]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10367, 336, 222, 7, 70, "ExampleSection",
 CellID->647050477],
Cell[CellGroupData[{
Cell[10614, 347, 227, 7, 70, "ExampleSubsection",
 CellID->578947695],
Cell[10844, 356, 71, 1, 70, "ExampleText",
 CellID->1121641158],
Cell[10918, 359, 139, 4, 70, "Input",
 CellID->346499281],
Cell[11060, 365, 1050, 34, 70, "Input",
 CellID->1830498631],
Cell[CellGroupData[{
Cell[12135, 403, 842, 23, 70, "Input",
 CellID->2087065062],
Cell[12980, 428, 3641, 64, 70, "Output",
 Evaluatable->False,
 CellID->429901782]
}, Open  ]],
Cell[16636, 495, 132, 4, 70, "ExampleText",
 CellID->153323372],
Cell[CellGroupData[{
Cell[16793, 503, 199, 5, 70, "Input",
 CellID->1369495674],
Cell[16995, 510, 430, 8, 70, "Message",
 CellID->548126691],
Cell[17428, 520, 736, 18, 36, "Output",
 CellID->252973826]
}, Open  ]],
Cell[18179, 541, 75, 1, 70, "ExampleText",
 CellID->83071627],
Cell[CellGroupData[{
Cell[18279, 546, 201, 5, 70, "Input",
 CellID->356452553],
Cell[18483, 553, 213, 7, 36, "Output",
 CellID->281861771]
}, Open  ]],
Cell[CellGroupData[{
Cell[18733, 565, 187, 5, 70, "Input",
 CellID->599735504],
Cell[18923, 572, 471, 16, 36, "Output",
 CellID->11005278]
}, Open  ]],
Cell[19409, 591, 91, 1, 70, "ExampleText",
 CellID->2091006801],
Cell[19503, 594, 552, 18, 70, "Input",
 CellID->1295542399],
Cell[CellGroupData[{
Cell[20080, 616, 1510, 47, 70, "Input",
 CellID->566053345],
Cell[21593, 665, 5947, 102, 70, "Output",
 Evaluatable->False,
 CellID->165207691]
}, Open  ]],
Cell[27555, 770, 115, 3, 70, "ExampleText",
 CellID->1346217026],
Cell[CellGroupData[{
Cell[27695, 777, 199, 5, 70, "Input",
 CellID->1094845671],
Cell[27897, 784, 430, 8, 70, "Message",
 CellID->229232719],
Cell[28330, 794, 727, 22, 58, "Output",
 CellID->184967242]
}, Open  ]],
Cell[29072, 819, 104, 2, 70, "ExampleText",
 CellID->420227377],
Cell[CellGroupData[{
Cell[29201, 825, 203, 5, 70, "Input",
 CellID->1664491364],
Cell[29407, 832, 372, 8, 70, "Message",
 CellID->110597292],
Cell[29782, 842, 731, 22, 58, "Output",
 CellID->987760407]
}, Open  ]],
Cell[30528, 867, 128, 3, 70, "ExampleText",
 CellID->2144256577],
Cell[CellGroupData[{
Cell[30681, 874, 139, 4, 70, "Input",
 CellID->465810180],
Cell[30823, 880, 371, 8, 70, "Message",
 CellID->28819117],
Cell[31197, 890, 668, 21, 39, "Output",
 CellID->871297310]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31926, 918, 232, 7, 70, "ExampleSection",
 CellID->5732],
Cell[32161, 927, 80, 1, 70, "ExampleText",
 CellID->2074237616],
Cell[32244, 930, 140, 4, 70, "Input",
 CellID->1995660859],
Cell[32387, 936, 804, 26, 70, "Input",
 CellID->747828232],
Cell[CellGroupData[{
Cell[33216, 966, 783, 22, 70, "Input",
 CellID->1674854273],
Cell[34002, 990, 2661, 59, 193, "Output",
 CellID->566974970]
}, Open  ]],
Cell[36678, 1052, 92, 1, 70, "ExampleText",
 CellID->1943442355],
Cell[CellGroupData[{
Cell[36795, 1057, 138, 4, 70, "Input",
 CellID->791804379],
Cell[36936, 1063, 222, 7, 36, "Output",
 CellID->84241503]
}, Open  ]],
Cell[37173, 1073, 126, 3, 70, "ExampleText",
 CellID->362737677],
Cell[CellGroupData[{
Cell[37324, 1080, 193, 5, 70, "Input",
 CellID->1874018825],
Cell[37520, 1087, 177, 6, 36, "Output",
 CellID->168518911]
}, Open  ]],
Cell[37712, 1096, 116, 3, 70, "ExampleText",
 CellID->1455282609],
Cell[CellGroupData[{
Cell[37853, 1103, 143, 4, 70, "Input",
 CellID->1732256846],
Cell[37999, 1109, 158, 5, 36, "Output",
 CellID->437709317]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38206, 1120, 225, 7, 70, "ExampleSection",
 CellID->8668],
Cell[38434, 1129, 139, 4, 70, "Input",
 CellID->500943106],
Cell[38576, 1135, 80, 1, 70, "ExampleText",
 CellID->1144975443],
Cell[38659, 1138, 805, 26, 70, "Input",
 CellID->1893948113],
Cell[CellGroupData[{
Cell[39489, 1168, 720, 21, 70, "Input",
 CellID->1171329876],
Cell[40212, 1191, 2499, 55, 193, "Output",
 CellID->146085880]
}, Open  ]],
Cell[42726, 1249, 180, 5, 70, "ExampleText",
 CellID->959865712],
Cell[CellGroupData[{
Cell[42931, 1258, 199, 5, 70, "Input",
 CellID->1179150599],
Cell[43133, 1265, 430, 8, 70, "Message",
 CellID->159743779],
Cell[43566, 1275, 631, 20, 36, "Output",
 CellID->143816460]
}, Open  ]],
Cell[44212, 1298, 192, 5, 70, "ExampleText",
 CellID->1331055759],
Cell[CellGroupData[{
Cell[44429, 1307, 201, 5, 70, "Input",
 CellID->878896283],
Cell[44633, 1314, 223, 7, 36, "Output",
 CellID->142298288]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44917, 1328, 311, 9, 70, "SeeAlsoSection",
 CellID->23910],
Cell[45231, 1339, 40, 1, 70, "SeeAlso",
 CellID->1575305997]
}, Open  ]],
Cell[CellGroupData[{
Cell[45308, 1345, 314, 9, 70, "TutorialsSection",
 CellID->18957],
Cell[45625, 1356, 163, 3, 70, "Tutorials",
 CellID->24801]
}, Open  ]],
Cell[CellGroupData[{
Cell[45825, 1364, 319, 9, 70, "MoreAboutSection",
 CellID->941931935],
Cell[46147, 1375, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[46336, 1382, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

