(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64655,       1832]
NotebookOptionsPosition[     59803,       1662]
NotebookOutlinePosition[     61199,       1702]
CellTagsIndexPosition[     61113,       1697]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MaximalBipartiteMatching" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/MaximalBipartiteMatching"], 
          "MaximalIndependentVertexSet" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/MaximalIndependentVertexSet"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"MaximalBipartiteMatching\"\>", 
       2->"\<\"MaximalIndependentVertexSet\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MaximalIndependentEdgeSet", "ObjectName",
 CellID->30234],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MaximalIndepndentEdgeSet", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a maximal independent edge set of an undirected \
graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4405]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MaximalIndependentEdgeSet"], "InlineFormula"],
 " gives an approximate maximal set of pairwise non-adjacent edges of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6334],

Cell["\<\
A maximal independent edge set of a graph is also called a maximal matching.\
\>", "Notes",
 CellID->13674],

Cell["The following option can be given:", "Notes",
 CellID->44],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Weighted",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Weighted"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether edges with higher weights are preferred when forming the maximal \
independent edge set\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->29174]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->138391903],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->700858692],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->358134926],

Cell["This defines a small graph:", "ExampleText",
 CellID->11478],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "g", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19912],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.4875669188038463`, 1.7455699225238166`}, {
    1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
    0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
    0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.4875669188038463`, 1.7455699225238166`}, {
     1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
     0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
     0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->493910036]
}, Open  ]],

Cell["\<\
This shows that the maximal independent edge set contains three edges:\
\>", "ExampleText",
 CellID->24464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"MaximalIndependentEdgeSet", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1538743642]
}, Open  ]],

Cell["\<\
This plots the hexagon with maximal edges highlighted in red:\
\>", "ExampleText",
 CellID->9741],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"color", "[", "_", "]"}], ":=", " ", "Green"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"color", "[", "#", "]"}], "=", 
       RowBox[{
        RowBox[{"color", "[", 
         RowBox[{"Reverse", "[", "#", "]"}], "]"}], "=", "Red"}]}], ")"}], 
     "&"}], ",", "m"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"color", "[", "#2", "]"}], ",", 
        RowBox[{"Line", "[", "#1", "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->17673],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {RGBColor[1, 0, 0], 
       LineBox[{{1.4875669188038463`, 1.7455699225238166`}, {
        1.9996460459354313`, 0.8861424682559871}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.9996460459354313`, 0.8861424682559871}, {1.511583448071915,
         0.013316663859109679`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.511583448071915, 0.013316663859109679`}, {
        0.5114456436282868, 0.}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.5114456436282868, 0.}, {0., 0.8594781450938977}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{0., 0.8594781450938977}, {0.48875342845363157`, 
        1.7322387782110364`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.48875342845363157`, 1.7322387782110364`}, {
        1.4875669188038463`, 1.7455699225238166`}}]}}, 
     GraphicsComplexBox[{{1.4875669188038463`, 1.7455699225238166`}, {
      1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
      0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
      0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "6"],
        Annotation[#, 6, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.4875669188038463`, 1.7455699225238166`}, {
     1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
     0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
     0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1866755942]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5520],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Weighted",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31107],

Cell["\<\
A matrix representation of a hexagon with a higher weight given to the edge \
connecting vertices 1 and 6:\
\>", "ExampleText",
 CellID->3035],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->28944535],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"(", GridBox[{
      {"0", "1", "0", "0", "0", "2"},
      {"1", "0", "1", "0", "0", "0"},
      {"0", "1", "0", "1", "0", "0"},
      {"0", "0", "1", "0", "1", "0"},
      {"0", "0", "0", "1", "0", "1"},
      {"2", "0", "0", "0", "1", "0"}
     }], ")"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22190],

Cell[TextData[{
 "This shows that with the default option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weighted",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/Weighted"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the weights are ignored:"
}], "ExampleText",
 CellID->1842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaximalIndependentEdgeSet", "[", "g", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1604524671]
}, Open  ]],

Cell[TextData[{
 "This shows that the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weighted",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/Weighted"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the higher weight edge ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "6"}], "}"}]], "InlineFormula"],
 " is included:"
}], "ExampleText",
 CellID->9040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaximalIndependentEdgeSet", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Weighted", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8942],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->87596155]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15752],

Cell["This is a matrix representation of the graph of a torus:", "ExampleText",
 CellID->17807],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->402109870],

Cell[BoxData[
 RowBox[{
  RowBox[{"torus", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", 
              RowBox[{"Mod", "[", 
               RowBox[{
                RowBox[{"i", "+", "1"}], ",", "5"}], "]"}]}], "+", "j", "+", 
             "1"}]}], "}"}], "\[Rule]", "1"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", 
              RowBox[{"Mod", "[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "5"}], "]"}]}], "+", "j", "+", 
             "1"}]}], "}"}], "\[Rule]", "1"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", "i"}], "+", 
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"j", "+", "1"}], ",", "10"}], "]"}], "+", "1"}]}], 
           "}"}], "\[Rule]", "1"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", "i"}], "+", 
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"j", "-", "1"}], ",", "10"}], "]"}], "+", "1"}]}], 
           "}"}], "\[Rule]", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", "9"}], "}"}]}], "]"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19668],

Cell["This finds the maximal independent edge set of the torus:", \
"ExampleText",
 CellID->14310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"MaximalIndependentEdgeSet", "[", "torus", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6617],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "31"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "36"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "38"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "39"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "40"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "42"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43", ",", "44"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "46"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", "48"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"49", ",", "50"}], "}"}]}], "}"}]], "Output",
 ImageSize->{524, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1780638364]
}, Open  ]],

Cell["\<\
This plots the torus, highlighting members of the maximal independent edge \
set in red:\
\>", "ExampleText",
 CellID->2421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"torus", ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"m", ",", 
            RowBox[{"Sort", "[", "#2", "]"}]}], "]"}], ",", "Red", ",", 
          "Green"}], "]"}], ",", 
        RowBox[{"Line", "[", "#1", "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3728],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {RGBColor[1, 0, 0], 
       LineBox[{{3.693501891278827, 1.5706647882496927`}, {4.29719055349273, 
        1.6395397167361043`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.693501891278827, 1.5706647882496927`}, {3.771608386529417, 
        0.9651942572360266}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.693501891278827, 1.5706647882496927`}, {
        4.1537329029605266`, 2.719933886630466}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.693501891278827, 1.5706647882496927`}, {2.694047908936145, 
        0.8597560688231758}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{4.1537329029605266`, 2.719933886630466}, {4.777152365044506, 
        2.846962733841587}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.1537329029605266`, 2.719933886630466}, {4.1395389798402, 
        2.1730083151658577`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.1537329029605266`, 2.719933886630466}, {
        3.8835134338029866`, 3.947104483351551}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.1537329029605266`, 2.719933886630466}, {3.693501891278827, 
        1.5706647882496927`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{3.8835134338029866`, 3.947104483351551}, {4.443749971759981, 
        4.121657737133722}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.8835134338029866`, 3.947104483351551}, {3.777680728349237, 
        3.347968252835022}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.8835134338029866`, 3.947104483351551}, {
        2.8864382799427535`, 4.782292431589923}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.8835134338029866`, 3.947104483351551}, {
        4.1537329029605266`, 2.719933886630466}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{2.8864382799427535`, 4.782292431589923}, {
        3.4288080035671458`, 4.953479937970072}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.8864382799427535`, 4.782292431589923}, {2.836032156047095, 
        4.1308124160201265`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.8864382799427535`, 4.782292431589923}, {
        1.5803623612442266`, 4.859562073252034}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.8864382799427535`, 4.782292431589923}, {
        3.8835134338029866`, 3.947104483351551}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.5803623612442266`, 4.859562073252034}, {2.121991070135936, 
        4.996193166015605}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.5803623612442266`, 4.859562073252034}, {
        1.5835245168076728`, 4.247734401751989}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.5803623612442266`, 4.859562073252034}, {0.4766089154201305,
         4.135477086334262}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.5803623612442266`, 4.859562073252034}, {
        2.8864382799427535`, 4.782292431589923}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{0.4766089154201305, 4.135477086334262}, {1.0347315188668935`,
         4.243491155830789}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.4766089154201305, 4.135477086334262}, {
        0.48376443798443036`, 3.571228820337723}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.4766089154201305, 4.135477086334262}, {0.02656777604128102,
         2.898858468274386}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.4766089154201305, 4.135477086334262}, {1.5803623612442266`,
         4.859562073252034}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{0.02656777604128102, 2.898858468274386}, {0.6254912998266768,
         3.0152151949364487`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.02656777604128102, 2.898858468274386}, {0., 
        2.3374363949439365`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.02656777604128102, 2.898858468274386}, {0.4024397858010924,
         1.633900569494581}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.02656777604128102, 2.898858468274386}, {0.4766089154201305,
         4.135477086334262}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{0.4024397858010924, 1.633900569494581}, {1.0170346843268994`,
         1.8199899398213473`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.4024397858010924, 1.633900569494581}, {0.3360596864042016, 
        1.0684371655867426`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.4024397858010924, 1.633900569494581}, {1.4427105687876238`,
         0.8558198720931514}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.4024397858010924, 1.633900569494581}, {0.02656777604128102,
         2.898858468274386}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.4427105687876238`, 0.8558198720931514}, {2.001710051056443,
         1.0818535418738793`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.4427105687876238`, 0.8558198720931514}, {1.374223807042967,
         0.24857116715128003`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.4427105687876238`, 0.8558198720931514}, {2.694047908936145,
         0.8597560688231758}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.4427105687876238`, 0.8558198720931514}, {
        0.4024397858010924, 1.633900569494581}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{2.694047908936145, 0.8597560688231758}, {3.2306075269340675`,
         0.996790257071722}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.694047908936145, 0.8597560688231758}, {2.700976805080317, 
        0.2116841106752787}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.694047908936145, 0.8597560688231758}, {3.693501891278827, 
        1.5706647882496927`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.694047908936145, 0.8597560688231758}, {1.4427105687876238`,
         0.8558198720931514}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.29719055349273, 1.6395397167361043`}, {4.6809250916696925`,
         1.1685849182623906`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{4.29719055349273, 1.6395397167361043`}, {3.693501891278827, 
        1.5706647882496927`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.29719055349273, 1.6395397167361043`}, {4.777152365044506, 
        2.846962733841587}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.29719055349273, 1.6395397167361043`}, {3.2306075269340675`,
         0.996790257071722}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.777152365044506, 2.846962733841587}, {5.130817112383097, 
        2.4008879805779966`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{4.777152365044506, 2.846962733841587}, {4.1537329029605266`, 
        2.719933886630466}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.777152365044506, 2.846962733841587}, {4.443749971759981, 
        4.121657737133722}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.777152365044506, 2.846962733841587}, {4.29719055349273, 
        1.6395397167361043`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.443749971759981, 4.121657737133722}, {4.755022217206827, 
        3.657881425139676}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{4.443749971759981, 4.121657737133722}, {3.8835134338029866`, 
        3.947104483351551}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.443749971759981, 4.121657737133722}, {3.4288080035671458`, 
        4.953479937970072}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.443749971759981, 4.121657737133722}, {4.777152365044506, 
        2.846962733841587}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.4288080035671458`, 4.953479937970072}, {
        3.7079713108256067`, 4.461065176941227}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{3.4288080035671458`, 4.953479937970072}, {
        2.8864382799427535`, 4.782292431589923}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.4288080035671458`, 4.953479937970072}, {2.121991070135936, 
        4.996193166015605}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.4288080035671458`, 4.953479937970072}, {4.443749971759981, 
        4.121657737133722}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.121991070135936, 4.996193166015605}, {2.409222271876861, 
        4.471808114494204}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{2.121991070135936, 4.996193166015605}, {1.5803623612442266`, 
        4.859562073252034}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.121991070135936, 4.996193166015605}, {1.0347315188668935`, 
        4.243491155830789}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.121991070135936, 4.996193166015605}, {3.4288080035671458`, 
        4.953479937970072}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0347315188668935`, 4.243491155830789}, {1.416571111895698, 
        3.721042747981387}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.0347315188668935`, 4.243491155830789}, {0.4766089154201305,
         4.135477086334262}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0347315188668935`, 4.243491155830789}, {0.6254912998266768,
         3.0152151949364487`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0347315188668935`, 4.243491155830789}, {2.121991070135936, 
        4.996193166015605}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.6254912998266768, 3.0152151949364487`}, {
        1.0143627244539037`, 2.567557909056202}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{0.6254912998266768, 3.0152151949364487`}, {
        0.02656777604128102, 2.898858468274386}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.6254912998266768, 3.0152151949364487`}, {
        1.0170346843268994`, 1.8199899398213473`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.6254912998266768, 3.0152151949364487`}, {
        1.0347315188668935`, 4.243491155830789}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0170346843268994`, 1.8199899398213473`}, {
        1.3144818137475784`, 1.3799504849098705`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.0170346843268994`, 1.8199899398213473`}, {
        0.4024397858010924, 1.633900569494581}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0170346843268994`, 1.8199899398213473`}, {
        2.001710051056443, 1.0818535418738793`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0170346843268994`, 1.8199899398213473`}, {
        0.6254912998266768, 3.0152151949364487`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.001710051056443, 1.0818535418738793`}, {
        2.2533769580435687`, 0.551398721934701}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{2.001710051056443, 1.0818535418738793`}, {
        1.4427105687876238`, 0.8558198720931514}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.001710051056443, 1.0818535418738793`}, {
        3.2306075269340675`, 0.996790257071722}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.001710051056443, 1.0818535418738793`}, {
        1.0170346843268994`, 1.8199899398213473`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.2306075269340675`, 0.996790257071722}, {3.559650579598662, 
        0.45501308849427247`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{3.2306075269340675`, 0.996790257071722}, {2.694047908936145, 
        0.8597560688231758}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.2306075269340675`, 0.996790257071722}, {4.29719055349273, 
        1.6395397167361043`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.2306075269340675`, 0.996790257071722}, {2.001710051056443, 
        1.0818535418738793`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{4.6809250916696925`, 1.1685849182623906`}, {
        4.320919076644323, 0.7386801870753943}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.6809250916696925`, 1.1685849182623906`}, {4.29719055349273,
         1.6395397167361043`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.6809250916696925`, 1.1685849182623906`}, {
        5.130817112383097, 2.4008879805779966`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.6809250916696925`, 1.1685849182623906`}, {
        3.559650579598662, 0.45501308849427247`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{5.130817112383097, 2.4008879805779966`}, {4.75509128594331, 
        1.9834420738408136`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{5.130817112383097, 2.4008879805779966`}, {4.777152365044506, 
        2.846962733841587}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{5.130817112383097, 2.4008879805779966`}, {4.755022217206827, 
        3.657881425139676}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{5.130817112383097, 2.4008879805779966`}, {
        4.6809250916696925`, 1.1685849182623906`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{4.755022217206827, 3.657881425139676}, {4.358848236759159, 
        3.224560858027393}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.755022217206827, 3.657881425139676}, {4.443749971759981, 
        4.121657737133722}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.755022217206827, 3.657881425139676}, {3.7079713108256067`, 
        4.461065176941227}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.755022217206827, 3.657881425139676}, {5.130817112383097, 
        2.4008879805779966`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{3.7079713108256067`, 4.461065176941227}, {
        3.3395025909650085`, 3.947139640136455}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.7079713108256067`, 4.461065176941227}, {
        3.4288080035671458`, 4.953479937970072}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.7079713108256067`, 4.461065176941227}, {2.409222271876861, 
        4.471808114494204}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.7079713108256067`, 4.461065176941227}, {4.755022217206827, 
        3.657881425139676}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{2.409222271876861, 4.471808114494204}, {2.1060303033265555`, 
        3.971986985485878}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.409222271876861, 4.471808114494204}, {2.121991070135936, 
        4.996193166015605}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.409222271876861, 4.471808114494204}, {1.416571111895698, 
        3.721042747981387}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.409222271876861, 4.471808114494204}, {3.7079713108256067`, 
        4.461065176941227}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.416571111895698, 3.721042747981387}, {1.0704614001870447`, 
        3.3212468397060495`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.416571111895698, 3.721042747981387}, {1.0347315188668935`, 
        4.243491155830789}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.416571111895698, 3.721042747981387}, {1.0143627244539037`, 
        2.567557909056202}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.416571111895698, 3.721042747981387}, {2.409222271876861, 
        4.471808114494204}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.0143627244539037`, 2.567557909056202}, {0.5745025475278014,
         2.171193760489139}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0143627244539037`, 2.567557909056202}, {0.6254912998266768,
         3.0152151949364487`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0143627244539037`, 2.567557909056202}, {
        1.3144818137475784`, 1.3799504849098705`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0143627244539037`, 2.567557909056202}, {1.416571111895698, 
        3.721042747981387}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.3144818137475784`, 1.3799504849098705`}, {
        0.8789937011950781, 0.9067409324397}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.3144818137475784`, 1.3799504849098705`}, {
        1.0170346843268994`, 1.8199899398213473`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.3144818137475784`, 1.3799504849098705`}, {
        2.2533769580435687`, 0.551398721934701}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.3144818137475784`, 1.3799504849098705`}, {
        1.0143627244539037`, 2.567557909056202}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{2.2533769580435687`, 0.551398721934701}, {
        1.9031098971713076`, 0.06816523803129737}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.2533769580435687`, 0.551398721934701}, {2.001710051056443, 
        1.0818535418738793`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.2533769580435687`, 0.551398721934701}, {3.559650579598662, 
        0.45501308849427247`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.2533769580435687`, 0.551398721934701}, {
        1.3144818137475784`, 1.3799504849098705`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{3.559650579598662, 0.45501308849427247`}, {3.224909040889221,
         0.}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.559650579598662, 0.45501308849427247`}, {
        3.2306075269340675`, 0.996790257071722}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.559650579598662, 0.45501308849427247`}, {
        4.6809250916696925`, 1.1685849182623906`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.559650579598662, 0.45501308849427247`}, {
        2.2533769580435687`, 0.551398721934701}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.320919076644323, 0.7386801870753943}, {3.771608386529417, 
        0.9651942572360266}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{4.320919076644323, 0.7386801870753943}, {4.6809250916696925`,
         1.1685849182623906`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.320919076644323, 0.7386801870753943}, {4.75509128594331, 
        1.9834420738408136`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.320919076644323, 0.7386801870753943}, {3.224909040889221, 
        0.}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.75509128594331, 1.9834420738408136`}, {4.1395389798402, 
        2.1730083151658577`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{4.75509128594331, 1.9834420738408136`}, {5.130817112383097, 
        2.4008879805779966`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.75509128594331, 1.9834420738408136`}, {4.358848236759159, 
        3.224560858027393}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.75509128594331, 1.9834420738408136`}, {4.320919076644323, 
        0.7386801870753943}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.358848236759159, 3.224560858027393}, {3.777680728349237, 
        3.347968252835022}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{4.358848236759159, 3.224560858027393}, {4.755022217206827, 
        3.657881425139676}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.358848236759159, 3.224560858027393}, {3.3395025909650085`, 
        3.947139640136455}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.358848236759159, 3.224560858027393}, {4.75509128594331, 
        1.9834420738408136`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.3395025909650085`, 3.947139640136455}, {2.836032156047095, 
        4.1308124160201265`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{3.3395025909650085`, 3.947139640136455}, {
        3.7079713108256067`, 4.461065176941227}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.3395025909650085`, 3.947139640136455}, {
        2.1060303033265555`, 3.971986985485878}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.3395025909650085`, 3.947139640136455}, {4.358848236759159, 
        3.224560858027393}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.1060303033265555`, 3.971986985485878}, {
        1.5835245168076728`, 4.247734401751989}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{2.1060303033265555`, 3.971986985485878}, {2.409222271876861, 
        4.471808114494204}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.1060303033265555`, 3.971986985485878}, {
        1.0704614001870447`, 3.3212468397060495`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.1060303033265555`, 3.971986985485878}, {
        3.3395025909650085`, 3.947139640136455}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0704614001870447`, 3.3212468397060495`}, {
        0.48376443798443036`, 3.571228820337723}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.0704614001870447`, 3.3212468397060495`}, {
        1.416571111895698, 3.721042747981387}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0704614001870447`, 3.3212468397060495`}, {
        0.5745025475278014, 2.171193760489139}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0704614001870447`, 3.3212468397060495`}, {
        2.1060303033265555`, 3.971986985485878}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.5745025475278014, 2.171193760489139}, {0., 
        2.3374363949439365`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{0.5745025475278014, 2.171193760489139}, {1.0143627244539037`,
         2.567557909056202}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.5745025475278014, 2.171193760489139}, {0.8789937011950781, 
        0.9067409324397}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.5745025475278014, 2.171193760489139}, {1.0704614001870447`,
         3.3212468397060495`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.8789937011950781, 0.9067409324397}, {0.3360596864042016, 
        1.0684371655867426`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{0.8789937011950781, 0.9067409324397}, {1.3144818137475784`, 
        1.3799504849098705`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.8789937011950781, 0.9067409324397}, {1.9031098971713076`, 
        0.06816523803129737}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.8789937011950781, 0.9067409324397}, {0.5745025475278014, 
        2.171193760489139}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.9031098971713076`, 0.06816523803129737}, {
        1.374223807042967, 0.24857116715128003`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.9031098971713076`, 0.06816523803129737}, {
        2.2533769580435687`, 0.551398721934701}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.9031098971713076`, 0.06816523803129737}, {
        3.224909040889221, 0.}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.9031098971713076`, 0.06816523803129737}, {
        0.8789937011950781, 0.9067409324397}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.224909040889221, 0.}, {2.700976805080317, 
        0.2116841106752787}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{3.224909040889221, 0.}, {3.559650579598662, 
        0.45501308849427247`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.224909040889221, 0.}, {4.320919076644323, 
        0.7386801870753943}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.224909040889221, 0.}, {1.9031098971713076`, 
        0.06816523803129737}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.771608386529417, 0.9651942572360266}, {3.693501891278827, 
        1.5706647882496927`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.771608386529417, 0.9651942572360266}, {4.320919076644323, 
        0.7386801870753943}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{3.771608386529417, 0.9651942572360266}, {4.1395389798402, 
        2.1730083151658577`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.771608386529417, 0.9651942572360266}, {2.700976805080317, 
        0.2116841106752787}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.1395389798402, 2.1730083151658577`}, {4.1537329029605266`, 
        2.719933886630466}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.1395389798402, 2.1730083151658577`}, {4.75509128594331, 
        1.9834420738408136`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{4.1395389798402, 2.1730083151658577`}, {3.777680728349237, 
        3.347968252835022}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{4.1395389798402, 2.1730083151658577`}, {3.771608386529417, 
        0.9651942572360266}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.777680728349237, 3.347968252835022}, {3.8835134338029866`, 
        3.947104483351551}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.777680728349237, 3.347968252835022}, {4.358848236759159, 
        3.224560858027393}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{3.777680728349237, 3.347968252835022}, {2.836032156047095, 
        4.1308124160201265`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{3.777680728349237, 3.347968252835022}, {4.1395389798402, 
        2.1730083151658577`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.836032156047095, 4.1308124160201265`}, {
        2.8864382799427535`, 4.782292431589923}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.836032156047095, 4.1308124160201265`}, {
        3.3395025909650085`, 3.947139640136455}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.836032156047095, 4.1308124160201265`}, {
        1.5835245168076728`, 4.247734401751989}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{2.836032156047095, 4.1308124160201265`}, {3.777680728349237, 
        3.347968252835022}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.5835245168076728`, 4.247734401751989}, {
        1.5803623612442266`, 4.859562073252034}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.5835245168076728`, 4.247734401751989}, {
        2.1060303033265555`, 3.971986985485878}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.5835245168076728`, 4.247734401751989}, {
        0.48376443798443036`, 3.571228820337723}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.5835245168076728`, 4.247734401751989}, {2.836032156047095, 
        4.1308124160201265`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.48376443798443036`, 3.571228820337723}, {
        0.4766089154201305, 4.135477086334262}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.48376443798443036`, 3.571228820337723}, {
        1.0704614001870447`, 3.3212468397060495`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.48376443798443036`, 3.571228820337723}, {0., 
        2.3374363949439365`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{0.48376443798443036`, 3.571228820337723}, {
        1.5835245168076728`, 4.247734401751989}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0., 2.3374363949439365`}, {0.02656777604128102, 
        2.898858468274386}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0., 2.3374363949439365`}, {0.5745025475278014, 
        2.171193760489139}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{0., 2.3374363949439365`}, {0.3360596864042016, 
        1.0684371655867426`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0., 2.3374363949439365`}, {0.48376443798443036`, 
        3.571228820337723}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.3360596864042016, 1.0684371655867426`}, {
        0.4024397858010924, 1.633900569494581}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.3360596864042016, 1.0684371655867426`}, {
        0.8789937011950781, 0.9067409324397}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.3360596864042016, 1.0684371655867426`}, {1.374223807042967,
         0.24857116715128003`}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{0.3360596864042016, 1.0684371655867426`}, {0., 
        2.3374363949439365`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.374223807042967, 0.24857116715128003`}, {
        1.4427105687876238`, 0.8558198720931514}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.374223807042967, 0.24857116715128003`}, {
        1.9031098971713076`, 0.06816523803129737}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{1.374223807042967, 0.24857116715128003`}, {2.700976805080317,
         0.2116841106752787}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.374223807042967, 0.24857116715128003`}, {
        0.3360596864042016, 1.0684371655867426`}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.700976805080317, 0.2116841106752787}, {2.694047908936145, 
        0.8597560688231758}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.700976805080317, 0.2116841106752787}, {3.224909040889221, 
        0.}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{2.700976805080317, 0.2116841106752787}, {3.771608386529417, 
        0.9651942572360266}}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{{2.700976805080317, 0.2116841106752787}, {1.374223807042967, 
        0.24857116715128003`}}]}}, 
     GraphicsComplexBox[{{3.693501891278827, 1.5706647882496927`}, {
      4.1537329029605266`, 2.719933886630466}, {3.8835134338029866`, 
      3.947104483351551}, {2.8864382799427535`, 4.782292431589923}, {
      1.5803623612442266`, 4.859562073252034}, {0.4766089154201305, 
      4.135477086334262}, {0.02656777604128102, 2.898858468274386}, {
      0.4024397858010924, 1.633900569494581}, {1.4427105687876238`, 
      0.8558198720931514}, {2.694047908936145, 0.8597560688231758}, {
      4.29719055349273, 1.6395397167361043`}, {4.777152365044506, 
      2.846962733841587}, {4.443749971759981, 4.121657737133722}, {
      3.4288080035671458`, 4.953479937970072}, {2.121991070135936, 
      4.996193166015605}, {1.0347315188668935`, 4.243491155830789}, {
      0.6254912998266768, 3.0152151949364487`}, {1.0170346843268994`, 
      1.8199899398213473`}, {2.001710051056443, 1.0818535418738793`}, {
      3.2306075269340675`, 0.996790257071722}, {4.6809250916696925`, 
      1.1685849182623906`}, {5.130817112383097, 2.4008879805779966`}, {
      4.755022217206827, 3.657881425139676}, {3.7079713108256067`, 
      4.461065176941227}, {2.409222271876861, 4.471808114494204}, {
      1.416571111895698, 3.721042747981387}, {1.0143627244539037`, 
      2.567557909056202}, {1.3144818137475784`, 1.3799504849098705`}, {
      2.2533769580435687`, 0.551398721934701}, {3.559650579598662, 
      0.45501308849427247`}, {4.320919076644323, 0.7386801870753943}, {
      4.75509128594331, 1.9834420738408136`}, {4.358848236759159, 
      3.224560858027393}, {3.3395025909650085`, 3.947139640136455}, {
      2.1060303033265555`, 3.971986985485878}, {1.0704614001870447`, 
      3.3212468397060495`}, {0.5745025475278014, 2.171193760489139}, {
      0.8789937011950781, 0.9067409324397}, {1.9031098971713076`, 
      0.06816523803129737}, {3.224909040889221, 0.}, {3.771608386529417, 
      0.9651942572360266}, {4.1395389798402, 2.1730083151658577`}, {
      3.777680728349237, 3.347968252835022}, {2.836032156047095, 
      4.1308124160201265`}, {1.5835245168076728`, 4.247734401751989}, {
      0.48376443798443036`, 3.571228820337723}, {0., 2.3374363949439365`}, {
      0.3360596864042016, 1.0684371655867426`}, {1.374223807042967, 
      0.24857116715128003`}, {2.700976805080317, 0.2116841106752787}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[7],
         "7"],
        Annotation[#, 7, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[8],
         "8"],
        Annotation[#, 8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[9],
         "9"],
        Annotation[#, 9, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[10],
         "10"],
        Annotation[#, 10, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[11],
         "11"],
        Annotation[#, 11, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[12],
         "12"],
        Annotation[#, 12, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[13],
         "13"],
        Annotation[#, 13, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[14],
         "14"],
        Annotation[#, 14, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[15],
         "15"],
        Annotation[#, 15, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[16],
         "16"],
        Annotation[#, 16, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[17],
         "17"],
        Annotation[#, 17, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[18],
         "18"],
        Annotation[#, 18, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[19],
         "19"],
        Annotation[#, 19, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[20],
         "20"],
        Annotation[#, 20, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[21],
         "21"],
        Annotation[#, 21, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[22],
         "22"],
        Annotation[#, 22, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[23],
         "23"],
        Annotation[#, 23, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[24],
         "24"],
        Annotation[#, 24, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[25],
         "25"],
        Annotation[#, 25, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[26],
         "26"],
        Annotation[#, 26, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[27],
         "27"],
        Annotation[#, 27, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[28],
         "28"],
        Annotation[#, 28, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[29],
         "29"],
        Annotation[#, 29, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[30],
         "30"],
        Annotation[#, 30, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[31],
         "31"],
        Annotation[#, 31, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[32],
         "32"],
        Annotation[#, 32, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[33],
         "33"],
        Annotation[#, 33, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[34],
         "34"],
        Annotation[#, 34, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[35],
         "35"],
        Annotation[#, 35, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[36],
         "36"],
        Annotation[#, 36, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[37],
         "37"],
        Annotation[#, 37, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[38],
         "38"],
        Annotation[#, 38, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[39],
         "39"],
        Annotation[#, 39, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[40],
         "40"],
        Annotation[#, 40, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[41],
         "41"],
        Annotation[#, 41, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[42],
         "42"],
        Annotation[#, 42, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[43],
         "43"],
        Annotation[#, 43, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[44],
         "44"],
        Annotation[#, 44, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[45],
         "45"],
        Annotation[#, 45, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[46],
         "46"],
        Annotation[#, 46, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[47],
         "47"],
        Annotation[#, 47, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[48],
         "48"],
        Annotation[#, 48, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[49],
         "49"],
        Annotation[#, 49, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[50],
         "50"],
        Annotation[#, 50, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{3.693501891278827, 1.5706647882496927`}, {
     4.1537329029605266`, 2.719933886630466}, {3.8835134338029866`, 
     3.947104483351551}, {2.8864382799427535`, 4.782292431589923}, {
     1.5803623612442266`, 4.859562073252034}, {0.4766089154201305, 
     4.135477086334262}, {0.02656777604128102, 2.898858468274386}, {
     0.4024397858010924, 1.633900569494581}, {1.4427105687876238`, 
     0.8558198720931514}, {2.694047908936145, 0.8597560688231758}, {
     4.29719055349273, 1.6395397167361043`}, {4.777152365044506, 
     2.846962733841587}, {4.443749971759981, 4.121657737133722}, {
     3.4288080035671458`, 4.953479937970072}, {2.121991070135936, 
     4.996193166015605}, {1.0347315188668935`, 4.243491155830789}, {
     0.6254912998266768, 3.0152151949364487`}, {1.0170346843268994`, 
     1.8199899398213473`}, {2.001710051056443, 1.0818535418738793`}, {
     3.2306075269340675`, 0.996790257071722}, {4.6809250916696925`, 
     1.1685849182623906`}, {5.130817112383097, 2.4008879805779966`}, {
     4.755022217206827, 3.657881425139676}, {3.7079713108256067`, 
     4.461065176941227}, {2.409222271876861, 4.471808114494204}, {
     1.416571111895698, 3.721042747981387}, {1.0143627244539037`, 
     2.567557909056202}, {1.3144818137475784`, 1.3799504849098705`}, {
     2.2533769580435687`, 0.551398721934701}, {3.559650579598662, 
     0.45501308849427247`}, {4.320919076644323, 0.7386801870753943}, {
     4.75509128594331, 1.9834420738408136`}, {4.358848236759159, 
     3.224560858027393}, {3.3395025909650085`, 3.947139640136455}, {
     2.1060303033265555`, 3.971986985485878}, {1.0704614001870447`, 
     3.3212468397060495`}, {0.5745025475278014, 2.171193760489139}, {
     0.8789937011950781, 0.9067409324397}, {1.9031098971713076`, 
     0.06816523803129737}, {3.224909040889221, 0.}, {3.771608386529417, 
     0.9651942572360266}, {4.1395389798402, 2.1730083151658577`}, {
     3.777680728349237, 3.347968252835022}, {2.836032156047095, 
     4.1308124160201265`}, {1.5835245168076728`, 4.247734401751989}, {
     0.48376443798443036`, 3.571228820337723}, {0., 2.3374363949439365`}, {
     0.3360596864042016, 1.0684371655867426`}, {1.374223807042967, 
     0.24857116715128003`}, {2.700976805080317, 0.2116841106752787}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{268., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{272, 261},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1949285931]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4732],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaximalBipartiteMatching",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/MaximalBipartiteMatching"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaximalIndependentVertexSet",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentVertexSet"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30704]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32218],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->28694]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->779542598],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaximalIndependentEdgeSet - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 16.3199690}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "matching edge coloring independent edge set maximal independent edge \
set"}, "index" -> True, "label" -> "Graph Utilities Package Symbol", 
    "language" -> "en", "paclet" -> "GraphUtilities Package", "status" -> 
    "None", "summary" -> 
    "MaximalIndepndentEdgeSet[g] gives a maximal independent edge set of an \
undirected graph g.", "synonyms" -> {}, "title" -> 
    "MaximalIndependentEdgeSet", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/MaximalIndependentEdgeSet"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4845, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->138391903]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 60970, 1690}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2067, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2690, 79, 63, 1, 70, "ObjectName",
 CellID->30234],
Cell[2756, 82, 505, 16, 70, "Usage",
 CellID->4405]
}, Open  ]],
Cell[CellGroupData[{
Cell[3298, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3776, 120, 240, 7, 70, "Notes",
 CellID->6334],
Cell[4019, 129, 117, 3, 70, "Notes",
 CellID->13674],
Cell[4139, 134, 64, 1, 70, "Notes",
 CellID->44],
Cell[4206, 137, 602, 17, 70, "3ColumnTableMod",
 CellID->29174]
}, Closed]],
Cell[CellGroupData[{
Cell[4845, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->138391903],
Cell[CellGroupData[{
Cell[5230, 173, 148, 5, 70, "ExampleSection",
 CellID->700858692],
Cell[5381, 180, 139, 4, 70, "Input",
 CellID->358134926],
Cell[5523, 186, 66, 1, 70, "ExampleText",
 CellID->11478],
Cell[5592, 189, 387, 12, 70, "Input",
 CellID->23811],
Cell[CellGroupData[{
Cell[6004, 205, 101, 3, 28, "Input",
 CellID->19912],
Cell[6108, 210, 1563, 46, 178, "Output",
 CellID->493910036]
}, Open  ]],
Cell[7686, 259, 117, 3, 70, "ExampleText",
 CellID->24464],
Cell[CellGroupData[{
Cell[7828, 266, 139, 4, 70, "Input",
 CellID->5705],
Cell[7970, 272, 362, 13, 36, "Output",
 CellID->1538743642]
}, Open  ]],
Cell[8347, 288, 107, 3, 70, "ExampleText",
 CellID->9741],
Cell[CellGroupData[{
Cell[8479, 295, 795, 27, 70, "Input",
 CellID->17673],
Cell[9277, 324, 2336, 63, 70, "Output",
 CellID->1866755942]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11662, 393, 217, 7, 70, "ExampleSection",
 CellID->5520],
Cell[CellGroupData[{
Cell[11904, 404, 225, 7, 70, "ExampleSubsection",
 CellID->31107],
Cell[12132, 413, 152, 4, 70, "ExampleText",
 CellID->3035],
Cell[12287, 419, 138, 4, 70, "Input",
 CellID->28944535],
Cell[12428, 425, 371, 12, 70, "Input",
 CellID->22190],
Cell[12802, 439, 363, 12, 70, "ExampleText",
 CellID->1842],
Cell[CellGroupData[{
Cell[13190, 455, 115, 3, 70, "Input",
 CellID->288],
Cell[13308, 460, 362, 13, 36, "Output",
 CellID->1604524671]
}, Open  ]],
Cell[13685, 476, 450, 16, 70, "ExampleText",
 CellID->9040],
Cell[CellGroupData[{
Cell[14160, 496, 179, 5, 70, "Input",
 CellID->8942],
Cell[14342, 503, 360, 13, 36, "Output",
 CellID->87596155]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[14763, 523, 223, 7, 70, "ExampleSection",
 CellID->15752],
Cell[14989, 532, 95, 1, 70, "ExampleText",
 CellID->17807],
Cell[15087, 535, 139, 4, 70, "Input",
 CellID->402109870],
Cell[15229, 541, 1959, 59, 70, "Input",
 CellID->19668],
Cell[17191, 602, 98, 2, 70, "ExampleText",
 CellID->14310],
Cell[CellGroupData[{
Cell[17314, 608, 143, 4, 70, "Input",
 CellID->6617],
Cell[17460, 614, 1701, 57, 71, "Output",
 CellID->1780638364]
}, Open  ]],
Cell[19176, 674, 134, 4, 70, "ExampleText",
 CellID->2421],
Cell[CellGroupData[{
Cell[19335, 682, 527, 17, 70, "Input",
 CellID->3728],
Cell[19865, 701, 37921, 882, 70, "Output",
 CellID->1949285931]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57847, 1590, 310, 9, 70, "SeeAlsoSection",
 CellID->4732],
Cell[58160, 1601, 551, 17, 70, "SeeAlso",
 CellID->30704]
}, Open  ]],
Cell[CellGroupData[{
Cell[58748, 1623, 314, 9, 70, "TutorialsSection",
 CellID->32218],
Cell[59065, 1634, 163, 3, 70, "Tutorials",
 CellID->28694]
}, Open  ]],
Cell[CellGroupData[{
Cell[59265, 1642, 319, 9, 70, "MoreAboutSection",
 CellID->779542598],
Cell[59587, 1653, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[59776, 1660, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

