(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36081,       1020]
NotebookOptionsPosition[     31593,        868]
NotebookOutlinePosition[     33102,        908]
CellTagsIndexPosition[     33017,        903]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MaximalIndependentEdgeSet" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MaximalIndependentEdgeSet\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MaximalIndependentVertexSet", "ObjectName",
 CellID->25998],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MaximalIndependentVertexSet", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a maximal independent vertex set of an undirected \
graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MaximalIndependentVertexSet", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["w", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a maximal independent vertex set of ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " with vertices weighted by ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16199]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MaximalIndependentVertexSet"], "InlineFormula"],
 " gives an (approximate) maximal set of vertices such the no two vertices \
form an edge. It treats the input as an undirected graph."
}], "Notes",
 CellID->15262],

Cell[TextData[{
 "The length of the vector ",
 Cell[BoxData[
  StyleBox["w", "TI"]], "InlineFormula"],
 " must be the same as the number of vertices in ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24108]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56037658],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->484342374],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->758789538],

Cell["This specifies a small graph:", "ExampleText",
 CellID->11478],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19912],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.4875669188038463`, 1.7455699225238166`}, {
    1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
    0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
    0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 1}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.4875669188038463`, 1.7455699225238166`}, {
     1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
     0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
     0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1018576213]
}, Open  ]],

Cell["\<\
This shows that the maximal independent vertex set contains three vertices:\
\>", "ExampleText",
 CellID->24464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"MaximalIndependentVertexSet", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "5"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2032136031]
}, Open  ]],

Cell["\<\
This plots the graph's maximal independent vertex set highlighted in red \
circles:\
\>", "ExampleText",
 CellID->9741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"m", ",", "#2"}], "]"}], ",", "Red", ",", "Green"}], 
          "]"}], "]"}], ",", "White", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", ".2"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->17673],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{1.4875669188038463`, 1.7455699225238166`}, {
      1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
      0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
      0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 1}}]}], {
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{1.4875669188038463`, 1.7455699225238166`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["1", {1.4875669188038463`, 1.7455699225238166`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{1.9996460459354313`, 0.8861424682559871}, 0.2], 
       {GrayLevel[0], 
        InsetBox["2", {1.9996460459354313`, 0.8861424682559871}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{1.511583448071915, 0.013316663859109679`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["3", {1.511583448071915, 0.013316663859109679`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{0.5114456436282868, 0.}, 0.2], 
       {GrayLevel[0], InsetBox["4", {0.5114456436282868, 0.}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{0., 0.8594781450938977}, 0.2], 
       {GrayLevel[0], InsetBox["5", {0., 0.8594781450938977}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{0.48875342845363157`, 1.7322387782110364`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["6", {0.48875342845363157`, 1.7322387782110364`}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.4875669188038463`, 1.7455699225238166`}, {
     1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
     0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
     0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->2062982494]
}, Open  ]],

Cell["\<\
This finds a maximal independent vertex set with preference given to vertices \
with even labels:\
\>", "ExampleText",
 CellID->30836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"MaximalIndependentVertexSet", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"EvenQ", "[", "#", "]"}], ",", "2", ",", "1"}], "]"}], "&"}],
       ",", 
      RowBox[{"VertexList", "[", "g", "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->24350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "4", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->769359516]
}, Open  ]],

Cell["\<\
This plots the new graph's maximal independent vertex set highlighted in red \
circles:\
\>", "ExampleText",
 CellID->1744718162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"m", ",", "#2"}], "]"}], ",", "Red", ",", "Green"}], 
          "]"}], "]"}], ",", "White", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", ".2"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->475929227],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{1.4875669188038463`, 1.7455699225238166`}, {
      1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
      0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
      0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 1}}]}], {
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{1.4875669188038463`, 1.7455699225238166`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["1", {1.4875669188038463`, 1.7455699225238166`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{1.9996460459354313`, 0.8861424682559871}, 0.2], 
       {GrayLevel[0], 
        InsetBox["2", {1.9996460459354313`, 0.8861424682559871}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{1.511583448071915, 0.013316663859109679`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["3", {1.511583448071915, 0.013316663859109679`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{0.5114456436282868, 0.}, 0.2], 
       {GrayLevel[0], InsetBox["4", {0.5114456436282868, 0.}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{0., 0.8594781450938977}, 0.2], 
       {GrayLevel[0], InsetBox["5", {0., 0.8594781450938977}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{0.48875342845363157`, 1.7322387782110364`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["6", {0.48875342845363157`, 1.7322387782110364`}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.4875669188038463`, 1.7455699225238166`}, {
     1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
     0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
     0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->512627352]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4499],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->334956069],

Cell["This is a matrix representation of the graph of a torus:", "ExampleText",
 CellID->23986],

Cell[BoxData[
 RowBox[{
  RowBox[{"torus", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", 
              RowBox[{"Mod", "[", 
               RowBox[{
                RowBox[{"i", "+", "1"}], ",", "5"}], "]"}]}], "+", "j", "+", 
             "1"}]}], "}"}], "\[Rule]", "1"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", 
              RowBox[{"Mod", "[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "5"}], "]"}]}], "+", "j", "+", 
             "1"}]}], "}"}], "\[Rule]", "1"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", "i"}], "+", 
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"j", "+", "1"}], ",", "10"}], "]"}], "+", "1"}]}], 
           "}"}], "\[Rule]", "1"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", "i"}], "+", 
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"j", "-", "1"}], ",", "10"}], "]"}], "+", "1"}]}], 
           "}"}], "\[Rule]", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", "9"}], "}"}]}], "]"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13290],

Cell["This finds the maximal independent vertex set of the torus:", \
"ExampleText",
 CellID->9161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"MaximalIndependentVertexSet", "[", "torus", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18636],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "5", ",", "7", ",", "9", ",", "12", ",", "14", ",", 
   "16", ",", "18", ",", "20", ",", "21", ",", "23", ",", "25", ",", "27", 
   ",", "29", ",", "32", ",", "34", ",", "36", ",", "38", ",", "40"}], 
  "}"}]], "Output",
 ImageSize->{476, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->475567087]
}, Open  ]],

Cell["\<\
This plots the torus, with the maximal independent vertex set in red:\
\>", "ExampleText",
 CellID->24767],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"color", "[", "_", "]"}], ":=", " ", "Green"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"color", "[", "#", "]"}], "=", "Red"}], ")"}], "&"}], ",", 
    "m"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"torus", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"color", "[", "#2", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", ".05"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellLabel->"In[4]:=",
 CellID->23655],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{3.693501891278827, 1.5706647882496927`}, {
      4.1537329029605266`, 2.719933886630466}, {3.8835134338029866`, 
      3.947104483351551}, {2.8864382799427535`, 4.782292431589923}, {
      1.5803623612442266`, 4.859562073252034}, {0.4766089154201305, 
      4.135477086334262}, {0.02656777604128102, 2.898858468274386}, {
      0.4024397858010924, 1.633900569494581}, {1.4427105687876238`, 
      0.8558198720931514}, {2.694047908936145, 0.8597560688231758}, {
      4.29719055349273, 1.6395397167361043`}, {4.777152365044506, 
      2.846962733841587}, {4.443749971759981, 4.121657737133722}, {
      3.4288080035671458`, 4.953479937970072}, {2.121991070135936, 
      4.996193166015605}, {1.0347315188668935`, 4.243491155830789}, {
      0.6254912998266768, 3.0152151949364487`}, {1.0170346843268994`, 
      1.8199899398213473`}, {2.001710051056443, 1.0818535418738793`}, {
      3.2306075269340675`, 0.996790257071722}, {4.6809250916696925`, 
      1.1685849182623906`}, {5.130817112383097, 2.4008879805779966`}, {
      4.755022217206827, 3.657881425139676}, {3.7079713108256067`, 
      4.461065176941227}, {2.409222271876861, 4.471808114494204}, {
      1.416571111895698, 3.721042747981387}, {1.0143627244539037`, 
      2.567557909056202}, {1.3144818137475784`, 1.3799504849098705`}, {
      2.2533769580435687`, 0.551398721934701}, {3.559650579598662, 
      0.45501308849427247`}, {4.320919076644323, 0.7386801870753943}, {
      4.75509128594331, 1.9834420738408136`}, {4.358848236759159, 
      3.224560858027393}, {3.3395025909650085`, 3.947139640136455}, {
      2.1060303033265555`, 3.971986985485878}, {1.0704614001870447`, 
      3.3212468397060495`}, {0.5745025475278014, 2.171193760489139}, {
      0.8789937011950781, 0.9067409324397}, {1.9031098971713076`, 
      0.06816523803129737}, {3.224909040889221, 0.}, {3.771608386529417, 
      0.9651942572360266}, {4.1395389798402, 2.1730083151658577`}, {
      3.777680728349237, 3.347968252835022}, {2.836032156047095, 
      4.1308124160201265`}, {1.5835245168076728`, 4.247734401751989}, {
      0.48376443798443036`, 3.571228820337723}, {0., 2.3374363949439365`}, {
      0.3360596864042016, 1.0684371655867426`}, {1.374223807042967, 
      0.24857116715128003`}, {2.700976805080317, 0.2116841106752787}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 11}, {1, 41}, {1, 2}, {1, 10}, {2, 12}, {2, 42}, {2, 3}, {
        3, 13}, {3, 43}, {3, 4}, {4, 14}, {4, 44}, {4, 5}, {5, 15}, {5, 45}, {
        5, 6}, {6, 16}, {6, 46}, {6, 7}, {7, 17}, {7, 47}, {7, 8}, {8, 18}, {
        8, 48}, {8, 9}, {9, 19}, {9, 49}, {9, 10}, {10, 20}, {10, 50}, {11, 
        21}, {11, 12}, {11, 20}, {12, 22}, {12, 13}, {13, 23}, {13, 14}, {14, 
        24}, {14, 15}, {15, 25}, {15, 16}, {16, 26}, {16, 17}, {17, 27}, {17, 
        18}, {18, 28}, {18, 19}, {19, 29}, {19, 20}, {20, 30}, {21, 31}, {21, 
        22}, {21, 30}, {22, 32}, {22, 23}, {23, 33}, {23, 24}, {24, 34}, {24, 
        25}, {25, 35}, {25, 26}, {26, 36}, {26, 27}, {27, 37}, {27, 28}, {28, 
        38}, {28, 29}, {29, 39}, {29, 30}, {30, 40}, {31, 41}, {31, 32}, {31, 
        40}, {32, 42}, {32, 33}, {33, 43}, {33, 34}, {34, 44}, {34, 35}, {35, 
        45}, {35, 36}, {36, 46}, {36, 37}, {37, 47}, {37, 38}, {38, 48}, {38, 
        39}, {39, 49}, {39, 40}, {40, 50}, {41, 42}, {41, 50}, {42, 43}, {43, 
        44}, {44, 45}, {45, 46}, {46, 47}, {47, 48}, {48, 49}, {49, 
        50}}]}], {
      {RGBColor[1, 0, 0], 
       DiskBox[{3.693501891278827, 1.5706647882496927`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{4.1537329029605266`, 2.719933886630466}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{3.8835134338029866`, 3.947104483351551}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{2.8864382799427535`, 4.782292431589923}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{1.5803623612442266`, 4.859562073252034}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{0.4766089154201305, 4.135477086334262}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{0.02656777604128102, 2.898858468274386}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{0.4024397858010924, 1.633900569494581}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{1.4427105687876238`, 0.8558198720931514}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{2.694047908936145, 0.8597560688231758}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{4.29719055349273, 1.6395397167361043`}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{4.777152365044506, 2.846962733841587}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{4.443749971759981, 4.121657737133722}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{3.4288080035671458`, 4.953479937970072}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{2.121991070135936, 4.996193166015605}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{1.0347315188668935`, 4.243491155830789}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{0.6254912998266768, 3.0152151949364487`}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{1.0170346843268994`, 1.8199899398213473`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{2.001710051056443, 1.0818535418738793`}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{3.2306075269340675`, 0.996790257071722}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{4.6809250916696925`, 1.1685849182623906`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{5.130817112383097, 2.4008879805779966`}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{4.755022217206827, 3.657881425139676}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{3.7079713108256067`, 4.461065176941227}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{2.409222271876861, 4.471808114494204}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{1.416571111895698, 3.721042747981387}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{1.0143627244539037`, 2.567557909056202}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{1.3144818137475784`, 1.3799504849098705`}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{2.2533769580435687`, 0.551398721934701}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{3.559650579598662, 0.45501308849427247`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{4.320919076644323, 0.7386801870753943}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{4.75509128594331, 1.9834420738408136`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{4.358848236759159, 3.224560858027393}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{3.3395025909650085`, 3.947139640136455}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{2.1060303033265555`, 3.971986985485878}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{1.0704614001870447`, 3.3212468397060495`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{0.5745025475278014, 2.171193760489139}, 0.05]}, 
      {RGBColor[1, 0, 0], 
       DiskBox[{0.8789937011950781, 0.9067409324397}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{1.9031098971713076`, 0.06816523803129737}, 0.05]}, 
      {RGBColor[1, 0, 0], DiskBox[{3.224909040889221, 0.}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{3.771608386529417, 0.9651942572360266}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{4.1395389798402, 2.1730083151658577`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{3.777680728349237, 3.347968252835022}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{2.836032156047095, 4.1308124160201265`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{1.5835245168076728`, 4.247734401751989}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{0.48376443798443036`, 3.571228820337723}, 0.05]}, 
      {RGBColor[0, 1, 0], DiskBox[{0., 2.3374363949439365`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{0.3360596864042016, 1.0684371655867426`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{1.374223807042967, 0.24857116715128003`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{2.700976805080317, 0.2116841106752787}, 0.05]}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{3.693501891278827, 1.5706647882496927`}, {
     4.1537329029605266`, 2.719933886630466}, {3.8835134338029866`, 
     3.947104483351551}, {2.8864382799427535`, 4.782292431589923}, {
     1.5803623612442266`, 4.859562073252034}, {0.4766089154201305, 
     4.135477086334262}, {0.02656777604128102, 2.898858468274386}, {
     0.4024397858010924, 1.633900569494581}, {1.4427105687876238`, 
     0.8558198720931514}, {2.694047908936145, 0.8597560688231758}, {
     4.29719055349273, 1.6395397167361043`}, {4.777152365044506, 
     2.846962733841587}, {4.443749971759981, 4.121657737133722}, {
     3.4288080035671458`, 4.953479937970072}, {2.121991070135936, 
     4.996193166015605}, {1.0347315188668935`, 4.243491155830789}, {
     0.6254912998266768, 3.0152151949364487`}, {1.0170346843268994`, 
     1.8199899398213473`}, {2.001710051056443, 1.0818535418738793`}, {
     3.2306075269340675`, 0.996790257071722}, {4.6809250916696925`, 
     1.1685849182623906`}, {5.130817112383097, 2.4008879805779966`}, {
     4.755022217206827, 3.657881425139676}, {3.7079713108256067`, 
     4.461065176941227}, {2.409222271876861, 4.471808114494204}, {
     1.416571111895698, 3.721042747981387}, {1.0143627244539037`, 
     2.567557909056202}, {1.3144818137475784`, 1.3799504849098705`}, {
     2.2533769580435687`, 0.551398721934701}, {3.559650579598662, 
     0.45501308849427247`}, {4.320919076644323, 0.7386801870753943}, {
     4.75509128594331, 1.9834420738408136`}, {4.358848236759159, 
     3.224560858027393}, {3.3395025909650085`, 3.947139640136455}, {
     2.1060303033265555`, 3.971986985485878}, {1.0704614001870447`, 
     3.3212468397060495`}, {0.5745025475278014, 2.171193760489139}, {
     0.8789937011950781, 0.9067409324397}, {1.9031098971713076`, 
     0.06816523803129737}, {3.224909040889221, 0.}, {3.771608386529417, 
     0.9651942572360266}, {4.1395389798402, 2.1730083151658577`}, {
     3.777680728349237, 3.347968252835022}, {2.836032156047095, 
     4.1308124160201265`}, {1.5835245168076728`, 4.247734401751989}, {
     0.48376443798443036`, 3.571228820337723}, {0., 2.3374363949439365`}, {
     0.3360596864042016, 1.0684371655867426`}, {1.374223807042967, 
     0.24857116715128003`}, {2.700976805080317, 0.2116841106752787}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1902153770]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14424],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["MaximalIndependentEdgeSet",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->355]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29755],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->13574]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->223976979],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaximalIndependentVertexSet - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 22.4451258}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "vertex coloring independent vertex set maximal independent vertex set"},
     "index" -> True, "label" -> "Graph Utilities Package Symbol", "language" -> 
    "en", "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "MaximalIndependentVertexSet[g] gives a maximal independent vertex set of \
an undirected graph g. MaximalIndependentVertexSet[g, w] gives a maximal \
independent vertex set of g with vertices weighted by w.", "synonyms" -> {}, 
    "title" -> "MaximalIndependentVertexSet", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/MaximalIndependentVertexSet"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4584, 152, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->56037658]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32875, 896}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1878, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2501, 76, 65, 1, 70, "ObjectName",
 CellID->25998],
Cell[2569, 79, 971, 30, 70, "Usage",
 CellID->16199]
}, Open  ]],
Cell[CellGroupData[{
Cell[3577, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4055, 131, 244, 5, 70, "Notes",
 CellID->15262],
Cell[4302, 138, 245, 9, 70, "Notes",
 CellID->24108]
}, Closed]],
Cell[CellGroupData[{
Cell[4584, 152, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56037658],
Cell[CellGroupData[{
Cell[4968, 166, 148, 5, 70, "ExampleSection",
 CellID->484342374],
Cell[5119, 173, 139, 4, 70, "Input",
 CellID->758789538],
Cell[5261, 179, 68, 1, 70, "ExampleText",
 CellID->11478],
Cell[5332, 182, 387, 12, 70, "Input",
 CellID->23811],
Cell[CellGroupData[{
Cell[5744, 198, 170, 5, 28, "Input",
 CellID->19912],
Cell[5917, 205, 1867, 45, 178, "Output",
 CellID->1018576213]
}, Open  ]],
Cell[7799, 253, 122, 3, 70, "ExampleText",
 CellID->24464],
Cell[CellGroupData[{
Cell[7946, 260, 141, 4, 70, "Input",
 CellID->5705],
Cell[8090, 266, 214, 7, 36, "Output",
 CellID->2032136031]
}, Open  ]],
Cell[8319, 276, 129, 4, 70, "ExampleText",
 CellID->9741],
Cell[CellGroupData[{
Cell[8473, 284, 668, 20, 70, "Input",
 CellID->17673],
Cell[9144, 306, 2174, 45, 182, "Output",
 CellID->2062982494]
}, Open  ]],
Cell[11333, 354, 144, 4, 70, "ExampleText",
 CellID->30836],
Cell[CellGroupData[{
Cell[11502, 362, 406, 13, 70, "Input",
 CellID->24350],
Cell[11911, 377, 213, 7, 36, "Output",
 CellID->769359516]
}, Open  ]],
Cell[12139, 387, 139, 4, 70, "ExampleText",
 CellID->1744718162],
Cell[CellGroupData[{
Cell[12303, 395, 672, 20, 70, "Input",
 CellID->475929227],
Cell[12978, 417, 2173, 45, 182, "Output",
 CellID->512627352]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15200, 468, 222, 7, 70, "ExampleSection",
 CellID->4499],
Cell[15425, 477, 139, 4, 70, "Input",
 CellID->334956069],
Cell[15567, 483, 95, 1, 70, "ExampleText",
 CellID->23986],
Cell[15665, 486, 1959, 59, 70, "Input",
 CellID->13290],
Cell[17627, 547, 99, 2, 70, "ExampleText",
 CellID->9161],
Cell[CellGroupData[{
Cell[17751, 553, 146, 4, 70, "Input",
 CellID->18636],
Cell[17900, 559, 413, 11, 36, "Output",
 CellID->475567087]
}, Open  ]],
Cell[18328, 573, 116, 3, 70, "ExampleText",
 CellID->24767],
Cell[CellGroupData[{
Cell[18469, 580, 748, 25, 70, "Input",
 CellID->23655],
Cell[19220, 607, 10663, 193, 196, "Output",
 CellID->1902153770]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29944, 807, 311, 9, 70, "SeeAlsoSection",
 CellID->14424],
Cell[30258, 818, 243, 6, 70, "SeeAlso",
 CellID->355]
}, Open  ]],
Cell[CellGroupData[{
Cell[30538, 829, 314, 9, 70, "TutorialsSection",
 CellID->29755],
Cell[30855, 840, 163, 3, 70, "Tutorials",
 CellID->13574]
}, Open  ]],
Cell[CellGroupData[{
Cell[31055, 848, 319, 9, 70, "MoreAboutSection",
 CellID->223976979],
Cell[31377, 859, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[31566, 866, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

