(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19966,        673]
NotebookOptionsPosition[     15897,        533]
NotebookOutlinePosition[     17148,        569]
CellTagsIndexPosition[     17063,        564]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageRankVector" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/PageRankVector"], "LinkRanks" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/LinkRanks"], 
          "LinkRankMatrix" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/LinkRankMatrix"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PageRankVector\"\>", 2->"\<\"LinkRanks\"\>", 
       3->"\<\"LinkRankMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PageRanks", "ObjectName",
 CellID->26036],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PageRanks", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the page rank of the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " as a rule list."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30474]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->1667494846],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "tolerance used for convergence check", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TeleportProbability",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/TeleportProbability"], "0.15", 
    Cell["probability of visiting random nodes", "TableText"]},
   {" ", 
    ButtonBox["RemoveSinks",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/RemoveSinks"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], 
    StyleBox[
     RowBox[{
     "whether", " ", "to", " ", "remove", " ", "sinks", " ", "by", " ", 
      "linking", " ", "them", " ", "with", " ", "every", " ", "node"}],
     FontFamily->"Verdana",
     FontSize->10]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->24411],

Cell[TextData[{
 "The page rank of a node measures the probability of a web surfer visiting \
that node. At any node, the surfer is assumed to follow all outlinks with \
equal probability; in addition, the surfer may visit any node randomly with a \
certain probability (",
 Cell[BoxData[
  ButtonBox["TeleportProbability",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/TeleportProbability"]], 
  "InlineFormula"],
 ")."
}], "Notes",
 CellID->2015537424],

Cell[TextData[{
 "The page rank algorithm uses an iterative procedure to find the page ranks. \
When the average change in the page ranks is less than the setting for ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 ", the iterative process terminates."
}], "Notes",
 CellID->3741]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->87331094],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->27821817],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->58575148],

Cell["This defines a small graph:", "ExampleText",
 CellID->1933671195],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<contact\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<links\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<work\>\""}], ",", 
     RowBox[{"\"\<links\>\"", "\[Rule]", "\"\<friend site\>\""}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3584],

Cell["This finds the page rank of each node:", "ExampleText",
 CellID->2000650101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PageRanks", "[", "g", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1351481993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"home\"\>", "\[Rule]", "0.14407493377505023`"}], ",", 
   RowBox[{"\<\"contact\"\>", "\[Rule]", "0.1848961429766947`"}], ",", 
   RowBox[{"\<\"links\"\>", "\[Rule]", "0.1848961429766947`"}], ",", 
   RowBox[{"\<\"work\"\>", "\[Rule]", "0.1848961429766947`"}], ",", 
   RowBox[{"\<\"friend site\"\>", "\[Rule]", "0.3012366372948656`"}]}], 
  "}"}]], "Output",
 ImageSize->{397, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->508481044]
}, Open  ]],

Cell[TextData[{
 "This boost the page rank of the ",
 Cell[BoxData["\"\<home\>\""], "InlineFormula"],
 " page by adding more feedback links:"
}], "ExampleText",
 CellID->22296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PageRanks", "[", 
  RowBox[{"Join", "[", 
   RowBox[{"g", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<friend site\>\"", "\[Rule]", "\"\<home\>\""}], ",", 
      RowBox[{"\"\<work\>\"", "\[Rule]", "\"\<home\>\""}], ",", 
      RowBox[{"\"\<contact\>\"", "\[Rule]", "\"\<home\>\""}]}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->29855],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"home\"\>", "\[Rule]", "0.4086886646564918`"}], ",", 
   RowBox[{"\<\"contact\"\>", "\[Rule]", "0.14579518488549334`"}], ",", 
   RowBox[{"\<\"links\"\>", "\[Rule]", "0.14579518488549334`"}], ",", 
   RowBox[{"\<\"work\"\>", "\[Rule]", "0.14579518488549334`"}], ",", 
   RowBox[{"\<\"friend site\"\>", "\[Rule]", "0.15392578068702797`"}]}], 
  "}"}]], "Output",
 ImageSize->{397, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1136836746]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->734],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RemoveSinks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->956983501],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->620756757],

Cell["This defines a small directed graph with node 4 a sink:", "ExampleText",
 CellID->369333331],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1260576865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1733335810],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.289325264907402, 1.548560010632156}, {
    1.6177537479398811`, 0.6043445040752278}, {0.8211445524087523, 0.}, {0., 
    0.5703652293378192}, {0.28868343143706776`, 1.527503072488133}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.036355975775320806`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 5}], ArrowBox[{2, 3}], ArrowBox[{3, 4}], 
      ArrowBox[{5, 4}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.289325264907402, 1.548560010632156}, {
     1.6177537479398811`, 0.6043445040752278}, {0.8211445524087523, 0.}, {0., 
     0.5703652293378192}, {0.28868343143706776`, 1.527503072488133}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->219998010]
}, Open  ]],

Cell["\<\
This calculates the page rank by linking node 4 with all other nodes:\
\>", "ExampleText",
 CellID->377831615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PageRanks", "[", "g", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->753820607],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "0.0985022037924128`"}], ",", 
   RowBox[{"2", "\[Rule]", "0.1403656256893005`"}], ",", 
   RowBox[{"3", "\[Rule]", "0.21781283603461113`"}], ",", 
   RowBox[{"4", "\[Rule]", "0.40295370879437514`"}], ",", 
   RowBox[{"5", "\[Rule]", "0.1403656256893005`"}]}], "}"}]], "Output",
 ImageSize->{465, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1466656424]
}, Open  ]],

Cell["\<\
Without removing the sink, the page rank of node 4 is much larger:\
\>", "ExampleText",
 CellID->76608079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PageRanks", "[", 
  RowBox[{"g", ",", 
   RowBox[{"RemoveSinks", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1578896828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "0.029999999999999992`"}], ",", 
   RowBox[{"2", "\[Rule]", "0.04274999999999999`"}], ",", 
   RowBox[{"3", "\[Rule]", "0.06633749999999998`"}], ",", 
   RowBox[{"4", "\[Rule]", "0.8181624999999999`"}], ",", 
   RowBox[{"5", "\[Rule]", "0.04274999999999999`"}]}], "}"}]], "Output",
 ImageSize->{423, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->340168642]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1307],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageRankVector",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRankVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/LinkRanks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRankMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/LinkRankMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2115278390]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5964],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->17784]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->167640689],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PageRanks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 23.9920404}", "context" -> 
    "GraphUtilities`", "keywords" -> {"PageRank page ranks"}, "index" -> True,
     "label" -> "Graph Utilities Package Symbol", "language" -> "en", 
    "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "PageRanks[g] gives the page rank of the graph g as a rule list.", 
    "synonyms" -> {}, "title" -> "PageRanks", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/PageRanks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5953, 186, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->87331094]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16921, 557}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2113, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2736, 80, 47, 1, 70, "ObjectName",
 CellID->26036],
Cell[2786, 83, 478, 15, 70, "Usage",
 CellID->30474]
}, Open  ]],
Cell[CellGroupData[{
Cell[3301, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3779, 120, 73, 1, 70, "Notes",
 CellID->1667494846],
Cell[3855, 123, 1226, 33, 70, "3ColumnTableMod",
 CellID->24411],
Cell[5084, 158, 472, 12, 70, "Notes",
 CellID->2015537424],
Cell[5559, 172, 357, 9, 70, "Notes",
 CellID->3741]
}, Closed]],
Cell[CellGroupData[{
Cell[5953, 186, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->87331094],
Cell[CellGroupData[{
Cell[6337, 200, 147, 5, 70, "ExampleSection",
 CellID->27821817],
Cell[6487, 207, 138, 4, 70, "Input",
 CellID->58575148],
Cell[6628, 213, 71, 1, 70, "ExampleText",
 CellID->1933671195],
Cell[6702, 216, 405, 11, 70, "Input",
 CellID->3584],
Cell[7110, 229, 82, 1, 70, "ExampleText",
 CellID->2000650101],
Cell[CellGroupData[{
Cell[7217, 234, 106, 3, 70, "Input",
 CellID->1351481993],
Cell[7326, 239, 544, 13, 54, "Output",
 CellID->508481044]
}, Open  ]],
Cell[7885, 255, 176, 5, 70, "ExampleText",
 CellID->22296],
Cell[CellGroupData[{
Cell[8086, 264, 396, 11, 70, "Input",
 CellID->29855],
Cell[8485, 277, 548, 13, 54, "Output",
 CellID->1136836746]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9082, 296, 216, 7, 70, "ExampleSection",
 CellID->734],
Cell[CellGroupData[{
Cell[9323, 307, 232, 7, 70, "ExampleSubsection",
 CellID->956983501],
Cell[9558, 316, 139, 4, 70, "Input",
 CellID->620756757],
Cell[9700, 322, 98, 1, 70, "ExampleText",
 CellID->369333331],
Cell[9801, 325, 350, 11, 70, "Input",
 CellID->1260576865],
Cell[CellGroupData[{
Cell[10176, 340, 230, 6, 70, "Input",
 CellID->1733335810],
Cell[10409, 348, 1683, 40, 193, "Output",
 CellID->219998010]
}, Open  ]],
Cell[12107, 391, 120, 3, 70, "ExampleText",
 CellID->377831615],
Cell[CellGroupData[{
Cell[12252, 398, 105, 3, 70, "Input",
 CellID->753820607],
Cell[12360, 403, 477, 12, 36, "Output",
 CellID->1466656424]
}, Open  ]],
Cell[12852, 418, 116, 3, 70, "ExampleText",
 CellID->76608079],
Cell[CellGroupData[{
Cell[12993, 425, 173, 5, 70, "Input",
 CellID->1578896828],
Cell[13169, 432, 479, 12, 36, "Output",
 CellID->340168642]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13721, 452, 310, 9, 70, "SeeAlsoSection",
 CellID->1307],
Cell[14034, 463, 772, 26, 70, "SeeAlso",
 CellID->2115278390]
}, Open  ]],
Cell[CellGroupData[{
Cell[14843, 494, 313, 9, 70, "TutorialsSection",
 CellID->5964],
Cell[15159, 505, 163, 3, 70, "Tutorials",
 CellID->17784]
}, Open  ]],
Cell[CellGroupData[{
Cell[15359, 513, 319, 9, 70, "MoreAboutSection",
 CellID->167640689],
Cell[15681, 524, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[15870, 531, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

