(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19748,        625]
NotebookOptionsPosition[     15853,        492]
NotebookOutlinePosition[     17224,        531]
CellTagsIndexPosition[     17139,        526]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WeakComponents" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/WeakComponents"], "Bicomponents" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/Bicomponents"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"WeakComponents\"\>", 
       2->"\<\"Bicomponents\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StrongComponents", "ObjectName",
 CellID->23606],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"StrongComponents", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all strongly connected components in \
the directed graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
A strongly connected component of a directed graph is a set of vertices such \
that there is a path connecting any two vertices.\
\>", "Notes",
 CellID->31150]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->660199502],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->626538515],

Cell["This defines a small graph:", "ExampleText",
 CellID->429326891],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->183858217],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "6"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1872375998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->506325967],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{354, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32094993]
}, Open  ]],

Cell["This finds all strong components of the above graph:", "ExampleText",
 CellID->1780779145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StrongComponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->625099218],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->416622213]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28676],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1551074621],

Cell["This defines a small graph:", "ExampleText",
 CellID->308056619],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "5"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1871055241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->521794200],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWF9QlFUUv+63/F0KRJgsErfgwVEffPDBB2f0qZxxUhtfnEZnIEFhnEYC
S4oIhUYsJygGnaISxv5gasmoEzVjMpMz8RATD1mMCYGhbsDasiy7H7Dh9jv3
7vLdveyyC9FIyXxc7r3nd8/9nXPvPfdcnsk9UJD/Qu6Bwt251qeLc4sKCneX
WJ/aX4wubRFj7BJ+dy5lqPtQ47+XfD78lctEKrWJkXbPwMe6/QtmoULzDHzk
9fxKouVcrg+d0+1nJbmtwTfpNuRu2wfol8ef8vEflsnlk1672/a+IdeHTo/9
2UqiRImF+07l6K0K3V5PqHqmuW4WjzkuG7M4e/Z6Bt425M7uvMmJIWmWiSvO
7nxDDrCze58xftzR5LpZYsgxmft2jcrC80f1+DDodzALFaL9naFl5Ld9mMiQ
83YwC3QZct5+UWIxfAoqDTlvNzxoLIR+l82mOxxUTb1/rMxTrMDF1NvWxhI6
GxvbKirwfVNS8vn27Q1r176VlvZGfPy3ZWUsBd0cpdk6OwVhlhQVWw2FhmMY
E4G1CYV5CheevcmvLzZgha39uXes1qMpKaamjRtZbEtOzpQVzVu3nli92gQb
FhN/kmvvrVnj5y9mogjh6+DKorLHHHKUYdcSKsxY4w/XrcOk/e3t8YqlmqSB
hbBYaOg6f/70tm3ttbVDXV1xig9U5lpgn939ucDR2+vnjKnD7LPQNszZ8jPP
Zh1C93IqJDtD4yGvyUgiaCbHR2FVmDMcvGPmbd0ul5beaG316rq6bqH5Keum
4ZBcra6G71m8smqEN8k7d/DHXMyEBaORJlQTQlgo75TYebFUPXmR7FJPYEj9
scKeTzZtwmHEwtKZ4+fx+MqVaOJ7MzW1Ljv75Pr1/BzG4ByKfv9pNMvemXcb
uSfNBj5ynIm0G00cj22CBafAmExFzIX8/NrMzOYtW66Ul1+/eJFvBxaDmCky
gznZGrRvZrAxGBdlBJUsSuM4ETKoGj8vUeP/eZP/91i4b1dMyzPvfmVocXbv
mZZnjtuCWKBLyTMLjfFjjpNQGZRnjt46prLwei7oQ+8GaUGaLNvShH5JPljj
342CBQzU7cdJlMTlIqGW5JPf64OSFbq9bsL1g8Fi+ltgtmV0bwev+5rX/Qs+
ZqEC+A4/z0J5TSLl/t15rt9fGu0vZRYqNOeN5/1rImuZ+/56ULTIGZcR22cf
SeemXcRR3AFI5pAR+uPsbO6m0PPONh+b93mC7EP6gswJ379v3wx3vBb1qoVj
NfOumL7O0eyOaN4/gZwgOq0L6XT9Ey2RbqWRnoIJ52dedwvF0RZq7w2hJdKt
4r5TNdp/kEJoEo+j4t84JCrgWh7hKPHiouoTvI23AHJZZHjsZY5aynsBAZCq
Vt4+t2PHT83NVJVROO14/9FYwQDvAbSpepCjHuW9XxcVISb4pm4vpI4iVQxC
gQeSZZRsGW9/unkzkmqqlnLUY7wXiqCOqhm8jVc7zj/e9OwVCQVG4IFJRNuM
UwtUpdmMtE/gMhRfCA54hJ5YterLXbvYqxz1uOIL2TdktYwyfKH6uYyjlim+
SA8whdWYl70moUCzfsUK8kW6YrVAZSq9S5SVLOcosSZQ7/e2eB+35OTAXVSV
UfAQHjXgzBYHrMFAqr5uoMxI8+uyKOqCYIqiXcYJ/sBdO3MmmeMwJSamagXH
WQN2HktPb9ywgT0c8AYsILsPcZTYocN9fUeTk6n3IcWHAvUk77165IjfGxbe
xoMTHMgbhzkqS+GbqKytjIKdeL1RNUHyDlUrOSpbGRun7LoqCWXwiFNWrUpi
P9KzZ/j6TnzMQgVyoJx7IgIcllFho81CQYW7nUKjI73J7/+ocDlSePRMd2fo
UeHuxIWypjOhXH37g/btSHfevb+GDZR4TbBFfwMzhVU6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->463723995]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["StrongComponents"], "InlineFormula"],
 " finds connected components of a directed graph:"
}], "ExampleText",
 CellID->1666203828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StrongComponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->879673641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1144706364]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeakComponents",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/WeakComponents"]], 
  "InlineFormula"],
 " finds connected components, assuming that the graph is undirected:"
}], "ExampleText",
 CellID->437057316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeakComponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1866246551],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1237832169]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9404],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeakComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/WeakComponents"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bicomponents",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/Bicomponents"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->876476447]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9003],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->17784]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1876030786],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StrongComponents - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 30.6015846}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "connected components strongly connected components block triangular \
ordering"}, "index" -> True, "label" -> "Graph Utilities Package Symbol", 
    "language" -> "en", "paclet" -> "GraphUtilities Package", "status" -> 
    "None", "summary" -> 
    "StrongComponents[g] gives a list of all strongly connected components in \
the directed graph g.", "synonyms" -> {}, "title" -> "StrongComponents", 
    "type" -> "Symbol", "uri" -> "GraphUtilities/ref/StrongComponents"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3889, 128, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->660199502]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16996, 519}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1981, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2604, 78, 54, 1, 70, "ObjectName",
 CellID->23606],
Cell[2661, 81, 507, 16, 70, "Usage",
 CellID->22]
}, Open  ]],
Cell[CellGroupData[{
Cell[3205, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3683, 119, 169, 4, 70, "Notes",
 CellID->31150]
}, Closed]],
Cell[CellGroupData[{
Cell[3889, 128, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->660199502],
Cell[CellGroupData[{
Cell[4274, 142, 148, 5, 70, "ExampleSection",
 CellID->626538515],
Cell[4425, 149, 70, 1, 70, "ExampleText",
 CellID->429326891],
Cell[4498, 152, 139, 4, 70, "Input",
 CellID->183858217],
Cell[4640, 158, 476, 14, 70, "Input",
 CellID->1872375998],
Cell[CellGroupData[{
Cell[5141, 176, 229, 6, 28, "Input",
 CellID->506325967],
Cell[5373, 184, 3082, 55, 88, "Output",
 Evaluatable->False,
 CellID->32094993]
}, Open  ]],
Cell[8470, 242, 96, 1, 70, "ExampleText",
 CellID->1780779145],
Cell[CellGroupData[{
Cell[8591, 247, 112, 3, 70, "Input",
 CellID->625099218],
Cell[8706, 252, 380, 13, 36, "Output",
 CellID->416622213]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9135, 271, 233, 7, 70, "ExampleSection",
 CellID->28676],
Cell[9371, 280, 140, 4, 70, "Input",
 CellID->1551074621],
Cell[9514, 286, 70, 1, 70, "ExampleText",
 CellID->308056619],
Cell[9587, 289, 434, 13, 70, "Input",
 CellID->1871055241],
Cell[CellGroupData[{
Cell[10046, 306, 229, 6, 70, "Input",
 CellID->521794200],
Cell[10278, 314, 2147, 39, 70, "Output",
 Evaluatable->False,
 CellID->463723995]
}, Open  ]],
Cell[12440, 356, 160, 4, 70, "ExampleText",
 CellID->1666203828],
Cell[CellGroupData[{
Cell[12625, 364, 112, 3, 70, "Input",
 CellID->879673641],
Cell[12740, 369, 381, 13, 36, "Output",
 CellID->1144706364]
}, Open  ]],
Cell[13136, 385, 274, 8, 70, "ExampleText",
 CellID->437057316],
Cell[CellGroupData[{
Cell[13435, 397, 111, 3, 70, "Input",
 CellID->1866246551],
Cell[13549, 402, 333, 11, 36, "Output",
 CellID->1237832169]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13943, 420, 310, 9, 70, "SeeAlsoSection",
 CellID->9404],
Cell[14256, 431, 505, 17, 70, "SeeAlso",
 CellID->876476447]
}, Open  ]],
Cell[CellGroupData[{
Cell[14798, 453, 313, 9, 70, "TutorialsSection",
 CellID->9003],
Cell[15114, 464, 163, 3, 70, "Tutorials",
 CellID->17784]
}, Open  ]],
Cell[CellGroupData[{
Cell[15314, 472, 320, 9, 70, "MoreAboutSection",
 CellID->1876030786],
Cell[15637, 483, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[15826, 490, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

