(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     56400,       1600]
NotebookOptionsPosition[     50849,       1411]
NotebookOutlinePosition[     52272,       1449]
CellTagsIndexPosition[     52186,       1444]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToCombinatoricaGraph", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToCombinatoricaGraph", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the ",
     StyleBox["Combinatorica",
      FontSlant->"Italic"],
     " representation of the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToCombinatoricaGraph", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ", adding additional unconnected vertices, if necessary, to create a \
graph with ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->213763687],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method used to lay out the graph", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->464392908]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->642515223],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->272091007],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->137747066],

Cell["This defines a simple graph:", "ExampleText",
 CellID->8213],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "b"}], ",", 
     RowBox[{"b", "\[Rule]", "c"}], ",", 
     RowBox[{"c", "\[Rule]", "d"}], ",", 
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"e", "\[Rule]", "f"}], ",", 
     RowBox[{"f", "\[Rule]", "a"}], ",", 
     RowBox[{"i", "\[Rule]", "k"}], ",", 
     RowBox[{"k", "\[Rule]", "h"}], ",", 
     RowBox[{"h", "\[Rule]", "i"}], ",", 
     RowBox[{"k", "\[Rule]", "a"}], ",", 
     RowBox[{"k", "\[Rule]", "b"}], ",", 
     RowBox[{"h", "\[Rule]", "c"}], ",", 
     RowBox[{"h", "\[Rule]", "d"}], ",", 
     RowBox[{"i", "\[Rule]", "f"}], ",", 
     RowBox[{"i", "\[Rule]", "e"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23992],

Cell[TextData[{
 "This shows the ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " object:"
}], "ExampleText",
 CellID->1368998428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", 
  RowBox[{"ToCombinatoricaGraph", "[", "g", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2670],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{1., 0.43831694450133785`}, {0.7604064847439643, 
      0.865257744388809}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7604064847439643, 0.865257744388809}, {0.2505162133543421, 
      0.8717497775622857}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.2505162133543421, 0.8717497775622857}, {0., 
      0.4511193002007417}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0., 0.4511193002007417}, {0.24968283153748527`, 
      0.006335710518021792}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.24968283153748527`, 0.006335710518021792}, {
      0.7396393450752398, 0.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7396393450752398, 0.}, {1., 0.43831694450133785`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.49697112288771217`, 0.20939209302417858`}, {
      0.7004880139971662, 0.5513370922968581}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7004880139971662, 0.5513370922968581}, {
      0.30259259046343634`, 0.5560805490300901}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.30259259046343634`, 0.5560805490300901}, {
      0.49697112288771217`, 0.20939209302417858`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7004880139971662, 0.5513370922968581}, {1., 
      0.43831694450133785`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7004880139971662, 0.5513370922968581}, {0.7604064847439643, 
      0.865257744388809}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.30259259046343634`, 0.5560805490300901}, {
      0.2505162133543421, 0.8717497775622857}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.30259259046343634`, 0.5560805490300901}, {0., 
      0.4511193002007417}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.49697112288771217`, 0.20939209302417858`}, {
      0.7396393450752398, 0.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.49697112288771217`, 0.20939209302417858`}, {
      0.24968283153748527`, 0.006335710518021792}}], 
     {GrayLevel[0]}}}, {
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{1., 0.43831694450133785`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["a", 
       Scaled[{0.02, 0.02}, {1., 0.43831694450133785`}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.7604064847439643, 0.865257744388809}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["b", 
       Scaled[{0.02, 0.02}, {0.7604064847439643, 0.865257744388809}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.2505162133543421, 0.8717497775622857}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["c", 
       Scaled[{0.02, 0.02}, {0.2505162133543421, 0.8717497775622857}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0., 0.4511193002007417}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["d", 
       Scaled[{0.02, 0.02}, {0., 0.4511193002007417}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.24968283153748527`, 0.006335710518021792}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["e", 
       Scaled[{0.02, 0.02}, {0.24968283153748527`, 0.006335710518021792}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.7396393450752398, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["f", 
       Scaled[{0.02, 0.02}, {0.7396393450752398, 0.}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.49697112288771217`, 0.20939209302417858`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["i", 
       Scaled[{0.02, 0.02}, {0.49697112288771217`, 0.20939209302417858`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.7004880139971662, 0.5513370922968581}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["k", 
       Scaled[{0.02, 0.02}, {0.7004880139971662, 0.5513370922968581}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.30259259046343634`, 0.5560805490300901}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["h", 
       Scaled[{0.02, 0.02}, {0.30259259046343634`, 0.5560805490300901}], \
{-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->1,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->{265., Automatic},
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{-0.05, 1.05}, {-0.05, 0.9217497775622857}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{269, 265},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2122045034]
}, Open  ]],

Cell["\<\
This uses the optional second argument to pad the graph with additional, \
unconnected, vertices:\
\>", "ExampleText",
 CellID->5097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", 
  RowBox[{"ToCombinatoricaGraph", "[", 
   RowBox[{"g", ",", "12"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6704],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{1., 0.2637129474974362}, {0.8862185878661397, 
      0.4664643744584066}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.8862185878661397, 0.4664643744584066}, {0.64407499291103, 
      0.46954739906075726`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.64407499291103, 0.46954739906075726`}, {0.525106462033121, 
      0.2697927034898365}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.525106462033121, 0.2697927034898365}, {0.6436792252715455, 
      0.05856785095580104}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6436792252715455, 0.05856785095580104}, {0.8763564074354069,
       0.0555590629723637}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.8763564074354069, 0.0555590629723637}, {1., 
      0.2637129474974362}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7611148368486391, 0.15499801485090567`}, {
      0.8577636933036279, 0.31738548534559036`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.8577636933036279, 0.31738548534559036`}, {
      0.6688057278808651, 0.31963812229582766`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6688057278808651, 0.31963812229582766`}, {
      0.7611148368486391, 0.15499801485090567`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.8577636933036279, 0.31738548534559036`}, {1., 
      0.2637129474974362}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.8577636933036279, 0.31738548534559036`}, {
      0.8862185878661397, 0.4664643744584066}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6688057278808651, 0.31963812229582766`}, {0.64407499291103, 
      0.46954739906075726`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6688057278808651, 0.31963812229582766`}, {0.525106462033121,
       0.2697927034898365}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7611148368486391, 0.15499801485090567`}, {
      0.8763564074354069, 0.0555590629723637}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7611148368486391, 0.15499801485090567`}, {
      0.6436792252715455, 0.05856785095580104}}], 
     {GrayLevel[0]}}}, {
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{1., 0.2637129474974362}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["a", 
       Scaled[{0.02, 0.02}, {1., 0.2637129474974362}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.8862185878661397, 0.4664643744584066}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["b", 
       Scaled[{0.02, 0.02}, {0.8862185878661397, 0.4664643744584066}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.64407499291103, 0.46954739906075726`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["c", 
       Scaled[{0.02, 0.02}, {0.64407499291103, 0.46954739906075726`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.525106462033121, 0.2697927034898365}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["d", 
       Scaled[{0.02, 0.02}, {0.525106462033121, 0.2697927034898365}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.6436792252715455, 0.05856785095580104}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["e", 
       Scaled[{0.02, 0.02}, {0.6436792252715455, 0.05856785095580104}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.8763564074354069, 0.0555590629723637}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["f", 
       Scaled[{0.02, 0.02}, {0.8763564074354069, 0.0555590629723637}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.7611148368486391, 0.15499801485090567`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["i", 
       Scaled[{0.02, 0.02}, {0.7611148368486391, 0.15499801485090567`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.8577636933036279, 0.31738548534559036`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["k", 
       Scaled[{0.02, 0.02}, {0.8577636933036279, 0.31738548534559036`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.6688057278808651, 0.31963812229582766`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["h", 
       Scaled[{0.02, 0.02}, {0.6688057278808651, 0.31963812229582766`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.525106462033121, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["10", 
       Scaled[{0.02, 0.02}, {0.525106462033121, 0.}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.7019239956795352, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["11", 
       Scaled[{0.02, 0.02}, {0.7019239956795352, 0.}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.8787415293259494, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["12", 
       Scaled[{0.02, 0.02}, {0.8787415293259494, 0.}], {-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->1,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.47510646203312096`, 1.05}, {-0.05, 0.5195473990607573}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->226690737]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28027],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4084],

Cell["This defines a simple graph:", "ExampleText",
 CellID->32604],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->11846408],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "b"}], ",", 
     RowBox[{"b", "\[Rule]", "c"}], ",", 
     RowBox[{"c", "\[Rule]", "d"}], ",", 
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"e", "\[Rule]", "f"}], ",", 
     RowBox[{"f", "\[Rule]", "a"}], ",", 
     RowBox[{"i", "\[Rule]", "k"}], ",", 
     RowBox[{"k", "\[Rule]", "h"}], ",", 
     RowBox[{"h", "\[Rule]", "i"}], ",", 
     RowBox[{"k", "\[Rule]", "a"}], ",", 
     RowBox[{"k", "\[Rule]", "b"}], ",", 
     RowBox[{"h", "\[Rule]", "c"}], ",", 
     RowBox[{"h", "\[Rule]", "d"}], ",", 
     RowBox[{"i", "\[Rule]", "f"}], ",", 
     RowBox[{"i", "\[Rule]", "e"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->237550193],

Cell[TextData[{
 "This contrasts the ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " representation of the graph with the drawing by ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1209279200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ShowGraph", "[", 
     RowBox[{"ToCombinatoricaGraph", "[", "g", "]"}], "]"}], ",", 
    RowBox[{"GraphPlot", "[", 
     RowBox[{"g", ",", 
      RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27489],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{330, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->200909843]
}, Open  ]],

Cell["\<\
This uses the spring embedding method to find the coordinates:\
\>", "ExampleText",
 CellID->683885067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", 
  RowBox[{"ToCombinatoricaGraph", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Method", "\[Rule]", "SpringEmbedding"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->1128541062],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{147, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->216309954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1046272759],

Cell[TextData[{
 "This defines a ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " object:"
}], "ExampleText",
 CellID->1160513182],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1184580375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"GridGraph", "[", 
   RowBox[{"4", ",", "4"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2131783975],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", "\<\"Undirected\"\>", 
   "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
  SequenceForm[
  "\[SkeletonIndicator]Graph:<", 24, ", ", 16, ", ", "Undirected", 
   ">\[SkeletonIndicator]"],
  Editable->False]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->601141226]
}, Open  ]],

Cell[TextData[{
 "If the input to ",
 Cell[BoxData[
  ButtonBox["ToCombinatoricaGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/ToCombinatoricaGraph"]], 
  "InlineFormula"],
 " is already a ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " object, it is not changed:"
}], "ExampleText",
 CellID->677366046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ShowGraph", "[", "g", "]"}], ",", 
    RowBox[{"ShowGraph", "[", 
     RowBox[{"ToCombinatoricaGraph", "[", "g", "]"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2035749510],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj9rwkAYxi9NdVBExMFEECLi6CaCLjq1U4dOOlRQYiGipWI7CoKDs4tk
FD+ALro7Cn4BR0dHP4J9kxzmjwUhjj6BnPfce8/5O5weXt+av9rnV/O3rTaV
136zp7XVH+Xlu09LosAYW9P7ITGan2lmvuvzmT6do2iM4n6/r9Vq2+2WSR4t
36gH7vQ/OSiGwyGznndjEDVNO5vPv3WBygKtC44TTqdTPB7f7Xb8e0gXi8XJ
ZMI5ptMp6ePxaNfpJEMH7vRb93g2VxVFORwOxtTa1Wg0ZrOZrUnQkjG1TjV+
GeuegTv9AihAAQpQgAIUoAAFKEABioeluKS7cDi8XC7t9JVOpweDAXeNx2PS
rnRGB7nSnU//dbpLJBJMqlQq5t1IRyIRJps6Go2STiaTrjqFPE7h3++koMRG
G3VdZ9Jms2HiarXKZrPdbpfJpu71eqQXi4Vd9yZEn34kRFCAAhSgAAUoQAEK
UIACFKBw5NRgMFitVplkhD2x0+lQ7iwUCkw2dalUIq2qql335lSf/uucmsvl
+K5yuUw6lUrxUzKZDOl8Pu+qe3OqH78np6KTCQpQgAIUoAAFKEABClCA4iEp
LgkxFAqNRiPeXZvP55Ik1et13n1rtVqkKdvYdW9C9Om/ToiyLLs6jbFYjHci
6Qh2u5Ppx+9JiLquuxIc1/KNeuBOv0Vx/V9ia2TCH3AJEuo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->369662056]
}, Open  ]],

Cell["This adds extra vertices:", "ExampleText",
 CellID->786998624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", 
  RowBox[{"ToCombinatoricaGraph", "[", 
   RowBox[{"g", ",", "18"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1506746652],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmU9qwkAUxp+MyQgKgmSRQAW7ENwI4kpoBFdtNgWPYIgFXZQU686FF/AE
bjxHVi49hsdwmb7JRBMn1kppS6AvkHG+7w2/+WMWH8mzO5+8vLrzqec2nmbu
22TqvTce/RlarAAAK3GbgP0Qe9G9CkP8/e1WEy07HA7b7RZbKH2huaLriu4r
upjMUmy1Wrgx0zSxwG9w9Ixzl3HsjMOiGaN52X6/B3ndi4btdrswusASjZbU
AbAGDxddljqp0WiEbrfbjU9G6uFwGGvbtmPNU3Xh1pXxfUXLk9KP7mazEV1J
Fc+DXLekYhGHJPXBYIDnLboeUYhCFKIQhShEyTnllL4cx1mv10naQlCSvrCC
9bP01el0giCAcUKJM1C1Wr2SrizLupiuarUaOnJNUQ45y0Ai7ei4dNB6vd4N
rpZxRYpK71imnmazCSU8D2C4vTglSd1ut2PNlfo4d/8hUYhCFKIQhShEyS/l
57MW53yxWPDlcglFwzDQqVQqJ6dcLp8cPTXmetbyPA+i0Zrv+ze4Wsa9nLW+
88aKshZRiEIUohCFKP+Dkts3Ule+5bmplavp5nPNFS1X/jdfXdMtFD4AC6sJ
gA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{140, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->4404535]
}, Open  ]],

Cell[TextData[{
 "This adds extra vertices, but using ",
 Cell[BoxData["\"\<SpringEmbedding\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->179275190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", 
  RowBox[{"ToCombinatoricaGraph", "[", 
   RowBox[{"g", ",", "18", ",", 
    RowBox[{"Method", "\[Rule]", "\"\<SpringEmbedding\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1034168238],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->209836075]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->28524324],

Cell["\<\
A second argument specifying fewer vertices than those contained in the graph \
is ignored:\
\>", "ExampleText",
 CellID->9161],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "b"}], ",", 
     RowBox[{"b", "\[Rule]", "c"}], ",", 
     RowBox[{"c", "\[Rule]", "d"}], ",", 
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"e", "\[Rule]", "f"}], ",", 
     RowBox[{"f", "\[Rule]", "a"}], ",", 
     RowBox[{"i", "\[Rule]", "k"}], ",", 
     RowBox[{"k", "\[Rule]", "h"}], ",", 
     RowBox[{"h", "\[Rule]", "i"}], ",", 
     RowBox[{"k", "\[Rule]", "a"}], ",", 
     RowBox[{"k", "\[Rule]", "b"}], ",", 
     RowBox[{"h", "\[Rule]", "c"}], ",", 
     RowBox[{"h", "\[Rule]", "d"}], ",", 
     RowBox[{"i", "\[Rule]", "f"}], ",", 
     RowBox[{"i", "\[Rule]", "e"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", 
  RowBox[{"ToCombinatoricaGraph", "[", 
   RowBox[{"g", ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25205],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{1., 0.43831694450133785`}, {0.7604064847439643, 
      0.865257744388809}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7604064847439643, 0.865257744388809}, {0.2505162133543421, 
      0.8717497775622857}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.2505162133543421, 0.8717497775622857}, {0., 
      0.4511193002007417}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0., 0.4511193002007417}, {0.24968283153748527`, 
      0.006335710518021792}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.24968283153748527`, 0.006335710518021792}, {
      0.7396393450752398, 0.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7396393450752398, 0.}, {1., 0.43831694450133785`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.49697112288771217`, 0.20939209302417858`}, {
      0.7004880139971662, 0.5513370922968581}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7004880139971662, 0.5513370922968581}, {
      0.30259259046343634`, 0.5560805490300901}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.30259259046343634`, 0.5560805490300901}, {
      0.49697112288771217`, 0.20939209302417858`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7004880139971662, 0.5513370922968581}, {1., 
      0.43831694450133785`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7004880139971662, 0.5513370922968581}, {0.7604064847439643, 
      0.865257744388809}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.30259259046343634`, 0.5560805490300901}, {
      0.2505162133543421, 0.8717497775622857}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.30259259046343634`, 0.5560805490300901}, {0., 
      0.4511193002007417}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.49697112288771217`, 0.20939209302417858`}, {
      0.7396393450752398, 0.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.49697112288771217`, 0.20939209302417858`}, {
      0.24968283153748527`, 0.006335710518021792}}], 
     {GrayLevel[0]}}}, {
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{1., 0.43831694450133785`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["a", 
       Scaled[{0.02, 0.02}, {1., 0.43831694450133785`}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.7604064847439643, 0.865257744388809}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["b", 
       Scaled[{0.02, 0.02}, {0.7604064847439643, 0.865257744388809}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.2505162133543421, 0.8717497775622857}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["c", 
       Scaled[{0.02, 0.02}, {0.2505162133543421, 0.8717497775622857}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0., 0.4511193002007417}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["d", 
       Scaled[{0.02, 0.02}, {0., 0.4511193002007417}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.24968283153748527`, 0.006335710518021792}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["e", 
       Scaled[{0.02, 0.02}, {0.24968283153748527`, 0.006335710518021792}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.7396393450752398, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["f", 
       Scaled[{0.02, 0.02}, {0.7396393450752398, 0.}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.49697112288771217`, 0.20939209302417858`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["i", 
       Scaled[{0.02, 0.02}, {0.49697112288771217`, 0.20939209302417858`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.7004880139971662, 0.5513370922968581}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["k", 
       Scaled[{0.02, 0.02}, {0.7004880139971662, 0.5513370922968581}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.30259259046343634`, 0.5560805490300901}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["h", 
       Scaled[{0.02, 0.02}, {0.30259259046343634`, 0.5560805490300901}], \
{-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->1,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->{216., Automatic},
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{-0.05, 1.05}, {-0.05, 0.9217497775622857}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{220, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->600855100]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell["", "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1055170939],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToCombinatoricaGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 31.1172228}", "context" -> 
    "GraphUtilities`", "keywords" -> {}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "ToCombinatoricaGraph[g] returns the Combinatorica representation of the \
graph g. ToCombinatoricaGraph[g, n] returns the graph g, adding additional \
unconnected vertices, if necessary, to create a graph with n vertices.", 
    "synonyms" -> {}, "title" -> "ToCombinatoricaGraph", "type" -> "Symbol", 
    "uri" -> "GraphUtilities/ref/ToCombinatoricaGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4159, 141, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->642515223]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52043, 1437}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1267, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1890, 60, 63, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1956, 63, 1047, 33, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3040, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3518, 118, 72, 1, 70, "Notes",
 CellID->213763687],
Cell[3593, 121, 529, 15, 70, "3ColumnTableMod",
 CellID->464392908]
}, Closed]],
Cell[CellGroupData[{
Cell[4159, 141, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->642515223],
Cell[CellGroupData[{
Cell[4544, 155, 148, 5, 70, "ExampleSection",
 CellID->272091007],
Cell[4695, 162, 139, 4, 70, "Input",
 CellID->137747066],
Cell[4837, 168, 66, 1, 70, "ExampleText",
 CellID->8213],
Cell[4906, 171, 765, 21, 70, "Input",
 CellID->23992],
Cell[5674, 194, 138, 6, 70, "ExampleText",
 CellID->1368998428],
Cell[CellGroupData[{
Cell[5837, 204, 147, 4, 70, "Input",
 CellID->2670],
Cell[5987, 210, 5750, 167, 286, "Output",
 CellID->2122045034]
}, Open  ]],
Cell[11752, 380, 143, 4, 70, "ExampleText",
 CellID->5097],
Cell[CellGroupData[{
Cell[11920, 388, 172, 5, 70, "Input",
 CellID->6704],
Cell[12095, 395, 6552, 189, 381, "Output",
 CellID->226690737]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18696, 590, 218, 7, 70, "ExampleSection",
 CellID->28027],
Cell[CellGroupData[{
Cell[18939, 601, 222, 7, 70, "ExampleSubsection",
 CellID->4084],
Cell[19164, 610, 67, 1, 70, "ExampleText",
 CellID->32604],
Cell[19234, 613, 138, 4, 70, "Input",
 CellID->11846408],
Cell[19375, 619, 769, 21, 70, "Input",
 CellID->237550193],
Cell[20147, 642, 310, 11, 70, "ExampleText",
 CellID->1209279200],
Cell[CellGroupData[{
Cell[20482, 657, 346, 11, 70, "Input",
 CellID->27489],
Cell[20831, 670, 8826, 149, 70, "Output",
 Evaluatable->False,
 CellID->200909843]
}, Open  ]],
Cell[29672, 822, 113, 3, 70, "ExampleText",
 CellID->683885067],
Cell[CellGroupData[{
Cell[29810, 829, 229, 7, 70, "Input",
 CellID->1128541062],
Cell[30042, 838, 4743, 82, 70, "Output",
 Evaluatable->False,
 CellID->216309954]
}, Open  ]],
Cell[34800, 923, 126, 3, 70, "ExampleDelimiter",
 CellID->1046272759],
Cell[34929, 928, 138, 6, 70, "ExampleText",
 CellID->1160513182],
Cell[35070, 936, 140, 4, 70, "Input",
 CellID->1184580375],
Cell[CellGroupData[{
Cell[35235, 944, 153, 5, 70, "Input",
 CellID->2131783975],
Cell[35391, 951, 596, 15, 36, "Output",
 CellID->601141226]
}, Open  ]],
Cell[36002, 969, 337, 12, 70, "ExampleText",
 CellID->677366046],
Cell[CellGroupData[{
Cell[36364, 985, 276, 9, 70, "Input",
 CellID->2035749510],
Cell[36643, 996, 931, 19, 70, "Output",
 Evaluatable->False,
 CellID->369662056]
}, Open  ]],
Cell[37589, 1018, 68, 1, 70, "ExampleText",
 CellID->786998624],
Cell[CellGroupData[{
Cell[37682, 1023, 178, 5, 70, "Input",
 CellID->1506746652],
Cell[37863, 1030, 825, 18, 70, "Output",
 Evaluatable->False,
 CellID->4404535]
}, Open  ]],
Cell[38703, 1051, 160, 5, 70, "ExampleText",
 CellID->179275190],
Cell[CellGroupData[{
Cell[38888, 1060, 249, 7, 70, "Input",
 CellID->1034168238],
Cell[39140, 1069, 2901, 52, 70, "Output",
 Evaluatable->False,
 CellID->209836075]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[42102, 1128, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[42336, 1137, 138, 4, 70, "Input",
 CellID->28524324],
Cell[42477, 1143, 137, 4, 70, "ExampleText",
 CellID->9161],
Cell[42617, 1149, 763, 21, 70, "Input",
 CellID->750],
Cell[CellGroupData[{
Cell[43405, 1174, 172, 5, 70, "Input",
 CellID->25205],
Cell[43580, 1181, 5749, 167, 237, "Output",
 CellID->600855100]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49390, 1355, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[49709, 1366, 39, 1, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[49785, 1372, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[50106, 1383, 167, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[50310, 1391, 320, 9, 70, "MoreAboutSection",
 CellID->1055170939],
Cell[50633, 1402, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[50822, 1409, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

