(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15742,        534]
NotebookOptionsPosition[     12130,        412]
NotebookOutlinePosition[     13522,        451]
CellTagsIndexPosition[     13437,        446]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StrongComponents" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/StrongComponents"], "Bicomponents" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/Bicomponents"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"StrongComponents\"\>", 
       2->"\<\"Bicomponents\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WeakComponents", "ObjectName",
 CellID->23606],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"WeakComponents", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all weakly connected components in the \
undirected graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A weakly connected component of a directed graph is a set of vertices such \
that for each pair of vertices, there is a path between them. The graph ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is considered as undirected."
}], "Notes",
 CellID->31150]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->540503875],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->506160203],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->2831402],

Cell["\<\
This shows that the following graph has 2 weakly connected components:\
\>", "ExampleText",
 CellID->757987577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeakComponents", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->568495616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1146030650]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28676],

Cell["This defines a small graph:", "ExampleText",
 CellID->308056619],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1551074621],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "5"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1871055241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->521794200],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWF9QlFUUv+63/F0KRJgsErfgwVEffPDBB2f0qZxxUhtfnEZnIEFhnEYC
S4oIhUYsJygGnaISxv5gasmoEzVjMpMz8RATD1mMCYGhbsDasiy7H7Dh9jv3
7vLdveyyC9FIyXxc7r3nd8/9nXPvPfdcnsk9UJD/Qu6Bwt251qeLc4sKCneX
WJ/aX4wubRFj7BJ+dy5lqPtQ47+XfD78lctEKrWJkXbPwMe6/QtmoULzDHzk
9fxKouVcrg+d0+1nJbmtwTfpNuRu2wfol8ef8vEflsnlk1672/a+IdeHTo/9
2UqiRImF+07l6K0K3V5PqHqmuW4WjzkuG7M4e/Z6Bt425M7uvMmJIWmWiSvO
7nxDDrCze58xftzR5LpZYsgxmft2jcrC80f1+DDodzALFaL9naFl5Ld9mMiQ
83YwC3QZct5+UWIxfAoqDTlvNzxoLIR+l82mOxxUTb1/rMxTrMDF1NvWxhI6
GxvbKirwfVNS8vn27Q1r176VlvZGfPy3ZWUsBd0cpdk6OwVhlhQVWw2FhmMY
E4G1CYV5CheevcmvLzZgha39uXes1qMpKaamjRtZbEtOzpQVzVu3nli92gQb
FhN/kmvvrVnj5y9mogjh6+DKorLHHHKUYdcSKsxY4w/XrcOk/e3t8YqlmqSB
hbBYaOg6f/70tm3ttbVDXV1xig9U5lpgn939ucDR2+vnjKnD7LPQNszZ8jPP
Zh1C93IqJDtD4yGvyUgiaCbHR2FVmDMcvGPmbd0ul5beaG316rq6bqH5Keum
4ZBcra6G71m8smqEN8k7d/DHXMyEBaORJlQTQlgo75TYebFUPXmR7FJPYEj9
scKeTzZtwmHEwtKZ4+fx+MqVaOJ7MzW1Ljv75Pr1/BzG4ByKfv9pNMvemXcb
uSfNBj5ynIm0G00cj22CBafAmExFzIX8/NrMzOYtW66Ul1+/eJFvBxaDmCky
gznZGrRvZrAxGBdlBJUsSuM4ETKoGj8vUeP/eZP/91i4b1dMyzPvfmVocXbv
mZZnjtuCWKBLyTMLjfFjjpNQGZRnjt46prLwei7oQ+8GaUGaLNvShH5JPljj
342CBQzU7cdJlMTlIqGW5JPf64OSFbq9bsL1g8Fi+ltgtmV0bwev+5rX/Qs+
ZqEC+A4/z0J5TSLl/t15rt9fGu0vZRYqNOeN5/1rImuZ+/56ULTIGZcR22cf
SeemXcRR3AFI5pAR+uPsbO6m0PPONh+b93mC7EP6gswJ379v3wx3vBb1qoVj
NfOumL7O0eyOaN4/gZwgOq0L6XT9Ey2RbqWRnoIJ52dedwvF0RZq7w2hJdKt
4r5TNdp/kEJoEo+j4t84JCrgWh7hKPHiouoTvI23AHJZZHjsZY5aynsBAZCq
Vt4+t2PHT83NVJVROO14/9FYwQDvAbSpepCjHuW9XxcVISb4pm4vpI4iVQxC
gQeSZZRsGW9/unkzkmqqlnLUY7wXiqCOqhm8jVc7zj/e9OwVCQVG4IFJRNuM
UwtUpdmMtE/gMhRfCA54hJ5YterLXbvYqxz1uOIL2TdktYwyfKH6uYyjlim+
SA8whdWYl70moUCzfsUK8kW6YrVAZSq9S5SVLOcosSZQ7/e2eB+35OTAXVSV
UfAQHjXgzBYHrMFAqr5uoMxI8+uyKOqCYIqiXcYJ/sBdO3MmmeMwJSamagXH
WQN2HktPb9ywgT0c8AYsILsPcZTYocN9fUeTk6n3IcWHAvUk77165IjfGxbe
xoMTHMgbhzkqS+GbqKytjIKdeL1RNUHyDlUrOSpbGRun7LoqCWXwiFNWrUpi
P9KzZ/j6TnzMQgVyoJx7IgIcllFho81CQYW7nUKjI73J7/+ocDlSePRMd2fo
UeHuxIWypjOhXH37g/btSHfevb+GDZR4TbBFfwMzhVU6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->235094800]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StrongComponents",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/StrongComponents"]], 
  "InlineFormula"],
 " finds connected components of a directed graph:"
}], "ExampleText",
 CellID->1666203828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StrongComponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->879673641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1144706364]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["WeakComponents"], "InlineFormula"],
 " finds connected components, assuming that the graph is undirected:"
}], "ExampleText",
 CellID->437057316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeakComponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1866246551],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1237832169]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9404],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StrongComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/StrongComponents"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bicomponents",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/Bicomponents"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1349309956]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9003],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->17784]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->803459232],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WeakComponents - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 31.7266134}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "connected components graph components weakly connected components \
connected graph block diagonal matrices"}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "WeakComponents[g] gives a list of all weakly connected components in the \
undirected graph g.", "synonyms" -> {}, "title" -> "WeakComponents", "type" -> 
    "Symbol", "uri" -> "GraphUtilities/ref/WeakComponents"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4010, 131, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->540503875]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13294, 439}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1987, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2610, 78, 52, 1, 70, "ObjectName",
 CellID->23606],
Cell[2665, 81, 505, 16, 70, "Usage",
 CellID->22]
}, Open  ]],
Cell[CellGroupData[{
Cell[3207, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3685, 119, 288, 7, 70, "Notes",
 CellID->31150]
}, Closed]],
Cell[CellGroupData[{
Cell[4010, 131, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->540503875],
Cell[CellGroupData[{
Cell[4395, 145, 148, 5, 70, "ExampleSection",
 CellID->506160203],
Cell[4546, 152, 137, 4, 70, "Input",
 CellID->2831402],
Cell[4686, 158, 121, 3, 70, "ExampleText",
 CellID->757987577],
Cell[CellGroupData[{
Cell[4832, 165, 219, 7, 28, "Input",
 CellID->568495616],
Cell[5054, 174, 303, 11, 36, "Output",
 CellID->1146030650]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5406, 191, 233, 7, 70, "ExampleSection",
 CellID->28676],
Cell[5642, 200, 70, 1, 70, "ExampleText",
 CellID->308056619],
Cell[5715, 203, 140, 4, 70, "Input",
 CellID->1551074621],
Cell[5858, 209, 434, 13, 70, "Input",
 CellID->1871055241],
Cell[CellGroupData[{
Cell[6317, 226, 229, 6, 70, "Input",
 CellID->521794200],
Cell[6549, 234, 2147, 39, 70, "Output",
 Evaluatable->False,
 CellID->235094800]
}, Open  ]],
Cell[8711, 276, 260, 8, 70, "ExampleText",
 CellID->1666203828],
Cell[CellGroupData[{
Cell[8996, 288, 112, 3, 70, "Input",
 CellID->879673641],
Cell[9111, 293, 381, 13, 36, "Output",
 CellID->1144706364]
}, Open  ]],
Cell[9507, 309, 176, 4, 70, "ExampleText",
 CellID->437057316],
Cell[CellGroupData[{
Cell[9708, 317, 111, 3, 70, "Input",
 CellID->1866246551],
Cell[9822, 322, 333, 11, 36, "Output",
 CellID->1237832169]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10216, 340, 310, 9, 70, "SeeAlsoSection",
 CellID->9404],
Cell[10529, 351, 510, 17, 70, "SeeAlso",
 CellID->1349309956]
}, Open  ]],
Cell[CellGroupData[{
Cell[11076, 373, 313, 9, 70, "TutorialsSection",
 CellID->9003],
Cell[11392, 384, 163, 3, 70, "Tutorials",
 CellID->17784]
}, Open  ]],
Cell[CellGroupData[{
Cell[11592, 392, 319, 9, 70, "MoreAboutSection",
 CellID->803459232],
Cell[11914, 403, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[12103, 410, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

