(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    714197,      20150]
NotebookOptionsPosition[    626967,      17094]
NotebookOutlinePosition[    655245,      18015]
CellTagsIndexPosition[    654460,      17984]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AdjacencyMatrix" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/AdjacencyMatrix"], "Bicomponents" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/Bicomponents"], 
         "ClosenessCentrality" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/ClosenessCentrality"], 
         "CommunityModularity" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/CommunityModularity"], 
         "CommunityStructureAssignment" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/CommunityStructureAssignment"], 
         "CommunityStructurePartition" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/CommunityStructurePartition"], 
         "EdgeList" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/EdgeList"], 
         "ExpressionTreePlot" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/ExpressionTreePlot"], "GraphCoordinates" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/GraphCoordinates"], "GraphCoordinates3D" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/GraphCoordinates3D"], "GraphDistance" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/GraphDistance"], 
         "GraphDistanceMatrix" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/GraphDistanceMatrix"], "GraphEdit" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/GraphEdit"], 
         "GraphPath" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/GraphPath"], 
         "LineScaledCoordinate" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/LineScaledCoordinate"], "LinkRankMatrix" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/LinkRankMatrix"],
          "LinkRanks" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/LinkRanks"], 
         "MaximalBipartiteMatching" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/MaximalBipartiteMatching"], 
         "MaximalIndependentEdgeSet" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"], 
         "MaximalIndependentVertexSet" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/MaximalIndependentVertexSet"], "MinCut" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/MinCut"], 
         "MinimumBandwidthOrdering" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/MinimumBandwidthOrdering"], "PageRanks" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/PageRanks"], 
         "PageRankVector" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/PageRankVector"],
          "PseudoDiameter" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/PseudoDiameter"],
          "SparseArray" :> Documentation`HelpLookup["paclet:ref/SparseArray"],
          "StrongComponents" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/StrongComponents"], 
         "ToCombinatoricaGraph" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/ToCombinatoricaGraph"], "VertexList" :> 
         Documentation`HelpLookup["paclet:GraphUtilities/ref/VertexList"], 
         "WeakComponents" :> 
         Documentation`HelpLookup[
          "paclet:GraphUtilities/ref/WeakComponents"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"AdjacencyMatrix\"\>", 2->"\<\"Bicomponents\"\>", 
      3->"\<\"ClosenessCentrality\"\>", 4->"\<\"CommunityModularity\"\>", 
      5->"\<\"CommunityStructureAssignment\"\>", 
      6->"\<\"CommunityStructurePartition\"\>", 7->"\<\"EdgeList\"\>", 
      8->"\<\"ExpressionTreePlot\"\>", 9->"\<\"GraphCoordinates\"\>", 
      10->"\<\"GraphCoordinates3D\"\>", 11->"\<\"GraphDistance\"\>", 
      12->"\<\"GraphDistanceMatrix\"\>", 13->"\<\"GraphEdit\"\>", 
      14->"\<\"GraphPath\"\>", 15->"\<\"LineScaledCoordinate\"\>", 
      16->"\<\"LinkRankMatrix\"\>", 17->"\<\"LinkRanks\"\>", 
      18->"\<\"MaximalBipartiteMatching\"\>", 
      19->"\<\"MaximalIndependentEdgeSet\"\>", 
      20->"\<\"MaximalIndependentVertexSet\"\>", 21->"\<\"MinCut\"\>", 
      22->"\<\"MinimumBandwidthOrdering\"\>", 23->"\<\"PageRanks\"\>", 
      24->"\<\"PageRankVector\"\>", 25->"\<\"PseudoDiameter\"\>", 
      26->"\<\"SparseArray\"\>", 27->"\<\"StrongComponents\"\>", 
      28->"\<\"ToCombinatoricaGraph\"\>", 29->"\<\"VertexList\"\>", 
      30->"\<\"WeakComponents\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Graph Utilities Package", "Title",
 CellTags->{"introduction", "i:2", "b:0.0"},
 CellID->251542051],

Cell[TextData[{
 "The ",
 ButtonBox["Graph Utilities Package",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/guide/GraphUtilitiesPackage"],
 " contains a number of functions useful for graph theory applications."
}], "Text",
 CellTags->"b:0.0",
 CellID->29196500],

Cell[BoxData[GridBox[{
   {
    ButtonBox["AdjacencyMatrix",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/AdjacencyMatrix"], 
    ButtonBox["LinkRanks",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/LinkRanks"]},
   {
    ButtonBox["Bicomponents",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Bicomponents"], 
    ButtonBox["LinkRankMatrix",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/LinkRankMatrix"]},
   {
    ButtonBox["ClosenessCentrality",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/ClosenessCentrality"], 
    ButtonBox["MaximalBipartiteMatching",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/MaximalBipartiteMatching"]},
   {
    ButtonBox["CommunityModularity",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/CommunityModularity"], 
    ButtonBox["MaximalIndependentEdgeSet",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"]},
   {
    ButtonBox["CommunityStructureAssignment",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/CommunityStructureAssignment"], 
    ButtonBox["MaximalIndependentVertexSet",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentVertexSet"]},
   {
    ButtonBox["CommunityStructurePartition",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/CommunityStructurePartition"], 
    ButtonBox["MinCut",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/MinCut"]},
   {
    ButtonBox["EdgeList",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/EdgeList"], 
    ButtonBox["MinimumBandwidthOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/MinimumBandwidthOrdering"]},
   {
    ButtonBox["ExpressionTreePlot",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/ExpressionTreePlot"], 
    ButtonBox["PageRanks",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/PageRanks"]},
   {
    ButtonBox["GraphCoordinates",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"], 
    ButtonBox["PageRankVector",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/PageRankVector"]},
   {
    ButtonBox["GraphDistanceMatrix",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/GraphDistanceMatrix"], 
    ButtonBox["PseudoDiameter",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/PseudoDiameter"]},
   {
    ButtonBox["GraphCoordinates3D",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates3D"], 
    ButtonBox["StrongComponents",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/StrongComponents"]},
   {
    ButtonBox["GraphDistance",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/GraphDistance"], 
    ButtonBox["ToCombinatoricaGraph",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/ToCombinatoricaGraph"]},
   {
    ButtonBox["GraphEdit",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/GraphEdit"], 
    ButtonBox["VertexList",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/VertexList"]},
   {
    ButtonBox["GraphPath",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/GraphPath"], 
    ButtonBox["WeakComponents",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/WeakComponents"]},
   {
    ButtonBox["LineScaledCoordinate",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/LineScaledCoordinate"], ""}
  }]], "DefinitionBox",
 CellTags->"b:0.0",
 CellID->7208189],

Cell[TextData[StyleBox["Functions in the Graph Utilities Package.", "SR"]], \
"Caption",
 CellTags->{"S5.18.1", "b:0.0"},
 CellID->661590988],

Cell["This loads the package.", "Text",
 CellTags->"b:0.0",
 CellID->299465232],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1575856720],

Cell[TextData[{
 "A graph can be represented by a list of rules or its adjacency matrix. \
Graphs in the ",
 StyleBox[ButtonBox["Combinatorica",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/CombinatoricaPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/CombinatoricaPackage"],
 " format are also supported."
}], "Text",
 CellID->1082663905],

Cell[CellGroupData[{

Cell["AdjacencyMatrix", "Subsection",
 CellID->373855679],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox[
       ButtonBox[
        StyleBox["AdjacencyMatrix", "MR"],
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/AdjacencyMatrix"], "MR"], 
      StyleBox["[", "MR"], 
      StyleBox["g", "TI"], 
      StyleBox["]", "MR"]}], 
     RowBox[{"gives", " ", "the", " ", 
      ButtonBox["SparseArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SparseArray"], " ", "object", " ", 
      "representing", " ", "the", " ", "graph", " ", 
      StyleBox["g", "TI"]}]},
    {
     RowBox[{
      StyleBox[
       ButtonBox[
        StyleBox["AdjacencyMatrix", "MR"],
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/AdjacencyMatrix"], "MR"], 
      StyleBox["[", "MR"], 
      RowBox[{
       StyleBox["g", "TI"], ",", 
       StyleBox["n", "TI"]}], 
      StyleBox["]", "MR"]}], 
     RowBox[{
      RowBox[{"gives", " ", "the", " ", 
       ButtonBox["SparseArray",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SparseArray"], " ", "object", " ", 
       "representing", " ", "the", " ", "graph", " ", 
       StyleBox["g", "TI"]}], ",", 
      RowBox[{
      "adding", " ", "additional", " ", "unconnected", " ", "vertices"}], ",",
       
      RowBox[{"if", " ", "necessary"}], ",", 
      RowBox[{"to", " ", "create", " ", "a", " ", "graph", " ", "with", " ", 
       StyleBox["n", "TI"], 
       StyleBox[" ", "TI"], 
       RowBox[{"vertices", "."}]}]}]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.3",
 CellID->1428138794],

Cell["Finding the adjacency matrix of a graph", "Caption",
 CellTags->"b:0.3",
 CellID->2129440045],

Cell[TextData[{
 "Given a graph in any of the formats supported by the Graph Utilities \
Package, ",
 StyleBox[ButtonBox["AdjacencyMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/AdjacencyMatrix"],
  FontFamily->"Courier"],
 " returns a matrix representing this graph."
}], "Text",
 CellID->892515739],

Cell[TextData[{
 "The graph ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " can be specified by a rule list, an adjacency matrix, or the ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " representation of a graph."
}], "Text",
 CellID->1766108205],

Cell[TextData[{
 "The rows and columns of the ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object correspond to vertices in the order returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexList",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/VertexList"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->2041381805],

Cell[TextData[{
 "This shows the adjacency matrix of a small graph. The 2 on the diagonal \
represents the two loops at vertex 1.",
 " ",
 "The off-diagonal element 2 represents the two multiedges ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["b", "TI"], "\[Rule]", 
      StyleBox["a", "TI"]}], ",", 
     RowBox[{
      StyleBox["b", "TI"], "\[Rule]", 
      StyleBox["a", "TI"]}]}], "}"}], TraditionalForm]]],
 "."
}], "MathCaption",
 CellID->369538215],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->890134534],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", " ", "->", " ", "b"}], ",", " ", 
     RowBox[{"b", " ", "->", " ", "b"}], ",", " ", 
     RowBox[{"b", " ", "->", " ", "a"}], ",", " ", 
     RowBox[{"a", " ", "->", " ", "b"}], ",", " ", 
     RowBox[{"b", " ", "->", " ", "a"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1335543861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AdjacencyMatrix", "[", "g", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1258371864],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwaAGxjAQDkP0fyAJj
rf//gTSEZAWRzCBRMGCQRuOzgFWxoIkyAwlWIJcbSIOE2bHIY+pCt4sLLAjn
g/UwMLDR3CxmNFF0VdjNQvcj04g1CxT2TEAu739I7HMQpUt+VBVUFJSWQUHP
BaWJC3VwDsCIMUrjEZnPg8YnLl7RUxa6KcS5BV0VuinotkBMQS8VCJmCrRzD
XroRG9LElVYgPojL8x9feUlcWQwptxkYAbkjMz4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{42, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->215949771]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["i", "TI"], "th"], TraditionalForm]]],
 " row/column of the matrix represents the vertex ",
 StyleBox[ButtonBox["VertexList",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/VertexList"],
  FontFamily->"Courier"],
 StyleBox["[g][[i]]",
  FontFamily->"Courier"],
 ". That is, in the above matrix, the first row corresponds to vertex ",
 Cell[BoxData[
  FormBox[
   StyleBox["b", "TI"], TraditionalForm]], "InlineFormula"],
 ", the second to vertex ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1431420352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"Rule", "[", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{"Length", "[", 
      RowBox[{"VertexList", "[", "g", "]"}], "]"}], "]"}], ",", 
    RowBox[{"VertexList", "[", "g", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->483467941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "b"}], ",", 
   RowBox[{"2", "\[Rule]", "a"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->514531251]
}, Open  ]],

Cell["\<\
This converts a graph into a sparse matrix, with two additional unconnected \
vertices added. It basically pads the matrix above with two columns and rows \
of zeros.\
\>", "MathCaption",
 CellID->1884084651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AdjacencyMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"b", "\[Rule]", "b"}], ",", 
      RowBox[{"b", "\[Rule]", "b"}], ",", 
      RowBox[{"b", "\[Rule]", "a"}], ",", 
      RowBox[{"a", "\[Rule]", "b"}], ",", 
      RowBox[{"b", "\[Rule]", "a"}]}], "}"}], ",", " ", "4"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->213005718],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmL1ugzAQgA2U5n/vmNfo0rHN0odAUaVkqFolGdgYMzIy8giMjIyMjIyM
jIyM7tkG7FAoQamjSAEJ+7BOfL4729zxbhw2H5/GYbs2lm8743uzXe+Xr187
GNIUhNAK7ucnBDIGid4rjKEXW520muu6mF5Ig0YD1XlLP6JKlmUJ+gg9UDGO
Y9/3q1GdEMsLZDS9ePSxnG0URXW64zjinKTR8zw3TZPTtXKUTYDNRgKdef54
PAKKiGpFV8Mw1KVSIawQ3FMq9XiapvJt5utKpPM1KJcO7mbbo4VOPP/XjpmU
vir0lca3vNSe71frPH92vUXWmhgP9IF+o/T/2Tm3ei5cX4tEk4RidpE/WdZQ
RfRqq2HgDlxZp4wK2gt876eMbdtnaPHaStSCfDDLMiycMlPcfNqwqCRJ4nke
EcUsFNLiohKSmwMHQdCQ/4MBxZxYFcnX4rz2POtNBN+e1Dn1Gq+L2N9GHjdO
VMG7ow7SpAeJ7FkVfEatKWzgNtV3dJ007kn6VRMXRFa0VZZKq5Q5h9HbvqNl
v6Ba7L8EUn4ASTawIw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->416424262]
}, Open  ]],

Cell[TextData[{
 "This shows the adjacency matrix of a graph specified by a ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " object."
}], "MathCaption",
 CellID->194404505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AdjacencyMatrix", "[", 
   RowBox[{"GridGraph", "[", 
    RowBox[{"2", ",", "2"}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->181282149],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl71ugzAQgA2U/hCyd8xrdOnYZulDoKhSMlSt0gxsjIyMjDwCIyMjIyMj
IyMjo3v+ARtCWwYjRS1I2MfluM+c7YvvxTntX9+c02HnbJ6Pzsf+sPvcPL0f
QWVoCKEt3A/3CGQMEr23GEMvtyZpjSiKML2QAY0BpivoTegt3q+4/oYaeZ4n
2SN0RcWiKJIk6bTkNdxeICOb/tRpz56t0beu2xHmeT4khmEoj0MpsWka13UF
0Wi1DMpGoIjIour7Prgnot4R9SzLTOUkmCaYrD6JRrOqqnm+TawNmSjWkXoi
hJIt62+IJKoGZ+jQr6We6O/amHB7bdTL4+D5/1qRGZQzhY37meR2khe2936b
4XHtcHUsxIU4J5FkEDlj2LifUaxJXi51Py8Z5HJX3kL8G8Qlg7RWQRBMsBJ1
imwFZ7S6rtt4/lS9sFkpyzKOYyLKJ0M4nvIKQ/1ZNE3TkfM2DJqPQz0R4tmr
Jeasl4Y1oSDqEFGV30Z2qA4xoz557Sq+SVdMOosXJ7IiaR6i8M2I8n/hWJWy
plaslkfaF2avSok=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->766703840]
}, Open  ]],

Cell["Input in the form of a matrix is unchanged.", "MathCaption",
 CellID->1903738394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AdjacencyMatrix", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1171058613],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVMEKwjAMzdZVxU29CgruvA/Rkx9RhrAdxDH3/zNph8ijsrpdLbTpS9PX
NmlyNV11u5uuLk1+aU1T1eUzPz9aVqmIiAruxz3xvOeZ7UXfs3SjllGJ1jY6
AE6sVQJaxYNmmLIU9dKz7t9F+o2tDdHaq10EMSLejaw7FgVaPGsLGH0Ue1nQ
B+KbmOEqaDdaZZPukPzgYbyvn1HOFZgNMuw1p7/VR0T0EAMd7HX8kXMiiFwp
4LCIIgv+z2l32YysOxbMYswFzFd/1o+xzK1Dkuvynu/1MKzWurpM0Qt8miFQ
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{42, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->100869116]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bicomponents", "Subsection",
 CellID->1402613878],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox[
       ButtonBox[
        StyleBox["Bicomponents", "MR"],
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/Bicomponents"], "MR"], 
      StyleBox["[", "MR"], 
      StyleBox["g", "TI"], 
      StyleBox["]", "MR"]}], 
     RowBox[{
     "gives", " ", "the", " ", "biconnected", " ", "components", " ", "of", 
      " ", "the", " ", "undirected", " ", "graph", " ", 
      StyleBox["g", "TI"]}]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.9",
 CellID->1980534118],

Cell["Finding biconnected components.", "Caption",
 CellTags->"b:0.9",
 CellID->1986619578],

Cell[TextData[{
 StyleBox[ButtonBox["Bicomponents",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/Bicomponents"], "MR"],
 StyleBox["[", "MR"],
 StyleBox[Cell[BoxData[
  FormBox["g", TraditionalForm]], "TI"], "MR"],
 StyleBox["]", "MR"],
 " returns a list of all biconnected components in the undirected graph ",
 StyleBox["g", "TI"],
 ". "
}], "Text",
 CellTags->"b:0.9",
 CellID->1070093888],

Cell[TextData[{
 "A vertex ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 " is a ",
 StyleBox["cutpoint",
  FontSlant->"Italic"],
 " of a graph ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]]],
 " if ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]]],
 " is not connected after removing the vertex ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 " and all edges. A graph is ",
 StyleBox["biconnected",
  FontSlant->"Italic"],
 " if it has no cutpoint. A ",
 StyleBox["biconnected component",
  FontSlant->"Italic"],
 " (bicomponent) is a maximal subgraph that has no cutpoint."
}], "Text",
 CellTags->"b:0.9",
 CellID->2132406313],

Cell["\<\
This shows that a simple line with two vertices is biconnected.\
\>", "MathCaption",
 CellTags->"b:0.9",
 CellID->13970831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bicomponents", "[", 
  RowBox[{"{", 
   RowBox[{"1", "\[Rule]", "2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->555822098],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->36165324]
}, Open  ]],

Cell["\<\
This shows two cycles linked by a line. Each of the cycles forms a \
bicomponent. The line breaks into two bicomponents.\
\>", "MathCaption",
 CellTags->"b:0.9",
 CellID->7475551],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "15"}], ",", 
     RowBox[{"15", "\[Rule]", "7"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}], ",", 
     RowBox[{"10", "\[Rule]", "11"}], ",", 
     RowBox[{"11", "\[Rule]", "12"}], ",", 
     RowBox[{"12", "\[Rule]", "7"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1860757518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->4827],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWVtvG0UUnnrttakdxUEg9TGP8AsQL1CBaJ/gAQmpD0Vyeo0FVUOolEoN
BFVcxEOg4SJF5dJQREpFiwqqxBtBRQgeKhXBC82tKUlxEhvi9W0TG3s5Z2b2
Npn1rhMbUQnLmezumTnn+76dy5nxk30n+g8f6zuRPtjXu3ewb6A/ffDF3j3H
B+GRsoMQchX+HtxF4NqAK/p31TDg//1YKnruSz13Gb4kjoWy/tc3Bv2QNLVv
5Kdc9srqJLffR73QUjGM6/mb+/XceySBhQI3Li/a7JHKyiia4tSuzR6qb2Tk
XqAkCSwilpdGvazNHCJd8ADbprnvJ2ir4vwAPEdTHAtVm041qllWpTD/XL36
LfWm0Ots4JjQDlqwpwq9eQEb7KGtmF80xbFQLd//x5TGDEERhq6ntjU2BgiB
12ggDAotsP/D/7ZjiTi842U4EKaw0CpiYvr1woVbU1McE9bCShEfbKYeqolx
bf4GeIEvq+P244dNygixXdq3b2L3bo5NztsbY4hWsutzNIj2w4ceAL/wtd+u
pObWcbvecxtxS3plENw72fy7Olm6/XJp8TUSxUItLZ4EqFDCt7hw/NGHd4W2
zke1+MCnqn1fXBhKYBSluDCsZy8iANWc5QsLJ9GU5PZTevaSzB6nKC27xTos
9j2ZKhEL31cTj5cWh0gYWMKMPpMq/v4KOt7Jot8aMhpVDBx1KFXJvKqvjtXK
V0gci3BpaXgjf57QT7Q1TfLTx1hFcABuEugP3sRYZXnc5gwLVTnzOpqS1A43
eu4LmZ3iUS27X0+QqGOqB71kLl3VJu2ohbl+3mtcWiy/AdCt+chxH2tNiaVr
z1xJpYqZDDQHJ2z2o9dnTaYhINpDn8MF5ADO57S+aj3X19ZaZa7aY4OOs6Qw
VrbD2t0n2Vi4ce7cmd7ebbItL1+cGhkBP8H6fic5JtzjvKbr2+T23UuPADfr
TSY6w6m0NIKJYAwLP05snG6Hk7bwiRP7Zk7a3FHIT1Wam7bKKcRXVVXKrbJy
PhA3Vx+ScDTXbjZ0zY/qwVyaV9jjtIkSevZdPfeOqITCo4dcKP2UEWcdxe7R
17BqnNZv1H/QZg9j6p7AIlKYH3AKQ7zWUzCv/nwakhuiQoGs5fHEe6iYuT7q
bCfPwpxqwUps7j5mUo2/8wj8HsOdIYQ34RRXbqVtqnXj+zDYyowimf3QQ6df
Jp6GtIqoULSk00+jTzVrxxg7dUJc8Q7p4spuHXokaL1y5gPnPtUed/69SBhp
gdURxpw8o8R6q59WVj4iPXT/rGc/rxZ+tFh2QCexN4elo85w79jtOdihlz2r
eahko3W9mxa0WV/7uHh7ELWB+QYmzvKdtzqpjYBam07RUR3Rpg8Y/IOykC7D
tdZyTaTzhJc2Eac2Vo4q0carZ4KJx+0x4+Snn0V0SYq5tHjK2WjTLqP5asX0
Ylsmw1yZbcaiDpAPQFbA8UT42/bib65lYVc9+SqlNOPLZ7Zu4T74ChRrjSVk
dDbLLWUbLbCIdYIBvCe7v95NDMz5RtjJtYmJlT0pfLDgDOLuwS0zLC8NQ1qA
G9go3cUa/qc6LsaqbE60a63/OV6YT5ME9Q2BynfOmAzxFPZtAIWmJLXDTSVz
VmaPm3bH2CVRYW5yzSDujMLM+hSnvTB3FN3G+O79QKOWF9Wp16Zg/4pb2Cjd
xwZQhx1VBVMH7mqly6SL+a6X2TP0xdY2MKKpx8fOdv42YxGb9OzFUV/MDTzr
l5aGMVSMxqtVvuZ4mGK+p6XsWKyZMo4T98cMd14ocpLnM1vgxMfivZ4cnKet
wrjmXMwVIvqf5OA6X5Zid/pUg3AIkMP8uyzMtdwPvenFnYW3G2uwmbPLB2tS
wBbyxt4ES6ItsbvvlljC73YsFkvP0ZS0M/SR7cTSc+/zWPYvjSwWrBiVlTft
WHp2rFqYDBALViPr9EApzD3PvR6h9qr2mXbTzpqV/G/7y3+M217Yb6Fkxz8p
DnYM\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->117957185]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bicomponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1361541404],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "10", ",", "11", ",", "12", ",", "7"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "4", ",", "5", ",", "6", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{389, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->2112498302]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClosenessCentrality", "Subsection",
 CellID->482574400],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox[
       ButtonBox[
        StyleBox["ClosenessCentrality", "MR"],
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/ClosenessCentrality"], "MR"], 
      StyleBox["[", "MR"], 
      StyleBox["g", "TI"], 
      StyleBox["]", "MR"]}], Cell["finds the closeness centrality", "Text"]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.6",
 CellID->1826735472],

Cell["Finding the closeness centrality.", "Caption",
 CellTags->"b:0.6",
 CellID->1313057589],

Cell[TextData[{
 "The closeness centrality of a vertex ",
 StyleBox["u", "TI"],
 " is defined as the inverse of the sum of the distance from ",
 StyleBox["u", "TI"],
 " to all other vertices. The closeness centrality of a vertex in a \
disconnected graph is based on the closeness centrality of the component \
where this vertex belongs."
}], "Text",
 CellID->1002965610],

Cell["\<\
This calculates the closeness centrality of a grid graph, and plots the graph \
so that vertices of high centrality are red.\
\>", "MathCaption",
 CellID->553769720],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"GridGraph", "[", 
    RowBox[{"14", ",", "10"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cs", "=", 
   RowBox[{"ClosenessCentrality", "[", "g", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "=", 
   RowBox[{"0.7", "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"cs", "/", 
       RowBox[{"Max", "[", "cs", "]"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "None"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"color", "[", 
          RowBox[{"[", "#3", "]"}], "]"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".2"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[10]:=",
 CellID->379950264],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->474507301]
}, Open  ]],

Cell["\<\
If a vertex does not have any paths to reach other vertices, the centrality \
of that vertices is zero.\
\>", "MathCaption",
 CellID->221466777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClosenessCentrality", "[", 
  RowBox[{"{", 
   RowBox[{"1", "\[Rule]", "2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->785949058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->431436644]
}, Open  ]],

Cell["\<\
Centrality of a disconnected graph is calculated by treating each components \
separately.\
\>", "MathCaption",
 CellID->1705732766],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", " ", "\[Rule]", " ", "2"}], ",", " ", 
     RowBox[{"3", " ", "\[Rule]", " ", "4"}], ",", " ", 
     RowBox[{"4", " ", "\[Rule]", " ", "3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->2054312142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->1876367756],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVl11oVFcQx4977252kwVDCW0eQ6vVBx/yoFEQWvtiBClIW1TqB0lDIakW
QwwoTanF2katYCmiEpX4iYItKqTEaEtAKXkwkhYf0lQxD5FEKHSTmnSb+LD9
nZm7d29WMZtNattwc3LPOTPz/8/cmTknb1Y31r7/YXVjXU11WWVDdX1tXc32
spXbGlhy5hhj2vhdXmp4T/Emv22pFH+fHN+wozvQ1fX9zp3Hly3rvXRpm6wX
2tEZG2oZ7tvIY+J2cMaHO1PyY14SvaGenv7OTp47589HOnftMu53W7acqaw8
tHDhbtcNfQqyw8sPTU12c6lI9LS2qg6gpYLy+FHPSN9mC1AkKMO/bBx9cMBu
FQa4/PmweXz4dCrVbYrsoPMbdqvYDhHMwR6Iq/X1J1esOFpeLvguL0x5vlm/
XjlC5+K6dS2LF+8vKfE5Xt+xI8PxclWV6hASkYjgEdO22lr2cRYwQSUipyGS
YSXzlty5y3480d9/t70d02dXrQIJRIAvrFnDStfBg8SKQAueiyQBxBXkXxPd
33p7Ebh15AjCrKOI+ldlZZhihZAgUDgrXCN2iOE6nEA6UFrqw8AGGFMlEr43
eIA3e4uLebnZ3Iym2pgxk5AdotjDKgT2RKO4zXfnyzwaGvpAdpOJBM5rWiOA
mFII5c8gxvzh7dYgKPbx9XEyaRoElTfmQVRFiueE4oqUrddUtz8Ps3+9cWUG
6SPJBEVS6w5yVi2SP0ogup9kRSicJe/khEKcu12Uwv+Y9bSWSXvusv/j3nep
BZLxY9HgRaHEy1DOMXKC0lHW73d8SfWTzqQ9ya8YjVargBemWhEIeHjZfrnT
x437UeOHxCa9fQ6UFGVIPm+1FopoEEEOiGktsOnxieQV56lyJSwVDxC1RgFq
1tMpyVb6lK3490QCfhBilT0aAk3Zp6g2AhkRmlY2Z/eGmHRFqoOuSKXSyrUl
Aqkdlaphiyb1uliCGcRZNC+IJozY1gbm91OUecccWzSW2Kx0sbnSMcDXc4te
QXBoqeARxBATEwaVLX0Il6mAgCm419HxRTyOHM+xigoO3Z9OnTJhuxdWY/rg
vBE7UWKOLMnBTFu2nmJzZ8WTF9Mdyb8NOPYcdWCv56hZYocCnzTPZ5EIdAis
ccVT/Tj6kDomZL1xCLZ34yiZBtOxwd2T7i1//d7uWXlbkpaK1VNJy9jMF62J
Py6M/Lo5ozU6sMfTivm2iVf3Wr21JJPe7gJvPR64Vz2fUb0dHWjyvNX7E06M
J64Fem3iRJZf+57w61lfN7tj55cj/38ruZ5o6dM4nHPHD55k2dZfldqiS9Du
yVha6DtZeE/v0Xl39p9PNtjifTl9nz+3evXhRYsoXUfuyldqarRIzVtS4zPl
8fTzP8PjFUHR/yu+njfPKItvN2x4Piy8r7BA5DkVOCv4BGZ2voHcYtyM1tS5
lR/OpFvFFJmb+x3pv1Sb/76VscHP+cc10IX7Nk2MdGWsTIycY2nSf7ljg0cz
VrSjmzl/A4lyYp8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->12679231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClosenessCentrality", "[", "g", "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->875835504],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.`", ",", "1.`", ",", "1.`"}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->52236985]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options for ClosenessCentrality", "Subsubsection",
 CellTags->"b:0.10b",
 CellID->1503268465],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Weighted",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Weighted"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether edge weight is used in calculating shortest path", 
     "TableText"]},
   {"Normalize", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to normalize the output", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.10b",
 CellID->486873165],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["ClosenessCentrality",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/ClosenessCentrality"]], 
  "InlineFormula"],
 StyleBox[".", "MR"]
}], "Caption",
 CellTags->"b:0.10b",
 CellID->820011780],

Cell[CellGroupData[{

Cell["Weighted", "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->359255388],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Weighted",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/Weighted"]], "InlineFormula"],
 " option specifies whether edge weights are to be taken into account when \
calculating distances. Possible values are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " (the default) or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weighted",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/Weighted"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " means that edges are assumed to have unit length."
}], "Text",
 CellID->99819372],

Cell[TextData[{
 "This shows a complete graph of three vertices, with one of the edges ",
 Cell[BoxData[
  RowBox[{"2", "\[Rule]", "3"}]], "InlineFormula"],
 " repeated twice, thus having an edge weight of ",
 Cell[BoxData["2"], "InlineFormula"],
 ". This reduces the centrality of vertex ",
 Cell[BoxData["2"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->736601936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClosenessCentrality", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "1"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", " ", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "2"}], ",", " ", 
    RowBox[{"3", "\[Rule]", "1"}], ",", " ", 
    RowBox[{"1", "\[Rule]", "3"}]}], " ", "}"}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->1411225982],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5`", ",", "0.3333333333333333`", ",", "0.5`"}], "}"}]], "Output",\

 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->1685772583]
}, Open  ]],

Cell[TextData[{
 "If it is intended that edge weights should all be one, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weighted",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/Weighted"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " should be specified."
}], "MathCaption",
 CellID->658232194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClosenessCentrality", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", " ", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", " ", 
     RowBox[{"3", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"1", "\[Rule]", "3"}]}], " ", "}"}], ",", 
   RowBox[{"Weighted", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->455414291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->1009931818]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Normalize", "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->1187208504],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Normalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normalize"]], "InlineFormula"],
 " option specifies whether the output is normalized to give a maximal \
centrality of 1. Possible values are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " (the default)."
}], "Text",
 CellID->1285773581],

Cell[TextData[{
 "This calculates the closeness centrality of a complete graph of three \
vertices. Since the sum of the distance from any vertex to others are ",
 Cell[BoxData["2"], "InlineFormula"],
 ", the closeness for each vertex is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "/", "2"}], " ", "=", " ", "0.5"}], TraditionalForm]]],
 "."
}], "MathCaption",
 CellID->435553136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClosenessCentrality", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "1"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "2"}], ",", " ", 
    RowBox[{"3", "\[Rule]", "1"}], ",", " ", 
    RowBox[{"1", "\[Rule]", "3"}]}], " ", "}"}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->1167510304],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->14000874]
}, Open  ]],

Cell["This normalizes the output.", "MathCaption",
 CellID->2004240014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClosenessCentrality", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", " ", "->", " ", "2"}], ",", " ", 
     RowBox[{"2", " ", "->", " ", "1"}], ",", " ", 
     RowBox[{"2", " ", "->", " ", "3"}], ",", " ", 
     RowBox[{"3", " ", "->", " ", "2"}], ",", " ", 
     RowBox[{"3", " ", "->", " ", "1"}], ",", " ", 
     RowBox[{"1", " ", "->", " ", "3"}]}], " ", "}"}], ",", 
   RowBox[{"Normalize", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->576872081],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->166828105]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
CommunityModularity, CommunityStructureAssignment, and \
CommunityStructurePartition\
\>", "Subsection",
 CellID->1878445495],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox[
       ButtonBox[
        StyleBox["CommunityStructurePartition", "MR"],
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/CommunityStructurePartition"], 
       "MR"], 
      StyleBox["[", "MR"], 
      StyleBox["g", "TI"], 
      StyleBox["]", "MR"]}], Cell[TextData[StyleBox[
     "gives the partition of a graph g into communities",
      FontFamily->"Verdana",
      FontSize->10]], "Text"]},
    {
     RowBox[{
      RowBox[{
       StyleBox[
        ButtonBox[
         StyleBox["CommunityStructureAssignment", "MR"],
         BaseStyle->"Link",
         ButtonData->
          "paclet:GraphUtilities/ref/CommunityStructureAssignment"], "MR"], 
       StyleBox["[", "MR"], 
       StyleBox["g", "TI"], 
       StyleBox["]", "MR"]}], " "}], Cell[TextData[{
      StyleBox["gives the assignment of the vertices of a graph ",
       FontFamily->"Verdana",
       FontSize->10],
      StyleBox["g", "TI",
       FontFamily->"Verdana",
       FontSize->10],
      StyleBox[" into communities",
       FontFamily->"Verdana",
       FontSize->10]
     }], "Text"]},
    {
     StyleBox[
      RowBox[{
       ButtonBox["CommunityModularity",
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/CommunityModularity"], "[", 
       Cell[TextData[{
        Cell[BoxData[
         StyleBox["g", "TI"]], "InlineFormula"],
        ", ",
        Cell[BoxData[
         StyleBox["partition", "TI"]], "InlineFormula"]
       }], "InlineFormula"], "]"}],
      FontFamily->"Courier"], 
     StyleBox[
      RowBox[{
      "gives", " ", "the", " ", "community", " ", "modularity", " ", "of", 
       " ", "a", " ", "partition"}],
      FontSize->10]},
    {
     RowBox[{
      StyleBox[
       ButtonBox[
        StyleBox["CommunityModularity",
         FontFamily->"Courier"],
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/CommunityModularity"],
       FontFamily->"Courier"], 
      StyleBox["[",
       FontFamily->"Courier"], 
      StyleBox[
       RowBox[{
        StyleBox["g", "TI"], ",", " ", "assignment"}],
       FontFamily->"Times"], 
      StyleBox["]",
       FontFamily->"Courier"]}], 
     StyleBox[
      RowBox[{
      "gives", " ", "the", " ", "community", " ", "modularity", " ", "of", 
       " ", "an", " ", "assignment"}],
      FontSize->10]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.1",
 CellID->1741365842],

Cell["Functions for finding and assessing community structure.", "Caption",
 CellTags->"b:0.11",
 CellID->404990997],

Cell[TextData[{
 StyleBox[ButtonBox["CommunityStructurePartition",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/CommunityStructurePartition"],
  FontFamily->"Courier"],
 " gives the partition of a graph into communities. The partition groups the \
vertices into communities, such that there is a higher density of edges \
within communities than between them. ",
 StyleBox[ButtonBox["CommunityStructureAssignment",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/CommunityStructureAssignment"],
  FontFamily->"Courier"],
 " gives the result as an assignment."
}], "Text",
 CellTags->"b:0.11",
 CellID->1615003150],

Cell["This defines a small graph.", "MathCaption",
 CellTags->"b:0.11",
 CellID->634919226],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[29]:=",
 CellID->1560725629],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{3.2344376352542517`, 0.}, {3.2337572982769833`, 
    0.7354540285242009}, {2.289055570457574, 0.3670604166963666}, {
    0.946294410665218, 0.3673034198452409}, {0., 0.734810413422331}, {
    0.0004080373007797622, 0.0002951182638846195}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {3, 1}, {3, 4}, {4, 5}, {5, 6}, {6, 4}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{3.2344376352542517`, 0.}, {3.2337572982769833`,
      0.7354540285242009}, {2.289055570457574, 0.3670604166963666}, {
     0.946294410665218, 0.3673034198452409}, {0., 0.734810413422331}, {
     0.0004080373007797622, 0.0002951182638846195}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{364, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->700239298]
}, Open  ]],

Cell["This find the partition of the graph into communities.", "MathCaption",
 CellID->1557311951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommunityStructurePartition", "[", "g", "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->305700368],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->1465366925]
}, Open  ]],

Cell["This shows the assignment of vertices into communities.", "MathCaption",
 CellID->59425543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cs", " ", "=", " ", 
  RowBox[{"CommunityStructureAssignment", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[34]:=",
 CellID->1285886019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "2"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->194891590]
}, Open  ]],

Cell["This shows which vertices are assigned into which community.", \
"MathCaption",
 CellID->728851723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"Rule", "[", 
   RowBox[{
    RowBox[{"VertexList", "[", "g", "]"}], ",", "cs"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[33]:=",
 CellID->1752928821],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "1"}], ",", 
   RowBox[{"2", "\[Rule]", "1"}], ",", 
   RowBox[{"3", "\[Rule]", "1"}], ",", 
   RowBox[{"4", "\[Rule]", "2"}], ",", 
   RowBox[{"5", "\[Rule]", "2"}], ",", 
   RowBox[{"6", "\[Rule]", "2"}]}], "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->1749539767]
}, Open  ]],

Cell["\<\
This plots the graph, with each community colored differently.\
\>", "MathCaption",
 CellID->1237320986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Framed", "[", 
          RowBox[{"#2", ",", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"Hue", "[", 
             RowBox[{
              RowBox[{"cs", "[", 
               RowBox[{"[", "#3", "]"}], "]"}], "/", "4"}], "]"}]}], ",", 
           RowBox[{"FrameStyle", "\[Rule]", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"0.94", ",", "0.85", ",", "0.36"}], "]"}]}]}], "]"}], 
         ",", "#1"}], "]"}], "}"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->1892274125],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWF9sU1UYP/Tc23bcPhAMYYi4GRIlmJj5YILEB4JReCFqfCFghGUQNxLd
wD00ThwvuhDF+UDYRCMm4ibKIg9NKkqyAIGZEDOCBhwkbUe3dW51t9BulzGW
+n3n3N5z713Xnq7Iw5bu673nO+f7fd93zvfndFttc/3ed2ubG+pqq7ccqG2q
b6h7v/rVxgMwRJcQQkLw/0IlgecsPLH/UDYL35wuRUrvTYTTgwcz8Y+JhoSm
Yy3301eQ9RHjPzAi6diHNv7tQ8ZYF7KW2qS0jv9wLPHlS5PXiYaEwouR/ElI
OZVae3Xo5a8mVxINCf1t7PmpkaNOKZ5gsidAcDY8GMkex+rLoxtbYZ6GBN+n
Ro8vptUKrPbABnmLSKFAKMxTC0qjKEUhuOFZ/MD8InIVJg8mwrd4X8zyqd3b
A2f2pxOJMqUqTJrQmumsAuP6qX2fVVae3r79z+5u8gGuUeJ9fWd27+ZIakko
qnlSmHS/5REQDQAAcy4Y1KPRZlzjA5sutrUdXbfu6w0b+k+c4HBMPjtrJZ1n
DxIvl/hFdTWXOGMYjTiu3gqHLfjxGzf47AXHjsoI9xHIDNXXJ/r7yT42CsYB
Boye3LoV/amWheRjVhm6fqWjo7OmBlwFD/C6h42DeWAkAIHBYDYY75NGYznw
amR/CDMnEnot0mSMnbRmqeAnsIyfDPCfuQqSL2ROUI9oSCgumZ1E1rOMPzXW
ZTD1Tf50qjfL/kiFUyr4Tkjt0Z8ejrz5V/wVoiGhkdg2yOZujdfMJDdnroks
viXTb2IHcv4Al8/1R8/Qp98PtQdRJyT04mDLPf0cstYz/jeZVYOR18PJ54iG
hF5KvJiOBQv5P8CrSpZ8d/dJLBgBVjVmjdt2W8lyNusQBhwbXVHghBwbPb4j
dQG3XyPm+3TqgtARAMAzYk/h3fQQP43R3l7HaVzJVoEjAA4fl+XVqNIZHb80
NYnoWLhGrlj8dtMmHourpHR6PJcb+trbrdxgKhOQ0cRvaeLKOk9I4a+xZUAO
K4Wqwnv8fJ3IpFVSaFUuX7uztFIE29PKp3tzezB86R2sFU89EnR3baCuk7Aw
LTxAFKuqwviPb6yF2WQ9kkeCbvnAqsLz+wBRPfYdKAudOjqt+VHz137g//NH
ozw6P+s8UrkOiiR+Xt9jDETP7hSZRC4GVrN8wVM3D1aui1pOLJhZwJVHIAvJ
ZQGeGcEGnqvNGvhQMqOjc4BnnvGKasSqh1nzwRgwidc4pUyd2HqzxnG5vMbJ
VZDHchZZVR0t8pWpky/nfUevsEJKo2U2e/i+c3tYTabdw587eoHzgwen9V6H
TrHoa65eoAVZFTb/23uM5Xm14h3Lz/HDqYG34EM0JPTfm7um9V+R5WcWWpUX
7MR44X1Fw0QYLqxCR+jUZmeSQse2WS+oJXQ8m6wxxk8ji60XHYZZifxcF/0Z
/eZOVCPAdMnED5seq7BpPP+esT5DVHXevYA7GhjTVWpL6HsLYdKcbCszoOz3
5mjCI1u+q5+D6bcwXSHPbyrwYEUsTDBvKgF5+V54vxX6xB63rMFUrXNakkyP
44YI478f2YVx574hYkZUCt7H7VLd+Za6diPfbT9XA8j/hiJ/yy0HJX8vUQxl
vmr98KTPubEXQPEw9wgU2R3J1fxi8p2dTqmxLP+L02KU0jHSmfrbVgmSA2/f
v9MnpHTdqZoY2CH4MHlypFNI4b+JkiX/ARxJdUE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->55210863]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithms for finding community structure", "Subsubsection",
 CellTags->"b:0.1",
 CellID->1387360053],

Cell["\<\
Much relational information can be represented in graphs. One graph feature \
is community structure, which is the gathering of vertices into groups such \
that there is a higher density of edges within groups than between them. The \
discovery and analysis of community structure in graphs is useful in a number \
of applications. For example, in software engineering, it is sometimes \
necessary to group source code in directories so that interrelated routines \
are located in the same directory. In social networks, it is often necessary \
to identify groups of friends that form a close-knit community. In parallel \
computing, it is desirable to partition computing tasks, so that highly \
related tasks are placed on the same processor.\
\>", "Text",
 CellID->103500215],

Cell[TextData[{
 "A number of algorithms exist that identify community structure in a \
network. One such algorithm is that of [16]. The key concept is a quantity \
called ",
 StyleBox["community modularity",
  FontSlant->"Italic"],
 ". Suppose the graph of concern is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"V", ",", " ", "E"}], "}"}]}], TraditionalForm]]],
 ", and the vertex set ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]]],
 " is partitioned into ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]]],
 " subsets ",
 Cell[BoxData[
  FormBox[
   RowBox[{"V", " ", "=", " ", 
    RowBox[{"\[Union]", " ", 
     SubscriptBox["V", "i"]}]}], TraditionalForm]]],
 " such that each subset belongs to one community. Then the community \
modularity ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 " of this partition is defined as"
}], "Text",
 CellID->189589686],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"Q", " ", "=", " ", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "k"], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["e", "ii"], " ", "-", " ", 
      SuperscriptBox[
       SubscriptBox["a", "i"], "2"]}], ")"}]}]}], TraditionalForm]]]], "Text",\

 CellID->2103657240],

Cell[TextData[{
 "Here, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "ii"], " "}], TraditionalForm]]],
 "is the percentage of number of edges that has both ends in community ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["V", "i"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "i"], TraditionalForm]]],
 " is the percentage of edges that start from community ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["V", "i"], "."}], TraditionalForm]]],
 " In other words, "
}], "Text",
 CellID->1504451905],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["e", "ii"], " ", "=", 
   RowBox[{"|", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", ",", "v"}], ")"}], "|", " ", 
       RowBox[{"u", "\[Element]", 
        SubscriptBox["V", "i"]}]}], ",", " ", 
      RowBox[{"v", "\[Element]", " ", 
       SubscriptBox["V", "i"]}], ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", ",", "v"}], ")"}], "\[Element]", " ", "E"}]}], "}"}], 
    " ", "|", 
    RowBox[{"/", 
     RowBox[{"|", "E", "|"}]}]}]}], TraditionalForm]]]], "Text",
 CellID->1036535411],

Cell["and", "Text",
 CellID->1582072628],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "i"], " ", "=", " ", 
    RowBox[{"|", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"u", ",", "v"}], ")"}], "|", " ", 
        RowBox[{"u", "\[Element]", 
         SubscriptBox["V", "i"]}]}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"u", ",", "v"}], ")"}], "\[Element]", " ", "E"}]}], "}"}], 
     " ", "|", 
     RowBox[{"/", 
      RowBox[{"|", "E", "|", " "}]}]}]}], TraditionalForm]]],
 "."
}], "Text",
 CellID->346004065],

Cell[TextData[{
 "Clearly, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", " ", "\[LessEqual]", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "1"}], "k"], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["e", "ii"], " ", "-", " ", 
       SuperscriptBox[
        SubscriptBox["a", "i"], "2"]}], ")"}]}], " ", "\[LessEqual]", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "1"}], "k"], 
     SubscriptBox["e", "ii"]}], " ", "\[LessEqual]", " ", "1."}], 
   TraditionalForm]]],
 " Typically, for a random partition of ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 " is close to zero, while the partition of ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]]],
 " that gives a large positive value of ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 " indicates a significant community structure."
}], "Text",
 CellID->643893516],

Cell[TextData[{
 "Therefore the algorithm of [16] starts by assigning every vertex into its \
own community, and calculates the change in ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 " that will result from merging two communities into one. It then merge the \
two communities that give the highest positive change in ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 ". This process is repeated on the merged network. The process terminates if \
the highest change is found to be negative."
}], "Text",
 CellID->608503716]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Options for CommunityStructurePartition, CommunityStructureAssignment, and \
CommunityModularity\
\>", "Subsubsection",
 CellTags->{"Options_for_GraphPlot", "b:0.1"},
 CellID->28720680],

Cell["The following option are accepted.", "Text",
 CellTags->"b:0.1",
 CellID->1967562584],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Weighted",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Weighted"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether edge weights are to be taken into account", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.10b",
 CellID->265227657],

Cell[TextData[{
 "Options for ",
 StyleBox["CommunityStructurePartition,", "MR"],
 " ",
 StyleBox["CommunityStructureAssignment", "MR"],
 " and ",
 StyleBox["CommunityModularity", "MR"],
 "."
}], "Caption",
 CellTags->"b:0.1",
 CellID->1770086522],

Cell[TextData[{
 "The ",
 StyleBox[ButtonBox["Weighted",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/Weighted"],
  FontFamily->"Courier"],
 " option specifies whether edge weights are to be taken into account. \
Possible values for this option are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " (the default)",
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->225069933],

Cell["\<\
This defines a graph with edge weights of 1 except the edge between vertices \
3 and 4, which has an edge weight of 2.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->178664163],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}], ",", 
     RowBox[{"10", "\[Rule]", "7"}], ",", 
     RowBox[{"10", "\[Rule]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"ToCombinatoricaGraph", "[", "g", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"SetEdgeWeights", "[", 
    RowBox[{"g", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[36]:=",
 CellID->257522100],

Cell["\<\
This finds and shows the three communities, ignoring the edge weights.\
\>", "MathCaption",
 CellID->1689655390],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"assignment", " ", "=", " ", 
   RowBox[{"CommunityStructureAssignment", "[", "g", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"color", " ", "=", " ", 
   RowBox[{"0.7", "*", 
    RowBox[{"assignment", "/", 
     RowBox[{"Max", "[", "assignment", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Hue", "[", 
         RowBox[{"color", "[", 
          RowBox[{"[", "#3", "]"}], "]"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[36]:=",
 CellID->56997146],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0.8335382931014308, 0.38704913210235614`}, {
      0.03131723095252403, 0.}, {0.000019333747780070354`, 
      0.8517143812160743}, {0., 2.003236968498627}, {0.031162029872202623`, 
      2.8540002602369556`}, {0.8330742064916268, 2.468271005638538}, {
      1.9427396058162434`, 1.9490939994400782`}, {2.9531873306836913`, 
      1.8334767515512143`}, {2.9533687136981435`, 1.0212939811416084`}, {
      1.9435164333868937`, 0.9065791588800988}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {2, 3}, {3, 1}, {3, 4}, {4, 5}, {5, 6}, {6, 4}, {6, 
        7}, {7, 8}, {8, 9}, {9, 10}, {10, 1}, {10, 7}}]}], {
      {Hue[0.2333333333333333], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8335382931014308, 0.38704913210235614`}, 0.1], 
       {GrayLevel[0], 
        InsetBox["1", {0.8335382931014308, 0.38704913210235614`}]}}, 
      {Hue[0.2333333333333333], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.03131723095252403, 0.}, 0.1], 
       {GrayLevel[0], InsetBox["2", {0.03131723095252403, 0.}]}}, 
      {Hue[0.2333333333333333], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.000019333747780070354`, 0.8517143812160743}, 0.1], 
       {GrayLevel[0], 
        InsetBox["3", {0.000019333747780070354`, 0.8517143812160743}]}}, 
      {Hue[0.4666666666666666], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 2.003236968498627}, 0.1], 
       {GrayLevel[0], InsetBox["4", {0., 2.003236968498627}]}}, 
      {Hue[0.4666666666666666], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.031162029872202623`, 2.8540002602369556`}, 0.1], 
       {GrayLevel[0], 
        InsetBox["5", {0.031162029872202623`, 2.8540002602369556`}]}}, 
      {Hue[0.4666666666666666], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8330742064916268, 2.468271005638538}, 0.1], 
       {GrayLevel[0], 
        InsetBox["6", {0.8330742064916268, 2.468271005638538}]}}, 
      {Hue[0.7], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.9427396058162434`, 1.9490939994400782`}, 0.1], 
       {GrayLevel[0], 
        InsetBox["7", {1.9427396058162434`, 1.9490939994400782`}]}}, 
      {Hue[0.7], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.9531873306836913`, 1.8334767515512143`}, 0.1], 
       {GrayLevel[0], 
        InsetBox["8", {2.9531873306836913`, 1.8334767515512143`}]}}, 
      {Hue[0.7], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.9533687136981435`, 1.0212939811416084`}, 0.1], 
       {GrayLevel[0], 
        InsetBox["9", {2.9533687136981435`, 1.0212939811416084`}]}}, 
      {Hue[0.7], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.9435164333868937`, 0.9065791588800988}, 0.1], 
       {GrayLevel[0], 
        InsetBox["10", {1.9435164333868937`, 0.9065791588800988}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.8335382931014308, 0.38704913210235614`}, {
     0.03131723095252403, 0.}, {0.000019333747780070354`, 
     0.8517143812160743}, {0., 2.003236968498627}, {0.031162029872202623`, 
     2.8540002602369556`}, {0.8330742064916268, 2.468271005638538}, {
     1.9427396058162434`, 1.9490939994400782`}, {2.9531873306836913`, 
     1.8334767515512143`}, {2.9533687136981435`, 1.0212939811416084`}, {
     1.9435164333868937`, 0.9065791588800988}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{364, 349},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->508964893]
}, Open  ]],

Cell["\<\
This shows that when edge weight is taken into account, the larger edge \
weight between vertices 3 and 4 means that these two vertices are now placed \
in the same community.\
\>", "MathCaption",
 CellID->1313779799],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"assignment", " ", "=", " ", 
   RowBox[{"CommunityStructureAssignment", "[", 
    RowBox[{"g", ",", " ", 
     RowBox[{"Weighted", "->", "True"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"color", " ", "=", " ", 
   RowBox[{"0.7", "*", 
    RowBox[{"assignment", "/", 
     RowBox[{"Max", "[", "assignment", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Hue", "[", 
         RowBox[{"color", "[", 
          RowBox[{"[", "#3", "]"}], "]"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[42]:=",
 CellID->1814834051],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0.8335382931014308, 0.38704913210235614`}, {
      0.03131723095252403, 0.}, {0.000019333747780070354`, 
      0.8517143812160743}, {0., 2.003236968498627}, {0.031162029872202623`, 
      2.8540002602369556`}, {0.8330742064916268, 2.468271005638538}, {
      1.9427396058162434`, 1.9490939994400782`}, {2.9531873306836913`, 
      1.8334767515512143`}, {2.9533687136981435`, 1.0212939811416084`}, {
      1.9435164333868937`, 0.9065791588800988}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {2, 3}, {3, 1}, {3, 4}, {4, 5}, {5, 6}, {6, 4}, {6, 
        7}, {7, 8}, {8, 9}, {9, 10}, {10, 1}, {10, 7}}]}], {
      {Hue[0.2333333333333333], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8335382931014308, 0.38704913210235614`}, 0.1], 
       {GrayLevel[0], 
        InsetBox["1", {0.8335382931014308, 0.38704913210235614`}]}}, 
      {Hue[0.2333333333333333], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.03131723095252403, 0.}, 0.1], 
       {GrayLevel[0], InsetBox["2", {0.03131723095252403, 0.}]}}, 
      {Hue[0.2333333333333333], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.000019333747780070354`, 0.8517143812160743}, 0.1], 
       {GrayLevel[0], 
        InsetBox["3", {0.000019333747780070354`, 0.8517143812160743}]}}, 
      {Hue[0.2333333333333333], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 2.003236968498627}, 0.1], 
       {GrayLevel[0], InsetBox["4", {0., 2.003236968498627}]}}, 
      {Hue[0.4666666666666666], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.031162029872202623`, 2.8540002602369556`}, 0.1], 
       {GrayLevel[0], 
        InsetBox["5", {0.031162029872202623`, 2.8540002602369556`}]}}, 
      {Hue[0.4666666666666666], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8330742064916268, 2.468271005638538}, 0.1], 
       {GrayLevel[0], 
        InsetBox["6", {0.8330742064916268, 2.468271005638538}]}}, 
      {Hue[0.7], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.9427396058162434`, 1.9490939994400782`}, 0.1], 
       {GrayLevel[0], 
        InsetBox["7", {1.9427396058162434`, 1.9490939994400782`}]}}, 
      {Hue[0.7], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.9531873306836913`, 1.8334767515512143`}, 0.1], 
       {GrayLevel[0], 
        InsetBox["8", {2.9531873306836913`, 1.8334767515512143`}]}}, 
      {Hue[0.7], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.9533687136981435`, 1.0212939811416084`}, 0.1], 
       {GrayLevel[0], 
        InsetBox["9", {2.9533687136981435`, 1.0212939811416084`}]}}, 
      {Hue[0.7], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.9435164333868937`, 0.9065791588800988}, 0.1], 
       {GrayLevel[0], 
        InsetBox["10", {1.9435164333868937`, 0.9065791588800988}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.8335382931014308, 0.38704913210235614`}, {
     0.03131723095252403, 0.}, {0.000019333747780070354`, 
     0.8517143812160743}, {0., 2.003236968498627}, {0.031162029872202623`, 
     2.8540002602369556`}, {0.8330742064916268, 2.468271005638538}, {
     1.9427396058162434`, 1.9490939994400782`}, {2.9531873306836913`, 
     1.8334767515512143`}, {2.9533687136981435`, 1.0212939811416084`}, {
     1.9435164333868937`, 0.9065791588800988}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{364, 349},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[44]=",
 CellID->2084731565]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EdgeList", "Subsection",
 CellID->239679646],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox[
       ButtonBox[
        StyleBox["EdgeList", "MR"],
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/EdgeList"], "MR"], 
      StyleBox["[", "MR"], 
      StyleBox["g", "TI"], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      "gives a list of edges in the graph ",
      Cell[BoxData[
       StyleBox["g", "TI"]], "InlineFormula"],
      ". "
     }], "Text"]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.6",
 CellID->1173875382],

Cell["Finding the list of edges.", "Caption",
 CellTags->"b:0.6",
 CellID->1521328465],

Cell["This gives the list of vertices of a simple graph.", "MathCaption",
 CellID->1377811920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EdgeList", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<a\>\"", "\[Rule]", "\"\<b\>\""}], ",", 
    RowBox[{"\"\<b\>\"", "\[Rule]", "\"\<c\>\""}], ",", 
    RowBox[{"\"\<a\>\"", "\[Rule]", "\"\<c\>\""}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->1806197961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->2031118735]
}, Open  ]],

Cell[TextData[{
 "This converts a ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " graph object to a rule list."
}], "MathCaption",
 CellID->2092380576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gc", "=", "PetersenGraph"}]], "Input",
 CellLabel->"In[102]:=",
 CellID->2109398399],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", "\<\"Undirected\"\>", 
   "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
  SequenceForm[
  "\[SkeletonIndicator]Graph:<", 15, ", ", 10, ", ", "Undirected", 
   ">\[SkeletonIndicator]"],
  Editable->False]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[102]=",
 CellID->1674544461]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Rule", "@@", "#"}], "&"}], ",", 
    RowBox[{"EdgeList", "[", "gc", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[103]:=",
 CellID->1106863291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "3"}], ",", 
   RowBox[{"1", "\[Rule]", "4"}], ",", 
   RowBox[{"1", "\[Rule]", "6"}], ",", 
   RowBox[{"2", "\[Rule]", "4"}], ",", 
   RowBox[{"2", "\[Rule]", "5"}], ",", 
   RowBox[{"2", "\[Rule]", "7"}], ",", 
   RowBox[{"3", "\[Rule]", "1"}], ",", 
   RowBox[{"3", "\[Rule]", "5"}], ",", 
   RowBox[{"3", "\[Rule]", "8"}], ",", 
   RowBox[{"4", "\[Rule]", "1"}], ",", 
   RowBox[{"4", "\[Rule]", "2"}], ",", 
   RowBox[{"4", "\[Rule]", "9"}], ",", 
   RowBox[{"5", "\[Rule]", "2"}], ",", 
   RowBox[{"5", "\[Rule]", "3"}], ",", 
   RowBox[{"5", "\[Rule]", "10"}], ",", 
   RowBox[{"6", "\[Rule]", "1"}], ",", 
   RowBox[{"6", "\[Rule]", "7"}], ",", 
   RowBox[{"6", "\[Rule]", "10"}], ",", 
   RowBox[{"7", "\[Rule]", "2"}], ",", 
   RowBox[{"7", "\[Rule]", "6"}], ",", 
   RowBox[{"7", "\[Rule]", "8"}], ",", 
   RowBox[{"8", "\[Rule]", "3"}], ",", 
   RowBox[{"8", "\[Rule]", "7"}], ",", 
   RowBox[{"8", "\[Rule]", "9"}], ",", 
   RowBox[{"9", "\[Rule]", "4"}], ",", 
   RowBox[{"9", "\[Rule]", "8"}], ",", 
   RowBox[{"9", "\[Rule]", "10"}], ",", 
   RowBox[{"10", "\[Rule]", "5"}], ",", 
   RowBox[{"10", "\[Rule]", "6"}], ",", 
   RowBox[{"10", "\[Rule]", "9"}]}], "}"}]], "Output",
 ImageSize->{447, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[103]=",
 CellID->803276254]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "g", "]"}]], "Input",
 CellLabel->"In[106]:=",
 CellID->1188040214],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw9l3k4VH/8xSdJRKUkyxclS6VNJVnKIS2isoWQrUVosyUiSaXSokXZSiiV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    "], {
     {RGBColor[0.5, 0., 0.], LineBox[CompressedData["
1:eJwt1GXQVkUYBuDvRbpEuhEQkO6WlFRAUunubpBUSelWUEBQpEW6u7u7O+zu
uM6858c1c/84c8/us7sna9te9XvGiomJyUxyIiQiMUlIyvMk44XwmxSkJBWp
SUNa0pGeWGFPBjKSKezPwotkJRvZeYkc5CQXL5ObPDwX9uQlH/kpQEEKUZgi
FKUYxSlBSUpRmjLEDtdUllcoR3kqUJFKVOZVqlCValSnBjV5LVxL0PM6tahN
Hd6gLvWoTwMa0og3eYvGNKEpccOeZjSnBS1pRWva0JZ2tKcDHelEZ7rQlfjh
jLrRnR70pBe96UNf+tGfAQxkEIN5myHhvoKeoQxjOCMYyTu8y3uMYjRjGMs4
xvM+E4gT9kxkEpOZwlSmMZ0ZzGQWs5nDB3zIXOaRIDyzj/iY+SxgIZ+wiMV8
ymcs4XOWsozlrAj3FfSsZBWr+YI1fMla1rGeDWxkE5vZwla2ES/s2c4OdrKL
3exhL/vYzwEOcojDHOEox0gYzug4JzjJKU5zhrOc4zwXuMglLnOFq1wLZxz0
XOcGN7nFbe5wl3vc5wEPecRjnvCUZzHRexj0fMXXfMO3fMf3/MCP/MTP/MKv
/Mbv/MGf4XyCrr/4m3/4l/9ioocQIRbPEZs4xCUe8UlAwkh0LUFPIjkxSUjK
8yTjBZKTgpSkIjVpSEs60keibyvoySBnJBOZycKLZCUb2XmJHOQkFy+TmzyR
6HkFe8sr5yM/BShIIQpThKIUozglKEkpSlMm3FfQU1Z+hXKUpwIVqURlXqUK
ValGdWpQk9ci0TsY9Lwu16I2dXiDutSjPg1oSCPe5C0a04Smkeh/I9BMbk4L
WtKK1rShLe1oTwc60onOdKFrOOegp5vcnR70pBe96UNf+tGfAQxkEIN5myGR
6J6CnqHyMIYzgpG8w7u8xyhGM4axjGM87zMhEv1vBCbKk5jMFKYyjenMYCaz
mM0cPuBD5jIvEn1fQc9H8sfMZwEL+YRFLOZTPmMJn7OUZSxnRTjnoGelvIrV
fMEavmQt61jPBjayic1sYSvbItF7GNgu72Anu9jNHvayj/0c4CCHOMwRjnIs
En0TQc9x+QQnOcVpznCWc5znAhe5xGWucJVrkeg9DHquyze4yS1uc4e73OM+
D3jIIx7zhKc8C8/rf7CT7so=
       "]]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.3847107222795063`, 0.}, {2.07134426812127, 
     0.6717419313333276}, {0.5601121389809807, 0.9793015011168973}, {
     0.6843133274205824, 0.000055352070726488733`}, {1.0361927693771995`, 
     1.5752122075807349`}, {1.0353764158743097`, 0.6973354167964172}, {
     1.5107508601937454`, 0.977047186638105}, {1.693832956322857, 
     1.7100320626368382`}, {0.37925516898563527`, 1.7107461371094828`}, {0., 
     0.6739771695102383}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{213., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{217, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[106]=",
 CellID->83367176]
}, Open  ]],

Cell["This removes multiedges.", "MathCaption",
 CellID->1459575814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g2", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", 
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ",", 
        RowBox[{"Rule", "@@", "#"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "&"}], ",", 
     RowBox[{"EdgeList", "[", "gc", "]"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[104]:=",
 CellID->573693372],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", "\[Rule]", "1"}], ",", 
   RowBox[{"4", "\[Rule]", "1"}], ",", 
   RowBox[{"4", "\[Rule]", "2"}], ",", 
   RowBox[{"5", "\[Rule]", "2"}], ",", 
   RowBox[{"5", "\[Rule]", "3"}], ",", 
   RowBox[{"6", "\[Rule]", "1"}], ",", 
   RowBox[{"7", "\[Rule]", "2"}], ",", 
   RowBox[{"7", "\[Rule]", "6"}], ",", 
   RowBox[{"8", "\[Rule]", "3"}], ",", 
   RowBox[{"8", "\[Rule]", "7"}], ",", 
   RowBox[{"9", "\[Rule]", "4"}], ",", 
   RowBox[{"9", "\[Rule]", "8"}], ",", 
   RowBox[{"10", "\[Rule]", "5"}], ",", 
   RowBox[{"10", "\[Rule]", "6"}], ",", 
   RowBox[{"10", "\[Rule]", "9"}]}], "}"}]], "Output",
 ImageSize->{358, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[104]=",
 CellID->2109607209]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "g2", "]"}]], "Input",
 CellLabel->"In[107]:=",
 CellID->326944604],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.5257630732144183`, 0.014754569919383953`}, {
    1.8096534340057002`, 1.2955209958902165`}, {0.6756379106658243, 
    1.6212833221531806`}, {1.3597673944025335`, 1.0905395631616257`}, {
    2.0146771057272437`, 0.3699265408257372}, {1.2337710537640347`, 
    1.7222673127643648`}, {0.5127997930698238, 1.0327113033139814`}, {
    0.4056245861654083, 0.}, {0., 0.7324158611275737}, {1.0346825868208214`, 
    0.6454227119779798}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 2}, {3, 4}, {5, 4}, {5, 1}, {6, 2}, {7, 4}, {7, 
       6}, {8, 1}, {8, 7}, {9, 3}, {9, 8}, {10, 5}, {10, 6}, {10, 9}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.5257630732144183`, 0.014754569919383953`}, {
     1.8096534340057002`, 1.2955209958902165`}, {0.6756379106658243, 
     1.6212833221531806`}, {1.3597673944025335`, 1.0905395631616257`}, {
     2.0146771057272437`, 0.3699265408257372}, {1.2337710537640347`, 
     1.7222673127643648`}, {0.5127997930698238, 1.0327113033139814`}, {
     0.4056245861654083, 0.}, {0., 0.7324158611275737}, {1.0346825868208214`, 
     0.6454227119779798}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{218., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{222, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[107]=",
 CellID->995139259]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExpressionTreePlot", "Subsection",
 CellID->101821423],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox[
       ButtonBox[
        StyleBox["ExpressionTreePlot", "MR"],
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/ExpressionTreePlot"], "MR"], 
      StyleBox["[", "MR"], 
      StyleBox["e", "TI"], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      StyleBox["plots the expression tree of ",
       FontFamily->"Verdana",
       FontSize->10],
      Cell[BoxData[
       StyleBox["e", "TI"]], "InlineFormula"],
      " "
     }], "Text"]},
    {
     RowBox[{
      RowBox[{
       StyleBox[
        ButtonBox[
         StyleBox["ExpressionTreePlot", "MR"],
         BaseStyle->"Link",
         ButtonData->"paclet:GraphUtilities/ref/ExpressionTreePlot"], "MR"], 
       StyleBox["[", "MR"], 
       RowBox[{
        StyleBox["e", "TI"], 
        StyleBox[",", "MR"], 
        StyleBox[" ", "MR"], 
        StyleBox["pos", "TI"]}], 
       StyleBox["]", "MR"]}], " "}], Cell[TextData[{
      "plots the expression tree of ",
      Cell[BoxData[
       StyleBox["e", "TI"]], "InlineFormula"],
      " with its root placed at position ",
      Cell[BoxData[
       StyleBox["pos", "TI"]], "InlineFormula"]
     }], "Text",
      FontFamily->"Verdana",
      FontSize->10]},
    {
     StyleBox[
      RowBox[{
       ButtonBox[
        StyleBox["ExpressionTreePlot", "MR"],
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/ExpressionTreePlot"], "[", 
       RowBox[{
        StyleBox["e", "TI"], ",", " ", 
        StyleBox["pos", "TI"], ",", " ", 
        StyleBox["lev", "TI"]}], "]"}],
      FontFamily->"Courier"], 
     StyleBox[
      RowBox[{
      "plots", " ", "the", " ", "expression", " ", "tree", " ", "of", " ", 
       StyleBox["e", "TI"], " ", "up", " ", "to", " ", "level", " ", 
       StyleBox["lev", "TI"], " ", "with", " ", "its", " ", "root", " ", 
       "placed", " ", "at", " ", "position", " ", 
       StyleBox["pos", "TI"]}],
      FontSize->10]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.1",
 CellID->1815760708],

Cell["Functions for plotting an expression tree.", "Caption",
 CellTags->"b:0.11",
 CellID->643723736],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpressionTreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/ExpressionTreePlot"]], 
  "InlineFormula"],
 " plots the expression tree of an expression. It has the same options as ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.11",
 CellID->1625834858],

Cell["\<\
This gives an expression tree plot, with tooltips for each vertex giving the \
subexpression from that vertex down.\
\>", "MathCaption",
 CellID->5097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionTreePlot", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"E", "^", "x"}], "+", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->16512],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.831299685083074, 2.1975596220996887`}, {
    0.3662599370166148, 1.465039748066459}, {0., 0.7325198740332295}, {
    0.7325198740332296, 0.7325198740332295}, {1.831299685083074, 
    1.465039748066459}, {1.4650397480664592`, 0.7325198740332295}, {
    2.1975596220996887`, 0.7325198740332295}, {3.2963394331495333`, 
    1.465039748066459}, {2.9300794961329184`, 0.7325198740332295}, {
    2.9300794961329184`, 0.}, {3.662599370166148, 0.7325198740332295}, {
    3.662599370166148, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 5}, {1, 8}, {2, 3}, {2, 4}, {5, 6}, {5, 7}, {8, 
       9}, {8, 11}, {9, 10}, {11, 12}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           SuperscriptBox["\[ExponentialE]", "x"], "+", 
           SuperscriptBox["x", "2"], "+", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Sin", "[", "x", "]"}]}]}], HoldForm]],
       Annotation[#, 
        HoldForm[
        E^$CellContext`x + $CellContext`x^2 + 
         Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
       Annotation[#, 
        HoldForm[E^$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["\[ExponentialE]",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["\[ExponentialE]", HoldForm]],
       Annotation[#, 
        HoldForm[E], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         SuperscriptBox["x", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox[
         RowBox[{
           RowBox[{"Cos", "[", "x", "]"}], " ", 
           RowBox[{"Sin", "[", "x", "]"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Cos", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox[
         RowBox[{"Cos", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Cos[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Sin", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox[
         RowBox[{"Sin", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.831299685083074, 2.1975596220996887`}, {
     0.3662599370166148, 1.465039748066459}, {0., 0.7325198740332295}, {
     0.7325198740332296, 0.7325198740332295}, {1.831299685083074, 
     1.465039748066459}, {1.4650397480664592`, 0.7325198740332295}, {
     2.1975596220996887`, 0.7325198740332295}, {3.2963394331495333`, 
     1.465039748066459}, {2.9300794961329184`, 0.7325198740332295}, {
     2.9300794961329184`, 0.}, {3.662599370166148, 0.7325198740332295}, {
     3.662599370166148, 0.}}]& ],
  AspectRatio->NCache[2 Rational[2, 15]^Rational[1, 2], 0.7302967433402214],
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->1074248922]
}, Open  ]],

Cell["\<\
This shows an expression tree up to level 2 with its root at the left.\
\>", "MathCaption",
 CellID->1108291180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionTreePlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"E", "^", "x"}], "+", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cos", "[", "x", "]"}]}]}], ",", "Left", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->638430509],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.7437145811572876`}, {0.6974858324629172, 
    0.34874291623145715`}, {1.3949716649258332`, 0.}, {1.3949716649258324`, 
    0.6974858324629158}, {0.6974858324629157, 1.7437145811572883`}, {
    1.3949716649258317`, 1.3949716649258315`}, {1.394971664925831, 
    2.092457497388747}, {0.6974858324629143, 3.13868624608312}, {
    1.3949716649258301`, 2.7899433298516625`}, {1.3949716649258295`, 
    3.4874291623145783`}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 5}, {1, 8}, {2, 3}, {2, 4}, {5, 6}, {5, 7}, {8, 
       9}, {8, 10}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           SuperscriptBox["\[ExponentialE]", "x"], "+", 
           SuperscriptBox["x", "2"], "+", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Sin", "[", "x", "]"}]}]}], HoldForm]],
       Annotation[#, 
        HoldForm[
        E^$CellContext`x + $CellContext`x^2 + 
         Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
       Annotation[#, 
        HoldForm[E^$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["\[ExponentialE]",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["\[ExponentialE]", HoldForm]],
       Annotation[#, 
        HoldForm[E], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         SuperscriptBox["x", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox[
         RowBox[{
           RowBox[{"Cos", "[", "x", "]"}], " ", 
           RowBox[{"Sin", "[", "x", "]"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            RowBox[{"cos", "(", "x", ")"}],
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox[
         RowBox[{"Cos", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Cos[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            RowBox[{"sin", "(", "x", ")"}],
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox[
         RowBox[{"Sin", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Sin[$CellContext`x]], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.7437145811572876`}, {0.6974858324629172, 
     0.34874291623145715`}, {1.3949716649258332`, 0.}, {1.3949716649258324`, 
     0.6974858324629158}, {0.6974858324629157, 1.7437145811572883`}, {
     1.3949716649258317`, 1.3949716649258315`}, {1.394971664925831, 
     2.092457497388747}, {0.6974858324629143, 3.13868624608312}, {
     1.3949716649258301`, 2.7899433298516625`}, {1.3949716649258295`, 
     3.4874291623145783`}}]& ],
  AspectRatio->NCache[
   Rational[1, 2] Rational[3, 2]^Rational[1, 2], 0.6123724356957945],
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->1362734504]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GraphCoordinates, GraphCoordinates3D", "Subsection",
 CellTags->{"graphplot", "i:4", "b:0.2"},
 CellID->355209470],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GraphCoordinates",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"], 
     StyleBox["[", "MR"], 
     StyleBox["g", "TI"], "]"}], Cell["\<\
calculates a visually appealing two-dimensional layout and returns the \
coordinates of the vertices\
\>", "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["GraphCoordinates3D",
       BaseStyle->"Link",
       ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates3D"], 
      StyleBox["[", "MR"], 
      StyleBox["g", "TI"], "]"}], " "}], Cell["\<\
calculates a visually appealing three-dimensional layout and returns the \
coordinates of the vertices\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.2",
 CellID->41670843],

Cell["Graph drawing functions that return coordinates.", "Caption",
 CellTags->"b:0.2",
 CellID->493933754],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphCoordinates",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"]], 
  "InlineFormula"],
 " returns the coordinates of the vertices as computed using a graph drawing \
algorithm. It is useful when the coordinates of the vertices are needed, \
rather than a drawing of the graph, or when one needs to draw a graph \
repeatedly using the same layout but different style."
}], "Text",
 CellID->996693321],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphCoordinates",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"]], 
  "InlineFormula"],
 " accepts the same options as ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1067943069],

Cell["This defines and plots a small graph.", "MathCaption",
 CellTags->"b:0.2",
 CellID->27298254],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a10", "\[Rule]", "a11"}], ",", 
     RowBox[{"a11", "\[Rule]", "a12"}], ",", 
     RowBox[{"a12", "\[Rule]", "a7"}], ",", 
     RowBox[{"a1", "\[Rule]", "a7"}], ",", 
     RowBox[{"a2", "\[Rule]", "a8"}], ",", 
     RowBox[{"a3", "\[Rule]", "a9"}], ",", 
     RowBox[{"a4", "\[Rule]", "a10"}], ",", 
     RowBox[{"a5", "\[Rule]", "a11"}], ",", 
     RowBox[{"a6", "\[Rule]", "a12"}], ",", 
     RowBox[{"a7", "\[Rule]", "a13"}], ",", 
     RowBox[{"a9", "\[Rule]", "a13"}], ",", 
     RowBox[{"a11", "\[Rule]", "a13"}], ",", 
     RowBox[{"a1", "\[Rule]", "a2"}], ",", 
     RowBox[{"a2", "\[Rule]", "a3"}], ",", 
     RowBox[{"a3", "\[Rule]", "a4"}], ",", 
     RowBox[{"a4", "\[Rule]", "a5"}], ",", 
     RowBox[{"a5", "\[Rule]", "a6"}], ",", 
     RowBox[{"a6", "\[Rule]", "a1"}], ",", 
     RowBox[{"a7", "\[Rule]", "a8"}], ",", 
     RowBox[{"a8", "\[Rule]", "a9"}], ",", 
     RowBox[{"a9", "\[Rule]", "a10"}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[54]:=",
 CellID->312718712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "g", "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[55]:=",
 CellID->608639290],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.5204017052453995`, 0.047566762918297645`}, {
    2.710485528072843, 1.109467213844454}, {2.19056735780271, 
    2.112084756853589}, {1.2065199149241677`, 1.6071153596889034`}, {
    0.4650206714861995, 1.995523046020941}, {0., 0.934279107694042}, {
    0.6402073915293885, 0.7621535976985391}, {0.7051022086486474, 0.}, {
    1.408909839795017, 0.047133337886437476`}, {1.8904246131071645`, 
    0.23558207307187184`}, {2.203029870107729, 1.4543975485934673`}, {
    1.50780526551756, 2.3889321027749038`}, {1.8449900303379148`, 
    0.885128543209283}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 13}, {3, 4}, {4, 13}, {4, 7}, {5, 4}, {5, 
       6}, {6, 7}, {6, 8}, {7, 9}, {8, 9}, {8, 10}, {9, 13}, {9, 1}, {10, 
       1}, {10, 11}, {11, 2}, {11, 12}, {12, 3}, {12, 5}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "a10"],
       Annotation[#, $CellContext`a10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "a11"],
       Annotation[#, $CellContext`a11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "a12"],
       Annotation[#, $CellContext`a12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "a7"],
       Annotation[#, $CellContext`a7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "a1"],
       Annotation[#, $CellContext`a1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "a2"],
       Annotation[#, $CellContext`a2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "a8"],
       Annotation[#, $CellContext`a8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "a3"],
       Annotation[#, $CellContext`a3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "a9"],
       Annotation[#, $CellContext`a9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "a4"],
       Annotation[#, $CellContext`a4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "a5"],
       Annotation[#, $CellContext`a5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "a6"],
       Annotation[#, $CellContext`a6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "a13"],
       Annotation[#, $CellContext`a13, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.5204017052453995`, 0.047566762918297645`}, {
     2.710485528072843, 1.109467213844454}, {2.19056735780271, 
     2.112084756853589}, {1.2065199149241677`, 1.6071153596889034`}, {
     0.4650206714861995, 1.995523046020941}, {0., 0.934279107694042}, {
     0.6402073915293885, 0.7621535976985391}, {0.7051022086486474, 0.}, {
     1.408909839795017, 0.047133337886437476`}, {1.8904246131071645`, 
     0.23558207307187184`}, {2.203029870107729, 1.4543975485934673`}, {
     1.50780526551756, 2.3889321027749038`}, {1.8449900303379148`, 
     0.885128543209283}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{Automatic, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{364, 317},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[55]=",
 CellID->216522487]
}, Open  ]],

Cell["\<\
This gives the coordinates of the vertices in the previous drawing.\
\>", "MathCaption",
 CellTags->"b:0.2",
 CellID->109486886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coord", " ", "=", " ", 
  RowBox[{"GraphCoordinates", "[", "g", "]"}]}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[56]:=",
 CellID->275966196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.5204017052453995`", ",", "0.047566762918297645`"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"2.710485528072843`", ",", "1.109467213844454`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.19056735780271`", ",", "2.112084756853589`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2065199149241677`", ",", "1.6071153596889034`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4650206714861995`", ",", "1.995523046020941`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.934279107694042`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6402073915293885`", ",", "0.7621535976985391`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7051022086486474`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.408909839795017`", ",", "0.047133337886437476`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"1.8904246131071645`", ",", "0.23558207307187184`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"2.203029870107729`", ",", "1.4543975485934673`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.50780526551756`", ",", "2.3889321027749038`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.8449900303379148`", ",", "0.885128543209283`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{538, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[56]=",
 CellID->755418280]
}, Open  ]],

Cell["\<\
This plots the graph with two different styles, using the layout already \
calculated.\
\>", "MathCaption",
 CellID->2044539646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"GraphPlot", "[", 
     RowBox[{"g", ",", 
      RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
      RowBox[{"VertexCoordinateRules", "\[Rule]", "coord"}]}], "]"}], ",", 
    RowBox[{"GraphPlot", "[", 
     RowBox[{"g", ",", 
      RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
      RowBox[{"VertexCoordinateRules", "\[Rule]", "coord"}]}], "]"}]}], "}"}],
   "]"}]], "Input",
 CellLabel->"In[58]:=",
 CellID->893076608],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.5204017052453995`, 0.047566762918297645`}, {
      2.710485528072843, 1.109467213844454}, {2.19056735780271, 
      2.112084756853589}, {1.2065199149241677`, 1.6071153596889034`}, {
      0.4650206714861995, 1.995523046020941}, {0., 0.934279107694042}, {
      0.6402073915293885, 0.7621535976985391}, {0.7051022086486474, 0.}, {
      1.408909839795017, 0.047133337886437476`}, {1.8904246131071645`, 
      0.23558207307187184`}, {2.203029870107729, 1.4543975485934673`}, {
      1.50780526551756, 2.3889321027749038`}, {1.8449900303379148`, 
      0.885128543209283}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {2, 3}, {2, 13}, {3, 4}, {4, 13}, {4, 7}, {5, 4}, {5,
          6}, {6, 7}, {6, 8}, {7, 9}, {8, 9}, {8, 10}, {9, 13}, {9, 1}, {10, 
         1}, {10, 11}, {11, 2}, {11, 12}, {12, 3}, {12, 5}}]}, {InsetBox[
         FrameBox["a10",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 1], InsetBox[
         FrameBox["a11",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 2], InsetBox[
         FrameBox["a12",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 3], InsetBox[
         FrameBox["a7",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 4], InsetBox[
         FrameBox["a1",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 5], InsetBox[
         FrameBox["a2",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 6], InsetBox[
         FrameBox["a8",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 7], InsetBox[
         FrameBox["a3",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 8], InsetBox[
         FrameBox["a9",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 9], InsetBox[
         FrameBox["a4",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 10], InsetBox[
         FrameBox["a5",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 11], InsetBox[
         FrameBox["a6",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 12], InsetBox[
         FrameBox["a13",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 13]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.5204017052453995`, 
       0.047566762918297645`}, {2.710485528072843, 1.109467213844454}, {
       2.19056735780271, 2.112084756853589}, {1.2065199149241677`, 
       1.6071153596889034`}, {0.4650206714861995, 1.995523046020941}, {0., 
       0.934279107694042}, {0.6402073915293885, 0.7621535976985391}, {
       0.7051022086486474, 0.}, {1.408909839795017, 0.047133337886437476`}, {
       1.8904246131071645`, 0.23558207307187184`}, {2.203029870107729, 
       1.4543975485934673`}, {1.50780526551756, 2.3889321027749038`}, {
       1.8449900303379148`, 0.885128543209283}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    ImageSize->{236., Automatic},
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], "\[InvisibleSpace]", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.5204017052453995`, 0.047566762918297645`}, {
      2.710485528072843, 1.109467213844454}, {2.19056735780271, 
      2.112084756853589}, {1.2065199149241677`, 1.6071153596889034`}, {
      0.4650206714861995, 1.995523046020941}, {0., 0.934279107694042}, {
      0.6402073915293885, 0.7621535976985391}, {0.7051022086486474, 0.}, {
      1.408909839795017, 0.047133337886437476`}, {1.8904246131071645`, 
      0.23558207307187184`}, {2.203029870107729, 1.4543975485934673`}, {
      1.50780526551756, 2.3889321027749038`}, {1.8449900303379148`, 
      0.885128543209283}}, {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.030163851988336772`, 0.8}}], 
        ArrowBox[{1, 2}], ArrowBox[{2, 3}], ArrowBox[{2, 13}], 
        ArrowBox[{3, 4}], ArrowBox[{4, 13}], ArrowBox[{4, 7}], 
        ArrowBox[{5, 4}], ArrowBox[{5, 6}], ArrowBox[{6, 7}], 
        ArrowBox[{6, 8}], ArrowBox[{7, 9}], ArrowBox[{8, 9}], 
        ArrowBox[{8, 10}], ArrowBox[{9, 13}], ArrowBox[{9, 1}], 
        ArrowBox[{10, 1}], ArrowBox[{10, 11}], ArrowBox[{11, 2}], 
        ArrowBox[{11, 12}], ArrowBox[{12, 3}], ArrowBox[{12, 5}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "a10"],
         Annotation[#, $CellContext`a10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "a11"],
         Annotation[#, $CellContext`a11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "a12"],
         Annotation[#, $CellContext`a12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "a7"],
         Annotation[#, $CellContext`a7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "a1"],
         Annotation[#, $CellContext`a1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "a2"],
         Annotation[#, $CellContext`a2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "a8"],
         Annotation[#, $CellContext`a8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "a3"],
         Annotation[#, $CellContext`a3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "a9"],
         Annotation[#, $CellContext`a9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "a4"],
         Annotation[#, $CellContext`a4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "a5"],
         Annotation[#, $CellContext`a5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "a6"],
         Annotation[#, $CellContext`a6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "a13"],
         Annotation[#, $CellContext`a13, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.5204017052453995`, 
       0.047566762918297645`}, {2.710485528072843, 1.109467213844454}, {
       2.19056735780271, 2.112084756853589}, {1.2065199149241677`, 
       1.6071153596889034`}, {0.4650206714861995, 1.995523046020941}, {0., 
       0.934279107694042}, {0.6402073915293885, 0.7621535976985391}, {
       0.7051022086486474, 0.}, {1.408909839795017, 0.047133337886437476`}, {
       1.8904246131071645`, 0.23558207307187184`}, {2.203029870107729, 
       1.4543975485934673`}, {1.50780526551756, 2.3889321027749038`}, {
       1.8449900303379148`, 0.885128543209283}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    ImageSize->{242., Automatic},
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}],
  Row[{
    Graphics[
     Annotation[
      GraphicsComplex[{{2.5204017052453995`, 0.047566762918297645`}, {
       2.710485528072843, 1.109467213844454}, {2.19056735780271, 
       2.112084756853589}, {1.2065199149241677`, 1.6071153596889034`}, {
       0.4650206714861995, 1.995523046020941}, {0., 0.934279107694042}, {
       0.6402073915293885, 0.7621535976985391}, {0.7051022086486474, 0.}, {
       1.408909839795017, 0.047133337886437476`}, {1.8904246131071645`, 
       0.23558207307187184`}, {2.203029870107729, 1.4543975485934673`}, {
       1.50780526551756, 2.3889321027749038`}, {1.8449900303379148`, 
       0.885128543209283}}, {{
         RGBColor[0.5, 0., 0.], 
         Line[{{1, 2}, {2, 3}, {2, 13}, {3, 4}, {4, 13}, {4, 7}, {5, 4}, {5, 
          6}, {6, 7}, {6, 8}, {7, 9}, {8, 9}, {8, 10}, {9, 13}, {9, 1}, {10, 
          1}, {10, 11}, {11, 2}, {11, 12}, {12, 3}, {12, 5}}]}, {
         Text[
          
          Framed[$CellContext`a10, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 1], 
         Text[
          
          Framed[$CellContext`a11, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 2], 
         Text[
          
          Framed[$CellContext`a12, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 3], 
         Text[
          
          Framed[$CellContext`a7, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 4], 
         Text[
          
          Framed[$CellContext`a1, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 5], 
         Text[
          
          Framed[$CellContext`a2, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 6], 
         Text[
          
          Framed[$CellContext`a8, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 7], 
         Text[
          
          Framed[$CellContext`a3, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 8], 
         Text[
          Framed[$CellContext`a9, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 9], 
         Text[
          
          Framed[$CellContext`a4, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 10], 
         Text[
          
          Framed[$CellContext`a5, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 11], 
         Text[
          
          Framed[$CellContext`a6, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 12], 
         Text[
          
          Framed[$CellContext`a13, {
           Background -> RGBColor[1, 1, 0.8], FrameStyle -> 
            RGBColor[0.94, 0.85, 0.36], FrameMargins -> Automatic}], 
          13]}}, {}], 
      VertexCoordinateRules -> {{2.5204017052453995`, 
       0.047566762918297645`}, {2.710485528072843, 1.109467213844454}, {
       2.19056735780271, 2.112084756853589}, {1.2065199149241677`, 
       1.6071153596889034`}, {0.4650206714861995, 1.995523046020941}, {0., 
       0.934279107694042}, {0.6402073915293885, 0.7621535976985391}, {
       0.7051022086486474, 0.}, {1.408909839795017, 0.047133337886437476`}, {
       1.8904246131071645`, 0.23558207307187184`}, {2.203029870107729, 
       1.4543975485934673`}, {1.50780526551756, 2.3889321027749038`}, {
       1.8449900303379148`, 0.885128543209283}}], FrameTicks -> None, 
     PlotRange -> All, PlotRangePadding -> Scaled[0.1], AspectRatio -> 
     Automatic], 
    Graphics[
     Annotation[
      GraphicsComplex[{{2.5204017052453995`, 0.047566762918297645`}, {
       2.710485528072843, 1.109467213844454}, {2.19056735780271, 
       2.112084756853589}, {1.2065199149241677`, 1.6071153596889034`}, {
       0.4650206714861995, 1.995523046020941}, {0., 0.934279107694042}, {
       0.6402073915293885, 0.7621535976985391}, {0.7051022086486474, 0.}, {
       1.408909839795017, 0.047133337886437476`}, {1.8904246131071645`, 
       0.23558207307187184`}, {2.203029870107729, 1.4543975485934673`}, {
       1.50780526551756, 2.3889321027749038`}, {1.8449900303379148`, 
       0.885128543209283}}, {{
         RGBColor[0.5, 0., 0.], 
         Arrowheads[{{0.030163851988336772`, 0.8}}], 
         Arrow[{1, 2}], 
         Arrow[{2, 3}], 
         Arrow[{2, 13}], 
         Arrow[{3, 4}], 
         Arrow[{4, 13}], 
         Arrow[{4, 7}], 
         Arrow[{5, 4}], 
         Arrow[{5, 6}], 
         Arrow[{6, 7}], 
         Arrow[{6, 8}], 
         Arrow[{7, 9}], 
         Arrow[{8, 9}], 
         Arrow[{8, 10}], 
         Arrow[{9, 13}], 
         Arrow[{9, 1}], 
         Arrow[{10, 1}], 
         Arrow[{10, 11}], 
         Arrow[{11, 2}], 
         Arrow[{11, 12}], 
         Arrow[{12, 3}], 
         Arrow[{12, 5}]}, {
         RGBColor[0, 0, 0.7], 
         Tooltip[
          Point[1], $CellContext`a10], 
         Tooltip[
          Point[2], $CellContext`a11], 
         Tooltip[
          Point[3], $CellContext`a12], 
         Tooltip[
          Point[4], $CellContext`a7], 
         Tooltip[
          Point[5], $CellContext`a1], 
         Tooltip[
          Point[6], $CellContext`a2], 
         Tooltip[
          Point[7], $CellContext`a8], 
         Tooltip[
          Point[8], $CellContext`a3], 
         Tooltip[
          Point[9], $CellContext`a9], 
         Tooltip[
          Point[10], $CellContext`a4], 
         Tooltip[
          Point[11], $CellContext`a5], 
         Tooltip[
          Point[12], $CellContext`a6], 
         Tooltip[
          Point[13], $CellContext`a13]}}, {}], 
      VertexCoordinateRules -> {{2.5204017052453995`, 
       0.047566762918297645`}, {2.710485528072843, 1.109467213844454}, {
       2.19056735780271, 2.112084756853589}, {1.2065199149241677`, 
       1.6071153596889034`}, {0.4650206714861995, 1.995523046020941}, {0., 
       0.934279107694042}, {0.6402073915293885, 0.7621535976985391}, {
       0.7051022086486474, 0.}, {1.408909839795017, 0.047133337886437476`}, {
       1.8904246131071645`, 0.23558207307187184`}, {2.203029870107729, 
       1.4543975485934673`}, {1.50780526551756, 2.3889321027749038`}, {
       1.8449900303379148`, 0.885128543209283}}], FrameTicks -> None, 
     PlotRange -> All, PlotRangePadding -> Scaled[0.1], AspectRatio -> 
     Automatic]}]]], "Output",
 ImageSize->{482, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[58]=",
 CellID->961597993]
}, Open  ]],

Cell["\<\
The relationship between vertices and coordinates is given below.\
\>", "MathCaption",
 CellID->564073450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"Rule", "[", 
   RowBox[{
    RowBox[{"VertexList", "[", "g", "]"}], ",", "coords"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1247042406],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"10", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.5204017052453995`", ",", "0.047566762918297645`"}], "}"}]}], 
   ",", 
   RowBox[{"11", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.710485528072843`", ",", "1.109467213844454`"}], "}"}]}], ",", 
   
   RowBox[{"12", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.19056735780271`", ",", "2.112084756853589`"}], "}"}]}], ",", 
   RowBox[{"7", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.2065199149241677`", ",", "1.6071153596889034`"}], "}"}]}], 
   ",", 
   RowBox[{"1", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4650206714861995`", ",", "1.995523046020941`"}], "}"}]}], ",",
    
   RowBox[{"2", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.`", ",", "0.934279107694042`"}], "}"}]}], ",", 
   RowBox[{"8", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.6402073915293885`", ",", "0.7621535976985391`"}], "}"}]}], 
   ",", 
   RowBox[{"3", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.7051022086486474`", ",", "0.`"}], "}"}]}], ",", 
   RowBox[{"9", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.408909839795017`", ",", "0.047133337886437476`"}], "}"}]}], 
   ",", 
   RowBox[{"4", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.8904246131071645`", ",", "0.23558207307187184`"}], "}"}]}], 
   ",", 
   RowBox[{"5", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.203029870107729`", ",", "1.4543975485934673`"}], "}"}]}], ",",
    
   RowBox[{"6", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.50780526551756`", ",", "2.3889321027749038`"}], "}"}]}], ",", 
   
   RowBox[{"13", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.8449900303379148`", ",", "0.885128543209283`"}], "}"}]}]}], 
  "}"}]], "Output",
 ImageSize->{493, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->784038527]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphCoordinates",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"]], 
  "InlineFormula"],
 " only returns the position of the vertices, so when used for ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 ", curved edges will not be reproduced, although multiedges and self-loops \
will still be drawn."
}], "Text",
 CellID->683934603],

Cell[TextData[{
 "This shows the ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " of a directed graph."
}], "MathCaption",
 CellID->1420315704],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellID->49060918],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[59]:=",
 CellID->1327739138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[60]:=",
 CellID->1081758619],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxliHsw1AkAx42eo06uuLytooepSE/C1ymt4fKuOx0hE0XEzEkUNuQx1XQo
TLnOo0h1Rbp0Vn72NMeuRbZYZzttG5Z9+f08dr123d2f3X1mvvOZ78fy5Dn/
U9paWlo+/+xf/wfXzy+Jz/3/fqTHQ/BFfC0SWuxS4+MXMeHXFJXoyAI9ZkKt
eKnBJyY9zmtFBzK13DMu/qmGc0Al41A3DxsZW3S+4i1AkBust57Rjy2S0lvN
FfPgpvlEmhUNotClwirRaw45xi6sR7kinEzd3+DAncHbownPRDPDKK4KPbLa
WgV6Aiu7/s4Y7BrXi2VHp3Fe3DDrXiBFpP9UuPXBKVyVZ6wL9ZbDieURv99q
EtmZG95puhWoW26wdtMshfrAjp8KVpH4Y0MQXcEiUfx03Gosn4TSxoa2Qa1A
rH/aovY8iZ9f5febnpBhn3PSduFhCjnq0QZu1Rgmzw08YSRSeCKxbd7JH0Gl
pDpzKJuCwZVIqdf4JywrX9eak0WhwkxvwVXvI/qz/bJGkihc1AkLin3xHqal
4W1a4RQ6k67NBZXxwRMevNYHCo6Z9wX0QR5mA2d4UfoUcoOOzcYKucifSbvz
fJDE21FHpvfj17jdwR9uukvi4WlqNsK1Efpd2s8YgSQOkC5zJ8gHYH8YTdhz
vwxMnkhwaskiGnJnAz6srYdMd/dYsUINp/s5o5G0FhQ+n9xcxFpAwYCx4S5F
G2pbLUvCLs3Dzv570+jkNzjo1OygMp+Dv+V2a+viXnxjzl59vGYGtY6ZVZ6+
AnDPuH2ZZ6KCNbHDN5YnBMvchp6VOI01ypC8aM8hbHNmPPFqmIRKYLU1gjaC
gVaDQE/mBAwMd8REN4tRZnFzrKmewumHyT4MqzGk+s7HVZaRIAtW9N3zl2Dk
cVH7/JJx/NLD1/A9pNCOWFlY8lSGskgJ22iFDN6tXs5mhyRg+2Ff9HUZ2J1h
bXksMTYV9h1mC2RIzKDvHNw8jN9samf2Tsjg93ExxThJhOlX/cmkUoY9V3Uj
U0s/wGciWGWvJ4eFwYvuWyUDaGtzStA4yxEWprRPE/Ui2OWC2J8hh+ps9429
KT3QPbbmuB1fDk5iBjeV4GBQV5td5KZA4M3iszs2tYJ72nd39u8KGMQ0Lap9
X4IfMXdHc2wcjaeCjJqNqrH6uzUb/daSeHeJa+qiHQJuysIjZgyFoyUHPNpT
ihDPDZ2/0DUBgWXzlTCTAtxKD+rSN5+CkeO2zoLRK8SkTmFDJaZBcn70ZNo+
Jc5LS4akJkqE2waZcBgthHjVKh23ciX2lufGBXA4hKHwhz1Tr5WQOww3Vkl4
xL43d6Ots5RIWn4h5GJoP0HTsOJWDk1jmm1FlQb8RSz1/FYnkZpC3ZkQVk2t
kDB4GeYnJCZh6J1+uM5YRKjiTxp1Rk2gL5WmL+CIiGpbx5p3SymsrHnTtaxe
RHR28ZcII8exeLZlwLj3I2Gvbo8+YSZHRXKesdhNSEg1EeEmwVKMLGzlH3d4
T3i3njGi0SWwyD8UQTPjE9cu61rfmxqDlvevW3Rv9xCuxKuv3WMkcN/NZFS5
tRO9UdWX0sulsLQQP9x6vYmQ0TqK4tPkcLHR1DXsekBcvhG40CcYhzx9u3+T
VyjxN5AjfZY=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.7}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
       21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 3}], 
      ArrowBox[{1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45,
        46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 3}], ArrowBox[{2, 3}], 
      ArrowBox[{3, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
        72, 73, 74, 75, 76, 77, 78, 79, 3}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3]}}],
   Annotation[#, VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{123, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[60]=",
 CellID->1988216243]
}, Open  ]],

Cell["This finds the vertex coordinates of the previous plot.", "MathCaption",
 CellID->461662465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coord", "=", 
  RowBox[{"GraphCoordinates", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Method", "\[Rule]", "\"\<LayeredDigraphDrawing\>\""}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[61]:=",
 CellID->10859885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "2.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[61]=",
 CellID->1045251399]
}, Open  ]],

Cell["\<\
This shows that the curved edges between vertices 1 and 3 are not reproduced.\
\
\>", "MathCaption",
 CellID->2024933293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", "coord"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[62]:=",
 CellID->813684022],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{130, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[62]=",
 CellID->14869616]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options for GraphCoordinates and GraphCoordinates3D", "Subsubsection",
 CellTags->"b:0.2",
 CellID->50339381],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphCoordinates",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphCoordinates3D",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates3D"]], 
  "InlineFormula"],
 " accept the same options as",
 ButtonBox[" ",
  BaseStyle->"RefGuideLinkText",
  ButtonData:>{
   "Advanced Documentation: GraphPlot: GraphPlot and GraphPlot3D", 
    "Options_for_GraphPlot"}],
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.2",
 CellID->375106804]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GraphDistance, GraphPath, GraphDistanceMatrix", "Subsection",
 CellID->1713104521],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GraphDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/GraphDistance"], "[", 
     RowBox[{
      StyleBox["g", "TI"], ",", 
      StyleBox["start", "TI"], ",", 
      StyleBox["end", "TI"]}], "]"}], Cell[TextData[{
     "gives the distance from vertex ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to vertex ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " in the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphPath",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/GraphPath"], "[", 
     RowBox[{
      StyleBox["g", "TI"], ",", 
      StyleBox["start", "TI"], ",", 
      StyleBox["end", "TI"]}], "]"}], Cell[TextData[{
     "finds a shortest path between vertices ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["end", "TI"]], "InlineFormula"],
     " in graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphDistanceMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/GraphDistanceMatrix"], "[", 
     StyleBox["g", "TI"], "]"}], Cell[TextData[{
     "gives a matrix in which the ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], ")"}]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " ",
     "entry is the length of a shortest path in ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " between vertices ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphDistanceMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/GraphDistanceMatrix"], "[", 
     RowBox[{
      StyleBox["g", "TI"], ",", "Parent"}], "]"}], Cell[TextData[{
     "returns a three-dimensional matrix in which the ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{"1", ",", 
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], ")"}]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry is the length of a shortest path from ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " and the ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{"2", ",", 
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], ")"}]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry is the predecessor of ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " in a shortest path from ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     "."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->369537956],

Cell["\<\
Finding shortest distance, shortest path, and all-pairs shortest distances \
and paths.\
\>", "Caption",
 CellID->301719368],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphDistance"]], "InlineFormula"],
 " returns the graph distance from one vertex to another. ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " is returned if no path exists from ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 ". By default every edge is assumed to have an edge weight of 1."
}], "Text",
 CellID->1878198478],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPath",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphPath"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphDistanceMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphDistanceMatrix"]], 
  "InlineFormula"],
 " find shortest path and all-pairs shortest paths."
}], "Text",
 CellID->1263057935],

Cell["This shows a dodecahedron in two dimensions.", "MathCaption",
 CellTags->"b:0.4",
 CellID->1138998977],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "10"}], ",", 
     RowBox[{"1", "\[Rule]", "11"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "18"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "12"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "19"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "13"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"6", "\[Rule]", "20"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"7", "\[Rule]", "14"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"8", "\[Rule]", "16"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}], ",", 
     RowBox[{"9", "\[Rule]", "15"}], ",", 
     RowBox[{"10", "\[Rule]", "17"}], ",", 
     RowBox[{"11", "\[Rule]", "15"}], ",", 
     RowBox[{"11", "\[Rule]", "12"}], ",", 
     RowBox[{"12", "\[Rule]", "13"}], ",", 
     RowBox[{"13", "\[Rule]", "14"}], ",", 
     RowBox[{"14", "\[Rule]", "15"}], ",", 
     RowBox[{"16", "\[Rule]", "20"}], ",", 
     RowBox[{"16", "\[Rule]", "17"}], ",", 
     RowBox[{"17", "\[Rule]", "18"}], ",", 
     RowBox[{"18", "\[Rule]", "19"}], ",", 
     RowBox[{"19", "\[Rule]", "20"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[98]:=",
 CellID->538061090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[72]:=",
 CellID->1308540579],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.7147905824004743`, 2.8561701021208226`}, {
    3.254468406279015, 1.9118832707972013`}, {2.1588120504193133`, 
    2.6538503759139416`}, {1.6242776120956737`, 2.9358110219988385`}, {
    2.5319968949225182`, 1.236360279903744}, {3.256895522000315, 
    1.0307478139648618`}, {2.165660030322879, 0.27897864327440147`}, {
    1.6273030773879185`, 1.8826830550817475`}, {1.0978086240919154`, 
    0.27723374355094665`}, {2.7227506274003774`, 0.08344575666567544}, {
    0.5416325276274312, 0.07745068699192958}, {0.7258669585339056, 
    1.2328244488018065`}, {0.0023086154902249856`, 1.0214732058710883`}, {
    1.6325115941516066`, 0.}, {0.7240612960333823, 1.6956233894460109`}, {0., 
    1.9031528229996784`}, {1.091533851309919, 2.6507665990498688`}, {
    1.628797321582606, 1.051439930403241}, {0.5347885113273745, 
    2.8507986468436854`}, {2.5301469568849573`, 1.7003648702260268`}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.02795376099302155, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{1, 4}], ArrowBox[{2, 5}], 
      ArrowBox[{2, 6}], ArrowBox[{3, 20}], ArrowBox[{4, 19}], 
      ArrowBox[{4, 8}], ArrowBox[{5, 7}], ArrowBox[{5, 8}], ArrowBox[{6, 10}],
       ArrowBox[{7, 9}], ArrowBox[{7, 10}], ArrowBox[{8, 12}], 
      ArrowBox[{9, 11}], ArrowBox[{9, 12}], ArrowBox[{10, 14}], 
      ArrowBox[{11, 13}], ArrowBox[{11, 14}], ArrowBox[{12, 16}], 
      ArrowBox[{13, 15}], ArrowBox[{13, 16}], ArrowBox[{15, 17}], 
      ArrowBox[{15, 18}], ArrowBox[{16, 19}], ArrowBox[{17, 3}], 
      ArrowBox[{17, 19}], ArrowBox[{18, 14}], ArrowBox[{18, 20}], 
      ArrowBox[{20, 6}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["18",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["19",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["13",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["20",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15], InsetBox[
       FrameBox["14",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 16], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 17], InsetBox[
       FrameBox["16",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 18], InsetBox[
       FrameBox["15",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 19], InsetBox[
       FrameBox["17",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 20]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.7147905824004743`, 2.8561701021208226`}, {
     3.254468406279015, 1.9118832707972013`}, {2.1588120504193133`, 
     2.6538503759139416`}, {1.6242776120956737`, 2.9358110219988385`}, {
     2.5319968949225182`, 1.236360279903744}, {3.256895522000315, 
     1.0307478139648618`}, {2.165660030322879, 0.27897864327440147`}, {
     1.6273030773879185`, 1.8826830550817475`}, {1.0978086240919154`, 
     0.27723374355094665`}, {2.7227506274003774`, 0.08344575666567544}, {
     0.5416325276274312, 0.07745068699192958}, {0.7258669585339056, 
     1.2328244488018065`}, {0.0023086154902249856`, 1.0214732058710883`}, {
     1.6325115941516066`, 0.}, {0.7240612960333823, 1.6956233894460109`}, {0.,
      1.9031528229996784`}, {1.091533851309919, 2.6507665990498688`}, {
     1.628797321582606, 1.051439930403241}, {0.5347885113273745, 
     2.8507986468436854`}, {2.5301469568849573`, 1.7003648702260268`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[72]=",
 CellID->1797456440]
}, Open  ]],

Cell["\<\
This shows that the distance between vertices 7 and 18 is 4, and gives the \
path.\
\>", "MathCaption",
 CellID->1615198124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"g", ",", "7", ",", "18"}], "]"}]], "Input",
 CellLabel->"In[87]:=",
 CellID->712567211],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[87]=",
 CellID->1586572525]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", " ", "7", ",", " ", "18"}], "]"}]], "Input",
 CellLabel->"In[90]:=",
 CellID->1626891699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "8", ",", "16", ",", "17", ",", "18"}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[90]=",
 CellID->1445376542]
}, Open  ]],

Cell["This shows that there is no path from vertices 7 to 6.", "MathCaption",
 CellID->1741794910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"g", ",", "7", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[76]:=",
 CellID->1136393314],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[76]=",
 CellID->1517243017]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", " ", "7", ",", " ", "6"}], "]"}]], "Input",
 CellLabel->"In[91]:=",
 CellID->259176196],

Cell[BoxData[
 RowBox[{"{", "6", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[91]=",
 CellID->1316360995]
}, Open  ]],

Cell["This finds the distances between all vertices.", "MathCaption",
 CellID->1518893238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphDistanceMatrix", "[", "g", "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[93]:=",
 CellID->513117130],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{332, 297},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[93]//MatrixForm=",
 CellID->85465418]
}, Open  ]],

Cell["This defines a simple directed graph.", "MathCaption",
 CellID->1973623475],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2."}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[95]:=",
 CellID->1060781549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", "0.1"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#2", "]"}], ",", 
             RowBox[{"Last", "[", "#2", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[96]:=",
 CellID->285926919],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{
       ArrowBox[{{1.2893252649072984`, 1.548560010632206}, {
        1.6177537479398778`, 0.6043445040753127}}, 0.1], 
       InsetBox["1.`", {1.453539506423588, 1.0764522573537594`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.2893252649072984`, 1.548560010632206}, {
        0.2886834314369662, 1.5275030724880767`}}, 0.1], 
       InsetBox["1.`", {0.7890043481721323, 1.5380315415601413`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.6177537479398778`, 0.6043445040753127}, {
        0.8211445524088133, 0.}}, 0.1], 
       InsetBox["1.`", {1.2194491501743456`, 0.30217225203765635`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 0.5703652293377319}, {0.8211445524088133, 0.}}, 0.1], 
       InsetBox["1.`", {0.41057227620440667`, 0.28518261466886596`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0.2886834314369662, 1.5275030724880767`}, {0., 
        0.5703652293377319}}, 0.1], InsetBox[
        RowBox[{"-", "2.`"}], {0.1443417157184831, 1.0489341509129044`},
        Background->GrayLevel[1]]}}, 
     GraphicsComplexBox[{{1.2893252649072984`, 1.548560010632206}, {
      1.6177537479398778`, 0.6043445040753127}, {0.8211445524088133, 0.}, {0.,
       0.5703652293377319}, {0.2886834314369662, 
      1.5275030724880767`}}, {InsetBox[
        FrameBox["1",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 1], InsetBox[
        FrameBox["2",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 2], InsetBox[
        FrameBox["3",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 3], InsetBox[
        FrameBox["4",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 4], InsetBox[
        FrameBox["5",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 5]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2893252649072984`, 1.548560010632206}, {
     1.6177537479398778`, 0.6043445040753127}, {0.8211445524088133, 0.}, {0., 
     0.5703652293377319}, {0.2886834314369662, 1.5275030724880767`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{211., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{215, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[96]=",
 CellID->195791831]
}, Open  ]],

Cell["This calculates distance between vertices.", "MathCaption",
 CellID->9961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphDistanceMatrix", "[", "g", "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[79]:=",
 CellID->491],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.`", "1.`", "0.`", 
      RowBox[{"-", "1.`"}], "1.`"},
     {"\[Infinity]", "0.`", "1.`", "\[Infinity]", "\[Infinity]"},
     {"\[Infinity]", "\[Infinity]", "0.`", "\[Infinity]", "\[Infinity]"},
     {"\[Infinity]", "\[Infinity]", "1.`", "0.`", "\[Infinity]"},
     {"\[Infinity]", "\[Infinity]", 
      RowBox[{"-", "1.`"}], 
      RowBox[{"-", "2.`"}], "0.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{142, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[79]//MatrixForm=",
 CellID->1926863129]
}, Open  ]],

Cell[TextData[{
 "This shows also the predecessors in the shortest path, for example, the \
path from 1 to 3 has predecessor 4 (",
 Cell[BoxData[
  RowBox[{"prd", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "3"}], "]"}], "]"}]], "InlineFormula"],
 "), the path from 1 to 4 has predecessor 5 (",
 Cell[BoxData[
  RowBox[{"prd", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "4"}], "]"}], "]"}]], "InlineFormula"],
 "), and therefore the path from 1 to 3 is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "5", ",", "4", ",", "3"}], "}"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->11942],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"prd", "=", 
   RowBox[{
    RowBox[{"GraphDistanceMatrix", "[", 
     RowBox[{"g", ",", "Parent"}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"prd", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[80]:=",
 CellID->1037634306],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "4", "5", "1"},
     {"1", "2", "2", "4", "5"},
     {"1", "2", "3", "4", "5"},
     {"1", "2", "4", "4", "5"},
     {"1", "2", "4", "5", "5"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[81]//MatrixForm=",
 CellID->1749301989]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Drop", "[", 
   RowBox[{
    RowBox[{"FixedPointList", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"prd", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "#"}], "]"}], "]"}], "&"}], ",", "3"}], "]"}], ",",
     
    RowBox[{"-", "1"}]}], "]"}], "//", "Reverse"}]], "Input",
 CellLabel->"In[82]:=",
 CellID->1812294677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[82]=",
 CellID->275082077]
}, Open  ]],

Cell["This confirms the shortest path.", "MathCaption",
 CellID->751001782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[97]:=",
 CellID->732872013],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[97]=",
 CellID->2005443550]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithms for shortest paths", "Subsubsection",
 CellID->1755373314],

Cell[TextData[{
 "In the following it is assumed that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"w", "(", 
    RowBox[{"i", ",", "j"}], ")"}], TraditionalForm]]],
 " is the edge weight of edge ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"i", ",", " ", "j"}], "}"}], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "(", 
    RowBox[{"i", ",", "j"}], ")"}], TraditionalForm]]],
 " is the current estimate of the length of the shortest path from vertex ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 " to vertex ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]]],
 "."
}], "Text",
 CellID->182433279],

Cell[CellGroupData[{

Cell["Single source shortest path algorithms", "Subsubsubsection",
 CellID->516083380],

Cell[TextData[{
 "Single source shortest path algorithms find the shortest path from one \
vertex ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]]],
 " to all other vertices. "
}], "Text",
 CellID->1302040693],

Cell[TextData[{
 StyleBox["Dijkstra's algorithm",
  FontWeight->"Bold"],
 " assumes that edge weights are non-negative. "
}], "Text",
 CellID->319815696],

Cell["Denote", "Text",
 CellID->117624113],

Cell[TextData[{
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 ": the set of vertices whose shortest distance to ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]]],
 " has been found.\n",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 ": the set of vertices not in ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " that ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " \"touches\", stored in a heap."
}], "Text",
 CellID->1613350403],

Cell["The algorithm, then:", "Text",
 CellID->275122147],

Cell[TextData[{
 "(1) picks in ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 " the vertex ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 " with the smallest ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]]],
 " value. This step has complexity ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"O", "(", 
     RowBox[{"Log", "[", 
      RowBox[{"|", "V", "|"}], "]"}], ")"}], " "}], TraditionalForm]]],
 "with a binary heap or with a Fibonacci heap, and in all cases it will be \
repeated |V| times."
}], "Text",
 CellID->1872685855],

Cell[TextData[{
 "(2) places vertex ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 " in ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 ", inserts all neighbors ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]]],
 " of ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", ","}], TraditionalForm]]],
 " if vertex ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]]],
 " is not in ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", "[", "j", "]"}], " ", ">", " ", 
    RowBox[{
     RowBox[{"d", "[", "i", "]"}], " ", "+", " ", 
     RowBox[{"w", "[", 
      RowBox[{"i", ",", "j"}], "]"}]}]}], TraditionalForm]]],
 ", it sets ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", "[", "j", "]"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"d", "[", "i", "]"}], " ", "+", " ", 
     RowBox[{"w", "[", 
      RowBox[{"i", ",", "j"}], "]"}]}]}], TraditionalForm]]],
 " and updates the heap. Each insertion/update to the heap has complexity ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", 
    RowBox[{"(", 
     RowBox[{"Log", "[", 
      RowBox[{"|", "V", "|"}], "]"}], ")"}]}], TraditionalForm]]],
 " with a binary heap, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", 
    RowBox[{"(", "1", ")"}]}], TraditionalForm]]],
 " with a Fibonacci heap, and in all, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "E", "|"}], TraditionalForm]]],
 " update operations and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "V", "|", " "}], TraditionalForm]]],
 "insertions are needed."
}], "Text",
 CellID->710834553],

Cell[TextData[{
 "So the overall complexity is",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"|", "V", "|", 
         RowBox[{"+", 
          RowBox[{"|", "E", "|"}]}]}], ")"}], " ", "Log"}], "|", "V", "|"}], 
     ")"}]}], TraditionalForm]]],
 " with a binary heap, and",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"O", "(", 
     RowBox[{"|", "V", "|", " ", "Log", " ", "|", "V", "|", 
      RowBox[{"+", 
       RowBox[{"|", "E", "|", " ", 
        RowBox[{"+", " ", 
         RowBox[{"|", "V", "|"}]}]}]}]}], ")"}]}], TraditionalForm]]],
 " with a Fibonacci heap."
}], "Text",
 CellID->1069431564],

Cell[TextData[{
 "The ",
 StyleBox["Bellman-Ford",
  FontWeight->"Bold"],
 ":",
 " ",
 "algorithm works even if edge weights are negative. It works by looping \
through each edge ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"i", ",", " ", "j"}], "}"}], TraditionalForm]]],
 ", if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", "[", "j", "]"}], " ", ">", " ", 
    RowBox[{
     RowBox[{"d", "[", "i", "]"}], " ", "+", " ", 
     RowBox[{"w", "[", 
      RowBox[{"i", ",", "j"}], "]"}]}]}], TraditionalForm]]],
 ", set ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", "[", "j", "]"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"d", "[", "i", "]"}], " ", "+", " ", 
     RowBox[{"w", "[", 
      RowBox[{"i", ",", "j"}], "]"}]}]}], TraditionalForm]]],
 ". Since this looping is carried out",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "V", "|", 
    RowBox[{"-", "1"}]}], TraditionalForm]]],
 " times, the Bellman-Ford algorithm has a complexity of ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{"O", "(", 
      RowBox[{"|", 
       RowBox[{"E", "||", "V"}], "|"}], ")"}], ","}]}], TraditionalForm]]],
 "which is much higher than Dijkstra's algorithm. Therefore it is only used \
if the graph contains negative weights. The algorithm can detect negative \
weight cycles."
}], "Text",
 CellID->139072023]
}, Open  ]],

Cell[CellGroupData[{

Cell["All-pairs shortest path algorithms", "Subsubsubsection",
 CellID->1598301965],

Cell["\<\
All-pairs shortest path algorithms find shortest paths between all vertex \
pairs.\
\>", "Text",
 CellID->1123871519],

Cell[TextData[{
 "The ",
 StyleBox["Floyd-Warshall ",
  FontWeight->"Bold"],
 "algorithm sets all distances to \[Infinity] initially, except for \
neighboring vertices, for which the distance is set to the edge weights. It \
then loops over all vertex pairs ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"i", ",", " ", "j"}], "}"}], TraditionalForm]]],
 ", and relaxes if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", "[", 
     RowBox[{"i", ",", "j"}], "]"}], " ", "<", " ", 
    RowBox[{
     RowBox[{"d", "[", 
      RowBox[{"i", ",", "k"}], "]"}], " ", "+", " ", 
     RowBox[{"d", "[", 
      RowBox[{"k", ",", "j"}], "]"}]}]}], TraditionalForm]]],
 ", in which case it sets ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{"d", "[", 
      RowBox[{"i", ",", "j"}], "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"d", "[", 
       RowBox[{"i", ",", "k"}], "]"}], " ", "+", " ", 
      RowBox[{"d", "[", 
       RowBox[{"k", ",", "j"}], "]"}]}]}]}], TraditionalForm]]],
 ". This is so that at any iteration ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]]],
 ", the distance ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "[", 
    RowBox[{"i", ",", "j"}], "]"}], TraditionalForm]]],
 " represents the shortest distance between vertices ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]]],
 ", passing through only vertices ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", ",", "2", ",", "...", ",", " ", 
    RowBox[{"k", "."}]}], TraditionalForm]]],
 " This algorithm has a complexity of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", "(", 
    RowBox[{"|", "V", 
     SuperscriptBox["|", "3"]}], ")"}], TraditionalForm]]],
 ". It works even for negative weights, but does not detect negative weight \
cycles."
}], "Text",
 CellID->364490271],

Cell[TextData[{
 "If the edge weights are nonnegative, the ",
 Cell[BoxData[
  FormBox[
   StyleBox["Dijkstra",
    FontWeight->"Bold"], TraditionalForm]]],
 " algorithm can be applied repeatedly to each vertex, for single source \
shortest paths. This gives a complexity of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"|", "V", "|", 
        RowBox[{"+", 
         RowBox[{"|", "E", "|"}]}]}], ")"}], " ", "|", "V", "|", " ", "Log", 
      "|", "V", "|"}], ")"}]}], TraditionalForm]]],
 " with a binary heap, and",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"O", "(", 
     RowBox[{"|", "V", 
      SuperscriptBox["|", "2"], " ", "Log", " ", "|", "V", "|", 
      RowBox[{"+", 
       RowBox[{"|", 
        RowBox[{"E", "||", "V"}], "|"}]}]}], ")"}]}], TraditionalForm]]],
 " with a Fibonacci heap."
}], "Text",
 CellID->1488651201],

Cell[TextData[{
 "If there are negative edge weights, then Dijkstra algorithm can not be \
applied directly. The ",
 StyleBox["Johnson",
  FontWeight->"Bold"],
 " algorithm first makes all edge weights positive, by associating a value ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "[", "i", "]"}], TraditionalForm]]],
 " to every vertex ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 ", such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"i", ",", "j"}], "]"}], " ", "+", " ", 
     RowBox[{"p", "[", "i", "]"}], "-", 
     RowBox[{"p", "[", "j", "]"}]}], " ", "\[GreaterEqual]", " ", "0"}], 
   TraditionalForm]]],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "\[RightArrow]", "j"}], TraditionalForm]]],
 ". The edge weights are then modified by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"i", ",", "j"}], "]"}], " ", ":=", " ", 
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"i", ",", "j"}], "]"}], " ", "+", " ", 
     RowBox[{"p", "[", "i", "]"}], "-", 
     RowBox[{"p", "[", "j", "]"}]}]}], TraditionalForm]]],
 "."
}], "Text",
 CellID->976081803],

Cell[TextData[{
 "To modify the edge weights, a virtual vertex ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]]],
 " is added that is linked to every vertex, with an edge weight of 0. Then \
for any vertex ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "[", "i", "]"}], TraditionalForm]]],
 " is defined as the distance of ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]]],
 " to ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 ". So for every edge ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"i", ",", "j"}], "}"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"p", "[", "j", "]"}], " ", "\[LessEqual]", " ", 
    RowBox[{
     RowBox[{"p", "[", "i", "]"}], "+", " ", 
     RowBox[{"w", "[", 
      RowBox[{"i", ",", "j"}], "]"}]}]}], TraditionalForm]]],
 ", otherwise ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "[", "j", "]"}], TraditionalForm]]],
 " is not the length of a true shortest path. Hence ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"i", ",", "j"}], "]"}], " ", "+", " ", 
     RowBox[{"p", "[", "i", "]"}], " ", "-", " ", 
     RowBox[{"p", "[", "j", "]"}]}], " ", "\[GreaterEqual]", " ", "0"}], 
   TraditionalForm]]],
 "."
}], "Text",
 CellID->2071651024],

Cell[TextData[{
 "This modification does not change the shortest path, hence the Dijkstra \
algorithm can then be applied to the weight\[Hyphen]modified graph. After \
that, the distance is modified back by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", "[", 
     RowBox[{"i", ",", "j"}], "]"}], ":=", " ", 
    RowBox[{
     RowBox[{"d", "[", 
      RowBox[{"i", ",", "j"}], "]"}], "+", 
     RowBox[{"p", "[", "j", "]"}], "-", 
     RowBox[{
      RowBox[{"p", "[", "i", "]"}], "."}]}]}], TraditionalForm]]]
}], "Text",
 CellID->358487948],

Cell["\<\
The Johnson algorithm has the same complex as the Dijkstra algorithm when \
edge weights are nonnegative, otherwise it has the same complexity as the \
Bellman-Ford algorithm.\
\>", "Text",
 CellID->1100681814]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Options for GraphPath, GraphDistanceMatrix, and GraphDistance\
\>", "Subsubsection",
 CellTags->"b:0.10b",
 CellID->2045394960],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    StyleBox[
     ButtonBox["Method",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Method"],
     FontFamily->"Courier"], 
    StyleBox[
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], "MR"], Cell[
    "algorithm to find shortest paths", "TableText"]},
   {
    StyleBox[
     ButtonBox["Weighted",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/Weighted"],
     FontFamily->"Courier"], 
    StyleBox[
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "MR"], Cell[
    "whether edge weight is used in calculating shortest paths", 
     "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.10b",
 CellID->356755035],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["GraphPath",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphPath"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphDistanceMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphDistanceMatrix"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:0.10b",
 CellID->1275994674],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    StyleBox[
     ButtonBox["Weighted",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/Weighted"],
     FontFamily->"Courier"], 
    StyleBox[
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], "MR"], Cell[
    "whether edge weight is used in calculating shortest paths", 
     "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.10b",
 CellID->764686970],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["GraphDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphDistance"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:0.10b",
 CellID->2004897033],

Cell[CellGroupData[{

Cell["Method", "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->1459351349],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " specifies the algorithm use to find the shortest paths. By default ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", which uses Johnson's algorithm. Other possible values for this option are \
",
 Cell[BoxData["\"\<BellmanFord\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Dijkstra\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<FloydWarshall\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<Johnson\>\""], "InlineFormula"],
 "."
}], "Text",
 CellID->1320311085]
}, Open  ]],

Cell[CellGroupData[{

Cell["Weighted", "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->478024011],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["Weighted",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/Weighted"]], "InlineFormula"],
 " specifies whether edge weights are to be taken into account when finding \
shortest paths. Possible values are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1964617688]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GraphEdit", "Subsection",
 CellID->1709138021],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{
       ButtonBox["GraphEdit",
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/GraphEdit"], "[", "]"}], "MR"],
      Cell[TextData[StyleBox["interactively create and edit a graph",
      FontFamily->"Verdana",
      FontSize->10]], "Text"]},
    {
     RowBox[{
      RowBox[{
       StyleBox[
        ButtonBox[
         StyleBox["GraphEdit", "MR"],
         BaseStyle->"Link",
         ButtonData->"paclet:GraphUtilities/ref/GraphEdit"], "MR"], 
       StyleBox["[", "MR"], 
       StyleBox["g", "TI"], 
       StyleBox["]", "MR"]}], " "}], Cell[TextData[{
      "interactively edit the graph ",
      Cell[BoxData[
       StyleBox["g", "TI"]], "InlineFormula"]
     }], "Text",
      FontFamily->"Verdana",
      FontSize->10]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.1",
 CellID->1728316411],

Cell["Interactive graph editing.", "Caption",
 CellTags->"b:0.11",
 CellID->1663227580],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphEdit",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphEdit"]], "InlineFormula"],
 " is a ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " application. On executing this function, a Java window will be opened. \
Users can then enter a new graph or modify an existing graph, and get the \
resulting graph back in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->1956637088],

Cell[TextData[{
 "The graph ",
 StyleBox["g", "TI"],
 " may be specified by a rule list, an adjacency matrix, or the ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " representation of a graph. "
}], "Text",
 CellID->7376],

Cell["\<\
Vertices and edges can be added by clicking and dragging with the mouse. \
Vertices can be moved after setting \"Drawing mode\" to \"Move\" and dragging \
the mouse on the vertices. Vertices can be deleted after setting \"Drawing \
mode\" to \"Delete\" and selecting the vertices to be deleted by clicking.\
\>", "Text",
 CellID->2113717424],

Cell[TextData[{
 "Users can hold the ",
 StyleBox["Ctrl", "KeyEvent"],
 " key and click the vertex (using the first mouse button) in the GraphEdit \
window to edit the vertex labels."
}], "Text",
 CellID->96223269],

Cell["\<\
On closing the window, a drawing of the graph, a representation of the graph \
as a list of rules, the coordinates, and the vertex labels are returned.\
\>", "Text",
 CellID->296616681]
}, Open  ]],

Cell[CellGroupData[{

Cell["LineScaledCoordinate", "Subsection",
 CellID->1375416274],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{
       ButtonBox["LineScaledCoordinate",
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/LineScaledCoordinate"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["k", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["k", "TI"]]}], "}"}]}], "}"}], ",", " ", 
        StyleBox["r", "TI"]}], "]"}],
      FontFamily->"Courier"], 
     RowBox[{
      RowBox[{
      "gives", " ", "the", " ", "coordinate", " ", "of", " ", "a", " ", 
       "point", " ", "in", " ", "the", " ", "polyline", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["k", "TI"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["k", "TI"]]}], "}"}]}], "}"}]}], ",", 
      RowBox[{
      "at", " ", "a", " ", "scaled", " ", "distance", " ", "of", " ", 
       StyleBox["r", "TI"], 
       StyleBox[" ", "TI"], "from", " ", "point", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]]}], "}"}]}]}]},
    {
     StyleBox[
      RowBox[{
       ButtonBox["LineScaledCoordinate",
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/LineScaledCoordinate"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["k", "TI"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["k", "TI"]]}], "}"}]}], "}"}], "]"}],
      FontFamily->"Courier"], 
     RowBox[{"equivalent", " ", "to", " ", 
      RowBox[{
       StyleBox["LineScaledCoordinate", "InlineCode"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["k", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["k", "TI"]]}], "}"}]}], "}"}], ",", " ", 
        StyleBox["0.5", "InlineCode"]}], "]"}]}]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.3",
 CellID->1079773270],

Cell["Finding the coordinates of a point on a polyline.", "Caption",
 CellTags->"b:0.3",
 CellID->1774220843],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LineScaledCoordinate",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/LineScaledCoordinate"]], 
  "InlineFormula"],
 " is often used in conjunction with the ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 ", to add text or graphics along the edge of a graph."
}], "Text",
 CellID->1815893747],

Cell["\<\
This display the vertices that form the edges 60% along the arrow.\
\>", "MathCaption",
 CellID->682788706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", "#1", "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", 
          RowBox[{"LineScaledCoordinate", "[", 
           RowBox[{"#1", ",", "0.6"}], "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->986285025],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{ArrowBox[{{0., 1.}, {1., 0.}}], InsetBox[
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], {0.6, 0.4},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 1.}, {-0.025746437496366743`, 
        1.1029857499854667`}, {-0.03215737675792646, 
        1.1306803512803836`}, {-0.03759536161226607, 
        1.158582311853501}, {-0.042053732367951145`, 
        1.1866574612441039`}, {-0.04552702902935305, 
        1.2148714168937766`}, {-0.04801099798329617, 
        1.2431896262534037`}, {-0.04950259720829479, 
        1.2715774090983496`}, {-0.050000000000000044`, 
        1.3000000000000007`}, {-0.050000000000000044`, 
        1.7000000000000002`}, {-0.049502597208294766`, 
        1.7284225909016513`}, {-0.04801099798329613, 
        1.7568103737465972`}, {-0.04552702902935298, 
        1.785128583106224}, {-0.042053732367951055`, 
        1.813342538755897}, {-0.03759536161226596, 
        1.8414176881464999`}, {-0.03215737675792633, 
        1.869319648719617}, {-0.025746437496366587`, 1.897014250014534}, {0., 
        2.}}], InsetBox[
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], {-0.050000000000000044`, 1.6010287763275026`},
        
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 1.}, {0.0017105178787790423`, 0.9956797249985594}, {
        0.021208373809263676`, 0.9142090936446657}, {0.01708297603814942, 
        0.8305394381397095}, {-0.01033477157261007, 
        0.7513820172933944}, {-0.05884565355972128, 
        0.6830861573316037}, {-0.12455854497307363`, 
        0.631129963656692}, {-0.2022025238906468, 
        0.5996809144352067}, {-0.2855496593572316, 
        0.591261581409205}, {-0.36791456234154957`, 
        0.6065472909273086}, {-0.44269063003846376`, 
        0.6443119550840898}, {-0.5038799706190041, 
        0.7015264179270335}, {-0.5465745024309547, 
        0.7736014282457723}, {-0.5673496380176103, 
        0.8547557497600579}, {-0.5645389750149683, 
        0.9384798820790825}, {-0.5383679605905084, 
        1.0180581967325273`}, {-0.4909358080140239, 
        1.0871076070200096`}, {-0.4260471158573743, 
        1.1400895642251518`}, {-0.34890669588007134`, 
        1.1727543122696913`}, {-0.2657020878781428, 
        1.1824817665272764`}, {-0.18310724855776733`, 
        1.168491674435754}, {-0.10774722423567096`, 
        1.1319062006345164`}, {-0.045666746709527514`, 
        1.0756599165864666`}, {-0.0018453769586838946`, 1.004264414541535}, {
        0., 1.}}], InsetBox[
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], {-0.559014444647902, 0.9552783450172263},
        
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 2.}, {0.04835996651265902, 1.951640033487341}, {
        0.10455097716174719`, 1.8954490228382528`}, {0.16857303194726453`, 
        1.8314269680527355`}, {0.24042613086921105`, 1.759573869130789}, {
        0.32011027392758673`, 1.6798897260724133`}, {0.4076254611223915, 
        1.5923745388776085`}, {0.5029716924536255, 1.4970283075463744`}, {
        0.6061489679212887, 1.3938510320787112`}, {0.717157287525381, 
        1.282842712474619}, {0.7765193382916591, 1.2185423901034025`}, {
        0.8288976183795514, 1.1513492952006954`}, {0.8742921277890582, 
        1.0812634277664972`}, {0.9127028665201793, 1.0082847878008083`}, {
        0.9441298345729148, 0.9324133753036284}, {0.9685730319472645, 
        0.8536491902749577}, {0.9860324586432286, 0.771992232714796}, {
        0.9965081146608071, 0.6874425026231434}, {1., 0.6}, {1., 
        0.5135802469135802}, {1., 0.43209876543209874`}, {1., 
        0.3555555555555555}, {1., 0.2839506172839506}, {1., 
        0.21728395061728392`}, {1., 0.15555555555555553`}, {1., 
        0.09876543209876541}, {1., 0.04691358024691357}, {1., 0.}}], 
       InsetBox[
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], {0.9399975019811208, 0.9423897086909738},
        
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 2.}, {0.025746437496366743`, 1.8970142500145335`}, {
        0.03215737675792646, 1.8693196487196166`}, {0.03759536161226607, 
        1.8414176881464992`}, {0.042053732367951145`, 1.8133425387558963`}, {
        0.04552702902935305, 1.7851285831062236`}, {0.04801099798329617, 
        1.7568103737465965`}, {0.04950259720829479, 1.7284225909016506`}, {
        0.050000000000000044`, 1.6999999999999995`}, {0.050000000000000044`, 
        1.3}, {0.049502597208294766`, 1.271577409098349}, {
        0.04801099798329613, 1.243189626253403}, {0.04552702902935298, 
        1.2148714168937762`}, {0.042053732367951055`, 1.1866574612441032`}, {
        0.03759536161226596, 1.1585823118535004`}, {0.03215737675792633, 
        1.1306803512803831`}, {0.025746437496366587`, 1.1029857499854663`}, {
        0., 1.}}], InsetBox[
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], {0.050000000000000044`, 1.3989712236724974`},
        
        Background->GrayLevel[1]]}}, GraphicsComplexBox[CompressedData["
1:eJxt1AtQVFUABuDFAlESgkF5hQwIgkYPgV1GAn5eg9DwUGAJSRAUghEJwYIC
0qx4yUNo5R0kIQJOhRqkgM6JJYSMRxkuxaOFXUBeu8AFsXgZ1GGdms6cO3f+
M3fuPWfm/p/+sSiv0E0sFou7dq3f/z1m8J8Fu/9f38gz4NsZmjoHFBElJ/6x
7opZuFixPpbGXiJGV2sOOGkwyHHgyH2DcnLcxKw4M41BhOi4tmpqBanIrk/N
WGYgfyel8JBnJcmPvbtJ99QcXFOOfj9ysYoImyw7tYfnkORonBrmV00uZ13J
DPabx6XC9VFNfmpfH0+zhfn6WMJH9Pmg6MMxpZVLcKTvM7Jt2zeis4yl2/98
72Ta/hXRhWUE0v0cjXKOO/3MCs7R/Zb1dITExK6ATc/zO/fgrcaxFeTS8/7R
aFPyov8q4vQ8895WOAJrDfmG4v5pJMlfEVbczEWrzkCkub0EnL5iXfMzOdhk
VBzdypvAPON9IXRvEllJELl5KY2Bv6SV8Kz+1yR3wOHDnr4RaDVplqiKCVFr
fynO0mwYgrryupahH4ivTvTmvFfF0L+mrh7jfJ/UqkeHl0yKcLPaNmk8vYfE
etsNPAgXI+t6troSt59E2s9oW5QOozUoQNymN0g4vW0pD2NGMZVX0JX2wRDR
S/doe6NpDKQvN7LBWEROm403mPhPIp4TtLX2eREpff+VBQVFKTROrEZ7Wg0R
V3vnkMeuMyhtWpA/EyEk4l0c5l7ILHaHva73plMf2dKwLavThkGTw9bvEn0E
JEMlX6GomcFrBfE+jnI/k9QSNitmkoH0qo5U+VQreVTwrrfhDQYH67zf8cpt
JPEC3a9cX2AQWOlIyoIryc5v2aYP2bPIWJqKULMOJGZDKtlxqjMo2mbJLudX
gXfAd3Ri/xPsrPnSu7e5AcrsFn++9yribxdu7+C1ILrNLSDZfQUmTH62y91O
NMpJJBzjZbglhnfUJHZDMljxXPfgIobDDLTTdvRi81tx9QHxf2J6wFrDT3MQ
ijnB87/MPYautWXSp6FizAaH3OG4LyDBg9Uzx4yC/+tZ9eTkefjxuNvx2xhC
zxt67D47h65PuG4+yRMQZqrZSCIYDBmwEs0XJ/Gy2HWo120WWZHcy/0WEvic
v2c1rT8DQQi3xZMjxecKe3g+AgluKbKEGatSOHzmqaN5aBLsw9xZXuY0ch4o
Ku+pHYO7L3c5RDyNjBs+ESlPRmQ9/Pv3NxfLcun19B5EDcpyh0r6xXOVfbK8
42TT2hTIstZ7DWyY3pfl6rAp0aOuH2WZZzu+NptlWTguWL7mUi/Li3vb05Tl
qzY8wALtB/UA/bQ/1AOU0n5RD3CE9o96gBO0n9QDGND+Ug8QQPtN+499tP8b
uYP6QD1AGfWDeoB+6gv1ALnUH+oBvqA+UQ8QRP2iHmAX9Y16gC3Uv78A0454
4A==
      "], 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, VertexCoordinateRules -> {{0., 1.}, {0., 2.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{262.76384699279504`, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{267, 335},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->776547191]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MaximalBipartiteMatching", "Subsection",
 CellID->2086213910],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MaximalBipartiteMatching",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/MaximalBipartiteMatching"], "[", 
     
     StyleBox["g", "TI"], "]"}], Cell[TextData[{
     "gives the maximal matching of the bipartite graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->496910741],

Cell["Finding the maximal bipartite matching.", "Caption",
 CellID->14920804],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaximalBipartiteMatching",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalBipartiteMatching"]], 
  "InlineFormula"],
 " gives a maximal set of non-adjacent edges between the two vertex sets of \
the bipartite graph."
}], "Text",
 CellID->18678],

Cell[TextData[{
 "The bipartite graph represented by an ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "\[Times]", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " matrix consists of the row and column vertex sets ",
 Cell[BoxData[
  RowBox[{"R", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     StyleBox["m", "TI"]}], "}"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     StyleBox["n", "TI"]}], "}"}]}]], "InlineFormula"],
 ", with a vertex ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], "\[Element]", "R"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["j", "TI"], "\[Element]", 
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"]}]], "InlineFormula"],
 " connected if the matrix element ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["g", "TI"], 
    StyleBox["ij", "TI"]], "\[NotEqual]", "0"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->21545],

Cell[TextData[{
 "The bipartite graph represented by a rule list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], "->", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["2", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " consists of vertex sets ",
 Cell[BoxData[
  RowBox[{"R", "=", 
   RowBox[{
    ButtonBox["Union",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Union"], "[", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "=", 
   RowBox[{
    ButtonBox["Union",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Union"], "[", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]}]], "InlineFormula"],
 ", with a vertex ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], "\[Element]", "R"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["j", "TI"], "\[Element]", 
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"]}]], "InlineFormula"],
 " connected if the rule ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], "->", 
   StyleBox["j", "TI"]}]], "InlineFormula"],
 " is included in the rule list."
}], "Text",
 CellID->28712],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaximalBipartiteMatching",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalBipartiteMatching"]], 
  "InlineFormula"],
 " returns a list of index pairs ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]], ",", 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["k", "TI"]]}], "}"}]}], "}"}]], "InlineFormula"],
 " where the number of pairs ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " is not larger than either vertex set."
}], "Text",
 CellID->17546],

Cell["This finds a maximal matching.", "MathCaption",
 CellID->527984360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaximalBipartiteMatching", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<Alex\>\"", "\[Rule]", "\"\<Mary\>\""}], ",", 
    RowBox[{"\"\<Alex\>\"", "\[Rule]", "\"\<Sarah\>\""}], ",", 
    RowBox[{"\"\<Victor\>\"", "\[Rule]", "\"\<Mary\>\""}], ",", 
    RowBox[{"\"\<Victor\>\"", "\[Rule]", "\"\<Rachel\>\""}], ",", 
    RowBox[{"\"\<James\>\"", "\[Rule]", "\"\<Rachel\>\""}], ",", 
    RowBox[{"\"\<James\>\"", "\[Rule]", "\"\<Helen\>\""}], ",", 
    RowBox[{"\"\<Richard\>\"", "\[Rule]", "\"\<Helen\>\""}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->335475824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Victor\"\>", ",", "\<\"Mary\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Alex\"\>", ",", "\<\"Sarah\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"James\"\>", ",", "\<\"Rachel\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Richard\"\>", ",", "\<\"Helen\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{447, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->161151542]
}, Open  ]],

Cell[CellGroupData[{

Cell["Applications", "Subsubsection",
 CellTags->"b:0.10b",
 CellID->120889888],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaximalBipartititeMatching",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalBipartiteMatching"]], 
  "InlineFormula"],
 " can be used to permute as many entries as possible onto the diagonal of a \
sparse matrix."
}], "Text",
 CellID->816888557],

Cell[TextData[{
 "This defines a random ",
 Cell[BoxData[
  RowBox[{"50", "\[Times]", "60"}]], "InlineFormula"],
 " sparse matrix with approximately 4% of the elements nonzero."
}], "MathCaption",
 CellID->24472],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellID->321333761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"Floor", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], "+", ".04"}], ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "60"}], "}"}]}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->27152],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "122", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 122, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"50", ",", "60"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->2061044946]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "m", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->14423],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWt1PE0EQP9heQQlSUWODktSvKB/lKxBiojEalZgoiYToA740RAMxIiLx
SYmJ/4Evvvrgg38F/9q6e51p9/Zmr3Ntt1cMJNx072Z+v/2amd3be1E73Hn7
oXa4u12rrB3U9nd2tz9Xnn48ULfEQBAEx+r/bzlQv6X6Ff0fS6lk8lpSV6EU
ZpQsKDmo5KCSc/qpviHxT9+tghQgSxHGeX0VDd0IKwjr5cY1Qk5oNRkIjSl9
KZoatN4oWYtZFr5WCMIGOtR1piPmqlGmWj5FPY/V1C//NIwezSvIJ2Mk0zSz
nm7GaJRCc55RNa63syTpWUjP1TmDszlXXX6gGf4EATCNWvx2feas8mKLsm0/
ErEIow2hZ0aTS9TZDQ2qz+3ybxuRsNfBZ0DLPmLQxSXd8l8Pg+u6rOQTuB+2
ZIDOCmg/LVh8Ns9a3EK6vGAwxtXom1SuZ8ARglxWMlTygqQ8Sjg40TtQ2vMw
lcXqaROn3hTbj7hoI6T1JFhtQS/f8Gj1EqzGQc6DdbHvrSugfZS79gholy25
AnIY2jcEkjcL/KDeA+1a7trvZdxHpj1afQPtSs+1rfgm6eizDxiXHWNJowiK
gZF/MrKR+YJeT9qxuxUTjYJZwsp3iSyhFdALtkCuSGNll4oQz0W8vGezrZLj
0h2udeDAOHBJGjOezcmbf6lczHlo+wUXMz2WTIL1I49Wq2B1VcZjC8rVE4eC
+WsT5J2+s5qH9ux50EYvfQU1ug1lAeVzJw4Fcz+u8cahvNED6/xWDGn7RmyT
3b/2qrfz/SCbicDtbJ/YPebWmUeboyd/hTL2GzO3MFrkWldzVhzt9t62pNdn
jPFizD8nemLeubzShUB7DO4sH8ss8aMzq83ctatQ70+5a2tfxJ28uSvDSHar
hyg/ZXOFla/2D6j/FQ/aOD4PQC7kbmWeH9hxAd9pPLfumzYQjIt1YV5bxbQY
+pnG/SQQEc2yR2tXW7oVrXURZz6uHnG3cE1y31y2mxdsxjayKuNEIDUDOkfD
wWdkcVdecuDL+EkCnZFc2Zn2lT2ZxbN8akdne0p7Hazue7TC2YKzB/uMF8vy
tB6F9t4EuevR6o2Mr1x5u9ZeWmnNRdl8I6ERMPrzVkf9gIDnL8sgJ8B6QmbJ
3t1BQW2cKcOAgn42C7JEotVff+GfK7tm4ohFP5HIv9nzYbst5ORLXm10EXfx
R1AudA3dLCPLd29tMcvvgG1M0uvf/mXl5GSSJ2NuxlULxmM8gTVPgYqG72oU
vcPgnaWdZHTsXXxjWvZotQY1fJ27Nu4U8SRCeLTahPG4K7Pkg15aYQbD9xsl
Sa/p87fWc7oRtY2n+F74i7Rjg1YaimyHLBt79GIYKXGvyELDN9RlQD0L8iJI
ZFtqm01g1GOwLDj6rV/akmbV6TdNdC301dsXVYnsNCxx7je/HnN9Y3b6xeXp
F5cUryCf/L9fXAYD/wB0fj8w\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{190, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->472802055]
}, Open  ]],

Cell["This finds rows and columns that are matched.", "MathCaption",
 CellID->2131107523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"matched", " ", "=", " ", 
  RowBox[{"MaximalBipartiteMatching", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->529102339],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"13", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"35", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "29"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "31"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "36"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "38"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "40"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "41"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43", ",", "42"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "43"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "44"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "46"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "47"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "48"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "49"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "51"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "52"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"49", ",", "53"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "54"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "56"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "57"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", "59"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "60"}], "}"}]}], "}"}]], "Output",
 ImageSize->{508, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1894592817]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"matched", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->2131973120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "13", ",", "1", ",", "40", ",", "16", ",", "15", ",", "17", ",", "29", ",", 
   "11", ",", "10", ",", "19", ",", "31", ",", "45", ",", "2", ",", "22", ",",
    "35", ",", "50", ",", "33", ",", "25", ",", "32", ",", "6", ",", "27", 
   ",", "39", ",", "21", ",", "4", ",", "37", ",", "12", ",", "38", ",", "34",
    ",", "14", ",", "3", ",", "43", ",", "18", ",", "8", ",", "36", ",", "9", 
   ",", "20", ",", "42", ",", "23", ",", "7", ",", "49", ",", "41", ",", "28",
    ",", "24", ",", "47", ",", "5"}], "}"}]], "Output",
 ImageSize->{566, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->123349180]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "=", 
  RowBox[{"matched", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->1769261241],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "4", ",", "5", ",", "6", ",", "7", ",", "10", ",", "11",
    ",", "12", ",", "13", ",", "14", ",", "15", ",", "16", ",", "18", ",", 
   "19", ",", "20", ",", "22", ",", "23", ",", "24", ",", "28", ",", "29", 
   ",", "31", ",", "32", ",", "33", ",", "34", ",", "35", ",", "36", ",", 
   "38", ",", "40", ",", "41", ",", "42", ",", "43", ",", "44", ",", "46", 
   ",", "47", ",", "48", ",", "49", ",", "51", ",", "52", ",", "53", ",", 
   "54", ",", "56", ",", "57", ",", "59", ",", "60"}], "}"}]], "Output",
 ImageSize->{570, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1907315810]
}, Open  ]],

Cell["This finds unmatched rows and columns.", "MathCaption",
 CellID->802143656],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{"Complement", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"Dimensions", "[", "m", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "r"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c2", " ", "=", " ", 
   RowBox[{"Complement", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"Dimensions", "[", "m", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "c"}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[13]:=",
 CellID->1421463279],

Cell["\<\
This orders the matrix by permuting matched rows and columns to the principal \
diagonal block first.\
\>", "MathCaption",
 CellID->892932029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{"r", ",", "r2"}], "]"}], ",", 
     RowBox[{"Join", "[", 
      RowBox[{"c", ",", "c2"}], "]"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->347416693],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWv9LFEEUX927NTXrShIlQYmiIAhPLw0VSRClL5IQREIQpwj6Q9/Mn6Ig
CPotCPpBiKA/JMi/w79mmtl975yZfbM7c97djqboPGf3vfeZmX0z772ZWa3v
bW+9qu/tbNbHV3brb7d3Nt+PL7/Z5Y/CriAIDvnf3+GA/8/4f/HfIWOcymWF
lyF/VeO0xGk3p92cTou34gHDH3wqaAj0UqwjLsMGb6wrKCf1RhlrlrmmVASC
Y1IUkcxB810gW3E3V38V+hyUG9qhrbVjIU9LdarnVeq90tL24k/C16NxQ/JN
hUSasmynGTH+SmXZzqgWJ/2sMNoKaVudkTCPbDU9A+RygJcHQUKhlFqht2pG
q8/m1HX5/hgllHpSbjOijBUm6BIHNfJ6/Y+ukZAXi0+XoE0hjPAi3F8MngBd
bQuiqOpIj+B5ORcBBi+gZ2/Jpkcpe03r6VawGmOViTUKGL8YNa9CAwbOEaS6
HSpatZGU5ZKm6vPGJN1Pct8D7s+Fc7u12x/uW8D9vXBuHO/HQKveSS0B90Wg
t4HWvJcWNlzi3LpP6Dz3ArR7Huicd1IbwH0F6AIppa2ujF4L83TRWkIKwcIb
OqKR3oqOcYXnEIpwREOgE5xGOMKgj9aA/knztJn+yYQW98sUSWZ4xRagOnti
O8xngHUV6JITlp0tkhiWtqjPkTxd9Mx6B9wrhXO/Bu6HhXMPAvcDoL2MjmT9
k0YbQI+05p0URkLLQJ96J4VfAPuFEROuPfhFhoGWgF4HGknP/2+0l8C9Xjj3
C6bGlvr7/Ew+T4Ms21xmnotA6Dtepj4GSDOaVbhn7PmeVYib8DBvx/Gz9Kkt
7KFNFOY6umtMnVsb7t8zwx5ztafsUbenPA30TOphqn8SK0NkHccXKY35JUbi
295JjTE1j0RpsRrbZ3M+aamC1BBT/QuucYMnTouIZYXNTTmNQyelcFdir3Du
ReA+D/Q5y/K+p0cas9UPJLd8Sqev6iZJWQZcbZQQuczzSIr23sbztCLCF9n5
XsEwK6GUwPu32rfOAcYn7XnrY6TmkWzO1fS6sr9tHG0DnhSDmaIGg36mnsfR
8YLb3rvw1ZEUcQn/IdawCeaSLfqkBXMn3F/BPYUh76XvAPeIJO2XFEYZ3wrn
xoy4xlzyy05K3QDuH4Vz9zE1NrwP9DLQUa3ed+q04rzEWBIzE3q3LnGF+GOK
ATJ1Kmt2mIoK3DNk2x7YZMju6Fnn0q1BE1VE+Ql1m4jEx77IdVxffzeBZhMp
KPodIwVT2+g5hPnYF6BCZyRZZM+J04JzCrMGt1OHTkhVmLoKbnknNQDcX4Fe
804KPQqeLmBsZnfaVaQ07qPhzofbzl8npPDcAb0x2g5GSngOMUpqi98G6RNd
J60pTxvP/dQKEB4HI2N9j8xoasv2j+6l3WRHWQFlx/YYohp3hWtJfk0Y44ax
Lrb9cn1eq3+00irKtt3oTPnTc4yaBe25rypQDgK8I5t9n/bsdnlwdrtcwQ3J
N6f3dnnQ9Q8Up/9y\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{217, 190},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->151771837]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaximalBipartititeMatching",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalBipartiteMatching"]], 
  "InlineFormula"],
 " can be used to find the structural rank of a sparse matrix. The structural \
rank of a matrix is the number of entries in the maximal matching of the \
bipartite graph of the matrix. It is an upper bound on the numeric rank of \
the matrix. A matrix has structural full rank if it can be permuted so that \
the diagonal has no zero entries."
}], "Text",
 CellID->791633024],

Cell["\<\
This shows that on average, a random 50\[Times]50 matrix with 4% nonzero \
entries has structural rank of 39.4.\
\>", "MathCaption",
 CellID->638418240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"MaximalBipartiteMatching", "[", 
       RowBox[{"SparseArray", "[", 
        RowBox[{"Floor", "[", 
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", " ", "1"}], "}"}], " ", "+", " ", ".04"}], ",",
            " ", 
           RowBox[{"{", 
            RowBox[{"50", ",", " ", "50"}], "}"}]}], "]"}], "]"}], "]"}], 
       "]"}], "]"}], ",", 
     RowBox[{"{", "10000", "}"}]}], "]"}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->1312020061],

Cell[BoxData["39.4391`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->42835252]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MaximalIndependentEdgeSet", "Subsection",
 CellID->657286346],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{
       ButtonBox["MaximalIndependentEdgeSet",
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"], 
       "[", 
       StyleBox["g", "TI"], "]"}],
      FontFamily->"Courier"], 
     RowBox[{
     "gives", " ", "a", " ", "maximal", " ", "independent", " ", "edge", " ", 
      "set", " ", "of", " ", "an", " ", "undirected", " ", "graph", " ", 
      StyleBox["g", "TI"]}]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.3",
 CellID->816891785],

Cell["Finding the maximal independent edge set.", "Caption",
 CellTags->"b:0.3",
 CellID->163532451],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaximalIndependentEdgeSet",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"]], 
  "InlineFormula"],
 " gives an approximate maximal set of pairwise non-adjacent edges of \.1d ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". A maximal independent edge set of a graph is also called a maximal \
matching."
}], "Text",
 CellID->6334],

Cell["\<\
This defines a graph and finds a maximal independent edge set.\
\>", "MathCaption",
 CellID->268468226],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "10"}], ",", 
     RowBox[{"1", "\[Rule]", "11"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "18"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "12"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "19"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "13"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"6", "\[Rule]", "20"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"7", "\[Rule]", "14"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"8", "\[Rule]", "16"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}], ",", 
     RowBox[{"9", "\[Rule]", "15"}], ",", 
     RowBox[{"10", "\[Rule]", "17"}], ",", 
     RowBox[{"11", "\[Rule]", "15"}], ",", 
     RowBox[{"11", "\[Rule]", "12"}], ",", 
     RowBox[{"12", "\[Rule]", "13"}], ",", 
     RowBox[{"13", "\[Rule]", "14"}], ",", 
     RowBox[{"14", "\[Rule]", "15"}], ",", 
     RowBox[{"16", "\[Rule]", "20"}], ",", 
     RowBox[{"16", "\[Rule]", "17"}], ",", 
     RowBox[{"17", "\[Rule]", "18"}], ",", 
     RowBox[{"18", "\[Rule]", "19"}], ",", 
     RowBox[{"19", "\[Rule]", "20"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->615331030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"match", "=", 
  RowBox[{"MaximalIndependentEdgeSet", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[27]:=",
 CellID->98719676],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}]}], "}"}]], "Output",
 ImageSize->{524, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->166568810]
}, Open  ]],

Cell["\<\
This plots the graph so that edges in the maximal independent edge set are \
red.\
\>", "MathCaption",
 CellID->719249700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"match", ",", "#2"}], "]"}], "||", 
          RowBox[{"MemberQ", "[", 
           RowBox[{"match", ",", 
            RowBox[{"Reverse", "[", "#2", "]"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
           RowBox[{"Line", "[", "#", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"Line", "[", "#", "]"}]}], "}"}]}], "]"}], "}"}], "&"}], 
     ")"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->1038700657],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{228, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->5996055]
}, Open  ]],

Cell["\<\
The defines a graph with edge weights and finds a maximal independent edge \
set.\
\>", "MathCaption",
 CellTags->"b:0.8",
 CellID->35264876],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", "1"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "6"}], "}"}], "\[Rule]", "2"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"b:0.8",
 CellLabel->"In[47]:=",
 CellID->2003541824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"match", " ", "=", " ", 
  RowBox[{"MaximalIndependentEdgeSet", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[50]:=",
 CellID->1034366891],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->1825555766]
}, Open  ]],

Cell["\<\
This plots the graph so that edges in the maximal independent edge set are \
red. The edge weights are also shown.\
\>", "MathCaption",
 CellID->359116893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"match", ",", "#2"}], "]"}], "||", 
           RowBox[{"MemberQ", "[", 
            RowBox[{"match", ",", 
             RowBox[{"Reverse", "[", "#2", "]"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
            RowBox[{"Line", "[", "#", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"Line", "[", "#", "]"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#4", "]"}], ",", 
             RowBox[{"Last", "[", "#4", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->145650617],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{212, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[51]=",
 CellID->143138241]
}, Open  ]],

Cell["\<\
This gives preference to edges with higher edge weights in finding the \
matching.\
\>", "MathCaption",
 CellID->583110382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"match", "=", 
  RowBox[{"MaximalIndependentEdgeSet", "[", 
   RowBox[{"g", ",", " ", 
    RowBox[{"Weighted", " ", "->", " ", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[52]:=",
 CellID->3725621],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->541530758]
}, Open  ]],

Cell["This plots the graph again.", "MathCaption",
 CellID->1902343016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"match", ",", "#2"}], "]"}], "||", 
           RowBox[{"MemberQ", "[", 
            RowBox[{"match", ",", 
             RowBox[{"Reverse", "[", "#2", "]"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
            RowBox[{"Line", "[", "#", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"Line", "[", "#", "]"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#4", "]"}], ",", 
             RowBox[{"Last", "[", "#4", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->339972785],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{203, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->375988330]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option for MaximalIndependentEdgeSet", "Subsubsection",
 CellTags->"b:0.10b",
 CellID->1203381253],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Weighted",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Weighted"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether edges with higher weights are preferred when forming the maximal \
independent edge set\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.10b",
 CellID->17545054],

Cell[TextData[{
 "Options for ",
 StyleBox[ButtonBox["MaximalIndependentEdgeSet",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"], "MR"],
 StyleBox[".", "MR"]
}], "Caption",
 CellTags->"b:0.10b",
 CellID->1648668149],

Cell[CellGroupData[{

Cell["Weighted", "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->1155770649],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Weighted",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/Weighted"]], "InlineFormula"],
 " option specifies whether edges with higher weights are preferred when \
forming the maximal independent edge set. Possible values are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " (the default) or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->1396410826]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MaximalIndependentVertexSet", "Subsection",
 CellID->114316719],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{
       ButtonBox["MaximalIndependentVertexSet",
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentVertexSet"], 
       "[", 
       StyleBox["g", "TI"], "]"}],
      FontFamily->"Courier"], 
     RowBox[{
     "gives", " ", "a", " ", "maximal", " ", "independent", " ", "vertex", 
      " ", "set", " ", "of", " ", "an", " ", "undirected", " ", "graph", " ", 
      
      StyleBox["g", "TI"]}]},
    {
     StyleBox[
      RowBox[{
       ButtonBox["MaximalIndependentVertexSet",
        BaseStyle->"Link",
        ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentVertexSet"], 
       "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["w", "TI"]}], "]"}],
      FontFamily->"Courier"], 
     RowBox[{
     "gives", " ", "a", " ", "maximal", " ", "independent", " ", "vertex", 
      " ", "set", " ", "of", " ", 
      StyleBox["g", "TI"], 
      StyleBox[" ", "TI"], "with", " ", "vertices", " ", "weighted", " ", 
      "by", " ", 
      StyleBox["w", "TI"]}]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.3",
 CellID->1610718510],

Cell["Finding the maximal independent vertex set.", "Caption",
 CellTags->"b:0.3",
 CellID->1097751099],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaximalIndependentVertexSet",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentVertexSet"]], 
  "InlineFormula"],
 " gives an approximate maximal set of vertices such that no two vertices \
form an edge. It treats the input as an undirected graph."
}], "Text",
 CellID->537558084],

Cell[TextData[{
 "The length of the vector ",
 Cell[BoxData[
  StyleBox["w", "TI"]], "InlineFormula"],
 " must be the same as the number of vertices in ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1458506999],

Cell["\<\
This specifies a small graph and finds a maximal independent vertex set.\
\>", "MathCaption",
 CellID->11478],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "10"}], ",", 
     RowBox[{"1", "\[Rule]", "11"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "18"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "12"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "19"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "13"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"6", "\[Rule]", "20"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"7", "\[Rule]", "14"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"8", "\[Rule]", "16"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}], ",", 
     RowBox[{"9", "\[Rule]", "15"}], ",", 
     RowBox[{"10", "\[Rule]", "17"}], ",", 
     RowBox[{"11", "\[Rule]", "15"}], ",", 
     RowBox[{"11", "\[Rule]", "12"}], ",", 
     RowBox[{"12", "\[Rule]", "13"}], ",", 
     RowBox[{"13", "\[Rule]", "14"}], ",", 
     RowBox[{"14", "\[Rule]", "15"}], ",", 
     RowBox[{"16", "\[Rule]", "20"}], ",", 
     RowBox[{"16", "\[Rule]", "17"}], ",", 
     RowBox[{"17", "\[Rule]", "18"}], ",", 
     RowBox[{"18", "\[Rule]", "19"}], ",", 
     RowBox[{"19", "\[Rule]", "20"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->1254289988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"MaximalIndependentVertexSet", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[56]:=",
 CellID->5705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "18", ",", "5", ",", "7", ",", "20", ",", "9"}],
   "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[56]=",
 CellID->29072017]
}, Open  ]],

Cell["\<\
This plots the graph's maximal independent vertex set highlighted in red \
circles.\
\>", "MathCaption",
 CellID->9741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"m", ",", "#2"}], "]"}], ",", "Red", ",", "Green"}], 
          "]"}], "]"}], ",", "White", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", ".2"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[57]:=",
 CellID->17673],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{1.6259484070919739`, 1.89942433588615}, {
      2.525743164436057, 1.247413869171976}, {0.723815661835152, 
      1.2509861158757563`}, {1.6292060381268905`, 2.9551691159561084`}, {
      3.2514562810241943`, 1.916550500830707}, {2.1555200473837184`, 
      0.29440680433769706`}, {3.24911053247253, 1.0312999777822431`}, {
      2.7173276146001526`, 2.865520379274897}, {2.5271251359922524`, 
      1.703420028014876}, {2.7108121164579364`, 0.08484942223115288}, {
      1.6248593076213649`, 1.0559092694599501`}, {2.160962776323694, 
      2.658206053569364}, {0.7255120107141158, 1.7082937988178344`}, {
      1.6227479640249876`, 0.}, {0., 1.0390189250610926`}, {
      1.0957589741648373`, 2.6608399808223933`}, {0.0024930692484230743`, 
      1.9235762679728474`}, {0.5339424248415161, 0.08949111554298339}, {
      0.5401497660325034, 2.8700654348455354`}, {1.0898244186154944`, 
      0.29632152134114786`}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 20}, {4, 19}, {4, 
        8}, {5, 7}, {5, 8}, {6, 10}, {7, 9}, {7, 10}, {8, 12}, {9, 11}, {9, 
        12}, {10, 14}, {11, 13}, {11, 14}, {12, 16}, {13, 15}, {13, 16}, {15, 
        17}, {15, 18}, {16, 19}, {17, 3}, {17, 19}, {18, 14}, {18, 20}, {20, 
        6}}]}], {
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{1.6259484070919739`, 1.89942433588615}, 0.2], 
       {GrayLevel[0], 
        InsetBox["1", {1.6259484070919739`, 1.89942433588615}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{2.525743164436057, 1.247413869171976}, 0.2], 
       {GrayLevel[0], 
        InsetBox["2", {2.525743164436057, 1.247413869171976}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{0.723815661835152, 1.2509861158757563`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["10", {0.723815661835152, 1.2509861158757563`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{1.6292060381268905`, 2.9551691159561084`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["11", {1.6292060381268905`, 2.9551691159561084`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{3.2514562810241943`, 1.916550500830707}, 0.2], 
       {GrayLevel[0], 
        InsetBox["3", {3.2514562810241943`, 1.916550500830707}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{2.1555200473837184`, 0.29440680433769706`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["18", {2.1555200473837184`, 0.29440680433769706`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{3.24911053247253, 1.0312999777822431`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["4", {3.24911053247253, 1.0312999777822431`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{2.7173276146001526`, 2.865520379274897}, 0.2], 
       {GrayLevel[0], 
        InsetBox["12", {2.7173276146001526`, 2.865520379274897}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{2.5271251359922524`, 1.703420028014876}, 0.2], 
       {GrayLevel[0], 
        InsetBox["5", {2.5271251359922524`, 1.703420028014876}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{2.7108121164579364`, 0.08484942223115288}, 0.2], 
       {GrayLevel[0], 
        InsetBox["19", {2.7108121164579364`, 0.08484942223115288}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{1.6248593076213649`, 1.0559092694599501`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["6", {1.6248593076213649`, 1.0559092694599501`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{2.160962776323694, 2.658206053569364}, 0.2], 
       {GrayLevel[0], 
        InsetBox["13", {2.160962776323694, 2.658206053569364}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{0.7255120107141158, 1.7082937988178344`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["7", {0.7255120107141158, 1.7082937988178344`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{1.6227479640249876`, 0.}, 0.2], 
       {GrayLevel[0], InsetBox["20", {1.6227479640249876`, 0.}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{0., 1.0390189250610926`}, 0.2], 
       {GrayLevel[0], InsetBox["8", {0., 1.0390189250610926`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{1.0957589741648373`, 2.6608399808223933`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["14", {1.0957589741648373`, 2.6608399808223933`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{0.0024930692484230743`, 1.9235762679728474`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["9", {0.0024930692484230743`, 1.9235762679728474`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{0.5339424248415161, 0.08949111554298339}, 0.2], 
       {GrayLevel[0], 
        InsetBox["16", {0.5339424248415161, 0.08949111554298339}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{0.5401497660325034, 2.8700654348455354`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["15", {0.5401497660325034, 2.8700654348455354`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{1.0898244186154944`, 0.29632152134114786`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["17", {1.0898244186154944`, 0.29632152134114786`}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.6259484070919739`, 1.89942433588615}, {
     2.525743164436057, 1.247413869171976}, {0.723815661835152, 
     1.2509861158757563`}, {1.6292060381268905`, 2.9551691159561084`}, {
     3.2514562810241943`, 1.916550500830707}, {2.1555200473837184`, 
     0.29440680433769706`}, {3.24911053247253, 1.0312999777822431`}, {
     2.7173276146001526`, 2.865520379274897}, {2.5271251359922524`, 
     1.703420028014876}, {2.7108121164579364`, 0.08484942223115288}, {
     1.6248593076213649`, 1.0559092694599501`}, {2.160962776323694, 
     2.658206053569364}, {0.7255120107141158, 1.7082937988178344`}, {
     1.6227479640249876`, 0.}, {0., 1.0390189250610926`}, {
     1.0957589741648373`, 2.6608399808223933`}, {0.0024930692484230743`, 
     1.9235762679728474`}, {0.5339424248415161, 0.08949111554298339}, {
     0.5401497660325034, 2.8700654348455354`}, {1.0898244186154944`, 
     0.29632152134114786`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{260., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{264, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[57]=",
 CellID->296389683]
}, Open  ]],

Cell["\<\
This finds a maximal independent vertex set with preference given to vertices \
with even labels.\
\>", "MathCaption",
 CellID->30836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VertexList", "[", "g", "]"}]], "Input",
 CellLabel->"In[58]:=",
 CellID->1124238699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "10", ",", "11", ",", "3", ",", "18", ",", "4", ",", 
   "12", ",", "5", ",", "19", ",", "6", ",", "13", ",", "7", ",", "20", ",", 
   "8", ",", "14", ",", "9", ",", "16", ",", "15", ",", "17"}], 
  "}"}]], "Output",
 ImageSize->{448, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[58]=",
 CellID->700175770]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"MaximalIndependentVertexSet", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"EvenQ", "[", "#", "]"}], ",", "2", ",", "1"}], "]"}], "&"}],
       ",", 
      RowBox[{"VertexList", "[", "g", "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[59]:=",
 CellID->24350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "16", ",", "14", ",", "6", ",", "12", ",", "4", ",", "18", ",", "10"}], 
  "}"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[59]=",
 CellID->1177614126]
}, Open  ]],

Cell["\<\
This plots the new maximal independent vertex set in red circles.\
\>", "MathCaption",
 CellID->1640054030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"m", ",", "#2"}], "]"}], ",", "Red", ",", "Green"}], 
          "]"}], "]"}], ",", "White", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", ".2"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[60]:=",
 CellID->643703617],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{1.6259484070919739`, 1.89942433588615}, {
      2.525743164436057, 1.247413869171976}, {0.723815661835152, 
      1.2509861158757563`}, {1.6292060381268905`, 2.9551691159561084`}, {
      3.2514562810241943`, 1.916550500830707}, {2.1555200473837184`, 
      0.29440680433769706`}, {3.24911053247253, 1.0312999777822431`}, {
      2.7173276146001526`, 2.865520379274897}, {2.5271251359922524`, 
      1.703420028014876}, {2.7108121164579364`, 0.08484942223115288}, {
      1.6248593076213649`, 1.0559092694599501`}, {2.160962776323694, 
      2.658206053569364}, {0.7255120107141158, 1.7082937988178344`}, {
      1.6227479640249876`, 0.}, {0., 1.0390189250610926`}, {
      1.0957589741648373`, 2.6608399808223933`}, {0.0024930692484230743`, 
      1.9235762679728474`}, {0.5339424248415161, 0.08949111554298339}, {
      0.5401497660325034, 2.8700654348455354`}, {1.0898244186154944`, 
      0.29632152134114786`}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 20}, {4, 19}, {4, 
        8}, {5, 7}, {5, 8}, {6, 10}, {7, 9}, {7, 10}, {8, 12}, {9, 11}, {9, 
        12}, {10, 14}, {11, 13}, {11, 14}, {12, 16}, {13, 15}, {13, 16}, {15, 
        17}, {15, 18}, {16, 19}, {17, 3}, {17, 19}, {18, 14}, {18, 20}, {20, 
        6}}]}], {
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{1.6259484070919739`, 1.89942433588615}, 0.2], 
       {GrayLevel[0], 
        InsetBox["1", {1.6259484070919739`, 1.89942433588615}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{2.525743164436057, 1.247413869171976}, 0.2], 
       {GrayLevel[0], 
        InsetBox["2", {2.525743164436057, 1.247413869171976}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{0.723815661835152, 1.2509861158757563`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["10", {0.723815661835152, 1.2509861158757563`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{1.6292060381268905`, 2.9551691159561084`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["11", {1.6292060381268905`, 2.9551691159561084`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{3.2514562810241943`, 1.916550500830707}, 0.2], 
       {GrayLevel[0], 
        InsetBox["3", {3.2514562810241943`, 1.916550500830707}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{2.1555200473837184`, 0.29440680433769706`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["18", {2.1555200473837184`, 0.29440680433769706`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{3.24911053247253, 1.0312999777822431`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["4", {3.24911053247253, 1.0312999777822431`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{2.7173276146001526`, 2.865520379274897}, 0.2], 
       {GrayLevel[0], 
        InsetBox["12", {2.7173276146001526`, 2.865520379274897}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{2.5271251359922524`, 1.703420028014876}, 0.2], 
       {GrayLevel[0], 
        InsetBox["5", {2.5271251359922524`, 1.703420028014876}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{2.7108121164579364`, 0.08484942223115288}, 0.2], 
       {GrayLevel[0], 
        InsetBox["19", {2.7108121164579364`, 0.08484942223115288}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{1.6248593076213649`, 1.0559092694599501`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["6", {1.6248593076213649`, 1.0559092694599501`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{2.160962776323694, 2.658206053569364}, 0.2], 
       {GrayLevel[0], 
        InsetBox["13", {2.160962776323694, 2.658206053569364}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{0.7255120107141158, 1.7082937988178344`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["7", {0.7255120107141158, 1.7082937988178344`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{1.6227479640249876`, 0.}, 0.2], 
       {GrayLevel[0], InsetBox["20", {1.6227479640249876`, 0.}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{0., 1.0390189250610926`}, 0.2], 
       {GrayLevel[0], InsetBox["8", {0., 1.0390189250610926`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{1.0957589741648373`, 2.6608399808223933`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["14", {1.0957589741648373`, 2.6608399808223933`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{0.0024930692484230743`, 1.9235762679728474`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["9", {0.0024930692484230743`, 1.9235762679728474`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], 
       DiskBox[{0.5339424248415161, 0.08949111554298339}, 0.2], 
       {GrayLevel[0], 
        InsetBox["16", {0.5339424248415161, 0.08949111554298339}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{0.5401497660325034, 2.8700654348455354`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["15", {0.5401497660325034, 2.8700654348455354`}]}}, 
      {GrayLevel[1], EdgeForm[RGBColor[0, 1, 0]], 
       DiskBox[{1.0898244186154944`, 0.29632152134114786`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["17", {1.0898244186154944`, 0.29632152134114786`}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.6259484070919739`, 1.89942433588615}, {
     2.525743164436057, 1.247413869171976}, {0.723815661835152, 
     1.2509861158757563`}, {1.6292060381268905`, 2.9551691159561084`}, {
     3.2514562810241943`, 1.916550500830707}, {2.1555200473837184`, 
     0.29440680433769706`}, {3.24911053247253, 1.0312999777822431`}, {
     2.7173276146001526`, 2.865520379274897}, {2.5271251359922524`, 
     1.703420028014876}, {2.7108121164579364`, 0.08484942223115288}, {
     1.6248593076213649`, 1.0559092694599501`}, {2.160962776323694, 
     2.658206053569364}, {0.7255120107141158, 1.7082937988178344`}, {
     1.6227479640249876`, 0.}, {0., 1.0390189250610926`}, {
     1.0957589741648373`, 2.6608399808223933`}, {0.0024930692484230743`, 
     1.9235762679728474`}, {0.5339424248415161, 0.08949111554298339}, {
     0.5401497660325034, 2.8700654348455354`}, {1.0898244186154944`, 
     0.29632152134114786`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{232., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{236, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[60]=",
 CellID->1285324110]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MinCut", "Subsection",
 CellID->1696346694],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MinCut",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/MinCut"], 
     StyleBox["[", "MR"], 
     StyleBox["g", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "partitions the undirected graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " into ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " parts where the number of edge cuts is approximately minimized."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.1",
 CellID->1415606667],

Cell["Minimizing edge cuts.", "Caption",
 CellTags->"b:0.11",
 CellID->1291700419],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MinCut",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MinCut"]], "InlineFormula"],
 " treats the input as an undirected graph, and tries to find a partition of \
the vertices into ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " parts so that each part has roughly the same number of vertices, and the \
number of edges between these parts (known as the edge separator) is \
minimized."
}], "Text",
 CellTags->"b:0.1",
 CellID->1197092942],

Cell["This finds a graph.", "MathCaption",
 CellTags->"b:0.1",
 CellID->156141686],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "2"}], ",", 
     RowBox[{"5", "\[Rule]", "2"}], ",", 
     RowBox[{"5", "\[Rule]", "3"}], ",", 
     RowBox[{"8", "\[Rule]", "6"}], ",", 
     RowBox[{"9", "\[Rule]", "6"}], ",", 
     RowBox[{"9", "\[Rule]", "7"}], ",", 
     RowBox[{"10", "\[Rule]", "7"}], ",", 
     RowBox[{"10", "\[Rule]", "8"}], ",", 
     RowBox[{"13", "\[Rule]", "11"}], ",", 
     RowBox[{"14", "\[Rule]", "11"}], ",", 
     RowBox[{"14", "\[Rule]", "12"}], ",", 
     RowBox[{"15", "\[Rule]", "5"}], ",", 
     RowBox[{"15", "\[Rule]", "12"}], ",", 
     RowBox[{"15", "\[Rule]", "13"}], ",", 
     RowBox[{"18", "\[Rule]", "16"}], ",", 
     RowBox[{"19", "\[Rule]", "16"}], ",", 
     RowBox[{"19", "\[Rule]", "17"}], ",", 
     RowBox[{"20", "\[Rule]", "10"}], ",", 
     RowBox[{"20", "\[Rule]", "17"}], ",", 
     RowBox[{"20", "\[Rule]", "18"}], ",", 
     RowBox[{"21", "\[Rule]", "1"}], ",", 
     RowBox[{"21", "\[Rule]", "9"}], ",", 
     RowBox[{"22", "\[Rule]", "2"}], ",", 
     RowBox[{"22", "\[Rule]", "21"}], ",", 
     RowBox[{"23", "\[Rule]", "3"}], ",", 
     RowBox[{"23", "\[Rule]", "22"}], ",", 
     RowBox[{"24", "\[Rule]", "4"}], ",", 
     RowBox[{"24", "\[Rule]", "23"}], ",", 
     RowBox[{"25", "\[Rule]", "6"}], ",", 
     RowBox[{"26", "\[Rule]", "7"}], ",", 
     RowBox[{"26", "\[Rule]", "25"}], ",", 
     RowBox[{"27", "\[Rule]", "8"}], ",", 
     RowBox[{"27", "\[Rule]", "21"}], ",", 
     RowBox[{"27", "\[Rule]", "26"}], ",", 
     RowBox[{"28", "\[Rule]", "11"}], ",", 
     RowBox[{"28", "\[Rule]", "24"}], ",", 
     RowBox[{"29", "\[Rule]", "12"}], ",", 
     RowBox[{"29", "\[Rule]", "28"}], ",", 
     RowBox[{"30", "\[Rule]", "13"}], ",", 
     RowBox[{"30", "\[Rule]", "29"}], ",", 
     RowBox[{"31", "\[Rule]", "14"}], ",", 
     RowBox[{"31", "\[Rule]", "16"}], ",", 
     RowBox[{"31", "\[Rule]", "30"}], ",", 
     RowBox[{"32", "\[Rule]", "17"}], ",", 
     RowBox[{"32", "\[Rule]", "31"}], ",", 
     RowBox[{"33", "\[Rule]", "18"}], ",", 
     RowBox[{"33", "\[Rule]", "32"}], ",", 
     RowBox[{"34", "\[Rule]", "19"}], ",", 
     RowBox[{"34", "\[Rule]", "25"}], ",", 
     RowBox[{"34", "\[Rule]", "33"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[75]:=",
 CellID->419731589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "g", "]"}]], "Input",
 CellLabel->"In[76]:=",
 CellID->1466878388],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.41345663504992824`, 0.44130034439431}, {
    1.4269632490364308`, 0.}, {0.8238574165454131, 0.5214581652200667}, {
    0.49082094451993097`, 0.7546723985088444}, {0., 1.483468835024543}, {
    4.751671091901073, 0.4003354304221787}, {4.911500858354717, 
    0.8209742942624207}, {3.894366123270074, 0.37078388934195283`}, {
    4.542781442030485, 0.7161639870938714}, {4.823577258562185, 
    1.452384344960754}, {0.36626288300656373`, 3.9230212749778794`}, {
    0.7701898178614386, 3.836459715389247}, {1.5548701185426828`, 
    4.014995403814324}, {0.5754057403107256, 3.53247629299042}, {
    0.007044501012331228, 2.8495333652669563`}, {4.550049083951841, 
    3.730716866715177}, {4.025260901842165, 4.352213215504006}, {
    5.040201479900472, 3.968297574813271}, {4.6743214554310395`, 
    3.4692981901100004`}, {4.802800217947693, 2.70374574159693}, {
    2.732646072183024, 0.06670735855509324}, {1.5332899234990227`, 
    0.38204520786650753`}, {0.9150338218119527, 0.8394571472783925}, {
    0.6986589010958086, 1.576823819160594}, {5.464833894537737, 
    1.5751631810200868`}, {5.105540997824667, 0.5220706255629957}, {
    4.074987137894369, 0.004930149438343356}, {0.7115054867735382, 
    2.831488799550515}, {1.017572236997439, 3.628037953418163}, {
    1.45783707931197, 4.315276822855014}, {2.7602049914280378`, 
    4.282847301018502}, {3.991863273970899, 3.981294294379129}, {
    5.014087671233881, 3.6719020072785997`}, {5.483781734257558, 
    2.9430901203265565`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 2}, {3, 4}, {5, 4}, {5, 1}, {6, 7}, {8, 7}, {8, 
       9}, {10, 9}, {10, 6}, {11, 12}, {13, 12}, {13, 14}, {15, 5}, {15, 
       14}, {15, 11}, {16, 17}, {18, 17}, {18, 19}, {20, 10}, {20, 19}, {20, 
       16}, {21, 2}, {21, 8}, {22, 4}, {22, 21}, {23, 1}, {23, 22}, {24, 3}, {
       24, 23}, {25, 7}, {26, 9}, {26, 25}, {27, 6}, {27, 21}, {27, 26}, {28, 
       12}, {28, 24}, {29, 14}, {29, 28}, {30, 11}, {30, 29}, {31, 13}, {31, 
       17}, {31, 30}, {32, 19}, {32, 31}, {33, 16}, {33, 32}, {34, 18}, {34, 
       25}, {34, 33}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "34"],
       Annotation[#, 34, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.41345663504992824`, 0.44130034439431}, {
     1.4269632490364308`, 0.}, {0.8238574165454131, 0.5214581652200667}, {
     0.49082094451993097`, 0.7546723985088444}, {0., 1.483468835024543}, {
     4.751671091901073, 0.4003354304221787}, {4.911500858354717, 
     0.8209742942624207}, {3.894366123270074, 0.37078388934195283`}, {
     4.542781442030485, 0.7161639870938714}, {4.823577258562185, 
     1.452384344960754}, {0.36626288300656373`, 3.9230212749778794`}, {
     0.7701898178614386, 3.836459715389247}, {1.5548701185426828`, 
     4.014995403814324}, {0.5754057403107256, 3.53247629299042}, {
     0.007044501012331228, 2.8495333652669563`}, {4.550049083951841, 
     3.730716866715177}, {4.025260901842165, 4.352213215504006}, {
     5.040201479900472, 3.968297574813271}, {4.6743214554310395`, 
     3.4692981901100004`}, {4.802800217947693, 2.70374574159693}, {
     2.732646072183024, 0.06670735855509324}, {1.5332899234990227`, 
     0.38204520786650753`}, {0.9150338218119527, 0.8394571472783925}, {
     0.6986589010958086, 1.576823819160594}, {5.464833894537737, 
     1.5751631810200868`}, {5.105540997824667, 0.5220706255629957}, {
     4.074987137894369, 0.004930149438343356}, {0.7115054867735382, 
     2.831488799550515}, {1.017572236997439, 3.628037953418163}, {
     1.45783707931197, 4.315276822855014}, {2.7602049914280378`, 
     4.282847301018502}, {3.991863273970899, 3.981294294379129}, {
     5.014087671233881, 3.6719020072785997`}, {5.483781734257558, 
     2.9430901203265565`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[76]=",
 CellID->859834050]
}, Open  ]],

Cell["\<\
This partitions the vertices into two parts with the minimum number of edge \
cuts.\
\>", "MathCaption",
 CellID->28145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "=", 
  RowBox[{"MinCut", "[", 
   RowBox[{"g", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[77]:=",
 CellID->23281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "3", ",", "1", ",", "4", ",", "2", ",", "5", ",", "8", ",", "6", ",", "9",
      ",", "7", ",", "10", ",", "21", ",", "22", ",", "23", ",", "24", ",", 
     "25", ",", "26", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "13", ",", "11", ",", "14", ",", "12", ",", "15", ",", "18", ",", "16", 
     ",", "19", ",", "17", ",", "20", ",", "28", ",", "29", ",", "30", ",", 
     "31", ",", "32", ",", "33", ",", "34"}], "}"}]}], "}"}]], "Output",
 ImageSize->{449, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[77]=",
 CellID->1818630849]
}, Open  ]],

Cell["\<\
This plots the graph with partitions one part colored red and the other \
colored green.\
\>", "MathCaption",
 CellID->1096522104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{
            "c", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
            "#2"}], "]"}], ",", "Red", ",", "Green"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", ".05"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[78]:=",
 CellID->2995],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmg10VdWVxy/vvfuSl08MCSEJEAKBEGjAykcZFgI6A37EKNOiUdMGIuVr
0XFUXAJl+mEDCqKgtEymw1h0iiMLZVJaqUVRCo6l2FXjV8WvEe1ooZUlHa0y
Wpw3v3P+955788YyU9bqWtOuYcXrve+es/d///c+++xz7mnpuH7R/L/quH7x
vI4h513Xcc2ixfOWDpn519fxU7KP53kP8N/tAzzus9zZ/x7IZvn/H+L6KXP1
T27ffqKq6ti11x7eu/ffDhzwpppfU789ceKXnZ0n6+qyXV0TbesJ5pr37pEj
e5YvfzqZ5JcjffveNX36P0ya5KW+CtLkrQMG8MyflzCX5Hfmzt37la/w5yXM
JXmouxsd/HkJLv2NvOSJ48eD35JcfNvu/ssv7yXnGyNHIt+oSJiLvyo//8Xy
cgOgtBQ8QuaNs/iwALXr+vf/+ogRz61YkV20KIvstNVF25h+L9mzZUsvfNtm
zYrplU3oimNJ7R079u10+seNjVumTUtZdFgdR5dcY1mxr7jIomfvvbeX5rcO
Hcraf17SXNLZnp4P58zZfdZZnb4PCoBaa7xP2rf0hmT+Hl+3DpEvP/jgQPN7
CT566u67dy1Z8q0pU24qKnq+pIQubxYWrqusBNS9F1/86Je+9PyOHUgbZD19
9KmnoHJ1JrPzqqsMb1a6N8Zc8/HDYzffTDfIh8MjPT3o41pt3pYfP3wYsnhF
A0T84Jpr8CVdwC2GaUWbn3R1qc3fnXmma2Ox+i/s3IlT1pSWfv8LXzC6x1rd
nzDXDGw8sGgR3Ygs3vEbJmKoaVcZRgkk0MhL3D5kiI0sns37Iut1gB7YsAHm
IB/cyEGCZ7GnYWlfZ+fasrJbKioARacmq3uUxUW7reefj01gp6WXsPp44Fe0
euWWHd7QkN4YhgqMpAUGl4cxB3d0wP/A5t6MowFWO+ruu/TSjfX1t1VXS/to
q73BakcugjCJzgZxymqnHaaa27JQPlGEXQQjDbEUez3Lax7hhLV6h/3BOzu2
0rzrGjPmzsmTNwweLN2NVvdwqxv4/Ajr6OI+0A0irEOM1zfGLFqRjxZwGNuG
hazg4hxWcKZlJc39htpaMGGetFub1ddHCu15hXTDsx/6GQJxrVdsNbiYQrxi
CpZQa31X4KIC9yGJoCBIT2zZkh05kqxVavHThl7QwDBxQMSAV2czHX0QjW3I
yrMoMIFfjJ2FVsZzV1zx74WFj/TrhwC00c4gPsu+08hA9XOZDCLfqqoyUeS4
w5rHJ09+r7yc3oFua783SOO+u/uj+voXm5txAzLokG8RoBtAxisZ245nFEPC
M+k0nX87adKfhXnj183NO2pqvub79112GeKl+e1p02j2wYQJsBtZXRdpTn3Y
2sr9sZoaXlgdJkeB1liWF45KvE3vzRMnbpk6FUd+sH9/kE+nWB++vn8/WbYz
nb6nudlEXYntB6anCgp+1NLCE1z0QlAbQ3Cwo+PnuGXUKGLI5mcfNnDdy7Nm
4XDDoo2JfPoRAzgELwPo1T17uOeXc20fYvyOYcPIK6BEkOImCXkwam4TYQ4Q
jidbWiCc6LCjR2PIvOUVejAeM1GiaDx55ZW0+VVFhcZGAe3wNWNBgwaT+Vnh
A1kzrCwwMNruqKtbP2iQQrvAysKkTaNGmeRvZaXIxa9UVRknjR8fw2LmSCA4
5EnA8Gy8Yp9TxP+2IUOeKys7smGD/cWnhwYIAWRyiNrRg2f+AH1+OB7XDxy4
ecIEZQOCy8ZamjY7583jqhyOwgRMe8knr776501NPXPmeHF8SlRu5ipGO2Rj
DSJ5B4l0fnbbNiV0oBNWxpe2dVLTCpR5zTZOeUO2BNA9F11EstDco9k6j7T2
8LJlqzIZBi/uARckB6xwhxpzW2Ox1YTze+B1678MMFYXFjLZKZRv7NOHIIEG
E4nyMB4Cj5F7ccgaatEGIwlT2GSAr5laYcgrZloQPbJyZVBVAETTueYbiyUR
xlAe5pGAMYQQvaW8fPfSpUxD6plSuEEcNPylZRMlEIeSQ+3t7xQXP1RU9LdN
Tcyb/IgIfKTEEGhGNmh7a/ZKoECTqPnX3X1y6NBHKyruGDr01spKBS3YGM9/
P368H+YaAtiMnUvNcxEx8DIs2sD/p5YWDd6DGzfiHN7LWvWkJW8j/dUfF8Gp
9y66iHdH+/UjbjTHAJrp2LCeDO0Isl2reS5UBnl/xw6e4AgnYRMsaJ6ld2A/
nfjJ3FZF+s0sCASZD7HdTU3vzZ5N0pI/ENbd3k7PN5Yv/8/hww+OHm3kXRn4
LBlm243Dh9Nm97Bhx6h0u7r8HL6lryon6hKBFJs/07CmBPBS//40fn/MmLYc
1pSb3PNvmptp925jYy67kTYjPREbSWZkSZuz2qTVsWOx97OWS1L6YVueiUvS
hLnr6flo/vzv1tcbH/g5XA6IbEu7WEKR6kGbM3zXmsgxmf9zVoYmQmdZHuVQ
NvxHc6AYvKlw5EFQpM9eUy52AlvtzJQSCvHRng2qFCyJ6jUeTDXqsmYkPZnj
o5i2iDNHpqzjhmqHWwa8qTnn2Nbc8SxsAAGOLHFSAl2OcdWuupo6kE5Idkxa
23yXySQm0KVhLl3iWrowktYmf0mXAObo8l2ccuXeszOQmSnlgYA56yjfZS/B
DqJBbSM+I/5ielJiQVhtpZRSBKim7uiNhfRh6rp0fKTFuLIVq65BTQ5GTay2
CtMKTWPKNBJ6h0u1XzAW4jEvhioj6SkRLWrs6iGlzrLmqlgbLQ6tTFPngUZB
5nwZoK6wffTra/v2wUZxaB3rMzOZzotFtxjR3BuPd82scYm0fOj660WCJCJr
z4oVsBBIVOXy49tvxwTFk2NIrogjTJrydfFiExG2UjNrWyYC4/XP22f6/nN7
O44Kqk4XqpgNzTxaOVoTmRgBmlnnloT2k6PVTvLoycLHtCgIY50evA5WO3Fp
LJJYIZk5QNiIKmpLyPEWGO9/vaEhHmG6qn+/MEJvLi5mmvJs3Z9UHWZiYoF9
/llb27FEglSumt74/IlNm4TWItBaK8mM+W7fvnvOOEM1vMkk1BBmxEnOiUsu
oW0WmyQHarDp2zNnorCXHBIhyRzfS86OtrbbauwELTnv7Nr1THGxqaWLQnup
D2HB6yWlp+eF6mpKvcAq0L2dTv90/HhvYbb3HKH4ODRnzrE+fT6ChX4xbqJR
VpKD7eOl6P3bgwefWorD9juk9PQcbmh4edmy3yGlNOd5QY4UaZGzzW3ZH6kU
RgEREkoxeez34SPKxH9avSMu/9h7R/O/ekf1r6ImqhrLTiElepaUqJYqyXn+
fyl/WlKiWvX0pZgYdfNeEH2n0zuK/P+rvaMK8PfvbVovPK1e8lR3tnvwW+XX
fq/ZO53ec7Nzvaw3+mf9T6t3T7bnU3emu75zzf+yd0kO4qB6OX78xkTCVDOS
Eu2jSEpZ2KvmzZKVP2oPWkXIJeWZrVs7fT/ySTRPxqWo1/AnCoNWWDDz4fol
rZWBlPtbWzfU1v4PUlL0mnv88oUtxXi9NBwfa0pLzbpgvn1eP3Dgdhb4Ts7W
X36z8hW/K9sVyFF9iZnfOvtsU3W6UfbNcePM2l+1qlnz5eU9vm5dUK/N/sV5
oJ+enR6XksIdDy9bpi2j4tAPd06eTB0ZyOF5bVmZ0SM5Ky8b8Rffr92b3RuX
E6z63JpCNWBKPlVxbOt7s/t3U1FR5K8Xdu5cncmYZ81ItgIO1nD01qopqEyl
Q/lA0vSZKIoO2lKx0ymoOSuy4Tor69a+VpYv37h9Uq8j7I+8zRMnBujM1lVd
ndnBi+R5aRdj/NPo1WrArbL1YyATK6j7jWa3DuhqaoKmYLWgLxtu1ZoN101W
Zko7Dqq4OkIGcZeRb/2V0qryngsvZDEaSYz2VVTPu5133+0sBDsdNjGbigGz
jZcllTh65ItfFEUxnLHx5fYtQWM8rp0GrTmzvXcaUlqj31pZCdWKDG1QPLJy
JTi1oqsMozrYe5R8rZzNrVbCAp21Wz9a67TnRK3w0+6Ngwfl3Ei+YSV3t8bu
vPVaYWth3x6yzULHRJRwq/bRjBbbOYjxkgojR3sr2n9Iu13mrP0WyGN7yPuu
JUvM+tfFJXLkU+Md6RiQw00yjFbkRHscUa4Ud84XXlvMC9+dPx9kGlGyWvsd
0T6S2+uNxU7qYzSYdp8Nx/nVf/OJAa/m3fTqDRoLbh8n2AWK7VLFuPLDcb3k
hhENJ4eT4kK5sjDKoG1htjr7B1WksfFHG7Wi1/Y8ON0WRmy3L8aY1eR/+o0Z
dG56sRrAdq/NxUNUMV9h5SKRrHfrigvm/0fHdZ+vD78t+K42DsZ4751MG0sZ
MnzLE+MWf7rslvLyznSaVfs3GhogxPhTniG8tPns2Uu+2RtoaLipsBBQ2djW
omLTtXbpKr5bG7FpERYCz3xaamzcNHo0LuBeX/y/etesipeSG99frz3plPao
n9+xg3fJnDGRCjnQ3pwbzvFd8Yhb64nMo1/+MoyJR4ByveCZcbA99tVa7cOb
nQXiVUuHiPno+4u4Ya4e+ItSM1fr2Y342J646V0Qjvtgn8+eZjB7gtC/4OR8
nGZm1M/Y1AGhwJUa5Fe9XrDqxWslv1gTzb+sXauvO11jxqwuKDhzi6fJkiZS
EXyXqc7hPGfPU80tFp2LUEljGtkSNvgyYGYcq72s7f1WFI3s6atDF2ZSnzLl
rnPOYdq5MZkkJQNs/5u7FmUXMeO64RT/RhT5IT9nzFivBrukZho+7zy86F0S
jmz5Qr4u3Lhq9gX7Rt3bs+H1xx4jDmiu72/EHvWBmUJTOdIjDG5fO7n9N1uJ
MVOp+GFeuKe5mfgja7Rkg9lPnoh2zSmbTP7TNzrugnGYCHMcWMwMrBiNquU4
BzkZxZz9QAWwpjw4AHobny7j/nDwxSR1YP3626qq9Inowo/zivmKh+H/OGPG
13xfk62Jpf++b0o7/GZmv9gXxeoFS2qGfzAUFoBNV1gEHHRCODB2/WTzVe+0
bT24lnszLD0PDTpboqHGWH9szRocLYQzrX/iY0dnCHSCgXn/jmHDfv3aa8H8
4VZLGsz6Mh2crDhn31DIGLI3UIhPjFXWc0WCSlfswcH3tbZy8/r+/Qw9IYGP
P7dI5MEnNm0CDL/rBAFsAz745qUZWHOFojOGIv34sT0X/LCR4ckreKeDrYsK
dO6A0CeL6FjI9xYuvPvccymp+X2ateD+D7dTx3/mhhKqPHTTPcqpUaSozqJt
/5eS7euGeYOt9lqrHTD6Hkpbc7bi+HFp5/GV3bsVNNx35uWtq6j43JUFA4+e
sf7YqkmxqNLhlE/enYDLcW+OwGzNlaoaLJlhToCYCdsytJvwq9EBiqHhmIQe
nTAx3xCKwijWbrJi3cwK5z85lu71B/KVnDCYrmeGERE/qwJfOqZD+lO28HK/
8RWEVrjTB9zgDjUXPp2k0YyDVCwwaawgR5LFV+Q0wYE+QMTjGRm41J6QMSce
eHRY3bGewpzZMBPGsNNu/KvzJQ3hnARo9OBCFEJZXuh97exrHOQrnnUgJ85d
bQyPztnohJjwuAo9+LKXF3oSVe7jvzfC4rEndsy3TgQjBsuQ4aKh9x6plzkF
Raqs8925GyF2Z4/OCPNukKH8GA/8pFHEC5v+PHsSLI12nYQiKhCKKcqe+kZk
J55TslQSxmPwzcWdUePZIC7P4dzmcvOVS4flINaMQ50LsyRkeKeI56oCit5a
Mcr+UzKkrA4edx6Prg6OrfgK4hU2P2qU86OOa+iEnD3hlNGpF+U6oP5082aK
15HZkW6FHTvDaaYwr5hsR5VOMqIHC0QSPLVu2+pBpCqqO51LPPr005qN8t13
crRgBjCU5ywTOtuZdmeAxm31VQDk55y9zMs5e2nf+7uXLp3+wzrNaSx4bIGR
e2JTpzjhKX4W1HdnVYNTsba2zKcawvLl+67ACAjVqS1e67SmzXvJh5799uxD
06kNvHxb07jDGMEeTZRxzPi1jJkx3Uu7O4kaP1+brzysSbpuX2LL1KmKVp1/
XWajCuKQyKx52Sszuv/1TmH6g5we1tXr8189stUy\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[78]=",
 CellID->14305917]
}, Open  ]],

Cell["\<\
This generates a random sparse matrix with about 2% zero, and symmetrizes it.\
\
\>", "MathCaption",
 CellID->2045809712],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"Floor", "[", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], "+", ".02"}], ",", 
       RowBox[{"{", 
        RowBox[{"40", ",", "40"}], "}"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"p", "=", 
  RowBox[{"p", "+", 
   RowBox[{"Transpose", "[", "p", "]"}]}]}]}], "Input",
 CellLabel->"In[95]:=",
 CellID->1899245228],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "63", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 63, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"40", ",", "40"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[96]=",
 CellID->1421123079]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "p", "]"}]], "Input",
 CellLabel->"In[99]:=",
 CellID->272819860],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWl9rE0EQ39zlri2xiWnS2qhgqYgPxSelKAriiwWxCIIiCGIolQaUljQP
/QR+gD7ox1137maTub3du91rclkwgezc7P3mz/6b2du74+Hk7PTXcDI6Ge4d
jYcXZ6OTy72352NRFTYYY9fi/2eXiWsurpL/NeeC5suOKEMB6CMNBA0E3Ra0
SXh5P0T+DkgDgMsf1HYSnbehDKf3ElmCRa0U0YMiSvlpmUP1CW+8X2jnVkX/
LBEFvm1hf7Jo2kREtiv6tG1hMZD1GU1aXzOIRfnUK9XQM3pd1SfoBxZTRLUR
LPOsw2crJyArZUfhXVaSadVuivKKpTTnEWpIJlpEa6FVu0qr7pbwA62WptZi
qPNG05NBfZ6hdQiKDaBJlX4dNhX9E4XXSwUpLVxNoBkAP4D+Pn24wWextlhS
akeAUTv1U1ppacdoPjbW0cbIyUbBPDXpVmeNYc5tWupoadHqSC8e1Ub/jpD2
kaorxT/pHT6bw5Ggx95Jyfa1kL4WNMB2+i39DdB/3zCQ7C5Iov653sU+eIR9
ckD6yG/pl4juIt3XStFcrsayMg1UNo1kIUFMY7EaBV0saPRls6GNRWClpWfI
R6Wa3XKK1H+YRXKnnOLQY4c6XMnOwXV0PqGt++6jUjCrjFpzs0md0SbJ4tXT
QakP3kmZxnIe6OeIfrF0dP0x+39ARTgGsFJizBEwA7eQxlhvt1Z80kbPbdTY
sc9neQKo3LEMFBzVgWE8Tgkty+JfobUNGuMVxZqI6B7pbds6r8gP7AMycnLn
55Y1XXOMyaIa5cpzjs0picrLPfrXwtEx2CP7A1OuM+jn2TMVfbbLyHoYgeTI
fVw6uv62B+jf+dLRsqdg3QTkGaHtvbTcRXSJlrqkZUaKUSpG/pX30t9Ju/Po
9LFE/kxZNKMjE5XCXN50z1smD23ylJs1YYRBz40XZinpD2HhAq9tzmd9awPl
n+LYPOH61WJj1Sbvae045r8yX33JBe85ORfX7M+WLyWfHOVOMuRVzpFuJr2I
Z1w39E9Eq3O1frQ/ffIY0e+06CRDsfxZV0Yqlz/WEtk1RSYs0lEQsWKjNmAH
qOWzwVOzNOWlli+Vfcm/yUvei4JScQ3lPUXK4X1gRQ/m+EYy50GyZ8G4f0Ui
+Xpy1/Ted/XNhr3c6puN+fi0+mbjpt9ssMY/4yinZg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{146, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[99]=",
 CellID->733542895]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["MinCut",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MinCut"]], "InlineFormula"],
 " to try to reorder the matrix into block diagonal form, with the number of \
off-diagonal elements minimized."
}], "MathCaption",
 CellID->22704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", 
  RowBox[{"MinCut", "[", 
   RowBox[{"p", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[97]:=",
 CellID->9930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "5", ",", "6", ",", "8", ",", "10", ",", 
     "11", ",", "15", ",", "22", ",", "25", ",", "27", ",", "29", ",", "30", 
     ",", "31", ",", "34", ",", "35", ",", "37", ",", "38", ",", "40"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "7", ",", "9", ",", "12", ",", "13", ",", "14", ",", "16", ",", 
     "17", ",", "18", ",", "19", ",", "20", ",", "21", ",", "23", ",", "24", 
     ",", "26", ",", "28", ",", "32", ",", "33", ",", "36", ",", "39"}], 
    "}"}]}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{504, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[97]=",
 CellID->2098309475]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"p", "\[LeftDoubleBracket]", 
   RowBox[{
    RowBox[{"Flatten", "[", "order", "]"}], ",", 
    RowBox[{"Flatten", "[", "order", "]"}]}], "\[RightDoubleBracket]"}], 
  "]"}]], "Input",
 CellLabel->"In[98]:=",
 CellID->22386],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWl9v0zAQT5s0haKqPCDWMe0P4hEJBAJpiBeYBAg0NAkknnigmjatD8A0
+gUmIXjgA/AJ9sCnNL7knDr2ObbbpHWnVaqvTn6/u7Pj3F3cvB9NTo6+jibj
w9HOm7PR6cn48MfO6+9n/FDciqLogn//DSP+m/Ff2feCMS71dsDbmAPWUba5
bGM/UfpwPsb+BrABwMQHjt7MdGZtXJzLuBIWtcqINWg6eb9oNdS61KfOD612
+jP6Z9ds8+02zmfUKYaIyMGMPtksruE1aWuahhSzhGjKJ/s8mr2e1SeY+SiV
EXXPZ+7ZAM/fQRkb+j53kumuhXX8J4pwPWdtR9YA/m8q/m9Z+tukltyCMmb0
sdOg3YS0GFPeENdK7f+mzmsaIHS2QGaH6Ls1UTTt8Sb+dXRvTzlOs9u5rLz3
wAIAhOYXbBqZq5lCOwKM2o3+a/Ndj423aANIXS4fedmqWHs2G+YrzuT11PfU
dYNkqWssFNQujqbHZcLlpiTDZr9CdIrySXCsY6/xhIMOda3WiTpg5TUHdzOs
RRV32dhbiL6PMkFJRzG5ElFjqqsmWUceUWMJUeSIivzsbInQW87avpZFrH/u
bcmeA4Eu9D9j5arPMdvNMQKXGsd3ttQ7z+F6VKwvTZu2jpqMD/s4b7tLRy8+
Ngr/bqEcokwvOVtkyR6yuivD/simNanMvhs8+wuiN7zGu0jWhDepc34NB30u
XRcdLe/eqZHXxJQ5mN7SXMitLUuUtF8vjuuKiHzhn//EM8Y+hash/0FX2HiH
/Q7Bmy+zmkbhUIc47G2Redw4ywY7Ur1TmdHJp+zF5PQ+zuJDlE+ZT+UcAlvE
VththGzxIXg21OjJ35cRMA9WmCGeQcQsfA6Wdbx09ANEf1oxdDgzSMezfOtU
fEzZW4+ysZa3F7NH7m8Fyoke1u9ibwMqnseMrinr8wK6NuvbiEtqsxrG2Jv2
wqU2EE8P52V9zKVGKHGt95YfWuRptyzRJBqQP5eGDHUfV8RVWK8pUSGHw1p+
VllVNPxHDrFoTKIhYhVR2cTS8mE343YVjvrEa7JMRU27NrErdTqzNugKLd8M
416UL43+t695AG3TbxWILHONiVU4fYvC9K7F1XtS7v5dvSdVj09X70nN+55U
1PoPXoyiuQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{165, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[98]=",
 CellID->104504521]
}, Open  ]],

Cell[CellGroupData[{

Cell["Applications", "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->1131827915],

Cell[TextData[{
 "One of the important uses of the ",
 Cell[BoxData[
  ButtonBox["MinCut",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MinCut"]], "InlineFormula"],
 " function is in partitioning graphs and meshes into subdomains of roughly \
equal size, so that the number of edges cut by the partition is minimized. \
This is important in areas such as parallel computing, where each processor \
works on one subdomain and the communication overhead between processors must \
be minimized. The communication overhead is proportional to the number of \
edges cut, so the number of edges cut by the partition must be minimized."
}], "Text",
 CellID->221039197],

Cell["\<\
Suppose a parallel finite element structural analysis is to be carried out on \
a three\[Hyphen]dimensional structure. An irregular mesh is generated to \
model the structure.\
\>", "Text",
 CellID->329725901],

Cell["\<\
This shows a graph illustrating the connection between vertices of the mesh.\
\>", "MathCaption",
 CellID->2091432269],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
   "Import", "[", "\"\<LinearAlgebraExamples/Data/dwt_1005.psa\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", "g", "]"}]}], "Input",
 CellLabel->"In[108]:=",
 CellID->1903220028],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9nWd0XMeV59/rHNAAGjkQGSCYKZIgwQDmTIo555xEMSdRiQQTCIKZBAMY
QVLMRCBIZVvBsmTJtqyxvGPJM7Y1a88Z71mf4z1nPsyH/aD9Vd3XhRY9O992
fehW4/Xrejf+771Vt6onLdu+dtWGZdvXrVhWOHbrss1r163YVjhm01YuuW3L
sp7w/9Ysi/ff807//8n33/Pf/9ev6erVW1PzT5bVJv+WzP7Qamj/LBCNvm0+
81iP1j1/nTdr1/76fNz3ExLe0jc85jVk37Fc6i+336+eoW6ob7/XnZn5Lp/a
3ODRd82JTP3bH//4zF2Bt976H88V3h7sX+d1tcjQfeyNoz1zZWQe74z8ih5T
6H+u81Pr2c+T9JgZ6tX/v//jP07k5w9MreaeqH2JV7/1IEar97HzjZfUi09G
nDu2NSPhnpAr97ldbT8YOVO9hpb0OyICsvWr22rKtE6HrVu8Xzzzx7vVPcHc
DEeI3RKPZiXdhyNby8vlarOi7WMFslNb1Gf247G5r5WFTk5zjW7o2zfquuZ+
hrMtcXSuWPyzO5MmLY8M9blbNZ1ev3Vfk6Oe4PH84AleZNu79H7PkJJDafSq
SMCb4blk9Ox1NVvbtMwKC3+kaLSUEir9W9ZmTfBYTZbQku2u71P24Nq1/+6M
nq11EfY8dMbR4wY1DfDamm5fgJkLvXq9uvVTMSGre5z21N+eZ/6u1JLTfz9O
tBtD9m0+8LlbZnd8mSsuq9XRnstudaQSR0liRpqySttuyQtfyXA3VPnWlgZP
zPBPOJKaOto121E/r762EnV/xDx31PCPeFOQdq95yZJ7M2ZMTl+nbb/ZkYRn
L/4Z8lqPRMJHs7Iu9Ox5d+pU7l49+iIXly346XNqxISM8F0lTbupLEPZQsRu
DFh39Lda3Xo4r6cttZ3iKJrp26Wlqwvu2vLcJ9Sr6zivwzKro+7r+otKEaW+
upOFhW9v3vxvv/qVfDNsaJc3E7qduzlmTIqnUZzWSMpbYb0A9cnWFcdf46/K
P9u56lZchkdZM2OW3cpr/8DWW+PHv7dr10vrfuToqFzLWh6bZl/gtWP4pEvf
zQMirtvaIZrX508dUvUxxiL85qrX1A5ZT43T2DHLqwy/rKluUrr2tL61adNn
J05ceO45WF426ITzVD2K70+fffb1nTvpoTvCZtC6q/lJgJ+FVu9C69BUa+QI
a7bQzg2wJNcL7Fp9p19dtO29Lle12+1xNNpqad7dWkqP2y1ZBuAfzxFTmFGw
zaGnVPtuqu9mOyd202jfwqB9tyBQL1baMXzqP/72N3VjWrsMctF5ZY8nEMQ9
2Z56AaaA66HgSJFdsyBjHpa1pLKOKzOG3E313xJmrg8b9nDu3A/27Pmnt97C
ENq9xq01gmz++MEHO1e9w9WJ3c/fGjeuc/go7zNc5/d5PEY8YetmPHf7fL4D
weB+n69v8CUuF3tq97ndlmu/3295NNsKtfiallCWTzsQEkN6DFrtci1y902w
b3Axyz4N7VNdo7lRG5HGOqtZTI+HHfD7haAuXT7M1ygqHHS09xR76wq9x5Q9
+ZQBV9jrwT8Hp30x/BUZ5mnEyI42Ob6p7/KI+RXZh0a75+griYKHWNeZTY3Y
4erumz+prcV2EB+SwbocuuwmzZn/cv/+yFf0CbGHEhONDyU73uJy8brEWxmx
1U3lkdM1SUmHEhJqU1PjTKQVNtV9VmK7rGwbWSmrsyyxckTKe6THxVGu2WLD
og++jmyD9j1H8vaoRXYf0RxSFe/lo7H+Bbyd2v/Gv//bv1k5Grlz0x+L5/bz
bBTm7Jgle5Bxtud8edn7+GNGuxxVZOjf6y0Ns49jOGAVIJRk+2osODxO8tza
WLUH1Huydu13H32EpLA+vk54/UlNzQt5U54rurOuz86znTr9trmZ66LWLsEa
1ArZMDUyziUFTd3GLJy/jbTEFz2YqRCA8PWVZDsGMUoXWpgakRXTSEms8WA4
7LOdgfS4STGfftzb2mCeeTAYnJS6hvezRzUhwHZP0tHEzaWnL77Yy94s8gjw
jSW+/j3zb42IbpPIiJ7x7CwtyQL1mv7w+q9LvHUh67bR29LgoCz7jFvfj0S5
i6/8/Px55HeqpGRy2lquVyXtfjR//j+/847lwnct91eNjVerqibxmX5yBk8T
bmtTUo7n5VVlHOBy5+R6zK4mMfFoZuaZsrI1WRPEbfq6XkQKGCWvRgoizUWu
CkgQh3DdHDvWSmhauHB+r5qQ58HgzANnOnY8FInsDwTiRYzVajtOMprhBp6I
iPd7vRW+7Sou+Y8eCASMgZaClYKyPAaKJYQB6QAW6GSFdMwTac+b+JR4NjV7
gyJc+7skQfPT5z6fvJKLlb7NCbZGPrIZHfOsQh1DkGIfj4JhQc5+7g1jvPNU
5LEbkTpGyV1oEF+/O22a2DG8X+rXz3Lj4VYx74A7g/Uuu7mhouLKwIGHk5NP
FhWlaJrR+OnSUqI8F+syMnh1/NturUFSXi/SEQvl621r1qBBeTAONWzYp3hZ
UGPy/v3fJie/Pany1qXKSiD1GWjE1w+GQkhwRv5WLbd0BZOBgAQddKxhTRu4
NRJY3tZjKQni2l7bQTCsiHsIkfA0t/Nr3DO+y1nLpThMBd1MzGfEN55/PjEs
j2zt7d6qYNaDtNsEIrlheXgwWYjK60TORRobBE8kthmk7Sz2z78haa8DCQSk
X127tnvA+orOzXsWN0rm1CnrljguVCz29CvJfpDoVzZEany6rAzKTxQUvFg8
MzddDTWp16XDSUlY87muXY+kpQU8jwxq4tAXe/W6vPexiFQqhTR0m5n0UFJM
FI4ukaPRKL43P2MeDoapMtyEyDIuElf7uDbtdSw6hH9MTFohLs+Qv7h4EYmJ
4pV/KE/0CcS9PnpXRaem+rovlw44pvn3uWMRzQhG4tTIglonTsXJMND68A8l
vqOjMndHLUm2FX2AhM6ni+TxGA72JeaTFHlixeoqFINjYn3oNC2WA5DKnu/R
A9+KMawunigsBAe4WJeZ6Vil1fxhdTWeIrEhU8zywsmvb44eTXhRYceepXJs
142ZweeBDPSi0loTFq1H57XxI/+D2iCV/QsmVSW/TO6LkGTQXVNOQyBK4UEt
S5d+UV+PQTyYNUsnvordae4xvV1bdIZwBpyAe5FYwFSLIrFi9dqZsR6vWqX5
VV+eFZ68Lm9Kluus4KhUbbg2dscjUXPMC1uKPUfgD6/9+u7dp+vXr0gaXuQ6
jClAKO7yxoQJyG1D8cyMoJLk8Oz9xABcjdyn3foNvpB+mZQPy0QO57p3540O
Go+j/jtzkqYfSU+/MWoUiEG+SlKhsEr4kjiONMUb0xAK440PLRa8ZzCunMjL
E3RzOXFRao1WvPzczru5/ou5kVuQlNsumXIpNcaO+rhjwukZvvHH8/OxgfHh
JWItRdZBCKcGuNS/f7WOjlSHg/qpgA8pKIzgTYR+88UXgTrAWDwVkEXntyZM
wHhMnvlk3bpTRUWIS+UWOs8tych4W6wKvAJzjuXmXh8xIqqxlbT36uDBeNvt
yZN50sTE5VzsET1RXvg43XVR4j81IGr4tq2tdcUKiJAvqietXXuuWzeAbk3m
eCd6as/w4tqPFi5EfNeGDiV4WB3a5eDPSdWW4GujSsAMDoXDqrjT30uUAJZu
1Ut69UldHTzw6K2LWiVAHs/NBX/q0tM1EiSIteP0WMyxnJz7M2euTB6RqtFx
QHAbf+KWZeqpGWLshza04JCwv8/r1Rp9HA3cnZs8A6aIqqdLSojeOpQp7rhI
ZIE7kD+Wu0Xykt8gS2K0Tsnnxg1qk+hHQBmfsFTlwtYerNZv3XNsaXD0lX/9
4gtlS3ntEgiTa5T6j63stB5HQBvoS4c55S/prgsm68skiQVpxRiRZYr3hsRC
JPrR/v1XBg3CEKGQDE4SCKwTj2peuhQppeqbid1WF+0VfAfL/dmpUzIKWsfV
bk+aBPAwxPLBp3h+SvD+wqwFxFdJY3iG8mOTswrEkTKqsfXVcKV/CwWTmL7U
al67WZ6LdkkQfsA3A+CymDkOLfnT0AoqliNd7JecXFL4nje+TWaYUD58b+2+
5LnC24OKG/hwYHgHaEk9C/XE7bTAG1asUERRePmSwMBO0fMKDbqqZ3b88+ef
61xbZcHzojPvTJmiULFPHxNgIbW+SxcEgyO9s20bAt/abXFe1hO/p4WUE6T9
6dGjq0ddsGKTM6QQJjn767ff8pCG11tw6c3DD2CZeKZwrGcoimEXpvknRoXU
UZkEA2Ka1K+SW2LkEPDllSvEgB+98ooJGCfy82H1eIcOUE5GSom2b9VdstBr
Q4YgGrTEF/WsTKbU5vgCFt66fPmVAQNujBzJo1dGR2KTCzPn48X4FAwyoE65
2pbO/VikLEmLEoj2wxBRMkEDM29E7ahs01xV4w6K7MqP4xD7RVfoFMcrdh1G
8Fw+tf6KyijtUb3sTSrRs5Tq+vu3QBnpJ37VOHLkqtTRZcETy0pW/+2770iN
QT5EgwJXDq+39LwFYcSEVs1hKV5XnngW7MZRyQGIrsLG9KrbmFrT4sWM/HDO
nB+/9hrW7syl2E04D8Q/WrAAL1UGaj2UwAC0HZy2H1DAEREiCQMKkOkzhBjH
Y0T0CgbjL8iOmxFZtZ6CaFq0SFJU47UpC6e+SyqEft5/6aU7kyb9+tatRb0P
CVZDBKTAktit193C+MAJQ/fUVQjOBRrwXRT+uydPZDoKK0BAqIhIdaq0dKxv
vhJQ2c1umVeWFa/6cN++n9bV8anKCPQMrUfMkv/hgy7lhB7eHJi6D4jev/ZB
HGeJPBgOIBQgBtt7510V+P3d06doY/+UaixngL1Sz0gxchQeMDkAA2sh6xOr
9rlbCKAXe/fmdUvXRTg0WkVpPJnnWpqzXOESU5mS8YKl51QB0NXdNiFS0nzA
FwpEkkiF3AcR3p81a7R7jhWb9rNVqtZSYNWgUMWU63/+9reW70x5OekPEuNR
fIBi8tsRJ0lqlYGRXfyFu/zjo0dmoosrmMsvGxqIfpJMif6iKB9iYfPzs2ex
iC1dFvbIu7mu9w5oxxkZBePilYgDFQyhyNA8pooJ8Ta/wztiewRIFA7MgziS
svZMP1Psrl2QMW9e1z0qeFgvKK4ltiTaNy6c+g2hCekS0OGI4SXQ4zyYHW6G
8UjFKhwWOwarMQRffGXTTyRfXjTnJ/v3fK3y/NTX7k+fbiYQQa1unlcFSbHr
f/nJT/gWypqjZmhVBMHSRVg8b54uTEhzNX+Zgt+8vbL/KUzMDk/GvtXUiGUR
fOURZHj3pk//9NixkFsmtFudiV+rLRB4qoZxqXAY5Dukmvydl/u2eBzveTY0
xfOnZtsA1/lpcxAzDzfRC6odc3E14/DYXW6gId2+MN09xqR+6PBUcbEoTeDA
50XLujrCGNFyevC2EGbp+d8k5E36ye3kQxgLusOyEMRf/uEflicOwxmWFCwH
wciiwvZNwcokD7mru3bHxOOMAPW4LUFjn8uFtIgMpYHj81JnYxlgNtbg8Ka9
rwh+cF0cntAFMhXpUbCgJb7+Jf5j1Stui4Fho1gDeGMqVgyKK4AFN28qm0NQ
IG5LSo3bvrlhw86K1dQtKgpqzRWLH6Dd//Xdd1gQ10jysUk8H0H85v59nBld
frxvH7nnInff2DRXa92udwU/ERYP4MFPXnhBzRNYbbkJjTdGj8ZVIYJxoCZO
bx7UBenIgGRL52odyL9RyJsbN4LbjLaoT43gPBkIufynx48v8Q8ganR17VbZ
W2ArskTyeB22xSN49PPRVeqj0Hb8QCKr5s5rQBvPhFTRsH9JfzVZObr4KMKH
SbxZoYlgdLm7umv6pdmRqaAWkvxw716egCJgglENRiBM5LRy2FlLLy3F8ecW
PBs79mcyYh5h8WRBwR/efx+uMZ5f377tFKTuln9+5x2SccTLWJiGMU8JrPCI
vQlWGtwQZ4Z30V/4SeufgNXFeUvf3b6dW0V/JsKBlZaWcXrMzVVWA4UEVch5
MGcObkBap4uNttWrflVRrAwpw9MgDBYUvK881/8k3vPcyAK1ut1OXMsjY4cm
tIIlg1Fk9qvSxnROvTi64qHk5mJDfBRxvSHVBtkoTAqH1S9/ycXuycd7FauM
W0BUlepioXKTrFKMKqrD6AhM1HtYxPgqVVTLwgqKy/acw8+pDM93747Iob9x
xAipaE3qbvJCSgBuOLHmIrHvZPUnBe21fYn4BPYx2rfQZz1I9t+pSFWrgkNS
XiXcYhiYBCCP9CSXZrSvbtxAJ8TmdR0mS5XRwVbT3rNHNeEcHbLfFMljcKgE
yYOEmK1wGJSEWGSNreKrxEsy2XGBhU7ea8fWbKm0wB1ETT5IRYkwJuuoOa78
1Ev9X1B1cdqc+q23MAmSGPwZhEA1FIZKnvE8Op7hdmYhIUGqL66gXgRI0AfM
LvXt+2LhdER0puYLGJFYsGDy20JsLO9VX+yZemrwwA+J7/CIC/JgBmEoR4uC
qqAPpFXmnLb0Sthfv/lGFAOeVHnXAJagFV4HMBN+kDJpIQArq0JQhoi58sbE
iVinWuHQAQYd8xiBoDgOS1sf/kHBcp66k9T589OnSUTBvn5ZauWpn3sDg1Dq
QxiyRFSQBwybWRJZVhlgLdczG29IiMBmgS8Iw23hc5KGHaJgD80jg4AUD+fN
Y+T8vHflK5/U1kquW2QfIstjBLT36dGjOB6amZazkY9GFtQqyXjr5iROE9Z4
BOPzRqpufIgvOj4ZxyM0U2ZX61lFMSwKvAezZmVE7gsAvKDX+EfmHwaQiRN4
4fmePY8sOtExfGp56RogUaZ3jqSlyVzvkvxlshzw/u7dJFBIRrCEQNjt+/aV
VVIE7hGZQ3m/bo8Jf4xvCidB2mRJl3BfqJfldyRLLOcKqPPO1q3YMIEOOmAA
kUltXFbwFAfgX7zFlvbKvSQpKGEWA7s2eDCGgKWsz59KfGyod0wJB8J0IQ0x
y6qFADKwIgkTroLsYxNlah0OsUk6OXLQO5jM/tX3hFfxEaRIVEEqrcuWAXBf
nDtHuSB5YTRwb9eU05ZbOVeaTG6D9jWzD3fNuIwqL/TseaqoCP54gApVvXpN
0rVtj+gJO7YEQykNlsbxGY3FGBXO9vt8ICXw2bx4MWUbCSmDEA27ZV3tnexE
SaBH1gn9YjR6ClV5CzKfAK7LvD3ZF1xI5OE9IEKwtYRPYojMqFHdU8Us6Vsr
+Wd7JazzeJn1yoAZZ3LF3YIq+QB5I+zLAwYczc6eVbKLj+ZNeCILboSGeT0P
Bqy7feyNYut4i+Thek4uH5ce418kszsCJEPT91B2Iy+4xW+BW4bFzswslhQZ
MkE+q2iHorXgKtXagbUPuBJbiH4ss7ojq94FVmaFJ+N7WDny0dV/2dtbtx5J
Td2z8wvBgthcRcuhSIT6c0Cfd/qmK/yeOfwBDwLp12ZP7N/rrYXZC3l6XXo6
pkctTqQDpjMTHwhhrw7fVmjXvDjgVRx1n15TlGJdZZFxPKv03azbJniVp7pd
iv+BCTtRyjVi/pYtYC/qJMwNqfr4+KsfIF+XCvpBPnJiGfVrZiZ2/u7OnS/k
TVFBR2edPhwAfwKFVPoUCmH6ep7Hg6djSKiLEKhlU+hxCt7mnxw6JLlDTlqr
QVrxbi4iM+T649dfxzZ45BhdZcoi4Ez/hH/5+GOecra8HP0fz8+H6RWJw0hS
STGFZ23bnQQ31MqBbYOTJLLlkTMR3wPDPI5DQnipshLiZW2d526YrrLwSv+W
O5MnP2z8GiW/Ou8y0QwwB3+gJzZj/zjNOk+CT/lPgCAiCJHLFvy0s84DgcTD
KSl8ujp1tFou0/yHEl03rzT8Hnv+y1df4YSbO82v6NQk4WF4zgHtUykQMSVz
PVfGlp1w6hhfGzfzGLHDEwUFMvUoK5eSfcZz7qCI9Qh8xLpIdpsWLFgaGAj/
CR4FiW5t9kAqSZks8PAq9QeaQPSMqeYv5s59a/NmWd0EtDaVzwP2ZiVMkapw
tGeuiqlZ+8xyte7mSBe5Dwhuo5IAcg8GAous3jK9JJkgSMDjiKCAGNHFea6r
meeqiktnjxEDA7frPyOAz0+fSwn+xvjxpDF8jmtRMSj8k26ixTN/LLMMzuyu
lkMyX5XFRNSPGRFBSaaOpKS0rVmzxFtJJZ2grYGHSBeEjiBus+wmESWF8ItV
Yq0mkfvZyZPoD59ErNVut2nmcWbh7WYKi446gogm+JfvOSXGyP0royMHVrxb
VaJXHD0bsUE4gnk4wpA7p1ygSCOGg3Q4EBI5uuxM75J75Kk4+QG//3THjkS4
E3l52AF/yrJnyNcikmjvRRNJ5MfNPQjGgkmyDkFcRiqgPTZya/z4ddkThw75
RPGdoKUnctg29gh6xB4gRC24DRhgKpJT66+UBk/gkHgjAtRz227ww6tXh53q
RpW+gweTpvJMUyTj60iVETFrbJc/KXCFkYGh7b9/7z0t+SRMBNTj2aS+WBIY
LREv5FdJoNtqyrLPJFpXcUQVE/Pb+XUbuTur7oiZcHosK0stakciCK++a1c1
FapnnngDtIL5tampY7RVC498i7h9rkcPakK8D5J1reyGqJqkpN6uzWJ9peAZ
OEcihjh39luLFGWCuNKzkViCpE3wcHq6XM1cFPYRHMXFVB2o8r3KSII+WeVv
KQuemBV8/mRRkcocdCsVkSwvjks0lGmd4elOxDXrqZW+zdTO2LtatdO9LomY
0mIdZU0SjSHDFPGeAL/f75+gFw14gkQM/IyPuMHgXVhb99CMvZgBQE8WSCol
KgWgZEZII1iG8SCZRkGNICxqbJ+d5OkutcqGUd+dNg3xUjxBsTwLfcdx6fvN
3bsynZ/jvYCqQXCx9IG69taQo15ConPi+rDIJtUtYo/ia5gmzjIm1vsp0z56
Mkd/R/xiRO5BqMMPIUHNfbgOv1CxC1WJVCu9m4Bb2AWr2rEhoqV6cs1F7l40
/gHhh/TrxsiROAt2SkWheht8Pgm5fEE40q9hE5l4nizaLw0OyvFddOmVOzxY
ei0T5WnkmcAWGsIWMd9Uy8z/q0Ua8gOkoH09UUok4+iq1SM1VVoOFnv6yTyK
pFC6Ay5EIMUrie8HgkEeQSYA3cQYEIKvaBx2S7ZuJOZwYCIMZOFPxBneAIik
9OCXko9eK/bgWVcHDSJejPUvkOwIqlMTHs7wjQe6MDyG13e6wYB1Oc+b/tBA
hn0O8eEjUIizrUwa3q9rKwNrXQepEiikCC1nO3fGs/ARYXNsrH51F+c0/z3d
IfJOiQj7AwGoAowZHqHyHkq0FN2K5qqqoOuek90QvRGIUQGE6l4dD54LZEBk
b3uzzHUTMg+FQsiDvF2vQwfABGR7MCFBInp5pspQA66HQqPM/D5DY7BvsdOt
RAjlkViHWmW3rDc3bJC4FpG+SLwd24OXk8XFWBGJK44JOztWvi2OLJ6fAHjW
RqP4mJkXdVY27fOHwmE0TkgWb5B1sBhGaC+1m6PWJa/1sDJhd5wFe03FYMlk
iPCTYZ2TeSTx3Aj2Wxo4ToBAV5iIYNjAyC7JHKRlRGWq0ThfJCNVqoxGj2Vn
K7e3+5T6j+Hz8gRE4vR7C8UyzSHdPoM8q0lPZkemSiKM/8VTPCa4xGc9kBZY
5TxKt9KbgvtgPxgBUSFgO50J/oCnSfgvsmvwbDBMYWmi1jypgiQtbrtV24gf
b0P4xFEqJY9edVR8ia8ghQ6hyyDXwqwFSAENSTlpIN2J1PrugHQGLnL3xU4H
ulZF7ctIf8n8z4pjTyaOUUYk2JJRh3Vz843p3nGgPVZARoI/kHLLFJca3a8r
NekXw0KpXyGya/ol1UQs1GPhWE9tWhpUbem8wEE46av87qOPIAlnBdiQ0SG8
McFZ6g74nwjl+jWAYmRagNv2685DAAjT16v++dSMsD0wdZ+xP5Wfut2AzoFQ
CMn94f33Idus4lCxDO6tzKus8CnAKwGStJwk/K1Nm7gfmyboMpTgSk7CTdSk
wCIx8cYo1bqltesGO6SXz3LhqpYH4mTe4fhrH8ZTv2nOA4PJ+zUywAmVjM5q
otIVpZOOZr7bxVIlp+qRc7sZXRrCRRMq7Ni26X+MVscmWS09l6hk4/HgD4w+
wppNmdrBfcqkGuAOhMucp+/93bsZCaCSmQKSA/GBgrR7DmrkxNEvBolMVfOi
poonYC6afp+ZPJvmHoPs0J+MleVp4E7VXhPfb6Is0+mN1z2Daq5fVt7xe5nD
sPS8iKWaTi2vmemlolD0S5YkSz4mB/PEJiCUoETyuaIh3aGvb4mhiMOfthyf
2nFQcm+6ZyyVGoIjkmmrVZ20si4sTcWmb9aK/UnslUZ56bMSNEcfeBDpv+wN
wYb1U4LtGaNel6ryrhHgGxR93Yqntv0+zzMYrjN+L6ECSBXQDsbQJBm5YnWq
p9kaeSwzE5m7Y0WDtEcSyiRVAC17WRudfM5uxRQJayS/sI0UlF8aqRQkNUr2
Oys0iadJvCav/YF15MZlionWNculXtxh6xa8Dc+vszpp+1ZTKitXEg7QJ5Cb
aZ1m2ARLTTUHrTupujOfNyb1N92ZYQxXLCK2aaR1ZvB5qMYNCZnnuneXHv/A
Ly5e3GvQwecT+wR14mSrujGkpN2r+/UETb6or9c0+gnQQNu3bW2lttp8gpko
hn1aFWNDS3Gl3vYGl4MHYZMLI2LTO4ygoejOpEmEPIcuRhW6lBKCwVHalWEq
ni4S/72xHQ7K4zWNXNSVvn9el9etONMmlehpOd2+IZet14ntGlmmwmVweuJQ
gtUYdt0RLfMds1GiKmn3nz//nOrYUmOLd4nMkmN9TvHW6Pnnd95xKLNtF3Tp
hmcnBmup+WR+xbQtIzvx5Ijd6OjXddegVYAHldkKopOsK1H7CjbSx7Upal8V
NCDIWnrxScZ2t+/8cjkO4XSNE3Yko9E2GIjfIeaAJiK0bT1L5Gu6/Q22ib2J
jmIa9MqUgVGis49CBCksGbvEZE00i8vxOz7jsd5nPs9up/Hv7mrfK9VJa0LN
SYhBjgksRoMRq5Gga/qZF1YcUVOO7s2m0z+EtA39+3S7hwrp9sryyBncuFPM
L8n78WLLo17cSEHKJsd7JYvmrrTATXJj0hfPMzxoK/YYCeMVukvbK47k7NSg
fNQcBPAqiToQh7VjqNLGIHtW0Mrnp0+rAcWyz5SXK8fQoVDG4/vx9he4M3my
PEWhi30NbEl3qfS/83+GlaEky2wEUJHWq4WnGhWxOtc+k0N28h9ux9dF096L
04PlP1VaatZhBEQAm3ia/ARtoXefzkCkCJTOMyVvYF1FooCOBvE2Fmd7btMn
4FDR3l/a6f8iGZVcxFNxfehQAxjOPF0wKFR4yJT26dJQVe9K7+novbO9G2sS
mRTZh7IsNSkITqAUclcIdVtNANxIzzxuC1q3Q9YtLCLBbqyv+1L09QM/k3lP
ISyeLun1djBWeyGydKSzfdlT+aZYi6fMvV8GS3Y3Cj5gLZt159XUykYpRPG+
KRkvSA4mvZLyj8fGEPK/8K14D2yn/tm7tI37ZOXTis2iuSzJvX2mBd7Mw+nr
QQlIghQiCoHZBZPfFnkpv8py16MA99/71X+FDc94X+SF/KlUAoa4Ud4FqCjR
fauztVuQAmRrRzAVHSxnAitqqfQeZ6yWKR6xPp8ntiNRW1tgv97xs8hVQVwO
WQoIEj1vmI5egxFJXrVoyRNdSTYxHmfErC6c/NpBa1mUykh9U56SiklJJJXA
JJEP8mO7DFtkKizRdTPDOiP3UGOYyK+iwfrKlw1aeEzopv6SXOThvHl/n4sE
zKqcJM8STX99+7Z4FrHvd0+fLg0OkhxkdsIUg6hhE18ww/4R1ThUGjhmtG66
3vziyXLrhVO/Id9TtZse3yvxXh6qAqZQ+suGhv+EUtM6qPJwchbt7vdnz9Za
z6f+vzp4MMmebBcS48q1jomr6sjwrGGaPTHxm2NG2nMEkM/37Pl41SqqNKH0
t01NP0AXofSPH3zwn1AKLSa72qd3lPCeClpHQGefL0kNqSSZ6dTsDeLNUHRA
byRZ4uufaZ/J8l8VQ3XWsVxzQ+4H0DU+eTUE5tjHnb2+Vr2a7/H5Gvr1U/P1
Yl090usdH5EojCHFV+ry6pMVZv4dTkys1uuhz+651rVDKD02T3o8N3efJNKO
7lXqafZpyliBWBOLiEvS0b72epPzk3PA9tHsbNnpxsMkM2ifxfA8Q0WcbD2y
YqfA2L4l97XvTZde4r9+801vz1bBbaIRNOjCRBFM+mTsN+DsAbXtHEv1jyRa
jTKza2ot8hizO0bFppNFRahMWtwBHakwRthzJAIAXP7YToo4TIrP+9uRS7Qi
y1YbBr0uck7BGxCLeKRkzM7uV737EjUr4/Q0qSby2CacmH0kxZJWx8hR57Lg
oLzwVZPJma1Uhze3WboODZK9S9yWPZ9mblnVNXFRKqjjtIJGECrTPpvubqBw
lVlGkXkBHg0ancjLW+ytLE8867NlYbF1fzBICUZuQzEDkOBNZmvBhZ49ZdHV
tlvMkzuWvrexag+0UIHJTL2yH5GWz92CeyvskB2614YMUdTHChiZR9g9vV7m
mTT9XjEx1YevN2RZLtzRUhnAb+7f14Tru0jRL/TqhfPVRqOqE0rHlQ7Dcw8e
DIfv6L0PT9auvdfwCzONbiae1S7vrq1bRh6STdwPZs8+kprKg04UFMjciSgk
0W6kuLoycKCm3CuTMdUaHFS+JFgi+5LafVRzEDSNSwjlWFZWTSTC8Hz7VFGR
zAnJnvq2wdFX8Kq6rCwSG2nZsJx5NYuM4lHj8OG/unYNRsMxjqUr9niHDqor
QpA6wdMeo5E+RaNa9dcaDlaW35HP+rpVeJRFR+hQMwxxEg9UT3xNUFooVRjn
9492dsI+69MR6ZKx9BL8qZKS0yUlOg87jYmNTN2R7TmX4Wmo2/mOzEkG4cBM
bsDT7E6vC1TXJCVZaibPclOBOeNrzXpcsUQAdxIrynCdd+6In2/6Wq9q8E/W
XcpS9S46+8Gz3qzzkOCfPvtseWSoLKyRHag2Le2PaN2h493t251vpKiXBOwk
L+EqzMxLnX0kJeVwUpLqIdEuq7IDq60kt0VsESsQSCFRUbt33Q5cPP57qp+d
0/E5K0l2C5lsun2+esVtLeUEygj0gJssC1X5XM42ZceqvN5jOTmEMb3G4ZPZ
aZyVlBpni2G2ej6wqm6RWfGznTpV6yjMv0Weflmec2RCAMTEPtedlT9NYULc
PI6qywb71xV7jpBF1Oh9gdgfopQTPcSKh+ccwIoPJSQ06AVGJxKUeI6cLS9X
7Q9yQgL88FVYOhSJrM+bYsf2Uvb1beO66rrWT1crKgDDgVCIZ6kol5ys5hS0
1Fev+lUcnZFY7qlytHnRmbU4cTh8VM95H45Gz3bujJ+oPVNyook+18PZj308
Lw9x7dfVm8gKu3Bqfi39MFYrMGTggFeeAKPSkOLkjGYdChh1KbDyqnmrGCy3
95BoDUSuDhokDijrgtIucjglBaJ537xkyenSUuWb2nOSeAf2Quvy8GCpsojm
p4qL4VKKIq4jgOxwo8J+/YQEw6XLbgna96h2uFXNq4dCYvE4s157CYe9D41N
DQzvgCJELat33bKumtlrGTdp6YBjwieWBquY2cmCAtDip3V1kiwUBlXyMnes
2ohtabyKmrNRmhcvRtxHMzPJwtEJ4SbFrQKKdFtW2OtlP8SjBQsEAZTn5Ueu
p7suzvCOO5KRAciY7FCWBoAIbfsKf6VlwInhUkRU+jY7+Gz2TlhxKxklOemO
Jx3QSzoY9sZZKjyPyKsxUU0CHjLBbYgkGIRkMYKG2Cv+h3oA2/TYto4T+fn8
eW/6dNTYtGjRrOKdji947CaexAeCywn3Z86E3+P5+Zi26cyyY2kAIqLQ0CtP
fviDwMWefkWuw0OC64vdtWZXXtwsb5ymSlQHpZ4kxczWT1GTu0FZh7EeHVt5
rsRbNyJle4nv6PLSNTwENuChZelSc1QJUoOi68OGwXPrihVrMsZ1y7zSL/sk
n47vWo9P3p02jeCg9pLH5qQV2Unum40jRsguFOz2XLduYCXQ+sbzz/fRe9Nx
H5/1cG7yDOwWOZF4gCISIfB4fAqrIlPFtvGy+s6dYVlNLz+7yhfXoVA+Vhu0
papAZfRuu7ln/q2Z/gmYC5EdLkg28LKLerej6Gxzp/ncs673DljGUKH0/Zde
Ul3+T58ijSzdhIcQCPrUedcGD17k7qsCm33BjmGAZGFecO1IerpARDgYO6GE
z2+OHQvzqPpSv36y6jC96rbyad0R4pzTgn1+WF2NSZBgQCdVC94EqUsCA2XK
fOrg+4VxnMrKhBDQMeH0nKTp0MyTmhYuxG+pES8PGICTvTFxojg5ecUvL12S
4zXuTJkiW4wGJuwU5d4YOXJ12hgMqiKtToiR5T6US0ZFzUKKt2T+ZzL3l7Fl
YUtMys2ZifdUra1B5db48Wjqu48+kt49tZDt86m2e+0ryNoc46A7UaLSqQRB
YmpulxLogOA2RCUT3fVduyIRqaaqJUeJk0FqzezDKe5rPL7CuxWXwMVujRt3
Wqua77z54ouypXf2qCazdVxOaLFcKiEKRmNdlN/rTY9Q+kltLVpW6zoSiUE3
vJKClKoPHyTX0lVq0HRFqG2+HTqolDM9XUov+WZ+l2DNwIp36+u+RC0/OXxY
XErtrI1tEyTC7dUNSlxvW7NmZfKIzikXwq47lmmkS3ypoaJCAn58r0qcBFLQ
J0guAQQ6rg0den348KtVVTwICWKR5rijCy8/xNFXdlrPRS39MN99ZeiWwny1
IWFwyqvSNIQAZb6q/Xyi/v4tmCJpPj6qNCAz/ODx4IEfzgpPhnceiJWQMVOb
aBxSJ6UQCWCdBOr60KGrRp6XSAB2dI6en58+9/fvvy+dxdTYuBbOjjxWJA3n
U6eT0q2jUGSXlH4meMZxX/byxo8tPfeNAMgyGEeB0dSpWxer7/b3bX599K4i
d+3i3MUi7K+uX0feCAA2sJF//eILIx48H1wFgsymJtnmykckTERitbah5/PK
0Zeyztxc0O3R/PnmpAM5XGxYZjVGJM05Tnut3fTezp2yxUjhv9U2Z0zLmY4d
GQEZQe6tCRPQneyWjPgeGk/A+AjnWJHZ+S58l5odBspDk5JIlsXQ/S4HrLBu
Ej/MFulCO95tzjMZkr4H1s+/dJ/Cp27Xu7IRoH9gq9kMKruNKtKPShKgu2wD
yEZtoqmulg0mlSWN3XOud7Ff0haS5fe1wcaasar1rmfqqbLQyY2D92JPCFtt
4op14n+0f/8vGxou9unDddU9uXgx9k1dRg4O8uDGguyAkoPscTynY2/Y75LC
FeIH8yc+dTZLu1t7dLgxXx/IhKu+vWWLrMaj5T9/8YXZ1+H0PzrbrGORjVqz
a/qlQxtaLlVWwoGcBwc30k+djE2h47yct4yNaGBTyp7uGcufUuLzBZkFlFOe
ji47ozyt84vSpk5uiSjg90xZGbxLUw3xgBzFmZfUe0Tb+dX5Thpc7F7/QSxx
az00q0ZtKO+yAZBrWbYMqCJhgGp5xsQeF1SXzKwasvJtY2q1Z0XIc2VWWU2V
2qPe3bEDLeKSMhtGfUfmoCxL81oqK/X9y26p3pLg8wgK5+lVck8mLIjBW7os
7NPx4cLshUC2NKjLTgaYw9ZI1ESqWKXQDaRAK1JB4MdzcqQezEm4eWDtg+J2
PotNp7ckOl/duMFXsJq3Nm6kunowZw7ggjfJgpt0ieKQpBHcI11Uf/78c7ND
XbrW8UHUzw2/uHjxYu/eECm7i80uMvgnBcAehZfn9b7NvvZ6DOgfHz3697/8
ha9IbxFcgKhH9eIyiS1ViuzbMx16oB7oiPTxaKlNqHowjXge4ajh9Zbywscy
iUNaAzjA1IPZs3HNO5MmySbnbolHu6RfmpM4jXyKTAJwkAMluhXqjQA63Xfb
LYYLAqps1xKNah7DsoN6Uc4iXF/6kLnt+1hHuJkHS6FQ3xvbFoBt830gmbuh
9Z0dOwTtl3grSQsH5Ks0fmjGXvJXvXbqntPpVQlFVhyXXmSGe6uzY3T3uOwC
zeVLqvm/Tx+UJXNG2PvHBw4QhXkaEEzGIN31dmz6vktaw+rum0+suYhjD+2i
jGpAaDsKFauz9B6d0NubN5NOYQ1SfM7I3yrg0zF8KsF9V0ehjFXLfr533Mug
2caqPbIZkSyI9BNnJFYgHXT2uydPJA0I+J+c7dJFQrIEaaJNHH9qDoX8iuci
IlN7zBz+QPKrquSX67ffxvHX9NzqgmMr+uPXXrs9aRIaOrLoRKFdM8Bewevr
i65jc/guFvO3776T9BJdOvt+9R6rEkxD9oVCKB8IiEEfYz28/uvc4CVzZBUA
ykW+ZPYu8EV4o/4n/VHdV/n5yxOHkSAm+RVUBa07SG1nn1XOeSpx/KWsnaC0
Q22GIu/Pnm1gWzaAYCOEMFwSf/z67l2CF3KCddnXjO+Q/Qhby6tUZTAyrwbK
wMLS4Im50Zm/uX8fsQl/HeR0GDnxY1yn06+N3AHoXDj5tezuBlYqI69Y+sAU
Sktpm5SotDhvKUSoZtCuXU8UFiJmuJR9WlL/IC3HSkriLFP2naFO7ts405nb
DQ8Z9KFqpfMfW5A5Xw6XQmPQL2v9Cs1kNk3m7IjQxl/0HmOVCnkADDkAcXLF
VdkDKLsc43ccya5A7RHqjkyJJ6pPi6Lf7/+nN9+kKCGMAzvSiD085wBQQ+aO
L2F0vMqKckUXtYAlGxN+wN+BqfvweVAJ/rKSnTM2cmTHOMRAAK8oBzyWeFGV
tFuvBZ1Js8+v6rpRtqaCEy/kTSEogNDf610biLIg/z1JkTV3RQKr12vfAxfW
V77M+89Pn+ZVZAaxJHiMAIZJ9xa5GRfJzVGt4/2eVnTGlfd375ZTpfguOsY6
5IkyKyycJYGT/+3hQ9nhuqXrorK85nTXBYLZN62tFBWAljSzw3diyJklTcIW
Gf5Hr7zCB/i4HIZHwJAzHsT2lF36j9VufSoWmXhw/28tfWCW7BBGawyvT6ZS
2ENqAdohwA3T5WSkqOwCuTFqVNuqVQitsscTs/EAYd6fNk0tFGkXUXsyDh9W
NUc8X3KogIRnki9kRxRTK1KBgGwk4y7JFRXsC1+ghDoOye+XrYSjCmqxNej9
cN8+WOMNBCKI+DMZnJUKvY8PPUje75xMoWshtTO0X7/YGZmt01yjld7EpykC
yd5NvSLS6Gu9AH45fqQXrB2+8mN1vpwfYFqZpc4mFYW7hr59EQR/YqQShWS9
JdN3eVnJaqpVFJoVdWYm4AlHR8rT87ZI/PleH3cBf8Kb7Asl3ZFqThXT/Bdt
dMu+xlVxRL4AdBAUXpp6hppXzi5i9Dc3blyfPxVcnDnzF06t57Ify4ZoSa8R
WhxnxWKc8KdqCn1KgDpDICsLA5CmqrPl5foQmcex86IeSRM06YMkzQQncvn5
aXMYh5SdnMLZpaXnGWVju+YsKtmkObkDrt7ZpmZEuU3i3LCsfTgRxo2VOu2d
wkPAujvdO+50x46yEwxOnDPR7BaxC1yXHBHDj+NN1Tb4Cvy8uWEDb+T4AJCY
+yFdzhQzPX8UVPOiMzE6XApUNye98nVK77bVq8m4pK80I+UxQABXf/nqKwxe
EETIwMHEnsaWn7o6aBBxFT7NwX4HdH/2g1mzqGfBKTkX0Tnw2LcZtITgZaEq
8slOnT4gIyWJkkQOlOCNY5HSmy5TDviYnO/CN2VT+vf6FEzJE1CarHWc0JvN
MUQ5wgSN9Sl7gMaoAhANFRBGabbGvrV5sxxpg2XL6SAmLTY7WEG4tzZt4okU
ckBmzcZW+Af5GIean/tv13+mJj5l7VVQhVjEiNAhBk3gQaJQLJKL4609n1UL
jllZcr/U2roUfKy7NpTeKCXBRLBaJiHMMSygIcLDutThqsOHo88NxTNl1wUp
IMTIXs+lcz/W2WWh4D/aw6GBevxn56STksoBQAwCJc65mYkvIUeAXSb9os4m
FaeuNZMZjLpTd9ZP7K7Wc5Qnx3Hob7r9DWKbkzQdOOcjrqmaX0srF86i9mUr
7pRExHaquFi2r5zfeZdARCVDkaS2CYM+FRXiiBO6nxc+KPebFi50dsphZJrH
YsnP0Bnl33cffSQ5OAb0xoQJakGjooKgbTbOgiNEVQTL/RA7qN/7ciI21Mg9
silQDg+W04DkmJA4LsNyZUHP/ZJ/QVyCr8k5XS80ycyrZlHInan5gqRV2vVK
89pQpzpJp3t33uBogBGZn8kFuYmbz3Xtinp66wM5OyWewad0TZ/peIZ/CwwA
Veq4wlh+TmmOCCgrSB8BVBJyamSM/frQoRCKgSNjLLJjtpNLhTpar5vt9VTk
cvAPNEm0jePVLd5nTh1LoA4xByJCxYqk4d7YMajipW5Xm/bSlPFd6ymbydE+
qa3FKWTKIzPtqTr3qmdP6D2elwd6JcfSDKpS/tRzNpkSVVTnQ04OEIVmKWc7
ZD6WXAgB4FxchNxtS5x+ShQNrVLS8ZFCdT1zH+wSOEQAIFTiLQgWc5lZuN2p
hyQr02tRHnFKcL1/0mua1xINYY9l2Z9MQQ5m7Z7bOLjjVXGy5cPPB1335PAx
9Hehd2+1QX7IEHJucxgy8RpXBjEnagDtFjlKvAP0ZZH28oABZo4uTFG+MnlE
VqJ63sDwDjRxqqgIZzeHTjmzInwPbs12ZDBS9p2dKinhc7WMqVZQW9rP3K7T
W/4gAz1grbJTXa1sxfHfBatG/mCuTjhkRbN9zRJdQDH3tC5bZk4bxDaBS2rl
5wpvy04z6Z8aXVR3+sWrXJybPAOR39CVmzlADatQU56dOx8Mh6XPtrRA+s/L
YUKVSJprU+tiZm+MH29O4XmhYhc6pOaGVC7uHrSha8blAXmq6J3U+7J0CmEh
CFMtva2+IA2+QB/0U6YfyciQlq5+Rdewi4b6bxwpSM+F6b+b2PPiQrVjt0nC
aEbI8YDEIvsQ8QU4wo3B1E7R8xQkRAfwTmZPpLkwYElncwpZqszhcz/0SjaY
7Lu9c/IpyqVjWVk4bY0cjq1XBxAqpqjnlpxdxAND29XuUx1lqzIOcqVL6gVu
gwbBke3L1QYgtUUvL4989Iv6ejxA7eGO9SuqUzD/8dEjTE3awBg8xXtD9r0U
Ry62g7LdRA6jYnK8TPKc/UVOTE9zqZbHYpdeaBOZyIzEX7/5Rg58+F6v1CAH
yTrBSNIFnpwUkJX9NImcZzp3vtinD9fNIeEnCwoA+aN6E5fU6R67ube9UY6u
BdGQjOQJf/7ii5BLGnZaj6SmyvSuGcc5ldbtZjTTyaEOvxwyBEkyeGzvhxe8
l9k8gT6p+cL3Gn4R1xT72HiBHDo7rvxUvHyS1uU8LyeYx46/d5xHnXdNDW/f
GVh4Xrzilw0Nci61iiHESEMw2P3Xb7+lvu3R48OchJszAxPF19Vcuqz9YDHr
++22XGraIYHMHLEZj8KR1KGYPrWvQ7oZS3Jb9BpxOSr/6dGjh6PRWD+WinCE
eQTDSGRl6QF1cfbo5vM9e8r5mi8Wzajq/+M9ixvlwHyZr8cXOoQuF2Q2kfmj
WCmFJvW5AhDLSl31xNekQFV4afqsHKGItOQXGpw+PLdzeLjaS2TXlIbV0TS4
lrP1yfvYHDvB2HICRlSy59oFx7qkX5JDchECPiEn3E5KWS1OsFcdCh9bGRdL
QDQYFbf21irplnGZAl6ODYv9IopfGmTJfT4+cEA6PFSE0L9RkonZ9StTwVL2
W8juqME5hzXNNQeCQdAMbDG1mVqpzc4mj0HSYB0pYrnnoLPaKpWGWoN57jnp
UjdIR7BU3RbaBkM/fvVVWZcnjRjsX8dzBnlWp7jUrUNSXytul6g/EpAT1FuW
R4aWhU4CuuPN+SNq1txVURo4vrFqz/mX7g8e+KGaR9LnhifJSVBYoln+Pt+9
uyu2TOp0R7vdhxIT1eSq5DTqJP9wGNMxjWvqh2Vcm5SHOn2Id8QrrwwaRLb2
bVubLPuYo5l5JHgl3kdhhCJkt5/pDVZN7dK6FvPSCAwfzc4+U1aGCokCqV5V
eYwpOcYVihhpSW3/dQGy4Ufz5/Nkae1CeWDkK0O3qPnwrAWyB126stQJVe7r
goP53tMGBwXoVq/6lTPHr30poDsVnG2pRaFzlvRXxvaFFLsOA0raxPWsmTSr
XWn4PfF5yYATQdd9xCQalR5CkRTim5M8Q3Xf6P2Qghklvjr1GxKxZi9fbFeR
7FBot279d7ZpznLpQ75Fa6YflHFlq+Xq9LES0WXPuxx/QNZlZuNNJ3CYWDMu
vCwx4cmKFV/JjxIgNfndoqrkl9X5wdpGA5IJI0XiEL4oKXFs/4DTVwDeRO1L
prvT8SvpAtA9SBETczvae34Aodaj5QlDJASrs9C0taveZbO6YLrFE4ARKVL6
ujfg7SY2VOttNvAT+1WIgFt3aUrbmSuuA1nvHAqBc3LR1jsy5Mcj5Gz+Es8R
F2K0oqhmn9fbP0nteOqUdJY/Qd9nNCUNnnJqCIYqCNbB7Dsws7WyoAysYSXz
u6kyYcHkt02OBa1Z9llAtcClTi0oj5yOnR7QGtZ1S8D/JF6SkjfLyIs8/ciW
iv0ndLA+LOe2Z6Y9MfvSw6adUk65U6e/WyMNZabH3QsV8Cu7+aKxszGTiqxD
e/XuD/6V6DRO9b7pplaxwARLTtVtNn3bGQYcwBS1PQ4QDoXMxb2xzQlmUyNf
5iJSk0kwqgQdPVPlSMzvYx2hJHGmNyGWwCoWHs6bd+/yl0OqPl7Zaf2XV6+q
HddmV9XmTvMlmqe7Ljo9KquW/VxGdTpBdddZBK+vTFA/loSf5AZUAZthnwu5
BCZan+kSC8Sf+tBY96OOkTMzfOPNbi5pCRYm06zzztqOzC3LP4/t2L+AGimM
ZKtqp5VnrDT/YpcJzm/OeE1x7shMUJ8/TFAhXvbt0nKy+hPr2ZNddD9LUP6u
2/UunizrrZ8eP07EUrYkzyjx1N4cNy7ZTAmYXbJOv51IS5+m4DX7151tqC7l
TQFxskSPKLqZikFI0J044f37v03wNw/LO0J5Yk7hNy17yEzjnEJpjXftZypK
JSpoqh23JV4p8iMj0m3m97W1861xxKNmY+E4M7PCv0OqYtCRtGhX5Trqgirf
2hx/Q5b/SnevWjxbtvDTOC4TTEYsq3ywVOZRJwpHvAp2InZjzcZWPTvhe9L6
p37d20Jep4zA3AXDzd4H55eSIN+O6ymNyHQA0pDeOLfdennvY4ne38c1Qjtn
IeQ4vyzRKj9rIbAzvvMZ2bvkck75ao3XVHho3lEr1iOKda3qulHqTMFetar+
3DP2otfLVd/Ui7MfJvibJlXeIsZKPuv7qrFxzYTrXK3q7ZD5rLXpXiSP/F27
9elY/wJ3zI4cGI71/7XITIKz+0hHU6dLU5/qLzubfJWejS8WTAPiRqbuqOjU
xCP077lFZAnEMFKceIlQWO492DP/1ryUWeaAF4npMrov/hf6bKsFrxFaKn2b
qafULfq33CKSoGeHG/XP0qiiWMo5yQakn0NhQdzYwYSwYyuSWnQJHpYZEyVh
/Ut5oarMg/F3xBZWm0t8R0kf4seSX/4z94CHTbe/ceSrxwqbzl819WvXyI9i
lfqPTu+w2eE7M45vdWp+8ZPy8h9t3fobGUb/GqBX+MxPezAnaboq0Z09pe5H
Dn8yhv61QbdUCea0Zmc/yfDhn8bf5dF0PdbbVRtkNLc7tn8kvf0+Bz/r676U
/F9QwOt9ImNdiFHXsaA1I7mppOCp4lw++//za4+W/X8AbIfcbQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[109]=",
 CellID->398887122]
}, Open  ]],

Cell["This partitions the graph into four parts.", "MathCaption",
 CellID->1123665313],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "1"}], ";", 
  RowBox[{"parts", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Thread", "[", 
        RowBox[{"#", "->", 
         RowBox[{"i", "++"}]}], "]"}], "&"}], ",", 
      RowBox[{"MinCut", "[", 
       RowBox[{"g", ",", "4"}], "]"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[110]:=",
 CellID->2121614828],

Cell["\<\
This plots the partitioned graph, coloring nodes according to the part to \
which they belong.\
\>", "MathCaption",
 CellID->314482243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"PointSize", "[", "0.015", "]"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"0.75", "/", 
          RowBox[{"(", 
           RowBox[{"#2", "/.", "parts"}], ")"}]}], "]"}], ",", 
        RowBox[{"Point", "[", "#", "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[115]:=",
 CellID->700244740],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[115]=",
 CellID->21821958]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MinimumBandwidthOrdering", "Subsection",
 CellID->772556000],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MinimumBandwidthOrdering",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/MinimumBandwidthOrdering"], 
     StyleBox["[", "MR"], 
     StyleBox["g", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "attempts to find a vertex ordering ",
     StyleBox["r",
      FontSlant->"Italic"],
     " that minimizes the bandwidth of the underlying undirected graph of the \
graph ",
     StyleBox["g",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["MinimumBandwidthOrdering",
       BaseStyle->"Link",
       ButtonData->"paclet:GraphUtilities/ref/MinimumBandwidthOrdering"], 
      StyleBox["[", "MR"], 
      StyleBox["m", "TI"], 
      StyleBox["]", "MR"]}], " "}], Cell[TextData[{
     "attempts to find a pair of orderings ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["r", "TI"], ",", 
       StyleBox["c", "TI"], "}"}]], "InlineFormula"],
     " that minimizes the bandwidth of the matrix ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], "[", "[", 
       StyleBox["r", "TI"], ",", 
       StyleBox["c", "TI"], "]", "]"}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " is a matrix and ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " are permutations; for symmetric ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " are the same"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.10b",
 CellID->176779614],

Cell["\<\
Finding orderings that minimize the bandwidth of graphs and matrices.\
\>", "Caption",
 CellTags->"b:0.10b",
 CellID->567251896],

Cell[TextData[{
 "For a graph ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"V", ",", "E"}], "}"}], TraditionalForm]]],
 " with vertex ordering ",
 StyleBox["f",
  FontSlant->"Italic"],
 ", the ",
 StyleBox["bandwidth",
  FontSlant->"Italic"],
 " of the graph is defined as"
}], "Text",
 CellTags->"b:0.10b",
 CellID->643617657],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Max", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", ",", "v"}], "}"}], "\[Element]", " ", "E"}]], " ", "|", 
    " ", 
    RowBox[{
     RowBox[{"f", "[", "u", "]"}], " ", "-", " ", 
     RowBox[{"f", "[", "v", "]"}]}], " ", "|"}], TraditionalForm]]],
 ","
}], "Text",
 CellTags->"b:0.10b",
 CellID->44874479],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[Cell["f"], TraditionalForm]], "TI"],
 " is a mapping from ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]]],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "2", ",", " ", "...", ",", " ", 
     RowBox[{"|", "V", "|"}]}], "}"}], TraditionalForm]]],
 ". "
}], "Text",
 CellTags->"b:0.10b",
 CellID->721731811],

Cell[TextData[{
 "The bandwidth of a vertex ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 " is defined as "
}], "Text",
 CellTags->"b:0.10b",
 CellID->35989567],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Max", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "v"}], "}"}], "\[Element]", " ", "E"}]], " ", "|", 
    " ", 
    RowBox[{
     RowBox[{"f", "[", "p", "]"}], " ", "-", " ", 
     RowBox[{"f", "[", "v", "]"}]}], " ", "|"}], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"b:0.10b",
 CellID->339184928],

Cell[TextData[{
 "For a matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", " ", "=", " ", 
    RowBox[{"{", 
     SubscriptBox["a", "ij"], "}"}]}], TraditionalForm]]],
 ", the bandwidth is defined as"
}], "Text",
 CellTags->"b:0.10b",
 CellID->150418205],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Max", 
     SubscriptBox["a", 
      RowBox[{"ij", " ", "\[NotEqual]", " ", "0"}]]], " ", "|", 
    RowBox[{"i", "-", "j"}], "|"}], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"b:0.10b",
 CellID->57018451],

Cell[TextData[{
 "For a symmetric matrix, the ",
 StyleBox["envelope size",
  FontSlant->"Italic"],
 " is defined as "
}], "Text",
 CellTags->"b:0.10b",
 CellID->186117812],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sum]", "i"], " ", 
    RowBox[{
     SubscriptBox["Max", 
      RowBox[{
       SubscriptBox["a", "ij"], " ", "\[NotEqual]", " ", "0"}]], " ", 
     RowBox[{"(", 
      RowBox[{"i", "-", "j"}], ")"}]}]}], TraditionalForm]]],
 ", "
}], "Text",
 CellTags->"b:0.10b",
 CellID->634272936],

Cell["\<\
which is the sum of the distance from the first element in each row to the \
diagonal position. If there is neither a diagonal element in a row nor \
elements before the diagonal, the distance is assumed to be zero. \
\>", "Text",
 CellTags->"b:0.10b",
 CellID->278548319],

Cell[TextData[{
 "The ",
 StyleBox["profile",
  FontSlant->"Italic"],
 " of a matrix is simply the envelope size plus the size of the matrix."
}], "Text",
 CellTags->"b:0.10b",
 CellID->3792156],

Cell["This defines a small graph.", "MathCaption",
 CellID->1963890172],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a2", "\[Rule]", "a3"}], ",", 
     RowBox[{"a3", "\[Rule]", "a4"}], ",", 
     RowBox[{"a3", "\[Rule]", "a5"}], ",", 
     RowBox[{"a4", "\[Rule]", "a6"}], ",", 
     RowBox[{"a5", "\[Rule]", "a6"}], ",", 
     RowBox[{"a1", "\[Rule]", "a2"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[117]:=",
 CellID->4596],

Cell[TextData[{
 "This numbers the vertices using ordering from ",
 Cell[BoxData[
  ButtonBox["VertexList",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/VertexList"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1788945258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", " ", "=", " ", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"VertexList", "[", "g", "]"}], "\[Rule]", 
    RowBox[{"Range", "[", "6", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[118]:=",
 CellID->828951749],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a2", "\[Rule]", "1"}], ",", 
   RowBox[{"a3", "\[Rule]", "2"}], ",", 
   RowBox[{"a4", "\[Rule]", "3"}], ",", 
   RowBox[{"a5", "\[Rule]", "4"}], ",", 
   RowBox[{"a6", "\[Rule]", "5"}], ",", 
   RowBox[{"a1", "\[Rule]", "6"}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[118]=",
 CellID->608897324]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"g", "/.", "order"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[119]:=",
 CellID->1045789575],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWFtIlEEUHp3dLXB7soegh6QILIqkG3ajIKiIhHrzoQcti62ITCP2KYMI
K+gGUhHdiCjpgkZREdLS1YcMH3qQaM3MSk1p3XXdrd10++bMf/P33/Zfsc0W
Heaf851zvnP+mX/mTFHpPs+23aX7dmwtzVtbUVru2bG1Mm/NngoM8SzGsnIZ
Y0VTGPoJ9Ohf/CbjX3Zlb4Vo+dCvvv62ynDHYZYjGh7uOBRuPyBELw2owdiT
UKsnPlDPckTDY8HrodY9VqgPuxKJJpYjGvm8dzyhHISijDTpz39HKxuNA0pO
22jVB1rmsqXF0WSPHv31ZXGbz5dO1E7Iv7fsvLJqVe3GjYG2NvacdJeTbn9n
p1RnboGdoPFpqas7lZf3qLwcCPaUNJaJ1vH+4cNzBQVSyW2KIZsQjSdP1uTn
+6qq4tGojzSXiNYVDQTqS0qurVunOTXrc9IHDsrw/vrs2SekX0hCeIbd5suX
pR8+FPOF/GXhDq9YB16sg0/7Qx92C5GT7MDNfY8HKlBsIDuLVfsaD664bRr8
+VgsEzetlaF4H62/hMg7NHpaWgBHBjubmx+TpUUmRtMIhzeD3NwuLkaaHxFu
wQiP02nk7Y0b0ER6IXpAyPlksaOxERaExZkUCFKIdCIXz6ur0Wf3CVtANvDc
4PVeKCyEt3zVD0ZgGObvEXKewSpMsDmEgwJIYgiE7xJu7nCLCJg0HQgYYYM5
OnWEnGOyuMAwKxAkIrxDuNkjLMrsIzaEgxcMsrcIOYssAqBYXKJqAoRYEP9N
wlGMHAjggJYzWLxlpBEmMWNrCUffSh7puhLtvYM/liOaidHe+oT6gzYogRic
rFQzgtWBQWTEIVdVvDfSfVHT59Ge2lioUYgWkhwPGNLlAENFiCRP+DP6F3yU
OZVLLHPVtRv0l0V7awSqhk2IdB8P+ndJoIwUmWariSN62iKWK+BH4FJ/e4Wm
zcOfqwa+nNA5DnypwpAuB/hHoEHnGPRvh0NdDiqDsR4LjsYvtkuuV2MO19BS
MX4yfvZdjXRVy/VN/fM6KwgwpO8A9PxMZwVncKHL6TkVKweevzVvkQlbb/gO
ZZyJeP72pkSs1g1yJgQCkgTLMAvlq1pEcklBl/9tFmJ35Bb7nJnN8D03OSuu
2HOmYDd8x0zF0mnaMXkKtty056dibX0OSc6ezhQOHa96GOs4rHlB/urI0oMY
XigaO3Hc3DRDQPMJn/k4rPH//n0kO+X9C/7c9mrgJuvmc7DV2rXKztjxt2aU
Kg6Hkn2Nf5LvsYpz2fj26LjkbIf7/c/2rfG5r+sVia0TUcZ2OeOpjWunNqUC
snO+zMzZDUFEuo4JgJtQ2ilY1lp/PE27ZKxxX6T7qO4n2nPadA6+jiFjLo6a
zsFnMG6Qdx1TGEiedk//9usJuxWK/ZrHbhVlvy5Lp9qzX0ParUpH1sFT1Xlr
qnPNlfcUdZaYKuuRFT6q8+D7kkl97zZjFbXuVN55turZVOGP/m4h/XsMy3uo
JLckSe+s/ngPk+zsa41OdeYZS630bp9Gd4s2Ombp5Wx83VYO/XoW8peJqe6m
+d7/0avM9xeEEl15g8uyfgPiHsTD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{275, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[119]=",
 CellID->556991624]
}, Open  ]],

Cell["\<\
This finds the bandwidth of the graph with the above ordering.\
\>", "MathCaption",
 CellID->23199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"Subtract", "@@", "#"}], "]"}], "&"}], ",", 
    RowBox[{"g", "/.", "order"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[120]:=",
 CellID->19668],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[120]=",
 CellID->969945602]
}, Open  ]],

Cell["\<\
This finds a vertex ordering that attempts to minimize the bandwidth.\
\>", "MathCaption",
 CellID->1932703233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"neworder", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"MinimumBandwidthOrdering", "[", "g", "]"}], "\[Rule]", 
    RowBox[{"Range", "[", "6", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[121]:=",
 CellID->24021],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a1", "\[Rule]", "1"}], ",", 
   RowBox[{"a2", "\[Rule]", "2"}], ",", 
   RowBox[{"a3", "\[Rule]", "3"}], ",", 
   RowBox[{"a5", "\[Rule]", "4"}], ",", 
   RowBox[{"a4", "\[Rule]", "5"}], ",", 
   RowBox[{"a6", "\[Rule]", "6"}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[121]=",
 CellID->151017768]
}, Open  ]],

Cell["\<\
This renumbers the vertices using the minimum bandwidth ordering.\
\>", "MathCaption",
 CellID->3728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"g", "/.", "neworder"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[122]:=",
 CellID->1807493739],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWF1IXEcUHnd2TcHNk3kI9KHSEDAlpZKkxfSHCoVEQgTz5kMftLFlTQix
Rso+1UIpVqFJCxJDSGIIJZH8oKWhCSIuTWJ8iMGHPEhw1abWqlG67rruml11
+82Z++fde9dr0I1ZdJg75zvnfOfcmTtzpqyq3vfliar6mqNVBQfrqmp9NUdP
FRw4WYchnsNYTj5jrGw7Qz+FHv2L3zb8y67sfSJavrw4Ozd6Kjr2A8sTDY+O
fR999q0Q9RpQS4meyLAvOd/J8kTDE+GrkeGTVqiR46lUP8sTjXz+ejOh3ISi
jPTrzxuj5ULjhpLHMVr1gZblOtLiaFwvj/63t2I0EFhL1B7I/xs8drmkpL28
PDQ6yu6T7sekOzcxIdWZV2C3aHwGOzp+Lii4W1sLBPuTND4SrXvozp1zRUVS
yWuKwUWIvjNnWgoLAw0NyXg8QJr7RZsbD4U6Kyt/LS3VnJr1OekDB2V4f9Ta
2kP6xSSEZ9gdaGuTfvhyIhAJVkfH/GId+LEO/v4mMnJCiDxkB25u+3xQgWI3
2flAta/x4Irb/qUXXWKZeGmtLCdnaf2lRN6hMT04CDgyODEw0EWW3jcxeotw
eDPIzc2KCqT5LuH2pnl8m0aeXLsGTaQXoj8IuYcsjvX1wYKwuJMCQQqRTuTi
fmMj+uw2YYvIBp67/f4LxcXwVqj6wQgMw/zvhHzPYBUm2G7CQQEkMQTCvxHu
3ZUWETBpuhEwwgZzdDoIudtkca9hViBIRHiLcO+kWZTZR2wIBy8YZG8QchdZ
BECxuF/VBAixIP7rhKMYORDAAS1nsHjLSCNMYsa2E46+lTw2eTk+cwt/LE80
b8RnOlPqD9qgBGJw8qmaEawODCIjbrmqkjOxqYuaPo9PtycifUK0j+R4wJAu
BxgqQiR5wp/Rv+CjzKl8Ypmvrt1wsDo+0yJQLWxLbOqncPC4BMpIkWn2GXFE
T1vEcgUshC7NPavTtHn0n4b58dM6x/nxBgzpcoAXQt06x3DwKzjU5aCylJi2
4Gj8YufK9WrM4QFaKsZPxovZK7HJRrm+qX9eZwUBhvQdgJ7v6azgDC50OT2v
xsqN5+cDX8iEHTJ8h7LORDw/f1wpVuthORNCIUmCZZmF8lUtI7mkoMs3moXd
PmdmI3ZRruHsWa3cm+3ZccWexxFL2sPd+o6Zvveb+XpMeyxfhTc3nRJW4299
csliHA9//PA7DO8TjSEOa16QXz+yQ0ALCZ/9OFbOM/v3YB3vRrwH7mDWW1t/
1ey5SWu914Ld213vONzKnND423yP1W/FanNn5RzL/O3Rca/ZvrU593W9InF0
IsraLmc8tXHt1KZUQE7Ol9k5uyGI2GSzAHgJpZ2CZa2V8TSdK2NNBmJTTbqf
+PQvpnPwVQwZc9FkOgefxbhBPtmsMJA8nZ7+ndcTTisU5zWP0yrKeV22lmrP
eQ3ptCpNr4PfVOetqc41V97b1VliqqzTK3xU5+Ghyq2zTz/HKho+prxzl+rZ
VOG//N3C2u8xLO+hbG5JbO+sMt7D2J0CrNHWu+hm0lr7nVWmU4T93ZXL4ry3
We4hM6GWF+9FgtViqntpvs/95Vfm+wNCia68wWU5/wMZf8TD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{275, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[122]=",
 CellID->552632471]
}, Open  ]],

Cell[TextData[{
 "This finds the bandwidth using the vertex ordering given by ",
 Cell[BoxData[
  ButtonBox["MinimumBandwidthOrdering",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MinimumBandwidthOrdering"]], 
  "InlineFormula"],
 "."
}], "MathCaption",
 CellID->27938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"Subtract", "@@", "#"}], "]"}], "&"}], ",", 
    RowBox[{"g", "/.", "neworder"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[123]:=",
 CellID->1064753963],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[123]=",
 CellID->1665006857]
}, Open  ]],

Cell["This defines a rectangular matrix.", "MathCaption",
 CellID->24221],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"(", GridBox[{
      {"0", "0", "0", "0", "0", "1", "2"},
      {"0", "2", "1", "0", "0", "3", "2"},
      {"2", "1", "2", "0", "0", "0", "3"},
      {"1", "2", "3", "0", "2", "0", "0"},
      {"0", "0", "2", "0", "0", "2", "1"},
      {"2", "3", "0", "2", "1", "0", "0"}
     }], ")"}]}], ";"}]], "Input",
 CellLabel->"In[127]:=",
 CellID->10383],

Cell["\<\
This finds the row and column ordering that attempt to minimize the bandwidth \
of the matrix.\
\>", "MathCaption",
 CellID->1828500338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"r", ",", "c"}], "}"}], "=", 
  RowBox[{"MinimumBandwidthOrdering", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[128]:=",
 CellID->18588],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "3", ",", "2", ",", "5", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3", ",", "7", ",", "6"}],
     "}"}]}], "}"}]], "Output",
 ImageSize->{272, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[128]=",
 CellID->1554303890]
}, Open  ]],

Cell["\<\
Plots of the matrix before and after the ordering show a decrease in \
bandwidth.\
\>", "MathCaption",
 CellID->13030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"MatrixPlot", "[", 
     RowBox[{"m", ",", 
      RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}], ",", 
    RowBox[{"MatrixPlot", "[", 
     RowBox[{
      RowBox[{"m", "\[LeftDoubleBracket]", 
       RowBox[{"r", ",", "c"}], "\[RightDoubleBracket]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[133]:=",
 CellID->8909],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnF1u1DAQx72bFPoCQqLbbSMeeoKCtOIK8ALcYVWBWiQEKn0vR4C7IMQb
bz1AD8E1gmdjb5zx2B637DZJZ9XGceKZ3z+Tjx072bxdXpy+/7S8ODtZHr0+
X345PTv5evTq87leVEyUmnxXSv05UHq+1nOrf/j80P/NLGduX08LbTrTZWlK
qB/C2sL6rNWeWT7X5dSU7vrj/+TnYKUKL505dT1tWjnr91Ed2z+FSdnWlWfx
fOtEektTfvdMfLEen0ftoe2Q5uSWUf7xEaCIIyZ/yzZH4m3ZDNX3Hf5Utecc
jmxqO27ql1a9520ttpsRcbNcT1fHEz6bNslqzqNQLPA+DrU7vqV9owKacK66
u3r6W1s9MeXueqnLepSIRaqeiiWuY97jnul5IFHaWpRe3HFUbst3otBeLfTn
8Orb5PDvyeq8rmD++tfHlwntl9ZOty2EIxzhDJSjiqaAzw6f2WkF3/qlKXdS
CjxLI6CTwZQ3UaJnpvQSRw+uR/QZa92xVBMoAzrB2WojtBf9p+aE0oVpF9BH
+nSVNQGxn4CXwcSwyDvWHFJhQr32wDzWrV1bwDRDw47bShH0MqXG89DsUojO
NG9voT3hnn1JFYRtc+yM7bomHOGMluMsXRiLRcQSUz44baEUkpCEtGkSlbNw
aLGcJ0Vu8x7q2z9bSaKOfSbV1V5mOFiVUKXUdTN3vP9CnrAm3wvqleBeHCdm
7D4cGaFQPw7n1xwl2dk1qYiTYWceS6n8OnXsEDn2yK5qQhLSPSF1s3vTHjL8
yvhIZfdv6rYnYG2FJzzh9Y2Hc0Q/4+HwSS+ROkcf9jkZpN5SkSOeDI2lyabW
HjL1WHul7FKbb0J11VxbQ+I+J9R0xvEd+wLVrT9KETGWjz2l7sqE4sTO6IOR
SmT1fdEztON97NdL4QlPeFGeYwd+KFvMs/2YyuE9E57whNczXkHnRQxmocKj
+xy+tQ+MnefrSdRDI/JRjTVrnL+nWnHuu+4nXDnP+yCl3RwfGuPsF7xQeiqz
ztqw811GvHLzXU686Hx3SPu3D+fu2K+PwhOe8BDPWVo5xIWhQT1FdO0qQ8S9
GCEKUYh9I1Lj11xqbAyco8AZAzd5qlPh6nnoXi3XLryRcLa+gL9GZypz5UYu
NwPmRJOfAUM1pPRmzwlR+uw9Cv8poVQ0uFHMzcs5UST6Xf6vGbhab/l7hqDe
1G9D8F2SfL11/D4JQ1nt9hvvw5VUiEIUIpd4CZbX9LNOK0qwF1RpxjthCEMY
mYxubkf+Rs8ldgiFascYA78RxHzPnpdDx7aclTdnRSbjOaYBaISqqy2+xyll
UA3dVQBtb2rnGBhN3PqmMZbBe/riWXvmeRrO2WNx6fNVTxjCGAvjJ+U3sp72
ctfvQcKq71qPRCkvSv770aCBvN1S3m5ZB/bQdkjydks/0vJ2y02xhvh2SzX5
Bw81mic=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{400, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[133]=",
 CellID->379044218]
}, Open  ]],

Cell["\<\
This defines a sparse matrix, and finds the minimal bandwidth ordering.\
\>", "MathCaption",
 CellTags->"b:0.10b",
 CellID->53025991],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{
   "Import", "[", "\"\<LinearAlgebraExamples/Data/dwt_1005.psa\>\"", "]"}]}], 
  ";"}]], "Input",
 CellTags->"b:0.10b",
 CellLabel->"In[1]:=",
 CellID->807438655],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r", ",", "c"}], "}"}], " ", "=", " ", 
   RowBox[{"MinimumBandwidthOrdering", "[", "m", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"order", " ", "=", " ", 
   RowBox[{"Ordering", "[", "r", "]"}]}], ";"}]}], "Input",
 CellTags->"b:0.10b",
 CellLabel->"In[3]:=",
 CellID->353820708],

Cell[TextData[{
 "This plot the matrix as a graph, coloring the vertices so that those that \
are among the first ordered are blue and those ordered last are red. For a \
symmetric matrix the row and column orderings are the same (",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", " ", "\[Equal]", " ", "c"}], TraditionalForm]]],
 ")."
}], "MathCaption",
 CellID->1370128377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"m", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"0.75", "*", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"order", "[", 
              RowBox[{"[", "#3", "]"}], "]"}], "/", "1005"}]}], ")"}]}], 
         "]"}], ",", 
        RowBox[{"Point", "[", "#1", "]"}]}], "}"}], "&"}], ")"}]}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.9", "]"}], ",", 
        RowBox[{"Line", "[", "#1", "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellTags->"b:0.10b",
 CellLabel->"In[5]:=",
 CellID->2053512829],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.10b",
 CellLabel->"Out[5]=",
 CellID->724713976]
}, Open  ]],

Cell["This shows the matrix before and after the ordering.", "MathCaption",
 CellTags->"b:0.10b",
 CellID->547164372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"MatrixPlot", "[", 
     RowBox[{"m", ",", 
      RowBox[{"ImageSize", "\[Rule]", "200"}], ",", 
      RowBox[{"MaxPlotPoints", "\[Rule]", "200"}]}], "]"}], ",", " ", 
    RowBox[{"MatrixPlot", "[", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"[", 
        RowBox[{"r", ",", "c"}], "]"}], "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "200"}], ",", 
      RowBox[{"MaxPlotPoints", "\[Rule]", "200"}]}], "\[IndentingNewLine]", 
     "]"}]}], "}"}], "]"}]], "Input",
 CellTags->"b:0.10b",
 CellLabel->"In[9]:=",
 CellID->597563837],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJzt3dGJ5EYQBuAFR+JInINDMPjZaTksh+AQjJl7ELes0E53dVVXfwfmO8xy
SC2pqv6RRvvrH3/9/ucvHx8ff//47/+/v/78+xtJkiR38p8f/vznu/8/ez/I
O53PZzrruO9+/uyynSRJsp/y5lytJ8lZRtcTdel+f09bB5LsqjrPTjqf52rd
SM4yuj5n1atqdVIfJEkyTn12ru4Xk+RL97t7aJ1Jklf1hTXKlWu0biT5suv9
7mpGr4M5gSQ5oj7ynvI7SfbW/W4+0XEkSY4oV67RepJkb93vPlOfw5AkKyjX
kyRPUL87U89F7LWdJOurn67ReuZqnedqPedqPXmCzvMzjc7p0Z8PZP08SX6l
ekKSPfR5LMldVK9IkiTZSfMtO+m87WHW/fRZ27PLupHsp7mOJHuY9f1QfYEr
db711u8FeG/7s7eLJEmSscrpJGfVjVn/jvpz5v6ST1QfSJKdzHpfE8l+RteT
0557n7XO2dtLrtB1QZI9lENJsqbqM0mS5JmaA0mypp7zWaP1IUmS1TTvkeQa
q73HUp2/39/T1oF76Xon464XsrJZ70HK3u/q60nyHLM+R1WvXupfJEmyq+7X
kzxN73vvofXsreuIJHmC5kmSfOl97z3Uv3rr+JJkb+VTkmSE+gtJkuR7mqNI
khF633sPrT9JknGai0iSI3rf+5la51x9T4RkNdWTNUavs/5+5v6SpPe991Z/
J0myvu7Xk2QPve+dT9zleDnfSJIn6PuGJNlb73vnE3fp77tsJ0lyrvIpSZKf
1R9JkmS05g2SJJ/r+Ss+0fElSY5oriBJnqz3vTNCx5Ekz7Ta9+mitzN7vaOO
V/Z2kSS/Z7V+mr0e/J6nzT8kyZrK6STJHa32uTd76HwgSVbQPEOS7KT3vfPq
ac9L7LKdJPdVTpyrPE7yu/Uhe7tW7+9p67C7u3y/jLl6L8Fe20myn36PKkmy
k/rLe8rjJEmOKxeTJCsr99XU/XSSJD+rP5IkySzNGyTJleojJMmV6jtrtM5z
db+AJFnZan1KvyNJklnK6STJEfUFkuSO6l+sYLX7FCTJXPUFkiQ/q69xpeYu
kpyr93uTJCur76zROnNE901IsqZZ9dnnDCR5puo5WV85nSRrqq6SJFdqzifr
K6eT3N3o93urkyTJE9S/yPXXl3mSJNeorpIkOylHkK47kvXN+r3V7neTJJ+o
/pPcRe8XIpmlOkOSrKy+QzJL95tIkiTnusvzP+a9e83JJLNUf9Zo3UiSZLSe
k8zVupGcpZxOkiRJxmmuJjmrPqgnJEmyq+YckmQF5XSSJMl7zT8kyZXu8j6T
0/R9MZIkSZI8Uzl9L6Pzu+NFkuRzzUUkyQjl9DOV30mSjNO8RJIcUU4nSZJc
ozmKJPlEOZ0kSZIkyTrK6SRJkjU1X5Ekr8rpJEmSNTV3keSZyukks/SeQ5Ik
SfKz8jjJLGfVGXWJJEmSnZTTSWbpvRkkSZLkZ829JKvpPvt7+9V1f0mSJE9T
Tie5i7Nyetc6dtr+kmRX1XPyHD1HSj6/LrK3q5vR65x1n73a+aOek+PXRfb2
kiTPUk4nSZIkSbKO3tdEkiR5rzmHJLlSOZ2VjT7fnJ8kySeaf0iSK5XT2Un5
nSS5UvMPSTJCOZ0kSZIkyTrK6SRJkms0L5EknyinkyRJ5mqOIkk+UU4nSZLM
1XxFkrwqp5MkSdbU3EWSZyqPk+R7RtdJ9ZYkSfJM5XSSnGv07w1Uh0mSJHsr
p5PkXLNyuvr8ctY6Z+8HSZI8V3MgSa4x+nl49fle/Y4kz1SdZyedzyT5Mrru
eR5+zfZ7bypJkqymOYQkSXbVnEOS3FH3EUiS5Gmac0iSlY3O6foaOX49zvp5
kuS95hySZAXldLK+rlOSJEnyHM3/JEmS72n+IUlGKKeTJEnO1VxEkhxRTidJ
klyjeYkkOaKcTpIkuUZzFEnyiXI6SZJkruYrkuRVeZwkeXVWndcvSJIk31NO
J0lenVX/9RGSJMn3lNNJklej67/+QpIkea+cTpJ8ovvsvTUPkCSfqC+sUV8m
SY7o++w1jf78xJxAkryqL7yn/kuSvBpdz91n7+Euc0K17SFJvlSH75XTSZLk
aZpnSLKm6vDL6JxunUnOun+avR8kSZLkCuV0klmqPyR3UT0hyZp2rc/mZJK7
6349ySzVE5LMtWsOldNJkiTnav4hyVx3z6dyOkmSJEmSdZTTSZIkczUvkWSu
u9RhOZ0kSTJXcxRJ5lqtDsvpJMlOzupH+hpJksxSHidJdjK6f+mDJEkyWjmd
JNnJ6L6mP5IkyWjldJLkCcrpHHHWeZK9HyTJPZTTSZInmPU8vL7ZW3MUSTJC
/WWN1nON1nOu1pMnKKdzxKzvWUSfzyTJNXqv+3v7Ff08ZNd1rqb1nKv1zNX6
r7Hre+dsT839qvbzJMk1ds2Pvm9I8jTVqx46XiRJMjqnmzdIkhxXPyVJ8hzl
dJI8U/W5h44jSZL9lNNJklfVc5IkyVzldJLkiOo8SZLkXOV0kmSE6j9JkuR7
yukkyZXqCyRJkvfK6STJCuoXc7WeJEnuq5xOkiRJkmQd5XSSJKlfkyRZRzmd
JEl+pT5OkuR65XSSJPld9XeSJOOU00mS5CzNA4zQ+UOSL+V0kuSI0f1C3+mh
48URnT8ku+p+OknyiVn5Wn7vofVnhK53kl2Vx0mSI+6S30nuq+ud5Gm6n06S
JLM0P3BE5wnJrsrpJEmymuYHjuj8Ibm7cjpJktxFcwVJ8gTldJIkubvmDZJk
J+V0kiS5i7PeT5i9HyRJ3imnkyTJ3TVvkCQ7KaeTJEmSJFlHOZ0kSZ6m+YQk
WVk5nSRJ8qW5hSRZQTmdJEnyXvMMSXKlcjpJkuR7mnNIkhHK6SRJknM1F3FE
5wnJr5TTSZIVnNVf9CNW1vnJq+Zqku6nkySfmNUXsv797PUmyZ9Vr8hzlMdJ
kiPukt+z14m803l7po47ya90P50kSTJXcxSvOu4k5XSSJMmamqNI8kzldJIk
yb00X/Gq84Hsp5xOkiTZQ3MXSfZQTidJktxLv9eAJHsrp5MkSZIkWUc5nSRJ
srfmMZLcSzmdJEnyTM1pJFlTOZ0kSZJXzW8kmaucTpIkySea60hyjXI6SZIk
RzTvkeRc5XSSJEmOaD7kEx13Mu46UodJkhXUj0hyL9VnMu56MReRJK9W6yP6
FNlP12lvHV/y+XVhziFJjii/k/zu9Zi9XZyj40vGXUfyO0mSJCM0N5LkvXI6
SZIkK2ue7K3jSz6/LuR0kiRJVtac2VvHlycrp5MkSbKT5k+SuyunkyRJkiRZ
RzmdJEmSnZz1+yCy94PkucrpJEmSPEFzKcldlNNJkiR5suZVktWU00mSJMnP
mmNJZimnkyRJks8135KMVk4nSZIkn2vuJRmtnE6SJEmS7ynvcKVyOkmyk/oU
ySzVn946vqygnE6SfOKsvhDdd/QvktVUf3roODLX/wBrkLIj
     "], {{0, 0}, {168, 168}}, {0, 1}],
    Frame->True,
    FrameLabel->{None, None},
    FrameTicks->{{{{167.91641791044776`, 
         FormBox["1", TraditionalForm]}, {84.50149253731344, 
         FormBox["500", TraditionalForm]}, {0.08358208955223881, 
         FormBox["1005", TraditionalForm]}}, {{167.91641791044776`, 
         FormBox["1", TraditionalForm]}, {84.50149253731344, 
         FormBox["500", TraditionalForm]}, {0.08358208955223881, 
         FormBox["1005", TraditionalForm]}}}, {{{0.08358208955223881, 
         FormBox["1", TraditionalForm]}, {83.49850746268658, 
         FormBox["500", TraditionalForm]}, {167.91641791044776`, 
         FormBox["1005", TraditionalForm]}}, {{0.08358208955223881, 
         FormBox["1", TraditionalForm]}, {83.49850746268658, 
         FormBox["500", TraditionalForm]}, {167.91641791044776`, 
         FormBox["1005", TraditionalForm]}}}},
    ImageSize->200,
    PlotRangeClipping->True], "\[InvisibleSpace]", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzt3dGJLEUYhuEDRmIk5mAIgtemZViGYAiyrBfiQrPb2zX/91U9C/LIQc5U
/T1evFPdsz//9sevv//048ePP//95+3f33/+/oUkSZIkSa7yr3/9/89X/3x6
HyRJkiRJ7uBTna7fSZIkSZL8vqs7Xb+TJEmSJPl5dTpJkiRJkq93qsd1OkmS
JEmSH9XpJEmSJEnmqNNJkiRJkswxrdP1O0mSJEnyZNN6XKeTJEmSJE82rcd1
OkmSJEnyBNO6W6eTJEmSJE8wra91OkmSJEmSH03rbp1OkiRJkjzBtL7W6SRJ
kiTJk03ra/1OkiRJkjzZpzo3rcd1OkmSJEmy0bSO1u8kSZIkyZNd3bl6nCRJ
kiTJz5vW0VOfD0xfB5IkSZIk335azs1Xv+70dSBJkiRJ8u0n7Xw87VyeJEmS
JMlXmtbLOp0kSZIkeYJpnZt2P/z09SFJkiRJnuVp3a3TSZIkSZLJtnS675Ej
SZIkSZ5g2vPgaX8+fX1IkiRJkmfZ/hy659NJkiRJkjt5Wqd/dT3T14ckSZIk
eZZT58tT5+ZpcyBJkiRJ8jOedm6u00mSJEmSyaZ977pOJ0mSJEmeYNr3q6d9
j5xOJ0mSJEm+0vZenjpnn75uJEmSJMk9bfneNp1OkiRJkjzZtOfB2z8HIEmS
JEnyO7b3sh4nSZIkSTaa9v1vaX8+fX1IkiRJkmfZ8jx42nqmrxtJkiRJ8izT
7j/X6SRJkiTJk23p9LTXJUmSJElyhbt2tB4nSZIkSa4w7fvWdDpJkiRJkh9N
6/HV62x5XZIkSZLkmab1Zsu5edrcSJIkSZJ7mNah7Z0+fT1JkiRJkt229GlL
v09fT5IkSZJkty3Pd+t0kiRJkuQJtn8/W8v9+dPXmSRJkiTZYVoX63eSJEmS
5Mnu2r/t659+X5AkSZIkZ5x6vnv1f9/yPLt+J0mSJEn+17RObO/Z9vWTJEmS
JGdt6cr2c+q09ZAkSZIkM03r37T72FvmRpIkSZLcw7R+TOvfls8NSJIkSZJ7
mNaV7V2cth6SJEmSZKYtndu+/rT1kCRJkiQzbT+nXr2vtHVOv19IkiRJkmtt
6cRduztt/SRJkiTJWdv7sWX9LeskSZIkSc76VCemdWVLF6ethyRJkiT5rLve
d239s+snSZIkSd6zvdPbv9euZZ0kSZIkydfY3rm77ittPSRJkiTJ19jSrfab
uR6SJEmS5D1Xd2hLP7afs7fPnyRJkiT5ru9pf/bP2/c1/X4kSZIkydPVcdf7
bZ9P+/pJkiRJst2p89b27tv1nLplnSRJkiTZ4tT92091XEsP7vo5hk4nSZIk
yWdt6fE0T5tb+/pJkiRJst3TOrRlbtP7W7Xf6X2QJEmSZKv6/d462+fjupMk
SZJkl2nfL3daz+663+n3NUmSJEm2mtZf7evZtVtP2y9JkiRJTjl1Pp52ntu+
/qn3Q9r6SZIkSbLFXbuyZW7T+3j1fKbXRZIkSZKttv9+8Pbz9JbrvvrvIUmS
JMld3bUr2+c5vY+U+UyvlyRJkiRfbUunt/dd2jxb5jC9XpIkSZJc5WmdmPZ7
4nz//OzrkiRJkmSaab2Wtt/T5py2zrT5kCRJkuRq07ps9b7S5pb2++NWz7Nl
PiRJkiQ5pd65t1+9eW+d5kaSJEmS1+qga9s7NO3++Za5kSRJkmSaOuja9g7V
7/fWQ5IkSZJppvVgS2el9WbL5wBpcyNJkiTJNFt6Z9fz4pb1r35fpb3fSJIk
STJN55v39qVz91g/SZIkSaY5dT/29L5XzSdtDmmv2/5+IEmSJMmnbHmeenpO
KXNr13xIkiRJ8p666Xq/evOe5kOSJEmS1+rNe5rbs5obSZIkSV6rQ691zv4a
zY0kSZLkabZ0Zft60rrSOkmSJEky0/bebJnPaXObmv/0ekmSJEnyu+rNe5rb
azRnkiRJkqfpvPie5jareZIkSZLcVV15va/Tenz1vsyZJEmSJO95Wgfpx2un
9nvanEmSJEnyq6b1UdrrpnVlWrf6PIQkSZIkn7Wlm6b6t6U32+cz/f8BSZIk
Saa4+jnl6f2tmsNp81n9/iFJkiRJvquzrvdrPteaD0mSJEm+xl37y/3b9zQ3
kiRJkpz1tM7Sm/c0H5IkSZJ8jZ7Xvl5n2u8vO20+JEmSJHmau3aWrnxWcyNJ
kiTJ17hrz3rO+p7mRpIkSZKzntZfOvSe5kOSJEmSs7b011PPy+vQa82HJEmS
JGdt7zI9fm9f5kaSJEmSmZ7WX6ft96k5mBtJkiRJzjr1e9nSfg/aVJ9O/f26
myRJkiQzbe8458LX+zptDiRJkiTZbkvfuX/73r52nQNJkiRJ7mp7x+nT633t
ul+SJEmSPM2p59a/+vdPnS+331cw/f4iSZIkSX7Nlu47rVtP2y9JkiRJ8t2W
Htz1ee1d90WSJEmSvGd7D7avc9frQpIkSZK8Z0v3tazTfkmSJEmSK0zrwfbz
Zfe3kyRJkiRXmNaJaT27+v726etPkiRJksxyqit37dld90WSJEmSfI0tnZ52
nt6yfpIkSZLkHrZ0cdp69DhJkiRJcoWrO7S9c9vXT5IkSZLscvU5cvs5dcs6
SZIkSZJ7mHae3vK8vE4nSZIkSa5Qp7/mdUmSJEmS/Izt9707HydJkiRJ7mRL
R6/e1/R1IEmSJEny7WfX+891OkmSJEmy0fZedn87SZIkSXIn2ztap5MkSZIk
d3LXjtbpJEmSJMlG03pZp5MkSZIkTzatl3U6SZIkSfJk2+9793w6SZIkSXIn
/V62e38/SZIkSZIr3LWXdTpJkiRJMtmW58Td906SJEmSPMG0bk37fGD6+pAk
SZIkz/K0+891OkmSJEky2V3ve3/qdaevD0mSJEnyLFt6WaeTJEmSJE+wpZen
7oefvj4kSZIkSb796PTXvC5JkiRJkp9x105P+3yAJEmSJMnv2N7LOp0kSZIk
uZNPda5OJ0mSJEny+z7VszqdJEmSJMnvm3ae3vL5AEmSJEmSK2zpZT1OkiRJ
kjzBtI7W4yRJkiTJk23pa51OkiRJkjzZtPvSdTpJkiRJ8gTTztPd906SJEmS
PNm035s2tU6SJEmSJBNM62jn6SRJkiRJfjTtfnU9TpIkSZI82ZZO1+8kSZIk
yRNMu49dp5MkSZIk+XnTun56HiRJkiRJvkK/f40kSZIkyXx9jxxJkiRJkvk6
NydJkiRJMtl/AF2uofQ=
     "], {{0, 0}, {168, 168}}, {0, 1}],
    Frame->True,
    FrameLabel->{None, None},
    FrameTicks->{{{{167.91641791044776`, 
         FormBox["1", TraditionalForm]}, {84.50149253731344, 
         FormBox["500", TraditionalForm]}, {0.08358208955223881, 
         FormBox["1005", TraditionalForm]}}, {{167.91641791044776`, 
         FormBox["1", TraditionalForm]}, {84.50149253731344, 
         FormBox["500", TraditionalForm]}, {0.08358208955223881, 
         FormBox["1005", TraditionalForm]}}}, {{{0.08358208955223881, 
         FormBox["1", TraditionalForm]}, {83.49850746268658, 
         FormBox["500", TraditionalForm]}, {167.91641791044776`, 
         FormBox["1005", TraditionalForm]}}, {{0.08358208955223881, 
         FormBox["1", TraditionalForm]}, {83.49850746268658, 
         FormBox["500", TraditionalForm]}, {167.91641791044776`, 
         FormBox["1005", TraditionalForm]}}}},
    ImageSize->200,
    PlotRangeClipping->True]}],
  Row[{
    Graphics[
     Raster[CompressedData["
1:eJzt3dGJ5EYQBuAFR+JInINDMPjZaTksh+AQjJl7ELes0E53dVVXfwfmO8xy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      "], {{0, 0}, {168, 168}}, {0, 1}], Frame -> True, 
     FrameLabel -> {None, None}, 
     FrameTicks -> {{{{167.91641791044776`, 1}, {84.50149253731344, 500}, {
         0.08358208955223881, 1005}}, {{167.91641791044776`, 1}, {
         84.50149253731344, 500}, {0.08358208955223881, 1005}}}, {{{
         0.08358208955223881, 1}, {83.49850746268658, 500}, {
         167.91641791044776`, 1005}}, {{0.08358208955223881, 1}, {
         83.49850746268658, 500}, {167.91641791044776`, 1005}}}}, ImageSize -> 
     200, PlotRangeClipping -> True], 
    Graphics[
     Raster[CompressedData["
1:eJzt3dGJLEUYhuEDRmIk5mAIgtemZViGYAiyrBfiQrPb2zX/91U9C/LIQc5U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      "], {{0, 0}, {168, 168}}, {0, 1}], Frame -> True, 
     FrameLabel -> {None, None}, 
     FrameTicks -> {{{{167.91641791044776`, 1}, {84.50149253731344, 500}, {
         0.08358208955223881, 1005}}, {{167.91641791044776`, 1}, {
         84.50149253731344, 500}, {0.08358208955223881, 1005}}}, {{{
         0.08358208955223881, 1}, {83.49850746268658, 500}, {
         167.91641791044776`, 1005}}, {{0.08358208955223881, 1}, {
         83.49850746268658, 500}, {167.91641791044776`, 1005}}}}, ImageSize -> 
     200, PlotRangeClipping -> True]}]]], "Output",
 ImageSize->{404, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.10b",
 CellLabel->"Out[9]=",
 CellID->1730983815]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithms for minimizing bandwidth/envelope size", "Subsubsection",
 CellTags->"b:0.10b",
 CellID->267857294],

Cell["\<\
The problem of finding the minimum bandwidth ordering of a graph has been \
proven to be NP-complete; hence, practical algorithms are all heuristics \
aimed at finding approximate optimal orderings.\
\>", "Text",
 CellTags->"b:0.10b",
 CellID->85334619],

Cell[CellGroupData[{

Cell["Basic algorithms", "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->253464642],

Cell[TextData[{
 "For a connected undirected graphs, the reverse Cuthill and McKee (RCM) \
algorithm [8] starts by finding a pseudo-diameter of the graph. Then from one \
end",
 " ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 " of the diameter, vertices are ordered and form a number of level sets, \
where vertices within the same level set have the same distance to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "."}], TraditionalForm]]],
 " Within the same level set, priority is given to vertices that are \
connected to the lowest-ordered vertex possible. Once all vertices are \
ordered, their order is reversed. While reversing the order has little effect \
on the bandwidth, it was found [13] that reversing the order often reduces \
the fill-in when the ordering is used for the factorization of sparse \
matrices. In our implementation we also provide a variant algorithm, RCMD, \
which breaks the tie between vertices that are connected to the same \
lowest-ordered vertex by ordering vertices with the lowest degree first."
}], "Text",
 CellTags->"b:0.10b",
 CellID->418352738],

Cell[TextData[{
 "The result from RCM or RCMD can be further refined and improved. The node \
centroid and hill climbing algorithms in [9, 12] are two possible procedures. \
In the hill climbing algorithm, critical vertices (those that have a \
bandwidth equal to the bandwidth of the graph) are identified and attempts \
are made at swapping the order of a critical vertex with non-critical \
vertices. This continues until neither the number of critical vertices nor \
the bandwidth can be reduced. In the node centroid algorithm, near-critical \
vertices (those with a bandwidth close to the bandwidth of the graph) are \
identified and their new orders are calculated as the average of their order \
and their neighbors's order. The vertices are then sorted and reordered. The \
node centroid algorithm is always followed by the hill climbing algorithm. \
The hill climbing refinement, or the combined node centroid and hill climbing \
algorithms, can be chosen using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RefinementMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/RefinementMethod"], "->", 
   "\"\<HillClimbing\>\""}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RefinementMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/RefinementMethod"], "->", 
   "\"\<NodeCentroidHillClimbing\>\""}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.10b",
 CellID->170510271],

Cell[TextData[{
 "The node centroid and hill climbing procedures can also be combined with a \
multilevel procedure. Here, a sequence of smaller and smaller graphs are \
generated from the original graph. An initial ordering is found for the \
smallest graph using RCM or RCMD. Orderings of the coarser graphs are then \
interpolated into finer graphs, and refined using the node centroid and hill \
climbing procedures. The multilevel method can be chosen with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RecursionMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/RecursionMethod"], "->", 
   RowBox[{"\"\<Multilevel\>\"", "."}]}]], "InlineFormula"]
}], "Text",
 CellTags->"b:0.10b",
 CellID->219256637],

Cell[TextData[{
 "The Sloan algorithm [10, 11] aims to minimize the envelope size of an \
ordering of an undirected graph. It works by first finding the graph's \
pseudo-diameter, formed by the pair ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", "u"}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 ". Vertices fall into four mutually exclusive classes: ordered (those that \
are already ordered), active (those that are connected to one more or more \
active vertices), preactive (those that are connected to one or more active \
vertices, but not to ordered vertices) and inactive (neither ordered, active, \
nor preactive). Starting from ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]]],
 ", vertices are prioritized. The priority of a vertex ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["w", "1"]}], " ", 
     RowBox[{"incr", "[", "i", "]"}]}], " ", "+", " ", 
    RowBox[{
     SubscriptBox["w", "2"], " ", 
     RowBox[{"dist", "[", 
      RowBox[{"i", ",", " ", "v"}], "]"}]}]}], TraditionalForm]]],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"incr", "[", "i", "]"}], TraditionalForm]]],
 " is the number of preactive and inactive vertices that will become active \
if ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 " is ordered next, plus 1 if ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 " is currently preactive, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"dist", "[", 
    RowBox[{"i", ",", " ", "v"}], "]"}], TraditionalForm]]],
 " is the distance between ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["w", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["w", "2"], TraditionalForm]]],
 " are two positive weights. The algorithm works by selecting among active \
and preactive vertices a vertex that has the highest priority. Once a vertex \
is selected, the priority of the remaining active and inactive vertices are \
updated. For efficiency in deciding the vertex of the highest priority \
(without using a sort), a binary heap data structure is used. The Sloan \
algorithm tends to give an ordering that has a small envelope size, at the \
expense of a larger bandwidth as compared with the RCM algorithm and \
variants."
}], "Text",
 CellTags->"b:0.10b",
 CellID->905493635]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithms for unsymmetric matrices", "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->210490374],

Cell[TextData[{
 "For a graph ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  ButtonBox["MinimumBandwidthOrdering",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MinimumBandwidthOrdering"]], 
  "InlineFormula"],
 " attempts to find the vertex ordering ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]]],
 " that minimizes the bandwidth of the underlying undirected graph of ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]]],
 ". However, for an ",
 "unsymmetric",
 " matrix ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 " of dimension ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", " ", "\[Times]", " ", "n"}], TraditionalForm]]],
 ", following [12], ",
 Cell[BoxData[
  ButtonBox["MinimumBandwidthOrdering",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MinimumBandwidthOrdering"]], 
  "InlineFormula"],
 " works with the symmetric matrix "
}], "Text",
 CellTags->"b:0.10b",
 CellID->38775144],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"b", " ", "=", " ", 
    RowBox[{"(", GridBox[{
       {"0", "a"},
       {
        SuperscriptBox["a", "T"], "0"}
      }], ")"}]}], TraditionalForm]]],
 ","
}], "Text",
 CellTags->"b:0.10b",
 CellID->415664190],

Cell[TextData[{
 "which represents the bipartite graph of the rows and columns of ",
 StyleBox["a",
  FontSlant->"Italic"],
 ". An ordering for ",
 StyleBox["b", "TI"],
 " is first computed. This is then converted to an ordering of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 ". Specifically, suppose the ordering ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["r", "1"], ",", " ", 
      SubscriptBox["r", "2"], ",", " ", "...", ",", " ", 
      SubscriptBox["r", 
       RowBox[{"m", "+", "n"}]]}], "}"}]}], TraditionalForm]]],
 " minimizes the bandwidth of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", 
    StyleBox["[", "MR"], 
    RowBox[{
     StyleBox["[", "MR"], 
     RowBox[{"p", 
      StyleBox[",", "MR"], "p"}], 
     StyleBox["]", "MR"]}], 
    StyleBox["]", "MR"]}], TraditionalForm]]],
 ". Then the row ordering of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 " is given by the elements of ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 " that are less than or equal to ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]]],
 " and the column ordering is given by those that is greater than ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]]],
 ", minus ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]]],
 ". That is, "
}], "Text",
 CellTags->"b:0.10b",
 CellID->470991382],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", ",", "c"}], "}"}], "=", " ", 
    RowBox[{"{", 
     RowBox[{Cell[BoxData[
       RowBox[{
        ButtonBox["Select",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Select"], "[", 
        RowBox[{"p", ",", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "\[LessEqual]", " ", "m"}], "&"}], ")"}]}], "]"}]], 
       "InlineFormula"], ",", 
      RowBox[{Cell[BoxData[
        RowBox[{
         ButtonBox["Select",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Select"], "[", 
         RowBox[{"p", ",", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", ">", "m"}], "&"}], ")"}]}], "]"}]], "InlineFormula"],
        " ", "-", " ", "m"}]}], "}"}]}], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"b:0.10b",
 CellID->269736475]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options for MinimumBandwidthOrdering", "Subsubsection",
 CellTags->"b:0.10b",
 CellID->249116623],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use", "TableText"]},
   {
    ButtonBox["RefinementMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/RefinementMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
algorithms used to further improve the quality of the ordering\
\>", "TableText"]},
   {
    ButtonBox["RecursionMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/RecursionMethod"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "recursion method to use", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.10b",
 CellID->220094535],

Cell[TextData[{
 "Options for ",
 StyleBox["MinimumBandwidthOrdering.", "MR"]
}], "Caption",
 CellTags->"b:0.10b",
 CellID->144910677],

Cell[CellGroupData[{

Cell["Method", "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->208570215],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " specifies method used to minimize the bandwidth or envelope size. Possible \
values for this option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<RCM\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<RCMD\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<Sloan\>\""], "InlineFormula"],
 ". By default, ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.10b",
 CellID->15471859],

Cell["\<\
The following example illustrates the difference between bandwidth reduction \
algorithms and the envelope size reduction algorithm. \
\>", "Text",
 CellTags->"b:0.10b",
 CellID->38378614],

Cell["This defines a sparse matrix.", "MathCaption",
 CellTags->"b:0.10b",
 CellID->55566182],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"Floor", "[", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", " ", "1"}], "}"}], " ", "+", " ", ".04"}], ",", 
       " ", 
       RowBox[{"{", 
        RowBox[{"50", ",", " ", "50"}], "}"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"m", "+", 
    RowBox[{"Transpose", "[", "m", "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[145]:=",
 CellID->156383302],

Cell["This reorder the matrix using RCMD method and Sloan method.", \
"MathCaption",
 CellID->1235052410],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "r"}], "}"}], "=", 
   RowBox[{"MinimumBandwidthOrdering", "[", 
    RowBox[{"m", ",", " ", 
     RowBox[{"Method", " ", "->", " ", "\"\<RCMD\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[151]:=",
 CellID->1858700288],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ps", ",", "rs"}], "}"}], "=", 
   RowBox[{"MinimumBandwidthOrdering", "[", 
    RowBox[{"m", ",", " ", 
     RowBox[{"Method", " ", "->", " ", "\"\<Sloan\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[152]:=",
 CellID->1588794428],

Cell["\<\
It is clear from the plots that the RCMD method gives a matrix with much \
smaller bandwidth:.\
\>", "MathCaption",
 CellTags->"b:0.10b",
 CellID->467565390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"MatrixPlot", "[", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"[", 
        RowBox[{"p", ",", "r"}], "]"}], "]"}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<RCMD\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}], ",", 
    RowBox[{"MatrixPlot", "[", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"[", 
        RowBox[{"ps", ",", "rs"}], "]"}], "]"}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<Sloan\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellTags->"b:0.10b",
 CellLabel->"In[156]:=",
 CellID->115661660],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXW1rFUcU3mQ3N/bKlYTaGpOiRhoaSKkoKAaEiEJEQUxbqa0gGLSgLbXV
2k/Sfu+nth/7A0LtC/0B/pv+kume3Tm7Z87O697d5CaZQHbu7J05z3Pm9cyZ
2bu3t18++fKb7ZdPH22fufFi+7snTx99f2bz2xf5rXQqSaZ+TZLkv4Uk/yzy
T8U//P2W/5cffT7N5dc0z3pShtN5OC3jGYvD96mML0HuDDGFIdVyr9LnCw2K
a1qlLVKRvBKFpjgBl5kyXl0bqU6SuO77BSeOS8Lpfcv8WMuSHx/5XVG2nGSm
KgKZcqnz0t5Ltm1L2MUIWtA03lckLehyKim6L+G9ZNtXCbtbjVmrk8ZvlvcJ
z7mWpQo9JRnQFO20snPGsbO62UEbnhTmZXuek1IWZZga4n4z7hLhhPN5f9LL
+Ry+9bFcRvn1X4kN4ai6S0uFl9ISi59yxE87vtf2qj3EPxpLoSoF2gJnxmR0
NZABxYZwkrjIq2Us4vG/uERH/j7k50ueZApCbw0g+lqGM470XcgLZzjZZSwb
S1JJV2alTCe/McY386XGb9pKnFbYVrpbZf+eX2Z3flwbQqQxt6Za1u45mMdD
UUpNcD7EkI8XilSGzvN1IacsWD6nmHLzsd+UTj9T/Zxf5vLUs3mYytAm/VV+
mZfSU0u+iNYv2jOZGqzQYR6mstZHnuguthEVcg0kaurR7x5LVqsyPbL074cH
Fe2xrLdznmi/5JeM1XNE6R7lrmwFG4ba5CibEoX2OxquiLp1ZJFFCxbbMtdI
5lqW7cDFZovUP0W9HNE90W8zdJR2XMZPyHgm/HrkKZnvjgzfFyEjZmRjZoP1
vSzRlg31zFFBi1Ge7rqB5V6gsXWT0K8bfDlYpDkxXHz1slOdFol7ndZSI5Pk
IOxATRPdSl2/x8TXvPeFOifQ/gEh9gOutV46sPDDXRflygL7KfbbORmuCr3m
ZtwkwXTVncZqHxL4anxU1PvTdsnuFIjtq/WRMOxAr0xQnXfqvQmq9WAvj5/2
t4Q6Bxdc3mwlWBJgYcGuA4z2i72VxA8S6Wwrjf3G5NaadjRea3X0HK85jy50
4fOfi59+tr2qY0J6z7yoPQG0l3GPvM5aHxJthkRuBprKeGQb2bZhi7YEjrEZ
YQUoKw5W90Ttj0FW6G+J6Db0WzIXrf+qPndKy9KGjvmXhNresF1EFqEsHshc
A4KaSqk2dPTyZhSd9Ei8z3t4ZLE/WFzJL8d2ao8Z2qcQhlgWXwu1dSKbc5FF
IIvCu5zXJyDeFOp8etyBjKP0RYm8KJrrnsGO6iOKjLpgtC7U3rcmUU55snog
018QtSUVUfceFWbXTK66sD/jOLAmWwq1rXyYLLD0fK+ZtuSilQt1PELPrl6D
NDGfsepCGyrfdaarL005h/BzRp2UhAMzlFNvpaXhMd4prbOiXhVQG2Yo749k
6VJbV2fbdF2Cip8vx8d9DN043sXJL8jetiz46eBQ3xrkten7jlO+1rO2i7Xf
xz5CSAvw2VMIbYHoSd6Q+Ng3jwu9Vd51D8AdbhxLqO50LPHpiawkLON8sNYB
c0hrjRpzBJ/bQ1nzebwtM72lMZlssG/DrjB46Fx+o7tC7fPI3m/tc5hQ0Z+z
JVS7FkcuOqvbWKCceSonz78hSnsXtcJTSH7rmciuPTtux2H40JPVJaHadXOi
HgG4xyiyOThsoDVCK1sT6niCLFODNM5qVah+J7DF7rB7frNAZORmhHuwmOuC
qL2EdGzhfnvXfI47OOdYfhyL/NpUZNeeHe59IYt1xgpHC74Dw9lwPwLm35Ah
ruuR5Vpkd6jZ4boaLfjLorYzdVI4K9jHmCVscIzkJ0VRnp9VE1n5s+Lnza+w
dsJXCJwV7j0sElQcH1FukwX9LRm+ig5lRGUVrdciO5Qtl50HgzKgV5enw0uj
t6r0TYBSojuFhYOX5k4E1c8S7vPitsxFoW+7vC/04X8DzfFZF8B8W9T2mK4t
dOWDAxEfeJbDqkzfxdPQIOe8Q+ezFrzxvI1ta75rr2NorXv43j1+S2Ss0gg8
z6xNMW6JOBHM+xEmbynfK+LzGH12DS0f/YlUCDMWd80qOB5eFlotmTS9V7aV
Bpa51Iuj94w+WaxWGKuPRO1DtqHTc8N0Nb0U0T3R0fKnz8jQdnDFwWJV1Ctf
xQ8h2Mr3zVbxXE5kdEAZ5amvidp6pOcOXGwukfTVfmyO/FlEtp3m2Sn9tLjD
A3XlQv1QqKM+Pr3Dz79fjywCWdwl0nS5ODr2VGwvzw8dClqwNCfdn6rWwHld
uhhQixTn0ROyPv37cmSzH9iss9zo6dp0IOMzNzjnnZfhzYjK60iov9+CLIae
6GjRIgtsI34j6e6il4934p/JM+jFSVkfpkRaxuKmk0Faxkap5aoz3LOFT8eD
q3JW0yb68KbRcwlQjvhkgfa3Dh1eND90iHJNb8j7WUcaQtSk2XtWrHE9pYej
Dg+3xreFuqfM12F9aIznPS4GYYZ797S6tfbeaVkHeutcpW36lRlTSZnPCegs
H5zXP3Wg4lqfnum6JkJm18ig3mvdkLnuOxDxTA6eA0ef5+OItqto3DsF686B
Byp/ih+tYrSznkV0T3Q8j/TAgUp9kni2EOuc+2UiInqg0PP/0IGMdbkd0fYE
ja7TqMeQj2K6FoMzFjL8KiLKuzCXDIldgCMd9ybqEDeFvs+WSMCnWov5IjbW
3SODlAZ+I2fxi8AJ/13gVLTTn9vsvBy5XFv5cFkDL6boccd6fjkuQ6F/ThV7
80+tWdPTNMj2ubzP61HHMpPrBRu7VwZ5B60safwMi8/skhZ85Ye4flrBtYs3
drR6n0ljPXpsotgcEboxeVe4WMb23cavZ6bmu4ggQXwbo5I3aXqUJuWdhrzm
9w/z+DbGvtnGtzH2zTa+jbEPnvFtjHvF/LC9jXGcTx8zftMknmrKFj7SPSNQ
5W9R2zDF98oufXH2hOX6vPj4ibY207Hv8rXda20qqlklyzqO8rK4V2vRfF8Z
Xy+5z/U3GPK1BpSzrn/1x3xgQOyOL35scv6i4ph1zuxPQXYXXW2ArkBIO4ar
rR1rV7UWLG2r4a3Y8j3vxZxrXZ5urqlHzflw/oPFec98YuHEeg3TDN+vxxG5
Ju6+X/OAsXBGyk5Z6aWa+/AHBP8R0rYl9wsvqvconEz9DxS5op0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{400, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.10b",
 CellLabel->"Out[156]=",
 CellID->48986718]
}, Open  ]],

Cell["\<\
This defines two functions that calculate the bandwidth and envelope size of \
a matrix.\
\>", "MathCaption",
 CellTags->"b:0.10b",
 CellID->211557088],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Bandwidth", "[", 
    RowBox[{"m_", "?", "MatrixQ"}], "]"}], ":=", " ", 
   RowBox[{"Max", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
         RowBox[{"#", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "]"}], "&"}], ",", 
      RowBox[{"Drop", "[", 
       RowBox[{
        RowBox[{"ArrayRules", "[", "m", "]"}], ",", 
        RowBox[{"-", "1"}]}], "]"}]}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Envelope", "[", 
    RowBox[{"m_", "?", "MatrixQ"}], "]"}], ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "=", 
        RowBox[{
         RowBox[{"Dimensions", "[", "m", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", "pfs"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"pfs", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", "i", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"pfs", "[", 
            RowBox[{"[", 
             RowBox[{"#", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"pfs", "[", 
              RowBox[{"[", 
               RowBox[{"#", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], ",", 
             RowBox[{"#", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}]}], ")"}], "&"}],
         ",", 
        RowBox[{"Drop", "[", 
         RowBox[{
          RowBox[{"ArrayRules", "[", "m", "]"}], ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Total", "[", 
       RowBox[{"Map", "[", 
        RowBox[{"Max", ",", 
         RowBox[{
          RowBox[{"Range", "[", "n", "]"}], "-", 
          RowBox[{"Map", "[", 
           RowBox[{"Flatten", ",", "pfs"}], "]"}]}]}], "]"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellTags->"b:0.10b",
 CellLabel->"In[161]:=",
 CellID->54977688],

Cell["\<\
This shows that the RCMD method tries to minimize the bandwidth, and thus \
gives smaller bandwidth.\
\>", "MathCaption",
 CellTags->"b:0.10b",
 CellID->359044420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Bandwidth", "[", 
    RowBox[{"m", "[", 
     RowBox[{"[", 
      RowBox[{"p", ",", "r"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"Bandwidth", "[", 
    RowBox[{"m", "[", 
     RowBox[{"[", 
      RowBox[{"ps", ",", "rs"}], "]"}], "]"}], "]"}]}], "}"}]], "Input",
 CellTags->"b:0.10b",
 CellLabel->"In[11]:=",
 CellID->162186416],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"28", ",", "40"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.10b",
 CellLabel->"Out[11]=",
 CellID->520553215]
}, Open  ]],

Cell["\<\
This shows that the Sloan method attempts to minimize the envelope size.\
\>", "MathCaption",
 CellTags->"b:0.10b",
 CellID->1613786388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Envelope", "[", 
    RowBox[{"m", "[", 
     RowBox[{"[", 
      RowBox[{"p", ",", "r"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"Envelope", "[", 
    RowBox[{"m", "[", 
     RowBox[{"[", 
      RowBox[{"ps", ",", "rs"}], "]"}], "]"}], "]"}]}], "}"}]], "Input",
 CellTags->"b:0.10b",
 CellLabel->"In[157]:=",
 CellID->405083175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"526", ",", "414"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.10b",
 CellLabel->"Out[157]=",
 CellID->1160293545]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RefinementMethod", "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->414869041],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["RefinementMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/RefinementMethod"]], 
  "InlineFormula"],
 " option specifies the refinement method used to further improve the \
bandwidth following the application of one of the above methods. Possible \
values for this option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<HillClimbing\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<NodeCentroidHillClimbing\>\""], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"b:0.10b",
 CellID->60742260]
}, Open  ]],

Cell[CellGroupData[{

Cell["RecursionMethod", "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->64159827],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["RecursionMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/RecursionMethod"]], 
  "InlineFormula"],
 " option specifies whether to employ a multilevel process. Possible values \
for this option are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " (the default) and ",
 Cell[BoxData["\"\<Multilevel\>\""], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"b:0.10b",
 CellID->44154937]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Applications", "Subsubsection",
 CellTags->"b:0.10b",
 CellID->171535448],

Cell["\<\
One of the applications of minimum bandwidth ordering is in optimizing cache \
performance of numerical calculations. For example, in multiplying a sparse \
matrix with a vector, if the matrix is preordered to minimize the bandwidth, \
then elements of the vector will not be accessed randomly, thus improving \
cache performance. Because ordering itself takes time, this improvement in \
cache performance would be beneficial only if the matrix-vector product \
operation is to be performed repeatedly many times.\
\>", "Text",
 CellID->1186433259],

Cell["\<\
This generates a banded matrix, and then randomly permutes it.\
\>", "MathCaption",
 CellID->617122973],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "200000"}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"Random", "[", "]"}]}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"Random", "[", "]"}]}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"Random", "[", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->484997384],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Ordering", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", "n", "}"}]}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"Ordering", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", "n", "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"a", "[", 
    RowBox[{"[", 
     RowBox[{"p", ",", "q"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->1268113918],

Cell["This performs a matrix-vector product 50 times.", "MathCaption",
 CellID->43315634],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "n", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"bx", "=", 
       RowBox[{"b", ".", "x"}]}], ";"}], ",", 
     RowBox[{"{", "50", "}"}]}], "]"}], ";"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[14]:=",
 CellID->1209087470],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.340271000000001`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->503351351]
}, Open  ]],

Cell["\<\
This permutes the matrix to minimize the bandwidth, and does a corresponding \
permutation of the vector.\
\>", "MathCaption",
 CellID->1131529567],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r", ",", "c"}], "}"}], "=", 
   RowBox[{"MinimumBandwidthOrdering", "[", "b", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"aa", "=", 
   RowBox[{"b", "[", 
    RowBox[{"[", 
     RowBox[{"r", ",", "c"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"xx", "=", 
   RowBox[{"x", "[", 
    RowBox[{"[", "c", "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[16]:=",
 CellID->1045269098],

Cell["This shows that matrix-vector product now takes less time.", \
"MathCaption",
 CellID->689341299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"aax", "=", 
      RowBox[{"aa", ".", "xx"}]}], ",", 
     RowBox[{"{", "50", "}"}]}], "]"}], ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->1397158291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0360649999999976`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->2041990880]
}, Open  ]],

Cell["\<\
This checks that the answer is the same, subject to a permutation.\
\>", "MathCaption",
 CellID->1637778318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"aax", "\[Equal]", 
  RowBox[{"bx", "[", 
   RowBox[{"[", "r", "]"}], "]"}]}]], "Input",
 CellLabel->"In[20]:=",
 CellID->1240548019],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->169740494]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PageRanks, PageRankVector, LinkRanks, LinkRankMatrix", "Subsection",
 CellTags->{"graphplot", "i:3", "b:0.1"},
 CellID->12840550],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PageRanks",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/PageRanks"], 
     StyleBox["[", "MR"], 
     StyleBox["g", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "gives the page rank of the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " as a rule list"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["PageRankVector",
       BaseStyle->"Link",
       ButtonData->"paclet:GraphUtilities/ref/PageRankVector"], 
      StyleBox["[", "MR"], 
      StyleBox["g", "TI"], 
      StyleBox["]", "MR"]}], " "}], Cell[TextData[{
     "gives the page rank of the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " as a vector"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.1",
 CellID->90032787],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PageRanks",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRanks"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PageRankVector",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRankVector"]], 
  "InlineFormula"],
 " functions. "
}], "Caption",
 CellTags->"b:0.11",
 CellID->266071060],

Cell[TextData[{
 "This calculates the ",
 Cell[BoxData[
  ButtonBox["PageRanks",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRanks"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PageRankVector",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRankVector"]], 
  "InlineFormula"],
 " of a small graph."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->160737363],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<contact\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<links\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<work\>\""}], ",", 
     RowBox[{"\"\<links\>\"", "\[Rule]", "\"\<friend site\>\""}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"pr", "=", 
  RowBox[{"PageRanks", "[", "g", "]"}]}]}], "Input",
 CellLabel->"In[29]:=",
 CellID->152225696],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"home\"\>", "\[Rule]", "0.14407493377505026`"}], ",", 
   RowBox[{"\<\"contact\"\>", "\[Rule]", "0.18489614297669474`"}], ",", 
   RowBox[{"\<\"links\"\>", "\[Rule]", "0.18489614297669474`"}], ",", 
   RowBox[{"\<\"work\"\>", "\[Rule]", "0.18489614297669474`"}], ",", 
   RowBox[{"\<\"friend site\"\>", "\[Rule]", "0.30123663729486566`"}]}], 
  "}"}]], "Output",
 ImageSize->{397, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->80612289]
}, Open  ]],

Cell["This shows page rank and the graph together.", "MathCaption",
 CellTags->"b:0.1",
 CellID->24492853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{"g", ",", 
    RowBox[{"VertexCoordinateRules", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"EdgeRenderingFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Arrow", "[", 
        RowBox[{"#1", ",", ".2"}], "]"}], "&"}], ")"}]}], ",", 
    RowBox[{"VertexRenderingFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".9", "]"}], ",", 
         RowBox[{"EdgeForm", "[", "Blue", "]"}], ",", 
         RowBox[{"Disk", "[", 
          RowBox[{"#1", ",", ".2"}], "]"}], ",", "Black", ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"#2", "<>", "\"\<\\n\>\"", "<>", 
            RowBox[{"ToString", "[", 
             RowBox[{"pr", "[", 
              RowBox[{"[", 
               RowBox[{"#3", ",", "2"}], "]"}], "]"}], "]"}]}], ",", "#1"}], 
          "]"}]}], "}"}], "&"}], ")"}]}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->173442147],

Cell[BoxData[
 GraphicsBox[
  TagBox[{{ArrowBox[{{0., 1.}, {0.5, 0.}}, 0.2], 
     ArrowBox[{{0., 1.}, {1., 1.}}, 0.2], ArrowBox[{{0., 1.}, {0., 0.}}, 0.2],
      ArrowBox[{{1., 1.}, {1., 0.}}, 0.2]}, {
     {GrayLevel[0.9], EdgeForm[RGBColor[0, 0, 1]], DiskBox[{0., 1.}, 0.2], 
      {GrayLevel[0], InsetBox["\<\"home\\n0.144075\"\>", {0., 1.}]}}, 
     {GrayLevel[0.9], EdgeForm[RGBColor[0, 0, 1]], DiskBox[{0.5, 0.}, 0.2], 
      {GrayLevel[0], InsetBox["\<\"contact\\n0.184896\"\>", {0.5, 0.}]}}, 
     {GrayLevel[0.9], EdgeForm[RGBColor[0, 0, 1]], DiskBox[{1., 1.}, 0.2], 
      {GrayLevel[0], InsetBox["\<\"links\\n0.184896\"\>", {1., 1.}]}}, 
     {GrayLevel[0.9], EdgeForm[RGBColor[0, 0, 1]], DiskBox[{0., 0.}, 0.2], 
      {GrayLevel[0], InsetBox["\<\"work\\n0.184896\"\>", {0., 0.}]}}, 
     {GrayLevel[0.9], EdgeForm[RGBColor[0, 0, 1]], DiskBox[{1., 0.}, 0.2], 
      {GrayLevel[0], InsetBox["\<\"friend site\\n0.301237\"\>", {1., 0.}]}}}},
   
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.}, {0.5, 0.}, {1., 1.}, {0., 0.}, {1., 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{261., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{265, 261},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->2106811907]
}, Open  ]],

Cell["\<\
This boosts the page rank of \"home\" by adding more feedback links.\
\>", "MathCaption",
 FontColor->GrayLevel[0],
 CellID->16805842],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<contact\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<links\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<work\>\""}], ",", 
     RowBox[{"\"\<links\>\"", "\[Rule]", "\"\<friend site\>\""}], ",", 
     RowBox[{"\"\<friend site\>\"", "\[Rule]", "\"\<home\>\""}], ",", 
     RowBox[{"\"\<work\>\"", "\[Rule]", "\"\<home\>\""}], ",", 
     RowBox[{"\"\<contact\>\"", "\[Rule]", "\"\<home\>\""}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"pr", "=", 
   RowBox[{"PageRanks", "[", "g", "]"}]}], ";"}], "\n", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{".5", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Arrow", "[", 
       RowBox[{"#1", ",", ".2"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", ".9", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Blue", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", ".2"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"#2", "<>", "\"\<\\n\>\"", "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{"pr", "[", 
             RowBox[{"[", 
              RowBox[{"#3", ",", "2"}], "]"}], "]"}], "]"}]}], ",", "#1"}], 
         "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellLabel->"In[32]:=",
 CellID->86303621],

Cell[BoxData[
 GraphicsBox[
  TagBox[{{
     ArrowBox[{{0., 1.}, {0.07723931248909999, 0.9098874687627166}, {
      0.09749755239811814, 0.8853983370985797}, {0.11688651753901648`, 
      0.8602153689526323}, {0.13538246299000298`, 0.8343694049398719}, {
      0.15296273747624126`, 0.8078920976208999}, {0.1696058111099979, 
      0.7808158727382445}, {0.18529130175746947`, 0.753173889505798}, {
      0.2000000000000003, 0.7249999999999994}, {0.4, 0.32499999999999996`}, {
      0.4137138926591203, 0.2963287077024962}, {0.4264161848565946, 
      0.26719512524505107`}, {0.4380913205824649, 0.23763493140845252`}, {
      0.44872500174589947`, 0.20768432742807863`}, {0.45830420568551583`, 
      0.1773799926596332}, {0.46681720111773484`, 0.14675903965934614`}, {
      0.4742535625036335, 0.11585896873364947`}, {0.5, 0.}}, 0.2], 
     ArrowBox[{{0., 1.}, {1., 1.}}, 0.2], 
     ArrowBox[{{0., 1.}, {0.025746437496366743`, 0.8970142500145333}, {
      0.03215737675792646, 0.8693196487196164}, {0.03759536161226607, 
      0.8414176881464992}, {0.042053732367951145`, 0.8133425387558963}, {
      0.04552702902935305, 0.7851285831062234}, {0.04801099798329617, 
      0.7568103737465964}, {0.04950259720829479, 0.7284225909016506}, {
      0.050000000000000044`, 0.6999999999999995}, {0.050000000000000044`, 
      0.3}, {0.049502597208294766`, 0.2715774090983489}, {0.04801099798329613,
       0.24318962625340304`}, {0.04552702902935298, 0.2148714168937761}, {
      0.042053732367951055`, 0.18665746124410315`}, {0.03759536161226596, 
      0.15858231185350027`}, {0.03215737675792633, 0.13068035128038302`}, {
      0.025746437496366587`, 0.1029857499854662}, {0., 0.}}, 0.2], 
     ArrowBox[{{0.5, 0.}, {0.4227606875109, 0.09011253123728347}, {
      0.40250244760188186`, 0.11460166290142046`}, {0.38311348246098353`, 
      0.13978463104736788`}, {0.36461753700999705`, 0.1656305950601282}, {
      0.3470372625237587, 0.19210790237910022`}, {0.3303941888900021, 
      0.2191841272617556}, {0.3147086982425306, 0.24682611049420208`}, {
      0.2999999999999998, 0.2750000000000006}, {0.09999999999999998, 0.675}, {
      0.0862861073408797, 0.7036712922975038}, {0.07358381514340538, 
      0.732804874754949}, {0.06190867941753512, 0.7623650685915474}, {
      0.05127499825410055, 0.7923156725719214}, {0.04169579431448422, 
      0.8226200073403668}, {0.03318279888226524, 0.8532409603406538}, {
      0.025746437496366553`, 0.8841410312663506}, {0., 1.}}, 0.2], 
     ArrowBox[{{1., 1.}, {1., 0.}}, 0.2], 
     ArrowBox[{{0., 0.}, {-0.025746437496366743`, 
      0.10298574998546682`}, {-0.03215737675792646, 
      0.13068035128038366`}, {-0.03759536161226607, 
      0.1585823118535009}, {-0.042053732367951145`, 
      0.1866574612441038}, {-0.04552702902935305, 
      0.21487141689377673`}, {-0.04801099798329617, 
      0.24318962625340368`}, {-0.04950259720829479, 
      0.27157740909834954`}, {-0.050000000000000044`, 
      0.30000000000000066`}, {-0.050000000000000044`, 
      0.7000000000000001}, {-0.049502597208294766`, 
      0.7284225909016512}, {-0.04801099798329613, 
      0.7568103737465971}, {-0.04552702902935298, 
      0.785128583106224}, {-0.042053732367951055`, 
      0.8133425387558969}, {-0.03759536161226596, 
      0.8414176881464999}, {-0.03215737675792633, 
      0.8693196487196171}, {-0.025746437496366587`, 0.8970142500145339}, {0., 
      1.}}, 0.2], ArrowBox[{{1., 0.}, {0., 1.}}, 0.2]}, {
     {GrayLevel[0.9], EdgeForm[RGBColor[0, 0, 1]], DiskBox[{0., 1.}, 0.2], 
      {GrayLevel[0], InsetBox["\<\"home\\n0.408689\"\>", {0., 1.}]}}, 
     {GrayLevel[0.9], EdgeForm[RGBColor[0, 0, 1]], DiskBox[{0.5, 0.}, 0.2], 
      {GrayLevel[0], InsetBox["\<\"contact\\n0.145795\"\>", {0.5, 0.}]}}, 
     {GrayLevel[0.9], EdgeForm[RGBColor[0, 0, 1]], DiskBox[{1., 1.}, 0.2], 
      {GrayLevel[0], InsetBox["\<\"links\\n0.145795\"\>", {1., 1.}]}}, 
     {GrayLevel[0.9], EdgeForm[RGBColor[0, 0, 1]], DiskBox[{0., 0.}, 0.2], 
      {GrayLevel[0], InsetBox["\<\"work\\n0.145795\"\>", {0., 0.}]}}, 
     {GrayLevel[0.9], EdgeForm[RGBColor[0, 0, 1]], DiskBox[{1., 0.}, 0.2], 
      {GrayLevel[0], InsetBox["\<\"friend site\\n0.153926\"\>", {1., 0.}]}}}},
   
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.}, {0.5, 0.}, {1., 1.}, {0., 0.}, {1., 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{261., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{265, 261},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->1560455589]
}, Open  ]],

Cell[CellGroupData[{

Cell["PageRanks Algorithm", "Subsubsection",
 CellTags->"b:0.1",
 CellID->352842546],

Cell[TextData[{
 "Roughly speaking, for a directed graph, the page rank of a vertex is the \
probability a random internet surfer visits that vertex, assuming that the \
directed graph represents the Internet, with a vertex ",
 Cell[BoxData[
  FormBox[
   StyleBox["i", "TI"], TraditionalForm]]],
 " having a link to a vertex ",
 Cell[BoxData[
  FormBox[
   StyleBox["j", "TI"], TraditionalForm]]],
 " if there is an edge from ",
 Cell[BoxData[
  FormBox[
   StyleBox["i", "TI"], TraditionalForm]]],
 " to ",
 Cell[BoxData[
  FormBox[
   StyleBox["j", "TI"], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->9966090],

Cell[TextData[{
 "Imaging a random surfer visiting a page",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    StyleBox["i", "TI"]}], TraditionalForm]]],
 " at time step ",
 Cell[BoxData[
  FormBox[
   StyleBox["k", "TI"], TraditionalForm]]],
 ". At the next step, the surfer will choose randomly, at equal probability, \
a node ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 " from among ",
 Cell[BoxData[
  FormBox[
   StyleBox["i", "TI"], TraditionalForm]]],
 "'s out-neighbors,",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"l", "|", "i"}], "\[Rule]", " ", "l"}], "}"}], "."}], 
   TraditionalForm]]]
}], "Text",
 CellTags->"b:0.1",
 CellID->291558977],

Cell[TextData[{
 "Some modification has to be made to the graph to avoid the surfer being \
trapped at a sink (a node that does not have any outer-links). For any node",
 " ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 " that has a zero outer degree, we will link it to every node, including \
itself. With this modification, we can define the following."
}], "Text",
 CellTags->"b:0.1",
 CellID->485621972],

Cell[TextData[{
 "The page rank of a page ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", " ", "\[Element]", " ", "V"}], TraditionalForm]]],
 " is defined as the probability that the surfer, at time step",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", "k"}], TraditionalForm]]],
 ", is at page ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "."}], TraditionalForm]]]
}], "Text",
 CellTags->"b:0.1",
 CellID->488661365],

Cell[TextData[{
 "Define a matrix ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]]],
 " to be of the same structure as the graph, with entry values ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"P", 
     RowBox[{"(", 
      RowBox[{"i", ",", "j"}], ")"}]}], "=", " ", 
    RowBox[{
     RowBox[{"1", "/", "deg"}], 
     RowBox[{"(", "i", ")"}]}]}], TraditionalForm]]],
 " for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j", "|", "i"}], "\[Rule]", "j"}], "}"}], ","}], 
   TraditionalForm]]],
 " with d",
 Cell[BoxData[
  FormBox[
   RowBox[{"eg", 
    RowBox[{"(", "i", ")"}], " "}], TraditionalForm]]],
 "the outer degree of ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 ". Thus provided that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"deg", "(", "i", ")"}], " ", "\[NotEqual]", " ", "0"}], ",", 
    " "}], TraditionalForm]]],
 "the sum of the",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", "i"}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " row is 1. If",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"deg", 
     RowBox[{"(", "i", ")"}]}], " ", "=", " ", "0"}], TraditionalForm]]],
 ", we will modify row",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", "i"}], TraditionalForm]]],
 " by setting every entry in that row to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "n"}], TraditionalForm]]],
 ", with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " the number of vertices. Thus the modified matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "'"}], TraditionalForm]]],
 " is"
}], "Text",
 CellTags->"b:0.1",
 CellID->587622375],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"P", "'"}], " ", "=", " ", 
    RowBox[{"P", " ", "+", " ", "D"}]}], ","}], TraditionalForm]]]], "Text",
 CellTags->"b:0.1",
 CellID->30706421],

Cell[TextData[{
 "with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"D", " ", "=", " ", 
    RowBox[{"d", " ", 
     RowBox[{
      SuperscriptBox["e", "T"], "/", "n"}]}]}], TraditionalForm]]],
 ". Here ",
 Cell[BoxData[
  FormBox["e", TraditionalForm]]],
 " is the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 "-dimensional column vector of all 1's, and",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", "d"}], TraditionalForm]]],
 " is a column vector of 0's, except that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", 
     RowBox[{"(", "i", ")"}]}], " ", "=", " ", 
    RowBox[{"1", "/", "n"}]}], TraditionalForm]]],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"i", "|", " ", 
      RowBox[{"deg", 
       RowBox[{"(", "i", ")"}]}]}], " ", "=", " ", "0"}], "}"}], 
   TraditionalForm]]],
 ". Thus D is a matrix with row ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 " of entry values ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "n"}], TraditionalForm]]],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"deg", 
     RowBox[{"(", "i", ")"}]}], " ", "=", " ", "0"}], TraditionalForm]]],
 ", and entry values 0 for other rows."
}], "Text",
 CellTags->"b:0.1",
 CellID->241477472],

Cell[TextData[{
 "We need one more modification. If the directed graph given by ",
 StyleBox["P'", "TI"],
 " is not strongly connected, then the surfer will be trapped in a component \
of the directed graph. Thus to ensure than every page can be visited, we \
assume that the surfer, on visiting a page ",
 StyleBox["i", "TI"],
 ", will then have a small probability (the ",
 StyleBox["teleport probability",
  FontSlant->"Italic"],
 ") of visiting any page randomly. Therefore, to summarize, from a node ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "\[Element]", 
    RowBox[{"{", 
     RowBox[{"l", "|", 
      RowBox[{
       RowBox[{"deg", "(", "l", ")"}], "\[NotEqual]", " ", "0"}]}], "}"}]}], 
   TraditionalForm]]],
 ", there is a probability of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"c", "/", "deg"}], 
    RowBox[{"(", "i", ")"}]}], TraditionalForm]]],
 " of visiting any of its deg(i) neighbors, and a probability ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "c"}], ")"}], "/", "n"}], TraditionalForm]]],
 " of visiting any node (including itself); from a node ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"i", "\[Element]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"l", "|", 
        RowBox[{"deg", "(", "l", ")"}]}], "=", " ", "0"}], "}"}]}], ","}], 
   TraditionalForm]]],
 " there is a probability of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"c", "/", "n"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "c"}], ")"}], "/", "n"}]}], " ", "=", " ", 
    RowBox[{"1", "/", "n"}]}], TraditionalForm]]],
 " of visiting any node. In matrix terms,",
 " ",
 "a PageRank vector ",
 StyleBox["x", "TI"],
 " must satisfy"
}], "Text",
 CellTags->"b:0.1",
 CellID->31481460],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"x", " ", "=", " ", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"p", "''"}], "T"], " ", "x", " "}]}], TraditionalForm]]]], "Text",\

 CellTags->"b:0.1",
 CellID->219815997],

Cell["with ", "Text",
 CellTags->"b:0.1",
 CellID->178466116],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"P", "''"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"c", " ", 
     RowBox[{"P", "'"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "c"}], ")"}], " ", "e", " ", 
     RowBox[{
      SuperscriptBox["e", "T"], "/", "n"}]}]}]}], TraditionalForm]]]], "Text",\

 CellTags->"b:0.1",
 CellID->34745763],

Cell[TextData[{
 "Denoting ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", " ", "=", " ", 
    SuperscriptBox[
     RowBox[{"P", "''"}], "T"]}], TraditionalForm]]],
 ", the task of calculating page rank is that of finding a fixed point",
 " ",
 "of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", " ", "=", " ", 
    RowBox[{"A", " ", "x"}]}], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->91183741],

Cell[TextData[{
 "The fixed point calculation is done iteratively, starting from a vector of \
1's. If the average change in the page ranks is less than a tolerance, the \
process is assumed to have converged. The final result is an approximation of \
the surfer's probability, scaled so that the sum is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "."}], TraditionalForm]]]
}], "Text",
 CellTags->"b:0.1",
 CellID->27459171],

Cell[TextData[{
 "An alternative model for dealing with sinks is not to remove it by linking \
it to every node, but to just link to itself. Under this model, the only way \
to get out of a sink is through teleporting. Hence at this node, the surfer \
has a probability of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", " "}], TraditionalForm]]],
 "to stay at the node, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "c"}], ")"}], "/", "n", " "}], TraditionalForm]]],
 "of visiting any node. This model can be accessed through the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RemoveSinks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/RemoveSinks"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->337999237]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options for PageRanks and PageRankVector", "Subsubsection",
 CellTags->{"Options_for_GraphPlot", "b:0.1"},
 CellID->165075718],

Cell["The following options are accepted.", "Text",
 CellTags->"b:0.1",
 CellID->665584976],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "tolerance used for convergence check", "TableText"]},
   {
    ButtonBox["TeleportProbability",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/TeleportProbability"], "0.15", 
    Cell["probability of visiting random nodes", "TableText"]},
   {
    ButtonBox["RemoveSinks",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/RemoveSinks"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to remove sinks by linking them with every node", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.1",
 CellID->423183779],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["PageRanks",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRanks"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PageRankVector",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRankVector"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:0.1",
 CellID->299747457],

Cell[CellGroupData[{

Cell["Tolerance", "Subsubsubsection",
 CellTags->"b:0.1",
 CellID->441644662],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 " option specifies the convergence tolerance of the iterative algorithm for \
the page rank calculation. If the average change is less than the tolerance, \
the iterative process terminates. Possible values for this option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", or a positive machine-sized number."
}], "Text",
 CellTags->"b:0.1",
 CellID->388666005]
}, Open  ]],

Cell[CellGroupData[{

Cell["TeleportProbability", "Subsubsubsection",
 CellTags->"b:0.1",
 CellID->174016635],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["TeleportProbablity",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/TeleportProbability"]], 
  "InlineFormula"],
 " option specifies the probability that the internet surfer may choose to \
visit nodes randomly, instead of following the out-links of a vertex.\n\
Possible values for this option are positive machine-sized numbers less than \
1, with a default value of 0.15. Smaller values of this option make the page \
ranks a more accurate reflection of a normal internet surfer's behavior, but \
makes the iterative process that calculates the page ranks converge more \
slowly."
}], "Text",
 CellTags->"b:0.1",
 CellID->13002614]
}, Open  ]],

Cell[CellGroupData[{

Cell["RemoveSinks", "Subsubsubsection",
 CellTags->"b:0.1",
 CellID->228658500],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["RemoveSinks",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/RemoveSinks"]], "InlineFormula"],
 " option specifies whether sinks (a node with no outer-links) are removed by \
linking with every node. The default value is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". Possible values are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->643225519],

Cell[TextData[{
 "This calculates the ",
 Cell[BoxData[
  ButtonBox["PageRanks",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRanks"]], "InlineFormula"],
 " of a simple directed graph."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->216973463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PageRanks", "[", 
  RowBox[{"{", 
   RowBox[{"1", "->", "2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->411981085],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "0.35087712117725867`"}], ",", 
   RowBox[{"2", "\[Rule]", "0.6491228788227413`"}]}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->236110384]
}, Open  ]],

Cell[TextData[{
 "This calculates the ",
 Cell[BoxData[
  ButtonBox["PageRanks",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRanks"]], "InlineFormula"],
 " of the graph without removing the sink (node 2)."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->152890940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PageRanks", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", "->", "2"}], "}"}], ",", 
   RowBox[{"RemoveSinks", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->286841857],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "0.075`"}], ",", 
   RowBox[{"2", "\[Rule]", "0.9249999999999998`"}]}], "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1381496751]
}, Open  ]],

Cell[TextData[{
 "To understand the results, assume the probability (",
 Cell[BoxData[
  ButtonBox["PageRanks",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRanks"]], "InlineFormula"],
 ") of the surfer at node ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", " "}], TraditionalForm]]],
 "is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "i"], TraditionalForm]]],
 ", and the teleport probability is ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 ". Then with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RemoveSinks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/RemoveSinks"], "\[Rule]", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the surfer would visit node 1 either from node 2 due to the link added \
from node 2 to each node after removing the sink (with a probability of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}], " ", 
    SubscriptBox["r", "2"]}], TraditionalForm]]],
 "), or from node 1 itself due to teleporting (with a probability of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", " ", 
    RowBox[{
     SubscriptBox["r", "1"], "/", "2"}]}], TraditionalForm]]],
 "), or from node 2 due to teleporting (with a probability of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", " ", 
    RowBox[{
     SubscriptBox["r", "2"], "/", "2"}]}], TraditionalForm]]],
 "). Hence ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "1"], "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "p"}], ")"}], " ", 
      RowBox[{
       SubscriptBox["r", "2"], "/", "2"}]}], " ", "+", " ", 
     RowBox[{"p", " ", 
      RowBox[{
       SubscriptBox["r", "1"], "/", "2"}]}], " ", "+", " ", 
     RowBox[{"p", " ", 
      RowBox[{
       SubscriptBox["r", "2"], "/", "2"}]}]}]}], TraditionalForm]]],
 ". Similarly node 2 is visited either due to teleporting from node 1 \
(probability ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", " ", 
    RowBox[{
     SubscriptBox["r", "1"], "/", "2"}]}], TraditionalForm]]],
 "), or from node 1 following the link (probability ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}], " ", 
    SubscriptBox["r", "1"]}], TraditionalForm]]],
 "), or from node 2 following the added link after removal of the sink \
(probability ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}], " ", 
    SubscriptBox["r", "2"]}], TraditionalForm]]],
 "), or from node 2 due to teleporting (probability ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", " ", 
    RowBox[{
     SubscriptBox["r", "2"], "/", "2"}]}], TraditionalForm]]],
 "). Thus the probability satisfies the following equations, ",
 "normal",
 "ized to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["r", "1"], "+", 
     SubscriptBox["r", "2"]}], " ", "=", " ", "2."}], TraditionalForm]]]
}], "Text",
 CellTags->"b:0.1",
 CellID->696743200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["r", "1"], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}], " ", 
        RowBox[{
         SubscriptBox["r", "2"], "/", "2"}]}], " ", "+", " ", 
       RowBox[{"p", "  ", 
        RowBox[{
         SubscriptBox["r", "1"], "/", "2"}]}], "+", 
       RowBox[{"p", " ", 
        RowBox[{
         SubscriptBox["r", "2"], "/", "2"}]}]}]}], ",", " ", 
     RowBox[{
      SubscriptBox["r", "2"], " ", "==", 
      RowBox[{
       RowBox[{"p", " ", 
        RowBox[{
         SubscriptBox["r", "1"], "/", "2"}]}], " ", "+", "  ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}], " ", 
        SubscriptBox["r", "1"]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}], "  ", 
        RowBox[{
         SubscriptBox["r", "2"], "/", "2"}]}], "+", 
       RowBox[{"p", " ", 
        RowBox[{
         SubscriptBox["r", "2"], "/", "2"}]}]}]}], ",", " ", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       SubscriptBox["r", "1"], "+", 
       SubscriptBox["r", "2"]}], "==", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["r", "1"], ",", 
     SubscriptBox["r", "2"]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->69144570],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["r", "1"], "\[Rule]", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "p"}]]}]}], ",", 
    RowBox[{
     SubscriptBox["r", "2"], "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "p"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", "3"}], "+", "p"}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{209, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1660727361]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", " ", "=", " ", "0.15"}], TraditionalForm]]],
 ", the above is:"
}], "Text",
 CellTags->"b:0.1",
 CellID->58600801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"p", "\[Rule]", "0.15"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->70409623],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["r", "1"], "\[Rule]", "0.7017543859649122`"}], ",", 
    RowBox[{
     SubscriptBox["r", "2"], "\[Rule]", "1.2982456140350878`"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->658484530]
}, Open  ]],

Cell["\<\
When the sink is not removed, the following equations are satisfied:\
\>", "Text",
 CellID->338182235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["r", "1"], "==", " ", 
      RowBox[{
       RowBox[{"p", "  ", 
        RowBox[{
         SubscriptBox["r", "1"], "/", "2"}]}], "+", 
       RowBox[{"p", " ", 
        RowBox[{
         SubscriptBox["r", "2"], "/", "2"}]}]}]}], ",", " ", 
     RowBox[{
      SubscriptBox["r", "2"], " ", "==", 
      RowBox[{
       RowBox[{"p", " ", 
        RowBox[{
         SubscriptBox["r", "1"], "/", "2"}]}], " ", "+", "  ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}], " ", 
        SubscriptBox["r", "1"]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}], "  ", 
        SubscriptBox["r", "2"]}], "+", 
       RowBox[{"p", " ", 
        RowBox[{
         SubscriptBox["r", "2"], "/", "2"}]}]}]}], ",", " ", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       SubscriptBox["r", "1"], "+", 
       SubscriptBox["r", "2"]}], "==", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["r", "1"], ",", 
     SubscriptBox["r", "2"]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->44019153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["r", "1"], "\[Rule]", "p"}], ",", 
    RowBox[{
     SubscriptBox["r", "2"], "\[Rule]", 
     RowBox[{"2", "-", "p"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1014372329]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"p", "\[Rule]", "0.15"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->109862815],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["r", "1"], "\[Rule]", "0.15`"}], ",", 
    RowBox[{
     SubscriptBox["r", "2"], "\[Rule]", "1.85`"}]}], "}"}], "}"}]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->506631393]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PseudoDiameter", "Subsection",
 CellID->338176873],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PseudoDiameter",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/PseudoDiameter"], 
     StyleBox["[", "MR"], 
     StyleBox["g", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "gives the pseudo diameter of the undirected graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ", and the two vertices that achieve this diameter"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.1",
 CellID->1716347051],

Cell["Finding pseudo diameter of undirected graphs", "Caption",
 CellTags->"b:0.11",
 CellID->1930395161],

Cell[TextData[{
 "A graph geodesic is a shortest path between two vertices of a graph. The \
graph diameter is the longest possible length of all graph geodesics of the \
graph. ",
 Cell[BoxData[
  RowBox[{" ", 
   ButtonBox["PseudoDiameter",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PseudoDiameter"]}]], 
  "InlineFormula"],
 " finds an approximate graph diameter. "
}], "Text",
 CellID->52933267],

Cell[TextData[{
 "The algorithm used works by starting from a vertex ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 ", and finds a vertex ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " that is farthest away from ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 ".",
 " ",
 "This process is repeated by treating ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " as the new starting vertex, and ends when the graph distance no longer \
increases. A vertex from the last level set that has the smallest degree is \
chosen as the final starting vertex ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 ", and a traversal is done to see if the graph distance can be increased. \
This graph distance is taken to be the pseudo diameter."
}], "Text",
 CellID->64119438],

Cell["\<\
If the graph is disconnected, then the diameter and vertices for each \
connected component are returned.\
\>", "Text",
 CellID->2861],

Cell["This shows that a Pentagon graph has a diameter of 2.", "MathCaption",
 CellID->74951448],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "->", "2"}], ",", 
     RowBox[{"2", "->", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1393839371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"pseudodiameter", ",", "vertices"}], "}"}], "}"}], "=", 
  RowBox[{"PseudoDiameter", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->205289293],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"2", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1471525678]
}, Open  ]],

Cell["\<\
This is a plot showing the graph with the two vertices of the pseudo-diameter \
highlighted in red.\
\>", "MathCaption",
 CellID->20600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"vertices", ",", "#2"}], "]"}], ",", "Red", ",", "Green"}],
          "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".05"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->6617],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{1.2893252649071054`, 1.5485600106322983`}, {
      1.617753747939871, 0.6043445040754697}, {0.8211445524089258, 0.}, {0., 
      0.5703652293375701}, {0.2886834314367773, 1.5275030724879717`}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 1}}]}], {
      {RGBColor[1, 0, 0], 
       DiskBox[{1.2893252649071054`, 1.5485600106322983`}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{1.617753747939871, 0.6043445040754697}, 0.05]}, 
      {RGBColor[1, 0, 0], DiskBox[{0.8211445524089258, 0.}, 0.05]}, 
      {RGBColor[0, 1, 0], DiskBox[{0., 0.5703652293375701}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{0.2886834314367773, 1.5275030724879717`}, 0.05]}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2893252649071054`, 1.5485600106322983`}, {
     1.617753747939871, 0.6043445040754697}, {0.8211445524089258, 0.}, {0., 
     0.5703652293375701}, {0.2886834314367773, 1.5275030724879717`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->218279897]
}, Open  ]],

Cell["This defines a grid graph and finds its pseudo diameter.", "MathCaption",
 CellID->643263048],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"GridGraph", "[", 
    RowBox[{"5", ",", "5"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->1815863831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"pseudodiameter", ",", " ", "vertices"}], "}"}], "}"}], " ", "=", 
  " ", 
  RowBox[{"PseudoDiameter", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1384662509],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"8", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "25"}], "}"}]}], "}"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->761540458]
}, Open  ]],

Cell["\<\
This finds the graph geodesic between vertices 1 and 25, and highlights the \
graph geodesic in red.\
\>", "MathCaption",
 CellID->2421],

Cell[BoxData[
 RowBox[{
  RowBox[{"path", "=", 
   RowBox[{"GraphPath", "[", 
    RowBox[{"g", ",", "1", ",", "25"}], "]"}]}], ";", 
  RowBox[{"edges", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Drop", "[", 
       RowBox[{"path", ",", 
        RowBox[{"-", "1"}]}], "]"}], ",", 
      RowBox[{"Drop", "[", 
       RowBox[{"path", ",", "1"}], "]"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->599761383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"vertices", ",", "#2"}], "]"}], ",", "Red", ",", 
           "Green"}], "]"}], "]"}], ",", "White", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{"edges", ",", "#2"}], "]"}], "||", 
         RowBox[{"MemberQ", "[", 
          RowBox[{"edges", ",", 
           RowBox[{"Reverse", "[", "#2", "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
          RowBox[{"Line", "[", "#", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"Line", "[", "#", "]"}]}], "}"}]}], "]"}], "&"}], ")"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->1770532779],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->133808072]
}, Open  ]],

Cell["\<\
This defines a disconnected graph, and finds the pseudo diameters for each \
component.\
\>", "MathCaption",
 CellTags->"b:0.5",
 CellID->2089666341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "1"}], ",", 
    RowBox[{"4", "\[Rule]", "5"}], ",", 
    RowBox[{"5", "\[Rule]", "6"}], ",", 
    RowBox[{"6", "\[Rule]", "7"}]}], "}"}]}]], "Input",
 CellLabel->"In[20]:=",
 CellID->1196580261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"3", "\[Rule]", "1"}], ",", 
   RowBox[{"4", "\[Rule]", "5"}], ",", 
   RowBox[{"5", "\[Rule]", "6"}], ",", 
   RowBox[{"6", "\[Rule]", "7"}]}], "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->2032949408]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->1196347861],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtMU1EQvfJQI8X4C/GDQlEXLFmyZKVsTHRnjAtQ1BJjRMD/B5SFC+M3
GP9K1KjxE4kh4sJo4kIWkLDQSNQiKkiFVktbXh+01jozr3Dvu/T1NVIjBkm5
zNw5d+bcub8pq0qrHZu2lVaXbyy1r6wsrXCUb6yyr9heCV3KFMZYE/yuW8BA
joJEv03RKPzNwFYJ+VuCfTc0zwNmw0YJ9l0JB9+hKZfsmvu+5rkn2F0XoxGV
21XXJegXx1+P0g/LIXsk7FFdF7hdc98Z+t6MpgyBhdp7ZLCnRvPUI6qeKYFP
lUPepzyKr3NLsO84t/ucZZGQW4gSeuZzbuJ2APucW/n4YW9D4FMVt0Mw9csJ
mUXw69HhAaDfxmzY6PoL7sX/YSsE4nbSjSygi9tJ3yGwGLgOLrmd9Iv/Wfw7
LNIJhWco2sZ1c1Zp0CB8mgU7BZq0UZw5S0WKP/WPsJ4q4RUL9mnklONZzEOq
54Fx0ke9Q//dNctqQc/FJhn+J7IzEZpD+KT4f362hkfg/ONnNBn+I6PY6Gr/
zXX4vXkYd6s5fyMuMW9+Sv4m27F7MvGZHYs3Z2+2Oqk+vemx+VrxN+ISn1Ul
abYT457+z0L9UjOmovr2mHvxOTePqaiGXQYW0CVVVOV8/JD3Krg0VFSDPcdk
FuHgI8192uAFCkJxLg3QL9j7sSjjLGCCmucsmjLJrpeOgj3yUusXZqF5zoQC
rZxF07jb5KrksPo6rL6BD7NhA/i2GM9ycU2sqlxnWeDzzsHuPcyGjeJ7vyG2
JqKX399fk8WL8T1JXJ2lx7kp43uN/xon956w8UcxqXXivw5WUZJ9E60qkPje
U11vpmY9zN7fVO0ms2pn4p+X8Xixemf8nY6Q71ZYbcSbsRH1LXG8WL0Tam/d
YPduvBQz6WbU/wWBJgd5mU+ojocP76xejWIe6QGX65TdHtY0totQC6gXIABE
0U76/bVrX92+jaKIcrW3Xy4sxLE6g+6WFtBR3E2ohdT7pKKi5eTJ6Oh7dL6g
AAbKKOABBmjZEtJbz51rchDxPYRaRL3gCNyhmK3nRNOAPY7aK6CgF3hAkBiK
M9BR2VImdAbujg5ggLPZR6jFUibkzIgongk5y/sJtUTikTXCEyJCXHZAQGle
b31+Ps4pS5qzjsqReudJ63iQULlSrueS3lhS0n7tGooi6n1z883iYhTnjMwG
BqJ4iFB2aeazJd8iimdxFukQDoKiWEOoPCkTM6V1rBVQPBMzpVE6aqmUCRvp
3q4uGIUMDhNqmcQ2Q5qNiOp6/ryhqAjFGVJmjhBquTR2urTf6gQU5zFd4lkn
sPd3bh54ux4+zIYN1DMlP/Wzf1hEmd4zEwVl/AZkhbZ6kSfXKLNXcaKsbSJU
4ON2w/71O8t+/hjgKP0bApvyCy22tGA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->791292]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PseudoDiameter", "[", "g", "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->987874085],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "7"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->1871057773]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options for PseudoDiameter", "Subsubsection",
 CellTags->"b:0.10b",
 CellID->1801023034],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Aggressive",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Aggressive"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to make extra effort in finding the optimal graph diameter\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.10b",
 CellID->771295471],

Cell[TextData[{
 "Options for ",
 StyleBox[ButtonBox["PseudoDiameter",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/PseudoDiameter"], "MR"],
 StyleBox[".", "MR"]
}], "Caption",
 CellTags->"b:0.10b",
 CellID->1406539800],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["Aggressive",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/Aggressive"]], "InlineFormula"],
 " specifies whether to make extra effort in finding the optimal graph \
diameter. Possible values are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " (the default). With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Aggressive",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/Aggressive"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", a traversal is carried out from each vertex in the last level set. This \
can give larger pseudo diameter on occasions."
}], "Text",
 CellID->522526817],

Cell[TextData[{
 "This finds the average pseudo diameter of random graphs represented by \
sparse matrices of dimension 100\[Times]100 with 4% nonzeros, with the ",
 Cell[BoxData[
  ButtonBox["Aggressive",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/Aggressive"]], "InlineFormula"],
 " option set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". The largest pseudo diameter is chosen if there is more than one \
component."
}], "MathCaption",
 CellID->69573764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Mean", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"m", "=", 
        RowBox[{"SparseArray", "[", 
         RowBox[{"Floor", "[", 
          RowBox[{"RandomReal", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}], "+", ".04"}], ",", 
            RowBox[{"{", 
             RowBox[{"100", ",", "100"}], "}"}]}], "]"}], "]"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Max", "[", 
          RowBox[{
           RowBox[{"Transpose", "[", 
            RowBox[{"PseudoDiameter", "[", "m", "]"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
         RowBox[{"Max", "[", 
          RowBox[{
           RowBox[{"Transpose", "[", 
            RowBox[{"PseudoDiameter", "[", 
             RowBox[{"m", ",", 
              RowBox[{"Aggressive", "\[Rule]", "True"}]}], "]"}], "]"}], "[", 
           
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", "100", "}"}]}], "]"}], "]"}], "//", "N"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->1880103238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.3`", ",", "4.32`"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->1105857454]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StrongComponents, WeakComponents", "Subsection",
 CellTags->{"i:11", "b:0.9"},
 CellID->270763112],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StrongComponents",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/StrongComponents"], 
     StyleBox["[", "MR"], 
     StyleBox["g", "TI"], 
     StyleBox["]", "MR"]}], Cell["\<\
returns a list of all strongly connected components in a directed graph\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["WeakComponents",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/WeakComponents"], "[", 
     StyleBox["g", "TI"], "]"}], 
    RowBox[{
     StyleBox["returns", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["a", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["list", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["of", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["all", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["weakly", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["connected", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["components", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["in", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["the", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["undirected", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["graph", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["g", "TI"]}]}
  }]], "DefinitionBox",
 CellTags->"b:0.9",
 CellID->474215926],

Cell["Finding strongly connected components.", "Caption",
 CellTags->"b:0.9",
 CellID->118792592],

Cell["\<\
A strongly connected component in a directed graph is a set of vertices such \
that there is a path between any two nodes in the set.\
\>", "Text",
 CellTags->"b:0.9",
 CellID->279365717],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StrongComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/StrongComponents"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 " returns a list of all strongly connected components in the directed graph \
g. "
}], "Text",
 CellTags->"b:0.9",
 CellID->3463340],

Cell[TextData[{
 "A weakly connected component of a directed graph is a set of vertices such \
that for each pair of vertices, there is a path between them. The graph ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is considered as undirected."
}], "Text",
 CellID->31150],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WeakComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/WeakComponents"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 " returns a list of all weakly connected components in the undirected graph \
g. "
}], "Text",
 CellID->24427726],

Cell["This shows a simple directed graph.", "Text",
 CellTags->"b:0.9",
 CellID->814501527],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "3"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}], ",", 
     RowBox[{"7", "\[Rule]", "5"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[44]:=",
 CellID->1026276196],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.4604452762449824}, {0.8337097254613702, 
    0.0545628067828256}, {0.8331246739490872, 0.8658215957871405}, {
    1.9892773560607682`, 0.}, {1.9882014879641083`, 0.9211907141554811}, {
    3.06333916673331, 0.015605260302768265`}, {3.061836178318085, 
    0.9059227473706353}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028686724125180238`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{2, 3}], ArrowBox[{2, 4}], 
      ArrowBox[{4, 5}], ArrowBox[{5, 3}], ArrowBox[{6, 7}], ArrowBox[{6, 4}], 
      ArrowBox[{7, 5}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.4604452762449824}, {0.8337097254613702, 
     0.0545628067828256}, {0.8331246739490872, 0.8658215957871405}, {
     1.9892773560607682`, 0.}, {1.9882014879641083`, 0.9211907141554811}, {
     3.06333916673331, 0.015605260302768265`}, {3.061836178318085, 
     0.9059227473706353}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->253290890]
}, Open  ]],

Cell["\<\
This shows that there are no strongly connected components of the graph \
consisting of more than just one vertex.\
\>", "Text",
 CellTags->"b:0.9",
 CellID->297519026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StrongComponents", "[", "g", "]"}]], "Input",
 CellTags->"b:0.9",
 CellLabel->"In[46]:=",
 CellID->83599705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "7", "}"}], ",", 
   RowBox[{"{", "6", "}"}]}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellLabel->"Out[46]=",
 CellID->1812808428]
}, Open  ]],

Cell[TextData[{
 "If an edge from 3 to 2 is added, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"2", ",", " ", "3", ",", " ", "4", ",", " ", "5"}], "}"}], 
   TraditionalForm]]],
 " becomes a strongly connected component."
}], "Text",
 CellTags->"b:0.9",
 CellID->143584978],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Append", "[", 
    RowBox[{"g", ",", 
     RowBox[{"3", "\[Rule]", "2"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g2", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellTags->"b:0.9",
 CellLabel->"In[50]:=",
 CellID->138950330],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellLabel->"Out[51]=",
 CellID->157336271]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StrongComponents", "[", "g2", "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->497994166],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "7", "}"}], ",", 
   RowBox[{"{", "6", "}"}]}], "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->90811278]
}, Open  ]],

Cell["Both graphs are weakly connected.", "Text",
 CellID->1805813009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeakComponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->1723893864],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
   "}"}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->334024673]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeakComponents", "[", "g2", "]"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->933409718],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
   "}"}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]=",
 CellID->536308895]
}, Open  ]],

Cell["This defines a disconnected graph.", "Text",
 CellID->767519722],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->698606370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[56]:=",
 CellID->1031731725],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.1792466550471676`, -1.4055327732752103`}, {
    0.17924665504716766`, -1.405532773185417}, {
    0.6761727395742755, -0.17924665504716764`}, {
    1.1792403276681436`, -1.0434938383787922`}, {
    0.17924665504716772`, -1.0470394630910818`}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03946501925492895, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{3, 4}], ArrowBox[{4, 5}], 
      ArrowBox[{5, 3}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.1792466550471676`, -1.4055327732752103`}, {
     0.17924665504716766`, -1.405532773185417}, {
     0.6761727395742755, -0.17924665504716764`}, {
     1.1792403276681436`, -1.0434938383787922`}, {
     0.17924665504716772`, -1.0470394630910818`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[56]=",
 CellID->452606758]
}, Open  ]],

Cell["This graph has two weakly connected components.", "Text",
 CellID->1740837411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeakComponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[57]:=",
 CellID->187031944],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[57]=",
 CellID->858264253]
}, Open  ]],

Cell["This finds the strongly connected components.", "Text",
 CellID->1521858659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StrongComponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[58]:=",
 CellID->1213011576],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[58]=",
 CellID->1343042300]
}, Open  ]],

Cell[CellGroupData[{

Cell["Applications", "Subsubsection",
 CellTags->"b:0.9",
 CellID->121306228],

Cell[CellGroupData[{

Cell["\<\
Finding the number of connected components in an undirected graph\
\>", "Subsubsubsection",
 CellTags->"b:0.9",
 CellID->583156197],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StrongComponents",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/StrongComponents"]], 
  "InlineFormula"],
 " can be used to work out how many connected components there are in an \
undirected graph."
}], "Text",
 CellTags->"b:0.9",
 CellID->34775316],

Cell["\<\
This shows a symmetric matrix representing a disconnected graph.\
\>", "Text",
 CellTags->"b:0.9",
 CellID->769190340],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}], "}"}]}],
   ";"}], "\n", 
 RowBox[{"a", "//", "MatrixForm"}]}], "Input",
 CellTags->"b:0.9",
 CellID->118136853],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "1", "0", "0"},
     {"1", "1", "1", "0", "0"},
     {"1", "1", "1", "0", "0"},
     {"0", "0", "0", "1", "1"},
     {"0", "0", "0", "1", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
      "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellID->331904439]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "a", "]"}]], "Input",
 CellTags->"b:0.9",
 CellID->8365528],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{0.0103833845649366, 0.692913789735141}, {
   0.494727404790218, 1.56779160979672}, {-0.505110789355155, 
   1.54980675696471}, {1.77017071883219, 1.27017071878729}, {
   0.770170718832188, 
   1.27017071887709}}, {{LineBox[{1, 2}], LineBox[{1, 3}], LineBox[{2, 3}], 
     LineBox[{4, 5}]}, {PointBox[1], PointBox[2], PointBox[3], PointBox[4], 
     PointBox[5]}}],
  AspectRatio->Automatic,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{Automatic, Automatic},
  PlotRange->All]], "Output",
 ImageSize->{364, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellID->21477522]
}, Open  ]],

Cell["This shows that the graph has 2 disconnected components.", "Text",
 CellTags->"b:0.9",
 CellID->552833780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StrongComponents", "[", "a", "]"}]], "Input",
 CellTags->"b:0.9",
 CellID->8895882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellID->159390595]
}, Open  ]],

Cell[TextData[{
 "A graph specified as a rule list can be first symmetrized, and then its \
connected components can be found using ",
 Cell[BoxData[
  ButtonBox["StrongComponents",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/StrongComponents"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.9",
 CellID->116881540],

Cell["\<\
This specifies a graph using a rule list and plots it as an undirected graph.\
\
\>", "Text",
 CellTags->"b:0.9",
 CellID->150444139],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h", 
    ",", "j", ",", "k"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "b"}], ",", 
     RowBox[{"b", "\[Rule]", "c"}], ",", 
     RowBox[{"c", "\[Rule]", "d"}], ",", 
     RowBox[{"d", "\[Rule]", "a"}], ",", 
     RowBox[{"f", "\[Rule]", "h"}], ",", 
     RowBox[{"h", "\[Rule]", "j"}], ",", 
     RowBox[{"h", "\[Rule]", "k"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexStyleFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"RGBColor", "[", 
         RowBox[{".7", ",", ".9", ",", "1"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"VertexName", "[", "#", "]"}], ",", "#"}], "]"}]}], "}"}], 
      "&"}], ")"}]}]}], "]"}]}], "Input",
 CellID->81094529],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1.94440829276666, 1.95441666071853}, {2.94411608306018,
    1.94570351050866}, {2.9558983074031, 2.94537558183042}, {1.95557731688411,
    2.95450424705645}, {-0.866025403747025, 2.95000000011924}, {
   2.77555756156289*^-17, 2.45000000005443}, {-1.34689748747642*^-10, 
   1.45000000005443}, {0.866025403881715, 
   2.94999999988595}}, {{LineBox[{1, 2}], LineBox[{2, 3}], LineBox[{3, 4}], 
     LineBox[{4, 1}], LineBox[{5, 6}], LineBox[{6, 7}], LineBox[{6, 8}]}, {
     {RGBColor[0.7, 0.9, 1], EdgeForm[GrayLevel[0]], DiskBox[1, 0.1], 
      {GrayLevel[0], InsetBox["a", 1]}}, 
     {RGBColor[0.7, 0.9, 1], EdgeForm[GrayLevel[0]], DiskBox[2, 0.1], 
      {GrayLevel[0], InsetBox["b", 2]}}, 
     {RGBColor[0.7, 0.9, 1], EdgeForm[GrayLevel[0]], DiskBox[3, 0.1], 
      {GrayLevel[0], InsetBox["c", 3]}}, 
     {RGBColor[0.7, 0.9, 1], EdgeForm[GrayLevel[0]], DiskBox[4, 0.1], 
      {GrayLevel[0], InsetBox["d", 4]}}, 
     {RGBColor[0.7, 0.9, 1], EdgeForm[GrayLevel[0]], DiskBox[5, 0.1], 
      {GrayLevel[0], InsetBox["f", 5]}}, 
     {RGBColor[0.7, 0.9, 1], EdgeForm[GrayLevel[0]], DiskBox[6, 0.1], 
      {GrayLevel[0], InsetBox["h", 6]}}, 
     {RGBColor[0.7, 0.9, 1], EdgeForm[GrayLevel[0]], DiskBox[7, 0.1], 
      {GrayLevel[0], InsetBox["j", 7]}}, 
     {RGBColor[0.7, 0.9, 1], EdgeForm[GrayLevel[0]], DiskBox[8, 0.1], 
      {GrayLevel[0], InsetBox["k", 8]}}}}],
  AspectRatio->Automatic,
  ImageMargins->0.,
  ImageSize->Automatic,
  PlotRange->All]], "Output",
 ImageSize->{364, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->16131470]
}, Open  ]],

Cell["\<\
This symmetrizes the graph to make it undirected, then finds the two \
connected components of the undirected graph.\
\>", "Text",
 CellTags->"b:0.9",
 CellID->51544394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StrongComponents", "[", 
  RowBox[{"Join", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Map", "[", 
     RowBox[{"Reverse", ",", "g"}], "]"}]}], "]"}], "]"}]], "Input",
 CellID->901567],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "h", ",", "j", ",", "k"}], "}"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->572211481]
}, Open  ]],

Cell[TextData[{
 "This shows how the number of components changes with the average degree of \
the graph for an undirected graph with 100 vertices. ",
 Cell[BoxData["RandomSymmetricSparseMatrix"], "InlineFormula"],
 " was defined earlier."
}], "Text",
 CellTags->"b:0.9",
 CellID->6582764],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "100"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nrepeat", " ", "=", " ", "100"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "123", "]"}], ";"}], "\n", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ncomp", " ", "=", " ", "0."}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "=", 
        RowBox[{"RandomSymmetricSparseMatrix", "[", 
         RowBox[{"n", ",", "deg", ",", "False"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"ncomp", " ", "+=", " ", 
        RowBox[{"Length", "[", 
         RowBox[{"StrongComponents", "[", "a", "]"}], "]"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", "nrepeat", "}"}]}], "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"res", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"res", ",", 
       RowBox[{"{", 
        RowBox[{"deg", ",", 
         RowBox[{"ncomp", "/", "nrepeat"}]}], "}"}]}], "}"}]}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"deg", ",", "1", ",", "10"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}], "\n", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", "res", "]"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<average degree\>\"", ",", "\"\<Avg. num. of components\>\""}], 
     "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "50"}], "}"}]}], "}"}]}]}], "]"}]}], "Input",
 CellTags->"b:0.9",
 CellID->121533968],

Cell[BoxData[
 GraphicsBox[{{}, 
   LineBox[{{1., 51.17}, {2., 17.11}, {3., 6.06}, {4., 2.68}, {5., 1.58}, {6.,
     1.28}, {7., 1.07}, {8., 1.06}, {9., 1.01}, {10., 1.}}]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  AxesLabel->{
    FormBox["\"average degree\"", StandardForm], 
    FormBox["\"Avg. num. of components\"", StandardForm]},
  ImageMargins->0.,
  ImageSize->{Automatic, Automatic},
  PlotRange->{{0, 10}, {0, 50}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{364, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellID->276364028]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ordering a matrix into block triangular form", "Subsubsubsection",
 CellTags->"b:0.9",
 CellID->85560365],

Cell[TextData[{
 "The output from ",
 Cell[BoxData[
  ButtonBox["StrongComponents",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/StrongComponents"]], 
  "InlineFormula"],
 " can also be used to reorder a matrix into block triangular form."
}], "Text",
 CellTags->"b:0.9",
 CellID->278105924],

Cell[TextData[{
 "This generates a random directed graph of dimensions 100 \[Times] 100, with \
average degree 2. The ",
 Cell[BoxData["RandomSparseMatrix"], "InlineFormula"],
 " function was defined earlier."
}], "Text",
 CellTags->"b:0.9",
 CellID->251916138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", " ", "=", " ", "100"}], ";", 
  RowBox[{"SeedRandom", "[", "12345", "]"}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"RandomSparseMatrix", "[", 
    RowBox[{"n", ",", "n", ",", "2.75", ",", "False"}], "]"}]}]}]], "Input",
 CellTags->"b:0.9",
 CellID->43208183],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "275", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 275, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellID->423561855]
}, Open  ]],

Cell["This displays the matrix.", "Text",
 CellTags->"b:0.9",
 CellID->437094615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"a", ",", 
   RowBox[{"ColorRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "\[Rule]", "White"}], ",", 
      RowBox[{"0.", "\[Rule]", "White"}], ",", 
      RowBox[{"_", "\[Rule]", "Black"}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"b:0.9",
 CellID->47988465],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlW9uLTVEYP9Ng5JprIzQat1xGcmmEyGXcIqFGiOYY08y4GzwQScoDKQ9K
IokoT8iLiHgRRWreKDX/Av/A53zj92vtdVrtF3uv850xddZv1vp+356996z1
3dY624pnujqOFc90txenbewpnuzqbj89bcOJntJQbU2hUNNV+nTWF0q/S6Hw
96NNd6H/p7a/rz/90FH61BiU3Ck12v0UWToD0m/AuhIOKmFbdPYrsKYDr+TO
Wgfp1hLWAbV/wTh7HKRj8D6fAVsx3lRxLW1irJrzifemd7UcuCc6+wHY18pm
3ijj7El4qudg3cqdFWtuHMXd1OJu3knajM2TTTuonVW5MTaIm5+Kw6Dx3Dj7
tPjegevscXT2bkiboPXdCOsjpNvB3pQ7i1Zf57f6o1lgN2N8M3AWsJh4z//z
1RZAWzuLc2NwVncBhwPboDmmSrVmQ9oIvAStltS5GlNrKlg/gQ1gr4nO/iou
OuF9W2B14K7rwXopzgcoTq641mhI34vvpbjCwyvbvhbX3Frx475BwCnA/ea0
J4qLbbZWkMG4RTvhuZMFgz6/TlxUpJ4nbHHssC+CPV78VfY2OpvrQzs7c2Ms
wlu5AeZOSfMMdtiM8O5mLj0gvr29gP4qcTFSNWoxFtDO8twY+8ru6aoR1jxx
uSuHwx4mDyZtEPMRZtThXNEOexlYE8DqRX+mpEW4MbWY2TBeYwWPtvUw8Lg5
7W7xc9Rwth6fpc1SMCckMA6Ta2oT7pFVNq6x9JVoV+se2Kwsh2dzlqzr4uf4
58RlXJbZP8SP18pXVaM4L8dx21dhTP6l7CqdxtnaLABzSa6MbCvlrCKHK8hx
GAch3QWcK27OJ2O1enPaJ8W3Z/XQYv9slWqtFOetk965FthWca0d0GoWP75/
bZxNjzinbH5x/vVUXGso2CPFeUzFIcA+8e14uKYx8K7yRlyEmrQU4RgmTzbP
BtwVP1YI11/zZG8RP0ppScwwy+zV4q/VQ+jfj87m3LwJfChp8Z4dNusqR8S3
MS1mtEaIH7dxbWnuPKTwN8LS8fDpjerV/gzpeuD23FnarAYjWa+1xuR7HSV+
xHFK/MyF8yxsfS1dZTCk3IPeL87DaT98yi2mFq3KfHFWMPl8RPrecAV74F1F
m+xPNjHCo4VsQJ+7bWEvXr3aPF/2WvzIdhKQOUS46lNJbW0YnzdXmMEMLLwX
kgWDtuMJ8KUR1mVIFyb+V4q3o7O1yc4ePMLfCu+W5id9gWcO75D8i5Rnb3lu
75KkxUB22KwOsALOusteSVuVMbV4PqEz9f1XjqWd/M5ecKeFGbcYYbFu9ytz
qTaMPnnWLf0cUQwN7g8m94cbDDL5VLfwVHw61paY9S8Bpp+1t3w1xjf8rg73
ccL7H3bY2mTnSVl7YHz6wQiLUZ12wnY9Cwb3wJaJn9ucAK4Atg4w7WznECPB
vsylPAfCXEMHGw0y6ZF4+qNVXJ1GMXw+KqYWIwXW2p4aYTHaHAvszZ3Fc2uT
gS1Vwv6deJ/ZSmlLGsRlcIo9GA/vDdvX0sbSt58T39Gu+QPABaPS\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellID->329523696]
}, Open  ]],

Cell["This finds the strongly connected vertices.", "Text",
 CellTags->"b:0.9",
 CellID->157877045],

Cell[BoxData[
 RowBox[{
  RowBox[{"perm", " ", "=", " ", 
   RowBox[{"StrongComponents", "[", "a", "]"}]}], ";"}]], "Input",
 CellTags->"b:0.9",
 CellID->497154951],

Cell["\<\
This orders the matrix by symmetrically permuting its rows and columns with \
the list of strongly connected vertices. The reordered matrix is shown.\
\>", "Text",
 CellTags->"b:0.9",
 CellID->74443306],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"perm2", " ", "=", " ", 
   RowBox[{"Flatten", "[", "perm", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"a", "[", 
    RowBox[{"[", 
     RowBox[{"perm2", ",", "perm2"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"b", ",", 
   RowBox[{"ColorRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "\[Rule]", "White"}], ",", 
      RowBox[{"0.", "\[Rule]", "White"}], ",", 
      RowBox[{"_", "\[Rule]", "Black"}]}], "}"}]}]}], "]"}]}], "Input",
 CellTags->"b:0.9",
 CellID->188431946],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm89LVUEUx588xTAzLI0nJYr0AwtDy1AsFAPNfiH9oHAR9FJR6Zc8dVEU
EYEEIRUIEkKLIMLoJ+5qVbSLflCrdrXtD2h7uqPfL3fua7qre+fOi4Q3x3nn
c8Y7987MOWfmejg7OTp8Pjs5Npit35fLjo+ODU7U917MeV+li1KpolHvM5JJ
eb9LKrX8UcVYauknvVRXP0ti2PsUOag54BWsZhIkznlFsVdtBPkK9TLr9Gto
H0aufaT9fZvajdDW4eqeQ45Yp1dA+w1WVxyhzkC725OlnuxBfco6Xa7RSs7i
+g9CNheo1U3Q7H0r6AHr9DNQlyA3QJrXJXfoLvTqDuRM7NRaXM+IBOe2+QnH
SfdCqyrrEyRKcNULkKUStt7HSfP+TYHaCXnfcXocdAOo97FTH0D1gepzhOLz
LoZUI1/5h/2od8OavTsKWVlwrXGEfNJGtpLHYGWea+5bMarlun0WsjP0udu0
2gaqWoKR72nr9Fdo6aN7HKHqQfF+PtBGAEd4slbt4q+nSvZLMOI2zzn3rRiZ
c65x7nHN4bg65Zz1HmhVZXOCBP1fGr2Zl+VV2rwWxEnfAlUlfmat1C8cpzly
VaUxNuKIBCMkZkrmexknzchk1rK2Vnx/quQayBzkUOJWq3HfPkJec4zq0EZZ
lTWSqwDjPa4G5pzEHfqk+J5HyUUJeiRzPGfTirsozH/LNKm+z4of5/1L1pfF
j8b+niVGSamiBUSF9mzskIflz6xYyU3aqClEq8fQzknYKI+Suof73KKNLyXN
sZE79A8JxpocL4z667Txo2S1860wMn2a14rZs7pDq4JZa1usBDO97gQJ5jir
IAcgGQdltO/dsr4OaiskPSvP73KJW/HUqxWSZyH0febx574VfUFdnjV3Mi8k
brUOVA0kow/me28kGH2Z91T+vVbeQjsEmjuzZu8dJ83zzhugmsWP0lymh/N6
2Sl+HmmXZn7GXJ6R9pzj9A70insRMxIWF8VJT0B7CvRmCa6CyVttkWDWNArJ
k5YmCfOQhWv9WfwZoKj+2ClVcI+uUsLi2mTJXdCuFD+61OdcOm+cmVdfl1rZ
Dm2f+KudktyRM7+L474V1yL6wWkJZlXcm2rQWne7lavQtom/ZjETVzIjYZ6z
cK1r8u7OPGiec2e01tyyVgVX4o7YCM6PaVzTgiPUbWibIJn337VOv4TWfL4U
n5bvvHGe5yTM68ZJ8+1aniZw37A/dGS5b8V3YBZBhb+1FQV1XIKZ3k9HKO6R
fI9cq4py7Rr0azHHFDYsSDMaEEcoRmX574tWoDfcMWjK05vfJ3W5tS7QTyQY
h5p3rdyhmQu2iz/f46W4i6Yq5jNcOwR3CrhvyixwEJK7eyecs6a//2JZy3Nj
Rujqy7Q1kuvyXkj6Qvr8zsStGIVwR/6dIxR9eX5v7NO/QJlP2uPTMnOpk2Cm
ck382D1ZK+6pq8qhBAlVRPe/eiXa3zO/mWiHqNUIc14dBRHtvfuvsadRI6gU
VXPOaIeIvlcuzL7kn29Qo/3Pc9Fvol9oDg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellID->68727014]
}, Open  ]],

Cell["\<\
The reordered matrix is block triangular, with one big block. The other \
components are single vertices.\
\>", "Text",
 CellTags->"b:0.9",
 CellID->584841589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Length", ",", 
   RowBox[{"StrongComponents", "[", "b", "]"}]}], "]"}]], "Input",
 CellTags->"b:0.9",
 CellID->54429004],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "85", ",", "1", ",", "1", ",",
    "1"}], "}"}]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellID->319681624]
}, Open  ]],

Cell[TextData[{
 "To make the matrix block triangular with as many nonzero entries on the \
diagonal as possible, first use ",
 Cell[BoxData[
  ButtonBox["MaximalBipartiteMatching",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalBipartiteMatching"]], 
  "InlineFormula"],
 " to permute entries to the diagonal, and then use ",
 Cell[BoxData[
  ButtonBox["StrongComponents",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/StrongComponents"]], 
  "InlineFormula"],
 " to find the strongly connected components."
}], "Text",
 CellTags->"b:0.9",
 CellID->833160917],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", " ", "=", " ", 
   RowBox[{"MaximalBipartiteMatching", "[", "a", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ind", "\[Rule]", 
       RowBox[{"Table", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"Length", "[", "ind", "]"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Transpose", "[", "p", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", " ", "=", " ", 
   RowBox[{"p", ".", "a"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"perm", " ", "=", " ", 
   RowBox[{"StrongComponents", "[", "b", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"perm2", " ", "=", " ", 
   RowBox[{"Flatten", "[", "perm", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"b", "[", 
    RowBox[{"[", 
     RowBox[{"perm2", ",", "perm2"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"ColorRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "\[Rule]", "White"}], ",", 
      RowBox[{"0.", "\[Rule]", "White"}], ",", 
      RowBox[{"_", "\[Rule]", "Black"}]}], "}"}]}]}], "]"}]}], "Input",
 CellTags->"b:0.9",
 CellID->443104622],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdm99LVEEUx1fWMrYyJAqlYsWi6IfRTwwLwUyTMqIfJBFGW4na79LCh0LD
iBIkAkEi6CGQKHoLeigqgh6K3nrr/4ggejjdo98vd+4yLT3cO3e2hTtnz87n
3J2dX2fuzNkDhaH+3ouFoYEzhfq91wpX+gfODNZ3XL4WfJStyGQq+oOrrzYT
vJdMZvbSZCAz88rO6PqaEb3BVeFhzpYgoboa76s8JDXpDq7K4KNcYkQHcpsh
pyA3oWzVqVs9Q+406BpPqHlBUhWoo6AbQE9CX5K6lSYuRtRGlGYPZA9K2wd9
WepWi5C7FfIHrPKe07vQvi2gj0OegmxI3eo0rHZDPoRc7TmtSb2E41vbYK0z
co6EXqAR7xudkbdQxjFQayWch32mzfrNwWKbM5L9630gc4Fs8oTiuN0MmcWv
OVJUp5TN3t9FExd+awVKlUdpvsvsmG11TmtCi/aUifjqdzG+axPqYBr6Ssiu
1K3akPsZrXPQEyredvggoWfUeeSYJ9RbtFWThOt/rjzc0myVCVD0nz2e03dA
DUu4VkuW2l5Un6+gn/Wc/gWqL/bcn/je87HnDkq4HtHvr5VwTtNRdalMrTSJ
b3brxXfvl3DtqDPrdc/pkxKufZUaTpx6gNapAd0C/abnNJ/5r0p0/2gkNfpc
UbnHPKcfSfTZ/m7i1DyJepMNkNUSztoqx72zviLhvoHKJlhPeE7vA1WQ8MnD
9I/2Hu3S6gVySU96Qn0Blf2nX5EkvQqUnghUgaqErp9XQj7+z6wHjNpR2Q7r
J87pOonOFdy52An5tEytuDvYBTlfQg+s7dWIuy6E5AmDvZ/6fLcbEvWI7Hn2
ekmSXgP6vkTHgu8017GdoOqk1OyZJM1y14C6LFGPaPfg/lvdNijTmuthu4d3
acVZZhz0cik1f/tD30NuLazeJU7R850tqt+8RMeavYeXrzVPMjmnZIvu8jx1
K0Y+0F9wd4JrsNepW7Fv80mFu32lR0L6NE8R+ETCXdYuKeWZXVotADUq0fmY
fdv+1Oq/1SGjNnRt9C1xiuXskWjP5jz8pkytjkp0DUf/mENtfE3dip6b/ueT
J1S9RGfhw5A81V0GOeWdNfer2Q6cnRv+0j4j3t+FTyQ897T7GfeUuR+gFPfg
6LEZIcBVaB66ff+yHO6mMXhVRs/kfN4K/eV/Zn3B6Af68cfEKU1cxIVwtuaI
/J04xUgfcZzLcyNVsokRJ4wy2GOd4yC6jXLYY53dEIxE4f7cukDORbY9wtmF
xQGZHeOq2OOZ3RCaxDdSeQ6hSm2KRJvxu+0RyHERVPMpEvG24Q7jd9tjdeMg
uG6sMUh7bG66ZLx16yqHp9GqbE2MWC9hz7THwrohuOerij2CNQ5C+wz7SkuK
xAqD+HusaxwEVXtsahzEUqMcnSkSPPHSky76bXuEahIkVw+q2ONP3RDc1VXl
cGIE/zulij0O1Q0xxyDsUahxEVTtMaNuCE188lbG/1Qr/gDTONKV\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellID->257508985]
}, Open  ]],

Cell["\<\
Now the block is much smaller. The rest of the strongly connected components \
consist of single vertices.\
\>", "Text",
 CellTags->"b:0.9",
 CellID->355664394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Length", ",", 
   RowBox[{"StrongComponents", "[", "f", "]"}]}], "]"}]], "Input",
 CellTags->"b:0.9",
 CellID->23320521],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWFFOwzAMdZsVtiEYAwn43Bk4AfDBxAeHqCak7QOBxq4FVyxxslbIi1jb
ZYrTetLSxLVenGc7jfOab5Zv7/lmtchn83X+uVwtvmbPH2stUglA8g0A93eg
+4XumT/+fvTfdm3vEltVvi1g4nnsG5873j78ccV6CvWf00B65fOKrGJkVjHU
baaFA/L2JJD8VOZlyb+NljGRohbG1iiQPJQ9fZu3iT37o0a+T8fFz8h4KF4I
4AXJBfFCX/DECxzw2nkB25jqmFKffuVsVYZdWh8373GvqG8844WOTFWx7jMS
b2vqHRqJJq96V0kjvtrKlSMfpaL+354UmygqOp/4yAZkldxwAJaLHWnoqjcW
39jdk/tpauqw/u/4gpm9TfHjONOKF7isqjw5oJh6hYN93WPdsLzzlblmZmU3
uT93cq+IVjfy4BgVtdruFgP9nHjEdemfmVXggg6vpJ13DozjlDveo2GV5g1m
P+c7nCen1Xjqj6FSk3nbyR+cXqdaXKsqmbed3O5QKXlLb4dk3282nhd1cklY
FVbD4wmrwmoseJZV19085/P0i7EaTa1Tg0HyC9p4lRE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{429, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.9",
 CellID->828356546]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToCombinatoricaGraph", "Subsection",
 CellID->903426436],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToCombinatoricaGraph",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/ToCombinatoricaGraph"], 
     StyleBox["[", "MR"], 
     StyleBox["g", "TI"], 
     StyleBox["]", "MR"]}], 
    StyleBox[
     RowBox[{
     "returns", " ", "the", " ", "Combinatorica", " ", "representation", " ", 
      "of", " ", "the", " ", "graph", " ", 
      StyleBox["g", "TI"]}],
     FontFamily->"Verdana",
     FontSize->10]},
   {
    RowBox[{
     ButtonBox["ToCombinatoricaGraph",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/ToCombinatoricaGraph"], "[", 
     RowBox[{
      StyleBox["g", "TI"], ",", " ", 
      StyleBox["n", "TI"]}], "]"}], 
    StyleBox[
     RowBox[{
      RowBox[{"returns", " ", "the", " ", "graph", " ", 
       StyleBox["g", "TI"]}], ",", 
      RowBox[{
      "adding", " ", "additional", " ", "unconnected", " ", "vertices"}], ",",
       
      RowBox[{"if", " ", "necessary"}], ",", 
      RowBox[{"to", " ", "create", " ", "a", " ", "graph", " ", "with", " ", 
       StyleBox["n", "TI"], " ", "vertices"}]}],
     FontFamily->"Verdana",
     FontSize->10]}
  }]], "DefinitionBox",
 CellTags->"b:0.9",
 CellID->1436238083],

Cell[TextData[{
 "Converting to a ",
 StyleBox["Combinatorica ",
  FontSlant->"Italic"],
 "graph object."
}], "Caption",
 CellTags->"b:0.9",
 CellID->91508867],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToCombinatoricaGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/ToCombinatoricaGraph"]], 
  "InlineFormula"],
 " converts a graph in any format acceptable by the ",
 ButtonBox["Graph Utilities Package",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/guide/GraphUtilitiesPackage"],
 " to a ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " graph object."
}], "Text",
 CellID->1582146954],

Cell["This defines a simple graph.", "MathCaption",
 CellID->8213],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "2"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "3"}], ",", 
     RowBox[{"8", "\[Rule]", "2"}], ",", 
     RowBox[{"8", "\[Rule]", "3"}], ",", 
     RowBox[{"8", "\[Rule]", "7"}], ",", 
     RowBox[{"9", "\[Rule]", "2"}], ",", 
     RowBox[{"9", "\[Rule]", "4"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[64]:=",
 CellID->23992],

Cell[TextData[{
 "This shows the ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " object."
}], "MathCaption",
 CellID->1368998428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", 
  RowBox[{"ToCombinatoricaGraph", "[", "g", "]"}], "]"}]], "Input",
 CellLabel->"In[65]:=",
 CellID->2670],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.31162398598875557`, 0.3059142160913771}, {
      0.6399575598846841, 0.15254968331002414`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6085276475153217, 0.5134853397267577}, {0.6399575598846841, 
      0.15254968331002414`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6085276475153217, 0.5134853397267577}, {
      0.31162398598875557`, 0.3059142160913771}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.2845960088076271, 0.00015574040196883747`}, {
      0.6399575598846841, 0.15254968331002414`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.2845960088076271, 0.00015574040196883747`}, {
      0.31162398598875557`, 0.3059142160913771}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{1., 0.}, {0.6399575598846841, 0.15254968331002414`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.9187376395012945, 0.2818687956418936}, {0.6399575598846841, 
      0.15254968331002414`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.9187376395012945, 0.2818687956418936}, {0.6085276475153217, 
      0.5134853397267577}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.9187376395012945, 0.2818687956418936}, {1., 0.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.5604736441822937, 0.901206915877094}, {0.6085276475153217, 
      0.5134853397267577}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.35710208591707265`, 0.6896870750402169}, {
      0.31162398598875557`, 0.3059142160913771}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.35710208591707265`, 0.6896870750402169}, {
      0.6085276475153217, 0.5134853397267577}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.35710208591707265`, 0.6896870750402169}, {
      0.5604736441822937, 0.901206915877094}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0., 0.07041988854192892}, {0.31162398598875557`, 
      0.3059142160913771}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0., 0.07041988854192892}, {0.2845960088076271, 
      0.00015574040196883747`}}], 
     {GrayLevel[0]}}}, {
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.31162398598875557`, 0.3059142160913771}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["2", 
       Scaled[{0.02, 0.02}, {0.31162398598875557`, 0.3059142160913771}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.6399575598846841, 0.15254968331002414`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["1", 
       Scaled[{0.02, 0.02}, {0.6399575598846841, 0.15254968331002414`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.6085276475153217, 0.5134853397267577}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["3", 
       Scaled[{0.02, 0.02}, {0.6085276475153217, 0.5134853397267577}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.2845960088076271, 0.00015574040196883747`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["4", 
       Scaled[{0.02, 0.02}, {0.2845960088076271, 0.00015574040196883747`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{1., 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["5", Scaled[{0.02, 0.02}, {1., 0.}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.9187376395012945, 0.2818687956418936}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["6", 
       Scaled[{0.02, 0.02}, {0.9187376395012945, 0.2818687956418936}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.5604736441822937, 0.901206915877094}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["7", 
       Scaled[{0.02, 0.02}, {0.5604736441822937, 0.901206915877094}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.35710208591707265`, 0.6896870750402169}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["8", 
       Scaled[{0.02, 0.02}, {0.35710208591707265`, 0.6896870750402169}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0., 0.07041988854192892}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["9", 
       Scaled[{0.02, 0.02}, {0., 0.07041988854192892}], {-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->1,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->{244., Automatic},
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{-0.05, 1.05}, {-0.05, 0.951206915877094}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{248, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[65]=",
 CellID->174452703]
}, Open  ]],

Cell["\<\
This uses the optional second argument to pad the graph with additional, \
unconnected, vertices.\
\>", "MathCaption",
 CellID->124316864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", 
  RowBox[{"ToCombinatoricaGraph", "[", 
   RowBox[{"g", ",", "12"}], "]"}], "]"}]], "Input",
 CellLabel->"In[66]:=",
 CellID->6704],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.678159291631538, 0.19858443924481267`}, {0.8316671243464767,
       0.12688096779273705`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.8169725024319644, 0.29563145440498545`}, {
      0.8316671243464767, 0.12688096779273705`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.8169725024319644, 0.29563145440498545`}, {0.678159291631538,
       0.19858443924481267`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6655227337842464, 0.055631282245456576`}, {
      0.8316671243464767, 0.12688096779273705`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6655227337842464, 0.055631282245456576`}, {
      0.678159291631538, 0.19858443924481267`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{1., 0.05555846796914389}, {0.8316671243464767, 
      0.12688096779273705`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.9620069044617097, 0.18734233464941216`}, {
      0.8316671243464767, 0.12688096779273705`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.9620069044617097, 0.18734233464941216`}, {
      0.8169725024319644, 0.29563145440498545`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.9620069044617097, 0.18734233464941216`}, {1., 
      0.05555846796914389}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7945055161368993, 0.47690532824441084`}, {
      0.8169725024319644, 0.29563145440498545`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.699421949827444, 0.3780121448340242}, {0.678159291631538, 
      0.19858443924481267`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.699421949827444, 0.3780121448340242}, {0.8169725024319644, 
      0.29563145440498545`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.699421949827444, 0.3780121448340242}, {0.7945055161368993, 
      0.47690532824441084`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.5324637962135547, 0.08848231532910193}, {0.678159291631538, 
      0.19858443924481267`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.5324637962135547, 0.08848231532910193}, {0.6655227337842464,
       0.055631282245456576`}}], 
     {GrayLevel[0]}}}, {
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.678159291631538, 0.19858443924481267`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["2", 
       Scaled[{0.02, 0.02}, {0.678159291631538, 0.19858443924481267`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.8316671243464767, 0.12688096779273705`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["1", 
       Scaled[{0.02, 0.02}, {0.8316671243464767, 0.12688096779273705`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.8169725024319644, 0.29563145440498545`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["3", 
       Scaled[{0.02, 0.02}, {0.8169725024319644, 0.29563145440498545`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.6655227337842464, 0.055631282245456576`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["4", 
       Scaled[{0.02, 0.02}, {0.6655227337842464, 0.055631282245456576`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{1., 0.05555846796914389}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["5", 
       Scaled[{0.02, 0.02}, {1., 0.05555846796914389}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.9620069044617097, 0.18734233464941216`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["6", Scaled[{0.02, 0.02}, 
       {0.9620069044617097, 0.18734233464941216`}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.7945055161368993, 0.47690532824441084`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["7", 
       Scaled[{0.02, 0.02}, {0.7945055161368993, 0.47690532824441084`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.699421949827444, 0.3780121448340242}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["8", 
       Scaled[{0.02, 0.02}, {0.699421949827444, 0.3780121448340242}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.5324637962135547, 0.08848231532910193}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["9", 
       Scaled[{0.02, 0.02}, {0.5324637962135547, 0.08848231532910193}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.5324637962135547, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["10", 
       Scaled[{0.02, 0.02}, {0.5324637962135547, 0.}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.7068286867987512, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["11", 
       Scaled[{0.02, 0.02}, {0.7068286867987512, 0.}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.8811935773839477, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["12", 
       Scaled[{0.02, 0.02}, {0.8811935773839477, 0.}], {-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->1,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->{276., Automatic},
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.4824637962135547, 1.05}, {-0.05, 0.5269053282444108}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{280, 276},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[66]=",
 CellID->619079713]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options for ToCombinatoricaGraph", "Subsubsection",
 CellTags->"b:0.10b",
 CellID->215116067],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], "Automatic", Cell[
    "method used to lay out the graph", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.10b",
 CellID->1837786448],

Cell[TextData[{
 "Options for ",
 StyleBox[ButtonBox["ToCombinatoricaGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/ref/ToCombinatoricaGraph"], "MR"]
}], "Caption",
 CellTags->"b:0.10b",
 CellID->100920950],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " specifies the method used to lay out the graph. The coordinates thus \
calculated are embedding in the resulting ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " graph object. Possible values are the same as values for the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ". The default is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", which uses the default method of ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ", except when the input is an ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " object, in which case the coordinates that come with the object are not \
changed."
}], "Text",
 CellID->995232876],

Cell["This defines a simple graph.", "MathCaption",
 CellID->632762632],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "2"}], ",", 
     RowBox[{"8", "\[Rule]", "3"}], ",", 
     RowBox[{"9", "\[Rule]", "4"}], ",", 
     RowBox[{"10", "\[Rule]", "5"}], ",", 
     RowBox[{"11", "\[Rule]", "6"}], ",", 
     RowBox[{"11", "\[Rule]", "7"}], ",", 
     RowBox[{"12", "\[Rule]", "6"}], ",", 
     RowBox[{"12", "\[Rule]", "10"}], ",", 
     RowBox[{"13", "\[Rule]", "9"}], ",", 
     RowBox[{"13", "\[Rule]", "10"}], ",", 
     RowBox[{"14", "\[Rule]", "8"}], ",", 
     RowBox[{"14", "\[Rule]", "9"}], ",", 
     RowBox[{"15", "\[Rule]", "7"}], ",", 
     RowBox[{"15", "\[Rule]", "8"}], ",", 
     RowBox[{"16", "\[Rule]", "11"}], ",", 
     RowBox[{"17", "\[Rule]", "12"}], ",", 
     RowBox[{"17", "\[Rule]", "16"}], ",", 
     RowBox[{"18", "\[Rule]", "13"}], ",", 
     RowBox[{"18", "\[Rule]", "17"}], ",", 
     RowBox[{"19", "\[Rule]", "14"}], ",", 
     RowBox[{"19", "\[Rule]", "18"}], ",", 
     RowBox[{"20", "\[Rule]", "15"}], ",", 
     RowBox[{"20", "\[Rule]", "16"}], ",", 
     RowBox[{"20", "\[Rule]", "19"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[81]:=",
 CellID->1064780346],

Cell[TextData[{
 "This shows the graph of the above graph converted to a ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " object, and contrasts it with the drawing by ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->22171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ShowGraph", "[", 
     RowBox[{
      RowBox[{"ToCombinatoricaGraph", "[", "g", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "220"}]}], "]"}], ",", 
    RowBox[{"GraphPlot", "[", 
     RowBox[{"g", ",", 
      RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "250"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[84]:=",
 CellID->27489],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{470, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[84]=",
 CellID->40609373]
}, Open  ]],

Cell["\<\
This uses the spring embedding method to find the coordinates.\
\>", "MathCaption",
 CellID->683885067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", 
  RowBox[{"ToCombinatoricaGraph", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Method", "\[Rule]", "SpringEmbedding"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[85]:=",
 CellID->1128541062],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.4999718224842129, 0.46419321149353043`}, {
      0.8719937329952686, 0.6843765137994688}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.1232378099234107, 0.676296556327232}, {0.4999718224842129, 
      0.46419321149353043`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.29650311284244985`, 0.9240710718080409}, {
      0.1232378099234107, 0.676296556327232}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6934787834511472, 0.9283702449465102}, {0.8719937329952686, 
      0.6843765137994688}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6934787834511472, 0.9283702449465102}, {
      0.29650311284244985`, 0.9240710718080409}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{1., 0.4104932823838644}, {0.8719937329952686, 
      0.6843765137994688}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.504678155280083, 0.031917560761226996`}, {
      0.4999718224842129, 0.46419321149353043`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.0012597046420304943`, 0.3996473916347383}, {
      0.1232378099234107, 0.676296556327232}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.19477542176340173`, 0.8638303522409295}, {
      0.29650311284244985`, 0.9240710718080409}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7965266069687454, 0.8703522031064714}, {0.6934787834511472, 
      0.9283702449465102}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.8052317093436646, 0.06453659280846043}, {1., 
      0.4104932823838644}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.8052317093436646, 0.06453659280846043}, {0.504678155280083, 
      0.031917560761226996`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.9987375024250083, 0.5287137265244162}, {1., 
      0.4104932823838644}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.9987375024250083, 0.5287137265244162}, {0.7965266069687454, 
      0.8703522031064714}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.4953270691137398, 0.8964427664241871}, {
      0.19477542176340173`, 0.8638303522409295}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.4953270691137398, 0.8964427664241871}, {0.7965266069687454, 
      0.8703522031064714}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0., 0.517868032129251}, {0.0012597046420304943`, 
      0.3996473916347383}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0., 0.517868032129251}, {0.19477542176340173`, 
      0.8638303522409295}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.20347810047437434`, 0.058009807370367705`}, {
      0.504678155280083, 0.031917560761226996`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.20347810047437434`, 0.058009807370367705`}, {
      0.0012597046420304943`, 0.3996473916347383}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.7035017631139541, 0.004305497021464902}, {
      0.8052317093436646, 0.06453659280846043}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.8767400852167949, 0.2520857459001104}, {0.9987375024250083, 
      0.5287137265244162}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.8767400852167949, 0.2520857459001104}, {0.7035017631139541, 
      0.004305497021464902}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.500001994734895, 0.4641807899100804}, {0.4953270691137398, 
      0.8964427664241871}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.500001994734895, 0.4641807899100804}, {0.8767400852167949, 
      0.2520857459001104}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.12799666105840307`, 0.24398602001563388`}, {0., 
      0.517868032129251}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.12799666105840307`, 0.24398602001563388`}, {
      0.500001994734895, 0.4641807899100804}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.30652208401311415`, 0.}, {0.20347810047437434`, 
      0.058009807370367705`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.30652208401311415`, 0.}, {0.7035017631139541, 
      0.004305497021464902}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.30652208401311415`, 0.}, {0.12799666105840307`, 
      0.24398602001563388`}}], 
     {GrayLevel[0]}}}, {
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.4999718224842129, 0.46419321149353043`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["2", 
       Scaled[{0.02, 0.02}, {0.4999718224842129, 0.46419321149353043`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.8719937329952686, 0.6843765137994688}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["1", 
       Scaled[{0.02, 0.02}, {0.8719937329952686, 0.6843765137994688}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.1232378099234107, 0.676296556327232}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["3", 
       Scaled[{0.02, 0.02}, {0.1232378099234107, 0.676296556327232}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.29650311284244985`, 0.9240710718080409}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["4", 
       Scaled[{0.02, 0.02}, {0.29650311284244985`, 0.9240710718080409}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.6934787834511472, 0.9283702449465102}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["5", 
       Scaled[{0.02, 0.02}, {0.6934787834511472, 0.9283702449465102}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{1., 0.4104932823838644}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["6", 
       Scaled[{0.02, 0.02}, {1., 0.4104932823838644}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.504678155280083, 0.031917560761226996`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["7", 
       Scaled[{0.02, 0.02}, {0.504678155280083, 0.031917560761226996`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.0012597046420304943`, 0.3996473916347383}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["8", 
       Scaled[{0.02, 0.02}, {0.0012597046420304943`, 0.3996473916347383}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.19477542176340173`, 0.8638303522409295}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["9", 
       Scaled[{0.02, 0.02}, {0.19477542176340173`, 0.8638303522409295}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.7965266069687454, 0.8703522031064714}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["10", 
       Scaled[{0.02, 0.02}, {0.7965266069687454, 0.8703522031064714}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.8052317093436646, 0.06453659280846043}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["11", 
       Scaled[{0.02, 0.02}, {0.8052317093436646, 0.06453659280846043}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.9987375024250083, 0.5287137265244162}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["12", 
       Scaled[{0.02, 0.02}, {0.9987375024250083, 0.5287137265244162}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.4953270691137398, 0.8964427664241871}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["13", 
       Scaled[{0.02, 0.02}, {0.4953270691137398, 0.8964427664241871}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0., 0.517868032129251}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["14", 
       Scaled[{0.02, 0.02}, {0., 0.517868032129251}], {-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.20347810047437434`, 0.058009807370367705`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["15", 
       Scaled[{0.02, 0.02}, {0.20347810047437434`, 0.058009807370367705`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.7035017631139541, 0.004305497021464902}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["16", 
       Scaled[{0.02, 0.02}, {0.7035017631139541, 0.004305497021464902}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.8767400852167949, 0.2520857459001104}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["17", 
       Scaled[{0.02, 0.02}, {0.8767400852167949, 0.2520857459001104}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.500001994734895, 0.4641807899100804}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["18", 
       Scaled[{0.02, 0.02}, {0.500001994734895, 0.4641807899100804}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.12799666105840307`, 0.24398602001563388`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["19", 
       Scaled[{0.02, 0.02}, {0.12799666105840307`, 0.24398602001563388`}], \
{-1, 0}]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.30652208401311415`, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["20", 
       Scaled[{0.02, 0.02}, {0.30652208401311415`, 0.}], {-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->1,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{-0.05, 1.05}, {-0.05, 0.9783702449465103}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[85]=",
 CellID->1886033168]
}, Open  ]],

Cell[TextData[{
 "This defines a ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " object."
}], "MathCaption",
 CellID->1160513182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"ButterflyGraph", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[89]:=",
 CellID->2131783975],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "48", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", "\<\"Undirected\"\>", 
   "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
  SequenceForm[
  "\[SkeletonIndicator]Graph:<", 48, ", ", 32, ", ", "Undirected", 
   ">\[SkeletonIndicator]"],
  Editable->False]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[89]=",
 CellID->1814343985]
}, Open  ]],

Cell[TextData[{
 "This shows that ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " objects are unchanged after applying ",
 Cell[BoxData[
  ButtonBox["ToCombinatoricaGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/ToCombinatoricaGraph"]], 
  "InlineFormula"],
 "."
}], "MathCaption",
 CellID->677366046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ShowGraph", "[", "g", "]"}], ",", 
    RowBox[{"ShowGraph", "[", 
     RowBox[{"ToCombinatoricaGraph", "[", "g", "]"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[90]:=",
 CellID->2035749510],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[90]=",
 CellID->57132572]
}, Open  ]],

Cell["This adds extra vertices.", "MathCaption",
 CellID->786998624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", 
  RowBox[{"ToCombinatoricaGraph", "[", 
   RowBox[{"g", ",", "34"}], "]"}], "]"}]], "Input",
 CellLabel->"In[91]:=",
 CellID->1506746652],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmkmIVFcXx59VPdrdjmln4xCHEMc4BjFxIpqBL06RNh2nxhYVEYdWEUIw
ISHG4IziSiRi2g+JLcFPRBREhUjcBFcuXerOZZb1/e77vzrv1Otqh9ZFCixf
33fvueee4X+GW/9p2bNl0/aWPVs3toxcsrtl55atG9tGLt6xm6F8jyiK/gz/
BkU8F3iK//1ZKPD/v/m7JnxXPnny5IMPPoDjd9999++//45yrz06pexoa9nR
asfJ6tWro+Jn2LBhUe7AgQNR5cSJE7s1GraZ0oluGG0tO+o5gTl7V1FRkVB/
6623ujVaU1OTcOLphtHWsqOek/3799u7wHHutUenlB1tLTsqTmrDdwXvJk+e
PHz48GfPnuWLI7169aqvr7eRnTt3IoKBAwfevHlTI0h29OjRW7ZsYc7U4qr5
8+drZFOnEe3YM3zn79+/z/J4Svz3yJEjq6ur//nnn0i09f7MmTMszRdnPH78
ODz+5ugwxIuUDjKeNWsWqxM6ooBlDho0KJZZ/vbt23AUHttjOnXxKEIpxB9J
tgJOIMVSCMSUajj/sWPHePzkk0+uX7/Og95edFT69OnDOVMq4o5lLBYVtoYB
Hs+dO7dhwwa2YQLseSrpSXNOFuzJzjGVatuHbw72xx9/8Cr6r6Nh+yQ0rly5
smzZMi8HPduMPDYxb9482Cqhw+jFixdtVo3Y5pG1UODB8ZU/f/58VVVV0KKn
ITkVacQ+VOXl6OQTKCB3juUohBUZHdgDzMCS1nLAhQsXZk8gC0hPoBU82oup
U6cCV5KTF6inIvmlVEy+ZsiwzcHllxkpRV67qf3Fc6tBiEePHvEok+M5YEZ8
okrbRSIsoZNavuiYQvhA4dSpUzCsd1Wma2PYU+LMGFRKyXyBDzSampqCymQl
0lVqNVmv7Bx3At7Ec+sfPnxYWVkZFeMD0PDee+8hKk2tra1F+RZ1hgwZYjOj
CyntGo/tQIZ2X7JkST4G6XC0ixeBrs8++8xGdBQWxiN5G4nOO7oeqXv06LFx
40ZO3bt373wC/hXogCfA30YOxJ/iSMCeMnQ97oKnX3/9NWvGjh0rKkS1zZs3
s9+cOXNsRHTnzp0rujBeQjfG7H7QheXx48c3NzfLoNHNzJkzGxoaGhsb0SkG
A2sSNF65bt06j+6GypJtjKaVsk3eHjx4MNZxUHzN9OnT+/fvL697//33ka/s
6XK6sjfb4EZmHXIyjANNsAfOxCl5JbCI/ErRMo8RKiDKjz76CHZ41d7ezqBI
Jytju+2FbMyZ0ClxCTNm0k8//cSD6Mpx/CoGb926BbP8BYP37t3jmzmff/45
2zDI2hkzZuAmfhWiZpUcDuZu3LjBvswZMWKETgwDgj63qkH+C59yMYFIiITV
1UJElDJgwICow60R4sLlgwcPxJlQijUdHR3CglGjRvk1lYJDePz111/ZMzKM
xd8uXAga3rp1Kx6Vroln1DH3hx9+gCeJCexB0dL9ihUrevbs6XfpJR3BH7P1
AKOcCWnJRGEAi0PwXnI6NBzio2wqkbBHS0sLShDoMYFpfpVQivkQhzOBJLsA
EQjyr7/+Yq3s1K8SJsInAoI3hUnBO98///yzeObbrxIPMADzUpdGhBlLly5l
F1G4nPp1f49xaP7OnTsg2KVLl9CTcj2WsJAMCQMmJ4lekFk/B+Ow0Vwut2jR
IkM0mJXYXgnj8inG5eJZHEk7RKLDLsgbNEL1NjI//hRHXgLlgJ+2tjaocGpR
ISyfPn06n89/+eWXNnI7/oBeL0A5gsSYMWOY9/333yPoffv2cThU+8UXXwjl
yEkxF2YCGZzl6dOnQjk0h3N1QrkGgQa2BRZDBx9ET7ISuRd0QrRVhLN8Ic2T
kozI5aF1Cts44eLFi99++23lIRYcg6JzuIDiq0BQh1W+ETKm9pRahbCLbaZM
mZKbNGlSvMbCMjxfvXo19vMwu8qSyEIxrXTRvV4oCU/YD0Tv3r2rYK89BEzK
NixPEwb7bKOBDcA/wuFXX30FpvPMcQvF7K9gmY6yKElYO7gsqgEhsxIdyVwM
vZE/I+nOlvH/+OOPIex6GoapJ06cIAbLnWX60ovAMKEBWY4e6gFPQzpl9S+/
/IJJZTJBE2NC49q1a0wKj45GgrnwceTIEV6nmKtEkAdhhmhwQqAVK/E0ahlV
WfXtt99CSWwlGaCszZAo+Zs327ZtC1t5Oqxavnw52sGWcVSkCEBIMjpDmmWK
uoCyhAZyx1+pt8Fp1AYOIGZBrGgkKM2jJQjYNaJ1dlLLn+Q2mC1Wyz4QYist
jKmYlMw3FNg9DcaR1YIFC+RIHAgr1QGSqk4xRTEiW83Ij+oLSSaLj/fr1w/p
IGUJU5VihQThKjxXM7lctj6D8zt27MB+165dC5opay3WDimisxVmnuL8O++8
82KcB2lJXPhmXheo3g2cH/CSmM1ptPvs2bO1l+Ex07oYKY/ZdYbZCEriItbD
gmF21DkLfW5eWotawGTE6rWZWMRVNw/LwYAzxkMMCMjk5oX6klQcQyXZxtDH
jRuH8XCg/6VWGGzH/IHEgMSXnUtmMPrpp59CSF734YcfDh06tGQGq7EU829O
z1YlM3ADMmPeHT58GOsiZIWY7GcgR2oR9EMEJZ1btWrV5MmTS2Zw0k2bNokG
e61cuTL0yvyMwYMHoyoUsXv3buaBD8FC/Aywg7MYvmMFRNWsPGDN4siECRM4
eTLDohaiZwYFQxy18oFGHLVKtITW8AikSaxEYh9//DHnIpFGeyXzFB4gsH79
enjiBBiRIDqZl/FQ2OeMe/fuRZLmocOHD+/sod3KxPAO5ExewxHlEZi5shgs
rYuRl8zE0DL/hfK4i7yrW5kY1vDdd98hhzfj1fJNlcJwgdnDAv6DI6RevWfP
HljF16lfNMIyJOa9WjgPHEOrqamJ9biGLEXRM6GlCKpyOF+Um+JYgtEWMaBB
wUzeTyGt6i+xFFFSMFTYU8QQ/qcRo65oczgPLwQL8K26g/VRpgel4FcohkMf
wYhPMEPBRVEJY+CIap6gG1HJNL8KxYDoqRDVyZfr6uoQHRZNRaZ6K/R1FNWt
56Pwp4BYEtUR3DfffINCqPMQsMKdZicZRab7E6Igygj5r892tBDbp4gKMdTi
uLUitbm0BOcExoC6PuuSGLHG48ePcx4r+U2QSY0vGr///nvSEe4q++NU1paz
3DXplIkG9KdNmxZyD09DtTwGvH37drhRLe9VIYbSTjDCOnv2LOx7KuojgGLo
COBRH6HgGoKSTIIxsj9oMRrO1DlDZzU2g8FRScqzpRkpSxm65bjKFBMqqmqs
9sXaQCGd23JRtVjSjqDVHYViDu9pye8wWOxXCO2rGSYT0IMtq54xRRbiJqZq
EV/PNFhfCfwkahDxMB9Tu7WVEgs030j+TvvHLi/r71EfgyV7AT137dpFrDPU
h2bfvn1Rk+VlJaiPmF6M+oiQiMoDghBiEtXVs2O9jQikwI5X6DEiRfFvHcXW
1lbGX6vHCF5gi9j1mjVrDOHVE0X6r4T5/QzzZaKoDlmyASYm61aqh6GpjHl+
Lqdui6wahsjL5MqG+pgnYZuF8qHOnR3MYPz48dibgE8WZM1ulXF+lVX6zMS7
FRGYc/ToUXhQBBCe+1XyVaZBU6eADnOIVNbqV3fSrUpumlgCquRC8RjuSrBj
EiUrLhsaGjh+usq6cIcOHcLqxQoHQ8SKMYRY9FbS65M3IIyOjo64r1BEYtCy
vT14HcYZXjusUgHGkR8+fCiQkMPiMcCsLSnpQ8IVyCjF8C2Q8LwhDky3pENo
/VTB382bN3Vx9TwZRL1sZsF1ZDPyJlWETqb7a80H45VdTp48adcoXrfqNhtK
SgAmGNJVTCNjSiV9atmkdSpMDQpSdk+SxOCynUJERwEj6bW1tYW77Tjn85ch
5B3dzU8bGxvVqYLGG74NIQPnbKjuTd6GMEORAOG/gdsQoY2qvULc6KAaMQjy
tyHQIvpbn7C5uRkL8EgVdw8qo2LDTZCV5BQvilZpv9BlqNnb1pI7NrsdSd5Z
S6sQx1N16Upuq9PcVSssNBfiSK8bk7Q7qJyDv5QuPe820jpgPvmIMtlHkg97
OsZzcj9qUjEfVcCQRWuwbDaUvWFM72sz6ZnPziiNmVbuxthaVZZECBOkSwaB
ptBx9He9mY5vjfm8ZSz+dwmXL19OahZPw3pl2Xvzsvky9DDITL6ct+2STFRS
k+67zN0x5tCx83SyvydQdidbyNQRgsfOdUTeEsmSXzZIMpnuoIlLtZrLK103
U7/WiOKfolhtVWXaMjMMmvQUsr/3MOguqfO8jLJ1Xs+M3YsOaQVAHj86GfnK
M9VG2ZtusLEMYlPmlIzqHgjIv3btWjpK0l8W3Tv9jin32qOeusd4aqko9Bei
ynDr153RUBV66h7pFy5cGOVCsleJeXZrNJxD1O0XS8/pHb58f/Hf8Fu9l/mO
evwfAMDBdg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{198, 198},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[91]=",
 CellID->655772915]
}, Open  ]],

Cell[TextData[{
 "This adds extra vertices, using the ",
 Cell[BoxData["\"\<SpringEmbedding\>\""], "InlineFormula"],
 " method."
}], "MathCaption",
 CellID->179275190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", 
  RowBox[{"ToCombinatoricaGraph", "[", 
   RowBox[{"g", ",", "34", ",", 
    RowBox[{"Method", "\[Rule]", "\"\<SpringEmbedding\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[92]:=",
 CellID->1034168238],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{193, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[92]=",
 CellID->589840619]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexList", "Subsection",
 CellID->1713593147],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["VertexList",
      BaseStyle->"Link",
      ButtonData->"paclet:GraphUtilities/ref/VertexList"], 
     StyleBox["[", "MR"], 
     StyleBox["g", "TI"], 
     StyleBox["]", "MR"]}], 
    StyleBox[
     RowBox[{
     "gives", " ", "a", " ", "list", " ", "of", " ", "all", " ", "vertices", 
      " ", "in", " ", "the", " ", "graph", " ", 
      RowBox[{
       StyleBox["g", "TI"], "."}]}],
     FontFamily->"Verdana",
     FontSize->10]}
  }]], "DefinitionBox",
 CellTags->"b:0.9",
 CellID->24398145],

Cell["Getting a list of all vertices.", "Caption",
 CellTags->"b:0.9",
 CellID->361807899],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["VertexList",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/VertexList"]], "InlineFormula"],
 " returns a list of vertices of the graph ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->31934],

Cell["\<\
For graphs specified using a rule list, the list of vertices are returned in \
the order in which they first appear. \
\>", "Text",
 CellID->942392630],

Cell[TextData[{
 "Functions such as ",
 Cell[BoxData[
  ButtonBox["GraphCoordinates",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PageRankVector",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRankVector"]], 
  "InlineFormula"],
 " return information on vertices in the order given by ",
 Cell[BoxData[
  ButtonBox["VertexList",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/VertexList"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1615698730],

Cell["This gives a list of vertices of a simple graph.", "MathCaption",
 CellID->233031439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VertexList", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b", "\[Rule]", "a"}], ",", 
    RowBox[{"c", "\[Rule]", "d"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[94]:=",
 CellID->1521358867],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "a", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[94]=",
 CellID->349449370]
}, Open  ]],

Cell[TextData[{
 "This defines a small graph, and calculates ",
 Cell[BoxData[
  ButtonBox["GraphCoordinates",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"]], 
  "InlineFormula"],
 "."
}], "MathCaption",
 CellID->425094228],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[96]:=",
 CellID->1759281949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coord", "=", 
  RowBox[{"GraphCoordinates", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[97]:=",
 CellID->1854376424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.2979669616615499`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0010521124157084616`", ",", "0.887675446203021`"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0.7571686302840404`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.8928920018060198`", ",", "0.08912520878421659`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"1.8954888269180663`", ",", "1.0937906704676057`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7587678929999493`", ",", "1.1841206215341105`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{431, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[97]=",
 CellID->512486217]
}, Open  ]],

Cell["\<\
This shows the relationship between the vertex list and the coordinates.\
\>", "MathCaption",
 CellID->410705247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"crules", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"VertexList", "[", "g", "]"}], "->", "coord"}], "]"}]}]], "Input",\

 CellLabel->"In[98]:=",
 CellID->187304895],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.`", ",", "0.2979669616615499`"}], "}"}]}], ",", 
   RowBox[{"2", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.0010521124157084616`", ",", "0.887675446203021`"}], "}"}]}], 
   ",", 
   RowBox[{"4", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.7571686302840404`", ",", "0.`"}], "}"}]}], ",", 
   RowBox[{"5", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.8928920018060198`", ",", "0.08912520878421659`"}], "}"}]}], 
   ",", 
   RowBox[{"1", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.8954888269180663`", ",", "1.0937906704676057`"}], "}"}]}], 
   ",", 
   RowBox[{"6", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.7587678929999493`", ",", "1.1841206215341105`"}], "}"}]}]}], 
  "}"}]], "Output",
 ImageSize->{500, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[98]=",
 CellID->2030576091]
}, Open  ]],

Cell["This draws the graph using the coordinate information.", "MathCaption",
 CellID->681995046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", "crules"}]}], "]"}]], "Input",
 CellLabel->"In[99]:=",
 CellID->945400205],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.2979669616615499}, {
    0.0010521124157084616`, 0.887675446203021}, {0.7571686302840404, 0.}, {
    1.8928920018060198`, 0.08912520878421659}, {1.8954888269180663`, 
    1.0937906704676057`}, {0.7587678929999493, 1.1841206215341105`}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.034488330575963747`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{3, 2}], ArrowBox[{3, 1}], ArrowBox[{4, 5}], 
      ArrowBox[{4, 3}], ArrowBox[{6, 5}], ArrowBox[{6, 2}], 
      ArrowBox[{6, 1}]}, {InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.2979669616615499}, {
     0.0010521124157084616`, 0.887675446203021}, {0.7571686302840404, 0.}, {
     1.8928920018060198`, 0.08912520878421659}, {1.8954888269180663`, 
     1.0937906704676057`}, {0.7587678929999493, 1.1841206215341105`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{322., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{326, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[99]=",
 CellID->1391650768]
}, Open  ]],

Cell[TextData[{
 "This shows that the ordering of vertices from ",
 Cell[BoxData[
  ButtonBox["VertexList",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/VertexList"]], "InlineFormula"],
 " may not be the same as the lexicographical ordering of vertex labels."
}], "MathCaption",
 CellID->2138065999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VertexList", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", "\[Rule]", "1"}], ",", 
    RowBox[{"3", "\[Rule]", "2"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[93]:=",
 CellID->569941009],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[93]=",
 CellID->1766724519]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Section",
 CellTags->"b:0.12",
 CellID->1683113424],

Cell[TextData[{
 "[1] G. Di Battista, P. Eades, R. Tamassia, and I. G. Tollis, ",
 StyleBox["Algorithms for the Visualization of Graphs",
  FontSlant->"Italic"],
 ", Prentice-Hall, 1999."
}], "Text",
 CellTags->{"[1]", "b:0.12"},
 CellID->888998654],

Cell[TextData[{
 "[2] T. M. J. Fruchterman and E. M. Reigold, \"Graph drawing by Force \
Directed Placement\", ",
 StyleBox["Software\[LongDash]Practice and Experience",
  FontSlant->"Italic"],
 ", 21, 1991 pp. 1129-1164."
}], "Text",
 CellTags->{"[2]", "b:0.12"},
 CellID->40602425],

Cell[TextData[{
 "[3] P. Eades, \"A Heuristic for Graph Drawing\", ",
 StyleBox["Congressus Nutnerantiunt",
  FontSlant->"Italic"],
 ", 42, 1984 pp. 149-160."
}], "Text",
 CellTags->{"[3]", "b:0.12"},
 CellID->572165187],

Cell[TextData[{
 "[4] N. Quinn and M. Breur, \"A Force Directed Component Placement Procedure \
for Printed Circuit Boards\", ",
 StyleBox["IEEE Trans. on Circuits and Systems, CAS-26",
  FontSlant->"Italic"],
 ", (6), 1979 pp. 377-388."
}], "Text",
 CellTags->{"[4]", "b:0.12"},
 CellID->323587634],

Cell[TextData[{
 "[5] T. Kamada and S. Kawai, \"An Algorithm for Drawing General Undirected \
Graphs\", ",
 StyleBox["Information Processing Letters",
  FontSlant->"Italic"],
 ", 31, 1989 pp. 7-15."
}], "Text",
 CellTags->{"[5]", "b:0.12"},
 CellID->386606491],

Cell[TextData[{
 "[6] D. Harel and Y. Koren, \"Graph Drawing by High-Dimensional Embedding\", \
in ",
 StyleBox["Proceedings of 10",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", 
    StyleBox["th",
     FontSlant->"Italic"]], TraditionalForm]]],
 " ",
 StyleBox["Int. Symp. Graph Drawing (GD'02)",
  FontSlant->"Italic"],
 ";",
 StyleBox[" ",
  FontSlant->"Italic"],
 "Lecture Notes in Computer Science, Vol. 2528, Springer Verlag, 2002 pp. \
207-219."
}], "Text",
 CellTags->{"[6]", "b:0.12"},
 CellID->1216058703],

Cell[TextData[{
 "[7] C. Walshaw, \"A Multilevel Algorithm for Force-Directed Graph \
Drawing\", ",
 StyleBox["J. Graph Algorithms Appl.",
  FontSlant->"Italic"],
 ", 7, 2003 pp. 253-285."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->932091351],

Cell[TextData[{
 "[8] E. Cuthill and J. McKee, \"Reducing the Bandwidth of Sparse Symmetric \
Matrices\", in Proceeding, 24",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " ",
 "National Conference of ACM, ACM Publications, 1969 pp. 157-172."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->415327171],

Cell[TextData[{
 "[9] A. Lim, B. Rodrigues and F. Xiao, \"A Centroid-Based Approach to Solve \
the Bandwidth Minimization Problem\", ",
 StyleBox["Proceedings of the 37",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", 
    StyleBox["th",
     FontSlant->"Italic"]], TraditionalForm]]],
 " ",
 StyleBox["Annual Hawaii International Conference on System Sciences \
(HICSS'04)",
  FontSlant->"Italic"],
 ", January 05 - 08, 2004, Big Island, Hawaii."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1036137639],

Cell[TextData[{
 "[10] S. T. Barnard, A. Pothen, H. D. Simon, \"A spectral algorithm for \
envelope reduction of sparse matrices\", ",
 StyleBox["Journal of Numerical Linear Algebra with Applications",
  FontSlant->"Italic"],
 ", 2, 1995 pp. 311-334."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1643236012],

Cell[TextData[{
 "[11] S. Sloan, \"A Fortran program for profile and wavefront reduction\", \
",
 StyleBox["International Journal of Numerical Method in Engineering",
  FontSlant->"Italic"],
 ", 28, 1989 pp.2651-2679."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->37930045],

Cell[TextData[{
 "[12] J. K. Reid and J. A. Scott, \"Ordering symmetric sparse matrices for \
small profile and wavefront\", ",
 StyleBox["Numerical Linear Algebra with Applications",
  FontSlant->"Italic"],
 ", 6, 1999 pp.1-23."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1261207572],

Cell["\<\
[13] George, A. (1971), Computer implementation of the finite-element method, \
Report STAN CS-71-208, Ph. D. Thesis, Department of Computer Science, \
Stanford University, Stanford, California.\
\>", "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1821900176],

Cell[TextData[{
 "[14] K. Sugiyama, S. Tagawa and M. Toda, Methods for visual understanding \
of hierarchical systems, ",
 StyleBox["IEEE Trans. Syst. Man Cybern",
  FontSlant->"Italic"],
 "., SMC-11, No. 2, 1981 pp. 109-125."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->295452145],

Cell[TextData[{
 "[15] E. R. Gansner, E. Koutsofios, S. C. North and K.-P. Vo, A Technique \
for Drawing Directed Graphs, ",
 StyleBox["Software Engineering",
  FontSlant->"Italic"],
 ", 19, No. 3, 1993, 214-230"
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->899519486],

Cell["\<\
[16] A. Clauset, \"Finding local community structure in networks\", Phys. \
Rev. E 72, 026132 (2005). \
\>", "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->988196327],

Cell["\<\
[17] Y. F. Hu, Efficient, high-quality force-directed graph drawing, The \
Mathematica Journal, 10 (37-71), 2005.\
\>", "Text",
 CellID->254836105]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graph Utilities Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 36.3829826}", "context" -> 
    "GraphUtilities`", "keywords" -> {}, "index" -> True, "label" -> 
    "Graph Utilities Package Tutorial", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "The Graph Utilities Package contains a number of functions useful for \
graph theory applications. Functions in the Graph Utilities Package. This \
loads the package.", "synonyms" -> {}, "title" -> "Graph Utilities Package", 
    "type" -> "Tutorial", "uri" -> 
    "GraphUtilities/tutorial/GraphUtilities"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "introduction"->{
  Cell[5660, 122, 105, 2, 70, "Title",
   CellTags->{"introduction", "i:2", "b:0.0"},
   CellID->251542051]},
 "i:2"->{
  Cell[5660, 122, 105, 2, 70, "Title",
   CellTags->{"introduction", "i:2", "b:0.0"},
   CellID->251542051]},
 "b:0.0"->{
  Cell[5660, 122, 105, 2, 70, "Title",
   CellTags->{"introduction", "i:2", "b:0.0"},
   CellID->251542051],
  Cell[5768, 126, 275, 8, 70, "Text",
   CellTags->"b:0.0",
   CellID->29196500],
  Cell[6046, 136, 3753, 105, 70, "DefinitionBox",
   CellTags->"b:0.0",
   CellID->7208189],
  Cell[9802, 243, 141, 3, 70, "Caption",
   CellTags->{"S5.18.1", "b:0.0"},
   CellID->661590988],
  Cell[9946, 248, 79, 2, 70, "Text",
   CellTags->"b:0.0",
   CellID->299465232]},
 "S5.18.1"->{
  Cell[9802, 243, 141, 3, 70, "Caption",
   CellTags->{"S5.18.1", "b:0.0"},
   CellID->661590988]},
 "b:0.3"->{
  Cell[10687, 277, 1572, 47, 70, "DefinitionBox",
   CellTags->"b:0.3",
   CellID->1428138794],
  Cell[12262, 326, 99, 2, 70, "Caption",
   CellTags->"b:0.3",
   CellID->2129440045],
  Cell[197018, 5781, 4757, 149, 70, "DefinitionBox",
   CellTags->"b:0.3",
   CellID->1079773270],
  Cell[201778, 5932, 109, 2, 70, "Caption",
   CellTags->"b:0.3",
   CellID->1774220843],
  Cell[230405, 6784, 569, 17, 70, "DefinitionBox",
   CellTags->"b:0.3",
   CellID->816891785],
  Cell[230977, 6803, 100, 2, 70, "Caption",
   CellTags->"b:0.3",
   CellID->163532451],
  Cell[257834, 7473, 1182, 36, 70, "DefinitionBox",
   CellTags->"b:0.3",
   CellID->1610718510],
  Cell[259019, 7511, 103, 2, 70, "Caption",
   CellTags->"b:0.3",
   CellID->1097751099]},
 "b:0.9"->{
  Cell[20208, 602, 564, 18, 70, "DefinitionBox",
   CellTags->"b:0.9",
   CellID->1980534118],
  Cell[20775, 622, 91, 2, 70, "Caption",
   CellTags->"b:0.9",
   CellID->1986619578],
  Cell[20869, 626, 408, 13, 70, "Text",
   CellTags->"b:0.9",
   CellID->1070093888],
  Cell[21280, 641, 647, 25, 70, "Text",
   CellTags->"b:0.9",
   CellID->2132406313],
  Cell[21930, 668, 133, 4, 70, "MathCaption",
   CellTags->"b:0.9",
   CellID->13970831],
  Cell[22493, 694, 189, 5, 70, "MathCaption",
   CellTags->"b:0.9",
   CellID->7475551],
  Cell[503249, 13723, 104, 2, 70, "Subsection",
   CellTags->{"i:11", "b:0.9"},
   CellID->270763112],
  Cell[503356, 13727, 1501, 45, 70, "DefinitionBox",
   CellTags->"b:0.9",
   CellID->474215926],
  Cell[504860, 13774, 97, 2, 70, "Caption",
   CellTags->"b:0.9",
   CellID->118792592],
  Cell[504960, 13778, 197, 5, 70, "Text",
   CellTags->"b:0.9",
   CellID->279365717],
  Cell[505160, 13785, 350, 11, 70, "Text",
   CellTags->"b:0.9",
   CellID->3463340],
  Cell[506133, 13819, 91, 2, 70, "Text",
   CellTags->"b:0.9",
   CellID->814501527],
  Cell[509239, 13902, 178, 5, 70, "Text",
   CellTags->"b:0.9",
   CellID->297519026],
  Cell[509442, 13911, 132, 4, 70, "Input",
   CellTags->"b:0.9",
   CellID->83599705],
  Cell[509577, 13917, 444, 15, 36, "Output",
   CellTags->"b:0.9",
   CellID->1812808428],
  Cell[510036, 13935, 292, 10, 70, "Text",
   CellTags->"b:0.9",
   CellID->143584978],
  Cell[510353, 13949, 413, 12, 47, "Input",
   CellTags->"b:0.9",
   CellID->138950330],
  Cell[510769, 13963, 2677, 49, 84, "Output",
   Evaluatable->False,
   CellTags->"b:0.9",
   CellID->157336271],
  Cell[518493, 14200, 77, 2, 70, "Subsubsection",
   CellTags->"b:0.9",
   CellID->121306228],
  Cell[518595, 14206, 141, 4, 70, "Subsubsubsection",
   CellTags->"b:0.9",
   CellID->583156197],
  Cell[518739, 14212, 313, 10, 70, "Text",
   CellTags->"b:0.9",
   CellID->34775316],
  Cell[519055, 14224, 128, 4, 70, "Text",
   CellTags->"b:0.9",
   CellID->769190340],
  Cell[519208, 14232, 649, 18, 70, "Input",
   CellTags->"b:0.9",
   CellID->118136853],
  Cell[519860, 14252, 716, 22, 94, "Output",
   CellTags->"b:0.9",
   CellID->331904439],
  Cell[520613, 14279, 100, 3, 70, "Input",
   CellTags->"b:0.9",
   CellID->8365528],
  Cell[520716, 14284, 674, 17, 168, "Output",
   CellTags->"b:0.9",
   CellID->21477522],
  Cell[521405, 14304, 112, 2, 70, "Text",
   CellTags->"b:0.9",
   CellID->552833780],
  Cell[521542, 14310, 107, 3, 70, "Input",
   CellTags->"b:0.9",
   CellID->8895882],
  Cell[521652, 14315, 309, 11, 36, "Output",
   CellTags->"b:0.9",
   CellID->159390595],
  Cell[521976, 14329, 344, 11, 70, "Text",
   CellTags->"b:0.9",
   CellID->116881540],
  Cell[522323, 14342, 143, 5, 70, "Text",
   CellTags->"b:0.9",
   CellID->150444139],
  Cell[525291, 14421, 179, 5, 70, "Text",
   CellTags->"b:0.9",
   CellID->51544394],
  Cell[526037, 14451, 289, 7, 70, "Text",
   CellTags->"b:0.9",
   CellID->6582764],
  Cell[526351, 14462, 1887, 56, 70, "Input",
   CellTags->"b:0.9",
   CellID->121533968],
  Cell[528241, 14520, 602, 17, 177, "Output",
   CellTags->"b:0.9",
   CellID->276364028],
  Cell[528892, 14543, 111, 2, 70, "Subsubsubsection",
   CellTags->"b:0.9",
   CellID->85560365],
  Cell[529006, 14547, 310, 10, 70, "Text",
   CellTags->"b:0.9",
   CellID->278105924],
  Cell[529319, 14559, 261, 7, 70, "Text",
   CellTags->"b:0.9",
   CellID->251916138],
  Cell[529605, 14570, 295, 8, 70, "Input",
   CellTags->"b:0.9",
   CellID->43208183],
  Cell[529903, 14580, 484, 17, 36, "Output",
   CellTags->"b:0.9",
   CellID->423561855],
  Cell[530402, 14600, 81, 2, 70, "Text",
   CellTags->"b:0.9",
   CellID->437094615],
  Cell[530508, 14606, 336, 10, 28, "Input",
   CellTags->"b:0.9",
   CellID->47988465],
  Cell[530847, 14618, 1787, 33, 380, "Output",
   Evaluatable->False,
   CellTags->"b:0.9",
   CellID->329523696],
  Cell[532649, 14654, 99, 2, 70, "Text",
   CellTags->"b:0.9",
   CellID->157877045],
  Cell[532751, 14658, 164, 5, 70, "Input",
   CellTags->"b:0.9",
   CellID->497154951],
  Cell[532918, 14665, 212, 5, 70, "Text",
   CellTags->"b:0.9",
   CellID->74443306],
  Cell[533155, 14674, 581, 18, 65, "Input",
   CellTags->"b:0.9",
   CellID->188431946],
  Cell[533739, 14694, 1770, 33, 380, "Output",
   Evaluatable->False,
   CellTags->"b:0.9",
   CellID->68727014],
  Cell[535524, 14730, 169, 5, 70, "Text",
   CellTags->"b:0.9",
   CellID->584841589],
  Cell[535718, 14739, 167, 5, 70, "Input",
   CellTags->"b:0.9",
   CellID->54429004],
  Cell[535888, 14746, 353, 10, 36, "Output",
   CellTags->"b:0.9",
   CellID->319681624],
  Cell[536256, 14759, 602, 17, 70, "Text",
   CellTags->"b:0.9",
   CellID->833160917],
  Cell[536883, 14780, 1345, 42, 155, "Input",
   CellTags->"b:0.9",
   CellID->443104622],
  Cell[538231, 14824, 1726, 32, 380, "Output",
   Evaluatable->False,
   CellTags->"b:0.9",
   CellID->257508985],
  Cell[539972, 14859, 170, 5, 70, "Text",
   CellTags->"b:0.9",
   CellID->355664394],
  Cell[540167, 14868, 167, 5, 28, "Input",
   CellTags->"b:0.9",
   CellID->23320521],
  Cell[540337, 14875, 802, 17, 71, "Output",
   Evaluatable->False,
   CellTags->"b:0.9",
   CellID->828356546],
  Cell[541277, 14903, 1241, 38, 70, "DefinitionBox",
   CellTags->"b:0.9",
   CellID->1436238083],
  Cell[542521, 14943, 159, 7, 70, "Caption",
   CellTags->"b:0.9",
   CellID->91508867],
  Cell[613212, 16608, 555, 19, 70, "DefinitionBox",
   CellTags->"b:0.9",
   CellID->24398145],
  Cell[613770, 16629, 90, 2, 70, "Caption",
   CellTags->"b:0.9",
   CellID->361807899]},
 "b:0.6"->{
  Cell[26626, 809, 448, 14, 70, "DefinitionBox",
   CellTags->"b:0.6",
   CellID->1826735472],
  Cell[27077, 825, 93, 2, 70, "Caption",
   CellTags->"b:0.6",
   CellID->1313057589],
  Cell[73025, 2189, 535, 19, 70, "DefinitionBox",
   CellTags->"b:0.6",
   CellID->1173875382],
  Cell[73563, 2210, 86, 2, 70, "Caption",
   CellTags->"b:0.6",
   CellID->1521328465]},
 "b:0.10b"->{
  Cell[37177, 1078, 99, 2, 70, "Subsubsection",
   CellTags->"b:0.10b",
   CellID->1503268465],
  Cell[37279, 1082, 784, 23, 70, "DefinitionBox3Col",
   CellTags->"b:0.10b",
   CellID->486873165],
  Cell[38066, 1107, 269, 10, 70, "Caption",
   CellTags->"b:0.10b",
   CellID->820011780],
  Cell[38360, 1121, 78, 2, 70, "Subsubsubsection",
   CellTags->"b:0.10b",
   CellID->359255388],
  Cell[41620, 1239, 80, 2, 70, "Subsubsubsection",
   CellTags->"b:0.10b",
   CellID->1187208504],
  Cell[60862, 1867, 612, 17, 70, "DefinitionBox3Col",
   CellTags->"b:0.10b",
   CellID->265227657],
  Cell[190228, 5528, 137, 4, 70, "Subsubsection",
   CellTags->"b:0.10b",
   CellID->2045394960],
  Cell[190368, 5534, 1011, 32, 70, "DefinitionBox3Col",
   CellTags->"b:0.10b",
   CellID->356755035],
  Cell[191382, 5568, 397, 15, 70, "Caption",
   CellTags->"b:0.10b",
   CellID->1275994674],
  Cell[191782, 5585, 696, 21, 70, "DefinitionBox3Col",
   CellTags->"b:0.10b",
   CellID->764686970],
  Cell[192481, 5608, 239, 9, 70, "Caption",
   CellTags->"b:0.10b",
   CellID->2004897033],
  Cell[192745, 5621, 77, 2, 70, "Subsubsubsection",
   CellTags->"b:0.10b",
   CellID->1459351349],
  Cell[193698, 5657, 78, 2, 70, "Subsubsubsection",
   CellTags->"b:0.10b",
   CellID->478024011],
  Cell[217173, 6371, 79, 2, 70, "Subsubsection",
   CellTags->"b:0.10b",
   CellID->120889888],
  Cell[255984, 7403, 104, 2, 70, "Subsubsection",
   CellTags->"b:0.10b",
   CellID->1203381253],
  Cell[256091, 7407, 658, 19, 70, "DefinitionBox3Col",
   CellTags->"b:0.10b",
   CellID->17545054],
  Cell[256752, 7428, 258, 8, 70, "Caption",
   CellTags->"b:0.10b",
   CellID->1648668149],
  Cell[257035, 7440, 79, 2, 70, "Subsubsubsection",
   CellTags->"b:0.10b",
   CellID->1155770649],
  Cell[303476, 8643, 83, 2, 70, "Subsubsubsection",
   CellTags->"b:0.10b",
   CellID->1131827915],
  Cell[355178, 9555, 1829, 59, 70, "DefinitionBox",
   CellTags->"b:0.10b",
   CellID->176779614],
  Cell[357010, 9616, 138, 4, 70, "Caption",
   CellTags->"b:0.10b",
   CellID->567251896],
  Cell[357151, 9622, 340, 15, 70, "Text",
   CellTags->"b:0.10b",
   CellID->643617657],
  Cell[357494, 9639, 390, 15, 70, "Text",
   CellTags->"b:0.10b",
   CellID->44874479],
  Cell[357887, 9656, 393, 16, 70, "Text",
   CellTags->"b:0.10b",
   CellID->721731811],
  Cell[358283, 9674, 168, 7, 70, "Text",
   CellTags->"b:0.10b",
   CellID->35989567],
  Cell[358454, 9683, 391, 15, 70, "Text",
   CellTags->"b:0.10b",
   CellID->339184928],
  Cell[358848, 9700, 255, 10, 70, "Text",
   CellTags->"b:0.10b",
   CellID->150418205],
  Cell[359106, 9712, 281, 11, 70, "Text",
   CellTags->"b:0.10b",
   CellID->57018451],
  Cell[359390, 9725, 172, 7, 70, "Text",
   CellTags->"b:0.10b",
   CellID->186117812],
  Cell[359565, 9734, 358, 14, 70, "Text",
   CellTags->"b:0.10b",
   CellID->634272936],
  Cell[359926, 9750, 282, 6, 70, "Text",
   CellTags->"b:0.10b",
   CellID->278548319],
  Cell[360211, 9758, 194, 7, 70, "Text",
   CellTags->"b:0.10b",
   CellID->3792156],
  Cell[371914, 10118, 143, 4, 70, "MathCaption",
   CellTags->"b:0.10b",
   CellID->53025991],
  Cell[372060, 10124, 219, 8, 70, "Input",
   CellTags->"b:0.10b",
   CellID->807438655],
  Cell[372282, 10134, 346, 11, 70, "Input",
   CellTags->"b:0.10b",
   CellID->353820708],
  Cell[373026, 10160, 846, 27, 65, "Input",
   CellTags->"b:0.10b",
   CellID->2053512829],
  Cell[373875, 10189, 25346, 420, 198, "Output",
   Evaluatable->False,
   CellTags->"b:0.10b",
   CellID->724713976],
  Cell[399236, 10612, 117, 2, 70, "MathCaption",
   CellTags->"b:0.10b",
   CellID->547164372],
  Cell[399378, 10618, 621, 18, 70, "Input",
   CellTags->"b:0.10b",
   CellID->597563837],
  Cell[400002, 10638, 16978, 293, 207, "Output",
   CellTags->"b:0.10b",
   CellID->1730983815],
  Cell[417017, 10936, 116, 2, 70, "Subsubsection",
   CellTags->"b:0.10b",
   CellID->267857294],
  Cell[417136, 10940, 263, 6, 70, "Text",
   CellTags->"b:0.10b",
   CellID->85334619],
  Cell[417424, 10950, 86, 2, 70, "Subsubsubsection",
   CellTags->"b:0.10b",
   CellID->253464642],
  Cell[417513, 10954, 1096, 22, 70, "Text",
   CellTags->"b:0.10b",
   CellID->418352738],
  Cell[418612, 10978, 1454, 30, 70, "Text",
   CellTags->"b:0.10b",
   CellID->170510271],
  Cell[420069, 11010, 728, 15, 70, "Text",
   CellTags->"b:0.10b",
   CellID->219256637],
  Cell[420800, 11027, 2513, 72, 70, "Text",
   CellTags->"b:0.10b",
   CellID->905493635],
  Cell[423350, 11104, 105, 2, 70, "Subsubsubsection",
   CellTags->"b:0.10b",
   CellID->210490374],
  Cell[423458, 11108, 968, 34, 70, "Text",
   CellTags->"b:0.10b",
   CellID->38775144],
  Cell[424429, 11144, 265, 12, 70, "Text",
   CellTags->"b:0.10b",
   CellID->415664190],
  Cell[424697, 11158, 1370, 48, 70, "Text",
   CellTags->"b:0.10b",
   CellID->470991382],
  Cell[426070, 11208, 896, 30, 70, "Text",
   CellTags->"b:0.10b",
   CellID->269736475],
  Cell[427015, 11244, 103, 2, 70, "Subsubsection",
   CellTags->"b:0.10b",
   CellID->249116623],
  Cell[427121, 11248, 1141, 34, 70, "DefinitionBox3Col",
   CellTags->"b:0.10b",
   CellID->220094535],
  Cell[428265, 11284, 134, 5, 70, "Caption",
   CellTags->"b:0.10b",
   CellID->144910677],
  Cell[428424, 11293, 76, 2, 70, "Subsubsubsection",
   CellTags->"b:0.10b",
   CellID->208570215],
  Cell[428503, 11297, 878, 31, 70, "Text",
   CellTags->"b:0.10b",
   CellID->15471859],
  Cell[429384, 11330, 198, 5, 70, "Text",
   CellTags->"b:0.10b",
   CellID->38378614],
  Cell[429585, 11337, 93, 2, 70, "MathCaption",
   CellTags->"b:0.10b",
   CellID->55566182],
  Cell[430969, 11390, 167, 5, 70, "MathCaption",
   CellTags->"b:0.10b",
   CellID->467565390],
  Cell[431161, 11399, 694, 21, 47, "Input",
   CellTags->"b:0.10b",
   CellID->115661660],
  Cell[431858, 11422, 3460, 61, 246, "Output",
   Evaluatable->False,
   CellTags->"b:0.10b",
   CellID->48986718],
  Cell[435333, 11486, 161, 5, 70, "MathCaption",
   CellTags->"b:0.10b",
   CellID->211557088],
  Cell[435497, 11493, 2534, 77, 70, "Input",
   CellTags->"b:0.10b",
   CellID->54977688],
  Cell[438034, 11572, 173, 5, 70, "MathCaption",
   CellTags->"b:0.10b",
   CellID->359044420],
  Cell[438232, 11581, 380, 13, 70, "Input",
   CellTags->"b:0.10b",
   CellID->162186416],
  Cell[438615, 11596, 228, 8, 36, "Output",
   CellTags->"b:0.10b",
   CellID->520553215],
  Cell[438858, 11607, 146, 4, 70, "MathCaption",
   CellTags->"b:0.10b",
   CellID->1613786388],
  Cell[439029, 11615, 379, 13, 70, "Input",
   CellTags->"b:0.10b",
   CellID->405083175],
  Cell[439411, 11630, 232, 8, 36, "Output",
   CellTags->"b:0.10b",
   CellID->1160293545],
  Cell[439692, 11644, 86, 2, 70, "Subsubsubsection",
   CellTags->"b:0.10b",
   CellID->414869041],
  Cell[439781, 11648, 811, 26, 70, "Text",
   CellTags->"b:0.10b",
   CellID->60742260],
  Cell[440629, 11679, 84, 2, 70, "Subsubsubsection",
   CellTags->"b:0.10b",
   CellID->64159827],
  Cell[440716, 11683, 525, 18, 70, "Text",
   CellTags->"b:0.10b",
   CellID->44154937],
  Cell[441290, 11707, 79, 2, 70, "Subsubsection",
   CellTags->"b:0.10b",
   CellID->171535448],
  Cell[499088, 13581, 94, 2, 70, "Subsubsection",
   CellTags->"b:0.10b",
   CellID->1801023034],
  Cell[499185, 13585, 665, 19, 70, "DefinitionBox3Col",
   CellTags->"b:0.10b",
   CellID->771295471],
  Cell[499853, 13606, 236, 8, 70, "Caption",
   CellTags->"b:0.10b",
   CellID->1406539800],
  Cell[557134, 15392, 99, 2, 70, "Subsubsection",
   CellTags->"b:0.10b",
   CellID->215116067],
  Cell[557236, 15396, 533, 15, 70, "DefinitionBox3Col",
   CellTags->"b:0.10b",
   CellID->1837786448],
  Cell[557772, 15413, 225, 7, 70, "Caption",
   CellTags->"b:0.10b",
   CellID->100920950]},
 "b:0.1"->{
  Cell[44361, 1343, 2478, 81, 70, "DefinitionBox",
   CellTags->"b:0.1",
   CellID->1741365842],
  Cell[55048, 1670, 108, 2, 70, "Subsubsection",
   CellTags->"b:0.1",
   CellID->1387360053],
  Cell[60570, 1856, 195, 5, 70, "Subsubsection",
   CellTags->{"Options_for_GraphPlot", "b:0.1"},
   CellID->28720680],
  Cell[60768, 1863, 91, 2, 70, "Text",
   CellTags->"b:0.1",
   CellID->1967562584],
  Cell[61477, 1886, 247, 10, 70, "Caption",
   CellTags->"b:0.1",
   CellID->1770086522],
  Cell[61727, 1898, 577, 21, 70, "Text",
   CellTags->"b:0.1",
   CellID->225069933],
  Cell[62307, 1921, 189, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->178664163],
  Cell[94588, 2725, 2067, 65, 70, "DefinitionBox",
   CellTags->"b:0.1",
   CellID->1815760708],
  Cell[194448, 5690, 901, 30, 70, "DefinitionBox",
   CellTags->"b:0.1",
   CellID->1728316411],
  Cell[278333, 7978, 589, 19, 70, "DefinitionBox",
   CellTags->"b:0.1",
   CellID->1415606667],
  Cell[279010, 8003, 516, 14, 70, "Text",
   CellTags->"b:0.1",
   CellID->1197092942],
  Cell[279529, 8019, 82, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->156141686],
  Cell[446008, 11886, 135, 2, 70, "Subsection",
   CellTags->{"graphplot", "i:3", "b:0.1"},
   CellID->12840550],
  Cell[446146, 11890, 880, 30, 70, "DefinitionBox",
   CellTags->"b:0.1",
   CellID->90032787],
  Cell[447411, 11938, 416, 15, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->160737363],
  Cell[448901, 11988, 106, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->24492853],
  Cell[458640, 12217, 84, 2, 70, "Subsubsection",
   CellTags->"b:0.1",
   CellID->352842546],
  Cell[458727, 12221, 633, 22, 70, "Text",
   CellTags->"b:0.1",
   CellID->9966090],
  Cell[459363, 12245, 712, 29, 70, "Text",
   CellTags->"b:0.1",
   CellID->291558977],
  Cell[460078, 12276, 415, 10, 70, "Text",
   CellTags->"b:0.1",
   CellID->485621972],
  Cell[460496, 12288, 409, 15, 70, "Text",
   CellTags->"b:0.1",
   CellID->488661365],
  Cell[460908, 12305, 1705, 69, 70, "Text",
   CellTags->"b:0.1",
   CellID->587622375],
  Cell[462616, 12376, 216, 7, 70, "Text",
   CellTags->"b:0.1",
   CellID->30706421],
  Cell[462835, 12385, 1255, 51, 70, "Text",
   CellTags->"b:0.1",
   CellID->241477472],
  Cell[464093, 12438, 1790, 58, 70, "Text",
   CellTags->"b:0.1",
   CellID->31481460],
  Cell[465886, 12498, 222, 8, 70, "Text",
   CellTags->"b:0.1",
   CellID->219815997],
  Cell[466111, 12508, 61, 2, 70, "Text",
   CellTags->"b:0.1",
   CellID->178466116],
  Cell[466175, 12512, 386, 14, 70, "Text",
   CellTags->"b:0.1",
   CellID->34745763],
  Cell[466564, 12528, 413, 17, 70, "Text",
   CellTags->"b:0.1",
   CellID->91183741],
  Cell[466980, 12547, 425, 10, 70, "Text",
   CellTags->"b:0.1",
   CellID->27459171],
  Cell[467408, 12559, 879, 26, 70, "Text",
   CellTags->"b:0.1",
   CellID->337999237],
  Cell[468324, 12590, 132, 2, 70, "Subsubsection",
   CellTags->{"Options_for_GraphPlot", "b:0.1"},
   CellID->165075718],
  Cell[468459, 12594, 91, 2, 70, "Text",
   CellTags->"b:0.1",
   CellID->665584976],
  Cell[468553, 12598, 1083, 30, 70, "DefinitionBox3Col",
   CellTags->"b:0.1",
   CellID->423183779],
  Cell[469639, 12630, 387, 15, 70, "Caption",
   CellTags->"b:0.1",
   CellID->299747457],
  Cell[470051, 12649, 77, 2, 70, "Subsubsubsection",
   CellTags->"b:0.1",
   CellID->441644662],
  Cell[470131, 12653, 590, 16, 70, "Text",
   CellTags->"b:0.1",
   CellID->388666005],
  Cell[470758, 12674, 87, 2, 70, "Subsubsubsection",
   CellTags->"b:0.1",
   CellID->174016635],
  Cell[470848, 12678, 704, 16, 70, "Text",
   CellTags->"b:0.1",
   CellID->13002614],
  Cell[471589, 12699, 79, 2, 70, "Subsubsubsection",
   CellTags->"b:0.1",
   CellID->228658500],
  Cell[471671, 12703, 721, 25, 70, "Text",
   CellTags->"b:0.1",
   CellID->643225519],
  Cell[472395, 12730, 267, 9, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->216973463],
  Cell[473159, 12762, 288, 9, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->152890940],
  Cell[473995, 12796, 3025, 102, 70, "Text",
   CellTags->"b:0.1",
   CellID->696743200],
  Cell[479090, 12977, 182, 8, 70, "Text",
   CellTags->"b:0.1",
   CellID->58600801],
  Cell[482185, 13108, 528, 16, 70, "DefinitionBox",
   CellTags->"b:0.1",
   CellID->1716347051]},
 "b:0.11"->{
  Cell[46842, 1426, 116, 2, 70, "Caption",
   CellTags->"b:0.11",
   CellID->404990997],
  Cell[46961, 1430, 644, 15, 70, "Text",
   CellTags->"b:0.11",
   CellID->1615003150],
  Cell[47608, 1447, 91, 2, 70, "MathCaption",
   CellTags->"b:0.11",
   CellID->634919226],
  Cell[96658, 2792, 102, 2, 70, "Caption",
   CellTags->"b:0.11",
   CellID->643723736],
  Cell[96763, 2796, 427, 14, 70, "Text",
   CellTags->"b:0.11",
   CellID->1625834858],
  Cell[195352, 5722, 87, 2, 70, "Caption",
   CellTags->"b:0.11",
   CellID->1663227580],
  Cell[278925, 7999, 82, 2, 70, "Caption",
   CellTags->"b:0.11",
   CellID->1291700419],
  Cell[447029, 11922, 379, 14, 70, "Caption",
   CellTags->"b:0.11",
   CellID->266071060],
  Cell[482716, 13126, 105, 2, 70, "Caption",
   CellTags->"b:0.11",
   CellID->1930395161]},
 "Options_for_GraphPlot"->{
  Cell[60570, 1856, 195, 5, 70, "Subsubsection",
   CellTags->{"Options_for_GraphPlot", "b:0.1"},
   CellID->28720680],
  Cell[468324, 12590, 132, 2, 70, "Subsubsection",
   CellTags->{"Options_for_GraphPlot", "b:0.1"},
   CellID->165075718]},
 "graphplot"->{
  Cell[115177, 3331, 120, 2, 70, "Subsection",
   CellTags->{"graphplot", "i:4", "b:0.2"},
   CellID->355209470],
  Cell[446008, 11886, 135, 2, 70, "Subsection",
   CellTags->{"graphplot", "i:3", "b:0.1"},
   CellID->12840550]},
 "i:4"->{
  Cell[115177, 3331, 120, 2, 70, "Subsection",
   CellTags->{"graphplot", "i:4", "b:0.2"},
   CellID->355209470]},
 "b:0.2"->{
  Cell[115177, 3331, 120, 2, 70, "Subsection",
   CellTags->{"graphplot", "i:4", "b:0.2"},
   CellID->355209470],
  Cell[115300, 3335, 788, 24, 70, "DefinitionBox",
   CellTags->"b:0.2",
   CellID->41670843],
  Cell[116091, 3361, 107, 2, 70, "Caption",
   CellTags->"b:0.2",
   CellID->493933754],
  Cell[117049, 3393, 99, 2, 70, "MathCaption",
   CellTags->"b:0.2",
   CellID->27298254],
  Cell[117151, 3397, 1097, 28, 70, "Input",
   CellTags->"b:0.2",
   CellID->312718712],
  Cell[118273, 3429, 126, 4, 70, "Input",
   CellTags->"b:0.2",
   CellID->608639290],
  Cell[118402, 3435, 3340, 89, 70, "Output",
   CellTags->"b:0.2",
   CellID->216522487],
  Cell[121757, 3527, 138, 4, 70, "MathCaption",
   CellTags->"b:0.2",
   CellID->109486886],
  Cell[121920, 3535, 170, 5, 70, "Input",
   CellTags->"b:0.2",
   CellID->275966196],
  Cell[122093, 3542, 1416, 38, 88, "Output",
   CellTags->"b:0.2",
   CellID->755418280],
  Cell[149903, 4251, 115, 2, 70, "Subsubsection",
   CellTags->"b:0.2",
   CellID->50339381],
  Cell[150021, 4255, 844, 30, 70, "Text",
   CellTags->"b:0.2",
   CellID->375106804]},
 "b:0.4"->{
  Cell[155516, 4446, 108, 2, 70, "MathCaption",
   CellTags->"b:0.4",
   CellID->1138998977]},
 "b:0.8"->{
  Cell[243654, 7083, 151, 5, 70, "MathCaption",
   CellTags->"b:0.8",
   CellID->35264876],
  Cell[243808, 7090, 1405, 45, 70, "Input",
   CellTags->"b:0.8",
   CellID->2003541824]},
 "i:3"->{
  Cell[446008, 11886, 135, 2, 70, "Subsection",
   CellTags->{"graphplot", "i:3", "b:0.1"},
   CellID->12840550]},
 "b:0.5"->{
  Cell[495649, 13473, 159, 5, 70, "MathCaption",
   CellTags->"b:0.5",
   CellID->2089666341]},
 "i:11"->{
  Cell[503249, 13723, 104, 2, 70, "Subsection",
   CellTags->{"i:11", "b:0.9"},
   CellID->270763112]},
 "b:0.12"->{
  Cell[621748, 16904, 71, 2, 70, "Section",
   CellTags->"b:0.12",
   CellID->1683113424],
  Cell[621822, 16908, 249, 7, 70, "Text",
   CellTags->{"[1]", "b:0.12"},
   CellID->888998654],
  Cell[622074, 16917, 283, 8, 70, "Text",
   CellTags->{"[2]", "b:0.12"},
   CellID->40602425],
  Cell[622360, 16927, 220, 7, 70, "Text",
   CellTags->{"[3]", "b:0.12"},
   CellID->572165187],
  Cell[622583, 16936, 299, 8, 70, "Text",
   CellTags->{"[4]", "b:0.12"},
   CellID->323587634],
  Cell[622885, 16946, 260, 8, 70, "Text",
   CellTags->{"[5]", "b:0.12"},
   CellID->386606491],
  Cell[623148, 16956, 549, 20, 70, "Text",
   CellTags->{"[6]", "b:0.12"},
   CellID->1216058703],
  Cell[623700, 16978, 250, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->932091351],
  Cell[623953, 16988, 342, 10, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->415327171],
  Cell[624298, 17000, 542, 17, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1036137639],
  Cell[624843, 17019, 314, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1643236012],
  Cell[625160, 17029, 279, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->37930045],
  Cell[625442, 17039, 292, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1261207572],
  Cell[625737, 17049, 269, 6, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1821900176],
  Cell[626009, 17057, 288, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->295452145],
  Cell[626300, 17067, 274, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->899519486],
  Cell[626577, 17077, 176, 5, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->988196327]},
 "[1]"->{
  Cell[621822, 16908, 249, 7, 70, "Text",
   CellTags->{"[1]", "b:0.12"},
   CellID->888998654]},
 "[2]"->{
  Cell[622074, 16917, 283, 8, 70, "Text",
   CellTags->{"[2]", "b:0.12"},
   CellID->40602425]},
 "[3]"->{
  Cell[622360, 16927, 220, 7, 70, "Text",
   CellTags->{"[3]", "b:0.12"},
   CellID->572165187]},
 "[4]"->{
  Cell[622583, 16936, 299, 8, 70, "Text",
   CellTags->{"[4]", "b:0.12"},
   CellID->323587634]},
 "[5]"->{
  Cell[622885, 16946, 260, 8, 70, "Text",
   CellTags->{"[5]", "b:0.12"},
   CellID->386606491]},
 "[6]"->{
  Cell[623148, 16956, 549, 20, 70, "Text",
   CellTags->{"[6]", "b:0.12"},
   CellID->1216058703]},
 "[7]"->{
  Cell[623700, 16978, 250, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->932091351],
  Cell[623953, 16988, 342, 10, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->415327171],
  Cell[624298, 17000, 542, 17, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1036137639],
  Cell[624843, 17019, 314, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1643236012],
  Cell[625160, 17029, 279, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->37930045],
  Cell[625442, 17039, 292, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1261207572],
  Cell[625737, 17049, 269, 6, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1821900176],
  Cell[626009, 17057, 288, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->295452145],
  Cell[626300, 17067, 274, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->899519486],
  Cell[626577, 17077, 176, 5, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->988196327]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"introduction", 628384, 17128},
 {"i:2", 628504, 17132},
 {"b:0.0", 628626, 17136},
 {"S5.18.1", 629106, 17152},
 {"b:0.3", 629218, 17156},
 {"b:0.9", 629976, 17181},
 {"b:0.6", 635560, 17370},
 {"b:0.10b", 635941, 17383},
 {"b:0.1", 643629, 17629},
 {"b:0.11", 647917, 17768},
 {"Options_for_GraphPlot", 648756, 17796},
 {"graphplot", 649016, 17803},
 {"i:4", 649255, 17810},
 {"b:0.2", 649382, 17814},
 {"b:0.4", 650501, 17851},
 {"b:0.8", 650608, 17855},
 {"i:3", 650801, 17862},
 {"b:0.5", 650928, 17866},
 {"i:11", 651035, 17870},
 {"b:0.12", 651152, 17874},
 {"[1]", 652812, 17926},
 {"[2]", 652920, 17930},
 {"[3]", 653027, 17934},
 {"[4]", 653135, 17938},
 {"[5]", 653243, 17942},
 {"[6]", 653351, 17946},
 {"[7]", 653461, 17950}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 5035, 95, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5660, 122, 105, 2, 70, "Title",
 CellTags->{"introduction", "i:2", "b:0.0"},
 CellID->251542051],
Cell[5768, 126, 275, 8, 70, "Text",
 CellTags->"b:0.0",
 CellID->29196500],
Cell[6046, 136, 3753, 105, 70, "DefinitionBox",
 CellTags->"b:0.0",
 CellID->7208189],
Cell[9802, 243, 141, 3, 70, "Caption",
 CellTags->{"S5.18.1", "b:0.0"},
 CellID->661590988],
Cell[9946, 248, 79, 2, 70, "Text",
 CellTags->"b:0.0",
 CellID->299465232],
Cell[10028, 252, 142, 4, 70, "Input",
 CellID->1575856720],
Cell[10173, 258, 429, 12, 70, "Text",
 CellID->1082663905],
Cell[CellGroupData[{
Cell[10627, 274, 57, 1, 70, "Subsection",
 CellID->373855679],
Cell[10687, 277, 1572, 47, 70, "DefinitionBox",
 CellTags->"b:0.3",
 CellID->1428138794],
Cell[12262, 326, 99, 2, 70, "Caption",
 CellTags->"b:0.3",
 CellID->2129440045],
Cell[12364, 330, 324, 9, 70, "Text",
 CellID->892515739],
Cell[12691, 341, 269, 9, 70, "Text",
 CellID->1766108205],
Cell[12963, 352, 461, 15, 70, "Text",
 CellID->2041381805],
Cell[13427, 369, 498, 17, 70, "MathCaption",
 CellID->369538215],
Cell[13928, 388, 141, 4, 70, "Input",
 CellID->890134534],
Cell[14072, 394, 405, 11, 70, "Input",
 CellID->1335543861],
Cell[CellGroupData[{
Cell[14502, 409, 145, 4, 28, "Input",
 CellID->1258371864],
Cell[14650, 415, 507, 12, 63, "Output",
 Evaluatable->False,
 CellID->215949771]
}, Open  ]],
Cell[15172, 430, 678, 23, 70, "MathCaption",
 CellID->1431420352],
Cell[CellGroupData[{
Cell[15875, 457, 307, 9, 70, "Input",
 CellID->483467941],
Cell[16185, 468, 263, 9, 36, "Output",
 CellID->514531251]
}, Open  ]],
Cell[16463, 480, 218, 5, 70, "MathCaption",
 CellID->1884084651],
Cell[CellGroupData[{
Cell[16706, 489, 422, 13, 28, "Input",
 CellID->213005718],
Cell[17131, 504, 792, 17, 92, "Output",
 Evaluatable->False,
 CellID->416424262]
}, Open  ]],
Cell[17938, 524, 180, 6, 70, "MathCaption",
 CellID->194404505],
Cell[CellGroupData[{
Cell[18143, 534, 206, 6, 28, "Input",
 CellID->181282149],
Cell[18352, 542, 788, 17, 92, "Output",
 Evaluatable->False,
 CellID->766703840]
}, Open  ]],
Cell[19155, 562, 87, 1, 70, "MathCaption",
 CellID->1903738394],
Cell[CellGroupData[{
Cell[19267, 567, 303, 11, 28, "Input",
 CellID->1171058613],
Cell[19573, 580, 528, 13, 63, "Output",
 Evaluatable->False,
 CellID->100869116]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20150, 599, 55, 1, 70, "Subsection",
 CellID->1402613878],
Cell[20208, 602, 564, 18, 70, "DefinitionBox",
 CellTags->"b:0.9",
 CellID->1980534118],
Cell[20775, 622, 91, 2, 70, "Caption",
 CellTags->"b:0.9",
 CellID->1986619578],
Cell[20869, 626, 408, 13, 70, "Text",
 CellTags->"b:0.9",
 CellID->1070093888],
Cell[21280, 641, 647, 25, 70, "Text",
 CellTags->"b:0.9",
 CellID->2132406313],
Cell[21930, 668, 133, 4, 70, "MathCaption",
 CellTags->"b:0.9",
 CellID->13970831],
Cell[CellGroupData[{
Cell[22088, 676, 161, 5, 70, "Input",
 CellID->555822098],
Cell[22252, 683, 226, 8, 36, "Output",
 CellID->36165324]
}, Open  ]],
Cell[22493, 694, 189, 5, 70, "MathCaption",
 CellTags->"b:0.9",
 CellID->7475551],
Cell[22685, 701, 736, 20, 70, "Input",
 CellID->1860757518],
Cell[CellGroupData[{
Cell[23446, 725, 170, 5, 28, "Input",
 CellID->4827],
Cell[23619, 732, 2230, 41, 62, "Output",
 Evaluatable->False,
 CellID->117957185]
}, Open  ]],
Cell[CellGroupData[{
Cell[25886, 778, 110, 3, 70, "Input",
 CellID->1361541404],
Cell[25999, 783, 514, 17, 36, "Output",
 CellID->2112498302]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26562, 806, 61, 1, 70, "Subsection",
 CellID->482574400],
Cell[26626, 809, 448, 14, 70, "DefinitionBox",
 CellTags->"b:0.6",
 CellID->1826735472],
Cell[27077, 825, 93, 2, 70, "Caption",
 CellTags->"b:0.6",
 CellID->1313057589],
Cell[27173, 829, 371, 9, 70, "Text",
 CellID->1002965610],
Cell[27547, 840, 175, 4, 70, "MathCaption",
 CellID->553769720],
Cell[CellGroupData[{
Cell[27747, 848, 977, 32, 101, "Input",
 CellID->379950264],
Cell[28727, 882, 4972, 86, 148, "Output",
 Evaluatable->False,
 CellID->474507301]
}, Open  ]],
Cell[33714, 971, 154, 4, 70, "MathCaption",
 CellID->221466777],
Cell[CellGroupData[{
Cell[33893, 979, 169, 5, 70, "Input",
 CellID->785949058],
Cell[34065, 986, 208, 7, 36, "Output",
 CellID->431436644]
}, Open  ]],
Cell[34288, 996, 142, 4, 70, "MathCaption",
 CellID->1705732766],
Cell[34433, 1002, 307, 9, 70, "Input",
 CellID->2054312142],
Cell[CellGroupData[{
Cell[34765, 1015, 231, 6, 28, "Input",
 CellID->1876367756],
Cell[34999, 1023, 1753, 33, 80, "Output",
 Evaluatable->False,
 CellID->12679231]
}, Open  ]],
Cell[CellGroupData[{
Cell[36789, 1061, 116, 3, 70, "Input",
 CellID->875835504],
Cell[36908, 1066, 232, 7, 36, "Output",
 CellID->52236985]
}, Open  ]],
Cell[CellGroupData[{
Cell[37177, 1078, 99, 2, 70, "Subsubsection",
 CellTags->"b:0.10b",
 CellID->1503268465],
Cell[37279, 1082, 784, 23, 70, "DefinitionBox3Col",
 CellTags->"b:0.10b",
 CellID->486873165],
Cell[38066, 1107, 269, 10, 70, "Caption",
 CellTags->"b:0.10b",
 CellID->820011780],
Cell[CellGroupData[{
Cell[38360, 1121, 78, 2, 70, "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->359255388],
Cell[38441, 1125, 859, 28, 70, "Text",
 CellID->99819372],
Cell[39303, 1155, 373, 10, 70, "MathCaption",
 CellID->736601936],
Cell[CellGroupData[{
Cell[39701, 1169, 451, 12, 70, "Input",
 CellID->1411225982],
Cell[40155, 1183, 242, 8, 36, "Output",
 CellID->1685772583]
}, Open  ]],
Cell[40412, 1194, 383, 12, 70, "MathCaption",
 CellID->658232194],
Cell[CellGroupData[{
Cell[40820, 1210, 523, 14, 70, "Input",
 CellID->455414291],
Cell[41346, 1226, 225, 7, 36, "Output",
 CellID->1009931818]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41620, 1239, 80, 2, 70, "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->1187208504],
Cell[41703, 1243, 543, 19, 70, "Text",
 CellID->1285773581],
Cell[42249, 1264, 395, 11, 70, "MathCaption",
 CellID->435553136],
Cell[CellGroupData[{
Cell[42669, 1279, 405, 11, 70, "Input",
 CellID->1167510304],
Cell[43077, 1292, 223, 7, 36, "Output",
 CellID->14000874]
}, Open  ]],
Cell[43315, 1302, 71, 1, 70, "MathCaption",
 CellID->2004240014],
Cell[CellGroupData[{
Cell[43411, 1307, 516, 13, 70, "Input",
 CellID->576872081],
Cell[43930, 1322, 220, 7, 36, "Output",
 CellID->166828105]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44223, 1337, 135, 4, 70, "Subsection",
 CellID->1878445495],
Cell[44361, 1343, 2478, 81, 70, "DefinitionBox",
 CellTags->"b:0.1",
 CellID->1741365842],
Cell[46842, 1426, 116, 2, 70, "Caption",
 CellTags->"b:0.11",
 CellID->404990997],
Cell[46961, 1430, 644, 15, 70, "Text",
 CellTags->"b:0.11",
 CellID->1615003150],
Cell[47608, 1447, 91, 2, 70, "MathCaption",
 CellTags->"b:0.11",
 CellID->634919226],
Cell[CellGroupData[{
Cell[47724, 1453, 579, 16, 70, "Input",
 CellID->1560725629],
Cell[48306, 1471, 1919, 48, 106, "Output",
 CellID->700239298]
}, Open  ]],
Cell[50240, 1522, 98, 1, 70, "MathCaption",
 CellID->1557311951],
Cell[CellGroupData[{
Cell[50363, 1527, 124, 3, 70, "Input",
 CellID->305700368],
Cell[50490, 1532, 324, 11, 36, "Output",
 CellID->1465366925]
}, Open  ]],
Cell[50829, 1546, 97, 1, 70, "MathCaption",
 CellID->59425543],
Cell[CellGroupData[{
Cell[50951, 1551, 160, 4, 70, "Input",
 CellID->1285886019],
Cell[51114, 1557, 248, 8, 36, "Output",
 CellID->194891590]
}, Open  ]],
Cell[51377, 1568, 105, 2, 70, "MathCaption",
 CellID->728851723],
Cell[CellGroupData[{
Cell[51507, 1574, 201, 7, 70, "Input",
 CellID->1752928821],
Cell[51711, 1583, 426, 13, 36, "Output",
 CellID->1749539767]
}, Open  ]],
Cell[52152, 1599, 114, 3, 70, "MathCaption",
 CellID->1237320986],
Cell[CellGroupData[{
Cell[52291, 1606, 757, 21, 65, "Input",
 CellID->1892274125],
Cell[53051, 1629, 1960, 36, 74, "Output",
 Evaluatable->False,
 CellID->55210863]
}, Open  ]],
Cell[CellGroupData[{
Cell[55048, 1670, 108, 2, 70, "Subsubsection",
 CellTags->"b:0.1",
 CellID->1387360053],
Cell[55159, 1674, 788, 12, 70, "Text",
 CellID->103500215],
Cell[55950, 1688, 922, 30, 70, "Text",
 CellID->189589686],
Cell[56875, 1720, 354, 12, 70, "Text",
 CellID->2103657240],
Cell[57232, 1734, 557, 21, 70, "Text",
 CellID->1504451905],
Cell[57792, 1757, 624, 20, 70, "Text",
 CellID->1036535411],
Cell[58419, 1779, 40, 1, 70, "Text",
 CellID->1582072628],
Cell[58462, 1782, 577, 21, 70, "Text",
 CellID->346004065],
Cell[59042, 1805, 952, 32, 70, "Text",
 CellID->643893516],
Cell[59997, 1839, 536, 12, 70, "Text",
 CellID->608503716]
}, Open  ]],
Cell[CellGroupData[{
Cell[60570, 1856, 195, 5, 70, "Subsubsection",
 CellTags->{"Options_for_GraphPlot", "b:0.1"},
 CellID->28720680],
Cell[60768, 1863, 91, 2, 70, "Text",
 CellTags->"b:0.1",
 CellID->1967562584],
Cell[60862, 1867, 612, 17, 70, "DefinitionBox3Col",
 CellTags->"b:0.10b",
 CellID->265227657],
Cell[61477, 1886, 247, 10, 70, "Caption",
 CellTags->"b:0.1",
 CellID->1770086522],
Cell[61727, 1898, 577, 21, 70, "Text",
 CellTags->"b:0.1",
 CellID->225069933],
Cell[62307, 1921, 189, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->178664163],
Cell[62499, 1928, 1065, 32, 70, "Input",
 CellID->257522100],
Cell[63567, 1962, 122, 3, 70, "MathCaption",
 CellID->1689655390],
Cell[CellGroupData[{
Cell[63714, 1969, 901, 26, 70, "Input",
 CellID->56997146],
Cell[64618, 1997, 3526, 70, 370, "Output",
 CellID->508964893]
}, Open  ]],
Cell[68159, 2070, 227, 5, 70, "MathCaption",
 CellID->1313779799],
Cell[CellGroupData[{
Cell[68411, 2079, 970, 28, 70, "Input",
 CellID->1814834051],
Cell[69384, 2109, 3527, 70, 370, "Output",
 CellID->2084731565]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72972, 2186, 50, 1, 70, "Subsection",
 CellID->239679646],
Cell[73025, 2189, 535, 19, 70, "DefinitionBox",
 CellTags->"b:0.6",
 CellID->1173875382],
Cell[73563, 2210, 86, 2, 70, "Caption",
 CellTags->"b:0.6",
 CellID->1521328465],
Cell[73652, 2214, 94, 1, 70, "MathCaption",
 CellID->1377811920],
Cell[CellGroupData[{
Cell[73771, 2219, 304, 8, 70, "Input",
 CellID->1806197961],
Cell[74078, 2229, 411, 13, 36, "Output",
 CellID->2031118735]
}, Open  ]],
Cell[74504, 2245, 160, 6, 70, "MathCaption",
 CellID->2092380576],
Cell[CellGroupData[{
Cell[74689, 2255, 108, 3, 70, "Input",
 CellID->2109398399],
Cell[74800, 2260, 599, 15, 36, "Output",
 CellID->1674544461]
}, Open  ]],
Cell[CellGroupData[{
Cell[75436, 2280, 237, 8, 70, "Input",
 CellID->1106863291],
Cell[75676, 2290, 1392, 37, 71, "Output",
 CellID->803276254]
}, Open  ]],
Cell[CellGroupData[{
Cell[77105, 2332, 108, 3, 70, "Input",
 CellID->1188040214],
Cell[77216, 2337, 13217, 250, 70, "Output",
 CellID->83367176]
}, Open  ]],
Cell[90448, 2590, 68, 1, 70, "MathCaption",
 CellID->1459575814],
Cell[CellGroupData[{
Cell[90541, 2595, 534, 17, 70, "Input",
 CellID->573693372],
Cell[91078, 2614, 790, 22, 54, "Output",
 CellID->2109607209]
}, Open  ]],
Cell[CellGroupData[{
Cell[91905, 2641, 108, 3, 70, "Input",
 CellID->326944604],
Cell[92016, 2646, 2460, 70, 70, "Output",
 CellID->995139259]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[94525, 2722, 60, 1, 70, "Subsection",
 CellID->101821423],
Cell[94588, 2725, 2067, 65, 70, "DefinitionBox",
 CellTags->"b:0.1",
 CellID->1815760708],
Cell[96658, 2792, 102, 2, 70, "Caption",
 CellTags->"b:0.11",
 CellID->643723736],
Cell[96763, 2796, 427, 14, 70, "Text",
 CellTags->"b:0.11",
 CellID->1625834858],
Cell[97193, 2812, 161, 4, 70, "MathCaption",
 CellID->5097],
Cell[CellGroupData[{
Cell[97379, 2820, 275, 9, 70, "Input",
 CellID->16512],
Cell[97657, 2831, 9071, 251, 70, "Output",
 CellID->1074248922]
}, Open  ]],
Cell[106743, 3085, 122, 3, 70, "MathCaption",
 CellID->1108291180],
Cell[CellGroupData[{
Cell[106890, 3092, 324, 11, 70, "Input",
 CellID->638430509],
Cell[107217, 3105, 7911, 220, 70, "Output",
 CellID->1362734504]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[115177, 3331, 120, 2, 70, "Subsection",
 CellTags->{"graphplot", "i:4", "b:0.2"},
 CellID->355209470],
Cell[115300, 3335, 788, 24, 70, "DefinitionBox",
 CellTags->"b:0.2",
 CellID->41670843],
Cell[116091, 3361, 107, 2, 70, "Caption",
 CellTags->"b:0.2",
 CellID->493933754],
Cell[116201, 3365, 481, 11, 70, "Text",
 CellID->996693321],
Cell[116685, 3378, 361, 13, 70, "Text",
 CellID->1067943069],
Cell[117049, 3393, 99, 2, 70, "MathCaption",
 CellTags->"b:0.2",
 CellID->27298254],
Cell[117151, 3397, 1097, 28, 70, "Input",
 CellTags->"b:0.2",
 CellID->312718712],
Cell[CellGroupData[{
Cell[118273, 3429, 126, 4, 70, "Input",
 CellTags->"b:0.2",
 CellID->608639290],
Cell[118402, 3435, 3340, 89, 70, "Output",
 CellTags->"b:0.2",
 CellID->216522487]
}, Open  ]],
Cell[121757, 3527, 138, 4, 70, "MathCaption",
 CellTags->"b:0.2",
 CellID->109486886],
Cell[CellGroupData[{
Cell[121920, 3535, 170, 5, 70, "Input",
 CellTags->"b:0.2",
 CellID->275966196],
Cell[122093, 3542, 1416, 38, 88, "Output",
 CellTags->"b:0.2",
 CellID->755418280]
}, Open  ]],
Cell[123524, 3583, 138, 4, 70, "MathCaption",
 CellID->2044539646],
Cell[CellGroupData[{
Cell[123687, 3591, 509, 14, 70, "Input",
 CellID->893076608],
Cell[124199, 3607, 14553, 340, 70, "Output",
 CellID->961597993]
}, Open  ]],
Cell[138767, 3950, 116, 3, 70, "MathCaption",
 CellID->564073450],
Cell[CellGroupData[{
Cell[138908, 3957, 205, 7, 70, "Input",
 CellID->1247042406],
Cell[139116, 3966, 1839, 56, 105, "Output",
 CellID->784038527]
}, Open  ]],
Cell[140970, 4025, 501, 14, 70, "Text",
 CellID->683934603],
Cell[141474, 4041, 235, 8, 70, "MathCaption",
 CellID->1420315704],
Cell[141712, 4051, 115, 3, 70, "Input",
 CellID->49060918],
Cell[141830, 4056, 351, 11, 70, "Input",
 CellID->1327739138],
Cell[CellGroupData[{
Cell[142206, 4071, 183, 5, 70, "Input",
 CellID->1081758619],
Cell[142392, 4078, 3040, 61, 237, "Output",
 CellID->1988216243]
}, Open  ]],
Cell[145447, 4142, 98, 1, 70, "MathCaption",
 CellID->461662465],
Cell[CellGroupData[{
Cell[145570, 4147, 231, 7, 70, "Input",
 CellID->10859885],
Cell[145804, 4156, 375, 13, 36, "Output",
 CellID->1045251399]
}, Open  ]],
Cell[146194, 4172, 131, 4, 70, "MathCaption",
 CellID->2024933293],
Cell[CellGroupData[{
Cell[146350, 4180, 246, 6, 28, "Input",
 CellID->813684022],
Cell[146599, 4188, 3267, 58, 237, "Output",
 Evaluatable->False,
 CellID->14869616]
}, Open  ]],
Cell[CellGroupData[{
Cell[149903, 4251, 115, 2, 70, "Subsubsection",
 CellTags->"b:0.2",
 CellID->50339381],
Cell[150021, 4255, 844, 30, 70, "Text",
 CellTags->"b:0.2",
 CellID->375106804]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[150914, 4291, 88, 1, 70, "Subsection",
 CellID->1713104521],
Cell[151005, 4294, 3356, 109, 70, "DefinitionBox",
 CellID->369537956],
Cell[154364, 4405, 134, 4, 70, "Caption",
 CellID->301719368],
Cell[154501, 4411, 603, 18, 70, "Text",
 CellID->1878198478],
Cell[155107, 4431, 406, 13, 70, "Text",
 CellID->1263057935],
Cell[155516, 4446, 108, 2, 70, "MathCaption",
 CellTags->"b:0.4",
 CellID->1138998977],
Cell[155627, 4450, 1433, 36, 70, "Input",
 CellID->538061090],
Cell[CellGroupData[{
Cell[157085, 4490, 231, 6, 70, "Input",
 CellID->1308540579],
Cell[157319, 4498, 5974, 128, 183, "Output",
 CellID->1797456440]
}, Open  ]],
Cell[163308, 4629, 134, 4, 70, "MathCaption",
 CellID->1615198124],
Cell[CellGroupData[{
Cell[163467, 4637, 144, 4, 70, "Input",
 CellID->712567211],
Cell[163614, 4643, 160, 5, 36, "Output",
 CellID->1586572525]
}, Open  ]],
Cell[CellGroupData[{
Cell[163811, 4653, 151, 4, 70, "Input",
 CellID->1626891699],
Cell[163965, 4659, 239, 7, 36, "Output",
 CellID->1445376542]
}, Open  ]],
Cell[164219, 4669, 98, 1, 70, "MathCaption",
 CellID->1741794910],
Cell[CellGroupData[{
Cell[164342, 4674, 144, 4, 70, "Input",
 CellID->1136393314],
Cell[164489, 4680, 170, 5, 36, "Output",
 CellID->1517243017]
}, Open  ]],
Cell[CellGroupData[{
Cell[164696, 4690, 149, 4, 70, "Input",
 CellID->259176196],
Cell[164848, 4696, 182, 6, 36, "Output",
 CellID->1316360995]
}, Open  ]],
Cell[165045, 4705, 90, 1, 70, "MathCaption",
 CellID->1518893238],
Cell[CellGroupData[{
Cell[165160, 4710, 152, 5, 28, "Input",
 CellID->513117130],
Cell[165315, 4717, 3852, 67, 332, "Output",
 Evaluatable->False,
 CellID->85465418]
}, Open  ]],
Cell[169182, 4787, 81, 1, 70, "MathCaption",
 CellID->1973623475],
Cell[169266, 4790, 806, 26, 70, "Input",
 CellID->1060781549],
Cell[CellGroupData[{
Cell[170097, 4820, 783, 22, 70, "Input",
 CellID->285926919],
Cell[170883, 4844, 2688, 60, 223, "Output",
 CellID->195791831]
}, Open  ]],
Cell[173586, 4907, 80, 1, 70, "MathCaption",
 CellID->9961],
Cell[CellGroupData[{
Cell[173691, 4912, 146, 5, 70, "Input",
 CellID->491],
Cell[173840, 4919, 1066, 28, 108, "Output",
 CellID->1926863129]
}, Open  ]],
Cell[174921, 4950, 603, 18, 70, "MathCaption",
 CellID->11942],
Cell[CellGroupData[{
Cell[175549, 4972, 311, 9, 70, "Input",
 CellID->1037634306],
Cell[175863, 4983, 853, 25, 108, "Output",
 CellID->1749301989]
}, Open  ]],
Cell[CellGroupData[{
Cell[176753, 5013, 366, 13, 70, "Input",
 CellID->1812294677],
Cell[177122, 5028, 224, 7, 36, "Output",
 CellID->275082077]
}, Open  ]],
Cell[177361, 5038, 75, 1, 70, "MathCaption",
 CellID->751001782],
Cell[CellGroupData[{
Cell[177461, 5043, 139, 4, 70, "Input",
 CellID->732872013],
Cell[177603, 5049, 225, 7, 36, "Output",
 CellID->2005443550]
}, Open  ]],
Cell[CellGroupData[{
Cell[177865, 5061, 75, 1, 70, "Subsubsection",
 CellID->1755373314],
Cell[177943, 5064, 642, 24, 70, "Text",
 CellID->182433279],
Cell[CellGroupData[{
Cell[178610, 5092, 86, 1, 70, "Subsubsubsection",
 CellID->516083380],
Cell[178699, 5095, 211, 7, 70, "Text",
 CellID->1302040693],
Cell[178913, 5104, 153, 5, 70, "Text",
 CellID->319815696],
Cell[179069, 5111, 42, 1, 70, "Text",
 CellID->117624113],
Cell[179114, 5114, 455, 17, 70, "Text",
 CellID->1613350403],
Cell[179572, 5133, 56, 1, 70, "Text",
 CellID->275122147],
Cell[179631, 5136, 552, 20, 70, "Text",
 CellID->1872685855],
Cell[180186, 5158, 1631, 63, 70, "Text",
 CellID->710834553],
Cell[181820, 5223, 702, 26, 70, "Text",
 CellID->1069431564],
Cell[182525, 5251, 1359, 47, 70, "Text",
 CellID->139072023]
}, Open  ]],
Cell[CellGroupData[{
Cell[183921, 5303, 83, 1, 70, "Subsubsubsection",
 CellID->1598301965],
Cell[184007, 5306, 127, 4, 70, "Text",
 CellID->1123871519],
Cell[184137, 5312, 1853, 62, 70, "Text",
 CellID->364490271],
Cell[185993, 5376, 914, 30, 70, "Text",
 CellID->1488651201],
Cell[186910, 5408, 1155, 39, 70, "Text",
 CellID->976081803],
Cell[188068, 5449, 1332, 48, 70, "Text",
 CellID->2071651024],
Cell[189403, 5499, 553, 16, 70, "Text",
 CellID->358487948],
Cell[189959, 5517, 220, 5, 70, "Text",
 CellID->1100681814]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[190228, 5528, 137, 4, 70, "Subsubsection",
 CellTags->"b:0.10b",
 CellID->2045394960],
Cell[190368, 5534, 1011, 32, 70, "DefinitionBox3Col",
 CellTags->"b:0.10b",
 CellID->356755035],
Cell[191382, 5568, 397, 15, 70, "Caption",
 CellTags->"b:0.10b",
 CellID->1275994674],
Cell[191782, 5585, 696, 21, 70, "DefinitionBox3Col",
 CellTags->"b:0.10b",
 CellID->764686970],
Cell[192481, 5608, 239, 9, 70, "Caption",
 CellTags->"b:0.10b",
 CellID->2004897033],
Cell[CellGroupData[{
Cell[192745, 5621, 77, 2, 70, "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->1459351349],
Cell[192825, 5625, 836, 27, 70, "Text",
 CellID->1320311085]
}, Open  ]],
Cell[CellGroupData[{
Cell[193698, 5657, 78, 2, 70, "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->478024011],
Cell[193779, 5661, 553, 19, 70, "Text",
 CellID->1964617688]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[194393, 5687, 52, 1, 70, "Subsection",
 CellID->1709138021],
Cell[194448, 5690, 901, 30, 70, "DefinitionBox",
 CellTags->"b:0.1",
 CellID->1728316411],
Cell[195352, 5722, 87, 2, 70, "Caption",
 CellTags->"b:0.11",
 CellID->1663227580],
Cell[195442, 5726, 472, 15, 70, "Text",
 CellID->1956637088],
Cell[195917, 5743, 229, 8, 70, "Text",
 CellID->7376],
Cell[196149, 5753, 351, 6, 70, "Text",
 CellID->2113717424],
Cell[196503, 5761, 214, 6, 70, "Text",
 CellID->96223269],
Cell[196720, 5769, 195, 4, 70, "Text",
 CellID->296616681]
}, Open  ]],
Cell[CellGroupData[{
Cell[196952, 5778, 63, 1, 70, "Subsection",
 CellID->1375416274],
Cell[197018, 5781, 4757, 149, 70, "DefinitionBox",
 CellTags->"b:0.3",
 CellID->1079773270],
Cell[201778, 5932, 109, 2, 70, "Caption",
 CellTags->"b:0.3",
 CellID->1774220843],
Cell[201890, 5936, 868, 28, 70, "Text",
 CellID->1815893747],
Cell[202761, 5966, 117, 3, 70, "MathCaption",
 CellID->682788706],
Cell[CellGroupData[{
Cell[202903, 5973, 788, 23, 70, "Input",
 CellID->986285025],
Cell[203694, 5998, 7256, 141, 70, "Output",
 CellID->776547191]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[210999, 6145, 67, 1, 70, "Subsection",
 CellID->2086213910],
Cell[211069, 6148, 431, 13, 70, "DefinitionBox",
 CellID->496910741],
Cell[211503, 6163, 77, 1, 70, "Caption",
 CellID->14920804],
Cell[211583, 6166, 312, 9, 70, "Text",
 CellID->18678],
Cell[211898, 6177, 1159, 42, 70, "Text",
 CellID->21545],
Cell[213060, 6221, 1938, 73, 70, "Text",
 CellID->28712],
Cell[215001, 6296, 903, 32, 70, "Text",
 CellID->17546],
Cell[215907, 6330, 73, 1, 70, "MathCaption",
 CellID->527984360],
Cell[CellGroupData[{
Cell[216005, 6335, 607, 13, 70, "Input",
 CellID->335475824],
Cell[216615, 6350, 521, 16, 36, "Output",
 CellID->161151542]
}, Open  ]],
Cell[CellGroupData[{
Cell[217173, 6371, 79, 2, 70, "Subsubsection",
 CellTags->"b:0.10b",
 CellID->120889888],
Cell[217255, 6375, 313, 9, 70, "Text",
 CellID->816888557],
Cell[217571, 6386, 212, 6, 70, "MathCaption",
 CellID->24472],
Cell[217786, 6394, 116, 3, 70, "Input",
 CellID->321333761],
Cell[CellGroupData[{
Cell[217927, 6401, 367, 12, 70, "Input",
 CellID->27152],
Cell[218297, 6415, 486, 17, 36, "Output",
 CellID->2061044946]
}, Open  ]],
Cell[CellGroupData[{
Cell[218820, 6437, 102, 3, 28, "Input",
 CellID->14423],
Cell[218925, 6442, 1701, 32, 189, "Output",
 Evaluatable->False,
 CellID->472802055]
}, Open  ]],
Cell[220641, 6477, 89, 1, 70, "MathCaption",
 CellID->2131107523],
Cell[CellGroupData[{
Cell[220755, 6482, 159, 4, 70, "Input",
 CellID->529102339],
Cell[220917, 6488, 2916, 97, 122, "Output",
 CellID->1894592817]
}, Open  ]],
Cell[CellGroupData[{
Cell[223870, 6590, 178, 6, 70, "Input",
 CellID->2131973120],
Cell[224051, 6598, 697, 14, 54, "Output",
 CellID->123349180]
}, Open  ]],
Cell[CellGroupData[{
Cell[224785, 6617, 179, 6, 70, "Input",
 CellID->1769261241],
Cell[224967, 6625, 702, 14, 54, "Output",
 CellID->1907315810]
}, Open  ]],
Cell[225684, 6642, 81, 1, 70, "MathCaption",
 CellID->802143656],
Cell[225768, 6645, 600, 20, 70, "Input",
 CellID->1421463279],
Cell[226371, 6667, 152, 4, 70, "MathCaption",
 CellID->892932029],
Cell[CellGroupData[{
Cell[226548, 6675, 308, 10, 28, "Input",
 CellID->347416693],
Cell[226859, 6687, 1805, 35, 211, "Output",
 Evaluatable->False,
 CellID->151771837]
}, Open  ]],
Cell[228679, 6725, 563, 12, 70, "Text",
 CellID->791633024],
Cell[229245, 6739, 162, 4, 70, "MathCaption",
 CellID->638418240],
Cell[CellGroupData[{
Cell[229432, 6747, 674, 20, 70, "Input",
 CellID->1312020061],
Cell[230109, 6769, 165, 5, 36, "Output",
 CellID->42835252]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[230335, 6781, 67, 1, 70, "Subsection",
 CellID->657286346],
Cell[230405, 6784, 569, 17, 70, "DefinitionBox",
 CellTags->"b:0.3",
 CellID->816891785],
Cell[230977, 6803, 100, 2, 70, "Caption",
 CellTags->"b:0.3",
 CellID->163532451],
Cell[231080, 6807, 432, 12, 70, "Text",
 CellID->6334],
Cell[231515, 6821, 113, 3, 70, "MathCaption",
 CellID->268468226],
Cell[231631, 6826, 1433, 36, 70, "Input",
 CellID->615331030],
Cell[CellGroupData[{
Cell[233089, 6866, 148, 4, 70, "Input",
 CellID->98719676],
Cell[233240, 6872, 725, 25, 36, "Output",
 CellID->166568810]
}, Open  ]],
Cell[233980, 6900, 132, 4, 70, "MathCaption",
 CellID->719249700],
Cell[CellGroupData[{
Cell[234137, 6908, 886, 25, 65, "Input",
 CellID->1038700657],
Cell[235026, 6935, 8613, 145, 228, "Output",
 Evaluatable->False,
 CellID->5996055]
}, Open  ]],
Cell[243654, 7083, 151, 5, 70, "MathCaption",
 CellTags->"b:0.8",
 CellID->35264876],
Cell[243808, 7090, 1405, 45, 70, "Input",
 CellTags->"b:0.8",
 CellID->2003541824],
Cell[CellGroupData[{
Cell[245238, 7139, 160, 4, 70, "Input",
 CellID->1034366891],
Cell[245401, 7145, 363, 13, 36, "Output",
 CellID->1825555766]
}, Open  ]],
Cell[245779, 7161, 165, 4, 70, "MathCaption",
 CellID->359116893],
Cell[CellGroupData[{
Cell[245969, 7169, 1299, 35, 83, "Input",
 CellID->145650617],
Cell[247271, 7206, 3276, 58, 206, "Output",
 Evaluatable->False,
 CellID->143138241]
}, Open  ]],
Cell[250562, 7267, 133, 4, 70, "MathCaption",
 CellID->583110382],
Cell[CellGroupData[{
Cell[250720, 7275, 222, 6, 70, "Input",
 CellID->3725621],
Cell[250945, 7283, 362, 13, 36, "Output",
 CellID->541530758]
}, Open  ]],
Cell[251322, 7299, 71, 1, 70, "MathCaption",
 CellID->1902343016],
Cell[CellGroupData[{
Cell[251418, 7304, 1299, 35, 83, "Input",
 CellID->339972785],
Cell[252720, 7341, 3227, 57, 198, "Output",
 Evaluatable->False,
 CellID->375988330]
}, Open  ]],
Cell[CellGroupData[{
Cell[255984, 7403, 104, 2, 70, "Subsubsection",
 CellTags->"b:0.10b",
 CellID->1203381253],
Cell[256091, 7407, 658, 19, 70, "DefinitionBox3Col",
 CellTags->"b:0.10b",
 CellID->17545054],
Cell[256752, 7428, 258, 8, 70, "Caption",
 CellTags->"b:0.10b",
 CellID->1648668149],
Cell[CellGroupData[{
Cell[257035, 7440, 79, 2, 70, "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->1155770649],
Cell[257117, 7444, 584, 19, 70, "Text",
 CellID->1396410826]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[257762, 7470, 69, 1, 70, "Subsection",
 CellID->114316719],
Cell[257834, 7473, 1182, 36, 70, "DefinitionBox",
 CellTags->"b:0.3",
 CellID->1610718510],
Cell[259019, 7511, 103, 2, 70, "Caption",
 CellTags->"b:0.3",
 CellID->1097751099],
Cell[259125, 7515, 357, 9, 70, "Text",
 CellID->537558084],
Cell[259485, 7526, 249, 9, 70, "Text",
 CellID->1458506999],
Cell[259737, 7537, 119, 3, 70, "MathCaption",
 CellID->11478],
Cell[259859, 7542, 1434, 36, 70, "Input",
 CellID->1254289988],
Cell[CellGroupData[{
Cell[261318, 7582, 142, 4, 70, "Input",
 CellID->5705],
Cell[261463, 7588, 259, 8, 36, "Output",
 CellID->29072017]
}, Open  ]],
Cell[261737, 7599, 129, 4, 70, "MathCaption",
 CellID->9741],
Cell[CellGroupData[{
Cell[261891, 7607, 669, 20, 70, "Input",
 CellID->17673],
Cell[262563, 7629, 6708, 126, 260, "Output",
 CellID->296389683]
}, Open  ]],
Cell[269286, 7758, 144, 4, 70, "MathCaption",
 CellID->30836],
Cell[CellGroupData[{
Cell[269455, 7766, 108, 3, 70, "Input",
 CellID->1124238699],
Cell[269566, 7771, 410, 11, 36, "Output",
 CellID->700175770]
}, Open  ]],
Cell[CellGroupData[{
Cell[270013, 7787, 407, 13, 70, "Input",
 CellID->24350],
Cell[270423, 7802, 267, 9, 36, "Output",
 CellID->1177614126]
}, Open  ]],
Cell[270705, 7814, 117, 3, 70, "MathCaption",
 CellID->1640054030],
Cell[CellGroupData[{
Cell[270847, 7821, 673, 20, 70, "Input",
 CellID->643703617],
Cell[271523, 7843, 6709, 126, 234, "Output",
 CellID->1285324110]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[278281, 7975, 49, 1, 70, "Subsection",
 CellID->1696346694],
Cell[278333, 7978, 589, 19, 70, "DefinitionBox",
 CellTags->"b:0.1",
 CellID->1415606667],
Cell[278925, 7999, 82, 2, 70, "Caption",
 CellTags->"b:0.11",
 CellID->1291700419],
Cell[279010, 8003, 516, 14, 70, "Text",
 CellTags->"b:0.1",
 CellID->1197092942],
Cell[279529, 8019, 82, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->156141686],
Cell[279614, 8023, 2401, 58, 70, "Input",
 CellID->419731589],
Cell[CellGroupData[{
Cell[282040, 8085, 107, 3, 70, "Input",
 CellID->1466878388],
Cell[282150, 8090, 7433, 203, 70, "Output",
 CellID->859834050]
}, Open  ]],
Cell[289598, 8296, 130, 4, 70, "MathCaption",
 CellID->28145],
Cell[CellGroupData[{
Cell[289753, 8304, 146, 5, 70, "Input",
 CellID->23281],
Cell[289902, 8311, 663, 17, 54, "Output",
 CellID->1818630849]
}, Open  ]],
Cell[290580, 8331, 140, 4, 70, "MathCaption",
 CellID->1096522104],
Cell[CellGroupData[{
Cell[290745, 8339, 609, 19, 47, "Input",
 CellID->2995],
Cell[291357, 8360, 6353, 108, 165, "Output",
 Evaluatable->False,
 CellID->14305917]
}, Open  ]],
Cell[297725, 8471, 131, 4, 70, "MathCaption",
 CellID->2045809712],
Cell[CellGroupData[{
Cell[297881, 8479, 515, 17, 70, "Input",
 CellID->1899245228],
Cell[298399, 8498, 485, 17, 36, "Output",
 CellID->1421123079]
}, Open  ]],
Cell[CellGroupData[{
Cell[298921, 8520, 107, 3, 28, "Input",
 CellID->272819860],
Cell[299031, 8525, 1417, 27, 171, "Output",
 Evaluatable->False,
 CellID->733542895]
}, Open  ]],
Cell[300463, 8555, 308, 9, 70, "MathCaption",
 CellID->22704],
Cell[CellGroupData[{
Cell[300796, 8568, 149, 5, 70, "Input",
 CellID->9930],
Cell[300948, 8575, 789, 21, 54, "Output",
 CellID->2098309475]
}, Open  ]],
Cell[CellGroupData[{
Cell[301774, 8601, 277, 8, 28, "Input",
 CellID->22386],
Cell[302054, 8611, 1385, 27, 190, "Output",
 Evaluatable->False,
 CellID->104504521]
}, Open  ]],
Cell[CellGroupData[{
Cell[303476, 8643, 83, 2, 70, "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->1131827915],
Cell[303562, 8647, 679, 13, 70, "Text",
 CellID->221039197],
Cell[304244, 8662, 219, 5, 70, "Text",
 CellID->329725901],
Cell[304466, 8669, 128, 3, 70, "MathCaption",
 CellID->2091432269],
Cell[CellGroupData[{
Cell[304619, 8676, 265, 8, 47, "Input",
 CellID->1903220028],
Cell[304887, 8686, 22288, 369, 198, "Output",
 Evaluatable->False,
 CellID->398887122]
}, Open  ]],
Cell[327190, 9058, 86, 1, 70, "MathCaption",
 CellID->1123665313],
Cell[327279, 9061, 424, 14, 70, "Input",
 CellID->2121614828],
Cell[327706, 9077, 145, 4, 70, "MathCaption",
 CellID->314482243],
Cell[CellGroupData[{
Cell[327876, 9085, 542, 17, 47, "Input",
 CellID->700244740],
Cell[328421, 9104, 26627, 441, 198, "Output",
 Evaluatable->False,
 CellID->21821958]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[355109, 9552, 66, 1, 70, "Subsection",
 CellID->772556000],
Cell[355178, 9555, 1829, 59, 70, "DefinitionBox",
 CellTags->"b:0.10b",
 CellID->176779614],
Cell[357010, 9616, 138, 4, 70, "Caption",
 CellTags->"b:0.10b",
 CellID->567251896],
Cell[357151, 9622, 340, 15, 70, "Text",
 CellTags->"b:0.10b",
 CellID->643617657],
Cell[357494, 9639, 390, 15, 70, "Text",
 CellTags->"b:0.10b",
 CellID->44874479],
Cell[357887, 9656, 393, 16, 70, "Text",
 CellTags->"b:0.10b",
 CellID->721731811],
Cell[358283, 9674, 168, 7, 70, "Text",
 CellTags->"b:0.10b",
 CellID->35989567],
Cell[358454, 9683, 391, 15, 70, "Text",
 CellTags->"b:0.10b",
 CellID->339184928],
Cell[358848, 9700, 255, 10, 70, "Text",
 CellTags->"b:0.10b",
 CellID->150418205],
Cell[359106, 9712, 281, 11, 70, "Text",
 CellTags->"b:0.10b",
 CellID->57018451],
Cell[359390, 9725, 172, 7, 70, "Text",
 CellTags->"b:0.10b",
 CellID->186117812],
Cell[359565, 9734, 358, 14, 70, "Text",
 CellTags->"b:0.10b",
 CellID->634272936],
Cell[359926, 9750, 282, 6, 70, "Text",
 CellTags->"b:0.10b",
 CellID->278548319],
Cell[360211, 9758, 194, 7, 70, "Text",
 CellTags->"b:0.10b",
 CellID->3792156],
Cell[360408, 9767, 71, 1, 70, "MathCaption",
 CellID->1963890172],
Cell[360482, 9770, 400, 12, 70, "Input",
 CellID->4596],
Cell[360885, 9784, 249, 8, 70, "MathCaption",
 CellID->1788945258],
Cell[CellGroupData[{
Cell[361159, 9796, 244, 7, 70, "Input",
 CellID->828951749],
Cell[361406, 9805, 432, 13, 36, "Output",
 CellID->608897324]
}, Open  ]],
Cell[CellGroupData[{
Cell[361875, 9823, 206, 6, 28, "Input",
 CellID->1045789575],
Cell[362084, 9831, 1828, 34, 98, "Output",
 Evaluatable->False,
 CellID->556991624]
}, Open  ]],
Cell[363927, 9868, 109, 3, 70, "MathCaption",
 CellID->23199],
Cell[CellGroupData[{
Cell[364061, 9875, 269, 9, 70, "Input",
 CellID->19668],
Cell[364333, 9886, 160, 5, 36, "Output",
 CellID->969945602]
}, Open  ]],
Cell[364508, 9894, 121, 3, 70, "MathCaption",
 CellID->1932703233],
Cell[CellGroupData[{
Cell[364654, 9901, 247, 7, 70, "Input",
 CellID->24021],
Cell[364904, 9910, 432, 13, 36, "Output",
 CellID->151017768]
}, Open  ]],
Cell[365351, 9926, 111, 3, 70, "MathCaption",
 CellID->3728],
Cell[CellGroupData[{
Cell[365487, 9933, 209, 6, 28, "Input",
 CellID->1807493739],
Cell[365699, 9941, 1848, 34, 98, "Output",
 Evaluatable->False,
 CellID->552632471]
}, Open  ]],
Cell[367562, 9978, 289, 9, 70, "MathCaption",
 CellID->27938],
Cell[CellGroupData[{
Cell[367876, 9991, 277, 9, 70, "Input",
 CellID->1064753963],
Cell[368156, 10002, 161, 5, 36, "Output",
 CellID->1665006857]
}, Open  ]],
Cell[368332, 10010, 73, 1, 70, "MathCaption",
 CellID->24221],
Cell[368408, 10013, 403, 12, 70, "Input",
 CellID->10383],
Cell[368814, 10027, 146, 4, 70, "MathCaption",
 CellID->1828500338],
Cell[CellGroupData[{
Cell[368985, 10035, 188, 6, 70, "Input",
 CellID->18588],
Cell[369176, 10043, 404, 13, 36, "Output",
 CellID->1554303890]
}, Open  ]],
Cell[369595, 10059, 128, 4, 70, "MathCaption",
 CellID->13030],
Cell[CellGroupData[{
Cell[369748, 10067, 461, 14, 28, "Input",
 CellID->8909],
Cell[370212, 10083, 1687, 32, 212, "Output",
 Evaluatable->False,
 CellID->379044218]
}, Open  ]],
Cell[371914, 10118, 143, 4, 70, "MathCaption",
 CellTags->"b:0.10b",
 CellID->53025991],
Cell[372060, 10124, 219, 8, 70, "Input",
 CellTags->"b:0.10b",
 CellID->807438655],
Cell[372282, 10134, 346, 11, 70, "Input",
 CellTags->"b:0.10b",
 CellID->353820708],
Cell[372631, 10147, 370, 9, 70, "MathCaption",
 CellID->1370128377],
Cell[CellGroupData[{
Cell[373026, 10160, 846, 27, 65, "Input",
 CellTags->"b:0.10b",
 CellID->2053512829],
Cell[373875, 10189, 25346, 420, 198, "Output",
 Evaluatable->False,
 CellTags->"b:0.10b",
 CellID->724713976]
}, Open  ]],
Cell[399236, 10612, 117, 2, 70, "MathCaption",
 CellTags->"b:0.10b",
 CellID->547164372],
Cell[CellGroupData[{
Cell[399378, 10618, 621, 18, 70, "Input",
 CellTags->"b:0.10b",
 CellID->597563837],
Cell[400002, 10638, 16978, 293, 207, "Output",
 CellTags->"b:0.10b",
 CellID->1730983815]
}, Open  ]],
Cell[CellGroupData[{
Cell[417017, 10936, 116, 2, 70, "Subsubsection",
 CellTags->"b:0.10b",
 CellID->267857294],
Cell[417136, 10940, 263, 6, 70, "Text",
 CellTags->"b:0.10b",
 CellID->85334619],
Cell[CellGroupData[{
Cell[417424, 10950, 86, 2, 70, "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->253464642],
Cell[417513, 10954, 1096, 22, 70, "Text",
 CellTags->"b:0.10b",
 CellID->418352738],
Cell[418612, 10978, 1454, 30, 70, "Text",
 CellTags->"b:0.10b",
 CellID->170510271],
Cell[420069, 11010, 728, 15, 70, "Text",
 CellTags->"b:0.10b",
 CellID->219256637],
Cell[420800, 11027, 2513, 72, 70, "Text",
 CellTags->"b:0.10b",
 CellID->905493635]
}, Open  ]],
Cell[CellGroupData[{
Cell[423350, 11104, 105, 2, 70, "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->210490374],
Cell[423458, 11108, 968, 34, 70, "Text",
 CellTags->"b:0.10b",
 CellID->38775144],
Cell[424429, 11144, 265, 12, 70, "Text",
 CellTags->"b:0.10b",
 CellID->415664190],
Cell[424697, 11158, 1370, 48, 70, "Text",
 CellTags->"b:0.10b",
 CellID->470991382],
Cell[426070, 11208, 896, 30, 70, "Text",
 CellTags->"b:0.10b",
 CellID->269736475]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[427015, 11244, 103, 2, 70, "Subsubsection",
 CellTags->"b:0.10b",
 CellID->249116623],
Cell[427121, 11248, 1141, 34, 70, "DefinitionBox3Col",
 CellTags->"b:0.10b",
 CellID->220094535],
Cell[428265, 11284, 134, 5, 70, "Caption",
 CellTags->"b:0.10b",
 CellID->144910677],
Cell[CellGroupData[{
Cell[428424, 11293, 76, 2, 70, "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->208570215],
Cell[428503, 11297, 878, 31, 70, "Text",
 CellTags->"b:0.10b",
 CellID->15471859],
Cell[429384, 11330, 198, 5, 70, "Text",
 CellTags->"b:0.10b",
 CellID->38378614],
Cell[429585, 11337, 93, 2, 70, "MathCaption",
 CellTags->"b:0.10b",
 CellID->55566182],
Cell[429681, 11341, 568, 19, 70, "Input",
 CellID->156383302],
Cell[430252, 11362, 105, 2, 70, "MathCaption",
 CellID->1235052410],
Cell[430360, 11366, 300, 10, 70, "Input",
 CellID->1858700288],
Cell[430663, 11378, 303, 10, 70, "Input",
 CellID->1588794428],
Cell[430969, 11390, 167, 5, 70, "MathCaption",
 CellTags->"b:0.10b",
 CellID->467565390],
Cell[CellGroupData[{
Cell[431161, 11399, 694, 21, 47, "Input",
 CellTags->"b:0.10b",
 CellID->115661660],
Cell[431858, 11422, 3460, 61, 246, "Output",
 Evaluatable->False,
 CellTags->"b:0.10b",
 CellID->48986718]
}, Open  ]],
Cell[435333, 11486, 161, 5, 70, "MathCaption",
 CellTags->"b:0.10b",
 CellID->211557088],
Cell[435497, 11493, 2534, 77, 70, "Input",
 CellTags->"b:0.10b",
 CellID->54977688],
Cell[438034, 11572, 173, 5, 70, "MathCaption",
 CellTags->"b:0.10b",
 CellID->359044420],
Cell[CellGroupData[{
Cell[438232, 11581, 380, 13, 70, "Input",
 CellTags->"b:0.10b",
 CellID->162186416],
Cell[438615, 11596, 228, 8, 36, "Output",
 CellTags->"b:0.10b",
 CellID->520553215]
}, Open  ]],
Cell[438858, 11607, 146, 4, 70, "MathCaption",
 CellTags->"b:0.10b",
 CellID->1613786388],
Cell[CellGroupData[{
Cell[439029, 11615, 379, 13, 70, "Input",
 CellTags->"b:0.10b",
 CellID->405083175],
Cell[439411, 11630, 232, 8, 36, "Output",
 CellTags->"b:0.10b",
 CellID->1160293545]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[439692, 11644, 86, 2, 70, "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->414869041],
Cell[439781, 11648, 811, 26, 70, "Text",
 CellTags->"b:0.10b",
 CellID->60742260]
}, Open  ]],
Cell[CellGroupData[{
Cell[440629, 11679, 84, 2, 70, "Subsubsubsection",
 CellTags->"b:0.10b",
 CellID->64159827],
Cell[440716, 11683, 525, 18, 70, "Text",
 CellTags->"b:0.10b",
 CellID->44154937]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[441290, 11707, 79, 2, 70, "Subsubsection",
 CellTags->"b:0.10b",
 CellID->171535448],
Cell[441372, 11711, 559, 9, 70, "Text",
 CellID->1186433259],
Cell[441934, 11722, 113, 3, 70, "MathCaption",
 CellID->617122973],
Cell[442050, 11727, 827, 26, 70, "Input",
 CellID->484997384],
Cell[442880, 11755, 572, 20, 70, "Input",
 CellID->1268113918],
Cell[443455, 11777, 89, 1, 70, "MathCaption",
 CellID->43315634],
Cell[CellGroupData[{
Cell[443569, 11782, 422, 15, 70, "Input",
 CellID->1209087470],
Cell[443994, 11799, 225, 7, 36, "Output",
 CellID->503351351]
}, Open  ]],
Cell[444234, 11809, 157, 4, 70, "MathCaption",
 CellID->1131529567],
Cell[444394, 11815, 453, 16, 70, "Input",
 CellID->1045269098],
Cell[444850, 11833, 103, 2, 70, "MathCaption",
 CellID->689341299],
Cell[CellGroupData[{
Cell[444978, 11839, 260, 9, 70, "Input",
 CellID->1397158291],
Cell[445241, 11850, 227, 7, 36, "Output",
 CellID->2041990880]
}, Open  ]],
Cell[445483, 11860, 118, 3, 70, "MathCaption",
 CellID->1637778318],
Cell[CellGroupData[{
Cell[445626, 11867, 156, 5, 70, "Input",
 CellID->1240548019],
Cell[445785, 11874, 162, 5, 36, "Output",
 CellID->169740494]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[446008, 11886, 135, 2, 70, "Subsection",
 CellTags->{"graphplot", "i:3", "b:0.1"},
 CellID->12840550],
Cell[446146, 11890, 880, 30, 70, "DefinitionBox",
 CellTags->"b:0.1",
 CellID->90032787],
Cell[447029, 11922, 379, 14, 70, "Caption",
 CellTags->"b:0.11",
 CellID->266071060],
Cell[447411, 11938, 416, 15, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->160737363],
Cell[CellGroupData[{
Cell[447852, 11957, 483, 13, 70, "Input",
 CellID->152225696],
Cell[448338, 11972, 548, 13, 54, "Output",
 CellID->80612289]
}, Open  ]],
Cell[448901, 11988, 106, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->24492853],
Cell[CellGroupData[{
Cell[449032, 11994, 1421, 41, 70, "Input",
 CellID->173442147],
Cell[450456, 12037, 1360, 29, 282, "Output",
 CellID->2106811907]
}, Open  ]],
Cell[451831, 12069, 144, 4, 70, "MathCaption",
 CellID->16805842],
Cell[CellGroupData[{
Cell[452000, 12077, 2015, 55, 70, "Input",
 CellID->86303621],
Cell[454018, 12134, 4585, 78, 282, "Output",
 CellID->1560455589]
}, Open  ]],
Cell[CellGroupData[{
Cell[458640, 12217, 84, 2, 70, "Subsubsection",
 CellTags->"b:0.1",
 CellID->352842546],
Cell[458727, 12221, 633, 22, 70, "Text",
 CellTags->"b:0.1",
 CellID->9966090],
Cell[459363, 12245, 712, 29, 70, "Text",
 CellTags->"b:0.1",
 CellID->291558977],
Cell[460078, 12276, 415, 10, 70, "Text",
 CellTags->"b:0.1",
 CellID->485621972],
Cell[460496, 12288, 409, 15, 70, "Text",
 CellTags->"b:0.1",
 CellID->488661365],
Cell[460908, 12305, 1705, 69, 70, "Text",
 CellTags->"b:0.1",
 CellID->587622375],
Cell[462616, 12376, 216, 7, 70, "Text",
 CellTags->"b:0.1",
 CellID->30706421],
Cell[462835, 12385, 1255, 51, 70, "Text",
 CellTags->"b:0.1",
 CellID->241477472],
Cell[464093, 12438, 1790, 58, 70, "Text",
 CellTags->"b:0.1",
 CellID->31481460],
Cell[465886, 12498, 222, 8, 70, "Text",
 CellTags->"b:0.1",
 CellID->219815997],
Cell[466111, 12508, 61, 2, 70, "Text",
 CellTags->"b:0.1",
 CellID->178466116],
Cell[466175, 12512, 386, 14, 70, "Text",
 CellTags->"b:0.1",
 CellID->34745763],
Cell[466564, 12528, 413, 17, 70, "Text",
 CellTags->"b:0.1",
 CellID->91183741],
Cell[466980, 12547, 425, 10, 70, "Text",
 CellTags->"b:0.1",
 CellID->27459171],
Cell[467408, 12559, 879, 26, 70, "Text",
 CellTags->"b:0.1",
 CellID->337999237]
}, Open  ]],
Cell[CellGroupData[{
Cell[468324, 12590, 132, 2, 70, "Subsubsection",
 CellTags->{"Options_for_GraphPlot", "b:0.1"},
 CellID->165075718],
Cell[468459, 12594, 91, 2, 70, "Text",
 CellTags->"b:0.1",
 CellID->665584976],
Cell[468553, 12598, 1083, 30, 70, "DefinitionBox3Col",
 CellTags->"b:0.1",
 CellID->423183779],
Cell[469639, 12630, 387, 15, 70, "Caption",
 CellTags->"b:0.1",
 CellID->299747457],
Cell[CellGroupData[{
Cell[470051, 12649, 77, 2, 70, "Subsubsubsection",
 CellTags->"b:0.1",
 CellID->441644662],
Cell[470131, 12653, 590, 16, 70, "Text",
 CellTags->"b:0.1",
 CellID->388666005]
}, Open  ]],
Cell[CellGroupData[{
Cell[470758, 12674, 87, 2, 70, "Subsubsubsection",
 CellTags->"b:0.1",
 CellID->174016635],
Cell[470848, 12678, 704, 16, 70, "Text",
 CellTags->"b:0.1",
 CellID->13002614]
}, Open  ]],
Cell[CellGroupData[{
Cell[471589, 12699, 79, 2, 70, "Subsubsubsection",
 CellTags->"b:0.1",
 CellID->228658500],
Cell[471671, 12703, 721, 25, 70, "Text",
 CellTags->"b:0.1",
 CellID->643225519],
Cell[472395, 12730, 267, 9, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->216973463],
Cell[CellGroupData[{
Cell[472687, 12743, 153, 5, 70, "Input",
 CellID->411981085],
Cell[472843, 12750, 301, 9, 36, "Output",
 CellID->236110384]
}, Open  ]],
Cell[473159, 12762, 288, 9, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->152890940],
Cell[CellGroupData[{
Cell[473472, 12775, 217, 7, 70, "Input",
 CellID->286841857],
Cell[473692, 12784, 288, 9, 36, "Output",
 CellID->1381496751]
}, Open  ]],
Cell[473995, 12796, 3025, 102, 70, "Text",
 CellTags->"b:0.1",
 CellID->696743200],
Cell[CellGroupData[{
Cell[477045, 12902, 1405, 47, 70, "Input",
 CellID->69144570],
Cell[478453, 12951, 622, 23, 53, "Output",
 CellID->1660727361]
}, Open  ]],
Cell[479090, 12977, 182, 8, 70, "Text",
 CellTags->"b:0.1",
 CellID->58600801],
Cell[CellGroupData[{
Cell[479297, 12989, 124, 4, 70, "Input",
 CellID->70409623],
Cell[479424, 12995, 379, 13, 36, "Output",
 CellID->658484530]
}, Open  ]],
Cell[479818, 13011, 112, 3, 70, "Text",
 CellID->338182235],
Cell[CellGroupData[{
Cell[479955, 13018, 1215, 41, 70, "Input",
 CellID->44019153],
Cell[481173, 13061, 367, 13, 36, "Output",
 CellID->1014372329]
}, Open  ]],
Cell[CellGroupData[{
Cell[481577, 13079, 125, 4, 70, "Input",
 CellID->109862815],
Cell[481705, 13085, 348, 12, 36, "Output",
 CellID->506631393]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[482126, 13105, 56, 1, 70, "Subsection",
 CellID->338176873],
Cell[482185, 13108, 528, 16, 70, "DefinitionBox",
 CellTags->"b:0.1",
 CellID->1716347051],
Cell[482716, 13126, 105, 2, 70, "Caption",
 CellTags->"b:0.11",
 CellID->1930395161],
Cell[482824, 13130, 423, 12, 70, "Text",
 CellID->52933267],
Cell[483250, 13144, 827, 23, 70, "Text",
 CellID->64119438],
Cell[484080, 13169, 144, 4, 70, "Text",
 CellID->2861],
Cell[484227, 13175, 95, 1, 70, "MathCaption",
 CellID->74951448],
Cell[484325, 13178, 340, 11, 70, "Input",
 CellID->1393839371],
Cell[CellGroupData[{
Cell[484690, 13193, 226, 7, 70, "Input",
 CellID->205289293],
Cell[484919, 13202, 280, 10, 36, "Output",
 CellID->1471525678]
}, Open  ]],
Cell[485214, 13215, 146, 4, 70, "MathCaption",
 CellID->20600],
Cell[CellGroupData[{
Cell[485385, 13223, 522, 17, 70, "Input",
 CellID->6617],
Cell[485910, 13242, 1306, 29, 194, "Output",
 CellID->218279897]
}, Open  ]],
Cell[487231, 13274, 99, 1, 70, "MathCaption",
 CellID->643263048],
Cell[487333, 13277, 174, 6, 70, "Input",
 CellID->1815863831],
Cell[CellGroupData[{
Cell[487532, 13287, 245, 8, 70, "Input",
 CellID->1384662509],
Cell[487780, 13297, 280, 10, 36, "Output",
 CellID->761540458]
}, Open  ]],
Cell[488075, 13310, 146, 4, 70, "MathCaption",
 CellID->2421],
Cell[488224, 13316, 468, 15, 70, "Input",
 CellID->599761383],
Cell[CellGroupData[{
Cell[488717, 13335, 1345, 38, 101, "Input",
 CellID->1770532779],
Cell[490065, 13375, 5569, 95, 202, "Output",
 Evaluatable->False,
 CellID->133808072]
}, Open  ]],
Cell[495649, 13473, 159, 5, 70, "MathCaption",
 CellTags->"b:0.5",
 CellID->2089666341],
Cell[CellGroupData[{
Cell[495833, 13482, 367, 11, 70, "Input",
 CellID->1196580261],
Cell[496203, 13495, 426, 13, 36, "Output",
 CellID->2032949408]
}, Open  ]],
Cell[CellGroupData[{
Cell[496666, 13513, 176, 5, 28, "Input",
 CellID->1196347861],
Cell[496845, 13520, 1645, 31, 111, "Output",
 Evaluatable->False,
 CellID->791292]
}, Open  ]],
Cell[CellGroupData[{
Cell[498527, 13556, 111, 3, 70, "Input",
 CellID->987874085],
Cell[498641, 13561, 410, 15, 36, "Output",
 CellID->1871057773]
}, Open  ]],
Cell[CellGroupData[{
Cell[499088, 13581, 94, 2, 70, "Subsubsection",
 CellTags->"b:0.10b",
 CellID->1801023034],
Cell[499185, 13585, 665, 19, 70, "DefinitionBox3Col",
 CellTags->"b:0.10b",
 CellID->771295471],
Cell[499853, 13606, 236, 8, 70, "Caption",
 CellTags->"b:0.10b",
 CellID->1406539800],
Cell[500092, 13616, 944, 29, 70, "Text",
 CellID->522526817],
Cell[501039, 13647, 675, 20, 70, "MathCaption",
 CellID->69573764],
Cell[CellGroupData[{
Cell[501739, 13671, 1234, 36, 70, "Input",
 CellID->1880103238],
Cell[502976, 13709, 212, 7, 36, "Output",
 CellID->1105857454]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[503249, 13723, 104, 2, 70, "Subsection",
 CellTags->{"i:11", "b:0.9"},
 CellID->270763112],
Cell[503356, 13727, 1501, 45, 70, "DefinitionBox",
 CellTags->"b:0.9",
 CellID->474215926],
Cell[504860, 13774, 97, 2, 70, "Caption",
 CellTags->"b:0.9",
 CellID->118792592],
Cell[504960, 13778, 197, 5, 70, "Text",
 CellTags->"b:0.9",
 CellID->279365717],
Cell[505160, 13785, 350, 11, 70, "Text",
 CellTags->"b:0.9",
 CellID->3463340],
Cell[505513, 13798, 287, 7, 70, "Text",
 CellID->31150],
Cell[505803, 13807, 327, 10, 70, "Text",
 CellID->24427726],
Cell[506133, 13819, 91, 2, 70, "Text",
 CellTags->"b:0.9",
 CellID->814501527],
Cell[CellGroupData[{
Cell[506249, 13825, 708, 19, 70, "Input",
 CellID->1026276196],
Cell[506960, 13846, 2264, 53, 84, "Output",
 CellID->253290890]
}, Open  ]],
Cell[509239, 13902, 178, 5, 70, "Text",
 CellTags->"b:0.9",
 CellID->297519026],
Cell[CellGroupData[{
Cell[509442, 13911, 132, 4, 70, "Input",
 CellTags->"b:0.9",
 CellID->83599705],
Cell[509577, 13917, 444, 15, 36, "Output",
 CellTags->"b:0.9",
 CellID->1812808428]
}, Open  ]],
Cell[510036, 13935, 292, 10, 70, "Text",
 CellTags->"b:0.9",
 CellID->143584978],
Cell[CellGroupData[{
Cell[510353, 13949, 413, 12, 47, "Input",
 CellTags->"b:0.9",
 CellID->138950330],
Cell[510769, 13963, 2677, 49, 84, "Output",
 Evaluatable->False,
 CellTags->"b:0.9",
 CellID->157336271]
}, Open  ]],
Cell[CellGroupData[{
Cell[513483, 14017, 114, 3, 70, "Input",
 CellID->497994166],
Cell[513600, 14022, 365, 12, 36, "Output",
 CellID->90811278]
}, Open  ]],
Cell[513980, 14037, 70, 1, 70, "Text",
 CellID->1805813009],
Cell[CellGroupData[{
Cell[514075, 14042, 112, 3, 70, "Input",
 CellID->1723893864],
Cell[514190, 14047, 283, 9, 36, "Output",
 CellID->334024673]
}, Open  ]],
Cell[CellGroupData[{
Cell[514510, 14061, 112, 3, 70, "Input",
 CellID->933409718],
Cell[514625, 14066, 283, 9, 36, "Output",
 CellID->536308895]
}, Open  ]],
Cell[514923, 14078, 70, 1, 70, "Text",
 CellID->767519722],
Cell[514996, 14081, 308, 10, 70, "Input",
 CellID->698606370],
Cell[CellGroupData[{
Cell[515329, 14095, 231, 6, 70, "Input",
 CellID->1031731725],
Cell[515563, 14103, 1780, 44, 237, "Output",
 CellID->452606758]
}, Open  ]],
Cell[517358, 14150, 84, 1, 70, "Text",
 CellID->1740837411],
Cell[CellGroupData[{
Cell[517467, 14155, 111, 3, 70, "Input",
 CellID->187031944],
Cell[517581, 14160, 313, 11, 36, "Output",
 CellID->858264253]
}, Open  ]],
Cell[517909, 14174, 82, 1, 70, "Text",
 CellID->1521858659],
Cell[CellGroupData[{
Cell[518016, 14179, 114, 3, 70, "Input",
 CellID->1213011576],
Cell[518133, 14184, 323, 11, 36, "Output",
 CellID->1343042300]
}, Open  ]],
Cell[CellGroupData[{
Cell[518493, 14200, 77, 2, 70, "Subsubsection",
 CellTags->"b:0.9",
 CellID->121306228],
Cell[CellGroupData[{
Cell[518595, 14206, 141, 4, 70, "Subsubsubsection",
 CellTags->"b:0.9",
 CellID->583156197],
Cell[518739, 14212, 313, 10, 70, "Text",
 CellTags->"b:0.9",
 CellID->34775316],
Cell[519055, 14224, 128, 4, 70, "Text",
 CellTags->"b:0.9",
 CellID->769190340],
Cell[CellGroupData[{
Cell[519208, 14232, 649, 18, 70, "Input",
 CellTags->"b:0.9",
 CellID->118136853],
Cell[519860, 14252, 716, 22, 94, "Output",
 CellTags->"b:0.9",
 CellID->331904439]
}, Open  ]],
Cell[CellGroupData[{
Cell[520613, 14279, 100, 3, 70, "Input",
 CellTags->"b:0.9",
 CellID->8365528],
Cell[520716, 14284, 674, 17, 168, "Output",
 CellTags->"b:0.9",
 CellID->21477522]
}, Open  ]],
Cell[521405, 14304, 112, 2, 70, "Text",
 CellTags->"b:0.9",
 CellID->552833780],
Cell[CellGroupData[{
Cell[521542, 14310, 107, 3, 70, "Input",
 CellTags->"b:0.9",
 CellID->8895882],
Cell[521652, 14315, 309, 11, 36, "Output",
 CellTags->"b:0.9",
 CellID->159390595]
}, Open  ]],
Cell[521976, 14329, 344, 11, 70, "Text",
 CellTags->"b:0.9",
 CellID->116881540],
Cell[522323, 14342, 143, 5, 70, "Text",
 CellTags->"b:0.9",
 CellID->150444139],
Cell[CellGroupData[{
Cell[522491, 14351, 1151, 33, 70, "Input",
 CellID->81094529],
Cell[523645, 14386, 1631, 32, 182, "Output",
 CellID->16131470]
}, Open  ]],
Cell[525291, 14421, 179, 5, 70, "Text",
 CellTags->"b:0.9",
 CellID->51544394],
Cell[CellGroupData[{
Cell[525495, 14430, 205, 6, 70, "Input",
 CellID->901567],
Cell[525703, 14438, 319, 10, 36, "Output",
 CellID->572211481]
}, Open  ]],
Cell[526037, 14451, 289, 7, 70, "Text",
 CellTags->"b:0.9",
 CellID->6582764],
Cell[CellGroupData[{
Cell[526351, 14462, 1887, 56, 70, "Input",
 CellTags->"b:0.9",
 CellID->121533968],
Cell[528241, 14520, 602, 17, 177, "Output",
 CellTags->"b:0.9",
 CellID->276364028]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[528892, 14543, 111, 2, 70, "Subsubsubsection",
 CellTags->"b:0.9",
 CellID->85560365],
Cell[529006, 14547, 310, 10, 70, "Text",
 CellTags->"b:0.9",
 CellID->278105924],
Cell[529319, 14559, 261, 7, 70, "Text",
 CellTags->"b:0.9",
 CellID->251916138],
Cell[CellGroupData[{
Cell[529605, 14570, 295, 8, 70, "Input",
 CellTags->"b:0.9",
 CellID->43208183],
Cell[529903, 14580, 484, 17, 36, "Output",
 CellTags->"b:0.9",
 CellID->423561855]
}, Open  ]],
Cell[530402, 14600, 81, 2, 70, "Text",
 CellTags->"b:0.9",
 CellID->437094615],
Cell[CellGroupData[{
Cell[530508, 14606, 336, 10, 28, "Input",
 CellTags->"b:0.9",
 CellID->47988465],
Cell[530847, 14618, 1787, 33, 380, "Output",
 Evaluatable->False,
 CellTags->"b:0.9",
 CellID->329523696]
}, Open  ]],
Cell[532649, 14654, 99, 2, 70, "Text",
 CellTags->"b:0.9",
 CellID->157877045],
Cell[532751, 14658, 164, 5, 70, "Input",
 CellTags->"b:0.9",
 CellID->497154951],
Cell[532918, 14665, 212, 5, 70, "Text",
 CellTags->"b:0.9",
 CellID->74443306],
Cell[CellGroupData[{
Cell[533155, 14674, 581, 18, 65, "Input",
 CellTags->"b:0.9",
 CellID->188431946],
Cell[533739, 14694, 1770, 33, 380, "Output",
 Evaluatable->False,
 CellTags->"b:0.9",
 CellID->68727014]
}, Open  ]],
Cell[535524, 14730, 169, 5, 70, "Text",
 CellTags->"b:0.9",
 CellID->584841589],
Cell[CellGroupData[{
Cell[535718, 14739, 167, 5, 70, "Input",
 CellTags->"b:0.9",
 CellID->54429004],
Cell[535888, 14746, 353, 10, 36, "Output",
 CellTags->"b:0.9",
 CellID->319681624]
}, Open  ]],
Cell[536256, 14759, 602, 17, 70, "Text",
 CellTags->"b:0.9",
 CellID->833160917],
Cell[CellGroupData[{
Cell[536883, 14780, 1345, 42, 155, "Input",
 CellTags->"b:0.9",
 CellID->443104622],
Cell[538231, 14824, 1726, 32, 380, "Output",
 Evaluatable->False,
 CellTags->"b:0.9",
 CellID->257508985]
}, Open  ]],
Cell[539972, 14859, 170, 5, 70, "Text",
 CellTags->"b:0.9",
 CellID->355664394],
Cell[CellGroupData[{
Cell[540167, 14868, 167, 5, 28, "Input",
 CellTags->"b:0.9",
 CellID->23320521],
Cell[540337, 14875, 802, 17, 71, "Output",
 Evaluatable->False,
 CellTags->"b:0.9",
 CellID->828356546]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[541212, 14900, 62, 1, 70, "Subsection",
 CellID->903426436],
Cell[541277, 14903, 1241, 38, 70, "DefinitionBox",
 CellTags->"b:0.9",
 CellID->1436238083],
Cell[542521, 14943, 159, 7, 70, "Caption",
 CellTags->"b:0.9",
 CellID->91508867],
Cell[542683, 14952, 471, 15, 70, "Text",
 CellID->1582146954],
Cell[543157, 14969, 66, 1, 70, "MathCaption",
 CellID->8213],
Cell[543226, 14972, 766, 21, 70, "Input",
 CellID->23992],
Cell[543995, 14995, 138, 6, 70, "MathCaption",
 CellID->1368998428],
Cell[CellGroupData[{
Cell[544158, 15005, 148, 4, 70, "Input",
 CellID->2670],
Cell[544309, 15011, 5793, 167, 265, "Output",
 CellID->174452703]
}, Open  ]],
Cell[550117, 15181, 148, 4, 70, "MathCaption",
 CellID->124316864],
Cell[CellGroupData[{
Cell[550290, 15189, 173, 5, 70, "Input",
 CellID->6704],
Cell[550466, 15196, 6631, 191, 297, "Output",
 CellID->619079713]
}, Open  ]],
Cell[CellGroupData[{
Cell[557134, 15392, 99, 2, 70, "Subsubsection",
 CellTags->"b:0.10b",
 CellID->215116067],
Cell[557236, 15396, 533, 15, 70, "DefinitionBox3Col",
 CellTags->"b:0.10b",
 CellID->1837786448],
Cell[557772, 15413, 225, 7, 70, "Caption",
 CellTags->"b:0.10b",
 CellID->100920950],
Cell[558000, 15422, 1144, 36, 70, "Text",
 CellID->995232876],
Cell[559147, 15460, 71, 1, 70, "MathCaption",
 CellID->632762632],
Cell[559221, 15463, 1434, 36, 70, "Input",
 CellID->1064780346],
Cell[560658, 15501, 338, 11, 70, "MathCaption",
 CellID->22171],
Cell[CellGroupData[{
Cell[561021, 15516, 470, 14, 47, "Input",
 CellID->27489],
Cell[561494, 15532, 19655, 326, 265, "Output",
 Evaluatable->False,
 CellID->40609373]
}, Open  ]],
Cell[581164, 15861, 113, 3, 70, "MathCaption",
 CellID->683885067],
Cell[CellGroupData[{
Cell[581302, 15868, 230, 7, 70, "Input",
 CellID->1128541062],
Cell[581535, 15877, 11135, 311, 381, "Output",
 CellID->1886033168]
}, Open  ]],
Cell[592685, 16191, 138, 6, 70, "MathCaption",
 CellID->1160513182],
Cell[CellGroupData[{
Cell[592848, 16201, 135, 4, 70, "Input",
 CellID->2131783975],
Cell[592986, 16207, 598, 15, 36, "Output",
 CellID->1814343985]
}, Open  ]],
Cell[593599, 16225, 335, 12, 70, "MathCaption",
 CellID->677366046],
Cell[CellGroupData[{
Cell[593959, 16241, 277, 9, 28, "Input",
 CellID->2035749510],
Cell[594239, 16252, 4673, 81, 113, "Output",
 Evaluatable->False,
 CellID->57132572]
}, Open  ]],
Cell[598927, 16336, 68, 1, 70, "MathCaption",
 CellID->786998624],
Cell[CellGroupData[{
Cell[599020, 16341, 179, 5, 28, "Input",
 CellID->1506746652],
Cell[599202, 16348, 4740, 82, 219, "Output",
 Evaluatable->False,
 CellID->655772915]
}, Open  ]],
Cell[603957, 16433, 167, 5, 70, "MathCaption",
 CellID->179275190],
Cell[CellGroupData[{
Cell[604149, 16442, 250, 7, 28, "Input",
 CellID->1034168238],
Cell[604402, 16451, 8693, 147, 214, "Output",
 Evaluatable->False,
 CellID->589840619]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[613156, 16605, 53, 1, 70, "Subsection",
 CellID->1713593147],
Cell[613212, 16608, 555, 19, 70, "DefinitionBox",
 CellTags->"b:0.9",
 CellID->24398145],
Cell[613770, 16629, 90, 2, 70, "Caption",
 CellTags->"b:0.9",
 CellID->361807899],
Cell[613863, 16633, 289, 10, 70, "Text",
 CellID->31934],
Cell[614155, 16645, 161, 4, 70, "Text",
 CellID->942392630],
Cell[614319, 16651, 585, 20, 70, "Text",
 CellID->1615698730],
Cell[614907, 16673, 91, 1, 70, "MathCaption",
 CellID->233031439],
Cell[CellGroupData[{
Cell[615023, 16678, 217, 7, 70, "Input",
 CellID->1521358867],
Cell[615243, 16687, 224, 7, 36, "Output",
 CellID->349449370]
}, Open  ]],
Cell[615482, 16697, 260, 9, 70, "MathCaption",
 CellID->425094228],
Cell[615745, 16708, 477, 14, 70, "Input",
 CellID->1759281949],
Cell[CellGroupData[{
Cell[616247, 16726, 141, 4, 70, "Input",
 CellID->1854376424],
Cell[616391, 16732, 737, 22, 54, "Output",
 CellID->512486217]
}, Open  ]],
Cell[617143, 16757, 123, 3, 70, "MathCaption",
 CellID->410705247],
Cell[CellGroupData[{
Cell[617291, 16764, 201, 7, 70, "Input",
 CellID->187304895],
Cell[617495, 16773, 934, 29, 54, "Output",
 CellID->2030576091]
}, Open  ]],
Cell[618444, 16805, 97, 1, 70, "MathCaption",
 CellID->681995046],
Cell[CellGroupData[{
Cell[618566, 16810, 295, 7, 70, "Input",
 CellID->945400205],
Cell[618864, 16819, 2043, 48, 223, "Output",
 CellID->1391650768]
}, Open  ]],
Cell[620922, 16870, 318, 8, 70, "MathCaption",
 CellID->2138065999],
Cell[CellGroupData[{
Cell[621265, 16882, 216, 7, 70, "Input",
 CellID->569941009],
Cell[621484, 16891, 215, 7, 36, "Output",
 CellID->1766724519]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[621748, 16904, 71, 2, 70, "Section",
 CellTags->"b:0.12",
 CellID->1683113424],
Cell[621822, 16908, 249, 7, 70, "Text",
 CellTags->{"[1]", "b:0.12"},
 CellID->888998654],
Cell[622074, 16917, 283, 8, 70, "Text",
 CellTags->{"[2]", "b:0.12"},
 CellID->40602425],
Cell[622360, 16927, 220, 7, 70, "Text",
 CellTags->{"[3]", "b:0.12"},
 CellID->572165187],
Cell[622583, 16936, 299, 8, 70, "Text",
 CellTags->{"[4]", "b:0.12"},
 CellID->323587634],
Cell[622885, 16946, 260, 8, 70, "Text",
 CellTags->{"[5]", "b:0.12"},
 CellID->386606491],
Cell[623148, 16956, 549, 20, 70, "Text",
 CellTags->{"[6]", "b:0.12"},
 CellID->1216058703],
Cell[623700, 16978, 250, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->932091351],
Cell[623953, 16988, 342, 10, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->415327171],
Cell[624298, 17000, 542, 17, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1036137639],
Cell[624843, 17019, 314, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1643236012],
Cell[625160, 17029, 279, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->37930045],
Cell[625442, 17039, 292, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1261207572],
Cell[625737, 17049, 269, 6, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1821900176],
Cell[626009, 17057, 288, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->295452145],
Cell[626300, 17067, 274, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->899519486],
Cell[626577, 17077, 176, 5, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->988196327],
Cell[626756, 17084, 157, 4, 70, "Text",
 CellID->254836105]
}, Open  ]]
}, Open  ]],
Cell[626940, 17092, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

