(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11310,        400]
NotebookOptionsPosition[      8698,        315]
NotebookOutlinePosition[     10035,        352]
CellTagsIndexPosition[      9951,        347]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ClusterSplit" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/ClusterSplit"], 
          "ClusterFlatten" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/ClusterFlatten"], 
          "DendrogramPlot" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/DendrogramPlot"], "Agglomerate" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Agglomerate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ClusterSplit\"\>", 
       2->"\<\"ClusterFlatten\"\>", 3->"\<\"DendrogramPlot\"\>", 
       4->"\<\"Agglomerate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cluster", "ObjectName",
 CellID->2483],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Cluster", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["c", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["c", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["d", "TI"], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a merger of the clusters ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " with dissimilarity ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " data elements respectively."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27753]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A ",
 Cell[BoxData["Cluster"], "InlineFormula"],
 " object represents a cluster hierarchy of a data set."
}], "Notes",
 CellID->10383],

Cell[TextData[{
 "The clusters ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], "1"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " can be ",
 Cell[BoxData["Cluster"], "InlineFormula"],
 " objects or single data elements."
}], "Notes",
 CellID->14945],

Cell[TextData[{
 "The hierarchy may be viewed using ",
 Cell[BoxData[
  ButtonBox["DendrogramPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->403750047]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18367935],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->94134619],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->332829248],

Cell["Cluster obtained from hierarchical clustering:", "ExampleText",
 CellID->415170732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Agglomerate", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "5", ",", "2", ",", "10", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->517515733],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"Cluster", "[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], ",", 
       "5", ",", "9", ",", "2", ",", "1"}], "]"}], ",", "10", ",", "25", ",", 
     "3", ",", "1"}], "]"}], ",", "20", ",", "100", ",", "4", ",", "1"}], 
  "]"}]], "Output",
 ImageSize->{540, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->663120560]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2223],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClusterSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/ClusterSplit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClusterFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/ClusterFlatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DendrogramPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Agglomerate",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22142]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10067],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials",
 CellID->22848]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cluster - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 41.5081138}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "Cluster[c_1, c_2, d, n_1, n_2] represents a merger of the clusters c_1 \
and c_2 with dissimilarity d and n_1 and n_2 data elements respectively.", 
    "synonyms" -> {}, "title" -> "Cluster", "type" -> "Symbol", "uri" -> 
    "HierarchicalClustering/ref/Cluster"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5126, 180, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->18367935]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9809, 340}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1747, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2370, 70, 44, 1, 70, "ObjectName",
 CellID->2483],
Cell[2417, 73, 1404, 48, 70, "Usage",
 CellID->27753]
}, Open  ]],
Cell[CellGroupData[{
Cell[3858, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4336, 143, 152, 5, 70, "Notes",
 CellID->10383],
Cell[4491, 150, 346, 14, 70, "Notes",
 CellID->14945],
Cell[4840, 166, 249, 9, 70, "Notes",
 CellID->403750047]
}, Closed]],
Cell[CellGroupData[{
Cell[5126, 180, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18367935],
Cell[CellGroupData[{
Cell[5510, 194, 147, 5, 70, "ExampleSection",
 CellID->94134619],
Cell[5660, 201, 147, 4, 70, "Input",
 CellID->332829248],
Cell[5810, 207, 89, 1, 70, "ExampleText",
 CellID->415170732],
Cell[CellGroupData[{
Cell[5924, 212, 189, 6, 28, "Input",
 CellID->517515733],
Cell[6116, 220, 549, 16, 54, "Output",
 CellID->663120560]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6726, 243, 310, 9, 70, "SeeAlsoSection",
 CellID->2223],
Cell[7039, 254, 1071, 35, 70, "SeeAlso",
 CellID->22142]
}, Open  ]],
Cell[CellGroupData[{
Cell[8147, 294, 314, 9, 70, "TutorialsSection",
 CellID->10067],
Cell[8464, 305, 192, 5, 70, "Tutorials",
 CellID->22848]
}, Open  ]],
Cell[8671, 313, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

