(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12976,        468]
NotebookOptionsPosition[      9816,        361]
NotebookOutlinePosition[     11130,        398]
CellTagsIndexPosition[     11045,        393]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DirectAgglomerate" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/DirectAgglomerate"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"DirectAgglomerate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DistanceMatrix", "ObjectName",
 CellID->24155],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DistanceMatrix", "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a matrix of distances or dissimilarities between \
the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4833]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The elements of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " can be numeric lists, matrices, or tensors, lists of Boolean elements, or \
strings. All data elements must have the same dimensions."
}], "Notes",
 CellID->31115],

Cell[TextData[{
 Cell[BoxData["DistanceMatrix"], "InlineFormula"],
 " returns a symmetric matrix suitable for use by ",
 Cell[BoxData[
  ButtonBox["DirectAgglomerate",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/DirectAgglomerate"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->4639],

Cell[TextData[{
 "The method used to compute dissimilarities can be selected with the ",
 Cell[BoxData[
  ButtonBox["DistanceFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DistanceFunction"]], "InlineFormula"],
 " option. "
}], "Notes",
 CellID->22704],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DistanceFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DistanceFunction"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData["DistanceMatrix"], "InlineFormula"],
 " uses the square of ",
 Cell[BoxData[
  ButtonBox["EuclideanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EuclideanDistance"]], "InlineFormula"],
 " for numeric data, ",
 Cell[BoxData[
  ButtonBox["JaccardDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JaccardDissimilarity"]], "InlineFormula"],
 " for Boolean data, and ",
 Cell[BoxData[
  ButtonBox["EditDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EditDistance"]], "InlineFormula"],
 " for string data."
}], "Notes",
 CellID->900],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["DistanceFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DistanceFunction"]], "InlineFormula"],
 " can be any distance or dissimilarity function or a pure function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " defining a distance between two values."
}], "Notes",
 CellID->32591]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273134222],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->891641516],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->112252197],

Cell["Distance matrix for list of numbers:", "ExampleText",
 CellID->27638432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DistanceMatrix", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121000328],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "81", ",", "9", ",", "49"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "64", ",", "4", ",", "36"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", "64", ",", "0", ",", "36", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "4", ",", "36", ",", "0", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"49", ",", "36", ",", "4", ",", "16", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{378, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->475562127]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5402],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DistanceFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1757724783],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->451541288],

Cell[TextData[{
 "Distance matrix using ",
 Cell[BoxData[
  ButtonBox["ManhattanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ManhattanDistance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->141103965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DistanceMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"DistanceFunction", "->", "ManhattanDistance"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->146762761],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "9", ",", "3", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "8", ",", "2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "0", ",", "6", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "6", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6", ",", "2", ",", "4", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->712718053]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14902],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DirectAgglomerate",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/DirectAgglomerate"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->3561]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11903],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials",
 CellID->3676]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DistanceMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 42.4456378}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "DistanceMatrix[list] gives a matrix of distances or dissimilarities \
between the elements of list.", "synonyms" -> {}, "title" -> "DistanceMatrix",
     "type" -> "Symbol", "uri" -> 
    "HierarchicalClustering/ref/DistanceMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5143, 180, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->273134222]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10902, 386}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1291, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1914, 61, 52, 1, 70, "ObjectName",
 CellID->24155],
Cell[1969, 64, 512, 16, 70, "Usage",
 CellID->4833]
}, Open  ]],
Cell[CellGroupData[{
Cell[2518, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2996, 102, 263, 7, 70, "Notes",
 CellID->31115],
Cell[3262, 111, 315, 10, 70, "Notes",
 CellID->4639],
Cell[3580, 123, 265, 8, 70, "Notes",
 CellID->22704],
Cell[3848, 133, 883, 29, 70, "Notes",
 CellID->900],
Cell[4734, 164, 372, 11, 70, "Notes",
 CellID->32591]
}, Closed]],
Cell[CellGroupData[{
Cell[5143, 180, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273134222],
Cell[CellGroupData[{
Cell[5528, 194, 148, 5, 70, "ExampleSection",
 CellID->891641516],
Cell[5679, 201, 147, 4, 70, "Input",
 CellID->112252197],
Cell[5829, 207, 78, 1, 70, "ExampleText",
 CellID->27638432],
Cell[CellGroupData[{
Cell[5932, 212, 191, 6, 28, "Input",
 CellID->121000328],
Cell[6126, 220, 644, 18, 54, "Output",
 CellID->475562127]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6819, 244, 217, 7, 70, "ExampleSection",
 CellID->5402],
Cell[CellGroupData[{
Cell[7061, 255, 238, 7, 70, "ExampleSubsection",
 CellID->1757724783],
Cell[7302, 264, 147, 4, 70, "Input",
 CellID->451541288],
Cell[7452, 270, 223, 8, 70, "ExampleText",
 CellID->141103965],
Cell[CellGroupData[{
Cell[7700, 282, 271, 8, 70, "Input",
 CellID->146762761],
Cell[7974, 292, 632, 18, 36, "Output",
 CellID->712718053]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8679, 318, 311, 9, 70, "SeeAlsoSection",
 CellID->14902],
Cell[8993, 329, 236, 6, 70, "SeeAlso",
 CellID->3561]
}, Open  ]],
Cell[CellGroupData[{
Cell[9266, 340, 314, 9, 70, "TutorialsSection",
 CellID->11903],
Cell[9583, 351, 191, 5, 70, "Tutorials",
 CellID->3676]
}, Open  ]],
Cell[9789, 359, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

