(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9564,        331]
NotebookOptionsPosition[      6995,        248]
NotebookOutlinePosition[      8319,        285]
CellTagsIndexPosition[      8235,        280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HighlightStyle" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/HighlightStyle"], 
          "TruncateDendrogram" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/TruncateDendrogram"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"HighlightStyle\"\>", 
       2->"\<\"TruncateDendrogram\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HighlightLevel", "ObjectName",
 CellID->43703056],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["HighlightLevel"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["DendrogramPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"]], 
      "InlineFormula"],
     " that specifies the level at which to highlight the dendrogram."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->591964006]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["HighlightLevel"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " or a positive integer less than or equal to the number of clusters."
}], "Notes",
 CellID->56085878],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"HighLightLevel", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " distinct clusters are highlighted."
}], "Notes",
 CellID->414947758]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25628504],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->135663487],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->374425295],

Cell["Dendrogram highlighting the top 2 clusters:", "ExampleText",
 CellID->241812403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"HighlightLevel", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->318263060],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 1, 0], RectangleBox[{1, 0}], RectangleBox[{1.5, 0}, {3, 4}], 
    RectangleBox[{4, 0}, {5, 4}]}, {{}, {
     LineBox[{{1, 0}, {1, 1}, {2, 1}, {2, 0}}], 
     LineBox[{{1.5, 1}, {1.5, 4}, {3, 4}, {3, 0}}], 
     LineBox[{{4, 0}, {4, 4}, {5, 4}, {5, 0}}], 
     LineBox[{{2.25, 4}, {2.25, 16}, {4.5, 16}, {4.5, 4}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->262990787]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->226917397],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HighlightStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/HighlightStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TruncateDendrogram",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/TruncateDendrogram"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3847433]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->71759735],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials",
 CellID->54131287]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HighlightLevel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 46.3988640}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "HighlightLevel is an option for DendrogramPlot that specifies the level \
at which to highlight the dendrogram.", "synonyms" -> {}, "title" -> 
    "HighlightLevel", "type" -> "Symbol", "uri" -> 
    "HierarchicalClustering/ref/HighlightLevel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3848, 132, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25628504]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8093, 273}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1455, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2078, 64, 55, 1, 70, "ObjectName",
 CellID->43703056],
Cell[2136, 67, 574, 16, 70, "Usage",
 CellID->591964006]
}, Open  ]],
Cell[CellGroupData[{
Cell[2747, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3225, 105, 315, 10, 70, "Notes",
 CellID->56085878],
Cell[3543, 117, 268, 10, 70, "Notes",
 CellID->414947758]
}, Closed]],
Cell[CellGroupData[{
Cell[3848, 132, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25628504],
Cell[CellGroupData[{
Cell[4232, 146, 148, 5, 70, "ExampleSection",
 CellID->135663487],
Cell[4383, 153, 147, 4, 70, "Input",
 CellID->374425295],
Cell[4533, 159, 86, 1, 70, "ExampleText",
 CellID->241812403],
Cell[CellGroupData[{
Cell[4644, 164, 256, 7, 28, "Input",
 CellID->318263060],
Cell[4903, 173, 588, 14, 133, "Output",
 CellID->262990787]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5552, 194, 315, 9, 70, "SeeAlsoSection",
 CellID->226917397],
Cell[5870, 205, 531, 17, 70, "SeeAlso",
 CellID->3847433]
}, Open  ]],
Cell[CellGroupData[{
Cell[6438, 227, 317, 9, 70, "TutorialsSection",
 CellID->71759735],
Cell[6758, 238, 195, 5, 70, "Tutorials",
 CellID->54131287]
}, Open  ]],
Cell[6968, 246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

