(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9245,        324]
NotebookOptionsPosition[      6802,        247]
NotebookOutlinePosition[      8115,        284]
CellTagsIndexPosition[      8031,        279]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HighlightLevel" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/HighlightLevel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"HighlightLevel\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HighlightStyle", "ObjectName"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["HighlightStyle"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["DendrogramPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"]], 
      "InlineFormula"],
     " that specifies the style for highlighted clusters."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["HighlightStyle"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or a list of ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " directives."
}], "Notes",
 CellID->141348374],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"HighlightStyle", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " highlights clusters in ",
 Cell[BoxData[
  ButtonBox["Green",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Green"]], "InlineFormula"],
 "."
}], "Notes"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->626903090],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->380340631],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->627867394],

Cell[TextData[{
 "Dendrogram highlighting the ",
 "top 2 clusters",
 " in ",
 Cell[BoxData[
  ButtonBox["Blue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->255838559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"HighlightLevel", "\[Rule]", "2"}], ",", 
   RowBox[{"HighlightStyle", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81248909],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], RectangleBox[{1, 0}], RectangleBox[{1.5, 0}, {3, 4}], 
    RectangleBox[{4, 0}, {5, 4}]}, {{}, {
     LineBox[{{1, 0}, {1, 1}, {2, 1}, {2, 0}}], 
     LineBox[{{1.5, 1}, {1.5, 4}, {3, 4}, {3, 0}}], 
     LineBox[{{4, 0}, {4, 4}, {5, 4}, {5, 0}}], 
     LineBox[{{2.25, 4}, {2.25, 16}, {4.5, 16}, {4.5, 4}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->545780020]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection"],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["HighlightLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/HighlightLevel"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->3847433]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection"],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HighlightStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 46.5707434}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "HighlightStyle is an option for DendrogramPlot that specifies the style \
for highlighted clusters.", "synonyms" -> {}, "title" -> "HighlightStyle", 
    "type" -> "Symbol", "uri" -> 
    "HierarchicalClustering/ref/HighlightStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3810, 135, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->626903090]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7888, 272}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1282, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1905, 61, 36, 0, 70, "ObjectName"],
Cell[1944, 63, 542, 15, 70, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2523, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3001, 100, 408, 15, 70, "Notes",
 CellID->141348374],
Cell[3412, 117, 361, 13, 70, "Notes"]
}, Closed]],
Cell[CellGroupData[{
Cell[3810, 135, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->626903090],
Cell[CellGroupData[{
Cell[4195, 149, 148, 5, 70, "ExampleSection",
 CellID->380340631],
Cell[4346, 156, 147, 4, 70, "Input",
 CellID->627867394],
Cell[4496, 162, 231, 10, 70, "ExampleText",
 CellID->255838559],
Cell[CellGroupData[{
Cell[4752, 176, 311, 8, 28, "Input",
 CellID->81248909],
Cell[5066, 186, 588, 14, 133, "Output",
 CellID->545780020]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5715, 207, 295, 8, 70, "SeeAlsoSection"],
Cell[6013, 217, 233, 6, 70, "SeeAlso",
 CellID->3847433]
}, Open  ]],
Cell[CellGroupData[{
Cell[6283, 228, 298, 8, 70, "TutorialsSection"],
Cell[6584, 238, 176, 4, 70, "Tutorials"]
}, Open  ]],
Cell[6775, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

