(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10755,        379]
NotebookOptionsPosition[      8041,        291]
NotebookOutlinePosition[      9331,        327]
CellTagsIndexPosition[      9247,        322]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TruncateDendrogram" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/TruncateDendrogram"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"TruncateDendrogram\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LeafLabels", "ObjectName",
 CellID->214253414],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LeafLabels"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["DendrogramPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"]], 
      "InlineFormula"],
     " that specifies labels for the dendrogram leaves."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->76328695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For an input ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ", possible settings for ",
 Cell[BoxData["LeafLabels"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", a list of labels equal in length to the number of leaves, or a pure \
function."
}], "Notes",
 CellID->320411295],

Cell[TextData[{
 "For an input cluster ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 ", possible settings for ",
 Cell[BoxData["LeafLabels"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " or a pure function."
}], "Notes",
 CellID->585948588],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"LeafLabels", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the leaves are labeled according to the data element position."
}], "Notes",
 CellID->620318543],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"LeafLabels", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is a pure function, the leaf corresponding to the data element ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " is labeled with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->338359083],

Cell["\<\
For a truncated dendrogram, a boxed number is substituted for the label \
indicating the size of the truncated cluster.\
\>", "Notes",
 CellID->124339811]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->248502877],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->148736582],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->518611480],

Cell["\<\
Dendrogram labelling leaves with the associated data elements:\
\>", "ExampleText",
 CellID->386130532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"LeafLabels", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"#", "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->311966421],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[
    0, 1, 0]}, {{}, {LineBox[{{1, 0}, {1, 1}, {2, 1}, {2, 0}}], 
     LineBox[{{1.5, 1}, {1.5, 4}, {3, 4}, {3, 0}}], 
     LineBox[{{4, 0}, {4, 4}, {5, 4}, {5, 0}}], 
     LineBox[{{2.25, 4}, {2.25, 16}, {4.5, 16}, {4.5, 4}}]}}, {
    InsetBox["1", Offset[{0., -4.}, {1, 0}], {0, 1}], 
    InsetBox["2", Offset[{0., -4.}, {2, 0}], {0, 1}], 
    InsetBox["4", Offset[{0., -4.}, {3, 0}], {0, 1}], 
    InsetBox["8", Offset[{0., -4.}, {4, 0}], {0, 1}], 
    InsetBox["10", Offset[{0., -4.}, {5, 0}], {0, 1}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177563390]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->191839085],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["TruncateDendrogram",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/TruncateDendrogram"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->48787272]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->282169970],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials",
 CellID->65187721]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LeafLabels - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 46.7582482}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "LeafLabels is an option for DendrogramPlot that specifies labels for the \
dendrogram leaves.", "synonyms" -> {}, "title" -> "LeafLabels", "type" -> 
    "Symbol", "uri" -> "HierarchicalClustering/ref/LeafLabels"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4928, 178, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->248502877]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9104, 315}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1294, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1917, 61, 52, 1, 70, "ObjectName",
 CellID->214253414],
Cell[1972, 64, 555, 16, 70, "Usage",
 CellID->76328695]
}, Open  ]],
Cell[CellGroupData[{
Cell[2564, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3042, 102, 536, 19, 70, "Notes",
 CellID->320411295],
Cell[3581, 123, 352, 13, 70, "Notes",
 CellID->585948588],
Cell[3936, 138, 295, 9, 70, "Notes",
 CellID->620318543],
Cell[4234, 149, 490, 18, 70, "Notes",
 CellID->338359083],
Cell[4727, 169, 164, 4, 70, "Notes",
 CellID->124339811]
}, Closed]],
Cell[CellGroupData[{
Cell[4928, 178, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->248502877],
Cell[CellGroupData[{
Cell[5313, 192, 148, 5, 70, "ExampleSection",
 CellID->148736582],
Cell[5464, 199, 147, 4, 70, "Input",
 CellID->518611480],
Cell[5614, 205, 113, 3, 70, "ExampleText",
 CellID->386130532],
Cell[CellGroupData[{
Cell[5752, 212, 298, 9, 28, "Input",
 CellID->311966421],
Cell[6053, 223, 772, 18, 144, "Output",
 CellID->177563390]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6886, 248, 315, 9, 70, "SeeAlsoSection",
 CellID->191839085],
Cell[7204, 259, 242, 6, 70, "SeeAlso",
 CellID->48787272]
}, Open  ]],
Cell[CellGroupData[{
Cell[7483, 270, 318, 9, 70, "TutorialsSection",
 CellID->282169970],
Cell[7804, 281, 195, 5, 70, "Tutorials",
 CellID->65187721]
}, Open  ]],
Cell[8014, 289, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

