(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12501,        427]
NotebookOptionsPosition[      9795,        338]
NotebookOutlinePosition[     11110,        375]
CellTagsIndexPosition[     11025,        370]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Agglomerate" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Agglomerate"], "FindClusters" :> 
          Documentation`HelpLookup["paclet:ref/FindClusters"], 
          "DendrogramPlot" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/DendrogramPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Agglomerate\"\>", 
       2->"\<\"FindClusters\"\>", 
       3->"\<\"DendrogramPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Linkage", "ObjectName",
 CellID->30524],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Linkage"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Agglomerate",
       BaseStyle->"Link",
       ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"]], 
      "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["DendrogramPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"]], 
      "InlineFormula"],
     " that specifies the linkage method for agglomerative clustering."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9894]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Linkage"], "InlineFormula"],
 " defines the intercluster dissimilarity, given the dissimilarities between \
member elements."
}], "Notes",
 CellID->6483],

Cell[TextData[{
 "Possible settings for the ",
 Cell[BoxData["Linkage"], "InlineFormula"],
 " option include:"
}], "Notes",
 CellID->27595],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Single\>\"", Cell[
    "smallest intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Average\>\"", Cell[
    "average intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Complete\>\"", Cell[
    "largest intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Weighted\>\"", Cell[
    "weighted average intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Centroid\>\"", Cell[
    "distance from cluster centroids", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Median\>\"", Cell[
    "distance from cluster medians", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Ward\>\"", Cell[
    "Ward's minimum variance dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["f", "TI"], Cell["a pure function", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->16941],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " defines a distance from a cluster ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " to the new cluster formed by fusing clusters ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21724],

Cell[TextData[{
 "The arguments supplied to ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["d", "TI"], 
    StyleBox["ik", "TI"]], ",", 
   SubscriptBox[
    StyleBox["d", "TI"], 
    StyleBox["jk", "TI"]], ",", 
   SubscriptBox[
    StyleBox["d", "TI"], 
    StyleBox["ij", "TI"]], ",", 
   SubscriptBox[
    StyleBox["n", "TI"], 
    StyleBox["i", "TI"]], ",", 
   SubscriptBox[
    StyleBox["n", "TI"], 
    StyleBox["j", "TI"]], ","}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is the distance between clusters and ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the number of elements in a cluster."
}], "Notes",
 CellID->25939219]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->412727341],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->198476771],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->205177028],

Cell["Agglomerative clustering using Ward's linkage:", "ExampleText",
 CellID->158038108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Agglomerate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"Linkage", "\[Rule]", "\"\<Ward\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23591188],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{"1", ",", "2", ",", 
       FractionBox["1", "2"], ",", "1", ",", "1"}], "]"}], ",", "4", ",", 
     FractionBox["25", "6"], ",", "2", ",", "1"}], "]"}], ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{"8", ",", "10", ",", "2", ",", "1", ",", "1"}], "]"}], ",", 
   FractionBox["160", "3"], ",", "3", ",", "2"}], "]"}]], "Output",
 ImageSize->{361, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112549142]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22925],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Agglomerate",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindClusters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindClusters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DendrogramPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10910]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->330],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials",
 CellID->31923]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linkage - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 46.9457530}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "Linkage is an option for Agglomerate and DendrogramPlot that specifies \
the linkage method for agglomerative clustering.", "synonyms" -> {}, "title" -> 
    "Linkage", "type" -> "Symbol", "uri" -> 
    "HierarchicalClustering/ref/Linkage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6412, 211, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->412727341]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10882, 363}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1551, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2174, 66, 45, 1, 70, "ObjectName",
 CellID->30524],
Cell[2222, 69, 747, 22, 70, "Usage",
 CellID->9894]
}, Open  ]],
Cell[CellGroupData[{
Cell[3006, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3484, 113, 184, 5, 70, "Notes",
 CellID->6483],
Cell[3671, 120, 139, 5, 70, "Notes",
 CellID->27595],
Cell[3813, 127, 1267, 25, 70, "2ColumnTableMod",
 CellID->16941],
Cell[5083, 154, 396, 15, 70, "Notes",
 CellID->21724],
Cell[5482, 171, 893, 35, 70, "Notes",
 CellID->25939219]
}, Closed]],
Cell[CellGroupData[{
Cell[6412, 211, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->412727341],
Cell[CellGroupData[{
Cell[6797, 225, 148, 5, 70, "ExampleSection",
 CellID->198476771],
Cell[6948, 232, 147, 4, 70, "Input",
 CellID->205177028],
Cell[7098, 238, 89, 1, 70, "ExampleText",
 CellID->158038108],
Cell[CellGroupData[{
Cell[7212, 243, 256, 7, 28, "Input",
 CellID->23591188],
Cell[7471, 252, 595, 16, 81, "Output",
 CellID->112549142]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8127, 275, 311, 9, 70, "SeeAlsoSection",
 CellID->22925],
Cell[8441, 286, 768, 26, 70, "SeeAlso",
 CellID->10910]
}, Open  ]],
Cell[CellGroupData[{
Cell[9246, 317, 312, 9, 70, "TutorialsSection",
 CellID->330],
Cell[9561, 328, 192, 5, 70, "Tutorials",
 CellID->31923]
}, Open  ]],
Cell[9768, 336, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

