(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     93553,       2696]
NotebookOptionsPosition[     84764,       2398]
NotebookOutlinePosition[     86608,       2442]
CellTagsIndexPosition[     86565,       2439]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Agglomerate" :> 
         Documentation`HelpLookup[
          "paclet:HierarchicalClustering/ref/Agglomerate"], "Cluster" :> 
         Documentation`HelpLookup[
          "paclet:HierarchicalClustering/ref/Cluster"], "ClusterFlatten" :> 
         Documentation`HelpLookup[
          "paclet:HierarchicalClustering/ref/ClusterFlatten"], "ClusterSplit" :> 
         Documentation`HelpLookup[
          "paclet:HierarchicalClustering/ref/ClusterSplit"], "DendrogramPlot" :> 
         Documentation`HelpLookup[
          "paclet:HierarchicalClustering/ref/DendrogramPlot"], 
         "DirectAgglomerate" :> 
         Documentation`HelpLookup[
          "paclet:HierarchicalClustering/ref/DirectAgglomerate"], 
         "DistanceMatrix" :> 
         Documentation`HelpLookup[
          "paclet:HierarchicalClustering/ref/DistanceMatrix"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Agglomerate\"\>", 
      2->"\<\"Cluster\"\>", 3->"\<\"ClusterFlatten\"\>", 
      4->"\<\"ClusterSplit\"\>", 5->"\<\"DendrogramPlot\"\>", 
      6->"\<\"DirectAgglomerate\"\>", 
      7->"\<\"DistanceMatrix\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hierarchical Clustering Package", "Title",
 CellID->2948],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " finds clusters in a data set based on a distance or dissimilarity \
function. This package contains functions for generating cluster hierarchies \
and visualizing the mergers in the hierarchical clustering."
}], "Text",
 CellID->326425833],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Agglomerate",
      BaseStyle->"Link",
      ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "collects the elements of ",
     StyleBox["data", "TI"],
     " into a hierarchy of clusters"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->755],

Cell[TextData[StyleBox["Hierarchical clustering function.",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}}]], "Caption",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25611],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Agglomerate",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"]], 
  "InlineFormula"],
 " function computes a cluster hierarchy of a data set. ",
 Cell[BoxData[
  ButtonBox["Agglomerate",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"]], 
  "InlineFormula"],
 " accepts data in the same forms accepted by ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 ". The output from ",
 Cell[BoxData[
  ButtonBox["Agglomerate",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"]], 
  "InlineFormula"],
 " is a nested ",
 Cell[BoxData[
  ButtonBox["Cluster",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Cluster"]], 
  "InlineFormula"],
 " object representing the hierarchical clustering."
}], "Text",
 CellID->21425],

Cell["This loads the package.", "MathCaption",
 CellID->373720925],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[25]:=",
 CellID->716428967],

Cell["Here is a small numerical data set.", "MathCaption",
 CellID->6298],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7253055971477931`", ",", 
       RowBox[{"-", "1.1302536982240747`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5810146986977534`", ",", "1.4463710601068265`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"0.8460694069050189`", ",", "2.0329569918374406`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"0.2169129449840166`", ",", 
       RowBox[{"-", "0.33368074105304846`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.02675560596423776`"}], ",", "1.1506670168024957`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.38070042430357054`"}], ",", 
       RowBox[{"-", "0.24750818092033833`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.4423867332670177`", ",", "1.9380008134953024`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.3152439519516439`"}], ",", 
       RowBox[{"-", "0.2760546508444408`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.1616304061543707`", ",", "0.794607673348773`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.25171211458875775`"}], ",", "2.0210234868823256`"}], 
      "}"}]}], "}"}]}], ";"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[25]:=",
 CellID->10240],

Cell["This constructs a hierarchical clustering of the data.", "MathCaption",
 CellID->21086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cl", "=", 
  RowBox[{"Agglomerate", "[", "data", "]"}]}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[26]:=",
 CellID->12483],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.7253055971477931`", ",", 
         RowBox[{"-", "1.1302536982240747`"}]}], "}"}], ",", 
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.2169129449840166`", ",", 
           RowBox[{"-", "0.33368074105304846`"}]}], "}"}], ",", 
         RowBox[{"Cluster", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.3152439519516439`"}], ",", 
             RowBox[{"-", "0.2760546508444408`"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.38070042430357054`"}], ",", 
             RowBox[{"-", "0.24750818092033833`"}]}], "}"}], ",", 
           "0.005099450717886225`", ",", "1", ",", "1"}], "]"}], ",", 
         "0.28651172922892176`", ",", "1", ",", "2"}], "]"}], ",", 
       "0.8929915648703123`", ",", "1", ",", "3"}], "]"}], ",", 
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"Cluster", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.02675560596423776`"}], ",", 
             "1.1506670168024957`"}], "}"}], ",", 
           RowBox[{"Cluster", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.5810146986977534`", ",", "1.4463710601068265`"}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.8460694069050189`", ",", "2.0329569918374406`"}], 
              "}"}], ",", "0.4143370536471114`", ",", "1", ",", "1"}], "]"}], 
           ",", "0.456825624455459`", ",", "1", ",", "2"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.1616304061543707`", ",", "0.794607673348773`"}], "}"}], 
         ",", "0.7619101120636763`", ",", "3", ",", "1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.25171211458875775`"}], ",", "2.0210234868823256`"}], 
        "}"}], ",", "0.8081258157823555`", ",", "4", ",", "1"}], "]"}], ",", 
     "2.0801708179565495`", ",", "4", ",", "5"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4423867332670177`", ",", "1.9380008134953024`"}], "}"}], ",", 
   "2.5572456822488645`", ",", "9", ",", "1"}], "]"}]], "Output",
 ImageSize->{536, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->224452338]
}, Open  ]],

Cell["Here is some Boolean data.", "MathCaption",
 CellID->19999],

Cell[BoxData[
 RowBox[{
  RowBox[{"bdata", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
       "True", ",", "False", ",", "False", ",", "True", ",", "True"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
       "False", ",", "False", ",", "False", ",", "False", ",", "True"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
       "False", ",", "True", ",", "False", ",", "True", ",", "True"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "True", ",", "False", ",", "False", ",", "True", ",", 
       "False", ",", "False", ",", "False", ",", "True", ",", "True"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "True", ",", "False", ",", "False", ",", "True", ",", 
       "True", ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]}], 
    "}"}]}], ";"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[27]:=",
 CellID->30627],

Cell["This clusters the Boolean data.", "MathCaption",
 CellID->10573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Agglomerate", "[", "bdata", "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[28]:=",
 CellID->22304],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
     "True", ",", "False", ",", "False", ",", "True", ",", "True"}], "}"}], 
   ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "True", ",", "True", ",", "False", ",", "False", ",", "True", ",", 
           "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "True", ",", "True", ",", "False", ",", "False", ",", "True", ",", 
           "False", ",", "False", ",", "False", ",", "True", ",", "True"}], 
          "}"}], ",", 
         FractionBox["3", "8"], ",", "1", ",", "1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "True", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
         "False", ",", "True", ",", "False", ",", "True", ",", "True"}], 
        "}"}], ",", 
       FractionBox["5", "9"], ",", "2", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
       "False", ",", "False", ",", "False", ",", "False", ",", "True"}], 
      "}"}], ",", 
     FractionBox["3", "5"], ",", "3", ",", "1"}], "]"}], ",", 
   FractionBox["5", "8"], ",", "1", ",", "4"}], "]"}]], "Output",
 ImageSize->{571, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->267055195]
}, Open  ]],

Cell["Here is some string data.", "MathCaption",
 CellID->22244],

Cell[BoxData[
 RowBox[{
  RowBox[{"sdata", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<The\>\"", ",", "\"\<quick\>\"", ",", "\"\<brown\>\"", ",", 
     "\"\<fox\>\"", ",", "\"\<jumps\>\"", ",", "\"\<over\>\"", ",", 
     "\"\<the\>\"", ",", "\"\<lazy\>\"", ",", "\"\<dog\>\""}], "}"}]}], 
  ";"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[29]:=",
 CellID->23615],

Cell["This clusters the string data.", "MathCaption",
 CellID->29294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Agglomerate", "[", "sdata", "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[15]:=",
 CellID->31696],

Cell[BoxData[
 RowBox[{
  RowBox[{"Agglomerate", "::", "\<\"ties\"\>"}], ":", 
  " ", "\<\"\\!\\(2\\) ties have been detected; reordering input may produce \
a different result. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:HierarchicalClustering/ref/Agglomerate\\\", ButtonNote \
-> \\\"HierarchicalClustering`Agglomerate::ties\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellLabel->"During evaluation of In[15]:=",
 CellID->304934388],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"Cluster", "[", 
          RowBox[{
           RowBox[{"Cluster", "[", 
            
            RowBox[{"\<\"The\"\>", ",", "\<\"the\"\>", ",", "1", ",", "1", 
             ",", "1"}], "]"}], ",", 
           RowBox[{"Cluster", "[", 
            
            RowBox[{"\<\"dog\"\>", ",", "\<\"fox\"\>", ",", "2", ",", "1", 
             ",", "1"}], "]"}], ",", "3", ",", "2", ",", "2"}], "]"}], 
         ",", "\<\"over\"\>", ",", "3", ",", "4", ",", "1"}], "]"}], 
       ",", "\<\"lazy\"\>", ",", "4", ",", "5", ",", "1"}], "]"}], 
     ",", "\<\"brown\"\>", ",", "4", ",", "6", ",", "1"}], "]"}], ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{"\<\"jumps\"\>", ",", "\<\"quick\"\>", ",", "4", ",", "1", ",", 
     "1"}], "]"}], ",", "5", ",", "7", ",", "2"}], "]"}]], "Output",
 ImageSize->{480, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1136277374]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Cluster",
      BaseStyle->"Link",
      ButtonData->"paclet:HierarchicalClustering/ref/Cluster"], "[", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["d", "TI"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["2", "TR"]], "]"}], Cell[TextData[{
     "represents a merger in the cluster hierarchy where the elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " are the subclusters merged with distance or dissimilarity value ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     ", and the subclusters contain ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " data elements respectively"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->26801],

Cell["An element of the cluster hierarchy.", "Caption",
 CellID->6134],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ClusterFlatten",
      BaseStyle->"Link",
      ButtonData->"paclet:HierarchicalClustering/ref/ClusterFlatten"], "[", 
     StyleBox["cluster", "TI"], "]"}], Cell[TextData[{
     "flattens ",
     StyleBox["cluster", "TI"],
     " returning a list of the data elements contained in the cluster"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ClusterSplit",
      BaseStyle->"Link",
      ButtonData->"paclet:HierarchicalClustering/ref/ClusterSplit"], "[", 
     RowBox[{
      StyleBox["cluster", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "splits ",
     StyleBox["cluster", "TI"],
     " into ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " clusters, effectively undoing the last n-1 mergers"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->109852281],

Cell[TextData[{
 "Functions for manipulating ",
 Cell[BoxData[
  ButtonBox["Cluster",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Cluster"]], 
  "InlineFormula"],
 " expressions."
}], "Caption",
 CellID->25532],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ClusterFlatten",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/ClusterFlatten"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ClusterSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/ClusterSplit"]], 
  "InlineFormula"],
 " functions are utilities for manipulating ",
 Cell[BoxData[
  ButtonBox["Cluster",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Cluster"]], 
  "InlineFormula"],
 " objects."
}], "Text",
 CellID->22901],

Cell["\<\
This splits the clustering from the numerical data into the top 3 \
subclusters.\
\>", "MathCaption",
 CellID->30731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClusterSplit", "[", 
  RowBox[{"cl", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->14777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7253055971477931`", ",", 
       RowBox[{"-", "1.1302536982240747`"}]}], "}"}], ",", 
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.2169129449840166`", ",", 
         RowBox[{"-", "0.33368074105304846`"}]}], "}"}], ",", 
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.3152439519516439`"}], ",", 
           RowBox[{"-", "0.2760546508444408`"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.38070042430357054`"}], ",", 
           RowBox[{"-", "0.24750818092033833`"}]}], "}"}], ",", 
         "0.005099450717886225`", ",", "1", ",", "1"}], "]"}], ",", 
       "0.28651172922892176`", ",", "1", ",", "2"}], "]"}], ",", 
     "0.8929915648703123`", ",", "1", ",", "3"}], "]"}], ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.02675560596423776`"}], ",", 
           "1.1506670168024957`"}], "}"}], ",", 
         RowBox[{"Cluster", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.5810146986977534`", ",", "1.4463710601068265`"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.8460694069050189`", ",", "2.0329569918374406`"}], 
            "}"}], ",", "0.4143370536471114`", ",", "1", ",", "1"}], "]"}], 
         ",", "0.456825624455459`", ",", "1", ",", "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1616304061543707`", ",", "0.794607673348773`"}], "}"}], 
       ",", "0.7619101120636763`", ",", "3", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.25171211458875775`"}], ",", "2.0210234868823256`"}], 
      "}"}], ",", "0.8081258157823555`", ",", "4", ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4423867332670177`", ",", "1.9380008134953024`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{539, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->233526966]
}, Open  ]],

Cell["This flattens the cluster.", "MathCaption",
 CellID->28146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClusterFlatten", "[", "cl", "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->2129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.7253055971477931`", ",", 
     RowBox[{"-", "1.1302536982240747`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2169129449840166`", ",", 
     RowBox[{"-", "0.33368074105304846`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3152439519516439`"}], ",", 
     RowBox[{"-", "0.2760546508444408`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.38070042430357054`"}], ",", 
     RowBox[{"-", "0.24750818092033833`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.02675560596423776`"}], ",", "1.1506670168024957`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5810146986977534`", ",", "1.4463710601068265`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8460694069050189`", ",", "2.0329569918374406`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1616304061543707`", ",", "0.794607673348773`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.25171211458875775`"}], ",", "2.0210234868823256`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4423867332670177`", ",", "1.9380008134953024`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{559, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->421427787]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["option", "TI"], 
     StyleBox[" ", "TI"], 
     StyleBox["name", "TI"], " "}], 
    RowBox[{
     StyleBox["default", "TI"], 
     StyleBox[" ", "TI"], 
     StyleBox["value", "TI"], " "}], ""},
   {
    ButtonBox["DistanceFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DistanceFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style for the line", "TableText"]},
   {
    ButtonBox["Linkage",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/Linkage"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the clustering linkage algorithm to use", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->19253],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["Agglomerate",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellID->12592],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["DistanceFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DistanceFunction"]], "InlineFormula"],
 " option is the same as for ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["DistanceFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DistanceFunction"]], "InlineFormula"],
 " defines the distance or dissimilarity between data points, while ",
 Cell[BoxData[
  ButtonBox["Linkage",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Linkage"]], 
  "InlineFormula"],
 " defines the dissimilarity between clusters of data points."
}], "Text",
 CellID->12413],

Cell[BoxData[GridBox[{
   {"\"\<Single\>\"", Cell[
    "smallest intercluster dissimilarity", "TableText"]},
   {"\"\<Average\>\"", Cell[
    "average intercluster dissimilarity", "TableText"]},
   {"\"\<Complete\>\"", Cell[
    "largest intercluster dissimilarity", "TableText"]},
   {"\"\<Weighted\>\"", Cell[
    "weighted average intercluster dissimilarity", "TableText"]},
   {"\"\<Centroid\>\"", Cell[
    "distance from cluster centroids", "TableText"]},
   {"\"\<Median\>\"", Cell["distance from cluster medians ", "TableText"]},
   {"\"\<Ward\>\"", Cell["\<\
Ward\[CloseCurlyQuote]s minimum variance dissimilarity\
\>", "TableText"]},
   {
    StyleBox["f", "TI"], Cell["a pure function", "TableText"]}
  }]], "DefinitionBox",
 CellID->10233],

Cell[TextData[{
 "Possible values for the ",
 Cell[BoxData[
  ButtonBox["Linkage",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Linkage"]], 
  "InlineFormula"],
 " option."
}], "Caption",
 CellID->29004],

Cell["\<\
Linkage methods determine the intercluster dissimilarity, or fusion level, \
given the dissimilarities between member elements. Common algorithms include \
single linkage, which selects the smallest distance between elements; \
complete linkage, which selects the largest distance between elements; and \
centroid linkage, which uses the dissimilarity between cluster centroids.\
\>", "Text",
 CellID->5680],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Linkage",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Linkage"], "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is a pure function that defines the linkage algorithm. Distances or \
dissimilarities between clusters are determined recursively using information \
about the distances or dissimilarities of the unmerged clusters and their \
counterparts to determine the distances or dissimilarities for the newly \
merged cluster. If ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 " represent clusters to be merged, new distances or dissimilarities are \
recursively calculated between this merged cluster and the remaining ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " clusters. The function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " defines the recursion and is passed arguments ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["d", "TI"], 
     StyleBox["ik", "TI"]], ",", 
    SubscriptBox[
     StyleBox["d", "TI"], 
     StyleBox["jk", "TI"]], ",", 
    SubscriptBox[
     StyleBox["d", "TI"], 
     StyleBox["ij", "TI"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["j", "TI"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["k", "TI"]]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " represents the distances or dissimilarities between clusters and ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " represents the number of data elements in a cluster. The function returns \
the dissimilarity between ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " and the cluster formed by merging clusters ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->13404],

Cell[TextData[{
 "This clusters ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " using the average linkage method."
}], "MathCaption",
 CellID->17662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Agglomerate", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Linkage", "\[Rule]", "\"\<Average\>\""}]}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[33]:=",
 CellID->23704],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7253055971477931`", ",", 
       RowBox[{"-", "1.1302536982240747`"}]}], "}"}], ",", 
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.2169129449840166`", ",", 
         RowBox[{"-", "0.33368074105304846`"}]}], "}"}], ",", 
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.38070042430357054`"}], ",", 
           RowBox[{"-", "0.24750818092033833`"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.3152439519516439`"}], ",", 
           RowBox[{"-", "0.2760546508444408`"}]}], "}"}], ",", 
         "0.005099450717886225`", ",", "1", ",", "1"}], "]"}], ",", 
       "0.32553958925000465`", ",", "1", ",", "2"}], "]"}], ",", 
     "1.5692933031173812`", ",", "1", ",", "3"}], "]"}], ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"Cluster", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.5810146986977534`", ",", "1.4463710601068265`"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.8460694069050189`", ",", "2.0329569918374406`"}], 
            "}"}], ",", "0.4143370536471114`", ",", "1", ",", "1"}], "]"}], 
         ",", 
         RowBox[{"Cluster", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.25171211458875775`"}], ",", 
             "2.0210234868823256`"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.02675560596423776`"}], ",", 
             "1.1506670168024957`"}], "}"}], ",", "0.8081258157823555`", ",", 
           "1", ",", "1"}], "]"}], ",", "1.056502690557956`", ",", "2", ",", 
         "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1616304061543707`", ",", "0.794607673348773`"}], "}"}], 
       ",", "1.858917572349461`", ",", "4", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.4423867332670177`", ",", "1.9380008134953024`"}], "}"}], ",",
      "4.638591151045734`", ",", "5", ",", "1"}], "]"}], ",", 
   "6.1180264431022895`", ",", "4", ",", "6"}], "]"}]], "Output",
 ImageSize->{584, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->711667788]
}, Open  ]],

Cell["\<\
The following uses a pure function equivalent to the average linkage.\
\>", "MathCaption",
 CellID->32535],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Agglomerate", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Linkage", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"#1", " ", 
        FractionBox["#4", 
         RowBox[{"#4", "+", "#5"}]]}], "+", 
       RowBox[{"#2", " ", 
        FractionBox["#5", 
         RowBox[{"#4", "+", "#5"}]]}]}], "&"}], ")"}]}]}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[34]:=",
 CellID->21780],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7253055971477931`", ",", 
       RowBox[{"-", "1.1302536982240747`"}]}], "}"}], ",", 
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.2169129449840166`", ",", 
         RowBox[{"-", "0.33368074105304846`"}]}], "}"}], ",", 
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.38070042430357054`"}], ",", 
           RowBox[{"-", "0.24750818092033833`"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.3152439519516439`"}], ",", 
           RowBox[{"-", "0.2760546508444408`"}]}], "}"}], ",", 
         "0.005099450717886225`", ",", "1", ",", "1"}], "]"}], ",", 
       "0.32553958925000465`", ",", "1", ",", "2"}], "]"}], ",", 
     "1.569293303117381`", ",", "1", ",", "3"}], "]"}], ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"Cluster", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.5810146986977534`", ",", "1.4463710601068265`"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.8460694069050189`", ",", "2.0329569918374406`"}], 
            "}"}], ",", "0.4143370536471114`", ",", "1", ",", "1"}], "]"}], 
         ",", 
         RowBox[{"Cluster", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.25171211458875775`"}], ",", 
             "2.0210234868823256`"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.02675560596423776`"}], ",", 
             "1.1506670168024957`"}], "}"}], ",", "0.8081258157823555`", ",", 
           "1", ",", "1"}], "]"}], ",", "1.056502690557956`", ",", "2", ",", 
         "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1616304061543707`", ",", "0.794607673348773`"}], "}"}], 
       ",", "1.858917572349461`", ",", "4", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.4423867332670177`", ",", "1.9380008134953024`"}], "}"}], ",",
      "4.638591151045734`", ",", "5", ",", "1"}], "]"}], ",", 
   "6.118026443102289`", ",", "4", ",", "6"}], "]"}]], "Output",
 ImageSize->{584, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->124069737]
}, Open  ]],

Cell[TextData[{
 "Elements can be labeled using a list of rules or a single rule. Distances \
or dissimilarities between elements are computed using the expression on the \
left\[Hyphen]hand sides of the rules. The output ",
 StyleBox[ButtonBox["Cluster",
  BaseStyle->"Link",
  ButtonData->"paclet:HierarchicalClustering/ref/Cluster"], "MR"],
 " object contains the right\[Hyphen]hand sides of the rules."
}], "Text",
 CellID->15371],

Cell["This clusters the data showing results by label.", "MathCaption",
 CellID->13237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Agglomerate", "[", 
  RowBox[{"data", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
    "\"\<a\>\"", ",", "\"\<b\>\"", ",", " ", "\"\<c\>\"", ",", " ", 
     "\"\<d\>\"", ",", " ", "\"\<e\>\"", ",", " ", "\"\<f\>\"", ",", " ", 
     "\"\<g\>\"", ",", " ", "\"\<h\>\"", ",", " ", "\"\<i\>\"", ",", " ", 
     "\"\<j\>\""}], "}"}]}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[35]:=",
 CellID->25270],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{"\<\"a\"\>", ",", 
       RowBox[{"Cluster", "[", 
        RowBox[{"\<\"d\"\>", ",", 
         RowBox[{"Cluster", "[", 
          
          RowBox[{"\<\"h\"\>", ",", "\<\"f\"\>", ",", "0.005099450717886225`",
            ",", "1", ",", "1"}], "]"}], ",", "0.28651172922892176`", ",", 
         "1", ",", "2"}], "]"}], ",", "0.8929915648703123`", ",", "1", ",", 
       "3"}], "]"}], ",", 
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"Cluster", "[", 
          RowBox[{"\<\"e\"\>", ",", 
           RowBox[{"Cluster", "[", 
            
            RowBox[{"\<\"b\"\>", ",", "\<\"c\"\>", ",", "0.4143370536471114`",
              ",", "1", ",", "1"}], "]"}], ",", "0.456825624455459`", ",", 
           "1", ",", "2"}], "]"}], ",", "\<\"i\"\>", ",", 
         "0.7619101120636763`", ",", "3", ",", "1"}], "]"}], ",", "\<\"j\"\>",
        ",", "0.8081258157823555`", ",", "4", ",", "1"}], "]"}], ",", 
     "2.0801708179565495`", ",", "4", ",", "5"}], "]"}], ",", "\<\"g\"\>", 
   ",", "2.5572456822488645`", ",", "9", ",", "1"}], "]"}]], "Output",
 ImageSize->{534, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->44020661]
}, Open  ]],

Cell[TextData[{
 "It is also possible to build a cluster hierarchy directly using a distance \
or dissimilarity matrix\[LongDash]a matrix that provides the pairwise \
distances or dissimilarities between all data elements in lieu of a distance \
or dissimilarity function. In a distance matrix the element in the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " row and ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["j", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " column stores the distance value between the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["j", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " data elements. Note that only the upper\[Hyphen]triangular portion of the \
matrix is used, that is ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], "<", 
   StyleBox["j", "TI"]}]], "InlineFormula"],
 ", since distances and dissimilarities are symmetric."
}], "Text",
 CellID->32565],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DistanceMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:HierarchicalClustering/ref/DistanceMatrix"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "computes the symmetric matrix of distance or dissimilarity", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["DirectAgglomerate",
      BaseStyle->"Link",
      ButtonData->"paclet:HierarchicalClustering/ref/DirectAgglomerate"], "[",
      
     StyleBox["mat", "TI"], "]"}], Cell[TextData[{
     "constructs a cluster hierarchy based on the square distance matrix",
     " ",
     StyleBox["mat", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DirectAgglomerate",
      BaseStyle->"Link",
      ButtonData->"paclet:HierarchicalClustering/ref/DirectAgglomerate"], "[",
      
     StyleBox["mat", "TI"], ",", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "associates the elements of ",
     StyleBox["list", "TI"],
     " with the corresponding rows in the distance matrix ",
     StyleBox["mat", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1304546],

Cell["\<\
Functions for clustering using distance or dissimilarity matrices.\
\>", "Caption",
 CellID->115],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["DistanceMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/DistanceMatrix"]], 
  "InlineFormula"],
 " function can be given a ",
 Cell[BoxData[
  ButtonBox["DistanceFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DistanceFunction"]], "InlineFormula"],
 " option to define the distance measure."
}], "Text",
 CellID->7660],

Cell["Here is an example distance matrix.", "MathCaption",
 CellID->13095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dc", "=", 
  RowBox[{"DistanceMatrix", "[", "data", "]"}]}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[36]:=",
 CellID->9710],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "6.659815008619295`", ",", "10.020485767466527`", ",", 
     "0.8929915648703123`", ",", "5.768195361463636`", ",", 
     "2.0024889678065154`", ",", "12.3625533767028`", ",", 
     "1.8123993766753157`", ",", "3.895470638727931`", ",", 
     "10.885111506419044`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "6.659815008619295`", ",", "0.`", ",", "0.4143370536471114`", ",", 
     "3.3011545018699335`", ",", "0.456825624455459`", ",", 
     "3.7941228609922155`", ",", "3.706405665493336`", ",", 
     "3.770029898609857`", ",", "0.7619101120636763`", ",", 
     "1.0236593571652783`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10.020485767466527`", ",", "0.4143370536471114`", ",", "0.`", ",", 
     "5.996812012317988`", ",", "1.5402591031373816`", ",", 
     "6.7054856229247175`", ",", "2.5572456822488645`", ",", 
     "6.680183483499424`", ",", "1.633087778848597`", ",", 
     "1.2052666774737049`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8929915648703123`", ",", "3.3011545018699335`", ",", 
     "5.996812012317988`", ",", "0.`", ",", "2.262662628972003`", ",", 
     "0.36456744927108753`", ",", "10.113270667609903`", ",", 
     "0.28651172922892176`", ",", "2.165525827513536`", ",", 
     "5.764241447516312`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "5.768195361463636`", ",", "0.456825624455459`", ",", 
     "1.5402591031373816`", ",", "2.262662628972003`", ",", "0.`", ",", 
     "2.0801708179565495`", ",", "6.716558398799106`", ",", 
     "2.118760242703805`", ",", "1.5390395698598656`", ",", 
     "0.8081258157823555`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2.0024889678065154`", ",", "3.7941228609922155`", ",", 
     "6.7054856229247175`", ",", "0.36456744927108753`", ",", 
     "2.0801708179565495`", ",", "0.`", ",", "12.746270663911648`", ",", 
     "0.005099450717886225`", ",", "3.4647898443001224`", ",", 
     "5.162873911866621`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "12.3625533767028`", ",", "3.706405665493336`", ",", 
     "2.5572456822488645`", ",", "10.113270667609903`", ",", 
     "6.716558398799106`", ",", "12.746270663911648`", ",", "0.`", ",", 
     "12.50656859523222`", ",", "2.9476846423732184`", ",", 
     "7.2650613663141455`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.8123993766753157`", ",", "3.770029898609857`", ",", 
     "6.680183483499424`", ",", "0.28651172922892176`", ",", 
     "2.118760242703805`", ",", "0.005099450717886225`", ",", 
     "12.50656859523222`", ",", "0.`", ",", "3.3274756820778673`", ",", 
     "5.2806042651809735`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3.895470638727931`", ",", "0.7619101120636763`", ",", 
     "1.633087778848597`", ",", "2.165525827513536`", ",", 
     "1.5390395698598656`", ",", "3.4647898443001224`", ",", 
     "2.9476846423732184`", ",", "3.3274756820778673`", ",", "0.`", ",", 
     "3.501632828625706`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10.885111506419044`", ",", "1.0236593571652783`", ",", 
     "1.2052666774737049`", ",", "5.764241447516312`", ",", 
     "0.8081258157823555`", ",", "5.162873911866621`", ",", 
     "7.2650613663141455`", ",", "5.2806042651809735`", ",", 
     "3.501632828625706`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{588, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->544424131]
}, Open  ]],

Cell["\<\
This clusters the distance matrix directly, representing data elements by row \
number.\
\>", "MathCaption",
 CellID->7705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectAgglomerate", "[", "dc", "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[37]:=",
 CellID->28264],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{"1", ",", 
       RowBox[{"Cluster", "[", 
        RowBox[{"4", ",", 
         RowBox[{"Cluster", "[", 
          RowBox[{
          "6", ",", "8", ",", "0.005099450717886225`", ",", "1", ",", "1"}], 
          "]"}], ",", "0.28651172922892176`", ",", "1", ",", "2"}], "]"}], 
       ",", "0.8929915648703123`", ",", "1", ",", "3"}], "]"}], ",", 
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"Cluster", "[", 
          RowBox[{
           RowBox[{"Cluster", "[", 
            RowBox[{
            "2", ",", "3", ",", "0.4143370536471114`", ",", "1", ",", "1"}], 
            "]"}], ",", "5", ",", "0.456825624455459`", ",", "2", ",", "1"}], 
          "]"}], ",", "9", ",", "0.7619101120636763`", ",", "3", ",", "1"}], 
        "]"}], ",", "10", ",", "0.8081258157823555`", ",", "4", ",", "1"}], 
      "]"}], ",", "2.0801708179565495`", ",", "4", ",", "5"}], "]"}], ",", 
   "7", ",", "2.5572456822488645`", ",", "9", ",", "1"}], "]"}]], "Output",
 ImageSize->{534, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->1694352]
}, Open  ]],

Cell["\<\
This clusters the distance matrix specifying the corresponding data elements.\
\
\>", "MathCaption",
 CellID->27871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectAgglomerate", "[", 
  RowBox[{"dc", ",", "data"}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[38]:=",
 CellID->13811],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.7253055971477931`", ",", 
         RowBox[{"-", "1.1302536982240747`"}]}], "}"}], ",", 
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.2169129449840166`", ",", 
           RowBox[{"-", "0.33368074105304846`"}]}], "}"}], ",", 
         RowBox[{"Cluster", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.38070042430357054`"}], ",", 
             RowBox[{"-", "0.24750818092033833`"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.3152439519516439`"}], ",", 
             RowBox[{"-", "0.2760546508444408`"}]}], "}"}], ",", 
           "0.005099450717886225`", ",", "1", ",", "1"}], "]"}], ",", 
         "0.28651172922892176`", ",", "1", ",", "2"}], "]"}], ",", 
       "0.8929915648703123`", ",", "1", ",", "3"}], "]"}], ",", 
     RowBox[{"Cluster", "[", 
      RowBox[{
       RowBox[{"Cluster", "[", 
        RowBox[{
         RowBox[{"Cluster", "[", 
          RowBox[{
           RowBox[{"Cluster", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.5810146986977534`", ",", "1.4463710601068265`"}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.8460694069050189`", ",", "2.0329569918374406`"}], 
              "}"}], ",", "0.4143370536471114`", ",", "1", ",", "1"}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.02675560596423776`"}], ",", 
             "1.1506670168024957`"}], "}"}], ",", "0.456825624455459`", ",", 
           "2", ",", "1"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.1616304061543707`", ",", "0.794607673348773`"}], "}"}], 
         ",", "0.7619101120636763`", ",", "3", ",", "1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.25171211458875775`"}], ",", "2.0210234868823256`"}], 
        "}"}], ",", "0.8081258157823555`", ",", "4", ",", "1"}], "]"}], ",", 
     "2.0801708179565495`", ",", "4", ",", "5"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4423867332670177`", ",", "1.9380008134953024`"}], "}"}], ",", 
   "2.5572456822488645`", ",", "9", ",", "1"}], "]"}]], "Output",
 ImageSize->{583, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->171220674]
}, Open  ]],

Cell["\<\
The binary tree structure of the hierarchical cluster leads naturally to a \
graphical representation\[LongDash]the dendrogram. A dendrogram plot shows a \
visual representation of the merger history by connecting two lines \
representing clusters with a bar at their fusion level.\
\>", "Text",
 CellID->32525],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DendrogramPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "plots a dendrogram derived from clustering",
     " ",
     StyleBox["list", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DendrogramPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"], "[", 
     StyleBox["cluster", "TI"], "]"}], Cell[TextData[{
     "plots a dendrogram for the ",
     ButtonBox["Cluster",
      BaseStyle->"Link",
      ButtonData->"paclet:HierarchicalClustering/ref/Cluster"],
     " object ",
     StyleBox["cluster", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->102834940],

Cell["Dendrogram plotting functions.", "Caption",
 CellID->6700],

Cell["This generates a basic dendrogram plot.", "MathCaption",
 CellID->30451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", "data", "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[39]:=",
 CellID->6060],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWz2P00AQ3WABVipfh04IrJDw0bnKWalcQSQ+ZOl+QBKdkBJFiBCuS5Ey
pX8ASClTRf4JAVGkdOkyFXKZMuUxM2tjznAC+eCOO72VvJrZnffmZRM5uxPn
Ze+4//pN73hw1LOfjXuj/uDovf307ZiGjIpSlb5SanNHkX1CllzcBnRps6x1
m3vD9/0oith8QN2NIAjqMh7HsW3bnuepPe6Mer3uSVOW+DS53W4znDJGo1EY
hrlPDg2xqfkoXnRn82flTZLEdV02b/2gklKuVqvv0dPptCHj6/V6JU1Z3Bm0
Oqd8nSLP2u125/N57pNDQ7nKbHWz+Z/z6rjNZqNf0G9UugXWJlRABVRABVRA
BVRABVRAxbVUoQza0qcniH05MdRqtVarlfuWZV2KOo66K6cDx3FIJJv74hPy
UhR5Bf8Q2ZEd2ZG93W7zjWlP7k6LxaJY67hANcRCavL6j+u6pmnm9SFd7Pn3
apoFloMrn43gSrcD7ng+XcnmX80mxTiuw+mvuTQ72MEOdrCDHexgB/tVY/d9
P909HcruybKsNNv52D8UtL/6H9n0kUA9lPPAcrlMzwcN8WkXSxmylSibZTab
edJUI9v3V6tVNh+Jr4M5tFYqy5cC6gVYyrDoN1vd486YTCbD4ZDN++ITpARr
GIZTaSlrp9OhqJyVPhm73e7PWR/LKAnRBxz1FSiggAIKKKCAAgoooIACCiig
gAIKKKCAuraoKIosSx4meZdVlinqlO84ztksTzKWtOo9kqp3EASEYnMsfpIk
J9LU81+yfCy8gk+IQhSiEIWoC4uK49g0Tf759nPhCbibEsXm+f/vqirfAKQJ
1Mk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->1012834023]
}, Open  ]],

Cell["This generates a dendrogram using the Manhattan distance.", \
"MathCaption",
 CellID->16451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DistanceFunction", "->", "ManhattanDistance"}]}], "]"}]], "Input",\

 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[40]:=",
 CellID->4810],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnDFv2kAUx49abS2GxtlohgQ1pGVoJabUQgyeWoamssTIACiqBEOFlWZA
8sBH4AN0YGRk4AMwdGD0yMhUMfojpO+9szGgIrUkQCL9T+J07+7e//8LSnR3
ju2rxm3z2/fGbeu6kf180/Caresf2U/tG+oyUkqlmkqpWUZR+45a8uHSoo9u
btt6ybXhum4QBNw8p+pZr9fLST910hA3dWzb9nw+j+cpw/O84XCYxBRQVzI/
m80KZzy+yYdESZqbL5aoHMcZj8eL2d1uV8+mThpacZnNZolLvV7v9/tJTAF1
JfPjby8e3+RDovoHABWoQAUqUO2cajKZWJZFo+qYKyOXyzlSlHQapmmurED7
pryIKcdSlMUVu6zEepE7HKW9pnoJClCAAhSgAAUoQAEKUIACFKAABShAAQpQ
gAIUoAAFKEABClCAAhSgAMXSbGXQdOqiWp1wZVSrVd/3k/iwdGEYdqVENJRS
q9WSWN+stn86Zy2uwB3ucIc73OEOd7jDHe5whzvc4f6k3emEnclknMX9+qVS
iVSdxf38lmXthUarJPfpH3FlDAYDouPmscT6gYfd01yuqXyE2+N2c103uWqk
LyFx87XEnuft0D0IgpVrWPQX0263N1/Deih3eWxz6SmgCtShDnWoQx3qUH/s
6rS15S1tXva1o9Eo2vfquFAoPKBbp9NxpKi87OnT6XSxWEzicrm89Izu9m4/
1765r1CDGtSgdng1OgLyYexCTmS+71cqFW6+ldiRGyR46vk9XCiIzoHahQ6B
dBTk5juJwzC8k6LebOXyay3rC1SetAqturTM8wJ8Kquwbdv65RnqzImuvEXv
XvofVVrIo53Eqewker2e3kyos/Hqmy7+TTUf/247+t0jv5GFLGQhC1nIQhay
kLX3LNrjmaapqFxxZehBHnr+1yweeiV9yf/lPmw1czqdRs7UpY7EXW99efi9
zOTm/d9zqlJ/AAogXrU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->141217]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    StyleBox[
     RowBox[{"option", " ", "name"}], "TI"], 
    StyleBox[
     RowBox[{"default", " ", "value"}], "TI"], ""},
   {
    ButtonBox["TruncateDendrogram",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/TruncateDendrogram"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "the level at which to truncate the dendrogram", "TableText"]},
   {
    ButtonBox["HighlightLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/HighlightLevel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the level at which to highlight the clusters", "TableText"]},
   {
    ButtonBox["HighlightStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/HighlightStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
graphics directives to specify the style of each highlighted cluster\
\>", "TableText"]},
   {
    ButtonBox["LeafLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/LeafLabels"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["the leaf labels", "TableText"]},
   {
    ButtonBox["DistanceFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DistanceFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the distance or dissimilarity measure to use", "TableText"]},
   {
    ButtonBox["Linkage",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/Linkage"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the clustering linkage algorithm to use", "TableText"]},
   {
    ButtonBox["Orientation",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/Orientation"], 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "the orientation of the dendrogram", "TableText"]},
   {
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives to specify the style of the dendrogram", 
     "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->214263475],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["DendrogramPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"]], 
  "InlineFormula"],
 StyleBox[".", "MR"]
}], "Caption",
 CellID->681],

Cell["\<\
This generates a dendrogram using Ward\[CloseCurlyQuote]s linkage method to \
cluster the data.\
\>", "MathCaption",
 CellID->28660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Linkage", "\[Rule]", "\"\<Ward\>\""}]}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[41]:=",
 CellID->24000],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj9v2kAUwI9e0zI6TAhViUUi5CKkIERdxOSpZamE1C+AFbU1QxWURILN
QwZGPgJTxcjAgJgYGenGyMjokZG+987utVZQK+KoVftO4vTe3e/9ueT5eIn8
zr31Pnx2b9uXrvn22u147csb883VNSzJlBApTwixzgqQdyDRB0cbPko8VHqO
s2w2m8vlEsUzmJ4MBoNzWg+CwDAMiCbOcZKWZW2324gTstPpjMdjrYMCSygq
e9M0Kc9of1+czWZTq9VQfPZDVo7jzOfz77Tv+4TI6PQ7YZPearWGw6GOAgos
6Sw0f7bHr+LW67VK+K/PQkjAwTssiRxOcjabzWmE+j3Z9Xo93DIifjKZaB02
HzFbUBwaIoeTzGQy1WpV6yq0znY6nYa8Qfv5fB6ioHhM+mg0+im7pLJ1YvrH
Pb/xfy9Ko9Eol8v6J14sFm3b1jqE6vf7mk82Ojz/YfWqaoRsut0uisekq0sH
0Xyi0eNPrs3eE/cuJFzz4dObi2oJbnutw1dMolE/wfSC6gZKGoLrWxE8JRrp
Lqa/Z69/3Ku+yU6ouur1eqFQQPE0qrbFYvHQKPrGOqHKgjKDqCiekq5CHB7F
olX1vYnil9jZLDpLqVQKnySlZ7PZA7zqs1ix2/dl7PZ99Vtev8ZO6LIVW7EV
W7EVW7HVf2TleZ5lUWtyQf1JpVKBPyy1Ds0L9DO/8hIEQdifXFA/As0JtCgo
UsOF/cuOhji61wtuSVrT/5OpMckkk0wyySSTTDLJJJNMMskkk0wyySSTTDLJ
JJOPQK5Wq3Q6LcLXWZ/S+6W+7+9oiNdEovjwd1xF6hvFDDy1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->139458813]
}, Open  ]],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["LeafLabels",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/LeafLabels"]], 
  "InlineFormula"],
 " is provided to support labeling of the dendrogram. For data, a value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LeafLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/LeafLabels"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " will use the data element position for the label, but the option can also \
take a list of expressions or a function. The function will be applied to \
each data element to generate the label expression. For ",
 Cell[BoxData[
  ButtonBox["Cluster",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Cluster"]], 
  "InlineFormula"],
 " objects, the ",
 Cell[BoxData[
  ButtonBox["LeafLabels",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/LeafLabels"]], 
  "InlineFormula"],
 " option can take a function but not a list or ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", as there is no unambiguous mapping between the labels and data points in \
a ",
 Cell[BoxData[
  ButtonBox["Cluster",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Cluster"]], 
  "InlineFormula"],
 " object."
}], "Text",
 CellID->20515],

Cell["\<\
This generates a dendrogram with automatically generated labels.\
\>", "MathCaption",
 CellID->17710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"LeafLabels", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Orientation", "\[Rule]", "Left"}]}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[42]:=",
 CellID->22361],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1rE0EUn7ip0VJBCmraU+gHRryE0EPUYkOFWg+BXOqhB5u0KBuwuraF
RDwIXnvoXQ89lRw89g/wj1BowUMPCgUv/RPW995OdpLpfsx+NBachX2Zj/f7
zc7svDfzJltr7pgvN5s7rY1m4elW0zJbG9uFpbdbUGRkGMuYjLGfeQZpG1J0
49WC20mqptbgNgCec0samDJ6jDa7SjW/qLRUKjHn2kaBea5lBKBE6fuha3VA
XIHsNc/aT7o0ZumSPTgfvsD9wfONOJqFQuHk5ASTn5XeYxiqRnmo/EYXm0aR
PTo6sntX1p3ValzFYrFSqVSrVTaNImeapsvl6DJ3Hqkxivqi3T8Lh4u+l2B8
RX1ZozRqmChu1zUUxuTkpAKq0WhU6WI1FMbo6Ggg6o/SE8XTCrZZWfsuiqwY
Kz/PJeOmKA9DtLe3h8kriXhg/CzLomSkp3fR+/v7qTxFyjzJenNDo9RR3W4X
DXaKrHZ5eVkB1el0uNVOkdXm8/nd3V1/FE6Fm0pPpTXjagZbjBdC1VYFFlyN
Ez5Ewt6KqGsE9uI2lQk2f647fET8NQq6Zsg19C4M2PPzvcI8eZ2JiQnfOZDr
cfGd/jx5nLGxsePj4x4iL82JkUEk556X8j9AOO27MQjLxmL6TnlwpOAI8fEe
0jO60UgiVjBWMFlMLtj9Fh4Hfd5uorJU7X6biop+plEa9Q9QXyl/dnbGvc4s
WX273V5dXY3KAlZdLBbRwGfJyiGzuLgYlUWswrMJenTRLI/t/jOZpGwLlBfn
MumwOqeY8EI/0sXmUBhOcCXq5bOUdFqFCQB50aqjjFXxPL5yq9BdTD4aSisV
6tD5/Vva7Tywo6xvUdmfaNb/hxXCWHLxJMrlcgqssEfkMa9BYnx8/PDwMD7r
/VR6rFkuH8sB5WEFGpgv4owkCSuggFjMbXFeI7Oi1/aIosLYOdoIGYl4K49a
K/V6vVQq4aDN0cg5LgKr4q2qaq2K3eEcjawDxio861Bfl8JaM6U+qO1Hwlhb
FzIyr1KdQ+80i2bRLJrF08+gh70ezGZZFoZZBxRrQZ7vv5J4WBE3OqwzMzPy
M3Y6HVwQ1qWTQlwVxFc4Mvtvzx53u12+J1hHMSJ9r+Ccqod6cZn7NQqF+Cwt
3KYdtB7K2m2tpbUuUAtno8FtB2eloYR6Y8tzH/EZ+M3gbzAHP/MxvU6aYnEK
L2RK50hxOFHx+ZBxK32j7/8WUHNN11zqmhUqC/ufKEwTAjj+f50Noi7FcUFn
sqenpzwOs0HUpVjMG4nJhm/NC1ue0zm3Dsdh8Fta/29vWeYvFuQERA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->93152385]
}, Open  ]],

Cell["This generates a dendrogram using a list of labels.", "MathCaption",
 CellID->27247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"LeafLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\"", ",", "\"\<d\>\"", ",", 
      "\"\<e\>\"", ",", "\"\<f\>\"", ",", "\"\<g\>\"", ",", "\"\<h\>\"", ",", 
      "\"\<i\>\"", ",", "\"\<j\>\""}], "}"}]}], ",", 
   RowBox[{"Orientation", "\[Rule]", "Left"}]}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[43]:=",
 CellID->17742],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWr9PGzEUdu6SQhcEUoa0ZYhEFaWlUrMgQoSUCKnAUsRQCZqlpFHVywBE
FATtkm6MsBeJEabyJ/RPYAxLxVTd1Dmj+97z3cU97pK7ywXRYksx/vG+z/bZ
fn7P+HVt1/iwWdtt1GvZpZ1a02jUP2UXt3egSE8wljAYYz8zDNIcUvTD0ICf
SPZO1eGnA0h3St5jShc8ELMk/f1FpZ1O5wcFtoeRfnl5Sa1xpkGkuaRPT08z
mUylUmF7GI00m01uB29+QGxsbGDyi9QLSnpKfVWlt1C6RKUw19bcf6O539/f
X1tb60otkpRpmqOjozjdJxjp+Xy+XC7bM5qECdUk6evr62w2i8kTV8ufMUp2
599eof1wK/Y6PTw8bLVa7ClGKaiXV57og7S6EiG4YfBQ3+U+OjqKkxu+Giaf
cXlfhkVPx9KH51zs6Wh9eKlQCnWbqOXlZVRMK6SdYFeWSqV+qHa7XaHAVkhb
FQqFXC7nj/odqEfRpPJc7Hhru1Hw3rduJOqKv3Wlt45146YoD3pdqEfRcGQe
mDRxwBOPJo0E42AjcZjkHkm2iLcmCsPi5EOz2BZOKhL6oUINFQU7GewOXCNT
tFAgHB8f+6NwIaQD8SvJqJK4Y3THwg+CCLZTbaQGwGQoxA1tFwj5qO84Hgfm
esJ72VQokVU1d6ZmhGoODg4sK2GerIRisTg2NibPfdfzFQggOjs7Q0NknqwR
yExOTsrrSV4tLiR0BJPzrl61KQ92TYsCK2GUlL0P/WYvenKBuMw1cnFx4XC5
/fPAjBa87MrrkVheKZRC/eeo75QHNWHtxRxGEVkgAzZ4DCxWfW6AEQ2bpcLl
k3RQtjJGHr7PoLyaLQ/eKR4eM3SCCAfXqR9au12veMbjvnao7Vo+PLrgemyz
5MUe/pQJ28oclz2/uNkrivX+sFo36Jp9g16tVgdlhY5Z1qlm37gvLCxEZ52O
ZcSK5e6xnFO+60HoFE1MTFxdXQ3K2vUlBGs6nfbpK+psD3+pHzunYHnt/l9i
ziUfZyvgxVn/z6RTPGUYBrcDekoPYmnrBUSzqB9S7XZ7CPxGrN9/S7EoFsWi
WP5lFtDqqHDPySrzZ/nI+9+xdTqd1dVVPB7OyRrrrYf7+y6m58gKhUKxWMQG
6tTK+vq6Ve9+fRCG1TRNyz6t05dwzp+IrJu8l9/klt4NJLUVqSfBuJXUfZIK
tzq3XXnv25LbR42PjzMRGhihZrBQ7v9vebNgVTWw5Fvey3ZEiXcxtOLPoWri
rsEZ9b+fQwk8WVjKmTeS87sttOWT/Rl9fDQ8zkTAZt7QmhbPATh3vzLFInqt
6vFOEDN1Lr84xJKgr2JFiiX+AEwp0LM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->857433894]
}, Open  ]],

Cell["This generates a dendrogram using a label function.", "MathCaption",
 CellID->3020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"LeafLabels", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"#", "&"}], ")"}]}], ",", 
   RowBox[{"Orientation", "\[Rule]", "Left"}]}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[44]:=",
 CellID->30762],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[
    0, 1, 0]}, {{}, {
     LineBox[{{0, 3}, {-0.00509945071788622, 3}, {-0.00509945071788622, 4}, {
       0, 4}}], 
     LineBox[{{0, 2}, {-0.286511729228922, 2}, {-0.286511729228922, 
       3.5}, {-0.00509945071788622, 3.5}}], 
     LineBox[{{0, 1}, {-0.892991564870312, 1}, {-0.892991564870312, 
       2.75}, {-0.286511729228922, 2.75}}], 
     LineBox[{{0, 6}, {-0.414337053647111, 6}, {-0.414337053647111, 7}, {0, 
       7}}], LineBox[{{0, 5}, {-0.456825624455459, 5}, {-0.456825624455459, 
       6.5}, {-0.414337053647111, 6.5}}], 
     LineBox[{{-0.456825624455459, 5.75}, {-0.761910112063676, 
       5.75}, {-0.761910112063676, 8}, {0, 8}}], 
     LineBox[{{-0.761910112063676, 6.875}, {-0.808125815782356, 
       6.875}, {-0.808125815782356, 9}, {0, 9}}], 
     LineBox[{{-0.892991564870312, 1.875}, {-2.08017081795655, 
      1.875}, {-2.08017081795655, 7.9375}, {-0.808125815782356, 7.9375}}], 
     LineBox[{{-2.08017081795655, 4.90625}, {-2.55724568224886, 
       4.90625}, {-2.55724568224886, 10}, {0, 10}}]}}, {InsetBox[
     RowBox[{"{", 
      RowBox[{"0.7253055971477931`", ",", 
       RowBox[{"-", "1.1302536982240747`"}]}], "}"}], 
     Offset[{4., 0.}, {0, 1}], {-1, 0}], InsetBox[
     RowBox[{"{", 
      RowBox[{"0.2169129449840166`", ",", 
       RowBox[{"-", "0.33368074105304846`"}]}], "}"}], 
     Offset[{4., 0.}, {0, 2}], {-1, 0}], InsetBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.3152439519516439`"}], ",", 
       RowBox[{"-", "0.2760546508444408`"}]}], "}"}], 
     Offset[{4., 0.}, {0, 3}], {-1, 0}], InsetBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.38070042430357054`"}], ",", 
       RowBox[{"-", "0.24750818092033833`"}]}], "}"}], 
     Offset[{4., 0.}, {0, 4}], {-1, 0}], InsetBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.02675560596423776`"}], ",", "1.1506670168024957`"}], 
      "}"}], Offset[{4., 0.}, {0, 5}], {-1, 0}], InsetBox[
     RowBox[{"{", 
      RowBox[{"0.5810146986977534`", ",", "1.4463710601068265`"}], "}"}], 
     Offset[{4., 0.}, {0, 6}], {-1, 0}], InsetBox[
     RowBox[{"{", 
      RowBox[{"0.8460694069050189`", ",", "2.0329569918374406`"}], "}"}], 
     Offset[{4., 0.}, {0, 7}], {-1, 0}], InsetBox[
     RowBox[{"{", 
      RowBox[{"1.1616304061543707`", ",", "0.794607673348773`"}], "}"}], 
     Offset[{4., 0.}, {0, 8}], {-1, 0}], InsetBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.25171211458875775`"}], ",", "2.0210234868823256`"}], 
      "}"}], Offset[{4., 0.}, {0, 9}], {-1, 0}], InsetBox[
     RowBox[{"{", 
      RowBox[{"2.4423867332670177`", ",", "1.9380008134953024`"}], "}"}], 
     Offset[{4., 0.}, {0, 10}], {-1, 0}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->All]], "Output",
 ImageSize->{364, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[44]=",
 CellID->125598895]
}, Open  ]],

Cell[TextData[{
 "For large data sets, only a summary of the full dendrogram may be desired. \
Dendrograms may be truncated using the ",
 Cell[BoxData[
  ButtonBox["TruncateDendrogram",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/TruncateDendrogram"]], 
  "InlineFormula"],
 " option by providing an integer or a list of two integers. If given as a \
list of two integers, the first value specifies the fusion level above which \
mergers should not be shown, while the second indicates the fusion level \
under which the dendrogram should be truncated. For a single integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TruncateDendrogram",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/TruncateDendrogram"], "->",
    
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TruncateDendrogram",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/TruncateDendrogram"], "->",
    
   RowBox[{"{", 
    RowBox[{"1", ",", 
     StyleBox["n", "TI"]}], "}"}]}]], "InlineFormula"],
 ". A value of ",
 Cell[BoxData["\[Infinity]"], "InlineFormula"],
 " may be given as a second value to show the full clustering without \
truncation from below. When a cluster is truncated and labels are specified, \
a box is substituted for a label indicating the size of the cluster that has \
been truncated."
}], "Text",
 CellID->30039],

Cell["\<\
Here is a larger data set to cluster. It is based on Fisher's iris data.\
\>", "MathCaption",
 CellID->18380],

Cell[BoxData[
 RowBox[{
  RowBox[{"iris", "=", 
   RowBox[{"Import", "[", "\"\<StatisticsExamples/Data/iris.dat\>\"", "]"}]}],
   ";"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[45]:=",
 CellID->28145],

Cell["This turns off tie warnings.", "MathCaption",
 CellID->5672],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"Agglomerate", "::", "ties"}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[46]:=",
 CellID->13311],

Cell["\<\
This generates a dendrogram truncated to show only the highest 20 mergers.\
\>", "MathCaption",
 CellID->9143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{"iris", ",", 
   RowBox[{"TruncateDendrogram", "\[Rule]", "20"}], ",", 
   RowBox[{"LeafLabels", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[47]:=",
 CellID->4807],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]=",
 CellID->287514638]
}, Open  ]],

Cell["This highlights the two top clusters.", "MathCaption",
 CellID->220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{"iris", ",", 
   RowBox[{"TruncateDendrogram", "\[Rule]", "20"}], ",", 
   RowBox[{"LeafLabels", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"HighlightLevel", "\[Rule]", "2"}]}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[48]:=",
 CellID->12537],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[48]=",
 CellID->715669725]
}, Open  ]],

Cell["\<\
This generates a dendrogram truncated between levels 2 and 20.\
\>", "MathCaption",
 CellID->25452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{"iris", ",", 
   RowBox[{"TruncateDendrogram", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "20"}], "}"}]}], ",", 
   RowBox[{"LeafLabels", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"HighlightLevel", "\[Rule]", "2"}]}], "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[49]:=",
 CellID->14582],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->291682193]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hierarchical Clustering Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 47.6957722}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Tutorial", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "The function FindClusters finds clusters in a data set based on a \
distance or dissimilarity function. This package contains functions for \
generating cluster hierarchies and visualizing the mergers in the \
hierarchical clustering. Hierarchical clustering function. The Agglomerate \
function computes a cluster hierarchy of a data set. Agglomerate accepts data \
in the same forms accepted by FindClusters. The output from Agglomerate is a \
nested Cluster object representing the hierarchical clustering.", 
    "synonyms" -> {}, "title" -> "Hierarchical Clustering Package", "type" -> 
    "Tutorial", "uri" -> 
    "HierarchicalClustering/tutorial/HierarchicalClustering"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1534, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2159, 60, 63, 1, 70, "Title",
 CellID->2948],
Cell[2225, 63, 403, 10, 70, "Text",
 CellID->326425833],
Cell[2631, 75, 381, 12, 70, "DefinitionBox",
 CellID->755],
Cell[3015, 89, 924, 23, 70, "Caption",
 CellID->25611],
Cell[3942, 114, 977, 32, 70, "Text",
 CellID->21425],
Cell[4922, 148, 66, 1, 70, "MathCaption",
 CellID->373720925],
Cell[4991, 151, 550, 14, 70, "Input",
 CellID->716428967],
Cell[5544, 167, 73, 1, 70, "MathCaption",
 CellID->6298],
Cell[5620, 170, 1773, 51, 70, "Input",
 CellID->10240],
Cell[7396, 223, 93, 1, 70, "MathCaption",
 CellID->21086],
Cell[CellGroupData[{
Cell[7514, 228, 549, 15, 70, "Input",
 CellID->12483],
Cell[8066, 245, 2514, 62, 139, "Output",
 CellID->224452338]
}, Open  ]],
Cell[10595, 310, 65, 1, 70, "MathCaption",
 CellID->19999],
Cell[10663, 313, 1555, 42, 70, "Input",
 CellID->30627],
Cell[12221, 357, 70, 1, 70, "MathCaption",
 CellID->10573],
Cell[CellGroupData[{
Cell[12316, 362, 526, 14, 70, "Input",
 CellID->22304],
Cell[12845, 378, 1620, 42, 172, "Output",
 CellID->267055195]
}, Open  ]],
Cell[14480, 423, 64, 1, 70, "MathCaption",
 CellID->22244],
Cell[14547, 426, 766, 21, 70, "Input",
 CellID->23615],
Cell[15316, 449, 69, 1, 70, "MathCaption",
 CellID->29294],
Cell[CellGroupData[{
Cell[15410, 454, 526, 14, 70, "Input",
 CellID->31696],
Cell[15939, 470, 502, 10, 70, "Message",
 CellID->304934388],
Cell[16444, 482, 1115, 29, 71, "Output",
 CellID->1136277374]
}, Open  ]],
Cell[17574, 514, 1374, 45, 70, "DefinitionBox",
 CellID->26801],
Cell[18951, 561, 70, 1, 70, "Caption",
 CellID->6134],
Cell[19024, 564, 881, 27, 70, "DefinitionBox",
 CellID->109852281],
Cell[19908, 593, 238, 9, 70, "Caption",
 CellID->25532],
Cell[20149, 604, 575, 21, 70, "Text",
 CellID->22901],
Cell[20727, 627, 127, 4, 70, "MathCaption",
 CellID->30731],
Cell[CellGroupData[{
Cell[20879, 635, 129, 4, 70, "Input",
 CellID->14777],
Cell[21011, 641, 2252, 59, 122, "Output",
 CellID->233526966]
}, Open  ]],
Cell[23278, 703, 65, 1, 70, "MathCaption",
 CellID->28146],
Cell[CellGroupData[{
Cell[23368, 708, 107, 3, 70, "Input",
 CellID->2129],
Cell[23478, 713, 1320, 38, 71, "Output",
 CellID->421427787]
}, Open  ]],
Cell[24813, 754, 983, 31, 70, "DefinitionBox3Col",
 CellID->19253],
Cell[25799, 787, 219, 9, 70, "Caption",
 CellID->12592],
Cell[26021, 798, 765, 24, 70, "Text",
 CellID->12413],
Cell[26789, 824, 751, 18, 70, "DefinitionBox",
 CellID->10233],
Cell[27543, 844, 230, 9, 70, "Caption",
 CellID->29004],
Cell[27776, 855, 417, 7, 70, "Text",
 CellID->5680],
Cell[28196, 864, 2198, 69, 70, "Text",
 CellID->13404],
Cell[30397, 935, 167, 6, 70, "MathCaption",
 CellID->17662],
Cell[CellGroupData[{
Cell[30589, 945, 598, 16, 70, "Input",
 CellID->23704],
Cell[31190, 963, 2485, 64, 139, "Output",
 CellID->711667788]
}, Open  ]],
Cell[33690, 1030, 116, 3, 70, "MathCaption",
 CellID->32535],
Cell[CellGroupData[{
Cell[33831, 1037, 835, 25, 70, "Input",
 CellID->21780],
Cell[34669, 1064, 2483, 64, 139, "Output",
 CellID->124069737]
}, Open  ]],
Cell[37167, 1131, 434, 9, 70, "Text",
 CellID->15371],
Cell[37604, 1142, 87, 1, 70, "MathCaption",
 CellID->13237],
Cell[CellGroupData[{
Cell[37716, 1147, 826, 21, 70, "Input",
 CellID->25270],
Cell[38545, 1170, 1381, 34, 88, "Output",
 CellID->44020661]
}, Open  ]],
Cell[39941, 1207, 1093, 32, 70, "Text",
 CellID->32565],
Cell[41037, 1241, 1123, 34, 70, "DefinitionBox",
 CellID->1304546],
Cell[42163, 1277, 107, 3, 70, "Caption",
 CellID->115],
Cell[42273, 1282, 416, 14, 70, "Text",
 CellID->7660],
Cell[42692, 1298, 74, 1, 70, "MathCaption",
 CellID->13095],
Cell[CellGroupData[{
Cell[42791, 1303, 551, 15, 70, "Input",
 CellID->9710],
Cell[43345, 1320, 3476, 77, 241, "Output",
 CellID->544424131]
}, Open  ]],
Cell[46836, 1400, 133, 4, 70, "MathCaption",
 CellID->7705],
Cell[CellGroupData[{
Cell[46994, 1408, 529, 14, 70, "Input",
 CellID->28264],
Cell[47526, 1424, 1280, 32, 88, "Output",
 CellID->1694352]
}, Open  ]],
Cell[48821, 1459, 126, 4, 70, "MathCaption",
 CellID->27871],
Cell[CellGroupData[{
Cell[48972, 1467, 555, 15, 70, "Input",
 CellID->13811],
Cell[49530, 1484, 2526, 63, 139, "Output",
 CellID->171220674]
}, Open  ]],
Cell[52071, 1550, 321, 6, 70, "Text",
 CellID->32525],
Cell[52395, 1558, 812, 25, 70, "DefinitionBox",
 CellID->102834940],
Cell[53210, 1585, 64, 1, 70, "Caption",
 CellID->6700],
Cell[53277, 1588, 78, 1, 70, "MathCaption",
 CellID->30451],
Cell[CellGroupData[{
Cell[53380, 1593, 527, 14, 28, "Input",
 CellID->6060],
Cell[53910, 1609, 1073, 22, 244, "Output",
 Evaluatable->False,
 CellID->1012834023]
}, Open  ]],
Cell[54998, 1634, 98, 2, 70, "MathCaption",
 CellID->16451],
Cell[CellGroupData[{
Cell[55121, 1640, 608, 17, 28, "Input",
 CellID->4810],
Cell[55732, 1659, 1207, 24, 244, "Output",
 Evaluatable->False,
 CellID->141217]
}, Open  ]],
Cell[56954, 1686, 2623, 76, 70, "DefinitionBox3Col",
 CellID->214263475],
Cell[59580, 1764, 239, 9, 70, "Caption",
 CellID->681],
Cell[59822, 1775, 142, 4, 70, "MathCaption",
 CellID->28660],
Cell[CellGroupData[{
Cell[59989, 1783, 598, 16, 28, "Input",
 CellID->24000],
Cell[60590, 1801, 1055, 21, 244, "Output",
 Evaluatable->False,
 CellID->139458813]
}, Open  ]],
Cell[61660, 1825, 1481, 44, 70, "Text",
 CellID->20515],
Cell[63144, 1871, 111, 3, 70, "MathCaption",
 CellID->17710],
Cell[CellGroupData[{
Cell[63280, 1878, 651, 17, 28, "Input",
 CellID->22361],
Cell[63934, 1897, 1550, 29, 240, "Output",
 Evaluatable->False,
 CellID->93152385]
}, Open  ]],
Cell[65499, 1929, 90, 1, 70, "MathCaption",
 CellID->27247],
Cell[CellGroupData[{
Cell[65614, 1934, 874, 22, 47, "Input",
 CellID->17742],
Cell[66491, 1958, 1588, 30, 242, "Output",
 Evaluatable->False,
 CellID->857433894]
}, Open  ]],
Cell[68094, 1991, 89, 1, 70, "MathCaption",
 CellID->3020],
Cell[CellGroupData[{
Cell[68208, 1996, 689, 19, 70, "Input",
 CellID->30762],
Cell[68900, 2017, 2982, 67, 183, "Output",
 CellID->125598895]
}, Open  ]],
Cell[71897, 2087, 1509, 39, 70, "Text",
 CellID->30039],
Cell[73409, 2128, 119, 3, 70, "MathCaption",
 CellID->18380],
Cell[73531, 2133, 604, 17, 70, "Input",
 CellID->28145],
Cell[74138, 2152, 66, 1, 70, "MathCaption",
 CellID->5672],
Cell[74207, 2155, 551, 15, 70, "Input",
 CellID->13311],
Cell[74761, 2172, 120, 3, 70, "MathCaption",
 CellID->9143],
Cell[CellGroupData[{
Cell[74906, 2179, 655, 17, 28, "Input",
 CellID->4807],
Cell[75564, 2198, 2471, 45, 258, "Output",
 Evaluatable->False,
 CellID->287514638]
}, Open  ]],
Cell[78050, 2246, 74, 1, 70, "MathCaption",
 CellID->220],
Cell[CellGroupData[{
Cell[78149, 2251, 709, 18, 47, "Input",
 CellID->12537],
Cell[78861, 2271, 2418, 44, 258, "Output",
 Evaluatable->False,
 CellID->715669725]
}, Open  ]],
Cell[81294, 2318, 109, 3, 70, "MathCaption",
 CellID->25452],
Cell[CellGroupData[{
Cell[81428, 2325, 760, 20, 47, "Input",
 CellID->14582],
Cell[82191, 2347, 2519, 45, 258, "Output",
 Evaluatable->False,
 CellID->291682193]
}, Open  ]]
}, Open  ]],
Cell[84737, 2396, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

