(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8357,        278]
NotebookOptionsPosition[      6445,        221]
NotebookOutlinePosition[      7698,        253]
CellTagsIndexPosition[      7655,        250]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HISTOGRAMS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Histogram3D" :> 
         Documentation`HelpLookup["paclet:Histograms/ref/Histogram3D"], 
         "Graphics" :> Documentation`HelpLookup["paclet:ref/Graphics"], 
         "Rectangle" :> Documentation`HelpLookup["paclet:ref/Rectangle"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Histogram3D\"\>", 
      2->"\<\"Graphics\"\>", 3->"\<\"Rectangle\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Histogram", "ObjectName",
 CellID->11558],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Histogram", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a histogram of the univariate data ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Histogram", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{
         ButtonBox["FrequencyData",
          BaseStyle->"Link",
          ButtonData->"paclet:Histograms/ref/FrequencyData"], "->", 
         ButtonBox["True",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a histogram of the univariate frequency data \
",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is the frequency with which the original data occurs in category ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->5474]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The width of each bar in the histogram is proportional to the width of the \
interval defining the respective category.\
\>", "Notes",
 CellID->5169],

Cell["\<\
The area of each bar in the histogram is proportional to the frequency with \
which the data fall in that category.\
\>", "Notes",
 CellID->27694],

Cell["The following options can be given:", "Notes",
 CellID->13866],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["HistogramRange",
     BaseStyle->"Link",
     ButtonData->"paclet:Histograms/ref/HistogramRange"], Cell[
    "lower and upper limits of points", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["HistogramCategories",
     BaseStyle->"Link",
     ButtonData->"paclet:Histograms/ref/HistogramCategories"], Cell[
    "specifies categories ", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->13521]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7983],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Histogram3D",
    BaseStyle->"Link",
    ButtonData->"paclet:Histograms/ref/Histogram3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21514]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Histogram - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 54.9459578}", "context" -> "Histograms`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Histograms Package Symbol", "language" -> "en", "paclet" -> 
    "Histograms Package", "status" -> "None", "summary" -> 
    "Histogram[{x_1, x_2, ...}] generates a histogram of the univariate data \
{x_1, x_2, ...}. Histogram[{f_1, f_2, ...}, FrequencyData -> True] generates \
a histogram of the univariate frequency data {f_1, f_2, ...}, where f_i is \
the frequency with which the original data occurs in category i.", 
    "synonyms" -> {}, "title" -> "Histogram", "type" -> "Symbol", "uri" -> 
    "Histograms/ref/Histogram"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 779, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1402, 44, 47, 1, 70, "ObjectName",
 CellID->11558],
Cell[1452, 47, 2298, 73, 70, "Usage",
 CellID->5474]
}, Open  ]],
Cell[CellGroupData[{
Cell[3787, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4265, 142, 159, 4, 70, "Notes",
 CellID->5169],
Cell[4427, 148, 156, 4, 70, "Notes",
 CellID->27694],
Cell[4586, 154, 68, 1, 70, "Notes",
 CellID->13866],
Cell[4657, 157, 681, 17, 70, "2ColumnTableMod",
 CellID->13521]
}, Closed]],
Cell[CellGroupData[{
Cell[5375, 179, 310, 9, 70, "SeeAlsoSection",
 CellID->7983],
Cell[5688, 190, 715, 26, 70, "SeeAlso",
 CellID->21514]
}, Open  ]],
Cell[6418, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

