(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7822,        278]
NotebookOptionsPosition[      5998,        221]
NotebookOutlinePosition[      7092,        251]
CellTagsIndexPosition[      7049,        248]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HISTOGRAMS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Histogram" :> 
         Documentation`HelpLookup["paclet:Histograms/ref/Histogram"], 
         "Histogram3D" :> 
         Documentation`HelpLookup["paclet:Histograms/ref/Histogram3D"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Histogram\"\>", 
      2->"\<\"Histogram3D\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HistogramCategories", "ObjectName",
 CellID->28687],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["HistogramCategories"], "InlineFormula"],
     " \[LineSeparator]",
     "is an option of histogram functions that specifies the categories in \
the histogram."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"HistogramCategories", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the categories are chosen to be intervals of equal width. The number of \
categories is chosen automatically."
}], "Notes",
 CellID->1387996065],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"HistogramCategories", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " equally sized categories should be used."
}], "Notes",
 CellID->2082490741],

Cell[TextData[{
 Cell[BoxData["HistogramCategories"], "InlineFormula"],
 " -> {m, n} specified that an ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "\[Times]", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " grid of categories should be used for ",
 Cell[BoxData[
  ButtonBox["Histogram3D",
   BaseStyle->"Link",
   ButtonData->"paclet:Histograms/ref/Histogram3D"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->690369804],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"HistogramCategories", "->", " ", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["1", "TR"]], ",", " ", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["2", "TR"]], ",", " ", "...", ",", " ", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["n", "TI"]]}], "}"}]}]], "InlineFormula"],
 " uses categories ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["1", "TR"]], " ", "\[LessEqual]", 
     StyleBox["x", "TI"], "<", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["2", "TR"]]}], ",", " ", "\[Ellipsis]", ",", " ", 
    RowBox[{
     SubscriptBox[
      StyleBox["c", "TI"], 
      RowBox[{
       StyleBox["n", "TI"], "-", "1"}]], "\[LessEqual]", 
     StyleBox["x", "TI"], "<", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["n", "TI"]]}]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->733405181],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"HistogramCategories", "->", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", "\[Ellipsis]", ",", " ", 
       SubscriptBox["c", 
        StyleBox["n", "TI"]]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["d", "TI"], 
        StyleBox["1", "TR"]], ",", "\[Ellipsis]", ",", " ", "dl"}], "}"}]}], 
    "}"}]}]], "InlineFormula"],
 " specifies unequally sized categories in ",
 Cell[BoxData[
  ButtonBox["Histogram3D",
   BaseStyle->"Link",
   ButtonData->"paclet:Histograms/ref/Histogram3D"]], "InlineFormula"]
}], "Notes",
 CellID->1131502365]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21591],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Histogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Histograms/ref/Histogram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Histogram3D",
    BaseStyle->"Link",
    ButtonData->"paclet:Histograms/ref/Histogram3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20896]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HistogramCategories - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 54.7584530}", "context" -> "Histograms`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Histograms Package Symbol", "language" -> "en", "paclet" -> 
    "Histograms Package", "status" -> "None", "summary" -> 
    "HistogramCategories is an option of histogram functions that specifies \
the categories in the histogram.", "synonyms" -> {}, "title" -> 
    "HistogramCategories", "type" -> "Symbol", "uri" -> 
    "Histograms/ref/HistogramCategories"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 704, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1327, 44, 57, 1, 70, "ObjectName",
 CellID->28687],
Cell[1387, 47, 403, 12, 70, "Usage",
 CellID->30997]
}, Open  ]],
Cell[CellGroupData[{
Cell[1827, 64, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2305, 81, 340, 10, 70, "Notes",
 CellID->1387996065],
Cell[2648, 93, 272, 9, 70, "Notes",
 CellID->2082490741],
Cell[2923, 104, 431, 14, 70, "Notes",
 CellID->690369804],
Cell[3357, 120, 1027, 37, 70, "Notes",
 CellID->733405181],
Cell[4387, 159, 737, 24, 70, "Notes",
 CellID->1131502365]
}, Closed]],
Cell[CellGroupData[{
Cell[5161, 188, 311, 9, 70, "SeeAlsoSection",
 CellID->21591],
Cell[5475, 199, 481, 17, 70, "SeeAlso",
 CellID->20896]
}, Open  ]],
Cell[5971, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

