(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8345,        298]
NotebookOptionsPosition[      5714,        212]
NotebookOutlinePosition[      7131,        252]
CellTagsIndexPosition[      7047,        247]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SignificanceLevel" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/SignificanceLevel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"SignificanceLevel\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ConfidenceLevel", "ObjectName",
 CellID->27124],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ConfidenceLevel"], "InlineFormula"],
     "\[LineSeparator]is an option to statistical functions that specifies \
the confidence level for confidence intervals."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18318]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
For confidence level \[Alpha], the probability that a confidence interval \
will contain the true value is \[Alpha].\
\>", "Notes",
 CellID->209021549],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["ConfidenceLevel"], "InlineFormula"],
 " can be any number between 0 and 1. The default setting is ",
 Cell[BoxData["0.95"], "InlineFormula"],
 "."
}], "Notes",
 CellID->9135]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->269634629],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->849971344],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->214848766],

Cell["A 99% confidence interval from a normal distribution:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormalCI", "[", 
  RowBox[{"1", ",", "2", ",", 
   RowBox[{"ConfidenceLevel", "\[Rule]", ".99"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129566985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4.151658607097801`"}], ",", "6.151658607097801`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->734081199]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9253],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["SignificanceLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/SignificanceLevel"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->6922]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1774],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->29859]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConfidenceLevel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 2.3836482}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {
     "confidence level", "confidence interval", "significance level", 
      "coverage probability"}, "index" -> True, "label" -> 
    "Hypothesis Testing Package Symbol", "language" -> "en", "paclet" -> 
    "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "ConfidenceLevel is an option to statistical functions that specifies the \
confidence level for confidence intervals.", "synonyms" -> {}, "title" -> 
    "ConfidenceLevel", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/ConfidenceLevel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3291, 115, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->269634629]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6904, 240}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1268, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1891, 61, 53, 1, 70, "ObjectName",
 CellID->27124],
Cell[1947, 64, 405, 11, 70, "Usage",
 CellID->18318]
}, Open  ]],
Cell[CellGroupData[{
Cell[2389, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2867, 97, 161, 4, 70, "Notes",
 CellID->209021549],
Cell[3031, 103, 223, 7, 70, "Notes",
 CellID->9135]
}, Closed]],
Cell[CellGroupData[{
Cell[3291, 115, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->269634629],
Cell[CellGroupData[{
Cell[3676, 129, 148, 5, 70, "ExampleSection",
 CellID->849971344],
Cell[3827, 136, 142, 4, 70, "Input",
 CellID->214848766],
Cell[3972, 142, 96, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[4093, 147, 183, 5, 28, "Input",
 CellID->129566985],
Cell[4279, 154, 260, 9, 36, "Output",
 CellID->734081199]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4600, 170, 310, 9, 70, "SeeAlsoSection",
 CellID->9253],
Cell[4913, 181, 231, 6, 70, "SeeAlso",
 CellID->6922]
}, Open  ]],
Cell[CellGroupData[{
Cell[5181, 192, 313, 9, 70, "TutorialsSection",
 CellID->1774],
Cell[5497, 203, 175, 4, 70, "Tutorials",
 CellID->29859]
}, Open  ]],
Cell[5687, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

