(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13857,        503]
NotebookOptionsPosition[     10620,        394]
NotebookOutlinePosition[     11984,        433]
CellTagsIndexPosition[     11899,        428]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VarianceRatioCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceRatioCI"], 
          "VarianceRatioTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceRatioTest"], "FRatioPValue" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/FRatioPValue"], "FRatioDistribution" :> 
          Documentation`HelpLookup["paclet:ref/FRatioDistribution"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"VarianceRatioCI\"\>", 
       2->"\<\"VarianceRatioTest\"\>", 3->"\<\"FRatioPValue\"\>", 
       4->"\<\"FRatioDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FRatioCI", "ObjectName",
 CellID->3989],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FRatioCI", "[", 
       RowBox[{
        StyleBox["ratio", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a confidence interval based on an F-ratio \
distribution with ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " degrees of freedom."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9320]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FRatioCI", "[", 
   RowBox[{
    StyleBox["ratio", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " gives a confidence interval ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["min", "TI"], ",", " ", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 " for a ratio of variances estimated by ",
 Cell[BoxData[
  StyleBox["ratio", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->129549755],

Cell[TextData[{
 "For confidence level \[Alpha], ",
 Cell[BoxData[
  RowBox[{
   StyleBox["min", "TI"], "=", 
   RowBox[{
    StyleBox["ratio", "TI"], "/", 
    SubscriptBox[
     StyleBox["q", "TI"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Alpha]"}], ")"}], "/", "2"}]]}]}]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["max", "TI"], "=", 
    RowBox[{
     StyleBox["ratio", "TI"], "/", 
     SubscriptBox[
      StyleBox["q", "TI"], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], "/", "2"}]]}]}], 
   TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["q", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " quantile of an F-ratio distribution with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " numerator and ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " denominator degrees of freedom."
}], "Notes",
 CellID->381223639],

Cell[TextData[{
 Cell[BoxData["FRatioCI"], "InlineFormula"],
 " is the confidence interval for a ratio of population variances based on \
sample variances estimated from samples of size ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "+", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "+", "1"}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->198048243],

Cell["The following option can be given:", "Notes",
 CellID->9658],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], "0.95", 
    Cell["probability associated with a confidence interval", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->11293]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->391721992],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->234080648],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->287146581],

Cell["A 95% confidence interval based on an F-ratio distribution:", \
"ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FRatioCI", "[", 
  RowBox[{"1", ",", "10", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->176484641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3605329776777269`", ",", "3.418543516185032`"}], "}"}]], "Output",\

 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->384006432]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12097],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ConfidenceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1295379749],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->147832938],

Cell["A 99% confidence interval:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FRatioCI", "[", 
  RowBox[{"1", ",", "10", ",", "20", ",", 
   RowBox[{"ConfidenceLevel", "\[Rule]", ".99"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129566985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2599426941883654`", ",", "5.274016748576593`"}], "}"}]], "Output",\

 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->889704334]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27171],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceRatioCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceRatioTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FRatioPValue",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/FRatioPValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FRatioDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FRatioDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29975]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17206],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->26578]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FRatioCI - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 2.7742832}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {
     "confidence interval", "variance test", "variance ratio test"}, "index" -> 
    True, "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "FRatioCI[ratio, n, m] gives a confidence interval based on an F-ratio \
distribution with n and m degrees of freedom.", "synonyms" -> {}, "title" -> 
    "FRatioCI", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/FRatioCI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6208, 216, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->391721992]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11756, 421}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1701, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2324, 68, 45, 1, 70, "ObjectName",
 CellID->3989],
Cell[2372, 71, 686, 22, 70, "Usage",
 CellID->9320]
}, Open  ]],
Cell[CellGroupData[{
Cell[3095, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3573, 115, 503, 18, 70, "Notes",
 CellID->129549755],
Cell[4079, 135, 1113, 44, 70, "Notes",
 CellID->381223639],
Cell[5195, 181, 412, 13, 70, "Notes",
 CellID->198048243],
Cell[5610, 196, 66, 1, 70, "Notes",
 CellID->9658],
Cell[5679, 199, 492, 12, 70, "3ColumnTableMod",
 CellID->11293]
}, Closed]],
Cell[CellGroupData[{
Cell[6208, 216, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->391721992],
Cell[CellGroupData[{
Cell[6593, 230, 148, 5, 70, "ExampleSection",
 CellID->234080648],
Cell[6744, 237, 142, 4, 70, "Input",
 CellID->287146581],
Cell[6889, 243, 100, 2, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[7014, 249, 139, 4, 28, "Input",
 CellID->176484641],
Cell[7156, 255, 241, 8, 36, "Output",
 CellID->384006432]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7446, 269, 218, 7, 70, "ExampleSection",
 CellID->12097],
Cell[CellGroupData[{
Cell[7689, 280, 237, 7, 70, "ExampleSubsection",
 CellID->1295379749],
Cell[7929, 289, 142, 4, 70, "Input",
 CellID->147832938],
Cell[8074, 295, 69, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[8168, 300, 195, 5, 70, "Input",
 CellID->129566985],
Cell[8366, 307, 241, 8, 36, "Output",
 CellID->889704334]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8680, 323, 311, 9, 70, "SeeAlsoSection",
 CellID->27171],
Cell[8994, 334, 1055, 35, 70, "SeeAlso",
 CellID->29975]
}, Open  ]],
Cell[CellGroupData[{
Cell[10086, 374, 314, 9, 70, "TutorialsSection",
 CellID->17206],
Cell[10403, 385, 175, 4, 70, "Tutorials",
 CellID->26578]
}, Open  ]],
Cell[10593, 392, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

