(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10858,        374]
NotebookOptionsPosition[      8342,        291]
NotebookOutlinePosition[      9641,        328]
CellTagsIndexPosition[      9557,        323]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeanTest" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/MeanTest"], 
          "MeanDifferenceTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/MeanDifferenceTest"], "VarianceTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceTest"], "VarianceRatioTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceRatioTest"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MeanTest\"\>", 
       2->"\<\"MeanDifferenceTest\"\>", 3->"\<\"VarianceTest\"\>", 
       4->"\<\"VarianceRatioTest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FullReport", "ObjectName",
 CellID->5140],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["FullReport"], "InlineFormula"],
     "\[LineSeparator]is an option to hypothesis test functions that \
specifies whether all report information should be returned."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26887]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"FullReport", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", only the p\[Hyphen]value for the test is returned."
}], "Notes",
 CellID->19688],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"FullReport", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", a table containing the estimate, test statistic, and distribution of the \
test statistic is also returned."
}], "Notes",
 CellID->109575290]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24580513],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->694443685],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->220399839],

Cell["A full report for a mean test:", "ExampleText",
 CellID->238475917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", "0", 
   ",", 
   RowBox[{"FullReport", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99892941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FullReport", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         TagBox["\<\"Mean\"\>",
          HoldForm], 
         TagBox["\<\"TestStat\"\>",
          HoldForm], 
         TagBox["\<\"Distribution\"\>",
          HoldForm]},
        {"3.2`", "3.719924439802217`", 
         RowBox[{"StudentTDistribution", "[", "4", "]"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {None, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {None, {"Mean", "TestStat", "Distribution"}}]]]}], 
   ",", 
   RowBox[{"OneSidedPValue", "\[Rule]", "0.010237937210455338`"}]}], 
  "}"}]], "Output",
 ImageSize->{556, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->310351148]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28630],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDifferenceTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceRatioTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioTest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->77],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->29559]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FullReport - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 3.2117944}", "context" -> 
    "HypothesisTesting`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hypothesis Testing Package Symbol", "language" -> "en", "paclet" -> 
    "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "FullReport is an option to hypothesis test functions that specifies \
whether all report information should be returned.", "synonyms" -> {}, 
    "title" -> "FullReport", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/FullReport"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3931, 130, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->24580513]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9415, 316}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1698, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2321, 68, 47, 1, 70, "ObjectName",
 CellID->5140],
Cell[2371, 71, 408, 11, 70, "Usage",
 CellID->26887]
}, Open  ]],
Cell[CellGroupData[{
Cell[2816, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3294, 104, 279, 9, 70, "Notes",
 CellID->19688],
Cell[3576, 115, 318, 10, 70, "Notes",
 CellID->109575290]
}, Closed]],
Cell[CellGroupData[{
Cell[3931, 130, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24580513],
Cell[CellGroupData[{
Cell[4315, 144, 148, 5, 70, "ExampleSection",
 CellID->694443685],
Cell[4466, 151, 142, 4, 70, "Input",
 CellID->220399839],
Cell[4611, 157, 73, 1, 70, "ExampleText",
 CellID->238475917],
Cell[CellGroupData[{
Cell[4709, 162, 261, 8, 28, "Input",
 CellID->99892941],
Cell[4973, 172, 1368, 41, 50, "Output",
 CellID->310351148]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6402, 220, 311, 9, 70, "SeeAlsoSection",
 CellID->28630],
Cell[6716, 231, 1058, 35, 70, "SeeAlso",
 CellID->6219]
}, Open  ]],
Cell[CellGroupData[{
Cell[7811, 271, 311, 9, 70, "TutorialsSection",
 CellID->77],
Cell[8125, 282, 175, 4, 70, "Tutorials",
 CellID->29559]
}, Open  ]],
Cell[8315, 289, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

