(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15228,        558]
NotebookOptionsPosition[     11214,        418]
NotebookOutlinePosition[     12920,        470]
CellTagsIndexPosition[     12809,        464]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NormalCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/NormalCI"], 
          "StudentTCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/StudentTCI"],
           "MeanTest" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/MeanTest"], 
          "MeanDifferenceCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/MeanDifferenceCI"], 
          "MeanDifferenceTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/MeanDifferenceTest"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NormalCI\"\>", 
       2->"\<\"StudentTCI\"\>", 3->"\<\"MeanTest\"\>", 
       4->"\<\"MeanDifferenceCI\"\>", 
       5->"\<\"MeanDifferenceTest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MeanCI", "ObjectName",
 CellID->7768],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MeanCI", "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a confidence interval for the population mean \
estimated from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4734]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MeanCI", "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " gives a confidence interval ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["min", "TI"], ",", " ", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 " centered at ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24199],

Cell[TextData[{
 "If the variance is assumed known, ",
 Cell[BoxData["MeanCI"], "InlineFormula"],
 " is based on the normal distribution."
}], "Notes",
 CellID->198048243],

Cell[TextData[{
 "If the variance is not assumed known, ",
 Cell[BoxData["MeanCI"], "InlineFormula"],
 " is based on Student's ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["list", "TI"], "]"}], "-", "1"}]], "InlineFormula"],
 " degrees of freedom."
}], "Notes",
 CellID->603557951],

Cell["The following options can be given:", "Notes",
 CellID->542],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], "0.95", 
    Cell["probability associated with a confidence interval", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["KnownVariance",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "variance of population", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->17537]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->498157662],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->718849519],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->422858380],

Cell["A 95% confidence interval for the population mean:", "ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell["MeanCI[{1,2,4,6,3}]", "Input",
 CellTags->"S5.96.1",
 CellLabel->"In[2]:=",
 CellID->8217],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8116116119000205`", ",", "5.58838838809998`"}], "}"}]], "Output",\

 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.96.1",
 CellLabel->"Out[2]=",
 CellID->353575794]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10753],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ConfidenceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22104],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->38977948],

Cell["A 99% confidence interval:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell["MeanCI[{1,2,4,6,3},ConfidenceLevel->.99]", "Input",
 CellTags->"S5.96.1",
 CellLabel->"In[2]:=",
 CellID->482226228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.7605921643675408`"}], ",", "7.160592164367541`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.96.1",
 CellLabel->"Out[2]=",
 CellID->174235427]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "KnownVariance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19095],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->95505266],

Cell["\<\
A 95% confidence interval assuming the population variance is 1:\
\>", "ExampleText",
 CellID->22410113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanCI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"KnownVariance", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5187626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.323477459423419`", ",", "4.0765225405765815`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->282464271]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13093],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/NormalCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/StudentTCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDifferenceCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDifferenceTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceTest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16584]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7355],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->13289]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeanCI - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 3.6180548}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {
     "confidence interval", "z test", "t test", "one sample t test"}, "index" -> 
    True, "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "MeanCI[list] gives a confidence interval for the population mean \
estimated from list.", "synonyms" -> {}, "title" -> "MeanCI", "type" -> 
    "Symbol", "uri" -> "HypothesisTesting/ref/MeanCI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5559, 187, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->498157662]},
 "S5.96.1"->{
  Cell[6354, 219, 96, 3, 28, "Input",
   CellTags->"S5.96.1",
   CellID->8217],
  Cell[6453, 224, 262, 9, 36, "Output",
   CellTags->"S5.96.1",
   CellID->353575794],
  Cell[7480, 270, 122, 3, 70, "Input",
   CellTags->"S5.96.1",
   CellID->482226228],
  Cell[7605, 275, 283, 10, 36, "Output",
   CellTags->"S5.96.1",
   CellID->174235427]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12310, 444},
 {"S5.96.1", 12444, 448}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1833, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2456, 72, 43, 1, 70, "ObjectName",
 CellID->7768],
Cell[2502, 75, 500, 16, 70, "Usage",
 CellID->4734]
}, Open  ]],
Cell[CellGroupData[{
Cell[3039, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3517, 113, 497, 19, 70, "Notes",
 CellID->24199],
Cell[4017, 134, 171, 5, 70, "Notes",
 CellID->198048243],
Cell[4191, 141, 464, 16, 70, "Notes",
 CellID->603557951],
Cell[4658, 159, 66, 1, 70, "Notes",
 CellID->542],
Cell[4727, 162, 795, 20, 70, "3ColumnTableMod",
 CellID->17537]
}, Closed]],
Cell[CellGroupData[{
Cell[5559, 187, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->498157662],
Cell[CellGroupData[{
Cell[5944, 201, 148, 5, 70, "ExampleSection",
 CellID->718849519],
Cell[6095, 208, 142, 4, 70, "Input",
 CellID->422858380],
Cell[6240, 214, 89, 1, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[6354, 219, 96, 3, 28, "Input",
 CellTags->"S5.96.1",
 CellID->8217],
Cell[6453, 224, 262, 9, 36, "Output",
 CellTags->"S5.96.1",
 CellID->353575794]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6764, 239, 218, 7, 70, "ExampleSection",
 CellID->10753],
Cell[CellGroupData[{
Cell[7007, 250, 232, 7, 70, "ExampleSubsection",
 CellID->22104],
Cell[7242, 259, 141, 4, 70, "Input",
 CellID->38977948],
Cell[7386, 265, 69, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[7480, 270, 122, 3, 70, "Input",
 CellTags->"S5.96.1",
 CellID->482226228],
Cell[7605, 275, 283, 10, 36, "Output",
 CellTags->"S5.96.1",
 CellID->174235427]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7937, 291, 230, 7, 70, "ExampleSubsection",
 CellID->19095],
Cell[8170, 300, 141, 4, 70, "Input",
 CellID->95505266],
Cell[8314, 306, 114, 3, 70, "ExampleText",
 CellID->22410113],
Cell[CellGroupData[{
Cell[8453, 313, 244, 7, 70, "Input",
 CellID->5187626],
Cell[8700, 322, 241, 8, 36, "Output",
 CellID->282464271]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9014, 338, 311, 9, 70, "SeeAlsoSection",
 CellID->13093],
Cell[9328, 349, 1316, 44, 70, "SeeAlso",
 CellID->16584]
}, Open  ]],
Cell[CellGroupData[{
Cell[10681, 398, 313, 9, 70, "TutorialsSection",
 CellID->7355],
Cell[10997, 409, 175, 4, 70, "Tutorials",
 CellID->13289]
}, Open  ]],
Cell[11187, 416, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

