(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20121,        730]
NotebookOptionsPosition[     15536,        569]
NotebookOutlinePosition[     17049,        614]
CellTagsIndexPosition[     16938,        608]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeanCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/MeanCI"], 
          "NormalCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/NormalCI"], 
          "StudentTCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/StudentTCI"],
           "MeanDifferenceTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/MeanDifferenceTest"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MeanCI\"\>", 2->"\<\"NormalCI\"\>", 
       3->"\<\"StudentTCI\"\>", 
       4->"\<\"MeanDifferenceTest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MeanTest", "ObjectName",
 CellID->1677],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MeanTest", "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        SubscriptBox[
         StyleBox["\[Mu]", "TR"], 
         StyleBox["0", "TR"]]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]performs a test with null hypothesis ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Mu]", "TR"], "=", 
       SubscriptBox[
        StyleBox["\[Mu]", "TR"], 
        StyleBox["0", "TR"]]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17575]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MeanTest", "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    SubscriptBox[
     StyleBox["\[Mu]", "TR"], 
     StyleBox["0", "TR"]]}], "]"}]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value for the test that the mean of the population from which ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " was sampled is significantly different from ",
 Cell[BoxData[
  SubscriptBox["\[Mu]", "0"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24199],

Cell[TextData[{
 "If the variance is assumed known, ",
 Cell[BoxData["MeanTest"], "InlineFormula"],
 " is based on the normal distribution."
}], "Notes",
 CellID->198048243],

Cell[TextData[{
 "If the variance is not assumed known, ",
 Cell[BoxData["MeanTest"], "InlineFormula"],
 " is based on Student's ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["list", "TI"], "]"}], "-", "1"}]], "InlineFormula"],
 " degrees of freedom."
}], "Notes",
 CellID->603557951],

Cell["The following options can be given:", "Notes",
 CellID->47],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FullReport",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/FullReport"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to include detailed information about a test", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["KnownVariance",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "variance of population", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SignificanceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/SignificanceLevel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "significance level of the test", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TwoSided",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to perform a two-sided test", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->30990],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FullReport",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/FullReport"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData["MeanTest"], "InlineFormula"],
 " also returns the sample mean, the test statistic, and the distribution \
used to generate the ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "-value."
}], "Notes",
 CellID->23340]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->313754029],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->760697784],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->23121742],

Cell["A test of the population mean against 0:", "ExampleText",
 CellID->28864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", "0"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22677],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.010237937210455338`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50701946]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12919],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FullReport",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12855],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->290787441],

Cell["A full report for a mean test:", "ExampleText",
 CellID->238475917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", "0", 
   ",", 
   RowBox[{"FullReport", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99892941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FullReport", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         TagBox["\<\"Mean\"\>",
          HoldForm], 
         TagBox["\<\"TestStat\"\>",
          HoldForm], 
         TagBox["\<\"Distribution\"\>",
          HoldForm]},
        {"3.2`", "3.719924439802217`", 
         RowBox[{"StudentTDistribution", "[", "4", "]"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {None, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {None, {"Mean", "TestStat", "Distribution"}}]]]}], 
   ",", 
   RowBox[{"OneSidedPValue", "\[Rule]", "0.010237937210455338`"}]}], 
  "}"}]], "Output",
 ImageSize->{556, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->310351148]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "KnownVariance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15727],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->93003428],

Cell["A test assuming the population variance is 5:", "ExampleText",
 CellID->22410113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", "0", 
   ",", 
   RowBox[{"KnownVariance", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5187626],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.0006871379379158485`"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3486311]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SignificanceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4665],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->89932874],

Cell["A test at significance level .01:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell["MeanTest[{1,2,4,6,3},0,SignificanceLevel->.01]", "Input",
 CellTags->"S5.96.1",
 CellLabel->"In[2]:=",
 CellID->482226228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OneSidedPValue", "\[Rule]", "0.010237937210455338`"}], ",", 
   RowBox[{"\<\"Fail to reject null hypothesis at significance level\"\>", 
    "\[Rule]", "0.01`"}]}], "}"}]], "Output",
 ImageSize->{426, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.96.1",
 CellLabel->"Out[2]=",
 CellID->14261893]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TwoSided",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->10300],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->181190360],

Cell["A two\[Hyphen]sided mean test:", "ExampleText",
 CellID->384802285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", "0", 
   ",", 
   RowBox[{"TwoSided", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->357402744],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.020475874420910676`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26254242]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23875],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/NormalCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/StudentTCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDifferenceTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceTest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30370]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4564],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->11500]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeanTest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 10.4151038}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {"z test", "t test", "one sample t test"}, "index" -> True, 
    "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "MeanTest[list, \\[Mu]_0] performs a test with null hypothesis \\[Mu] = \
\\[Mu]_0.", "synonyms" -> {}, "title" -> "MeanTest", "type" -> "Symbol", 
    "uri" -> "HypothesisTesting/ref/MeanTest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6869, 229, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->313754029]},
 "S5.96.1"->{
  Cell[12027, 432, 128, 3, 70, "Input",
   CellTags->"S5.96.1",
   CellID->482226228],
  Cell[12158, 437, 386, 11, 54, "Output",
   CellTags->"S5.96.1",
   CellID->14261893]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16605, 594},
 {"S5.96.1", 16739, 598}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1657, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2280, 68, 45, 1, 70, "ObjectName",
 CellID->1677],
Cell[2328, 71, 695, 23, 70, "Usage",
 CellID->17575]
}, Open  ]],
Cell[CellGroupData[{
Cell[3060, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3538, 116, 564, 19, 70, "Notes",
 CellID->24199],
Cell[4105, 137, 173, 5, 70, "Notes",
 CellID->198048243],
Cell[4281, 144, 466, 16, 70, "Notes",
 CellID->603557951],
Cell[4750, 162, 65, 1, 70, "Notes",
 CellID->47],
Cell[4818, 165, 1493, 39, 70, "3ColumnTableMod",
 CellID->30990],
Cell[6314, 206, 518, 18, 70, "Notes",
 CellID->23340]
}, Closed]],
Cell[CellGroupData[{
Cell[6869, 229, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->313754029],
Cell[CellGroupData[{
Cell[7254, 243, 148, 5, 70, "ExampleSection",
 CellID->760697784],
Cell[7405, 250, 141, 4, 70, "Input",
 CellID->23121742],
Cell[7549, 256, 79, 1, 70, "ExampleText",
 CellID->28864],
Cell[CellGroupData[{
Cell[7653, 261, 205, 7, 28, "Input",
 CellID->22677],
Cell[7861, 270, 219, 6, 36, "Output",
 CellID->50701946]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8129, 282, 218, 7, 70, "ExampleSection",
 CellID->12919],
Cell[CellGroupData[{
Cell[8372, 293, 227, 7, 70, "ExampleSubsection",
 CellID->12855],
Cell[8602, 302, 142, 4, 70, "Input",
 CellID->290787441],
Cell[8747, 308, 73, 1, 70, "ExampleText",
 CellID->238475917],
Cell[CellGroupData[{
Cell[8845, 313, 261, 8, 70, "Input",
 CellID->99892941],
Cell[9109, 323, 1368, 41, 50, "Output",
 CellID->310351148]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10526, 370, 230, 7, 70, "ExampleSubsection",
 CellID->15727],
Cell[10759, 379, 141, 4, 70, "Input",
 CellID->93003428],
Cell[10903, 385, 87, 1, 70, "ExampleText",
 CellID->22410113],
Cell[CellGroupData[{
Cell[11015, 390, 260, 8, 70, "Input",
 CellID->5187626],
Cell[11278, 400, 219, 6, 36, "Output",
 CellID->3486311]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11546, 412, 233, 7, 70, "ExampleSubsection",
 CellID->4665],
Cell[11782, 421, 141, 4, 70, "Input",
 CellID->89932874],
Cell[11926, 427, 76, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[12027, 432, 128, 3, 70, "Input",
 CellTags->"S5.96.1",
 CellID->482226228],
Cell[12158, 437, 386, 11, 54, "Output",
 CellTags->"S5.96.1",
 CellID->14261893]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12593, 454, 225, 7, 70, "ExampleSubsection",
 CellID->10300],
Cell[12821, 463, 142, 4, 70, "Input",
 CellID->181190360],
Cell[12966, 469, 73, 1, 70, "ExampleText",
 CellID->384802285],
Cell[CellGroupData[{
Cell[13064, 474, 260, 8, 70, "Input",
 CellID->357402744],
Cell[13327, 484, 219, 6, 36, "Output",
 CellID->26254242]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13619, 498, 311, 9, 70, "SeeAlsoSection",
 CellID->23875],
Cell[13933, 509, 1033, 35, 70, "SeeAlso",
 CellID->30370]
}, Open  ]],
Cell[CellGroupData[{
Cell[15003, 549, 313, 9, 70, "TutorialsSection",
 CellID->4564],
Cell[15319, 560, 175, 4, 70, "Tutorials",
 CellID->11500]
}, Open  ]],
Cell[15509, 567, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

