(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12308,        450]
NotebookOptionsPosition[      9170,        344]
NotebookOutlinePosition[     10519,        382]
CellTagsIndexPosition[     10434,        377]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NormalCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/NormalCI"], 
          "NormalDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NormalDistribution"], 
          "StudentTPValue" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/StudentTPValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NormalCI\"\>", 
       2->"\<\"NormalDistribution\"\>", 
       3->"\<\"StudentTPValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NormalPValue", "ObjectName",
 CellID->27147],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NormalPValue", "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the cumulative density beyond ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " for a normal distribution with zero mean and unit variance."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->371]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The one-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["NormalDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NormalDistribution"], "[", 
     RowBox[{"0", ",", "1"}], "]"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " for x<0, and  ",
 Cell[BoxData[
  RowBox[{"1", "-", 
   RowBox[{
    ButtonBox["CDF",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CDF"], "[", 
    RowBox[{
     RowBox[{
      ButtonBox["NormalDistribution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NormalDistribution"], "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", 
     StyleBox["x", "TI"]}], "]"}]}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[GreaterEqual]", "0"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15717],

Cell[TextData[{
 "The two-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value is twice the one-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value."
}], "Notes",
 CellID->521369599],

Cell["The following options can be given:", "Notes",
 CellID->26633],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TwoSided",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to perform a two-sided test", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->24312]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4022635],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->82779843],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->86308912],

Cell["The p\[Hyphen]value for -2:", "ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormalPValue", "[", 
  RowBox[{"-", "2."}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10648],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.02275013194817921`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27932]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12075],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TwoSided",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1295379749],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->569041498],

Cell["A two\[Hyphen]sided p\[Hyphen]value:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormalPValue", "[", 
  RowBox[{
   RowBox[{"-", "2."}], ",", 
   RowBox[{"TwoSided", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129566985],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.04550026389635842`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48333904]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4685],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/NormalCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTPValue",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/StudentTPValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28086]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7862],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->5320]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NormalPValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 10.8838658}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {"z statistic", "z test", "p\\[Hyphen]value"}, "index" -> 
    True, "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "NormalPValue[x] gives the cumulative density beyond x for a normal \
distribution with zero mean and unit variance.", "synonyms" -> {}, "title" -> 
    "NormalPValue", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/NormalPValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5156, 179, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4022635]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10293, 370}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1531, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2154, 66, 50, 1, 70, "ObjectName",
 CellID->27147],
Cell[2207, 69, 526, 15, 70, "Usage",
 CellID->371]
}, Open  ]],
Cell[CellGroupData[{
Cell[2770, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3248, 106, 1009, 37, 70, "Notes",
 CellID->15717],
Cell[4260, 145, 243, 9, 70, "Notes",
 CellID->521369599],
Cell[4506, 156, 68, 1, 70, "Notes",
 CellID->26633],
Cell[4577, 159, 542, 15, 70, "3ColumnTableMod",
 CellID->24312]
}, Closed]],
Cell[CellGroupData[{
Cell[5156, 179, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4022635],
Cell[CellGroupData[{
Cell[5539, 193, 147, 5, 70, "ExampleSection",
 CellID->82779843],
Cell[5689, 200, 141, 4, 70, "Input",
 CellID->86308912],
Cell[5833, 206, 66, 1, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[5924, 211, 123, 4, 28, "Input",
 CellID->10648],
Cell[6050, 217, 215, 6, 36, "Output",
 CellID->27932]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6314, 229, 218, 7, 70, "ExampleSection",
 CellID->12075],
Cell[CellGroupData[{
Cell[6557, 240, 230, 7, 70, "ExampleSubsection",
 CellID->1295379749],
Cell[6790, 249, 142, 4, 70, "Input",
 CellID->569041498],
Cell[6935, 255, 79, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[7039, 260, 191, 6, 70, "Input",
 CellID->129566985],
Cell[7233, 268, 218, 6, 36, "Output",
 CellID->48333904]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7524, 282, 310, 9, 70, "SeeAlsoSection",
 CellID->4685],
Cell[7837, 293, 764, 26, 70, "SeeAlso",
 CellID->28086]
}, Open  ]],
Cell[CellGroupData[{
Cell[8638, 324, 313, 9, 70, "TutorialsSection",
 CellID->7862],
Cell[8954, 335, 174, 4, 70, "Tutorials",
 CellID->5320]
}, Open  ]],
Cell[9143, 342, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

