(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8842,        319]
NotebookOptionsPosition[      6148,        229]
NotebookOutlinePosition[      7646,        273]
CellTagsIndexPosition[      7537,        267]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TwoSided" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/TwoSided"], 
          "TwoSidedPValue" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/TwoSidedPValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TwoSided\"\>", 
       2->"\<\"TwoSidedPValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OneSidedPValue", "ObjectName",
 CellID->18284],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["OneSidedPValue"], "InlineFormula"],
     "\[LineSeparator]is an element in hypothesis test output for \
one\[Hyphen]sided tests."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8106]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In hypothesis test functions, if ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TwoSided",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the p\[Hyphen]value ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " for the test is returned as the rule ",
 Cell[BoxData[
  RowBox[{"OneSidedPValue", "->", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->251368302]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127504948],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->273706129],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1959711],

Cell["\<\
The p\[Hyphen]value for a one\[Hyphen]sided test:\
\>", "ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell["MeanTest[{1,2,4,6,3}, 0, TwoSided->False]", "Input",
 CellTags->"S5.96.1",
 CellLabel->"In[2]:=",
 CellID->8217],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.010237937210455338`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.96.1",
 CellLabel->"Out[2]=",
 CellID->346930238]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27123],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TwoSided",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/TwoSided"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TwoSidedPValue",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/TwoSidedPValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6258],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->27397]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OneSidedPValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 11.1182468}", "context" -> 
    "HypothesisTesting`", "keywords" -> {"one\\[Hyphen]sided test"}, "index" -> 
    True, "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "OneSidedPValue is an element in hypothesis test output for one-sided \
tests.", "synonyms" -> {}, "title" -> "OneSidedPValue", "type" -> "Symbol", 
    "uri" -> "HypothesisTesting/ref/OneSidedPValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3542, 123, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->127504948]},
 "S5.96.1"->{
  Cell[4342, 157, 118, 3, 28, "Input",
   CellTags->"S5.96.1",
   CellID->8217],
  Cell[4463, 162, 242, 7, 36, "Output",
   CellTags->"S5.96.1",
   CellID->346930238]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7211, 253},
 {"S5.96.1", 7345, 257}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1385, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2008, 63, 52, 1, 70, "ObjectName",
 CellID->18284],
Cell[2063, 66, 372, 11, 70, "Usage",
 CellID->8106]
}, Open  ]],
Cell[CellGroupData[{
Cell[2472, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2950, 99, 555, 19, 70, "Notes",
 CellID->251368302]
}, Closed]],
Cell[CellGroupData[{
Cell[3542, 123, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127504948],
Cell[CellGroupData[{
Cell[3927, 137, 148, 5, 70, "ExampleSection",
 CellID->273706129],
Cell[4078, 144, 140, 4, 70, "Input",
 CellID->1959711],
Cell[4221, 150, 96, 3, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[4342, 157, 118, 3, 28, "Input",
 CellTags->"S5.96.1",
 CellID->8217],
Cell[4463, 162, 242, 7, 36, "Output",
 CellTags->"S5.96.1",
 CellID->346930238]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4766, 176, 311, 9, 70, "SeeAlsoSection",
 CellID->27123],
Cell[5080, 187, 498, 17, 70, "SeeAlso",
 CellID->5256]
}, Open  ]],
Cell[CellGroupData[{
Cell[5615, 209, 313, 9, 70, "TutorialsSection",
 CellID->6258],
Cell[5931, 220, 175, 4, 70, "Tutorials",
 CellID->27397]
}, Open  ]],
Cell[6121, 227, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

