(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12812,        468]
NotebookOptionsPosition[      9651,        362]
NotebookOutlinePosition[     11015,        400]
CellTagsIndexPosition[     10930,        395]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StudentTCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/StudentTCI"],
           "StudentTDistribution" :> 
          Documentation`HelpLookup["paclet:ref/StudentTDistribution"], 
          "NormalPValue" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/NormalPValue"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"StudentTCI\"\>", 
       2->"\<\"StudentTDistribution\"\>", 
       3->"\<\"NormalPValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StudentTPValue", "ObjectName",
 CellID->25100],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"StudentTPValue", "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["df", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the cumulative probability beyond ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " for Student's ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["df", "TI"]], "InlineFormula"],
     " degrees of freedom."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27761]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The one-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["StudentTDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StudentTDistribution"], "[", 
     StyleBox["df", "TI"], "]"}], ",", 
    StyleBox["teststat", "TI"]}], "]"}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "<", "0"}]], "InlineFormula"],
 ", and  ",
 Cell[BoxData[
  RowBox[{"1", "-", 
   RowBox[{
    ButtonBox["CDF",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CDF"], "[", 
    RowBox[{
     RowBox[{
      ButtonBox["StudentTDistribution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StudentTDistribution"], "[", 
      StyleBox["df", "TI"], "]"}], ",", 
     StyleBox["teststat", "TI"]}], "]"}]}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[GreaterEqual]", "0"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15717],

Cell[TextData[{
 "The two-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value is twice the one-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value."
}], "Notes",
 CellID->521369599],

Cell["The following option can be given:", "Notes",
 CellID->13965],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TwoSided",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to perform a two-sided test", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->4539]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->378823271],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->86279061],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->59261778],

Cell[TextData[{
 "The p\[Hyphen]value for -2 in a ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with 5 degrees of freedom:"
}], "ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StudentTPValue", "[", 
  RowBox[{
   RowBox[{"-", "2."}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29807],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.050969739414929174`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54709999]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30095],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TwoSided",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1295379749],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->277200444],

Cell["A two\[Hyphen]sided p\[Hyphen]value:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StudentTPValue", "[", 
  RowBox[{
   RowBox[{"-", "2."}], ",", "5", ",", 
   RowBox[{"TwoSided", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129566985],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.10193947882985835`"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87722063]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10053],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/StudentTCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StudentTDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalPValue",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/NormalPValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6002]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19501],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->6423]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StudentTPValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 11.7120120}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {"t statistic", "t test", "p\\[Hyphen]value"}, "index" -> 
    True, "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "StudentTPValue[x, df] gives the cumulative probability beyond x for \
Student's t distribution with df degrees of freedom.", "synonyms" -> {}, 
    "title" -> "StudentTPValue", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/StudentTPValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5466, 191, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->378823271]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10787, 388}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1537, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2160, 66, 52, 1, 70, "ObjectName",
 CellID->25100],
Cell[2215, 69, 731, 23, 70, "Usage",
 CellID->27761]
}, Open  ]],
Cell[CellGroupData[{
Cell[2983, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3461, 114, 1108, 41, 70, "Notes",
 CellID->15717],
Cell[4572, 157, 243, 9, 70, "Notes",
 CellID->521369599],
Cell[4818, 168, 67, 1, 70, "Notes",
 CellID->13965],
Cell[4888, 171, 541, 15, 70, "3ColumnTableMod",
 CellID->4539]
}, Closed]],
Cell[CellGroupData[{
Cell[5466, 191, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->378823271],
Cell[CellGroupData[{
Cell[5851, 205, 147, 5, 70, "ExampleSection",
 CellID->86279061],
Cell[6001, 212, 141, 4, 70, "Input",
 CellID->59261778],
Cell[6145, 218, 188, 6, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[6358, 228, 149, 5, 28, "Input",
 CellID->29807],
Cell[6510, 235, 219, 6, 36, "Output",
 CellID->54709999]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6778, 247, 218, 7, 70, "ExampleSection",
 CellID->30095],
Cell[CellGroupData[{
Cell[7021, 258, 230, 7, 70, "ExampleSubsection",
 CellID->1295379749],
Cell[7254, 267, 142, 4, 70, "Input",
 CellID->277200444],
Cell[7399, 273, 79, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[7503, 278, 203, 6, 70, "Input",
 CellID->129566985],
Cell[7709, 286, 218, 6, 36, "Output",
 CellID->87722063]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8000, 300, 311, 9, 70, "SeeAlsoSection",
 CellID->10053],
Cell[8314, 311, 767, 26, 70, "SeeAlso",
 CellID->6002]
}, Open  ]],
Cell[CellGroupData[{
Cell[9118, 342, 314, 9, 70, "TutorialsSection",
 CellID->19501],
Cell[9435, 353, 174, 4, 70, "Tutorials",
 CellID->6423]
}, Open  ]],
Cell[9624, 360, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

