(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9539,        340]
NotebookOptionsPosition[      6734,        245]
NotebookOutlinePosition[      8284,        292]
CellTagsIndexPosition[      8175,        286]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SignificanceLevel" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/SignificanceLevel"], 
          "TwoSidedPValue" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/TwoSidedPValue"], "OneSidedPValue" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/OneSidedPValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SignificanceLevel\"\>", 
       2->"\<\"TwoSidedPValue\"\>", 
       3->"\<\"OneSidedPValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TwoSided", "ObjectName",
 CellID->26658],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["TwoSided"], "InlineFormula"],
     "\[LineSeparator]is an option to hypothesis test functions that \
specifies whether the test should be two\[Hyphen]sided."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14799]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With default setting ",
 Cell[BoxData[
  RowBox[{"TwoSided", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the p\[Hyphen]value is associated with the smaller tail of the \
distribution of the test statistics."
}], "Notes",
 CellID->15961],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"TwoSided", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the p\[Hyphen]value is split between the two tails of the distribution of \
the test statistic."
}], "Notes",
 CellID->880461052]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323057871],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->717082854],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->271365976],

Cell["\<\
The p\[Hyphen]value for a one\[Hyphen]sided test:\
\>", "ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell["MeanTest[{1,2,4,6,3}, 0, TwoSided->False]", "Input",
 CellTags->"S5.96.1",
 CellLabel->"In[2]:=",
 CellID->8217],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.010237937210455338`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.96.1",
 CellLabel->"Out[2]=",
 CellID->151510666]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8113],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SignificanceLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/SignificanceLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TwoSidedPValue",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/TwoSidedPValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OneSidedPValue",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/OneSidedPValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11656]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8380],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->21374]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TwoSided - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 11.9307676}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {"one\\[Hyphen]sided test", "two\\[Hyphen]sided test"}, 
    "index" -> True, "label" -> "Hypothesis Testing Package Symbol", 
    "language" -> "en", "paclet" -> "HypothesisTesting Package", "status" -> 
    "None", "summary" -> 
    "TwoSided is an option to hypothesis test functions that specifies \
whether the test should be two-sided.", "synonyms" -> {}, "title" -> 
    "TwoSided", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/TwoSided"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3833, 130, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->323057871]},
 "S5.96.1"->{
  Cell[4635, 164, 118, 3, 28, "Input",
   CellTags->"S5.96.1",
   CellID->8217],
  Cell[4756, 169, 242, 7, 36, "Output",
   CellTags->"S5.96.1",
   CellID->151510666]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7849, 272},
 {"S5.96.1", 7983, 276}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1577, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2200, 67, 46, 1, 70, "ObjectName",
 CellID->26658],
Cell[2249, 70, 401, 11, 70, "Usage",
 CellID->14799]
}, Open  ]],
Cell[CellGroupData[{
Cell[2687, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3165, 103, 324, 10, 70, "Notes",
 CellID->15961],
Cell[3492, 115, 304, 10, 70, "Notes",
 CellID->880461052]
}, Closed]],
Cell[CellGroupData[{
Cell[3833, 130, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323057871],
Cell[CellGroupData[{
Cell[4218, 144, 148, 5, 70, "ExampleSection",
 CellID->717082854],
Cell[4369, 151, 142, 4, 70, "Input",
 CellID->271365976],
Cell[4514, 157, 96, 3, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[4635, 164, 118, 3, 28, "Input",
 CellTags->"S5.96.1",
 CellID->8217],
Cell[4756, 169, 242, 7, 36, "Output",
 CellTags->"S5.96.1",
 CellID->151510666]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5059, 183, 310, 9, 70, "SeeAlsoSection",
 CellID->8113],
Cell[5372, 194, 792, 26, 70, "SeeAlso",
 CellID->11656]
}, Open  ]],
Cell[CellGroupData[{
Cell[6201, 225, 313, 9, 70, "TutorialsSection",
 CellID->8380],
Cell[6517, 236, 175, 4, 70, "Tutorials",
 CellID->21374]
}, Open  ]],
Cell[6707, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

