(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15013,        551]
NotebookOptionsPosition[     11794,        444]
NotebookOutlinePosition[     13205,        483]
CellTagsIndexPosition[     13120,        478]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VarianceRatioTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceRatioTest"], "VarianceCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/VarianceCI"],
           "FRatioCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/FRatioCI"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"VarianceRatioTest\"\>", 2->"\<\"VarianceCI\"\>", 
       3->"\<\"FRatioCI\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VarianceRatioCI", "ObjectName",
 CellID->8719],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VarianceRatioCI", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a confidence interval for the ratio of the \
population variances estimated from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26790]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"VarianceRatioCI", "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " gives a confidence interval ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["min", "TI"], ",", " ", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 " for a ratio of the population variances estimated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"], "[", 
   SubscriptBox[
    StyleBox["list", "TI"], 
    StyleBox["1", "TR"]], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"], "[", 
   SubscriptBox[
    StyleBox["list", "TI"], 
    StyleBox["2", "TR"]], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->129549755],

Cell[TextData[{
 "For confidence level \[Alpha], ",
 Cell[BoxData[
  RowBox[{
   StyleBox["min", "TI"], "=", 
   RowBox[{
    StyleBox["ratio", "TI"], "/", 
    SubscriptBox[
     StyleBox["q", "TI"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Alpha]"}], ")"}], "/", "2"}]]}]}]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["max", "TI"], "=", 
    RowBox[{
     StyleBox["ratio", "TI"], "/", 
     SubscriptBox[
      StyleBox["q", "TI"], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], "/", "2"}]]}]}], 
   TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["ratio", "TI"], "=", 
   RowBox[{
    RowBox[{
     ButtonBox["Variance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variance"], "[", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], "]"}], "/", 
    RowBox[{
     ButtonBox["Variance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variance"], "[", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], "]"}]}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["q", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " quantile of an F-ratio distribution with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], "]"}], "-", "1"}]], "InlineFormula"],
 " numerator and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], "]"}], "-", "1"}]], "InlineFormula"],
 " denominator degrees of freedom."
}], "Notes",
 CellID->381223639],

Cell["The following option can be given:", "Notes",
 CellID->3351],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], "0.95", 
    Cell["probability associated with a confidence interval", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->8329]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->585101872],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->442900992],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->411573091],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"95", "%"}]], "InlineFormula"],
 " confidence interval for the ratio of two population variances:"
}], "ExampleText",
 CellID->19668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceRatioCI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24484],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.10083621593974769`", ",", "6.976216513790082`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->408812198]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13998],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ConfidenceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8880],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->152007453],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"99", "%"}]], "InlineFormula"],
 " confidence interval:"
}], "ExampleText",
 CellID->770582629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceRatioCI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", 
   RowBox[{"ConfidenceLevel", "\[Rule]", ".99"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->859789852],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.04788914752920183`", ",", "16.729283456658088`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->124813565]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12189],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceRatioTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FRatioCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/FRatioCI"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15787]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16290],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->22974]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VarianceRatioCI - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 18.6184388}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {
     "confidence interval", "variance test", "variance ratio test"}, "index" -> 
    True, "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "VarianceRatioCI[list_1, list_2] gives a confidence interval for the \
ratio of the population variances estimated from list_1 and from list_2.", 
    "synonyms" -> {}, "title" -> "VarianceRatioCI", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/VarianceRatioCI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7176, 256, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->585101872]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12977, 471}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1527, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2150, 65, 52, 1, 70, "ObjectName",
 CellID->8719],
Cell[2205, 68, 884, 29, 70, "Usage",
 CellID->26790]
}, Open  ]],
Cell[CellGroupData[{
Cell[3126, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3604, 119, 975, 36, 70, "Notes",
 CellID->129549755],
Cell[4582, 157, 1994, 77, 70, "Notes",
 CellID->381223639],
Cell[6579, 236, 66, 1, 70, "Notes",
 CellID->3351],
Cell[6648, 239, 491, 12, 70, "3ColumnTableMod",
 CellID->8329]
}, Closed]],
Cell[CellGroupData[{
Cell[7176, 256, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->585101872],
Cell[CellGroupData[{
Cell[7561, 270, 148, 5, 70, "ExampleSection",
 CellID->442900992],
Cell[7712, 277, 142, 4, 70, "Input",
 CellID->411573091],
Cell[7857, 283, 183, 6, 70, "ExampleText",
 CellID->19668],
Cell[CellGroupData[{
Cell[8065, 293, 302, 9, 28, "Input",
 CellID->24484],
Cell[8370, 304, 243, 8, 36, "Output",
 CellID->408812198]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8662, 318, 218, 7, 70, "ExampleSection",
 CellID->13998],
Cell[CellGroupData[{
Cell[8905, 329, 231, 7, 70, "ExampleSubsection",
 CellID->8880],
Cell[9139, 338, 142, 4, 70, "Input",
 CellID->152007453],
Cell[9284, 344, 145, 6, 70, "ExampleText",
 CellID->770582629],
Cell[CellGroupData[{
Cell[9454, 354, 363, 10, 70, "Input",
 CellID->859789852],
Cell[9820, 366, 244, 8, 36, "Output",
 CellID->124813565]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10137, 382, 311, 9, 70, "SeeAlsoSection",
 CellID->12189],
Cell[10451, 393, 772, 26, 70, "SeeAlso",
 CellID->15787]
}, Open  ]],
Cell[CellGroupData[{
Cell[11260, 424, 314, 9, 70, "TutorialsSection",
 CellID->16290],
Cell[11577, 435, 175, 4, 70, "Tutorials",
 CellID->22974]
}, Open  ]],
Cell[11767, 442, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

