(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19382,        700]
NotebookOptionsPosition[     15164,        554]
NotebookOutlinePosition[     16679,        598]
CellTagsIndexPosition[     16568,        592]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VarianceCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/VarianceCI"],
           "ChiSquareCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/ChiSquareCI"], "VarianceRatioCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceRatioCI"], 
          "VarianceRatioTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceRatioTest"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"VarianceCI\"\>", 
       2->"\<\"ChiSquareCI\"\>", 3->"\<\"VarianceRatioCI\"\>", 
       4->"\<\"VarianceRatioTest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VarianceTest", "ObjectName",
 CellID->9711],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VarianceTest", "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        SuperscriptBox[
         SubscriptBox[
          StyleBox["\[Sigma]", "TR"], 
          StyleBox["0", "TR"]], "2"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]performs a test with null hypothesis ",
     Cell[BoxData[
      RowBox[{
       SuperscriptBox[
        StyleBox["\[Sigma]", "TR"], "2"], "=", 
       SuperscriptBox[
        SubscriptBox[
         StyleBox["\[Sigma]", "TR"], 
         StyleBox["0", "TR"]], "2"]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25066]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"VarianceTest", "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    SuperscriptBox[
     SubscriptBox[
      StyleBox["\[Sigma]", "TI"], "0"], "2"]}], "]"}]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value for the test that the variance of the population from which \
",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " was sampled is significantly different from ",
 Cell[BoxData[
  SuperscriptBox[
   SubscriptBox[
    StyleBox["\[Sigma]", "TR"], 
    StyleBox["0", "TR"]], "2"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24199],

Cell[TextData[{
 Cell[BoxData["VarianceTest"], "InlineFormula"],
 " uses the test statistic ",
 Cell[BoxData[
  RowBox[{
   StyleBox["df", "TI"], " ", 
   RowBox[{
    StyleBox["var", "TI"], "/", 
    SuperscriptBox[
     SubscriptBox[
      StyleBox["\[Sigma]", "TR"], 
      StyleBox["0", "TR"]], "2"]}]}]], "InlineFormula"],
 ",  where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["var", "TI"], "=", 
   RowBox[{
    ButtonBox["Variance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Variance"], "[", 
    StyleBox["list", "TI"], "]"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["df", "TI"], "=", 
   RowBox[{
    RowBox[{
     ButtonBox["Length",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Length"], "[", 
     StyleBox["list", "TI"], "]"}], "-", "1"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->381223639],

Cell[TextData[{
 Cell[BoxData["VarianceTest"], "InlineFormula"],
 " is based on a ",
 Cell[BoxData[
  SuperscriptBox["\[Chi]", "2"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["list", "TI"], "]"}], "-", "1"}]], "InlineFormula"],
 " degrees of freedom."
}], "Notes",
 CellID->15830117],

Cell["The following options can be given:", "Notes",
 CellID->9942],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FullReport",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/FullReport"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to include detailed information about a test", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SignificanceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/SignificanceLevel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "significance level of the test", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TwoSided",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to perform a two-sided test", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->32643],

Cell[TextData[{
 "With the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FullReport",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/FullReport"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData["VarianceTest"], "InlineFormula"],
 " also returns the sample variance, the test statistic, and the distribution \
used to generate the ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "-value."
}], "Notes",
 CellID->1500]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->322382848],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->148659562],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->52913147],

Cell["A test of the population variance against 1:", "ExampleText",
 CellID->28864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31920],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.005134523193488408`"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47959474]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28116],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FullReport",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29723],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->168477694],

Cell["A full report for a variance test:", "ExampleText",
 CellID->238475917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", "1", 
   ",", 
   RowBox[{"FullReport", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99892941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FullReport", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         TagBox["\<\"Variance\"\>",
          HoldForm], 
         TagBox["\<\"TestStat\"\>",
          HoldForm], 
         TagBox["\<\"Distribution\"\>",
          HoldForm]},
        {"3.7`", "14.8`", 
         RowBox[{"ChiSquareDistribution", "[", "4", "]"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {None, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {None, {"Variance", "TestStat", "Distribution"}}]]]}],
    ",", 
   RowBox[{"OneSidedPValue", "\[Rule]", "0.005134523193488408`"}]}], 
  "}"}]], "Output",
 ImageSize->{403, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->733036267]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SignificanceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4285],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->66336206],

Cell["A test at significance level .01:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell["VarianceTest[{1,2,4,6,3},1,SignificanceLevel->.01]", "Input",
 CellTags->"S5.96.1",
 CellLabel->"In[2]:=",
 CellID->482226228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OneSidedPValue", "\[Rule]", "0.005134523193488408`"}], ",", 
   RowBox[{"\<\"Reject null hypothesis at significance level\"\>", "\[Rule]", 
    "0.01`"}]}], "}"}]], "Output",
 ImageSize->{566, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.96.1",
 CellLabel->"Out[2]=",
 CellID->14986704]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TwoSided",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15203],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->428921907],

Cell["A two\[Hyphen]sided variance test:", "ExampleText",
 CellID->384802285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", "1", 
   ",", 
   RowBox[{"TwoSided", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->357402744],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.010269046386976816`"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125576655]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->182],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChiSquareCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/ChiSquareCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceRatioCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceRatioTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioTest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1916]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5209],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->24534]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VarianceTest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 19.1028262}", "context" -> 
    "HypothesisTesting`", "keywords" -> {"variance test"}, "index" -> True, 
    "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "VarianceTest[list, \\[Sigma]_0 2] performs a test with null hypothesis \
\\[Sigma]^2 = \\[Sigma]_0 2.", "synonyms" -> {}, "title" -> "VarianceTest", 
    "type" -> "Symbol", "uri" -> "HypothesisTesting/ref/VarianceTest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7481, 256, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->322382848]},
 "S5.96.1"->{
  Cell[11631, 417, 132, 3, 70, "Input",
   CellTags->"S5.96.1",
   CellID->482226228],
  Cell[11766, 422, 378, 11, 36, "Output",
   CellTags->"S5.96.1",
   CellID->14986704]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16235, 578},
 {"S5.96.1", 16369, 582}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1703, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2326, 69, 49, 1, 70, "ObjectName",
 CellID->9711],
Cell[2378, 72, 803, 26, 70, "Usage",
 CellID->25066]
}, Open  ]],
Cell[CellGroupData[{
Cell[3218, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3696, 120, 653, 23, 70, "Notes",
 CellID->24199],
Cell[4352, 145, 859, 33, 70, "Notes",
 CellID->381223639],
Cell[5214, 180, 428, 15, 70, "Notes",
 CellID->15830117],
Cell[5645, 197, 67, 1, 70, "Notes",
 CellID->9942],
Cell[5715, 200, 1190, 31, 70, "3ColumnTableMod",
 CellID->32643],
Cell[6908, 233, 536, 18, 70, "Notes",
 CellID->1500]
}, Closed]],
Cell[CellGroupData[{
Cell[7481, 256, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->322382848],
Cell[CellGroupData[{
Cell[7866, 270, 148, 5, 70, "ExampleSection",
 CellID->148659562],
Cell[8017, 277, 141, 4, 70, "Input",
 CellID->52913147],
Cell[8161, 283, 83, 1, 70, "ExampleText",
 CellID->28864],
Cell[CellGroupData[{
Cell[8269, 288, 209, 7, 28, "Input",
 CellID->31920],
Cell[8481, 297, 219, 6, 36, "Output",
 CellID->47959474]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8749, 309, 218, 7, 70, "ExampleSection",
 CellID->28116],
Cell[CellGroupData[{
Cell[8992, 320, 227, 7, 70, "ExampleSubsection",
 CellID->29723],
Cell[9222, 329, 142, 4, 70, "Input",
 CellID->168477694],
Cell[9367, 335, 77, 1, 70, "ExampleText",
 CellID->238475917],
Cell[CellGroupData[{
Cell[9469, 340, 265, 8, 70, "Input",
 CellID->99892941],
Cell[9737, 350, 1364, 41, 72, "Output",
 CellID->733036267]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11150, 397, 233, 7, 70, "ExampleSubsection",
 CellID->4285],
Cell[11386, 406, 141, 4, 70, "Input",
 CellID->66336206],
Cell[11530, 412, 76, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[11631, 417, 132, 3, 70, "Input",
 CellTags->"S5.96.1",
 CellID->482226228],
Cell[11766, 422, 378, 11, 36, "Output",
 CellTags->"S5.96.1",
 CellID->14986704]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12193, 439, 225, 7, 70, "ExampleSubsection",
 CellID->15203],
Cell[12421, 448, 142, 4, 70, "Input",
 CellID->428921907],
Cell[12566, 454, 77, 1, 70, "ExampleText",
 CellID->384802285],
Cell[CellGroupData[{
Cell[12668, 459, 264, 8, 70, "Input",
 CellID->357402744],
Cell[12935, 469, 220, 6, 36, "Output",
 CellID->125576655]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13228, 483, 309, 9, 70, "SeeAlsoSection",
 CellID->182],
Cell[13540, 494, 1054, 35, 70, "SeeAlso",
 CellID->1916]
}, Open  ]],
Cell[CellGroupData[{
Cell[14631, 534, 313, 9, 70, "TutorialsSection",
 CellID->5209],
Cell[14947, 545, 175, 4, 70, "Tutorials",
 CellID->24534]
}, Open  ]],
Cell[15137, 552, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

