(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36881,       1182]
NotebookOptionsPosition[     31924,       1015]
NotebookOutlinePosition[     33457,       1056]
CellTagsIndexPosition[     33371,       1051]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["LINEAR REGRESSION PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Regression Package" :> 
          Documentation`HelpLookup[
           "paclet:LinearRegression/tutorial/LinearRegression"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Linear Regression Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regress" :> 
          Documentation`HelpLookup["paclet:LinearRegression/ref/Regress"], 
          "DesignMatrix" :> 
          Documentation`HelpLookup[
           "paclet:LinearRegression/ref/DesignMatrix"], "Fit" :> 
          Documentation`HelpLookup["paclet:ref/Fit"], "LeastSquares" :> 
          Documentation`HelpLookup["paclet:ref/LeastSquares"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Regress\"\>", 
       2->"\<\"DesignMatrix\"\>", 3->"\<\"Fit\"\>", 
       4->"\<\"LeastSquares\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DesignedRegress", "ObjectName",
 CellID->31115],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DesignedRegress", "[", 
       RowBox[{
        StyleBox["matrix", "TI"], ",", 
        StyleBox["vector", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]finds a least\[Dash]squares fit given the design \
matrix ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     " and response vector ",
     Cell[BoxData[
      StyleBox["vector", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DesignedRegress", "[", 
       RowBox[{
        StyleBox["svd", "TI"], ",", 
        StyleBox["vector", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]finds a fit given the singular value decomposition ",
     Cell[BoxData[
      StyleBox["svd", "TI"]], "InlineFormula"],
     " of a design matrix."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->4639]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A design matrix is a list containing the basis functions evaluated at the \
observed values of the independent variables, as returned by ",
 Cell[BoxData[
  ButtonBox["DesignMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignMatrix"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->29658],

Cell[TextData[{
 Cell[BoxData["DesignedRegress"], "InlineFormula"],
 " returns a list of rules for results and diagnostics specified by the \
option ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->22704],

Cell[TextData[{
 "The argument ",
 Cell[BoxData[
  StyleBox["svd", "TI"]], "InlineFormula"],
 " is of the same form as returned that returned by ",
 Cell[BoxData[
  ButtonBox["SingularValueDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueDecomposition"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9930],

Cell[TextData[{
 "Exact numbers given as input to ",
 Cell[BoxData["DesignedRegress"], "InlineFormula"],
 " are converted to approximate numbers with machine precision. "
}], "Notes",
 CellID->4664],

Cell["The following options can be given:", "Notes",
 CellID->2306],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RegressionReport",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/RegressionReport"], 
    ButtonBox["SummaryReport",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/SummaryReport"], Cell[
    "results to be included in output", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BasisNames",
     BaseStyle->"Link",
     ButtonData->"paclet:LinearRegression/ref/BasisNames"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "names of basis elements for table headings", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Weights",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/Weights"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "weights for each data point", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method used to compute singular values", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "tolerance to use in computing singular values", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], "0.95", 
    Cell["confidence level used for confidence intervals", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->31673]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52381763],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->142092036],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->103400274],

Cell["\<\
Linear regression with one constant and one non\[Hyphen]constant basis \
function:\
\>", "ExampleText",
 CellID->661075337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignedRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49776190],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {"1", "0.833333333333333`", "0.3726779962499648`", 
         "2.2360679774997902`", "0.2677204728012301`"},
        {"2", "1.5`", "0.28867513459481275`", "5.196152422706634`", 
         "0.12103771832367682`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {
        Automatic, {"Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9642857142857142`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9285714285714284`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.16666666666666666`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "4.499999999999999`", "4.499999999999999`", 
        "26.999999999999993`", "0.12103771832367671`"},
       {"\<\"Error\"\>", "1", "0.16666666666666666`", 
        "0.16666666666666666`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "2", 
        "4.666666666666666`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{1, 4.5, 4.5, 27., 0.121037718323677}, {
       1, 0.166666666666667, 0.166666666666667}, {2, 4.66666666666667}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{544, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1315719]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13290],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RegressionReport",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1757724783],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->376220221],

Cell["Linear regression with a specific list of report values:", "ExampleText",
 CellID->54682976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignedRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"BestFitParameters", ",", "ParameterCITable"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34489903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFitParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.833333333333333`", ",", "1.5`"}], "}"}]}], ",", 
   RowBox[{"ParameterCITable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"CI\"\>",
          HoldForm]},
        {"1", "0.833333333333333`", "0.3726779962499648`", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.9019895876860646`"}], ",", "5.568656254352731`"}], 
          "}"}]},
        {"2", "1.5`", "0.28867513459481275`", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.1679653624044772`"}], ",", "5.167965362404477`"}], 
          "}"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {Automatic, {"Estimate", "SE", "CI"}}]]]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{424, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48298018]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BasisNames",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1295379749],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->119774922],

Cell["Linear regression with basis functions labeled b1 and b2:", \
"ExampleText",
 CellID->520383149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignedRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"BasisNames", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<b1\>\"", ",", "\"\<b2\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->402775949],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["\<\"b1\"\>",
          HoldForm], "0.833333333333333`", "0.3726779962499648`", 
         "2.2360679774997902`", "0.2677204728012301`"},
        {
         TagBox["\<\"b2\"\>",
          HoldForm], "1.5`", "0.28867513459481275`", "5.196152422706634`", 
         "0.12103771832367682`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {{"b1", "b2"}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9642857142857142`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9285714285714284`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.16666666666666666`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "4.499999999999999`", "4.499999999999999`", 
        "26.999999999999993`", "0.12103771832367671`"},
       {"\<\"Error\"\>", "1", "0.16666666666666666`", 
        "0.16666666666666666`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "2", 
        "4.666666666666666`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{1, 4.5, 4.5, 27., 0.121037718323677}, {
       1, 0.166666666666667, 0.166666666666667}, {2, 4.66666666666667}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{544, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151379254]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Weights",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->933705163],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->18073352],

Cell["\<\
Weighted regression with explicit weights for each data element:\
\>", "ExampleText",
 CellID->71839609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignedRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"Weights", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175853837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {"1", "0.8965517241379299`", "0.30454347814923616`", 
         "2.943920288775945`", "0.2084639622339668`"},
        {"2", "1.5172413793103456`", "0.20689655172413804`", 
         "7.333333333333333`", "0.0862796224269482`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {
        Automatic, {"Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9817444219066936`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9634888438133873`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.2068965517241382`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "11.126436781609193`", "11.126436781609193`", 
        "53.77777777777769`", "0.0862796224269482`"},
       {"\<\"Error\"\>", "1", "0.2068965517241382`", 
        "0.2068965517241382`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "2", 
        "11.333333333333332`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 11.1264367816092, 11.1264367816092, 53.7777777777777, 
        0.0862796224269482}, {1, 0.206896551724138, 0.206896551724138}, {
       2, 11.3333333333333}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{544, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36336327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->571455108],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->436518804],

Cell["\<\
Weighted regression with weights equal to the squares of the measured \
responses:\
\>", "ExampleText",
 CellID->143211852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignedRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"Weights", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"#", "^", "2"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->84694858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {"1", "0.5151515151515145`", "0.4997703788627464`", 
         "1.0307764064044145`", "0.4903527690225675`"},
        {"2", "1.727272727272728`", "0.27773186030035385`", 
         "6.219209871725787`", "0.10149471397410337`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {
        Automatic, {"Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9747974797479748`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9495949594959496`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.4848484848484842`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "18.753246753246756`", "18.753246753246756`", 
        "38.67857142857149`", "0.10149471397410337`"},
       {"\<\"Error\"\>", "1", "0.4848484848484842`", 
        "0.4848484848484842`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "2", 
        "19.23809523809524`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 18.7532467532468, 18.7532467532468, 38.6785714285715, 
        0.101494713974103}, {1, 0.484848484848484, 0.484848484848484}, {
       2, 19.2380952380952}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{544, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->584621719]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ConfidenceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->532914913],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->12652866],

Cell[TextData[{
 "Linear regression with ",
 Cell[BoxData[".99"], "InlineFormula"],
 " confidence level for confidence intervals:"
}], "ExampleText",
 CellID->177435415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignedRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"ConfidenceLevel", "\[Rule]", ".99"}], ",", 
   RowBox[{"RegressionReport", "\[Rule]", "ParameterCITable"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->585975940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ParameterCITable", "\[Rule]", 
   TagBox[
    TagBox[GridBox[{
       {
        StyleBox["\[Null]",
         ShowStringCharacters->False], 
        TagBox["\<\"Estimate\"\>",
         HoldForm], 
        TagBox["\<\"SE\"\>",
         HoldForm], 
        TagBox["\<\"CI\"\>",
         HoldForm]},
       {"1", "0.833333333333333`", "0.3726779962499648`", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "22.890133411048275`"}], ",", "24.55680007771494`"}], 
         "}"}]},
       {"2", "1.5`", "0.28867513459481275`", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "16.87611832305909`"}], ",", "19.87611832305909`"}], 
         "}"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxDividers->{
       "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
        "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
    Function[BoxForm`e$, 
     MatrixForm[
     BoxForm`e$, TableDepth -> 2, 
      TableHeadings -> {Automatic, {"Estimate", "SE", "CI"}}]]]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{424, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204415749]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19072],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Regress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/Regress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DesignMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/DesignMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeastSquares",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeastSquares"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22386],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/tutorial/LinearRegression"]], "Tutorials",
 CellID->5021]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DesignedRegress - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 20.3841090}", "context" -> 
    "LinearRegression`", 
    "keywords" -> {
     "linear regression", "linear models", "least squares", "linear fitting", 
      "regression analysis"}, "index" -> True, "label" -> 
    "Linear Regression Package Symbol", "language" -> "en", "paclet" -> 
    "LinearRegression Package", "status" -> "None", "summary" -> 
    "DesignedRegress[matrix, vector] finds a least\\[Dash]squares fit given \
the design matrix matrix and response vector vector. DesignedRegress[svd, \
vector] finds a fit given the singular value decomposition svd of a design \
matrix.", "synonyms" -> {}, "title" -> "DesignedRegress", "type" -> "Symbol", 
    "uri" -> "LinearRegression/ref/DesignedRegress"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7219, 228, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->52381763]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33229, 1044}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1568, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2191, 66, 53, 1, 70, "ObjectName",
 CellID->31115],
Cell[2247, 69, 1047, 32, 70, "Usage",
 CellID->4639]
}, Open  ]],
Cell[CellGroupData[{
Cell[3331, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3809, 123, 338, 10, 70, "Notes",
 CellID->29658],
Cell[4150, 135, 340, 11, 70, "Notes",
 CellID->22704],
Cell[4493, 148, 335, 11, 70, "Notes",
 CellID->9930],
Cell[4831, 161, 198, 5, 70, "Notes",
 CellID->4664],
Cell[5032, 168, 67, 1, 70, "Notes",
 CellID->2306],
Cell[5102, 171, 2080, 52, 70, "3ColumnTableMod",
 CellID->31673]
}, Closed]],
Cell[CellGroupData[{
Cell[7219, 228, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52381763],
Cell[CellGroupData[{
Cell[7603, 242, 148, 5, 70, "ExampleSection",
 CellID->142092036],
Cell[7754, 249, 141, 4, 70, "Input",
 CellID->103400274],
Cell[7898, 255, 133, 4, 70, "ExampleText",
 CellID->661075337],
Cell[CellGroupData[{
Cell[8056, 263, 410, 14, 28, "Input",
 CellID->49776190],
Cell[8469, 279, 3015, 76, 140, "Output",
 CellID->1315719]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11533, 361, 218, 7, 70, "ExampleSection",
 CellID->13290],
Cell[CellGroupData[{
Cell[11776, 372, 238, 7, 70, "ExampleSubsection",
 CellID->1757724783],
Cell[12017, 381, 141, 4, 70, "Input",
 CellID->376220221],
Cell[12161, 387, 98, 1, 70, "ExampleText",
 CellID->54682976],
Cell[CellGroupData[{
Cell[12284, 392, 550, 18, 70, "Input",
 CellID->34489903],
Cell[12837, 412, 1867, 54, 87, "Output",
 CellID->48298018]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14753, 472, 232, 7, 70, "ExampleSubsection",
 CellID->1295379749],
Cell[14988, 481, 141, 4, 70, "Input",
 CellID->119774922],
Cell[15132, 487, 102, 2, 70, "ExampleText",
 CellID->520383149],
Cell[CellGroupData[{
Cell[15259, 493, 529, 17, 70, "Input",
 CellID->402775949],
Cell[15791, 512, 3115, 80, 140, "Output",
 CellID->151379254]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18955, 598, 228, 7, 70, "ExampleSubsection",
 CellID->933705163],
Cell[19186, 607, 140, 4, 70, "Input",
 CellID->18073352],
Cell[19329, 613, 114, 3, 70, "ExampleText",
 CellID->71839609],
Cell[CellGroupData[{
Cell[19468, 620, 518, 17, 70, "Input",
 CellID->175853837],
Cell[19989, 639, 3086, 78, 140, "Output",
 CellID->36336327]
}, Open  ]],
Cell[23090, 720, 125, 3, 70, "ExampleDelimiter",
 CellID->571455108],
Cell[23218, 725, 141, 4, 70, "Input",
 CellID->436518804],
Cell[23362, 731, 133, 4, 70, "ExampleText",
 CellID->143211852],
Cell[CellGroupData[{
Cell[23520, 739, 529, 18, 70, "Input",
 CellID->84694858],
Cell[24052, 759, 3086, 78, 140, "Output",
 CellID->584621719]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27187, 843, 236, 7, 70, "ExampleSubsection",
 CellID->532914913],
Cell[27426, 852, 140, 4, 70, "Input",
 CellID->12652866],
Cell[27569, 858, 169, 5, 70, "ExampleText",
 CellID->177435415],
Cell[CellGroupData[{
Cell[27763, 867, 540, 17, 70, "Input",
 CellID->585975940],
Cell[28306, 886, 1686, 50, 64, "Output",
 CellID->204415749]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30065, 944, 311, 9, 70, "SeeAlsoSection",
 CellID->19072],
Cell[30379, 955, 978, 35, 70, "SeeAlso",
 CellID->6270]
}, Open  ]],
Cell[CellGroupData[{
Cell[31394, 995, 314, 9, 70, "TutorialsSection",
 CellID->22386],
Cell[31711, 1006, 171, 4, 70, "Tutorials",
 CellID->5021]
}, Open  ]],
Cell[31897, 1013, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

