(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49884,       1594]
NotebookOptionsPosition[     43908,       1388]
NotebookOutlinePosition[     45333,       1428]
CellTagsIndexPosition[     45247,       1423]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["LINEAR REGRESSION PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Regression Package" :> 
          Documentation`HelpLookup[
           "paclet:LinearRegression/tutorial/LinearRegression"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Linear Regression Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fit" :> Documentation`HelpLookup["paclet:ref/Fit"], 
          "LeastSquares" :> 
          Documentation`HelpLookup["paclet:ref/LeastSquares"], 
          "DesignedRegress" :> 
          Documentation`HelpLookup[
           "paclet:LinearRegression/ref/DesignedRegress"], "DesignMatrix" :> 
          Documentation`HelpLookup[
           "paclet:LinearRegression/ref/DesignMatrix"], "FindFit" :> 
          Documentation`HelpLookup["paclet:ref/FindFit"], "NonlinearRegress" :> 
          Documentation`HelpLookup[
           "paclet:NonlinearRegression/ref/NonlinearRegress"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Fit\"\>", 2->"\<\"LeastSquares\"\>",
        3->"\<\"DesignedRegress\"\>", 4->"\<\"DesignMatrix\"\>", 
       5->"\<\"FindFit\"\>", 
       6->"\<\"NonlinearRegress\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Regress", "ObjectName",
 CellID->28703],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Regress", "[", 
       RowBox[{
        StyleBox["data", "TI"], ",", 
        StyleBox["funs", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a least\[Dash]squares fit to a list of ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " as a linear combination of the functions ",
     Cell[BoxData[
      StyleBox["funs", "TI"]], "InlineFormula"],
     " of variables ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23811]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " can have the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["1", "TR"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["2", "TR"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], ",", "\[Ellipsis]"}], "}"}]], 
  "InlineFormula"],
 ", where the number of coordinates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ",", 
   StyleBox["y", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
 " is equal to the number of variables in the list ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21962],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " can also be of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "}"}]], "InlineFormula"],
 ", with a single coordinate assumed to take values ",
 Cell[BoxData[
  RowBox[{
   StyleBox["1", "TR"], ",", 
   StyleBox["2", "TR"], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->419364775],

Cell[TextData[{
 "The argument ",
 Cell[BoxData[
  StyleBox["funs", "TI"]], "InlineFormula"],
 " can be any list of functions that depend only on the variables ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31322],

Cell[TextData[{
 Cell[BoxData["Regress"], "InlineFormula"],
 " returns a list of rules for results and diagnostics specified by the \
option ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->22704],

Cell[TextData[{
 Cell[BoxData["Regress"], "InlineFormula"],
 " always finds the linear combination of the functions in the list ",
 Cell[BoxData[
  StyleBox["funs", "TI"]], "InlineFormula"],
 " that minimize the sum of the squares of deviations from the values ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17673],

Cell[TextData[{
 "Exact numbers given as input to ",
 Cell[BoxData["Regress"], "InlineFormula"],
 " are converted to approximate numbers with machine precision. "
}], "Notes",
 CellID->4664],

Cell["The following options can be given:", "Notes",
 CellID->15141],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RegressionReport",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/RegressionReport"], 
    ButtonBox["SummaryReport",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/SummaryReport"], Cell[
    "results to be included in output", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IncludeConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:LinearRegression/ref/IncludeConstant"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[Cell[BoxData[Cell["\<\
whether to automatically include a constant as one of the functions\
\>", "TableText"]]]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BasisNames",
     BaseStyle->"Link",
     ButtonData->"paclet:LinearRegression/ref/BasisNames"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "names of basis elements for table headings", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Weights",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/Weights"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "weights for each data point", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method used to compute singular values", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "tolerance to use in computing singular values", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], "0.95", 
    Cell["confidence level used for confidence intervals", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->263386023],

Cell[TextData[{
 "With the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IncludeConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/IncludeConstant"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData["Regress"], "InlineFormula"],
 " gives the same fit as ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 " does."
}], "Notes",
 CellID->28253],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Weights",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Weights"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", a list of numbers with the same length as the data, or a pure function."
}], "Notes",
 CellID->467],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weights",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Weights"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", each data point is given a weight of 1."
}], "Notes",
 CellID->3728]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->74282040],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->304595594],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->7373490],

Cell["Linear regression for a straight line:", "ExampleText",
 CellID->661075337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "6"}], "}"}], ",", "x", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->546482201],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["1",
          HoldForm], "0.4999999999999996`", "0.47434164902525666`", 
         "1.0540925533894594`", "0.40238569533280333`"},
        {
         TagBox["x",
          HoldForm], "1.3`", "0.17320508075688762`", "7.50555349946514`", 
         "0.017292370176009264`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {{1, $CellContext`x}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9657142857142859`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9485714285714288`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.14999999999999977`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "8.450000000000001`", "8.450000000000001`", 
        "56.33333333333343`", "0.017292370176009153`"},
       {"\<\"Error\"\>", "2", "0.29999999999999954`", 
        "0.14999999999999977`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "3", "8.75`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{1, 8.45, 8.45, 56.3333333333334, 0.0172923701760092}, {
       2, 0.3, 0.15}, {3, 8.75}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{516, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->330388406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->214862668],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->18629950],

Cell["Linear regression for a constant plus a sinusoid:", "ExampleText",
 CellID->3129238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Sin", "[", "x", "]"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43335],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["1",
          HoldForm], "1.0627115088055281`", "0.5639654747241798`", 
         "1.8843556147214002`", "0.20019294719615388`"},
        {
         TagBox[
          RowBox[{"Sin", "[", "x", "]"}],
          HoldForm], "2.421978729289724`", "0.7732885768285881`", 
         "3.13205031325142`", "0.08860093836888838`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$, TableHeadings -> {{1, 
          Sin[$CellContext`x]}, {"Estimate", "SE", "TStat", "PValue"}}]]]}], 
   ",", 
   RowBox[{"RSquared", "\[Rule]", "0.8306482495420706`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.7459723743131059`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "1.0796174091693`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "10.5907651816614`", "10.5907651816614`", 
        "9.809739164738321`", "0.0886009383688885`"},
       {"\<\"Error\"\>", "2", "2.1592348183386`", 
        "1.0796174091693`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "3", "12.75`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 10.5907651816614, 10.5907651816614, 9.80973916473832, 
        0.0886009383688885}, {2, 2.1592348183386, 1.0796174091693}, {
       3, 12.75}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{537, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1838763]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3035],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BasisNames",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22190],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->434105995],

Cell["\<\
Linear regression for a straight line with basis functions labeled b1 and b2:\
\
\>", "ExampleText",
 CellID->520383149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "6"}], "}"}], ",", "x", ",", "x", 
   ",", 
   RowBox[{"BasisNames", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<b1\>\"", ",", "\"\<b2\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->402775949],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["\<\"b1\"\>",
          HoldForm], "0.4999999999999996`", "0.47434164902525666`", 
         "1.0540925533894594`", "0.40238569533280333`"},
        {
         TagBox["\<\"b2\"\>",
          HoldForm], "1.3`", "0.17320508075688762`", "7.50555349946514`", 
         "0.017292370176009264`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {{"b1", "b2"}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9657142857142859`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9485714285714288`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.14999999999999977`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "8.450000000000001`", "8.450000000000001`", 
        "56.33333333333343`", "0.017292370176009153`"},
       {"\<\"Error\"\>", "2", "0.29999999999999954`", 
        "0.14999999999999977`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "3", "8.75`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{1, 8.45, 8.45, 56.3333333333334, 0.0172923701760092}, {
       2, 0.3, 0.15}, {3, 8.75}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{516, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->427713036]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ConfidenceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1842],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->456138220],

Cell[TextData[{
 "Linear regression with ",
 Cell[BoxData[".99"], "InlineFormula"],
 " confidence level for confidence intervals:"
}], "ExampleText",
 CellID->177435415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "6"}], "}"}], ",", "x", ",", "x", 
   ",", 
   RowBox[{"ConfidenceLevel", "\[Rule]", ".99"}], ",", 
   RowBox[{"RegressionReport", "\[Rule]", "ParameterCITable"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->585975940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ParameterCITable", "\[Rule]", 
   TagBox[
    TagBox[GridBox[{
       {
        StyleBox["\[Null]",
         ShowStringCharacters->False], 
        TagBox["\<\"Estimate\"\>",
         HoldForm], 
        TagBox["\<\"SE\"\>",
         HoldForm], 
        TagBox["\<\"CI\"\>",
         HoldForm]},
       {
        TagBox["1",
         HoldForm], "0.4999999999999996`", "0.47434164902525666`", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4.207766490240687`"}], ",", "5.207766490240687`"}], 
         "}"}]},
       {
        TagBox["x",
         HoldForm], "1.3`", "0.17320508075688762`", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.4190332681144986`"}], ",", "3.019033268114499`"}], 
         "}"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxDividers->{
       "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
        "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
    Function[BoxForm`e$, 
     MatrixForm[
     BoxForm`e$, TableDepth -> 2, 
      TableHeadings -> {{1, $CellContext`x}, {"Estimate", "SE", "CI"}}]]]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{431, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->505436721]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IncludeConstant",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->288],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->71044121],

Cell[TextData[{
 "Linear regression with constant term assumed to be ",
 Cell[BoxData["0"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->709020466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "6"}], "}"}], ",", "x", ",", "x", 
   ",", 
   RowBox[{"IncludeConstant", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149422177],

Cell[BoxData[
 RowBox[{
  RowBox[{"DesignedRegress", "::", "\<\"tsos\"\>"}], ":", 
  " ", "\<\"Warning: the total sum of squares in the ANOVATable is \
uncorrected (not centered on the response mean) when there is no constant \
term in the model; it is designated U Total. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:LinearRegression/ref/DesignedRegress\\\", ButtonNote \
-> \\\"LinearRegression`.`DesignedRegress::tsos\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->1989235694],

Cell[BoxData[
 RowBox[{
  RowBox[{"DesignedRegress", "::", "\<\"rsqr\"\>"}], ":", 
  " ", "\<\"Warning: the RSquared and AdjustedRSquared diagnostics are \
redefined when there is no constant term in the model. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:LinearRegression/ref/DesignedRegress\\\", ButtonNote \
-> \\\"LinearRegression`.`DesignedRegress::rsqr\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->1058892562],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["x",
          HoldForm], "1.466666666666667`", "0.07200822998230957`", 
         "20.368042194996132`", "0.00025874204404496837`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {{$CellContext`x}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9928205128205129`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9904273504273505`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.1555555555555556`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "64.53333333333333`", "64.53333333333333`", 
        "414.85714285714266`", "0.0002587420440450794`"},
       {"\<\"Error\"\>", "3", "0.46666666666666684`", 
        "0.1555555555555556`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"U Total\"\>", "4", "65.`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[2.0999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 64.53333333333333, 64.53333333333333, 414.85714285714266`, 
        0.0002587420440450794}, {
       3, 0.46666666666666684`, 0.1555555555555556}, {4, 65.}}, 
      TableHeadings -> {{"Model", "Error", "U Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{544, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->610306845]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RegressionReport",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9040],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->169529955],

Cell["Linear regression with a specific list of report values:", "ExampleText",
 CellID->54682976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "6"}], "}"}], ",", "x", ",", "x", 
   ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"BestFit", ",", "ParameterCITable"}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->34489903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFit", "\[Rule]", 
    RowBox[{"0.4999999999999996`", "\[InvisibleSpace]", "+", 
     RowBox[{"1.3`", " ", "x"}]}]}], ",", 
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["1",
          HoldForm], "0.4999999999999996`", "0.47434164902525666`", 
         "1.0540925533894594`", "0.40238569533280333`"},
        {
         TagBox["x",
          HoldForm], "1.3`", "0.17320508075688762`", "7.50555349946514`", 
         "0.017292370176009264`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {{1, $CellContext`x}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{540, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->770858562]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Weights",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19264],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->275024574],

Cell["\<\
Weighted regression with explicit weights for each data element:\
\>", "ExampleText",
 CellID->71839609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "6"}], "}"}], ",", "x", ",", "x", 
   ",", 
   RowBox[{"Weights", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175853837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["1",
          HoldForm], "0.4108527131782946`", "0.5814470261271067`", 
         "0.7066038602259194`", "0.5530409189095022`"},
        {
         TagBox["x",
          HoldForm], "1.3410852713178292`", "0.18669138881848532`", 
         "7.183434007348501`", "0.018833466032636803`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {{1, $CellContext`x}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.962687767377529`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9440316510662936`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.44961240310077616`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "23.20077519379845`", "23.20077519379845`", 
        "51.601724137930916`", "0.018833466032636803`"},
       {"\<\"Error\"\>", "2", "0.8992248062015523`", 
        "0.44961240310077616`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "3", "24.1`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 23.2007751937984, 23.2007751937984, 51.6017241379309, 
        0.0188334660326368}, {2, 0.899224806201552, 0.449612403100776}, {
       3, 24.1}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{544, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->526556988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->571455108],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->342761951],

Cell["\<\
Weighted regression with weights equal to the squares of the measured \
responses:\
\>", "ExampleText",
 CellID->143211852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "6"}], "}"}], ",", "x", ",", "x", 
   ",", 
   RowBox[{"Weights", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"#", "^", "2"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->84694858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["1",
          HoldForm], "0.04106548279689067`", "0.6776438652993675`", 
         "0.06060039041119171`", "0.9571883404340027`"},
        {
         TagBox["x",
          HoldForm], "1.4594894561598233`", "0.19817615280736509`", 
         "7.364606868609988`", "0.017942720649805066`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {{1, $CellContext`x}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9644364999247067`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9466547498870601`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "2.177580466148725`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "118.106377529241`", "118.106377529241`", 
        "54.23743432917742`", "0.017942720649805066`"},
       {"\<\"Error\"\>", "2", "4.35516093229745`", 
        "2.177580466148725`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "3", 
        "122.46153846153845`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 118.106377529241, 118.106377529241, 54.2374343291774, 
        0.0179427206498051}, {2, 4.35516093229745, 2.17758046614872}, {
       3, 122.461538461538}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{537, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97122718]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32757],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeastSquares",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeastSquares"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DesignedRegress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/DesignedRegress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DesignMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/DesignMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindFit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonlinearRegress",
    BaseStyle->"Link",
    ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6868],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/tutorial/LinearRegression"]], "Tutorials",
 CellID->25547]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Regress - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 26.6655198}", "context" -> 
    "LinearRegression`", 
    "keywords" -> {
     "linear regression", "linear models", "least squares", "linear fitting", 
      "regression analysis"}, "index" -> True, "label" -> 
    "Linear Regression Package Symbol", "language" -> "en", "paclet" -> 
    "LinearRegression Package", "status" -> "None", "summary" -> 
    "Regress[data, funs, vars] finds a least\\[Dash]squares fit to a list of \
data as a linear combination of the functions funs of variables vars.", 
    "synonyms" -> {}, "title" -> "Regress", "type" -> "Symbol", "uri" -> 
    "LinearRegression/ref/Regress"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10642, 353, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->74282040]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45104, 1416}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1859, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2482, 71, 45, 1, 70, "ObjectName",
 CellID->28703],
Cell[2530, 74, 783, 24, 70, "Usage",
 CellID->23811]
}, Open  ]],
Cell[CellGroupData[{
Cell[3350, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3828, 120, 1131, 41, 70, "Notes",
 CellID->21962],
Cell[4962, 163, 589, 22, 70, "Notes",
 CellID->419364775],
Cell[5554, 187, 256, 9, 70, "Notes",
 CellID->31322],
Cell[5813, 198, 332, 11, 70, "Notes",
 CellID->22704],
Cell[6148, 211, 398, 12, 70, "Notes",
 CellID->17673],
Cell[6549, 225, 190, 5, 70, "Notes",
 CellID->4664],
Cell[6742, 232, 68, 1, 70, "Notes",
 CellID->15141],
Cell[6813, 235, 2489, 63, 70, "3ColumnTableMod",
 CellID->263386023],
Cell[9305, 300, 518, 19, 70, "Notes",
 CellID->28253],
Cell[9826, 321, 411, 13, 70, "Notes",
 CellID->467],
Cell[10240, 336, 365, 12, 70, "Notes",
 CellID->3728]
}, Closed]],
Cell[CellGroupData[{
Cell[10642, 353, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->74282040],
Cell[CellGroupData[{
Cell[11026, 367, 148, 5, 70, "ExampleSection",
 CellID->304595594],
Cell[11177, 374, 139, 4, 70, "Input",
 CellID->7373490],
Cell[11319, 380, 81, 1, 70, "ExampleText",
 CellID->661075337],
Cell[CellGroupData[{
Cell[11425, 385, 208, 7, 28, "Input",
 CellID->546482201],
Cell[11636, 394, 3062, 79, 140, "Output",
 CellID->330388406]
}, Open  ]],
Cell[14713, 476, 125, 3, 70, "ExampleDelimiter",
 CellID->214862668],
Cell[14841, 481, 140, 4, 70, "Input",
 CellID->18629950],
Cell[14984, 487, 90, 1, 70, "ExampleText",
 CellID->3129238],
Cell[CellGroupData[{
Cell[15099, 492, 492, 17, 70, "Input",
 CellID->43335],
Cell[15594, 511, 3154, 81, 140, "Output",
 CellID->1838763]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18797, 598, 217, 7, 70, "ExampleSection",
 CellID->3035],
Cell[CellGroupData[{
Cell[19039, 609, 227, 7, 70, "ExampleSubsection",
 CellID->22190],
Cell[19269, 618, 141, 4, 70, "Input",
 CellID->434105995],
Cell[19413, 624, 130, 4, 70, "ExampleText",
 CellID->520383149],
Cell[CellGroupData[{
Cell[19568, 632, 327, 10, 70, "Input",
 CellID->402775949],
Cell[19898, 644, 3073, 79, 140, "Output",
 CellID->427713036]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23020, 729, 231, 7, 70, "ExampleSubsection",
 CellID->1842],
Cell[23254, 738, 141, 4, 70, "Input",
 CellID->456138220],
Cell[23398, 744, 169, 5, 70, "ExampleText",
 CellID->177435415],
Cell[CellGroupData[{
Cell[23592, 753, 338, 10, 70, "Input",
 CellID->585975940],
Cell[23933, 765, 1770, 54, 64, "Output",
 CellID->505436721]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25752, 825, 230, 7, 70, "ExampleSubsection",
 CellID->288],
Cell[25985, 834, 140, 4, 70, "Input",
 CellID->71044121],
Cell[26128, 840, 153, 5, 70, "ExampleText",
 CellID->709020466],
Cell[CellGroupData[{
Cell[26306, 849, 267, 8, 70, "Input",
 CellID->149422177],
Cell[26576, 859, 551, 10, 70, "Message",
 CellID->1989235694],
Cell[27130, 871, 491, 10, 70, "Message",
 CellID->1058892562],
Cell[27624, 883, 3082, 77, 125, "Output",
 CellID->610306845]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30755, 966, 232, 7, 70, "ExampleSubsection",
 CellID->9040],
Cell[30990, 975, 141, 4, 70, "Input",
 CellID->169529955],
Cell[31134, 981, 98, 1, 70, "ExampleText",
 CellID->54682976],
Cell[CellGroupData[{
Cell[31257, 986, 337, 11, 70, "Input",
 CellID->34489903],
Cell[31597, 999, 1863, 54, 64, "Output",
 CellID->770858562]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33509, 1059, 224, 7, 70, "ExampleSubsection",
 CellID->19264],
Cell[33736, 1068, 141, 4, 70, "Input",
 CellID->275024574],
Cell[33880, 1074, 114, 3, 70, "ExampleText",
 CellID->71839609],
Cell[CellGroupData[{
Cell[34019, 1081, 326, 10, 70, "Input",
 CellID->175853837],
Cell[34348, 1093, 3143, 81, 140, "Output",
 CellID->526556988]
}, Open  ]],
Cell[37506, 1177, 125, 3, 70, "ExampleDelimiter",
 CellID->571455108],
Cell[37634, 1182, 141, 4, 70, "Input",
 CellID->342761951],
Cell[37778, 1188, 133, 4, 70, "ExampleText",
 CellID->143211852],
Cell[CellGroupData[{
Cell[37936, 1196, 327, 11, 70, "Input",
 CellID->84694858],
Cell[38266, 1209, 3169, 82, 140, "Output",
 CellID->97122718]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41508, 1299, 311, 9, 70, "SeeAlsoSection",
 CellID->32757],
Cell[41822, 1310, 1519, 53, 70, "SeeAlso",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[43378, 1368, 313, 9, 70, "TutorialsSection",
 CellID->6868],
Cell[43694, 1379, 172, 4, 70, "Tutorials",
 CellID->25547]
}, Open  ]],
Cell[43881, 1386, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

