(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24090,        729]
NotebookOptionsPosition[     20571,        612]
NotebookOutlinePosition[     22042,        652]
CellTagsIndexPosition[     21957,        647]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quantile" :> Documentation`HelpLookup["paclet:ref/Quantile"], 
          "EllipsoidQuartiles" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/EllipsoidQuartiles"], 
          "Ellipsoid" :> 
          Documentation`HelpLookup["paclet:RegressionCommon/ref/Ellipsoid"], 
          "EllipsoidProbability" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/EllipsoidProbability"], 
          "PolytopeQuantile" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/PolytopeQuantile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Quantile\"\>", 
       2->"\<\"EllipsoidQuartiles\"\>", 3->"\<\"Ellipsoid\"\>", 
       4->"\<\"EllipsoidProbability\"\>", 
       5->"\<\"PolytopeQuantile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipsoidQuantile", "ObjectName",
 CellID->6624],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EllipsoidQuantile", "[", 
       RowBox[{
        StyleBox["matrix", "TI"], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ellipsoidal locus of the ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " quantile of ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EllipsoidQuantile", "[", 
       RowBox[{
        StyleBox["matrix", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["q", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["q", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ellipsoidal loci for multiple quantiles ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["q", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["q", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14989]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"EllipsoidQuantile", "[", 
   RowBox[{
    StyleBox["matrix", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " returns an ",
 Cell[BoxData[
  ButtonBox["Ellipsoid",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"]], "InlineFormula"],
 " object centered at ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"], "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->88262168],

Cell[TextData[{
 "The semi-axes radii are scaled to contain the fraction ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " of the sample space."
}], "Notes",
 CellID->712218644],

Cell[TextData[{
 "The value ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " can be any number between 0 and 1."
}], "Notes",
 CellID->80393511]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37947863],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->237973695],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1834053],

Cell["Ellipsoidal quantile for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipsoidQuantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "10"}], "}"}]}], "}"}], ",", ".9"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13949849],

Cell[BoxData[
 RowBox[{"Ellipsoid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["31", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.392863859964292`", ",", "0.26355504227817667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7599887254951234`", ",", "0.6499362561977118`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6499362561977119`"}], ",", "0.7599887254951236`"}], 
      "}"}]}], "}"}]}], "]"}]], "Output",
 ImageSize->{326, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->257655222]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->947],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->234166736],

Cell["Multiple ellipsoidal quantiles for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->37352860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipsoidQuantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "10"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{".5", ",", ".9"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->269969985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Ellipsoid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["24", "5"], ",", 
       FractionBox["31", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.592196955407274`", ",", "0.18931994943794686`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.7599887254951235`", ",", "0.6499362561977119`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.6499362561977119`"}], ",", "0.7599887254951235`"}], 
        "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Ellipsoid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["24", "5"], ",", 
       FractionBox["31", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.392863859964292`", ",", "0.26355504227817667`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.7599887254951234`", ",", "0.6499362561977118`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.6499362561977119`"}], ",", "0.7599887254951236`"}], 
        "}"}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{482, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->357170753]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28223],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->104520417],

Cell["Visualize ellipsoidal quantiles for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->404344751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"EllipsoidQuantile", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "10"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{".25", ",", ".5", ",", ".75", ",", ".9", ",", ".95"}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245404757],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34174077]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31516],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipsoidQuartiles",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuartiles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ellipsoid",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipsoidProbability",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidProbability"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolytopeQuantile",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuantile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28786]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12250],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->16085]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipsoidQuantile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 27.9936788}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {"multivariate quantile", "quantile"}, "index" -> True, 
    "label" -> "Multivariate Statistics Package Symbol", "language" -> "en", 
    "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "EllipsoidQuantile[matrix, q] gives the ellipsoidal locus of the \
q\\[Null]^th quantile of matrix. EllipsoidQuantile[matrix, {q_1, q_2, ...}] \
gives ellipsoidal loci for multiple quantiles q_1, q_2, ....", 
    "synonyms" -> {}, "title" -> "EllipsoidQuantile", "type" -> "Symbol", 
    "uri" -> "MultivariateStatistics/ref/EllipsoidQuantile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5538, 187, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->37947863]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21815, 640}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1881, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2504, 72, 54, 1, 70, "ObjectName",
 CellID->6624],
Cell[2561, 75, 1519, 49, 70, "Usage",
 CellID->14989]
}, Open  ]],
Cell[CellGroupData[{
Cell[4117, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4595, 146, 552, 20, 70, "Notes",
 CellID->88262168],
Cell[5150, 168, 190, 6, 70, "Notes",
 CellID->712218644],
Cell[5343, 176, 158, 6, 70, "Notes",
 CellID->80393511]
}, Closed]],
Cell[CellGroupData[{
Cell[5538, 187, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37947863],
Cell[CellGroupData[{
Cell[5922, 201, 148, 5, 70, "ExampleSection",
 CellID->237973695],
Cell[6073, 208, 145, 4, 70, "Input",
 CellID->1834053],
Cell[6221, 214, 215, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[6461, 223, 481, 16, 28, "Input",
 CellID->13949849],
Cell[6945, 241, 674, 22, 73, "Output",
 CellID->257655222]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7668, 269, 214, 7, 70, "ExampleSection",
 CellID->947],
Cell[7885, 278, 147, 4, 70, "Input",
 CellID->234166736],
Cell[8035, 284, 229, 5, 70, "ExampleText",
 CellID->37352860],
Cell[CellGroupData[{
Cell[8289, 293, 532, 18, 70, "Input",
 CellID->269969985],
Cell[8824, 313, 1314, 43, 103, "Output",
 CellID->357170753]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10187, 362, 223, 7, 70, "ExampleSection",
 CellID->28223],
Cell[10413, 371, 147, 4, 70, "Input",
 CellID->104520417],
Cell[10563, 377, 231, 5, 70, "ExampleText",
 CellID->404344751],
Cell[CellGroupData[{
Cell[10819, 386, 624, 20, 70, "Input",
 CellID->245404757],
Cell[11446, 408, 6828, 116, 70, "Output",
 Evaluatable->False,
 CellID->34174077]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18335, 531, 311, 9, 70, "SeeAlsoSection",
 CellID->31516],
Cell[18649, 542, 1334, 44, 70, "SeeAlso",
 CellID->28786]
}, Open  ]],
Cell[CellGroupData[{
Cell[20020, 591, 314, 9, 70, "TutorialsSection",
 CellID->12250],
Cell[20337, 602, 192, 5, 70, "Tutorials",
 CellID->16085]
}, Open  ]],
Cell[20544, 610, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

