(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20222,        635]
NotebookOptionsPosition[     17141,        532]
NotebookOutlinePosition[     18490,        570]
CellTagsIndexPosition[     18405,        565]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quartiles" :> Documentation`HelpLookup["paclet:ref/Quartiles"],
           "EllipsoidQuantile" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/EllipsoidQuantile"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"], "Ellipsoid" :> 
          Documentation`HelpLookup["paclet:RegressionCommon/ref/Ellipsoid"], 
          "EllipsoidProbability" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/EllipsoidProbability"], 
          "PolytopeQuartiles" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/PolytopeQuartiles"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Quartiles\"\>", 
       2->"\<\"EllipsoidQuantile\"\>", 3->"\<\"Quantile\"\>", 
       4->"\<\"Ellipsoid\"\>", 5->"\<\"EllipsoidProbability\"\>", 
       6->"\<\"PolytopeQuartiles\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipsoidQuartiles", "ObjectName",
 CellID->28814],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EllipsoidQuartiles", "[", 
       StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ellipsoidal loci of the quartiles of ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20485]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"EllipsoidQuartiles", "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 " gives a list of the loci of the ",
 Cell[BoxData[".25"], "InlineFormula"],
 ", ",
 Cell[BoxData[".5"], "InlineFormula"],
 ", and ",
 Cell[BoxData[".75"], "InlineFormula"],
 " quantiles of ",
 Cell[BoxData[
  StyleBox["matrix", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->98131897],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"EllipsoidQuartiles", "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 " returns a list of ",
 Cell[BoxData[
  ButtonBox["Ellipsoid",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"]], "InlineFormula"],
 " objects centered at ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"], "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6361997],

Cell[TextData[{
 "The semi-axes radii are scaled to contain the fractions ",
 Cell[BoxData[".25"], "InlineFormula"],
 ", ",
 Cell[BoxData[".5"], "InlineFormula"],
 ", and ",
 Cell[BoxData[".75"], "InlineFormula"],
 " of the sample space."
}], "Notes",
 CellID->292607605],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"EllipsoidQuartiles", "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipsoidQuantile",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuantile"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{".25", ",", ".5", ",", ".75"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->30523]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->186020964],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->281378106],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->268832711],

Cell["Ellipsoidal quartiles for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipsoidQuartiles", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "10"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14939941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Ellipsoid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["24", "5"], ",", 
       FractionBox["31", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.443610700689779`", ",", "0.14196782282408316`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.7599887254951235`", ",", "0.6499362561977119`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.6499362561977119`"}], ",", "0.7599887254951236`"}], 
        "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Ellipsoid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["24", "5"], ",", 
       FractionBox["31", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.592196955407274`", ",", "0.18931994943794686`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.7599887254951235`", ",", "0.6499362561977119`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.6499362561977119`"}], ",", "0.7599887254951235`"}], 
        "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Ellipsoid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["24", "5"], ",", 
       FractionBox["31", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.722247658629282`", ",", "0.23590792118083798`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.7599887254951235`", ",", "0.6499362561977119`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.6499362561977118`"}], ",", "0.7599887254951235`"}], 
        "}"}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{554, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->543528131]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5413],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->340332908],

Cell["Visualize ellipsoidal quartiles for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->404344751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"EllipsoidQuartiles", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "10"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245404757],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->196725139]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20202],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quartiles",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartiles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipsoidQuantile",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ellipsoid",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipsoidProbability",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidProbability"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolytopeQuartiles",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuartiles"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7997],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->16411]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipsoidQuartiles - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 28.3999392}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {"multivariate quartile", "quartile"}, "index" -> True, 
    "label" -> "Multivariate Statistics Package Symbol", "language" -> "en", 
    "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "EllipsoidQuartiles[matrix] gives the ellipsoidal loci of the quartiles \
of matrix.", "synonyms" -> {}, "title" -> "EllipsoidQuartiles", "type" -> 
    "Symbol", "uri" -> "MultivariateStatistics/ref/EllipsoidQuartiles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5823, 198, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->186020964]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18262, 558}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1970, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2593, 72, 56, 1, 70, "ObjectName",
 CellID->28814],
Cell[2652, 75, 495, 15, 70, "Usage",
 CellID->20485]
}, Open  ]],
Cell[CellGroupData[{
Cell[3184, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3662, 112, 416, 15, 70, "Notes",
 CellID->98131897],
Cell[4081, 129, 514, 18, 70, "Notes",
 CellID->6361997],
Cell[4598, 149, 271, 9, 70, "Notes",
 CellID->292607605],
Cell[4872, 160, 914, 33, 70, "Notes",
 CellID->30523]
}, Closed]],
Cell[CellGroupData[{
Cell[5823, 198, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->186020964],
Cell[CellGroupData[{
Cell[6208, 212, 148, 5, 70, "ExampleSection",
 CellID->281378106],
Cell[6359, 219, 147, 4, 70, "Input",
 CellID->268832711],
Cell[6509, 225, 216, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[6750, 234, 446, 15, 28, "Input",
 CellID->14939941],
Cell[7199, 251, 1880, 61, 133, "Output",
 CellID->543528131]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9128, 318, 222, 7, 70, "ExampleSection",
 CellID->5413],
Cell[9353, 327, 147, 4, 70, "Input",
 CellID->340332908],
Cell[9503, 333, 231, 5, 70, "ExampleText",
 CellID->404344751],
Cell[CellGroupData[{
Cell[9759, 342, 496, 16, 70, "Input",
 CellID->245404757],
Cell[10258, 360, 4340, 75, 70, "Output",
 Evaluatable->False,
 CellID->196725139]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14659, 442, 311, 9, 70, "SeeAlsoSection",
 CellID->20202],
Cell[14973, 453, 1581, 53, 70, "SeeAlso",
 CellID->26128]
}, Open  ]],
Cell[CellGroupData[{
Cell[16591, 511, 313, 9, 70, "TutorialsSection",
 CellID->7997],
Cell[16907, 522, 192, 5, 70, "Tutorials",
 CellID->16411]
}, Open  ]],
Cell[17114, 530, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

