(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13480,        500]
NotebookOptionsPosition[     10712,        411]
NotebookOutlinePosition[     12145,        450]
CellTagsIndexPosition[     12060,        445]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Correlation" :> 
          Documentation`HelpLookup["paclet:ref/Correlation"], 
          "SpearmanRankCorrelation" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/SpearmanRankCorrelation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Correlation\"\>", 
       2->"\<\"SpearmanRankCorrelation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KendallRankCorrelation", "ObjectName",
 CellID->9183],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KendallRankCorrelation", "[", 
       RowBox[{
        StyleBox["xlist", "TI"], ",", 
        StyleBox["ylist", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives Kendall's rank correlation coefficient \[Tau] for \
the real-valued vectors ",
     Cell[BoxData[
      StyleBox["xlist", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["ylist", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19796]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Kendall's rank correlation coefficient is a measure of association based on \
the relative order of consecutive elements in the two lists.\
\>", "Notes",
 CellID->882969799],

Cell[TextData[{
 "Kendall's rank correlation coefficient between ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["c", "TI"]], "-", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["d", "TI"]]}], ")"}], "/", 
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["c", "TI"]], "+", 
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["d", "TI"]], "+", 
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["x", "TI"]]}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["c", "TI"]], "+", 
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["d", "TI"]], "+", 
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["y", "TI"]]}], ")"}]}]]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["c", "TI"]]], "InlineFormula"],
 " is the number of concordant pairs of observations, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["d", "TI"]]], "InlineFormula"],
 " is the number of discordant pairs, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " is the number of ties involving only the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " variable, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["y", "TI"]]], "InlineFormula"],
 " is the number of ties involving only the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " variable."
}], "Notes",
 CellID->14798],

Cell[TextData[{
 "A concordant pair of observations ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["j", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["j", "TI"]]}], "}"}]], "InlineFormula"],
 " is one such that both ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["i", "TI"]], ">", 
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["i", "TI"]], ">", 
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " or both ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["i", "TI"]], "<", 
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["i", "TI"]], "<", 
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 ". A discordant pair of observations is one such that ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["i", "TI"]], ">", 
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["i", "TI"]], "<", 
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["i", "TI"]], "<", 
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["i", "TI"]], ">", 
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15281],

Cell[TextData[{
 "The arguments ",
 Cell[BoxData[
  StyleBox["xlist", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["ylist", "TI"]], "InlineFormula"],
 " can be any real\[Hyphen]valued vectors of equal length."
}], "Notes",
 CellID->234751703]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30606515],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->595964453],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->5415571],

Cell["Kendall's rank correlation for two vectors:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->176385558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KendallRankCorrelation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->338243318],

Cell[BoxData[
 FractionBox["1", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77317666]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31613],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Correlation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Correlation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpearmanRankCorrelation",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/SpearmanRankCorrelation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32632],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->31604]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KendallRankCorrelation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 34.4157182}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {"Kendall's tau", "Kendall tau", "rank correlation"}, 
    "index" -> True, "label" -> "Multivariate Statistics Package Symbol", 
    "language" -> "en", "paclet" -> "MultivariateStatistics Package", 
    "status" -> "None", "summary" -> 
    "KendallRankCorrelation[xlist, ylist] gives Kendall's rank correlation \
coefficient \\[Tau] for the real-valued vectors xlist and ylist.", 
    "synonyms" -> {}, "title" -> "KendallRankCorrelation", "type" -> "Symbol",
     "uri" -> "MultivariateStatistics/ref/KendallRankCorrelation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7869, 298, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->30606515]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11918, 438}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1427, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2050, 63, 59, 1, 70, "ObjectName",
 CellID->9183],
Cell[2112, 66, 673, 21, 70, "Usage",
 CellID->19796]
}, Open  ]],
Cell[CellGroupData[{
Cell[2822, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3300, 109, 183, 4, 70, "Notes",
 CellID->882969799],
Cell[3486, 115, 1864, 70, 70, "Notes",
 CellID->14798],
Cell[5353, 187, 2217, 95, 70, "Notes",
 CellID->15281],
Cell[7573, 284, 259, 9, 70, "Notes",
 CellID->234751703]
}, Closed]],
Cell[CellGroupData[{
Cell[7869, 298, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30606515],
Cell[CellGroupData[{
Cell[8253, 312, 148, 5, 70, "ExampleSection",
 CellID->595964453],
Cell[8404, 319, 145, 4, 70, "Input",
 CellID->5415571],
Cell[8552, 325, 223, 5, 70, "ExampleText",
 CellID->176385558],
Cell[CellGroupData[{
Cell[8800, 334, 259, 8, 28, "Input",
 CellID->338243318],
Cell[9062, 344, 177, 6, 51, "Output",
 CellID->77317666]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9300, 357, 311, 9, 70, "SeeAlsoSection",
 CellID->31613],
Cell[9614, 368, 510, 17, 70, "SeeAlso",
 CellID->25374]
}, Open  ]],
Cell[CellGroupData[{
Cell[10161, 390, 314, 9, 70, "TutorialsSection",
 CellID->32632],
Cell[10478, 401, 192, 5, 70, "Tutorials",
 CellID->31604]
}, Open  ]],
Cell[10685, 409, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

