(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6958,        242]
NotebookOptionsPosition[      5120,        184]
NotebookOutlinePosition[      6255,        215]
CellTagsIndexPosition[      6212,        212]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MultivariateMedianDeviation" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultivariateMedianDeviation"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"MultivariateMedianDeviation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MedianMethod", "ObjectName",
 CellID->7925],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["MedianMethod"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["MultivariateMedianDeviation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:MultivariateStatistics/ref/MultivariateMedianDeviation"]], 
      "InlineFormula"],
     " that specifies the multivariate median to use."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"MedianMethod", "->", 
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"]}]], "InlineFormula"],
 " uses a columnwise median."
}], "Notes",
 CellID->165297766],

Cell[TextData[{
 "Other possible settings are ",
 Cell[BoxData[
  ButtonBox["SpatialMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/SpatialMedian"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SimplexMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/SimplexMedian"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ConvexHullMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->35111736]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15690],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["MultivariateMedianDeviation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/MultivariateMedianDeviation"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->4474]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9009],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->23656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MedianMethod - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 34.6188484}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {"median"}, "index" -> True, 
    "label" -> "Multivariate Statistics Package Symbol", "language" -> "en", 
    "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "MedianMethod is an option for MultivariateMedianDeviation that specifies \
the multivariate median to use.", "synonyms" -> {}, "title" -> "MedianMethod",
     "type" -> "Symbol", "uri" -> 
    "MultivariateStatistics/ref/MedianMethod"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1314, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1937, 61, 49, 1, 70, "ObjectName",
 CellID->7925],
Cell[1989, 64, 586, 17, 70, "Usage",
 CellID->20798]
}, Open  ]],
Cell[CellGroupData[{
Cell[2612, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3090, 103, 256, 9, 70, "Notes",
 CellID->165297766],
Cell[3349, 114, 572, 21, 70, "Notes",
 CellID->35111736]
}, Closed]],
Cell[CellGroupData[{
Cell[3958, 140, 311, 9, 70, "SeeAlsoSection",
 CellID->15690],
Cell[4272, 151, 261, 7, 70, "SeeAlso",
 CellID->4474]
}, Open  ]],
Cell[CellGroupData[{
Cell[4570, 163, 313, 9, 70, "TutorialsSection",
 CellID->9009],
Cell[4886, 174, 192, 5, 70, "Tutorials",
 CellID->23656]
}, Open  ]],
Cell[5093, 182, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

