(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10389,        374]
NotebookOptionsPosition[      7724,        288]
NotebookOutlinePosition[      9115,        326]
CellTagsIndexPosition[      9031,        321]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeanDeviation" :> 
          Documentation`HelpLookup["paclet:ref/MeanDeviation"], 
          "MultivariateMedianDeviation" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultivariateMedianDeviation"]}, \
#, 2]& , Evaluator -> Automatic], {1->"\<\"MeanDeviation\"\>", 
       2->"\<\"MultivariateMedianDeviation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MultivariateMeanDeviation", "ObjectName",
 CellID->20220],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MultivariateMeanDeviation", "[", 
       StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the mean of the Euclidean distances between the \
elements of ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     " and their mean."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24179]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MultivariateMeanDeviation"], "InlineFormula"],
 " is a univariate measure of mean deviation for multivariate data."
}], "Notes",
 CellID->194946078],

Cell[TextData[{
 "The multivariate mean deviation is given by ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    StyleBox["n", "TI"]], 
   RowBox[{
    SubscriptBox[
     StyleBox["\[Sum]", "TI"], 
     StyleBox["i", "TI"]], 
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]], "-", 
      OverscriptBox[
       StyleBox["x", "TI"], "_"]}], "]"}]}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["matrix", "TI"], "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", "\[Ellipsis]", ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["n", "TI"]]}], "}"}]}]], "InlineFormula"],
 " and",
 " ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox[
    StyleBox["x", "TI"], "_"], "=", 
   RowBox[{
    ButtonBox["Mean",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mean"], "[", 
    StyleBox["matrix", "TI"], "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18190],

Cell[TextData[{
 Cell[BoxData["MultivariateMeanDeviation"], "InlineFormula"],
 " handles both numerical and symbolic data."
}], "Notes",
 CellID->459706872]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->350209734],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->73038065],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->458638781],

Cell["Multivariate mean deviation for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultivariateMeanDeviation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216950310],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   SqrtBox["2"]}], "3"]], "Output",
 ImageSize->{42, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85140130]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3616],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeanDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultivariateMedianDeviation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:MultivariateStatistics/ref/MultivariateMedianDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28900]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29246],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->19778]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MultivariateMeanDeviation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 36.9314076}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {"mean deviation"}, "index" -> 
    True, "label" -> "Multivariate Statistics Package Symbol", "language" -> 
    "en", "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "MultivariateMeanDeviation[matrix] gives the mean of the Euclidean \
distances between the elements of matrix and their mean.", "synonyms" -> {}, 
    "title" -> "MultivariateMeanDeviation", "type" -> "Symbol", "uri" -> 
    "MultivariateStatistics/ref/MultivariateMeanDeviation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4755, 169, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->350209734]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8888, 314}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1437, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2060, 63, 63, 1, 70, "ObjectName",
 CellID->20220],
Cell[2126, 66, 538, 16, 70, "Usage",
 CellID->24179]
}, Open  ]],
Cell[CellGroupData[{
Cell[2701, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3179, 104, 179, 4, 70, "Notes",
 CellID->194946078],
Cell[3361, 110, 1198, 48, 70, "Notes",
 CellID->18190],
Cell[4562, 160, 156, 4, 70, "Notes",
 CellID->459706872]
}, Closed]],
Cell[CellGroupData[{
Cell[4755, 169, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->350209734],
Cell[CellGroupData[{
Cell[5140, 183, 147, 5, 70, "ExampleSection",
 CellID->73038065],
Cell[5290, 190, 147, 4, 70, "Input",
 CellID->458638781],
Cell[5440, 196, 222, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[5687, 205, 331, 11, 28, "Input",
 CellID->216950310],
Cell[6021, 218, 213, 8, 56, "Output",
 CellID->85140130]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6295, 233, 310, 9, 70, "SeeAlsoSection",
 CellID->3616],
Cell[6608, 244, 528, 18, 70, "SeeAlso",
 CellID->28900]
}, Open  ]],
Cell[CellGroupData[{
Cell[7173, 267, 314, 9, 70, "TutorialsSection",
 CellID->29246],
Cell[7490, 278, 192, 5, 70, "Tutorials",
 CellID->19778]
}, Open  ]],
Cell[7697, 286, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

