(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15600,        555]
NotebookOptionsPosition[     12351,        447]
NotebookOutlinePosition[     13743,        485]
CellTagsIndexPosition[     13658,        480]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MedianDeviation" :> 
          Documentation`HelpLookup["paclet:ref/MedianDeviation"], 
          "MultivariateMeanDeviation" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultivariateMeanDeviation"], 
          "Median" :> Documentation`HelpLookup["paclet:ref/Median"], 
          "SpatialMedian" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/SpatialMedian"], 
          "SimplexMedian" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/SimplexMedian"], 
          "ConvexHullMedian" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/ConvexHullMedian"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MedianDeviation\"\>", 
       2->"\<\"MultivariateMeanDeviation\"\>", 3->"\<\"Median\"\>", 
       4->"\<\"SpatialMedian\"\>", 5->"\<\"SimplexMedian\"\>", 
       6->"\<\"ConvexHullMedian\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MultivariateMedianDeviation", "ObjectName",
 CellID->11921],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MultivariateMedianDeviation", "[", 
       StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the median Euclidean distance from the median of \
the elements in ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29657]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MultivariateMedianDeviation"], "InlineFormula"],
 " is a univariate measure of median deviation for multivariate data."
}], "Notes",
 CellID->194946078],

Cell[TextData[{
 "The multivariate median deviation is given by the median of the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], "-", 
      OverscriptBox[
       StyleBox["x", "TI"], "~"]}], "]"}], ",", 
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], "-", 
      OverscriptBox[
       StyleBox["x", "TI"], "~"]}], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["matrix", "TI"], "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", "\[Ellipsis]", ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["n", "TI"]]}], "}"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  OverscriptBox[
   StyleBox["x", "TI"], "~"]], "InlineFormula"],
 " is the median of ",
 Cell[BoxData[
  StyleBox["matrix", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7958],

Cell["The following option can be given: ", "Notes",
 CellID->11942],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MedianMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:MultivariateStatistics/ref/MedianMethod"], 
    ButtonBox["Median",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Median"], Cell[
    "the median to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->17035],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["MedianMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MedianMethod"]], 
  "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SimplexMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/SimplexMedian"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ConvexHullMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SpatialMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/SpatialMedian"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->19815]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->162327587],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->108191483],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->91838382],

Cell["Multivariate median deviation for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultivariateMedianDeviation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "10"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142954831],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox["2"]}]], "Output",
 ImageSize->{38, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->308545111]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25198],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MedianMethod",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7478],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->551451069],

Cell["Multivariate median deviation using a simplex median:", "ExampleText",
 CellID->238475917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultivariateMedianDeviation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "10"}], "}"}]}], "}"}], ",", 
   RowBox[{"MedianMethod", "\[Rule]", "SimplexMedian"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99892941],

Cell[BoxData["3.3644028563061816`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->79705211]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7976],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MedianDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MedianDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultivariateMeanDeviation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:MultivariateStatistics/ref/MultivariateMeanDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpatialMedian",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/SpatialMedian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SimplexMedian",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/SimplexMedian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConvexHullMedian",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31342]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3036],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->17745]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MultivariateMedianDeviation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 37.1189124}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {"median deviation"}, "index" -> 
    True, "label" -> "Multivariate Statistics Package Symbol", "language" -> 
    "en", "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "MultivariateMedianDeviation[matrix] gives the median Euclidean distance \
from the median of the elements in matrix.", "synonyms" -> {}, "title" -> 
    "MultivariateMedianDeviation", "type" -> "Symbol", "uri" -> 
    "MultivariateStatistics/ref/MultivariateMedianDeviation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6794, 231, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->162327587]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13515, 473}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2033, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2656, 75, 65, 1, 70, "ObjectName",
 CellID->11921],
Cell[2724, 78, 530, 16, 70, "Usage",
 CellID->29657]
}, Open  ]],
Cell[CellGroupData[{
Cell[3291, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3769, 116, 183, 4, 70, "Notes",
 CellID->194946078],
Cell[3955, 122, 1341, 50, 70, "Notes",
 CellID->7958],
Cell[5299, 174, 68, 1, 70, "Notes",
 CellID->11942],
Cell[5370, 177, 539, 15, 70, "3ColumnTableMod",
 CellID->17035],
Cell[5912, 194, 845, 32, 70, "Notes",
 CellID->19815]
}, Closed]],
Cell[CellGroupData[{
Cell[6794, 231, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->162327587],
Cell[CellGroupData[{
Cell[7179, 245, 148, 5, 70, "ExampleSection",
 CellID->108191483],
Cell[7330, 252, 146, 4, 70, "Input",
 CellID->91838382],
Cell[7479, 258, 224, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[7728, 267, 395, 13, 28, "Input",
 CellID->142954831],
Cell[8126, 282, 192, 7, 38, "Output",
 CellID->308545111]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8367, 295, 218, 7, 70, "ExampleSection",
 CellID->25198],
Cell[CellGroupData[{
Cell[8610, 306, 228, 7, 70, "ExampleSubsection",
 CellID->7478],
Cell[8841, 315, 147, 4, 70, "Input",
 CellID->551451069],
Cell[8991, 321, 96, 1, 70, "ExampleText",
 CellID->238475917],
Cell[CellGroupData[{
Cell[9112, 326, 480, 15, 70, "Input",
 CellID->99892941],
Cell[9595, 343, 175, 5, 36, "Output",
 CellID->79705211]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9843, 356, 310, 9, 70, "SeeAlsoSection",
 CellID->7976],
Cell[10156, 367, 1608, 54, 70, "SeeAlso",
 CellID->31342]
}, Open  ]],
Cell[CellGroupData[{
Cell[11801, 426, 313, 9, 70, "TutorialsSection",
 CellID->3036],
Cell[12117, 437, 192, 5, 70, "Tutorials",
 CellID->17745]
}, Open  ]],
Cell[12324, 445, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

