(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11157,        395]
NotebookOptionsPosition[      8303,        302]
NotebookOutlinePosition[      9776,        343]
CellTagsIndexPosition[      9692,        338]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TrimmedMean" :> 
          Documentation`HelpLookup["paclet:ref/TrimmedMean"], "Mean" :> 
          Documentation`HelpLookup["paclet:ref/Mean"], "ConvexHullMedian" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/ConvexHullMedian"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TrimmedMean\"\>", 2->"\<\"Mean\"\>",
        3->"\<\"ConvexHullMedian\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MultivariateTrimmedMean", "ObjectName",
 CellID->25949],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MultivariateTrimmedMean", "[", 
       RowBox[{
        StyleBox["matrix", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the mean of the bivariate data ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     " after dropping a fraction ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " of the outermost vectors. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MultivariateTrimmedMean"], "InlineFormula"],
 " gives a robust estimate of the mean by excluding extreme values."
}], "Notes",
 CellID->44152757],

Cell[TextData[{
 "The outlying vectors are removed by repeatedly peeling off layers of convex \
hulls from the data until at least a fraction ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " have been removed."
}], "Notes",
 CellID->20142],

Cell[TextData[{
 " ",
 Cell[BoxData["MultivariateTrimmedMean"], "InlineFormula"],
 " interpolates between the means of the points remaining before and after \
the last layer is removed."
}], "Notes",
 CellID->226987842],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MultivariateTrimmedMean", "[", 
   RowBox[{
    StyleBox["matrix", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"], "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23844],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MultivariateTrimmedMean", "[", 
   RowBox[{
    StyleBox["matrix", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " approaches ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConvexHullMedian",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"], "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " approaches 1."
}], "Notes",
 CellID->1416]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104893584],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->142800034],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->521998876],

Cell["Multivariate trimmed mean of bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultivariateTrimmedMean", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}]}], "}"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73528470],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.075`", ",", "4.300000000000001`"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200117176]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6744],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrimmedMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrimmedMean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConvexHullMedian",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23658]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21591],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->12848]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MultivariateTrimmedMean - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 43.7753328}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {
     "robust estimate", "location", "robust location estimate", 
      "truncated mean"}, "index" -> True, "label" -> 
    "Multivariate Statistics Package Symbol", "language" -> "en", "paclet" -> 
    "MultivariateStatistics Package", "status" -> "None", "summary" -> 
    "MultivariateTrimmedMean[matrix, f] gives the mean of the bivariate data \
matrix after dropping a fraction f of the outermost vectors. ", 
    "synonyms" -> {}, "title" -> "MultivariateTrimmedMean", "type" -> 
    "Symbol", "uri" -> 
    "MultivariateStatistics/ref/MultivariateTrimmedMean"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4941, 170, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->104893584]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9549, 331}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1478, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2101, 63, 61, 1, 70, "ObjectName",
 CellID->25949],
Cell[2165, 66, 671, 20, 70, "Usage",
 CellID->29869]
}, Open  ]],
Cell[CellGroupData[{
Cell[2873, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3351, 108, 176, 4, 70, "Notes",
 CellID->44152757],
Cell[3530, 114, 253, 7, 70, "Notes",
 CellID->20142],
Cell[3786, 123, 219, 6, 70, "Notes",
 CellID->226987842],
Cell[4008, 131, 377, 14, 70, "Notes",
 CellID->23844],
Cell[4388, 147, 516, 18, 70, "Notes",
 CellID->1416]
}, Closed]],
Cell[CellGroupData[{
Cell[4941, 170, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104893584],
Cell[CellGroupData[{
Cell[5326, 184, 148, 5, 70, "ExampleSection",
 CellID->142800034],
Cell[5477, 191, 147, 4, 70, "Input",
 CellID->521998876],
Cell[5627, 197, 219, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[5871, 206, 510, 17, 28, "Input",
 CellID->73528470],
Cell[6384, 225, 225, 7, 36, "Output",
 CellID->200117176]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6670, 239, 310, 9, 70, "SeeAlsoSection",
 CellID->6744],
Cell[6983, 250, 732, 26, 70, "SeeAlso",
 CellID->23658]
}, Open  ]],
Cell[CellGroupData[{
Cell[7752, 281, 314, 9, 70, "TutorialsSection",
 CellID->21591],
Cell[8069, 292, 192, 5, 70, "Tutorials",
 CellID->12848]
}, Open  ]],
Cell[8276, 300, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

