(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34588,       1214]
NotebookOptionsPosition[     28501,       1002]
NotebookOutlinePosition[     29909,       1040]
CellTagsIndexPosition[     29823,       1035]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NegativeBinomialDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NegativeBinomialDistribution"],
           "MultinomialDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultinomialDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"NegativeBinomialDistribution\"\>", 
       2->"\<\"MultinomialDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NegativeMultinomialDistribution", "ObjectName",
 CellID->22215],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NegativeMultinomialDistribution", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a negative multinomial distribution with \
parameter ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " and failure probability vector ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26671]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability for a vector ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " of nonnegative integers ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ", \[Ellipsis] ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["p", "TI"], "]"}]]], "InlineFormula"],
 " in a negative multinomial distribution is proportional to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      StyleBox["n", "TI"], "-", "1", "+", 
      RowBox[{"\[Sum]", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]]}]}], ")"}], "!"}], 
   RowBox[{"\[Product]", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox[
        StyleBox["p", "TI"], 
        StyleBox["i", "TI"]], 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]]], "/", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], "!"}]}], ")"}]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->612636944],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " can be any positive real number, and ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " can be any vector of nonnegative real numbers that sum to less than \
unity."
}], "Notes",
 CellID->20304],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is a positive integer, ",
 Cell[BoxData[
  RowBox[{"NegativeMultinomialDistribution", "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " gives the distribution of the failure counts in a sequence of trials with \
success probability ",
 Cell[BoxData[
  RowBox[{"1", "-", 
   RowBox[{
    ButtonBox["Total",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Total"], "[", 
    StyleBox["p", "TI"], "]"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 " types of failure before ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " successes occur."
}], "Notes",
 CellID->116383299],

Cell[TextData[{
 Cell[BoxData["NegativeMultinomialDistribution"], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->82602880]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->476288929],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->69901029],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->125432312],

Cell["The mean of a negative multinomial distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NegativeMultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "1"], ",", " ", 
      SubscriptBox["p", "2"], ",", " ", 
      SubscriptBox["p", "3"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", 
     SubscriptBox["p", "1"]}], 
    RowBox[{"1", "-", 
     SubscriptBox["p", "1"], "-", 
     SubscriptBox["p", "2"], "-", 
     SubscriptBox["p", "3"]}]], ",", 
   FractionBox[
    RowBox[{"n", " ", 
     SubscriptBox["p", "2"]}], 
    RowBox[{"1", "-", 
     SubscriptBox["p", "1"], "-", 
     SubscriptBox["p", "2"], "-", 
     SubscriptBox["p", "3"]}]], ",", 
   FractionBox[
    RowBox[{"n", " ", 
     SubscriptBox["p", "3"]}], 
    RowBox[{"1", "-", 
     SubscriptBox["p", "1"], "-", 
     SubscriptBox["p", "2"], "-", 
     SubscriptBox["p", "3"]}]]}], "}"}]], "Output",
 ImageSize->{300, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->333482090]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246746483],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->326412334],

Cell["The variances of each dimension:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->472395019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"NegativeMultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "1"], ",", " ", 
      SubscriptBox["p", "2"], ",", " ", 
      SubscriptBox["p", "3"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8902],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWs1u00AQXid2CbRJ2qZJQQhoD6iCM/QR4AScEaeQVmqRSlGa98tj5HGM
d71OzedZ74y9MZFqe9az87czs+tP/TJf3VzfzVe3i/nZ5+X8z83t4uHs0/0y
G+pHSkULpdT5c5U9p9mT+dO/q+wvf8yfRvraL96m6ji7aDLO7kl2H1o6sfdR
ie5ZvvL8Vx55I4+8vkfeRGgfypsYr4cwegJ0AjRGCb0eA70HdA/ol0L9KJ+l
P9nSxmdVieV0F15XtBrf1AERkSIfYiKPpONIvxDqGwv1YV659EnlcvUdkVGl
pFVXBGW14ZLGpZmF44AWYi36LGyjO4yFvLUuOmLCsiSx3DHJXbZA03sibuwj
vgjX2+KynPaTsoXP7esiLst5Ma9fobCWt+kPWrbeOw9ZXvEyXxrZesuOAlom
7Vh0P9hFzOieH1tNeMagItiDTNGPx8LxAdD6vSbxzMLVPxHqf9JQ/ziQ/y79
xQnT1GdlrXyrM7Sz84n574Q5tk9YVHea5OieMnU/a6l7xNTTRDe1UtWVQS58
/9XjAXrY9Xzy26IixVRtvKVtNL8BF+7U0w5n8fy4KtE6B5YempcD1x7bfgnf
83y5s5F5sPcVa9ZvoJceOpeCtXHv0R3l8bPV9ujTer221ffTVONgMNhsNqnt
Im3e65hG2ZDWHJE268sP0k6Mkb58Z0VzF5x6p9Fkcb57Cu8LDISLoZwDP/a9
OkyFwjwuPPMRQ6H2srJ8sg9XZh0CjTWE5wrOfu6tOYhinTxcJSkGQ6MdGOu2
yJKv+yPN63/FSufii58mKOyBktkEu0F6ulMrXMgLxmJGWkFlVwifEwcfdcp2
nCorOcf7+sT4hcSKODH+v3bTX20+5OWUnLXLSPq+m+mYcWql22ySYR3t8CVJ
dqEsrLsusSnU1SzbZLifHIPyZx/Owp01z75/cAvBavUIiV1WXPe9S4ZyIR2y
Z8lQLV6vorrQI45ykNIoTN8xjlhIWxQM+8GsI3tcqBiu26mDDys1dBwSB1+O
Se6nVbQmIcZ8p10uKoZRptCrUPop2fgFNCN4fDtLU19jxzyl3gEnVtpHoD8I
+d8K+V8bq94bo7ej1vpL4L1kcV2wuN4Yvfox/x8HFf0FfdkmQA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{355, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->244615294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->59339799],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NegativeMultinomialDistribution", "[", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["p", "1"], ",", " ", 
       SubscriptBox["p", "2"], ",", " ", 
       SubscriptBox["p", "3"]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30324],

Cell[BoxData[
 RowBox[{
  RowBox[{"Multinomial", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ",", "x", ",", "y", ",", "z"}], "]"}], 
  " ", 
  SubsuperscriptBox["p", "1", "x"], " ", 
  SubsuperscriptBox["p", "2", "y"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SubscriptBox["p", "1"], "-", 
     SubscriptBox["p", "2"], "-", 
     SubscriptBox["p", "3"]}], ")"}], "n"], " ", 
  SubsuperscriptBox["p", "3", "z"]}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48001189]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5311],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->48018596],

Cell["\<\
Generate a set of pseudorandom vectors that follow a negative multinomial \
distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"NegativeMultinomialDistribution", "[", 
    RowBox[{"20", ",", 
     RowBox[{"{", 
      RowBox[{".2", ",", ".3", ",", ".1"}], "}"}]}], "]"}], ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "19", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "21", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "15", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "8", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "27", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "17", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "17", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "16", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "11", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "18", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{406, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->222432882]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3561],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->10197367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"NegativeMultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "1"], ",", " ", 
      SubscriptBox["p", "2"], ",", " ", 
      SubscriptBox["p", "3"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "+", 
     SubscriptBox["p", "1"], "-", 
     SubscriptBox["p", "2"], "-", 
     SubscriptBox["p", "3"]}], 
    SqrtBox[
     RowBox[{"n", " ", 
      SubscriptBox["p", "1"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["p", "2"], "-", 
        SubscriptBox["p", "3"]}], ")"}]}]]], ",", 
   FractionBox[
    RowBox[{"1", "-", 
     SubscriptBox["p", "1"], "+", 
     SubscriptBox["p", "2"], "-", 
     SubscriptBox["p", "3"]}], 
    SqrtBox[
     RowBox[{"n", " ", 
      SubscriptBox["p", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["p", "1"], "-", 
        SubscriptBox["p", "3"]}], ")"}]}]]], ",", 
   FractionBox[
    RowBox[{"1", "-", 
     SubscriptBox["p", "1"], "-", 
     SubscriptBox["p", "2"], "+", 
     SubscriptBox["p", "3"]}], 
    SqrtBox[
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["p", "1"], "-", 
        SubscriptBox["p", "2"]}], ")"}], " ", 
      SubscriptBox["p", "3"]}]]]}], "}"}]], "Output",
 ImageSize->{394, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->430190054]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2948],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->454858569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"NegativeMultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "1"], ",", " ", 
      SubscriptBox["p", "2"], ",", " ", 
      SubscriptBox["p", "3"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6916],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWktv00AQdpM4tKXvUvEq0AISlZBAIAHXnuDE484ptCB6oEWlXEGCI1zg
R/Rv9F9xNZ71bup8+ezZtZM0qhKpjmc9uzsv78x86cvO0cf3nzpHezudjReH
nc8f93a+bDw/OEyHmlNRNPU0iqK9K1F6n6R35k8+z9K/7Da7+ynXpnuaRCvp
RchW+h2n3/OWju13E/jbueeN9HvXrPoDuC4BHQO9AHRLodsK3TFSHFnZsunu
g7wNq6nI0HLMIBsbRzou4HtnNv9qWLqjVqALypoLdBb6wI+Lyds/C7k6NaR3
McR3Qvliy92i3I0cd+TWVLXBWTsD94XsIHG/NEAf4Ky3do+4K30DdOuupcjP
5q0UjE+T9RlfB2jz3Lx7ja4y2QdXRAnnyZxLZOwiWQd5dqlUeC6hpZ8AvU9X
MWdmK+812f0p8B7QuXL7OPDJTJKdYxihclmnM4yl++IKTz653ICxKcM7R1aN
uyucnJxYK8uy88by29vbllfiJE1AZiW+Gvq9WI5Za1t/zXEvudwJsJF8X7e7
Yrz2emMNnq4m5ZlzIenNlGiFu0BrmXgR1tMy89WERxGeG5mWGzCK2oZm8EUi
Xd+uOfo20HUriCW2f5/30eMo5WVFCqpVdIuMxtaDIRWHbyWC74CLBBbPVSqf
IrlZRmd8rHpr2tOlFRXkdtWqNOIGVDtxLk1/9APP9qOsAblNcEdaWaiz/Coy
vzoNbeLncVdB+lVV5dUpqzfDuPN7zZbO1iKgvDKuV0e3g/Tyq1/DbOfnLb+T
1e8MCKvZq3VXw3z3w+T3OwdZFIV7JcTDrrbLuppbiiUWk7DuxberYX6SHKT1
KqHd1GrBOKvGGN9sgZztAv5FL6s6LbSOy6cLEwlcXZofn1Fk8O361sgYWoV1
gli5tglP08puoqGv9sWof608x1oTLYD8r4DG/eeBzqTcNArn3yrR6g3wYiZa
sprO0Nmo2W3LjRIY30ffYfSYcn3LjYqtj4GeC1hLbhHBPL37lvR2SGj3sg6N
dVDvqWQYv3hShHZKvBP5YL45gimET11dtc9AO5ShZtXyxCBrda16DZdeq0ZH
WXfiXmfli7CaoziCWK5qFoyz071OTYB+zKRiSGVMxvAMrJpLUatMij+KBRGZ
zH5n+WsEyXuDIZHZOSa3j9gu3SddVGqoiON6kjttayGN03QFhi6aXFmKJm7S
teSyVaLfprWT0O0ey11LTnNLfsUrSW+OwmhA1G8hKUcRMU4w+9Rdb9VodQ9G
mVZlPsBMrKF5WEN6oYl93kFbjGZXs0t0M+nFtHAtVveH8GvYXd2cj/uNev9l
Y8Ub1MJ+mZN2cBVz5mAwumFWOZq/xk/icA+HIV01osR7jyKJhoEpFkk2HPRw
FBqERwCtwUb6Trs6eNlrD7+3LPTsHR9JTz1YhkWx3+tD+Vml7Yux+fYDVew+
DDly7wVUG0W4FatMkFf7hZThcAxz8+lplke4l8MdMxzpJtkpTyM2dxVoDZtb
DeSnvwkaXFYGmXRCGqlUdG7Niwur3AxJewij/yjXg9yo2P4f0HMBa8mtjt25
PgXzssPufPsWjt2hLfDNw46hWgcwwe7ODrsLlX6U9U6mjfuN4iBAK5fLtWp1
kP/zwCMJRw+SccT0UMr9ZBwwPpTql2Jxjvkh128jaN6bxRggzpXLfSZFIecp
RsjiRUh/zJDFTBUM0X3JFZGmcDxRi7BifJEh/eV4o3ZayWWLcjaorTastkLH
pV5y+CT7D7d8HkZ7jic+iaObQGt4JT7Hc/b845VoQYdTT/DLavsvU6teph6o
gVdM8Myxkbi+x12VJ7qG4pqhHh5fVPC84Jou+4dEQB1800WP9v9WE1xzgmue
jRwTXHOCaybnGNeMpv4DBfoZUw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{310, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->205512677]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2350],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->115893191],

Cell["\<\
A univariate negative multinomial distribution is a negative binomial \
distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->81489686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NegativeMultinomialDistribution", "[", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"1", "-", "p"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14093519],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}], "x"], " ", 
  SuperscriptBox["p", "n"], " ", 
  RowBox[{"Multinomial", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ",", "x"}], "]"}]}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146343268]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NegativeBinomialDistribution", "[", 
    RowBox[{"n", ",", "p"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->148958097],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}], "x"], " ", 
  SuperscriptBox["p", "n"], " ", 
  RowBox[{"Binomial", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", "n", "+", "x"}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}]}], "]"}]}]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->624204427]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", "==", "%%"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->564587024],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->67154172]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32138],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->682206330],

Cell[TextData[{
 Cell[BoxData["NegativeMultinomialDistribution"], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is not a positive integer:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NegativeMultinomialDistribution", "[", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "1"], ",", " ", 
      SubscriptBox["p", "2"], ",", 
      SubscriptBox["p", "3"], ",", 
      SubscriptBox["p", "4"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95470147],

Cell[BoxData[
 RowBox[{
  RowBox[{"NegativeMultinomialDistribution", "::", "\<\"pos\"\>"}], ":", 
  " ", "\<\"The parameter \\!\\(-2\\) describing the number of successes is \
expected to be a positive, although it need not be an integer. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:MultivariateStatistics/ref/\
NegativeMultinomialDistribution\\\", ButtonNote -> \
\\\"MultivariateStatistics`NegativeMultinomialDistribution::pos\\\"]\\)\"\>"}]\
], "Message", "MSG",
 CellID->82663699],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NegativeMultinomialDistribution", "[", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    TagBox[
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["p", "1"], ",", 
       SubscriptBox["p", "2"], ",", 
       SubscriptBox["p", "3"], ",", 
       SubscriptBox["p", "4"]}], "}"}],
     Short]}], "]"}], "]"}]], "Output",
 ImageSize->{401, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->231316759]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["NegativeMultinomialDistribution"], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is not a vector of probabilities that sums to less than 1:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->322608174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NegativeMultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->209078008],

Cell[BoxData[
 RowBox[{
  RowBox[{"NegativeMultinomialDistribution", "::", "\<\"probvect\"\>"}], ":", 
  " ", "\<\"The parameter \\!\\({1\\/2, 2}\\) is expected to be a vector of \
failure probabilities, each entry between 0 and 1, and all entries summing to \
a quantity less than unity. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:MultivariateStatistics/ref/\
NegativeMultinomialDistribution\\\", ButtonNote -> \
\\\"MultivariateStatistics`NegativeMultinomialDistribution::probvect\\\"]\\)\"\
\>"}]], "Message", "MSG",
 CellID->30735438],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NegativeMultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    TagBox[
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", "2"}], "}"}],
     Short]}], "]"}], "]"}]], "Output",
 ImageSize->{339, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->476419402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15418],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->6796939],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"NegativeMultinomialDistribution", "[", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["p", "1"], ",", " ", 
       SubscriptBox["p", "2"], ",", 
       SubscriptBox["p", "3"]}], "}"}]}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"n", "\[Rule]", 
     RowBox[{"-", "5"}]}], ",", 
    RowBox[{
     SubscriptBox["p", "1"], "\[Rule]", 
     RowBox[{"1", "/", "2"}]}], ",", " ", 
    RowBox[{
     SubscriptBox["p", "2"], "\[Rule]", "2"}], ",", 
    RowBox[{
     SubscriptBox["p", "3"], "\[Rule]", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2647],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["15", "13"], "-", 
    FractionBox[
     RowBox[{"10", " ", "\[ImaginaryI]"}], "13"]}], ",", 
   RowBox[{
    FractionBox["60", "13"], "-", 
    FractionBox[
     RowBox[{"40", " ", "\[ImaginaryI]"}], "13"]}], ",", 
   RowBox[{
    FractionBox["20", "13"], "+", 
    FractionBox[
     RowBox[{"30", " ", "\[ImaginaryI]"}], "13"]}]}], "}"}]], "Output",
 ImageSize->{220, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106161884]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24637],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NegativeBinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NegativeBinomialDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/MultinomialDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6969]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25084],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->17915]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NegativeMultinomialDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 44.0409646}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {}, "index" -> True, "label" -> 
    "Multivariate Statistics Package Symbol", "language" -> "en", "paclet" -> 
    "MultivariateStatistics Package", "status" -> "None", "summary" -> 
    "NegativeMultinomialDistribution[n, p] represents a negative multinomial \
distribution with parameter n and failure probability vector p.", 
    "synonyms" -> {}, "title" -> "NegativeMultinomialDistribution", "type" -> 
    "Symbol", "uri" -> 
    "MultivariateStatistics/ref/NegativeMultinomialDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6427, 231, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->476288929]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29680, 1028}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1486, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2109, 64, 69, 1, 70, "ObjectName",
 CellID->22215],
Cell[2181, 67, 675, 21, 70, "Usage",
 CellID->26671]
}, Open  ]],
Cell[CellGroupData[{
Cell[2893, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3371, 110, 1300, 50, 70, "Notes",
 CellID->612636944],
Cell[4674, 162, 301, 10, 70, "Notes",
 CellID->20304],
Cell[4978, 174, 882, 31, 70, "Notes",
 CellID->116383299],
Cell[5863, 207, 527, 19, 70, "Notes",
 CellID->82602880]
}, Closed]],
Cell[CellGroupData[{
Cell[6427, 231, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->476288929],
Cell[CellGroupData[{
Cell[6812, 245, 147, 5, 70, "ExampleSection",
 CellID->69901029],
Cell[6962, 252, 147, 4, 70, "Input",
 CellID->125432312],
Cell[7112, 258, 223, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[7360, 267, 327, 10, 28, "Input",
 CellID->24173],
Cell[7690, 279, 790, 28, 51, "Output",
 CellID->333482090]
}, Open  ]],
Cell[8495, 310, 125, 3, 70, "ExampleDelimiter",
 CellID->246746483],
Cell[8623, 315, 147, 4, 70, "Input",
 CellID->326412334],
Cell[8773, 321, 212, 5, 70, "ExampleText",
 CellID->472395019],
Cell[CellGroupData[{
Cell[9010, 330, 330, 10, 28, "Input",
 CellID->8902],
Cell[9343, 342, 1362, 26, 54, "Output",
 Evaluatable->False,
 CellID->244615294]
}, Open  ]],
Cell[10720, 371, 119, 3, 70, "ExampleDelimiter",
 CellID->675],
Cell[10842, 376, 146, 4, 70, "Input",
 CellID->59339799],
Cell[10991, 382, 204, 5, 70, "ExampleText",
 CellID->6303],
Cell[CellGroupData[{
Cell[11220, 391, 415, 13, 70, "Input",
 CellID->30324],
Cell[11638, 406, 605, 20, 36, "Output",
 CellID->48001189]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12292, 432, 215, 7, 70, "ExampleSection",
 CellID->5311],
Cell[12510, 441, 146, 4, 70, "Input",
 CellID->48018596],
Cell[12659, 447, 273, 8, 70, "ExampleText",
 CellID->24449],
Cell[CellGroupData[{
Cell[12957, 459, 282, 9, 70, "Input",
 CellID->5765],
Cell[13242, 470, 888, 27, 54, "Output",
 CellID->222432882]
}, Open  ]],
Cell[14145, 500, 120, 3, 70, "ExampleDelimiter",
 CellID->3561],
Cell[14268, 505, 146, 4, 70, "Input",
 CellID->10197367],
Cell[CellGroupData[{
Cell[14439, 513, 330, 10, 70, "Input",
 CellID->6096],
Cell[14772, 525, 1231, 43, 56, "Output",
 CellID->430190054]
}, Open  ]],
Cell[16018, 571, 120, 3, 70, "ExampleDelimiter",
 CellID->2948],
Cell[16141, 576, 147, 4, 70, "Input",
 CellID->454858569],
Cell[CellGroupData[{
Cell[16313, 584, 330, 10, 70, "Input",
 CellID->6916],
Cell[16646, 596, 2132, 39, 70, "Output",
 Evaluatable->False,
 CellID->205512677]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18827, 641, 232, 7, 70, "ExampleSection",
 CellID->2350],
Cell[19062, 650, 147, 4, 70, "Input",
 CellID->115893191],
Cell[19212, 656, 272, 8, 70, "ExampleText",
 CellID->81489686],
Cell[CellGroupData[{
Cell[19509, 668, 282, 9, 70, "Input",
 CellID->14093519],
Cell[19794, 679, 396, 14, 36, "Output",
 CellID->146343268]
}, Open  ]],
Cell[CellGroupData[{
Cell[20227, 698, 203, 6, 70, "Input",
 CellID->148958097],
Cell[20433, 706, 449, 16, 36, "Output",
 CellID->624204427]
}, Open  ]],
Cell[CellGroupData[{
Cell[20919, 727, 133, 4, 70, "Input",
 CellID->564587024],
Cell[21055, 733, 160, 5, 36, "Output",
 CellID->67154172]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21264, 744, 226, 7, 70, "ExampleSection",
 CellID->32138],
Cell[21493, 753, 147, 4, 70, "Input",
 CellID->682206330],
Cell[21643, 759, 368, 11, 70, "ExampleText",
 CellID->8964],
Cell[CellGroupData[{
Cell[22036, 774, 381, 12, 70, "Input",
 CellID->95470147],
Cell[22420, 788, 560, 11, 70, "Message",
 CellID->82663699],
Cell[22983, 801, 497, 17, 36, "Output",
 CellID->231316759]
}, Open  ]],
Cell[23495, 821, 405, 11, 70, "ExampleText",
 CellID->322608174],
Cell[CellGroupData[{
Cell[23925, 836, 260, 8, 70, "Input",
 CellID->209078008],
Cell[24188, 846, 613, 11, 70, "Message",
 CellID->30735438],
Cell[24804, 859, 375, 13, 51, "Output",
 CellID->476419402]
}, Open  ]],
Cell[25194, 875, 121, 3, 70, "ExampleDelimiter",
 CellID->15418],
Cell[25318, 880, 145, 4, 70, "Input",
 CellID->6796939],
Cell[25466, 886, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[25772, 898, 670, 22, 70, "Input",
 CellID->2647],
Cell[26445, 922, 550, 19, 51, "Output",
 CellID->106161884]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27056, 948, 311, 9, 70, "SeeAlsoSection",
 CellID->24637],
Cell[27370, 959, 543, 17, 70, "SeeAlso",
 CellID->6969]
}, Open  ]],
Cell[CellGroupData[{
Cell[27950, 981, 314, 9, 70, "TutorialsSection",
 CellID->25084],
Cell[28267, 992, 192, 5, 70, "Tutorials",
 CellID->17915]
}, Open  ]],
Cell[28474, 1000, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

