(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38711,       1335]
NotebookOptionsPosition[     33312,       1148]
NotebookOutlinePosition[     34770,       1188]
CellTagsIndexPosition[     34684,       1183]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MultinormalDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultinormalDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"MultinormalDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["QuadraticFormDistribution", "ObjectName",
 CellID->30086],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"QuadraticFormDistribution", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["a", "TI"], ",", 
          StyleBox["b", "TI"], ",", 
          StyleBox["c", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["\[Mu]", "TR"], ",", 
          StyleBox["\[CapitalSigma]", "TR"]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]represents the distribution of a quadratic form ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["z", "TI"], ".", 
        StyleBox["a", "TI"], ".", 
        StyleBox["z", "TI"]}], "+", 
       RowBox[{
        StyleBox["b", "TI"], ".", 
        StyleBox["z", "TI"]}], "+", 
       StyleBox["c", "TI"]}]], "InlineFormula"],
     " for multivariate normal ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->464]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["QuadraticFormDistribution"], "InlineFormula"],
 " is the distribution of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["z", "TI"], ".", 
    StyleBox["a", "TI"], ".", 
    StyleBox["z", "TI"]}], "+", 
   RowBox[{
    StyleBox["b", "TI"], ".", 
    StyleBox["z", "TI"]}], "+", 
   StyleBox["c", "TI"]}]], "InlineFormula"],
 " for real-valued ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], "\[Times]", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 " symmetric positive definite matrix ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ", length ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " vector ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ", scalar ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "-dimensional multivariate normal vector ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->216039454],

Cell[TextData[{
 Cell[BoxData["QuadraticFormDistribution"], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1355]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173500230],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->150341758],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->226346518],

Cell["The mean of a quadratic form distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"QuadraticFormDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["a", "11"], ",", 
          SubscriptBox["a", "12"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["a", "12"], ",", 
          SubscriptBox["a", "22"]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["b", "1"], ",", 
        SubscriptBox["b", "2"]}], "}"}], ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Mu]", "1"], ",", 
        SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SuperscriptBox[
           SubscriptBox["\[Sigma]", "11"], "2"], ",", 
          RowBox[{"\[Rho]", "*", 
           SubscriptBox["\[Sigma]", "11"], "*", 
           SubscriptBox["\[Sigma]", "22"]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Rho]", "*", 
           SubscriptBox["\[Sigma]", "11"], "*", 
           SubscriptBox["\[Sigma]", "22"]}], ",", 
          SuperscriptBox[
           SubscriptBox["\[Sigma]", "22"], "2"]}], "}"}]}], "}"}]}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24173],

Cell[BoxData[
 RowBox[{"c", "+", 
  RowBox[{
   SubscriptBox["b", "1"], " ", 
   SubscriptBox["\[Mu]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["b", "2"], " ", 
   SubscriptBox["\[Mu]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Mu]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "11"], " ", 
      SubscriptBox["\[Mu]", "1"]}], "+", 
     RowBox[{
      SubscriptBox["a", "12"], " ", 
      SubscriptBox["\[Mu]", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Mu]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "12"], " ", 
      SubscriptBox["\[Mu]", "1"]}], "+", 
     RowBox[{
      SubscriptBox["a", "22"], " ", 
      SubscriptBox["\[Mu]", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["a", "11"], " ", 
   SubsuperscriptBox["\[Sigma]", "11", "2"]}], "+", 
  RowBox[{"2", " ", "\[Rho]", " ", 
   SubscriptBox["a", "12"], " ", 
   SubscriptBox["\[Sigma]", "11"], " ", 
   SubscriptBox["\[Sigma]", "22"]}], "+", 
  RowBox[{
   SubscriptBox["a", "22"], " ", 
   SubsuperscriptBox["\[Sigma]", "22", "2"]}]}]], "Output",
 ImageSize->{527, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106542364]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246746483],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1967454],

Cell["The variance of a quadratic form distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->472395019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"QuadraticFormDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["b", "1"], ",", 
        SubscriptBox["b", "2"]}], "}"}], ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Mu]", "1"], ",", 
        SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8902],

Cell[BoxData[
 RowBox[{"5", "+", 
  SubsuperscriptBox["b", "1", "2"], "+", 
  SubsuperscriptBox["b", "2", "2"], "+", 
  RowBox[{"4", " ", 
   SubscriptBox["b", "1"], " ", 
   SubscriptBox["\[Mu]", "1"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["b", "2"], " ", 
   SubscriptBox["\[Mu]", "1"]}], "+", 
  RowBox[{"5", " ", 
   SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["b", "1"], " ", 
   SubscriptBox["\[Mu]", "2"]}], "+", 
  RowBox[{"4", " ", 
   SubscriptBox["b", "2"], " ", 
   SubscriptBox["\[Mu]", "2"]}], "+", 
  RowBox[{"8", " ", 
   SubscriptBox["\[Mu]", "1"], " ", 
   SubscriptBox["\[Mu]", "2"]}], "+", 
  RowBox[{"5", " ", 
   SubsuperscriptBox["\[Mu]", "2", "2"]}]}]], "Output",
 ImageSize->{385, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->567723016]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5154],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->316394531],

Cell["\<\
Generate a set of pseudorandom numbers that follow a quadratic form \
distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"QuadraticFormDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}], ",", 
   "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.112684322961799`", ",", "4.972171873445854`", ",", "5.9489375748825815`",
    ",", "4.304756347090058`", ",", "4.461498142714127`", ",", 
   "4.6601669866573046`", ",", "4.89329439798393`", ",", "4.127826778537621`",
    ",", "4.104462658927446`", ",", "5.132786115579111`"}], "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->693585708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3561],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->87123137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"QuadraticFormDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["b", "1"], ",", 
        SubscriptBox["b", "2"]}], "}"}], ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Mu]", "1"], ",", 
        SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6096],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"14", "+", 
      RowBox[{"3", " ", 
       SubsuperscriptBox["b", "1", "2"]}], "+", 
      RowBox[{"3", " ", 
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["b", "2"]}], "+", 
      RowBox[{"3", " ", 
       SubsuperscriptBox["b", "2", "2"]}], "+", 
      RowBox[{"15", " ", 
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["\[Mu]", "1"]}], "+", 
      RowBox[{"12", " ", 
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["\[Mu]", "1"]}], "+", 
      RowBox[{"21", " ", 
       SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
      RowBox[{"12", " ", 
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["\[Mu]", "2"]}], "+", 
      RowBox[{"15", " ", 
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["\[Mu]", "2"]}], "+", 
      RowBox[{"39", " ", 
       SubscriptBox["\[Mu]", "1"], " ", 
       SubscriptBox["\[Mu]", "2"]}], "+", 
      RowBox[{"21", " ", 
       SubsuperscriptBox["\[Mu]", "2", "2"]}]}], ")"}]}], ")"}], "/", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"5", "+", 
     SubsuperscriptBox["b", "1", "2"], "+", 
     SubsuperscriptBox["b", "2", "2"], "+", 
     RowBox[{"4", " ", 
      SubscriptBox["b", "1"], " ", 
      SubscriptBox["\[Mu]", "1"]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["b", "2"], " ", 
      SubscriptBox["\[Mu]", "1"]}], "+", 
     RowBox[{"5", " ", 
      SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["b", "1"], " ", 
      SubscriptBox["\[Mu]", "2"]}], "+", 
     RowBox[{"4", " ", 
      SubscriptBox["b", "2"], " ", 
      SubscriptBox["\[Mu]", "2"]}], "+", 
     RowBox[{"8", " ", 
      SubscriptBox["\[Mu]", "1"], " ", 
      SubscriptBox["\[Mu]", "2"]}], "+", 
     RowBox[{"5", " ", 
      SubsuperscriptBox["\[Mu]", "2", "2"]}]}], ")"}], 
   RowBox[{"3", "/", "2"}]]}]], "Output",
 ImageSize->{562, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->557754434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2948],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->565644723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"QuadraticFormDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["b", "1"], ",", 
        SubscriptBox["b", "2"]}], "}"}], ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Mu]", "1"], ",", 
        SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6916],

Cell[BoxData[
 RowBox[{"3", "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"6", " ", 
     RowBox[{"(", 
      RowBox[{"41", "+", 
       RowBox[{"10", " ", 
        SubsuperscriptBox["b", "1", "2"]}], "+", 
       RowBox[{"16", " ", 
        SubscriptBox["b", "1"], " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"10", " ", 
        SubsuperscriptBox["b", "2", "2"]}], "+", 
       RowBox[{"56", " ", 
        SubscriptBox["b", "1"], " ", 
        SubscriptBox["\[Mu]", "1"]}], "+", 
       RowBox[{"52", " ", 
        SubscriptBox["b", "2"], " ", 
        SubscriptBox["\[Mu]", "1"]}], "+", 
       RowBox[{"82", " ", 
        SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
       RowBox[{"52", " ", 
        SubscriptBox["b", "1"], " ", 
        SubscriptBox["\[Mu]", "2"]}], "+", 
       RowBox[{"56", " ", 
        SubscriptBox["b", "2"], " ", 
        SubscriptBox["\[Mu]", "2"]}], "+", 
       RowBox[{"160", " ", 
        SubscriptBox["\[Mu]", "1"], " ", 
        SubscriptBox["\[Mu]", "2"]}], "+", 
       RowBox[{"82", " ", 
        SubsuperscriptBox["\[Mu]", "2", "2"]}]}], ")"}]}], ")"}], "/", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"5", "+", 
      SubsuperscriptBox["b", "1", "2"], "+", 
      SubsuperscriptBox["b", "2", "2"], "+", 
      RowBox[{"4", " ", 
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["\[Mu]", "1"]}], "+", 
      RowBox[{"2", " ", 
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["\[Mu]", "1"]}], "+", 
      RowBox[{"5", " ", 
       SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
      RowBox[{"2", " ", 
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["\[Mu]", "2"]}], "+", 
      RowBox[{"4", " ", 
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["\[Mu]", "2"]}], "+", 
      RowBox[{"8", " ", 
       SubscriptBox["\[Mu]", "1"], " ", 
       SubscriptBox["\[Mu]", "2"]}], "+", 
      RowBox[{"5", " ", 
       SubsuperscriptBox["\[Mu]", "2", "2"]}]}], ")"}], "2"]}]}]], "Output",
 ImageSize->{439, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->254812590]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19293],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->586968192],

Cell[TextData[{
 "PDF and CDF can only be evaluated using ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dist", "=", 
  RowBox[{"QuadraticFormDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->97380122],

Cell[BoxData[
 RowBox[{"QuadraticFormDistribution", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}],
      Short], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}],
      Short]}], "}"}]}], "]"}]], "Output",
 ImageSize->{559, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53154114]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdf", "=", 
  RowBox[{"PDF", "[", 
   RowBox[{"dist", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->95470147],

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"QuadraticFormDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}],
        Short], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}],
        Short]}], "}"}]}], "]"}], ",", "x"}], "]"}]], "Output",
 ImageSize->{416, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->643466081]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"pdf", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "5"}], "/", "4"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->262058155],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"5", "/", "8"}]]}]], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"x", "+", 
       FractionBox["5", "4"]}], ")"}]}], 
    RowBox[{"32", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"5", "/", "8"}]]}]], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", 
        FractionBox["5", "4"]}], ")"}], "2"]}], 
    RowBox[{"2048", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"5", "/", "8"}]]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "+", 
       FractionBox["5", "4"]}], "]"}], "3"],
    SeriesData[$CellContext`x, 
     Rational[-5, 4], {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   Rational[-5, 4], {
   Rational[1, 2] E^Rational[-5, 8], Rational[-3, 32] E^Rational[-5, 8], 
    Rational[-7, 2048] E^Rational[-5, 8]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{257, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->34119971]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{"dist", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "5"}], "/", "4"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->186278194],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"x", "+", 
     FractionBox["5", "4"]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"5", "/", "8"}]]}]], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", 
        FractionBox["5", "4"]}], ")"}], "2"]}], 
    RowBox[{"64", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"5", "/", "8"}]]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "+", 
       FractionBox["5", "4"]}], "]"}], "3"],
    SeriesData[$CellContext`x, 
     Rational[-5, 4], {}, 1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   Rational[-5, 4], {
   Rational[1, 2] E^Rational[-5, 8], Rational[-3, 64] E^Rational[-5, 8]}, 1, 
   3, 1],
  Editable->False]], "Output",
 ImageSize->{187, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->52866245]
}, Open  ]],

Cell["\<\
Series expansion must be about the lower support point for the distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->77093390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{"dist", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->226920241],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"qforig\"\>"}], ":", 
  " ", "\<\"The Series expansions of the PDF and CDF of the \
QuadraticFormDistribution must be about the lower point of the domain \\!\\(x\
\\) = \\!\\(-\\(\\(5\\/4\\)\\)\\). Try \
Series[\\!\\(CDF[\\(\\(\\(\\(QuadraticFormDistribution[\\(\\(\\(\\({\\(\\({\\(\
\\({1, 0}\\)\\), \\(\\({0, 1}\\)\\)}\\)\\), \\(\\({1, 2}\\)\\), 0}\\)\\), \\(\
\\({\\(\\({0, 0}\\)\\), \\(\\({\\(\\({1, 0}\\)\\), \\(\\({0, 1}\\)\\)}\\)\\)}\
\\)\\)\\)\\)]\\)\\), x\\)\\)]\\), \\!\\({x, \\(\\(-\\(\\(5\\/4\\)\\)\\)\\), \
2}\\)]. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Series\\\", ButtonNote -> \
\\\"Series::qforig\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->552644369],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{450, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->563479862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15418],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->84884342],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"QuadraticFormDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["b", "1"], ",", 
         SubscriptBox["b", "2"]}], "}"}], ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}], "]"}], "/.",
   
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["b", "1"], "\[Rule]", "1"}], ",", 
    RowBox[{
     SubscriptBox["b", "2"], "\[Rule]", "I"}], ",", 
    RowBox[{"c", "\[Rule]", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2647],

Cell[BoxData[
 RowBox[{"3", "+", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5469566]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32351],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["MultinormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MultinormalDistribution"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->15347]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29624],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->8181]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"QuadraticFormDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 45.1972442}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {"quadratic form", "discriminant analysis"}, "index" -> 
    True, "label" -> "Multivariate Statistics Package Symbol", "language" -> 
    "en", "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "QuadraticFormDistribution[{a, b, c}, {\\[Mu], \\[CapitalSigma]}] \
represents the distribution of a quadratic form z.a.z + b.z + c for \
multivariate normal z.", "synonyms" -> {}, "title" -> 
    "QuadraticFormDistribution", "type" -> "Symbol", "uri" -> 
    "MultivariateStatistics/ref/QuadraticFormDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5068, 181, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->173500230]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34541, 1176}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1310, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1933, 61, 63, 1, 70, "ObjectName",
 CellID->30086],
Cell[1999, 64, 1111, 36, 70, "Usage",
 CellID->464]
}, Open  ]],
Cell[CellGroupData[{
Cell[3147, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3625, 122, 1008, 38, 70, "Notes",
 CellID->216039454],
Cell[4636, 162, 395, 14, 70, "Notes",
 CellID->1355]
}, Closed]],
Cell[CellGroupData[{
Cell[5068, 181, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173500230],
Cell[CellGroupData[{
Cell[5453, 195, 148, 5, 70, "ExampleSection",
 CellID->150341758],
Cell[5604, 202, 147, 4, 70, "Input",
 CellID->226346518],
Cell[5754, 208, 217, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[5996, 217, 1378, 44, 49, "Input",
 CellID->24173],
Cell[7377, 263, 1237, 42, 36, "Output",
 CellID->106542364]
}, Open  ]],
Cell[8629, 308, 125, 3, 70, "ExampleDelimiter",
 CellID->246746483],
Cell[8757, 313, 145, 4, 70, "Input",
 CellID->1967454],
Cell[8905, 319, 226, 5, 70, "ExampleText",
 CellID->472395019],
Cell[CellGroupData[{
Cell[9156, 328, 928, 32, 70, "Input",
 CellID->8902],
Cell[10087, 362, 864, 27, 36, "Output",
 CellID->567723016]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11000, 395, 215, 7, 70, "ExampleSection",
 CellID->5154],
Cell[11218, 404, 147, 4, 70, "Input",
 CellID->316394531],
Cell[11368, 410, 267, 8, 70, "ExampleText",
 CellID->24449],
Cell[CellGroupData[{
Cell[11660, 422, 859, 29, 70, "Input",
 CellID->5765],
Cell[12522, 453, 470, 11, 54, "Output",
 CellID->693585708]
}, Open  ]],
Cell[13007, 467, 120, 3, 70, "ExampleDelimiter",
 CellID->3561],
Cell[13130, 472, 146, 4, 70, "Input",
 CellID->87123137],
Cell[CellGroupData[{
Cell[13301, 480, 928, 32, 70, "Input",
 CellID->6096],
Cell[14232, 514, 2054, 61, 62, "Output",
 CellID->557754434]
}, Open  ]],
Cell[16301, 578, 120, 3, 70, "ExampleDelimiter",
 CellID->2948],
Cell[16424, 583, 147, 4, 70, "Input",
 CellID->565644723],
Cell[CellGroupData[{
Cell[16596, 591, 928, 32, 70, "Input",
 CellID->6916],
Cell[17527, 625, 2111, 61, 80, "Output",
 CellID->254812590]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19687, 692, 226, 7, 70, "ExampleSection",
 CellID->19293],
Cell[19916, 701, 147, 4, 70, "Input",
 CellID->586968192],
Cell[20066, 707, 351, 12, 70, "ExampleText",
 CellID->8964],
Cell[CellGroupData[{
Cell[20442, 723, 740, 26, 70, "Input",
 CellID->97380122],
Cell[21185, 751, 846, 31, 36, "Output",
 CellID->53154114]
}, Open  ]],
Cell[CellGroupData[{
Cell[22068, 787, 150, 5, 70, "Input",
 CellID->95470147],
Cell[22221, 794, 951, 33, 54, "Output",
 CellID->643466081]
}, Open  ]],
Cell[CellGroupData[{
Cell[23209, 832, 234, 8, 70, "Input",
 CellID->262058155],
Cell[23446, 842, 1229, 41, 62, "Output",
 CellID->34119971]
}, Open  ]],
Cell[CellGroupData[{
Cell[24712, 888, 291, 10, 70, "Input",
 CellID->186278194],
Cell[25006, 900, 1007, 35, 62, "Output",
 CellID->52866245]
}, Open  ]],
Cell[26028, 938, 263, 7, 70, "ExampleText",
 CellID->77093390],
Cell[CellGroupData[{
Cell[26316, 949, 243, 8, 70, "Input",
 CellID->226920241],
Cell[26562, 959, 805, 14, 70, "Message",
 CellID->552644369],
Cell[27370, 975, 2811, 50, 70, "Output",
 Evaluatable->False,
 CellID->563479862]
}, Open  ]],
Cell[30196, 1028, 121, 3, 70, "ExampleDelimiter",
 CellID->15418],
Cell[30320, 1033, 146, 4, 70, "Input",
 CellID->84884342],
Cell[30469, 1039, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[30775, 1051, 1110, 38, 70, "Input",
 CellID->2647],
Cell[31888, 1091, 213, 7, 36, "Output",
 CellID->5469566]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32162, 1105, 311, 9, 70, "SeeAlsoSection",
 CellID->32351],
Cell[32476, 1116, 249, 6, 70, "SeeAlso",
 CellID->15347]
}, Open  ]],
Cell[CellGroupData[{
Cell[32762, 1127, 314, 9, 70, "TutorialsSection",
 CellID->29624],
Cell[33079, 1138, 191, 5, 70, "Tutorials",
 CellID->8181]
}, Open  ]],
Cell[33285, 1146, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

