(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10012,        352]
NotebookOptionsPosition[      7539,        271]
NotebookOutlinePosition[      8851,        308]
CellTagsIndexPosition[      8767,        303]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Median" :> Documentation`HelpLookup["paclet:ref/Median"], 
          "SpatialMedian" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/SpatialMedian"], 
          "ConvexHullMedian" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/ConvexHullMedian"], 
          "MultivariateMedianDeviation" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultivariateMedianDeviation"]}, \
#, 2]& , Evaluator -> Automatic], {1->"\<\"Median\"\>", 
       2->"\<\"SpatialMedian\"\>", 3->"\<\"ConvexHullMedian\"\>", 
       4->"\<\"MultivariateMedianDeviation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SimplexMedian", "ObjectName",
 CellID->30516],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SimplexMedian", "[", 
       StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a simplex median of the elements in ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24182]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SimplexMedian", "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 " gives a vector ",
 Cell[BoxData[
  OverscriptBox[
   StyleBox["x", "TI"], "~"]], "InlineFormula"],
 " minimizing the sum of the volumes of the ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "-dimensional simplices formed by the elements of ",
 Cell[BoxData[
  StyleBox["matrix", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  OverscriptBox[
   StyleBox["x", "TI"], "~"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->130683939]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->437869043],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->184984032],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->5120822],

Cell["Simplex median for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SimplexMedian", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->427897580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.6666666666666667`", ",", "2.6666666666666665`"}], 
  "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->35232787]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1797],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpatialMedian",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/SpatialMedian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConvexHullMedian",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultivariateMedianDeviation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:MultivariateStatistics/ref/MultivariateMedianDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23668],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->20536]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SimplexMedian - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 50.4005024}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {"median", "simplex median"}, 
    "index" -> True, "label" -> "Multivariate Statistics Package Symbol", 
    "language" -> "en", "paclet" -> "MultivariateStatistics Package", 
    "status" -> "None", "summary" -> 
    "SimplexMedian[matrix] gives a simplex median of the elements in matrix.",
     "synonyms" -> {}, "title" -> "SimplexMedian", "type" -> "Symbol", "uri" -> 
    "MultivariateStatistics/ref/SimplexMedian"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4020, 134, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->437869043]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8624, 296}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1737, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2360, 69, 51, 1, 70, "ObjectName",
 CellID->30516],
Cell[2414, 72, 485, 15, 70, "Usage",
 CellID->24182]
}, Open  ]],
Cell[CellGroupData[{
Cell[2936, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3414, 109, 569, 20, 70, "Notes",
 CellID->130683939]
}, Closed]],
Cell[CellGroupData[{
Cell[4020, 134, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->437869043],
Cell[CellGroupData[{
Cell[4405, 148, 148, 5, 70, "ExampleSection",
 CellID->184984032],
Cell[4556, 155, 145, 4, 70, "Input",
 CellID->5120822],
Cell[4704, 161, 209, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[4938, 170, 319, 11, 28, "Input",
 CellID->427897580],
Cell[5260, 183, 242, 8, 36, "Output",
 CellID->35232787]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5563, 198, 310, 9, 70, "SeeAlsoSection",
 CellID->1797],
Cell[5876, 209, 1075, 36, 70, "SeeAlso",
 CellID->13073]
}, Open  ]],
Cell[CellGroupData[{
Cell[6988, 250, 314, 9, 70, "TutorialsSection",
 CellID->23668],
Cell[7305, 261, 192, 5, 70, "Tutorials",
 CellID->20536]
}, Open  ]],
Cell[7512, 269, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

