(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14745,        549]
NotebookOptionsPosition[     11499,        438]
NotebookOutlinePosition[     12795,        475]
CellTagsIndexPosition[     12710,        470]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variance" :> Documentation`HelpLookup["paclet:ref/Variance"], 
          "GeneralizedVariance" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/GeneralizedVariance"], 
          "Covariance" :> 
          Documentation`HelpLookup["paclet:ref/Covariance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Variance\"\>", 
       2->"\<\"GeneralizedVariance\"\>", 
       3->"\<\"Covariance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TotalVariation", "ObjectName",
 CellID->26140],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TotalVariation", "[", 
       StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the total variation for ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16423]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TotalVariation", "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 " effectively gives the trace of the covariance matrix for ",
 Cell[BoxData[
  StyleBox["matrix", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30205783],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TotalVariation", "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"], "[", 
   RowBox[{
    ButtonBox["Variance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Variance"], "[", 
    StyleBox["matrix", "TI"], "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5002]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->840460543],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->527192708],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->535103262],

Cell["Total variation of bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TotalVariation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19771377],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "c", "-", "e"}], ")"}]}]}], ")"}], "2"], 
     "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "c", "-", "e"}], ")"}]}]}], ")"}], "2"], 
     "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "c", "-", "e"}], ")"}]}], "+", "e"}], 
       ")"}], "2"]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "b"}], "-", "d", "-", "f"}], ")"}]}]}], ")"}], "2"], 
     "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "b"}], "-", "d", "-", "f"}], ")"}]}]}], ")"}], "2"], 
     "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "b"}], "-", "d", "-", "f"}], ")"}]}], "+", "f"}], 
       ")"}], "2"]}], ")"}]}]}]], "Output",
 ImageSize->{431, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->317271518]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16028],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->517324494],

Cell["\<\
Total variation is equivalent to the trace of the covariance matrix:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->143789359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TotalVariation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10528200],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->188605246]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"Covariance", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32996918],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43192689]
}, Open  ]],

Cell["\<\
Total variation is equivalent to the sum of column variances:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->454163553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"Variance", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->676513535],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2945263]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13521],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralizedVariance",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/GeneralizedVariance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Covariance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Covariance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29017]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14957],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->6051]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TotalVariation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 50.9786422}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {"total variation"}, "index" -> 
    True, "label" -> "Multivariate Statistics Package Symbol", "language" -> 
    "en", "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "TotalVariation[matrix] gives the total variation for matrix.", 
    "synonyms" -> {}, "title" -> "TotalVariation", "type" -> "Symbol", "uri" -> 
    "MultivariateStatistics/ref/TotalVariation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3965, 138, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->840460543]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12567, 463}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1516, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2139, 65, 52, 1, 70, "ObjectName",
 CellID->26140],
Cell[2194, 68, 474, 15, 70, "Usage",
 CellID->16423]
}, Open  ]],
Cell[CellGroupData[{
Cell[2705, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3183, 105, 281, 9, 70, "Notes",
 CellID->30205783],
Cell[3467, 116, 461, 17, 70, "Notes",
 CellID->5002]
}, Closed]],
Cell[CellGroupData[{
Cell[3965, 138, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->840460543],
Cell[CellGroupData[{
Cell[4350, 152, 148, 5, 70, "ExampleSection",
 CellID->527192708],
Cell[4501, 159, 147, 4, 70, "Input",
 CellID->535103262],
Cell[4651, 165, 209, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[4885, 174, 319, 11, 28, "Input",
 CellID->19771377],
Cell[5207, 187, 1851, 68, 83, "Output",
 CellID->317271518]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7107, 261, 233, 7, 70, "ExampleSection",
 CellID->16028],
Cell[7343, 270, 147, 4, 70, "Input",
 CellID->517324494],
Cell[7493, 276, 256, 7, 70, "ExampleText",
 CellID->143789359],
Cell[CellGroupData[{
Cell[7774, 287, 380, 13, 70, "Input",
 CellID->10528200],
Cell[8157, 302, 158, 5, 36, "Output",
 CellID->188605246]
}, Open  ]],
Cell[CellGroupData[{
Cell[8352, 312, 415, 14, 70, "Input",
 CellID->32996918],
Cell[8770, 328, 157, 5, 36, "Output",
 CellID->43192689]
}, Open  ]],
Cell[8942, 336, 249, 7, 70, "ExampleText",
 CellID->454163553],
Cell[CellGroupData[{
Cell[9216, 347, 417, 14, 70, "Input",
 CellID->676513535],
Cell[9636, 363, 156, 5, 36, "Output",
 CellID->2945263]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9853, 375, 311, 9, 70, "SeeAlsoSection",
 CellID->13521],
Cell[10167, 386, 745, 26, 70, "SeeAlso",
 CellID->29017]
}, Open  ]],
Cell[CellGroupData[{
Cell[10949, 417, 314, 9, 70, "TutorialsSection",
 CellID->14957],
Cell[11266, 428, 191, 5, 70, "Tutorials",
 CellID->6051]
}, Open  ]],
Cell[11472, 436, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

