(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29594,       1089]
NotebookOptionsPosition[     24245,        905]
NotebookOutlinePosition[     25711,        945]
CellTagsIndexPosition[     25626,        940]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MultinormalDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultinormalDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"MultinormalDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WishartDistribution", "ObjectName",
 CellID->374],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"WishartDistribution", "[", 
       RowBox[{
        StyleBox["\[CapitalSigma]", "TR"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a Wishart distribution with scale matrix ",
     Cell[BoxData[
      StyleBox["\[CapitalSigma]", "TR"]], "InlineFormula"],
     " and degrees of freedom parameter ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1806]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for a symmetric positive definite matrix ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a Wishart distribution is proportional to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"\[LeftBracketingBar]", 
     StyleBox["x", "TI"], "\[RightBracketingBar]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["m", "TI"], "-", 
       StyleBox["p", "TI"], "-", "1"}], ")"}], "/", "2"}]], 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     RowBox[{
      ButtonBox["Tr",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Tr"], "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         StyleBox["\[CapitalSigma]", "TR"], 
         RowBox[{"-", "1"}]], ".", 
        StyleBox["x", "TI"]}], "/", "2"}], "]"}]}]]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->71158559],

Cell[TextData[{
 "The scale matrix ",
 Cell[BoxData[
  StyleBox["\[CapitalSigma]", "TR"]], "InlineFormula"],
 " can be any symmetric positive definite matrix. The parameter ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " can be any number such that ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], ">", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["\[CapitalSigma]", "TR"], "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23406],

Cell[TextData[{
 "For integer ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", the Wishart distribution gives the distribution of covariance matrices of \
multinormal samples."
}], "Notes",
 CellID->11643],

Cell[TextData[{
 Cell[BoxData["WishartDistribution"], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1355]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->781811602],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->265545811],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->405030773],

Cell["The mean of a Wishart distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"WishartDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox[
         SubscriptBox["\[Sigma]", "11"], "2"], ",", 
        RowBox[{"\[Rho]", "*", 
         SubscriptBox["\[Sigma]", "11"], "*", 
         SubscriptBox["\[Sigma]", "22"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Rho]", "*", 
         SubscriptBox["\[Sigma]", "11"], "*", 
         SubscriptBox["\[Sigma]", "22"]}], ",", 
        SuperscriptBox[
         SubscriptBox["\[Sigma]", "22"], "2"]}], "}"}]}], "}"}], ",", "10"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", " ", 
      SubsuperscriptBox["\[Sigma]", "11", "2"]}], ",", 
     RowBox[{"10", " ", "\[Rho]", " ", 
      SubscriptBox["\[Sigma]", "11"], " ", 
      SubscriptBox["\[Sigma]", "22"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", " ", "\[Rho]", " ", 
      SubscriptBox["\[Sigma]", "11"], " ", 
      SubscriptBox["\[Sigma]", "22"]}], ",", 
     RowBox[{"10", " ", 
      SubsuperscriptBox["\[Sigma]", "22", "2"]}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{279, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34879016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246746483],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455497681],

Cell["The variance:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->472395019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"WishartDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox[
         SubscriptBox["\[Sigma]", "11"], "2"], ",", 
        RowBox[{"\[Rho]", "*", 
         SubscriptBox["\[Sigma]", "11"], "*", 
         SubscriptBox["\[Sigma]", "22"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Rho]", "*", 
         SubscriptBox["\[Sigma]", "11"], "*", 
         SubscriptBox["\[Sigma]", "22"]}], ",", 
        SuperscriptBox[
         SubscriptBox["\[Sigma]", "22"], "2"]}], "}"}]}], "}"}], ",", "10"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"20", " ", 
      SubsuperscriptBox["\[Sigma]", "11", "4"]}], ",", 
     RowBox[{"10", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "11", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "22", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["\[Rho]", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "11", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "22", "2"]}]}], ")"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "11", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "22", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["\[Rho]", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "11", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "22", "2"]}]}], ")"}]}], ",", 
     RowBox[{"20", " ", 
      SubsuperscriptBox["\[Sigma]", "22", "4"]}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{419, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->123808708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->273870982],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"WishartDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "\[Rho]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Rho]", ",", "1"}], "}"}]}], "}"}], ",", "10"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "11"], ",", 
       SubscriptBox["x", "12"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "12"], ",", 
       SubscriptBox["x", "22"]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30324],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          SubscriptBox["x", "11"], 
          RowBox[{"1", "-", 
           SuperscriptBox["\[Rho]", "2"]}]]}], "+", 
        FractionBox[
         RowBox[{"\[Rho]", " ", 
          SubscriptBox["x", "12"]}], 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Rho]", "2"]}]]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"\[Rho]", " ", 
          SubscriptBox["x", "12"]}], 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Rho]", "2"]}]], "-", 
        FractionBox[
         SubscriptBox["x", "22"], 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Rho]", "2"]}]]}], ")"}]}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Rho]", "2"]}], ")"}], "2"]], "-", 
      FractionBox[
       SuperscriptBox["\[Rho]", "2"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Rho]", "2"]}], ")"}], "2"]]}], ")"}], "5"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SubsuperscriptBox["x", "12", "2"]}], "+", 
      RowBox[{
       SubscriptBox["x", "11"], " ", 
       SubscriptBox["x", "22"]}]}], ")"}], 
    RowBox[{"7", "/", "2"}]]}], 
  RowBox[{"161280", " ", "\[Pi]"}]]], "Output",
 ImageSize->{398, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->155657013]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5214],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->16141622],

Cell["\<\
Generate a set of pseudorandom matrices that follow a Wishart distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"WishartDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "3"}], ",", "1"}], "}"}]}], "}"}], ",", "5"}], 
    "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.833470598791877`", ",", 
       RowBox[{"-", "1.2219750680369155`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2219750680369155`"}], ",", "2.5217288176165407`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7532631650091415`", ",", "0.7918724528720352`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"0.7918724528720352`", ",", "2.7775413198443832`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8.64640480059351`", ",", "3.3147458568503025`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3147458568503025`", ",", "4.464795573922826`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.589172762778276`", ",", 
       RowBox[{"-", "0.0637311489878555`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0637311489878555`"}], ",", "7.991758118349015`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.4922805896707763`", ",", 
       RowBox[{"-", "2.6799142104743106`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.6799142104743106`"}], ",", "9.14474364950153`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{580, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88455880]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3561],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->131064707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"WishartDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "3"}], ",", "1"}], "}"}]}], "}"}], ",", "5"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SqrtBox[
       FractionBox["2", "5"]]}], ",", 
     FractionBox[
      RowBox[{"14", " ", 
       SqrtBox["2"]}], "25"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"14", " ", 
       SqrtBox["2"]}], "25"], ",", 
     RowBox[{"2", " ", 
      SqrtBox[
       FractionBox["2", "5"]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{252, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62073345]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2948],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->104263336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"WishartDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "3"}], ",", "1"}], "}"}]}], "}"}], ",", "5"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["27", "5"], ",", 
     FractionBox["443", "125"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["443", "125"], ",", 
     FractionBox["27", "5"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{167, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->562439515]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4959],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->473734178],

Cell[TextData[{
 Cell[BoxData["WishartDistribution"], "InlineFormula"],
 " is not defined when \[CapitalSigma] is not symmetric and positive \
definite:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"WishartDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "5"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95470147],

Cell[BoxData[
 RowBox[{
  RowBox[{"WishartDistribution", "::", "\<\"cmsym\"\>"}], ":", 
  " ", "\<\"The covariance matrix must be symmetric. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:MultivariateStatistics/ref/WishartDistribution\\\", \
ButtonNote -> \\\"MultivariateStatistics`.`WishartDistribution::cmsym\\\"]\\)\
\"\>"}]], "Message", "MSG",
 CellID->123861071],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"WishartDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "5"}], "]"}], 
  "]"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->274547232]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["WishartDistribution"], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "<", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["\[CapitalSigma]", "TR"], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->322608174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"WishartDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->209078008],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"WishartDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "1"}], "]"}], 
  "]"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26884104]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15418],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->85080577],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"WishartDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["s", "11"], ",", 
         SubscriptBox["s", "12"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["s", "12"], ",", 
         SubscriptBox["s", "22"]}], "}"}]}], "}"}], ",", "m"}], "]"}], "]"}], 
  "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["s", "11"], "\[Rule]", "1"}], ",", 
    RowBox[{
     SubscriptBox["s", "22"], "\[Rule]", "1"}], ",", 
    RowBox[{
     SubscriptBox["s", "12"], "\[Rule]", "0"}], ",", 
    RowBox[{"m", "\[Rule]", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2647],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[ImaginaryI]", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "\[ImaginaryI]"}], "}"}]}], "}"}]], "Output",
 ImageSize->{110, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4057649]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5331],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["MultinormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MultinormalDistribution"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->1410]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31061],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->30487]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WishartDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 51.2130232}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {
     "Wishart distribution", "multivariate analysis", 
      "sample covariance matrix"}, "index" -> True, "label" -> 
    "Multivariate Statistics Package Symbol", "language" -> "en", "paclet" -> 
    "MultivariateStatistics Package", "status" -> "None", "summary" -> 
    "WishartDistribution[\\[CapitalSigma], m] represents a Wishart \
distribution with scale matrix \\[CapitalSigma] and degrees of freedom \
parameter m.", "synonyms" -> {}, "title" -> "WishartDistribution", "type" -> 
    "Symbol", "uri" -> "MultivariateStatistics/ref/WishartDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5365, 190, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->781811602]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25483, 933}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1310, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1933, 61, 55, 1, 70, "ObjectName",
 CellID->374],
Cell[1991, 64, 680, 20, 70, "Usage",
 CellID->1806]
}, Open  ]],
Cell[CellGroupData[{
Cell[2708, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3186, 106, 879, 29, 70, "Notes",
 CellID->71158559],
Cell[4068, 137, 528, 18, 70, "Notes",
 CellID->23406],
Cell[4599, 157, 220, 7, 70, "Notes",
 CellID->11643],
Cell[4822, 166, 506, 19, 70, "Notes",
 CellID->1355]
}, Closed]],
Cell[CellGroupData[{
Cell[5365, 190, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->781811602],
Cell[CellGroupData[{
Cell[5750, 204, 148, 5, 70, "ExampleSection",
 CellID->265545811],
Cell[5901, 211, 147, 4, 70, "Input",
 CellID->405030773],
Cell[6051, 217, 210, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[6286, 226, 702, 22, 30, "Input",
 CellID->24173],
Cell[6991, 250, 685, 22, 39, "Output",
 CellID->34879016]
}, Open  ]],
Cell[7691, 275, 125, 3, 70, "ExampleDelimiter",
 CellID->246746483],
Cell[7819, 280, 147, 4, 70, "Input",
 CellID->455497681],
Cell[7969, 286, 193, 5, 70, "ExampleText",
 CellID->472395019],
Cell[CellGroupData[{
Cell[8187, 295, 705, 22, 70, "Input",
 CellID->8902],
Cell[8895, 319, 1198, 37, 39, "Output",
 CellID->123808708]
}, Open  ]],
Cell[10108, 359, 119, 3, 70, "ExampleDelimiter",
 CellID->675],
Cell[10230, 364, 147, 4, 70, "Input",
 CellID->273870982],
Cell[10380, 370, 204, 5, 70, "ExampleText",
 CellID->6303],
Cell[CellGroupData[{
Cell[10609, 379, 639, 23, 70, "Input",
 CellID->30324],
Cell[11251, 404, 1770, 60, 81, "Output",
 CellID->155657013]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13070, 470, 215, 7, 70, "ExampleSection",
 CellID->5214],
Cell[13288, 479, 146, 4, 70, "Input",
 CellID->16141622],
Cell[13437, 485, 259, 7, 70, "ExampleText",
 CellID->24449],
Cell[CellGroupData[{
Cell[13721, 496, 428, 15, 70, "Input",
 CellID->5765],
Cell[14152, 513, 1535, 49, 88, "Output",
 CellID->88455880]
}, Open  ]],
Cell[15702, 565, 120, 3, 70, "ExampleDelimiter",
 CellID->3561],
Cell[15825, 570, 147, 4, 70, "Input",
 CellID->131064707],
Cell[CellGroupData[{
Cell[15997, 578, 392, 14, 70, "Input",
 CellID->6096],
Cell[16392, 594, 577, 23, 60, "Output",
 CellID->62073345]
}, Open  ]],
Cell[16984, 620, 120, 3, 70, "ExampleDelimiter",
 CellID->2948],
Cell[17107, 625, 147, 4, 70, "Input",
 CellID->104263336],
Cell[CellGroupData[{
Cell[17279, 633, 392, 14, 70, "Input",
 CellID->6916],
Cell[17674, 649, 408, 15, 51, "Output",
 CellID->562439515]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18131, 670, 225, 7, 70, "ExampleSection",
 CellID->4959],
Cell[18359, 679, 147, 4, 70, "Input",
 CellID->473734178],
Cell[18509, 685, 324, 9, 70, "ExampleText",
 CellID->8964],
Cell[CellGroupData[{
Cell[18858, 698, 333, 12, 70, "Input",
 CellID->95470147],
Cell[19194, 712, 439, 8, 70, "Message",
 CellID->123861071],
Cell[19636, 722, 423, 15, 36, "Output",
 CellID->274547232]
}, Open  ]],
Cell[20074, 740, 506, 17, 70, "ExampleText",
 CellID->322608174],
Cell[CellGroupData[{
Cell[20605, 761, 334, 12, 70, "Input",
 CellID->209078008],
Cell[20942, 775, 422, 15, 36, "Output",
 CellID->26884104]
}, Open  ]],
Cell[21379, 793, 121, 3, 70, "ExampleDelimiter",
 CellID->15418],
Cell[21503, 798, 146, 4, 70, "Input",
 CellID->85080577],
Cell[21652, 804, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[21958, 816, 750, 26, 70, "Input",
 CellID->2647],
Cell[22711, 844, 324, 11, 36, "Output",
 CellID->4057649]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23096, 862, 310, 9, 70, "SeeAlsoSection",
 CellID->5331],
Cell[23409, 873, 248, 6, 70, "SeeAlso",
 CellID->1410]
}, Open  ]],
Cell[CellGroupData[{
Cell[23694, 884, 314, 9, 70, "TutorialsSection",
 CellID->31061],
Cell[24011, 895, 192, 5, 70, "Tutorials",
 CellID->30487]
}, Open  ]],
Cell[24218, 903, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

