(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    177180,       5338]
NotebookOptionsPosition[    163392,       4851]
NotebookOutlinePosition[    165097,       4893]
CellTagsIndexPosition[    165054,       4890]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"CDF" :> Documentation`HelpLookup["paclet:ref/CDF"], 
         "CharacteristicFunction" :> 
         Documentation`HelpLookup["paclet:ref/CharacteristicFunction"], 
         "Correlation" :> Documentation`HelpLookup["paclet:ref/Correlation"], 
         "Covariance" :> Documentation`HelpLookup["paclet:ref/Covariance"], 
         "Ellipsoid" :> 
         Documentation`HelpLookup["paclet:RegressionCommon/ref/Ellipsoid"], 
         "EllipsoidProbability" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/EllipsoidProbability"], 
         "EllipsoidQuantile" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/EllipsoidQuantile"], 
         "EllipsoidQuartiles" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/EllipsoidQuartiles"], 
         "ExpectedValue" :> 
         Documentation`HelpLookup["paclet:ref/ExpectedValue"], 
         "GeneralizedVariance" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/GeneralizedVariance"], 
         "HotellingTSquareDistribution" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/HotellingTSquareDistribution"], 
         "KendallRankCorrelation" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/KendallRankCorrelation"], 
         "Kurtosis" :> Documentation`HelpLookup["paclet:ref/Kurtosis"], 
         "Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], 
         "MultinomialDistribution" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/MultinomialDistribution"], 
         "MultinormalDistribution" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/MultinormalDistribution"], 
         "MultiPoissonDistribution" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/MultiPoissonDistribution"], 
         "MultivariateKurtosis" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/MultivariateKurtosis"], 
         "MultivariateMeanDeviation" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/MultivariateMeanDeviation"], 
         "MultivariateMedianDeviation" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/MultivariateMedianDeviation"], 
         "MultivariateSkewness" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/MultivariateSkewness"], 
         "MultivariateTDistribution" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/MultivariateTDistribution"], 
         "MultivariateTrimmedMean" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/MultivariateTrimmedMean"], 
         "NegativeMultinomialDistribution" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/NegativeMultinomialDistribution"]\
, "PDF" :> Documentation`HelpLookup["paclet:ref/PDF"], "Polytope" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/Polytope"], "PolytopeQuantile" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/PolytopeQuantile"], 
         "PolytopeQuartiles" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/PolytopeQuartiles"], 
         "PrincipalComponents" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/PrincipalComponents"], 
         "QuadraticFormDistribution" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/QuadraticFormDistribution"], 
         "Quantile" :> Documentation`HelpLookup["paclet:ref/Quantile"], 
         "RandomInteger" :> 
         Documentation`HelpLookup["paclet:ref/RandomInteger"], "RandomReal" :> 
         Documentation`HelpLookup["paclet:ref/RandomReal"], "SimplexMedian" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/SimplexMedian"], "Skewness" :> 
         Documentation`HelpLookup["paclet:ref/Skewness"], "SpatialMedian" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/SpatialMedian"], 
         "SpearmanRankCorrelation" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/SpearmanRankCorrelation"], 
         "StandardDeviation" :> 
         Documentation`HelpLookup["paclet:ref/StandardDeviation"], 
         "TotalVariation" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/TotalVariation"], "Variance" :> 
         Documentation`HelpLookup["paclet:ref/Variance"], 
         "WishartDistribution" :> 
         Documentation`HelpLookup[
          "paclet:MultivariateStatistics/ref/WishartDistribution"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"CDF\"\>", 
      2->"\<\"CharacteristicFunction\"\>", 3->"\<\"Correlation\"\>", 
      4->"\<\"Covariance\"\>", 5->"\<\"Ellipsoid\"\>", 
      6->"\<\"EllipsoidProbability\"\>", 7->"\<\"EllipsoidQuantile\"\>", 
      8->"\<\"EllipsoidQuartiles\"\>", 9->"\<\"ExpectedValue\"\>", 
      10->"\<\"GeneralizedVariance\"\>", 
      11->"\<\"HotellingTSquareDistribution\"\>", 
      12->"\<\"KendallRankCorrelation\"\>", 13->"\<\"Kurtosis\"\>", 
      14->"\<\"Mean\"\>", 15->"\<\"MultinomialDistribution\"\>", 
      16->"\<\"MultinormalDistribution\"\>", 
      17->"\<\"MultiPoissonDistribution\"\>", 
      18->"\<\"MultivariateKurtosis\"\>", 
      19->"\<\"MultivariateMeanDeviation\"\>", 
      20->"\<\"MultivariateMedianDeviation\"\>", 
      21->"\<\"MultivariateSkewness\"\>", 
      22->"\<\"MultivariateTDistribution\"\>", 
      23->"\<\"MultivariateTrimmedMean\"\>", 
      24->"\<\"NegativeMultinomialDistribution\"\>", 25->"\<\"PDF\"\>", 
      26->"\<\"Polytope\"\>", 27->"\<\"PolytopeQuantile\"\>", 
      28->"\<\"PolytopeQuartiles\"\>", 29->"\<\"PrincipalComponents\"\>", 
      30->"\<\"QuadraticFormDistribution\"\>", 31->"\<\"Quantile\"\>", 
      32->"\<\"RandomInteger\"\>", 33->"\<\"RandomReal\"\>", 
      34->"\<\"SimplexMedian\"\>", 35->"\<\"Skewness\"\>", 
      36->"\<\"SpatialMedian\"\>", 37->"\<\"SpearmanRankCorrelation\"\>", 
      38->"\<\"StandardDeviation\"\>", 39->"\<\"TotalVariation\"\>", 
      40->"\<\"Variance\"\>", 
      41->"\<\"WishartDistribution\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Multivariate Statistics Package", "Title",
 CellID->29538],

Cell[TextData[{
 "This package contains descriptive statistics for multivariate data, \
distributions derived from the multivariate normal distribution and \
multivariate discrete distributions. Distributions are represented in the \
symbolic form ",
 StyleBox["name", "TI"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param", "TI"], "1"], TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param", "TI"], "2"], TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " \[Ellipsis] ",
 StyleBox["]", "MR"],
 "."
}], "Text",
 CellID->19239],

Cell[CellGroupData[{

Cell["Multivariate Descriptive Statistics", "Section",
 CellID->668135853],

Cell["This loads the package. ", "MathCaption",
 CellID->12105],

Cell[BoxData[
 RowBox[{"<<", "MultivariateStatistics`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19556],

Cell["\<\
Here is a bivariate data set (courtesy of United States Forest Products \
Laboratory). \
\>", "MathCaption",
 CellID->27000],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1232", ",", "4175"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1115", ",", "6652"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2205", ",", "7612"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1897", ",", "10914"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1932", ",", "10850"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1612", ",", "7627"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1598", ",", "6954"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1804", ",", "8365"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1752", ",", "9469"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2067", ",", "6410"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2365", ",", "10327"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1646", ",", "7320"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1579", ",", "8196"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1880", ",", "9709"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1773", ",", "10370"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1712", ",", "7749"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1932", ",", "6818"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1820", ",", "9307"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1900", ",", "6457"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2426", ",", "10102"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1558", ",", "7414"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1470", ",", "7556"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1858", ",", "7833"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1587", ",", "8309"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2208", ",", "9559"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1487", ",", "6255"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2206", ",", "10723"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2332", ",", "5430"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2540", ",", "12090"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2322", ",", "10072"}], "}"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9665],

Cell["\<\
The variables represent stiffness and bending strength for a sample of a \
particular grade of lumber.\
\>", "MathCaption",
 CellID->247070732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"stiffness", ",", "strength"}], "}"}], "=", 
  RowBox[{"Transpose", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23647167],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1232.`", ",", "1115.`", ",", "2205.`", ",", "1897.`", ",", "1932.`", ",",
      "1612.`", ",", "1598.`", ",", "1804.`", ",", "1752.`", ",", "2067.`", 
     ",", "2365.`", ",", "1646.`", ",", "1579.`", ",", "1880.`", ",", 
     "1773.`", ",", "1712.`", ",", "1932.`", ",", "1820.`", ",", "1900.`", 
     ",", "2426.`", ",", "1558.`", ",", "1470.`", ",", "1858.`", ",", 
     "1587.`", ",", "2208.`", ",", "1487.`", ",", "2206.`", ",", "2332.`", 
     ",", "2540.`", ",", "2322.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4175.`", ",", "6652.`", ",", "7612.`", ",", "10914.`", ",", "10850.`", 
     ",", "7627.`", ",", "6954.`", ",", "8365.`", ",", "9469.`", ",", 
     "6410.`", ",", "10327.`", ",", "7320.`", ",", "8196.`", ",", "9709.`", 
     ",", "10370.`", ",", "7749.`", ",", "6818.`", ",", "9307.`", ",", 
     "6457.`", ",", "10102.`", ",", "7414.`", ",", "7556.`", ",", "7833.`", 
     ",", "8309.`", ",", "9559.`", ",", "6255.`", ",", "10723.`", ",", 
     "5430.`", ",", "12090.`", ",", "10072.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{511, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->100142765]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Location", "Subsection",
 CellID->30082],

Cell["\<\
The coordinate\[Hyphen]wise mean is identical to the mean obtained when \
considering all variates simultaneously. Unfortunately, the coordinate\
\[Hyphen]wise definition is not the best multivariate generalization for \
other location measures such as the median, mode, and quantiles. This section \
describes various location measures requiring special definitions in the \
multivariate case. \
\>", "Text",
 CellID->23142],

Cell["\<\
It is well known that the mean has the disadvantage of being sensitive to \
outliers and other deviations from multinormality. The median is resistant to \
such deviations. Multivariate definitions of the median often make use of \
geometric ideas, such as minimizing the sum of simplex volumes or peeling \
convex hulls.\
\>", "Text",
 CellID->18466],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SpatialMedian",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/SpatialMedian"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "multivariate median equal to the ",
     StyleBox["p", "TI"],
     "\[Hyphen]vector minimizing the sum of Euclidean distances between the \
vector and rows from the data matrix"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SimplexMedian",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/SimplexMedian"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "multivariate median equal to the ",
     StyleBox["p", "TI"],
     "\[Hyphen]vector minimizing the sum of volumes of ",
     StyleBox["p", "TI"],
     "\[Hyphen]dimensional simplices the vector forms with all possible \
combinations of ",
     StyleBox["p", "TI"],
     " rows from the data matrix"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MultivariateTrimmedMean",
      BaseStyle->"Link",
      ButtonData->
       "paclet:MultivariateStatistics/ref/MultivariateTrimmedMean"], "[", 
     StyleBox["data", "TI"], ",", " ", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "mean of remaining data when a fraction ",
     StyleBox["f", "TI"],
     " is removed, outermost points first"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->12195],

Cell["Multivariate location statistics. ", "Caption",
 CellID->5423],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["L", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " median or ",
 Cell[BoxData[
  ButtonBox["SpatialMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/SpatialMedian"]], 
  "InlineFormula"],
 " gives the ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]dimensional point that minimizes the sum of the Euclidean \
distances between the point and the data. This estimator is orthogonally \
equivariant, but not affinely equivariant. "
}], "Text",
 CellID->17873],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["SimplexMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/SimplexMedian"]], 
  "InlineFormula"],
 " gives the ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]dimensional point that, when joined with all possible combinations \
of ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " points to form ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]dimensional simplices, yields the smallest total simplex volume. \
In the case of the lumber data, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "=", "30"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p", "TI"], "=", "2"}], TraditionalForm]], "InlineFormula"],
 ", so there are ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["n", "TI"], "!"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         StyleBox["n", "TI"], "-", 
         StyleBox["p", "TI"]}], ")"}], "!", 
       StyleBox["p", "TI"], "!"}], ")"}]}], "=", "435"}], TraditionalForm]], 
  "InlineFormula"],
 " simplices to consider. ",
 Cell[BoxData[
  ButtonBox["SimplexMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/SimplexMedian"]], 
  "InlineFormula"],
 " is an affinely equivariant estimator. "
}], "Text",
 CellID->12238],

Cell["\<\
This vector minimizes the sum of Euclidean distances between itself and the \
data. \
\>", "MathCaption",
 CellID->24349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpatialMedian", "[", "data", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9869],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1757.5345957337934`", ",", "8062.875680720717`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->144618665]
}, Open  ]],

Cell["\<\
This vector minimizes the sum of the volumes of all possible simplices having \
the vector as a vertex. \
\>", "MathCaption",
 CellID->20549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SimplexMedian", "[", "data", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->19428],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1804.0000000000032`", ",", "8364.999999999989`"}], "}"}]], "Output",\

 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->423061781]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    StyleBox[
     RowBox[{
      ButtonBox["Ellipsoid",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"], "[", "{", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["p", "TR"]], "}", ",", "{", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["1", "TR"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["p", "TR"]], "}", ",", "{", 
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["1", "TR"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["p", "TR"]], "}", "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "a ",
     StyleBox["p", "TI"],
     "\[Hyphen]dimensional ellipsoid, centered at ",
     "{",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "1"]], "InlineFormula"],
     ", \[Ellipsis] , ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["p", "TI"]]], "InlineFormula"],
     "}",
     ", with radii ",
     "{",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], "1"]], "InlineFormula"],
     ",",
     " ",
     "\[Ellipsis]",
     " ",
     ",",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["p", "TI"]]], "InlineFormula"],
     "}",
     ", where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is the radius in direction ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["Polytope",
       BaseStyle->"Link",
       ButtonData->"paclet:MultivariateStatistics/ref/Polytope"], "[", "{", 
      "{", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox[
        RowBox[{"1", "1"}], "TR"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox[
        RowBox[{"1", "p"}], "TR"]], "}", ",", "\[Ellipsis]", ",", "{", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox[
        RowBox[{"m", "1"}], "TR"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox[
        RowBox[{"m", "p"}], "TR"]], "}", "}", ",", 
      StyleBox["conn", "TI"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "a ",
     StyleBox["p", "TI"],
     "\[Hyphen]dimensional polytope with ",
     StyleBox["m", "TI"],
     " vertices, where the vertex connectivity is specified by ",
     StyleBox["conn", "TI"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 AutoMultiplicationSymbol->False,
 CellID->4048],

Cell["Geometric primitives. ", "Caption",
 CellID->18839],

Cell[TextData[{
 "In the case of a univariate sample, the ",
 Cell[BoxData[
  FormBox[
   StyleBox["q", "TI"], TraditionalForm]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
 " quantile is the number below which a fraction ",
 Cell[BoxData[
  FormBox[
   StyleBox["q", "TI"], TraditionalForm]], "InlineFormula"],
 " of the sample lies. In the case of a multivariate sample and an associated \
estimate of the underlying population location, we can take the ",
 Cell[BoxData[
  FormBox[
   StyleBox["q", "TI"], TraditionalForm]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
 " quantile to be that locus, centered on the location estimate, within which \
a fraction ",
 Cell[BoxData[
  FormBox[
   StyleBox["q", "TI"], TraditionalForm]], "InlineFormula"],
 " of the sample lies. This leads to different definitions of a multivariate \
quantile, depending on how the location estimate and the quantile locus are \
defined. For example, the locus can be an ellipsoid centered on the mean, or \
a convex polytope centered on the median. "
}], "Text",
 CellID->6989],

Cell[TextData[{
 "This package defines geometric primitives for representing multidimensional \
ellipsoids and polytopes. The ",
 Cell[BoxData[
  ButtonBox["Ellipsoid",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Polytope",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/Polytope"]], 
  "InlineFormula"],
 " primitives can be plotted using ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", "2"}], TraditionalForm]], "InlineFormula"],
 ". The results of the location statistics ",
 Cell[BoxData[
  ButtonBox["EllipsoidQuantile",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuantile"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EllipsoidQuartiles",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuartiles"]], 
  "InlineFormula"],
 " are expressed in terms of ",
 Cell[BoxData[
  ButtonBox["Ellipsoid",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"]], "InlineFormula"],
 ". The results of the location statistics ",
 Cell[BoxData[
  ButtonBox["PolytopeQuantile",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuantile"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolytopeQuartiles",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuartiles"]], 
  "InlineFormula"],
 " are expressed in terms of ",
 Cell[BoxData[
  ButtonBox["Polytope",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/Polytope"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->700],

Cell[TextData[{
 "The third argument of ",
 Cell[BoxData[
  ButtonBox["Ellipsoid",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"]], "InlineFormula"],
 ", specifying the directions of the semi\[Hyphen]axes, is automatically \
dropped when the semi\[Hyphen]axes lie along the coordinate axes. The radii \
are reordered if necessary. "
}], "Text",
 CellID->250132332],

Cell["\<\
Here is a 3\[Hyphen]dimensional ellipsoid with semi-axes on the coordinate \
axes.\
\>", "MathCaption",
 CellID->27054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ellipsoid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1096],

Cell[BoxData[
 RowBox[{"Ellipsoid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "6"}], "}"}]}], "]"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->360272783]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EllipsoidQuantile",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuantile"], "[",
      
     StyleBox["data", "TI"], ",", 
     StyleBox["q", "TI"], "]"}], Cell[TextData[{
     StyleBox["p", "TI"],
     "-",
     "1",
     " dimensional locus of the ",
     StyleBox["q", "TI"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " quantile of the ",
     StyleBox["p", "TI"],
     "\[Hyphen]variate data, where the data have been ordered using \
ellipsoids centered on the mean"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipsoidQuartiles",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuartiles"], 
     "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "list of the ",
     StyleBox["p", "TI"],
     "-",
     "1",
     " dimensional loci of the quartiles of the ",
     StyleBox["p", "TI"],
     "\[Hyphen]variate data, where the data have been ordered using \
ellipsoids centered on the mean"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolytopeQuantile",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuantile"], "[", 
     
     StyleBox["data", "TI"], ",", 
     StyleBox["q", "TI"], "]"}], Cell[TextData[{
     StyleBox["p", "TI"],
     "-",
     "1",
     " dimensional locus of the ",
     StyleBox["q", "TI"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " quantile of the ",
     StyleBox["p", "TI"],
     "\[Hyphen]variate data, where the data have been ordered using convex \
hulls centered on the median"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolytopeQuartiles",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuartiles"], "[",
      
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "list of the ",
     StyleBox["p", "TI"],
     "-",
     "1",
     " dimensional loci of the quartiles of the ",
     StyleBox["p", "TI"],
     "\[Hyphen]variate data, where the data have been ordered using convex \
hulls centered on the median"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->14321],

Cell["More multivariate location statistics. ", "Caption",
 CellID->31475],

Cell["\<\
This gives the minima and maxima for the stiffness and strength variables. \
\>", "MathCaption",
 CellID->27921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"minx", ",", "maxx"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"miny", ",", "maxy"}], "}"}]}], "}"}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Min", "[", "#", "]"}], ",", 
       RowBox[{"Max", "[", "#", "]"}]}], "}"}], "&"}], ")"}], "/@", 
   RowBox[{"{", 
    RowBox[{"stiffness", ",", "strength"}], "}"}]}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->29367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1115.`", ",", "2540.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4175.`", ",", "12090.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{229, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->49303169]
}, Open  ]],

Cell["\<\
Here is a plot of the quartile contours assuming elliptical symmetry. \
\>", "MathCaption",
 CellID->31545],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"EllipsoidQuartiles", "[", "data", "]"}]}], ";"}], "\n", 
 RowBox[{"Graphics", "[", 
  RowBox[{"q", ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"minx", ",", "maxx"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"miny", ",", "maxy"}], "}"}]}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->17716],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 347},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->9951103]
}, Open  ]],

Cell["\<\
Here is a plot of the quartile contours found by linear interpolation between \
convex layers of the data. \
\>", "MathCaption",
 CellID->7096],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"PolytopeQuartiles", "[", "data", "]"}]}], ";"}], "\n", 
 RowBox[{"Graphics", "[", 
  RowBox[{"q", ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"minx", ",", "maxx"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"miny", ",", "maxy"}], "}"}]}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[10]:=",
 CellID->26135],

Cell[BoxData[
 GraphicsBox[{
   LineBox[{{2170.0548227982877`, 9415.41544946872}, {1832.3632569152553`, 
    9221.868919439805}, {1817.887136313621, 9209.366043143376}, {
    1623.615133541331, 7650.014372407172}, {1634.94054054054, 
    7522.354531001595}, {1655.819881804338, 7364.752534736743}, {
    1920.053497266357, 6916.884203906671}, {1987.3973041521285`, 
    7543.150038699216}, {2170.0548227982877`, 9415.41544946872}}], 
   LineBox[{{2305.3137631770173`, 10006.292701857237`}, {1877.5893335831436`, 
    9662.055443461217}, {1825.7136909055143`, 9571.025670447838}, {
    1753.9380204632655`, 9395.749396049452}, {1598.419465339472, 
    8290.74375851112}, {1590.4984013135154`, 8184.429395224548}, {
    1567.380799211709, 7538.590951597921}, {1565.638252647781, 
    7432.604601092095}, {1595.976146264819, 7092.0243179545805`}, {
    1605.9558659360698`, 6996.316976573751}, {1895.7541258981873`, 
    6516.598527269615}, {1936.513119020822, 6780.6437802376095`}, {
    2292.815712592511, 9879.942656450063}, {2305.3137631770173`, 
    10006.292701857237`}}], 
   LineBox[{{2395.1155438482356`, 9998.851755951118}, {2366.065093726919, 
    10245.520146089233`}, {2352.387507195171, 10275.450741203274`}, {
    2181.8252143248565`, 10563.220990497563`}, {1927.4813968668404`, 
    10633.63772845953}, {1921.4304173200626`, 10634.525782475117`}, {
    1750.23447122993, 9535.731002665345}, {1579.4419674172382`, 
    8321.08298846836}, {1565.3032110594643`, 8209.78279703436}, {
    1487.8510108130936`, 7579.684069325671}, {1490.1665371906543`, 
    7248.7770655858085`}, {1506.7344908769865`, 6468.561904061215}, {
    1509.5792218789088`, 6383.155013993982}, {1905.2047363113352`, 
    6383.942106255616}, {2047.5855339361297`, 6520.7352314670825`}, {
    2176.112097007663, 7637.861772944792}, {2395.1155438482356`, 
    9998.851755951118}}]},
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{{1115., 2540.}, {4175., 12090.}}]], "Output",
 ImageSize->{364, 347},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->794083281]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Dispersion", "Subsection",
 CellID->27754],

Cell[TextData[{
 "While measures of location of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]variate data have ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 " components, measures of dispersion of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]variate data may be matrix\[Hyphen], vector\[Hyphen], or scalar\
\[Hyphen]valued. This section describes scalar\[Hyphen]valued multivariate \
dispersion measures. "
}], "Text",
 CellID->8670],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GeneralizedVariance",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/GeneralizedVariance"], 
     "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "determinant of the covariance matrix", "TableText"]},
   {
    RowBox[{
     ButtonBox["TotalVariation",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/TotalVariation"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "trace of the covariance matrix", "TableText"]},
   {
    RowBox[{
     ButtonBox["MultivariateMeanDeviation",
      BaseStyle->"Link",
      ButtonData->
       "paclet:MultivariateStatistics/ref/MultivariateMeanDeviation"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "scalar mean of the Euclidean distances between the ",
     StyleBox["p", "TI"],
     "\[Hyphen]variate mean and the ",
     StyleBox["p", "TI"],
     "\[Hyphen]variate data"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MultivariateMedianDeviation",
      BaseStyle->"Link",
      ButtonData->
       "paclet:MultivariateStatistics/ref/MultivariateMedianDeviation"], "[", 
     
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "scalar median of the Euclidean distances between the ",
     StyleBox["p", "TI"],
     "\[Hyphen]variate median and the ",
     StyleBox["p", "TI"],
     "\[Hyphen]variate data"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->25446],

Cell["\<\
Scalar\[Hyphen]valued multivariate dispersion statistics. \
\>", "Caption",
 CellID->4728],

Cell[TextData[{
 "These scalar\[Hyphen]valued measures of dispersion consider all ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " variates simultaneously. ",
 Cell[BoxData[
  ButtonBox["GeneralizedVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/GeneralizedVariance"]], 
  "InlineFormula"],
 " gives the product of the variances of the principal components of the \
data, while ",
 Cell[BoxData[
  ButtonBox["TotalVariation",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/TotalVariation"]], 
  "InlineFormula"],
 " gives the sum of the variances of the principal components of the data. ",
 Cell[BoxData[
  ButtonBox["MultivariateMedianDeviation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/MultivariateMedianDeviation"]], 
  "InlineFormula"],
 " accepts the option ",
 Cell[BoxData[
  ButtonBox["MedianMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MedianMethod"]], 
  "InlineFormula"],
 " for selecting the coordinate\[Hyphen]wise median ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 ", the total distance minimizing median ",
 Cell[BoxData[
  ButtonBox["SpatialMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/SpatialMedian"]], 
  "InlineFormula"],
 ", the total simplex volume minimizing median ",
 Cell[BoxData[
  ButtonBox["SimplexMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/SimplexMedian"]], 
  "InlineFormula"],
 ", or the peeled convex hull median ",
 Cell[BoxData[
  ButtonBox["ConvexHullMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->24864],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GeneralizedVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/GeneralizedVariance"]], 
  "InlineFormula"],
 " gives the product of the principal component variances. "
}], "MathCaption",
 CellID->3521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeneralizedVariance", "[", "data", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->31109],

Cell[BoxData["3.017265687364325`*^11"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->38177355]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TotalVariation",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/TotalVariation"]], 
  "InlineFormula"],
 " gives the sum of the principal component variances. "
}], "MathCaption",
 CellID->31603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TotalVariation", "[", "data", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->2764],

Cell[BoxData["3.6103878264367813`*^6"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->49212213]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Association", "Subsection",
 CellID->18752],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpearmanRankCorrelation",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/SpearmanRankCorrelation"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["KendallRankCorrelation",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/KendallRankCorrelation"]], 
  "InlineFormula"],
 " are useful when dealing with imprecise numerical or ordinal data. A value \
close to zero indicates there is not a significant monotonic relationship \
(linear or nonlinear) between the variables. "
}], "Text",
 CellID->4100],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SpearmanRankCorrelation",
      BaseStyle->"Link",
      ButtonData->
       "paclet:MultivariateStatistics/ref/SpearmanRankCorrelation"], "[", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], "]"}], Cell[TextData[{
     "Spearman\[CloseCurlyQuote]s rank correlation coefficient between ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox[
        StyleBox["list", "TI"], 
        StyleBox["1", "TR"]], "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox[
        StyleBox["list", "TI"], 
        StyleBox["2", "TR"]], "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["KendallRankCorrelation",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/KendallRankCorrelation"],
      "[", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], "]"}], Cell[TextData[{
     "Kendall\[CloseCurlyQuote]s rank correlation coefficient between ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox[
        StyleBox["list", "TI"], 
        StyleBox["1", "TR"]], "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox[
        StyleBox["list", "TI"], 
        StyleBox["2", "TR"]], "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->26208],

Cell["Association statistics. ", "Caption",
 CellID->9865],

Cell[TextData[{
 "Rank correlations indicate positive correlation between ",
 Cell[BoxData[
  StyleBox["stiffness", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["strength", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SpearmanRankCorrelation", "[", 
     RowBox[{"stiffness", ",", "strength"}], "]"}], ",", 
    RowBox[{"KendallRankCorrelation", "[", 
     RowBox[{"stiffness", ",", "strength"}], "]"}]}], "}"}], "//", 
  "N"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->9592],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.4823673408422493`", ",", "0.37284259438895667`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->91552971]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Shape", "Subsection",
 CellID->25972],

Cell[TextData[{
 "Multivariate shape statistics consider all variables of the data \
simultaneously. The functions ",
 Cell[BoxData[
  ButtonBox["MultivariateSkewness",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MultivariateSkewness"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MultivariateKurtosis",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MultivariateKurtosis"]], 
  "InlineFormula"],
 " can be used to test for elliptical symmetry or multinormal shape, \
respectively."
}], "Text",
 CellID->3922],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MultivariateSkewness",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/MultivariateSkewness"], 
     "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "multivariate coefficient of skewness, ",
     Cell[BoxData[
      RowBox[{
       FractionBox["1", 
        SuperscriptBox[
         StyleBox["n", "TI"], "2"]], 
       UnderscriptBox["\[Sum]", 
        StyleBox["i", "TI"],
        LimitsPositioning->True], 
       UnderscriptBox["\[Sum]", 
        StyleBox["j", "TI"],
        LimitsPositioning->True], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["i", "TI"]], "-", 
             OverscriptBox[
              StyleBox["x", "TI"], "_"]}], ")"}], "\[Prime]"], 
          SuperscriptBox[Cell[BoxData["\[CapitalSigma]"], "InlineFormula"], 
           RowBox[{"-", "1"}]], 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["j", "TI"]], "-", 
            OverscriptBox[
             StyleBox["x", "TI"], "_"]}], ")"}]}], ")"}], "3"]}]], 
      "InlineFormula"],
     ", where ",
     Cell[BoxData["\[CapitalSigma]"], "InlineFormula"],
     " is the maximum likelihood estimate of the population covariance"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MultivariateKurtosis",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/MultivariateKurtosis"], 
     "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "multivariate kurtosis coefficient, ",
     Cell[BoxData[
      RowBox[{
       FractionBox["1", 
        StyleBox["n", "TI"]], 
       UnderscriptBox["\[Sum]", 
        StyleBox["i", "TI"],
        LimitsPositioning->True], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["i", "TI"]], "-", 
             OverscriptBox[
              StyleBox["x", "TI"], "_"]}], ")"}], "\[Prime]"], 
          SuperscriptBox[Cell[BoxData["\[CapitalSigma]"], "InlineFormula"], 
           RowBox[{"-", "1"}]], 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["i", "TI"]], "-", 
            OverscriptBox[
             StyleBox["x", "TI"], "_"]}], ")"}]}], ")"}], "2"]}]], 
      "InlineFormula"],
     ", where ",
     Cell[BoxData["\[CapitalSigma]"], "InlineFormula"],
     " is the maximum likelihood estimate of the population covariance"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->21045],

Cell["Multivariate shape statistics. ", "Caption",
 CellID->29064],

Cell[TextData[{
 "This gives a single value for skewness for ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->22789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"multiskewness", "=", 
  RowBox[{"MultivariateSkewness", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[15]:=",
 CellID->31613],

Cell[BoxData["1.0262767498632666`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->59631828]
}, Open  ]],

Cell[TextData[{
 "A value of ",
 Cell[BoxData[
  ButtonBox["MultivariateSkewness",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MultivariateSkewness"]], 
  "InlineFormula"],
 " near 0 indicates approximate elliptical symmetry. As the sample size ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " goes to ",
 Cell[BoxData["\[Infinity]"], "InlineFormula"],
 ", the distribution of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Beta]", "1"], 
    StyleBox["n", "TI"], "/", "6"}], TraditionalForm]], "InlineFormula"],
 " (where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "1"], TraditionalForm]], "InlineFormula"],
 " is multivariate skewness) approaches ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Chi]", 
    StyleBox["\[Nu]", "TI"], "2"], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["\[Nu]", "TI"], "=", 
    RowBox[{
     FractionBox["1", "6"], 
     RowBox[{
      StyleBox["p", "TI"], "(", 
      RowBox[{
       StyleBox["p", "TI"], "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["p", "TI"], "+", "2"}], ")"}]}]}], TraditionalForm]], 
  "InlineFormula"],
 "."
}], "Text",
 CellID->96075275],

Cell["\<\
 At a 5% level, the hypothesis of elliptical symmetry is not rejected. \
\>", "MathCaption",
 CellID->4623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"multiskewness", " ", 
   RowBox[{
    RowBox[{"Length", "[", "data", "]"}], "/", "6"}]}], ">", 
  RowBox[{"Quantile", "[", 
   RowBox[{
    RowBox[{"ChiSquareDistribution", "[", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"2", "+", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"2", "+", "2"}], ")"}]}], "]"}], ",", ".95"}], 
   "]"}]}]], "Input",
 CellLabel->"In[16]:=",
 CellID->15901],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->475960883]
}, Open  ]],

Cell[TextData[{
 "A value of ",
 Cell[BoxData[
  ButtonBox["MultivariateKurtosis",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MultivariateKurtosis"]], 
  "InlineFormula"],
 " near ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], 
   RowBox[{"(", 
    RowBox[{
     StyleBox["p", "TI"], "+", "2"}], ")"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is the number of variables, indicates approximate multinormality. As the \
sample size ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " goes to ",
 Cell[BoxData["\[Infinity]"], "InlineFormula"],
 ", the distribution of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Gamma]", "2"], "-", 
      RowBox[{
       StyleBox["p", "TI"], "(", 
       RowBox[{
        StyleBox["p", "TI"], "+", "2"}], ")"}]}], ")"}], "/", 
    SqrtBox[
     RowBox[{"8", 
      StyleBox["p", "TI"], 
      RowBox[{"(", 
       RowBox[{
        StyleBox["p", "TI"], "+", "2"}], ")"}], "/", 
      StyleBox["n", "TI"]}]]}], TraditionalForm]], "InlineFormula"],
 " (where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "2"], TraditionalForm]], "InlineFormula"],
 " is multivariate kurtosis) approaches a standard normal."
}], "Text",
 CellID->149228161],

Cell["\<\
This gives a single value for kurtosis for the two variables. \
\>", "MathCaption",
 CellID->24570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"multikurtosis", "=", 
  RowBox[{"MultivariateKurtosis", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[17]:=",
 CellID->1157],

Cell[BoxData["8.017201247905584`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->132574427]
}, Open  ]],

Cell["\<\
 At a 5% level of significance, the hypothesis of multinormal shape is not \
rejected. \
\>", "MathCaption",
 CellID->22837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"multikurtosis", "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "2"}], ")"}]}]}], ")"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"8", " ", "2", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "2"}], ")"}], "/", 
       RowBox[{"Length", "[", "data", "]"}]}]}], "]"}]}], "]"}], ">", 
  RowBox[{"Quantile", "[", 
   RowBox[{
    RowBox[{"NormalDistribution", "[", 
     RowBox[{"0", ",", "1"}], "]"}], ",", ".975"}], "]"}]}]], "Input",
 CellLabel->"In[18]:=",
 CellID->11891],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->533165511]
}, Open  ]],

Cell["\<\
The bivariate shape statistics do not provide evidence that the lumber data \
deviate significantly from a bivariate normal distribution. \
\>", "Text",
 CellID->4390]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Data Transformation", "Subsection",
 CellID->98],

Cell[TextData[{
 "A principal component transformation decomposes data into uncorrelated \
variables that are linear combinations of the original variables. The new \
variables are given in order of decreasing variance and can be used to \
decrease high dimensional problems to lower dimensional problems. The ",
 Cell[BoxData[
  ButtonBox["PrincipalComponents",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/PrincipalComponents"]], 
  "InlineFormula"],
 " function gives the transformed data. "
}], "Text",
 CellID->27619],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PrincipalComponents",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/PrincipalComponents"], 
     "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "transforms elements of ",
     StyleBox["data", "TI"],
     " into principal components"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->27296],

Cell["Multivariate data transformations. ", "Caption",
 CellID->3764],

Cell["\<\
Changing the location of the data does not affect the covariance. \
\>", "MathCaption",
 CellID->18223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Covariance", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", "data", "]"}], "-", 
    RowBox[{"Mean", "[", "data", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->6607],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"124054.6724137931`", ",", "361620.4482758621`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"361620.4482758621`", ",", "3.4863331540229884`*^6"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{313, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->252904566]
}, Open  ]],

Cell["\<\
Standardizing the data coordinates yields correlated variables with unit \
variances. \
\>", "MathCaption",
 CellID->790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Covariance", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Transpose", "[", "data", "]"}], "-", 
      RowBox[{"Mean", "[", "data", "]"}]}], ")"}], "/", 
    RowBox[{"StandardDeviation", "[", "data", "]"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[20]:=",
 CellID->22599],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999998`", ",", "0.5498724666450516`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5498724666450516`", ",", "0.9999999999999999`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->81347043]
}, Open  ]],

Cell["\<\
The principal component transformation yields decorrelated variables ordered \
from largest variance to smallest. \
\>", "MathCaption",
 CellID->4257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Covariance", "[", 
  RowBox[{"PrincipalComponents", "[", "data", "]"}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->2216],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.5247864508808153`*^6", ",", 
     RowBox[{"-", "3.412173225961882`*^-11"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.412173225961882`*^-11"}], ",", "85601.37555596695`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{406, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->87687678]
}, Open  ]],

Cell[TextData[{
 "If you wish to approximate a multivariate data set by a univariate set, you \
can take the first column of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrincipalComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/PrincipalComponents"], "[",
    
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 " and still retain a significant portion of the information conveyed by the \
original multivariate set. For a data set with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], " ", ">", " ", "2"}]], "InlineFormula"],
 ", a scatter plot of the first two principal components can sometimes be \
more informative than scatter plots of all possible variable pairs. Also, \
some nonparametric procedures that are prohibitively time consuming for \
higher\[Hyphen]dimensional data, can be applied to the first two or three \
principal components in reasonable time. "
}], "Text",
 CellID->18037]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Distributions Related to the Multivariate Normal", "Section",
 CellID->20994],

Cell[TextData[{
 "The most commonly used probability distributions for multivariate data \
analysis are those derived from the multinormal (multivariate Gaussian) \
distribution. This package contains multinormal, multivariate Student ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", Wishart, Hotelling ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["T", "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", and quadratic form distributions. Multinormal and multivariate Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " are distributions for random vectors. Wishart is a distribution for random \
matrices. Hotelling ",
 Cell[BoxData[
  SuperscriptBox["T", "2"]], "InlineFormula"],
 " and quadratic form distributions are univariate distributions derived from \
the multivariate normal."
}], "Text",
 CellID->21113],

Cell[TextData[{
 "Distributions are represented in the symbolic form ",
 StyleBox["name", "TI"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param", "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param", "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 StyleBox[", \[Ellipsis] ]", "MR"],
 ". When there are many parameters, they may be organized into lists, as in \
the case of ",
 Cell[BoxData[
  ButtonBox["QuadraticFormDistribution",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/QuadraticFormDistribution"]], 
  "InlineFormula"],
 ". Functions such as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", which give properties of statistical distributions, take the symbolic \
representation of the distribution as an argument. "
}], "Text",
 CellID->2483],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MultinormalDistribution",
      BaseStyle->"Link",
      ButtonData->
       "paclet:MultivariateStatistics/ref/MultinormalDistribution"], "[", 
     StyleBox["\[Mu]", "TI"], ",", 
     StyleBox["\[CapitalSigma]", "TI"], "]"}], Cell[TextData[{
     "multinormal (multivariate Gaussian) distribution with mean vector ",
     StyleBox["\[Mu]", "TI"],
     " and covariance matrix ",
     StyleBox["\[CapitalSigma]", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MultivariateTDistribution",
      BaseStyle->"Link",
      ButtonData->
       "paclet:MultivariateStatistics/ref/MultivariateTDistribution"], "[", 
     StyleBox["R", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "multivariate Student ",
     StyleBox["t", "TI"],
     " distribution with correlation matrix ",
     StyleBox["R", "TI"],
     " and ",
     StyleBox["m", "TI"],
     " degrees of freedom "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["WishartDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/WishartDistribution"], 
     "[", 
     StyleBox["\[CapitalSigma]", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "Wishart distribution with scale matrix ",
     StyleBox["\[CapitalSigma]", "TI"],
     " and ",
     StyleBox["m", "TI"],
     " degrees of freedom "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HotellingTSquareDistribution",
      BaseStyle->"Link",
      ButtonData->
       "paclet:MultivariateStatistics/ref/HotellingTSquareDistribution"], "[",
      
     StyleBox["p", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "Hotelling ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["T", "TI"], "2"]], "InlineFormula"],
     " distribution with dimensionality parameter ",
     StyleBox["p", "TI"],
     " and ",
     StyleBox["m", "TI"],
     " degrees of freedom "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["QuadraticFormDistribution",
      BaseStyle->"Link",
      ButtonData->
       "paclet:MultivariateStatistics/ref/QuadraticFormDistribution"], "[", 
     "{", 
     StyleBox["A", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["c", "TI"], "}", ",", "{", 
     StyleBox["\[Mu]", "TI"], ",", 
     StyleBox["\[CapitalSigma]", "TI"], "}", "]"}], Cell[TextData[{
     "distribution of the quadratic form of a multinormal, where ",
     Cell[BoxData[
      FormBox[
       StyleBox["A", "TI"], TraditionalForm]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      FormBox[
       StyleBox["b", "TI"], TraditionalForm]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      FormBox[
       StyleBox["c", "TI"], TraditionalForm]], "InlineFormula"],
     " are the parameters of the quadratic form ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox[
         StyleBox["z", "TI"], "\[Prime]"], 
        StyleBox["A", "TI"], 
        StyleBox["z", "TI"], "+", 
        SuperscriptBox[
         StyleBox["b", "TI"], "\[Prime]"], 
        StyleBox["z", "TI"], "+", 
        StyleBox["c", "TI"]}], TraditionalForm]], "InlineFormula"],
     ", and ",
     StyleBox["z", "TI"],
     " is distributed multinormally, with mean vector ",
     StyleBox["\[Mu]", "TI"],
     " and covariance matrix ",
     StyleBox["\[CapitalSigma]", "TI"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->30234],

Cell["\<\
Distributions derived from the multivariate normal distribution.\
\>", "Caption",
 CellID->1748],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 "\[Hyphen]variate ",
 StyleBox["multinormal distribution", "TB",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{
   "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
    "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}}],
 " with mean vector ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and covariance matrix ",
 Cell[BoxData[
  FormBox["\[CapitalSigma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["N", "TI"], 
     StyleBox["p", "TI"]], 
    RowBox[{"(", 
     RowBox[{"\[Mu]", ",", Cell[BoxData["\[CapitalSigma]"], "InlineFormula",
       GridBoxOptions->{
       GridBoxItemSize->{
        "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
         "RowsIndexed" -> {}}}]}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". If ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["X", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i", "TI"], "=", "1", ",", "\[Ellipsis]", ",", 
    StyleBox["m", "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", is distributed ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["N", "TI"], 
     StyleBox["p", "TI"]], 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["0", "\[RightVector]"], ",", Cell[BoxData[
      "\[CapitalSigma]"], "InlineFormula",
       GridBoxOptions->{
       GridBoxItemSize->{
        "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
         "RowsIndexed" -> {}}}]}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " (where ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["0", "\[RightVector]"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is the zero vector), and ",
 StyleBox["X", "TB",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{
   "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
    "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}}],
 " denotes the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m", "TI"], "\[Cross]", 
    StyleBox["p", "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " data matrix composed of the ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " row vectors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["X", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", then the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p", "TI"], "\[Cross]", 
    StyleBox["p", "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["X", "TB"], "\[Prime]"], 
    StyleBox["X", "TB"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " has a ",
 StyleBox["Wishart distribution", "TB",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{
   "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
    "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}}],
 " with scale matrix ",
 Cell[BoxData[
  FormBox["\[CapitalSigma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and degrees of freedom parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["W", "TI"], 
     StyleBox["p", "TI"]], 
    RowBox[{"(", 
     RowBox[{Cell[BoxData["\[CapitalSigma]"], "InlineFormula",
       GridBoxOptions->{
       GridBoxItemSize->{
        "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
         "RowsIndexed" -> {}}}], ",", 
      StyleBox["m", "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". The Wishart distribution is most typically used when describing the \
covariance matrix of multinormal samples. "
}], "Text",
 CellID->28228],

Cell[TextData[{
 "A vector that has a ",
 StyleBox["multivariate Student ", "TB",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{
   "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
    "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}}],
 StyleBox["t", "TBI"],
 StyleBox[" distribution", "TB",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{
   "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
    "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}}],
 " can also be written as a function of a multinormal random vector. Let ",
 Cell[BoxData[
  FormBox[
   StyleBox["X", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " be a standardized multinormal vector with covariance matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["R", "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and let ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["S", "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " be a chi\[Hyphen]square variable with ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " degrees of freedom. (Note that since ",
 Cell[BoxData[
  FormBox[
   StyleBox["X", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is standardized, ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["0", "\[RightVector]"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is the mean vector of ",
 Cell[BoxData[
  FormBox[
   StyleBox["X", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["R", "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is also the correlation matrix of ",
 Cell[BoxData[
  FormBox[
   StyleBox["X", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ".) Then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["X", "TI"], "/", 
    StyleBox["S", "TI"], "/", 
    SqrtBox[
     StyleBox["m", "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " has a multivariate ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " distribution with correlation matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["R", "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " degrees of freedom, denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["t", "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["R", "TB"], ",", 
      StyleBox["m", "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". The multivariate Student ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " distribution is elliptically contoured like the multinormal distribution, \
and characterizes the ratio of a multinormal vector to the standard deviation \
common to each variate. When ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["R", "TB"], "=", 
    StyleBox["I", "TB"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m", "TI"], "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", the multivariate ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " distribution is the same as the multivariate Cauchy distribution (here ",
 Cell[BoxData[
  FormBox[
   StyleBox["I", "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " denotes the identity matrix). "
}], "Text",
 CellID->22726],

Cell[TextData[{
 "The ",
 StyleBox["Hotelling ", "TB"],
 StyleBox["T", "TBI"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", 
    StyleBox["2", "TB"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 StyleBox[" distribution", "TB"],
 " is a univariate distribution proportional to the ",
 StyleBox["F", "TI"],
 "\[Hyphen]ratio distribution. If vector ",
 Cell[BoxData[
  FormBox[
   StyleBox["d", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["M", "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " are independently distributed ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["N", "TI"], 
     StyleBox["p", "TI"]], 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["0", "\[RightVector]"], ",", 
      StyleBox["I", "TB"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["W", "TI"], 
     StyleBox["p", "TI"]], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["I", "TB"], ",", 
      StyleBox["m", "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m", "TI"], 
    SuperscriptBox[
     StyleBox["d", "TI"], "\[Prime]"], 
    SuperscriptBox[
     StyleBox["M", "TB"], 
     RowBox[{"-", "1"}]], 
    StyleBox["d", "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " has the Hotelling ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["T", "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " distribution with parameters ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["T", "TI"], "2"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      StyleBox["m", "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". This distribution is commonly used to describe the sample Mahalanobis \
distance between two populations. "
}], "Text",
 CellID->11709],

Cell[TextData[{
 "A ",
 StyleBox["quadratic form", "TB"],
 " in a multinormal vector ",
 Cell[BoxData[
  FormBox[
   StyleBox["X", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " distributed ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["N", "TI"], 
     StyleBox["p", "TI"]], 
    RowBox[{"(", 
     RowBox[{"\[Mu]", ",", Cell[BoxData["\[CapitalSigma]"], "InlineFormula",
       GridBoxOptions->{
       GridBoxItemSize->{
        "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
         "RowsIndexed" -> {}}}]}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["X", "TI"], "\[Prime]"], 
    StyleBox["A", "TI"], 
    StyleBox["X", "TI"], "+", 
    SuperscriptBox[
     StyleBox["b", "TI"], "\[Prime]"], 
    StyleBox["X", "TI"], "+", 
    StyleBox["c", "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["A", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is a symmetric ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p", "TI"], "\[Cross]", 
    StyleBox["p", "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " matrix, ",
 Cell[BoxData[
  FormBox[
   StyleBox["b", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is a ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 "\[Hyphen]vector, and ",
 Cell[BoxData[
  FormBox[
   StyleBox["c", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is a scalar. This univariate distribution can be useful in discriminant \
analysis of multinormal samples. "
}], "Text",
 CellID->19601],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PDF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PDF"], "[", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "probability density function at ",
     StyleBox["x", "TI"],
     ", where ",
     StyleBox["x", "TI"],
     " is scalar\[Hyphen], vector\[Hyphen], or matrix\[Hyphen]valued \
depending on ",
     StyleBox["dist", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CDF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CDF"], "[", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "cumulative distribution function at ",
     StyleBox["x", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Mean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mean"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell["mean ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Variance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variance"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell["variance ", "TableText"]},
   {
    RowBox[{
     ButtonBox["StandardDeviation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StandardDeviation"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "standard deviation ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Skewness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Skewness"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "coefficient of skewness ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Kurtosis",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Kurtosis"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "coefficient of kurtosis ", "TableText"]},
   {
    RowBox[{
     ButtonBox["CharacteristicFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacteristicFunction"], "[", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "characteristic function ",
     Cell[BoxData[
      RowBox[{"\[CurlyPhi]", "(", 
       StyleBox["t", "TI"], ")"}]], "InlineFormula"],
     ", where ",
     StyleBox["t", "TI"],
     " is scalar\[Hyphen], vector\[Hyphen], or matrix\[Hyphen]valued \
depending on ",
     StyleBox["dist", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpectedValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpectedValue"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["dist", "TI"], "]"}], Cell[TextData[{
     "expected value of pure function ",
     StyleBox["f", "TI"],
     " with respect to the specified distribution "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpectedValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpectedValue"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "expected value of function ",
     StyleBox["f", "TI"],
     " of ",
     StyleBox["x", "TI"],
     " with respect to the specified distribution, where ",
     StyleBox["x", "TI"],
     " is scalar\[Hyphen], vector\[Hyphen], or matrix\[Hyphen]valued \
depending on ",
     StyleBox["dist", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell["\<\
pseudorandom number, vector, or matrix with specified distribution \
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["dims", "TI"], "]"}], Cell[TextData[{
     "pseudorandom array with dimensionality ",
     StyleBox["dims", "TI"],
     StyleBox[",", "MR"],
     " and elements from the specified distribution "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->17755],

Cell["\<\
Functions of univariate statistical distributions applicable to multivariate \
distributions. \
\>", "Caption",
 CellID->4061],

Cell[TextData[{
 "Generally, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " evaluates the density at ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " if ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is a numerical value, vector, or matrix, and otherwise leaves the function \
in symbolic form. Similarly, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " gives the cumulative density and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CharacteristicFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacteristicFunction"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
 " gives the characteristic function of the specified distribution. "
}], "Text",
 CellID->13223],

Cell[TextData[{
 "In some cases explicit forms of these expressions are not available. For \
example, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PDF"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["QuadraticFormDistribution",
      BaseStyle->"Link",
      ButtonData->
       "paclet:MultivariateStatistics/ref/QuadraticFormDistribution"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"A", ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["c", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["\[Mu]", "TI"], ",", 
        StyleBox["\[CapitalSigma]", "TI"]}], "}"}]}], "]"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " does not evaluate, but a ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " expansion of the ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " about the lower support point of the domain (for a positive definite \
quadratic form) does evaluate. The ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  ButtonBox["MultinormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MultinormalDistribution"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MultivariateTDistribution",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/MultivariateTDistribution"]], 
  "InlineFormula"],
 " is available for numerical vector arguments, but not for symbolic vector \
arguments. In the case of ",
 Cell[BoxData[
  ButtonBox["MultivariateTDistribution",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/MultivariateTDistribution"]], 
  "InlineFormula"],
 ", the ",
 Cell[BoxData[
  ButtonBox["CharacteristicFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacteristicFunction"]], "InlineFormula"],
 " is expressed in terms of an integral. "
}], "Text",
 CellID->6278],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  ButtonBox["MultinormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MultinormalDistribution"]], 
  "InlineFormula"],
 " can be represented in a closed form if ",
 Cell[BoxData[
  StyleBox["\[CapitalSigma]", "TR"]], "InlineFormula"],
 " is a diagonal matrix. Otherwise numeric methods are required. The ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  ButtonBox["MultivariateTDistribution",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/MultivariateTDistribution"]], 
  "InlineFormula"],
 " can only be computed numerically."
}], "Text",
 CellID->695677167],

Cell["Here is a symbolic bivariate normal distribution.", "MathCaption",
 CellID->10160],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox["1", 
        SqrtBox["3"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["3"]], ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"ndist", "=", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "r"}], "]"}]}]}], "Input",
 CellLabel->"In[22]:=",
 CellID->10883],

Cell[BoxData[
 RowBox[{"MultinormalDistribution", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        FractionBox["1", 
         SqrtBox["3"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["1", 
         SqrtBox["3"]], ",", "1"}], "}"}]}], "}"}],
    Short]}], "]"}]], "Output",
 ImageSize->{375, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->220139620]
}, Open  ]],

Cell["This gives its probability density function. ", "MathCaption",
 CellID->1404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdf", "=", 
  RowBox[{"PDF", "[", 
   RowBox[{"ndist", ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[24]:=",
 CellID->22741],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["3", "2"]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "x2"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox[
            RowBox[{
             SqrtBox["3"], " ", "x1"}], "2"]}], "+", 
          FractionBox[
           RowBox[{"3", " ", "x2"}], "2"]}], ")"}]}], "-", 
       RowBox[{"x1", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"3", " ", "x1"}], "2"], "-", 
          FractionBox[
           RowBox[{
            SqrtBox["3"], " ", "x2"}], "2"]}], ")"}]}]}], ")"}]}]]}], 
  RowBox[{"2", " ", "\[Pi]"}]]], "Output",
 ImageSize->{249, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->254524342]
}, Open  ]],

Cell["The density can be plotted to visualize the distribution. ", \
"MathCaption",
 CellID->3415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"pdf", ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x2", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->714349960],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->480102087]
}, Open  ]],

Cell[TextData[{
 "Here is the probability of the distribution in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], "1"], "<", 
    RowBox[{"-", "1"}], "\[Intersection]", 
    SubscriptBox[
     StyleBox["x", "TI"], "2"], "<", "1"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". "
}], "MathCaption",
 CellID->29175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{"ndist", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1."}], ",", "1."}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->31527],

Cell[BoxData["0.15654424797762292`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->124847979]
}, Open  ]],

Cell[TextData[{
 "While the density of a quadratic form distribution is not generally \
expressible in closed form, it can be approximated by its series expansion \
about the lower support point of the distribution. Series expansions for ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " of a ",
 Cell[BoxData[
  ButtonBox["QuadraticFormDistribution",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/QuadraticFormDistribution"]], 
  "InlineFormula"],
 " can be obtained using ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 "."
}], "Text",
 CellID->453528901],

Cell[TextData[{
 "A series expansion of the ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " of the quadratic form distribution can be plotted."
}], "MathCaption",
 CellID->26614],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"qdist", "=", 
   RowBox[{"QuadraticFormDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"8", ",", 
           RowBox[{"-", "4"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4"}], ",", "3"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"polynomial", "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"PDF", "[", 
       RowBox[{"qdist", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        FractionBox["47", "8"], ",", "20"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{"polynomial", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     FractionBox["47", "8"], ",", "40"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[27]:=",
 CellID->241750428],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->120169904]
}, Open  ]],

Cell[TextData[{
 "The following gives a ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " value for a four\[Hyphen]dimensional normal."
}], "MathCaption",
 CellID->11382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"MultinormalDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0.2", ",", "0.8", ",", "0.4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2", ",", "1.5", ",", 
         RowBox[{"-", "0.3"}], ",", "0.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8", ",", 
         RowBox[{"-", "0.3"}], ",", "3", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4", ",", "0.1", ",", 
         RowBox[{"-", "1"}], ",", "2.5"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2"}], ",", "1", ",", "5", ",", "4"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->22849],

Cell[BoxData["0.09028649423922173`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->313931302]
}, Open  ]],

Cell[TextData[{
 "The following gives a ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " value for a bivariate ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with 10 degrees of freedom."
}], "MathCaption",
 CellID->20212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"MultivariateTDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2", ",", "1"}], "}"}]}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->10886],

Cell[BoxData["0.7049523596974749`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->3695569]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Quantile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quantile"], "[", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["q", "TI"], "]"}], Cell[TextData[{
     StyleBox["q", "TI"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " quantile of the univariate distribution ",
     StyleBox["dist", "TI"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->31553],

Cell["\<\
Functions of univariate statistical distributions not applicable to \
multivariate distributions. \
\>", "Caption",
 CellID->19548],

Cell[TextData[{
 "In the multivariate case, it is difficult to define ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " as the inverse of the ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " function because many values of the random vector (or random matrix) \
correspond to a single probability value. This package defines ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " only for the univariate distribution ",
 Cell[BoxData[
  ButtonBox["HotellingTSquareDistribution",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/HotellingTSquareDistribution"]], 
  "InlineFormula"],
 " and some minor degenerate cases of the other distributions. ",
 Cell[BoxData[
  ButtonBox["EllipsoidQuantile",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuantile"]], 
  "InlineFormula"],
 " and its inverse ",
 Cell[BoxData[
  ButtonBox["EllipsoidProbability",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidProbability"]], 
  "InlineFormula"],
 " can be computed for the elliptically\[Hyphen]contoured distributions ",
 Cell[BoxData[
  ButtonBox["MultinormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MultinormalDistribution"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MultivariateTDistribution",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/MultivariateTDistribution"]], 
  "InlineFormula"],
 ". Ellipses must define constant\[Hyphen]probability contours."
}], "Text",
 CellID->14499],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EllipsoidProbability",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidProbability"], 
     "[", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["ellipse", "TI"], "]"}], Cell[
    "cumulative probability within the specified domain ", "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipsoidQuantile",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuantile"], "[",
      
     StyleBox["dist", "TI"], ",", 
     StyleBox["q", "TI"], "]"}], Cell[TextData[{
     StyleBox["q", "TI"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " elliptically contoured quantile "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Covariance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Covariance"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "covariance matrix of the specified distribution ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Correlation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Correlation"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "correlation matrix of the specified distribution ", "TableText"]},
   {
    RowBox[{
     ButtonBox["MultivariateSkewness",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/MultivariateSkewness"], 
     "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "multivariate coefficient of skewness ", "TableText"]},
   {
    RowBox[{
     ButtonBox["MultivariateKurtosis",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/MultivariateKurtosis"], 
     "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "multivariate kurtosis coefficient ", "TableText"]}
  }]], "DefinitionBox",
 CellID->6900],

Cell["Functions of multivariate statistical distributions.", "Caption",
 CellID->27841],

Cell[TextData[{
 "This gives the ellipse centered on the mean that encloses a probability of \
.5 in ",
 Cell[BoxData[
  StyleBox["ndist", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ellipse", "=", 
  RowBox[{"EllipsoidQuantile", "[", 
   RowBox[{"ndist", ",", ".5"}], "]"}]}]], "Input",
 CellLabel->"In[32]:=",
 CellID->32570],

Cell[BoxData[
 RowBox[{"Ellipsoid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.478739931052286`", ",", "0.76545211381984`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7071067811865475`", ",", "0.7071067811865475`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"0.7071067811865476`", ",", 
       RowBox[{"-", "0.7071067811865476`"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Output",
 ImageSize->{580, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->1004537557]
}, Open  ]],

Cell["\<\
This gives the probability of the distribution within the ellipse.\
\>", "MathCaption",
 CellID->18152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipsoidProbability", "[", 
  RowBox[{"ndist", ",", "ellipse"}], "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->28468],

Cell[BoxData["0.4999999999999999`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->320629128]
}, Open  ]],

Cell[TextData[{
 "As ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m", "TI"], "->", "\[Infinity]"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", multivariate ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " elliptic quantiles approach those of a multivariate normal. "
}], "MathCaption",
 CellID->4696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ellipse", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Dashing", "[", 
        RowBox[{"{", 
         RowBox[{".04", ",", ".02"}], "}"}], "]"}], ",", 
       RowBox[{"EllipsoidQuantile", "[", 
        RowBox[{
         RowBox[{"MultivariateTDistribution", "[", 
          RowBox[{"r", ",", "2"}], "]"}], ",", ".5"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Dashing", "[", 
        RowBox[{"{", 
         RowBox[{".02", ",", ".04"}], "}"}], "]"}], ",", 
       RowBox[{"EllipsoidQuantile", "[", 
        RowBox[{
         RowBox[{"MultivariateTDistribution", "[", 
          RowBox[{"r", ",", "1"}], "]"}], ",", ".5"}], "]"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->27036],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->41651969]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Discrete Distributions", "Section",
 CellID->7373],

Cell["\<\
The multinomial, negative multinomial and multiple Poisson distributions \
generalize the binomial, negative binomial and Poisson distributions to \
multiple dimensions. \
\>", "Text",
 CellID->397],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MultinomialDistribution",
      BaseStyle->"Link",
      ButtonData->
       "paclet:MultivariateStatistics/ref/MultinomialDistribution"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "multinomial distribution with index ",
     StyleBox["n", "TI"],
     " and probability vector ",
     StyleBox["p", "TI"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["NegativeMultinomialDistribution",
       BaseStyle->"Link",
       ButtonData->
        "paclet:MultivariateStatistics/ref/NegativeMultinomialDistribution"], 
      "[", 
      StyleBox["n", "TI"], ",", 
      StyleBox["p", "TI"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "negative multinomial distribution with parameter ",
     StyleBox["n", "TI"],
     " and failure probability vector ",
     StyleBox["p", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MultiPoissonDistribution",
      BaseStyle->"Link",
      ButtonData->
       "paclet:MultivariateStatistics/ref/MultiPoissonDistribution"], "[", 
     SubscriptBox[
      StyleBox["\[Mu]", "TI"], 
      StyleBox["0", "TR"]], ",", 
     StyleBox["\[Mu]", "TI"], "]"}], Cell[TextData[{
     "multiple Poisson distribution with mean vector ",
     Cell[BoxData[
      RowBox[{"{", 
       SubscriptBox[
        StyleBox["\[Mu]", "TI"], 
        StyleBox["0", "TR"]], "+", 
       SubscriptBox[
        StyleBox["\[Mu]", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["\[Mu]", "TI"], 
        StyleBox["0", "TR"]], "+", 
       SubscriptBox[
        StyleBox["\[Mu]", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["...", "TI"], "}"}]], "InlineFormula"],
     "."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->15124],

Cell["Discrete multivariate probability distributions.", "Caption",
 CellID->360],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  FormBox[
   StyleBox["k", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]variate ",
 StyleBox["multinomial distribution", "TB"],
 " with index ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 " and probability vector ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 " may be used to describe a series of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 " independent trials, in each of which just one of ",
 Cell[BoxData[
  FormBox[
   StyleBox["k", "TI"], TraditionalForm]], "InlineFormula"],
 " mutually exclusive events is observed with probability ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["p", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i", "TI"], "=", "1", ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    StyleBox["k", "TI"]}], TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->14126],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  FormBox[
   StyleBox["k", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]variate ",
 StyleBox["negative multinomial distribution", "TB"],
 " with positive integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 " and failure probability vector ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 " may be used to describe a series of independent trials, in each of which \
there may be a success or one of ",
 Cell[BoxData[
  FormBox[
   StyleBox["k", "TI"], TraditionalForm]], "InlineFormula"],
 " mutually exclusive modes of failure. The ",
 Cell[BoxData[
  FormBox[
   StyleBox["i", "TI"], TraditionalForm]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
 " failure mode is observed with probability ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["p", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i", "TI"], "=", "1", ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    StyleBox["k", "TI"]}], TraditionalForm]], "InlineFormula"],
 ", and the trials are discontinued when ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 " successes are observed. The parameter ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " can be any positive value, though the interpretation of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " as a success count does not hold for non\[Hyphen]integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->21640],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  FormBox[
   StyleBox["k", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]variate ",
 StyleBox["multiple Poisson distribution", "TB"],
 " with mean vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Mu]", "0"], "+", 
     SubscriptBox["\[Mu]", "1"], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox["\[Mu]", "0"], "+", 
     SubscriptBox["\[Mu]", 
      StyleBox["k", "TI"]]}], "}"}], TraditionalForm]], "InlineFormula"],
 " is a common way to generalize the univariate Poisson distribution. Here \
the random ",
 Cell[BoxData[
  FormBox[
   StyleBox["k", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["X", "TI"], "1"], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["X", "TI"], 
      StyleBox["k", "TI"]]}], "}"}], TraditionalForm]], "InlineFormula"],
 " following this distribution is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["Y", "TI"], "1"], "+", 
     SubscriptBox[
      StyleBox["Y", "TI"], "0"], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["Y", "TI"], 
      StyleBox["k", "TI"]], "+", 
     SubscriptBox[
      StyleBox["Y", "TI"], "0"]}], "}"}], TraditionalForm]], 
  "InlineFormula"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["Y", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 " is a Poisson random variable with mean ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Mu]", 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i", "TI"], "=", "0", ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    StyleBox["k", "TI"]}], TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->30119],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PDF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PDF"], "[", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "probability density function at ",
     StyleBox["x", "TI"],
     ", where ",
     StyleBox["x", "TI"],
     " is vector\[Hyphen]valued"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CDF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CDF"], "[", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "cumulative distribution function at ",
     StyleBox["x", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Mean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mean"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell["mean ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Variance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variance"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell["variance ", "TableText"]},
   {
    RowBox[{
     ButtonBox["StandardDeviation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StandardDeviation"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "standard deviation ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Skewness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Skewness"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "coefficient of skewness ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Kurtosis",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Kurtosis"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "coefficient of kurtosis ", "TableText"]},
   {
    RowBox[{
     ButtonBox["CharacteristicFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacteristicFunction"], "[", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "characteristic function ",
     Cell[BoxData[
      RowBox[{"\[Phi]", "(", 
       StyleBox["t", "TI"], ")"}]], "InlineFormula"],
     ", where ",
     StyleBox["t", "TI"],
     " is vector\[Hyphen]valued"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpectedValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpectedValue"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["dist", "TI"], "]"}], Cell[TextData[{
     "expected value of pure function ",
     StyleBox["f", "TI"],
     " with respect to the specified distribution "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpectedValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpectedValue"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "expected value of function ",
     StyleBox["f", "TI"],
     " of ",
     StyleBox["x", "TI"],
     " with respect to the specified distribution, where ",
     StyleBox["x", "TI"],
     " is vector\[Hyphen]valued "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "pseudorandom vector with specified distribution ", "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     StyleBox["dist", "TI"], ",", 
     StyleBox["dims", "TI"], "]"}], Cell[TextData[{
     "pseudorandom array with dimensionality ",
     StyleBox["dims", "TI"],
     ", and elements from the specified distribution "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->18228],

Cell["\<\
Functions of univariate distributions applicable to multivariate \
distributions. \
\>", "Caption",
 CellID->4741],

Cell[TextData[{
 "Generally, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " evaluates the density at ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 " is a vector, and otherwise leaves the function in symbolic form. The same \
is true for ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CharacteristicFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacteristicFunction"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->5271],

Cell[TextData[{
 "Univariate descriptive statistic functions like ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Kurtosis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Kurtosis"]], "InlineFormula"],
 " give vectors of coordinate\[Hyphen]wise results for multivariate \
distributions."
}], "Text",
 CellID->13948],

Cell["\<\
Here is a symbolic representation of a bivariate multinomial distribution. \
\>", "MathCaption",
 CellID->30229],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"{", 
    RowBox[{".4", ",", ".6"}], "}"}]}], ";"}], "\n", 
 RowBox[{"mdist", "=", 
  RowBox[{"MultinomialDistribution", "[", 
   RowBox[{"10", ",", "p"}], "]"}]}]}], "Input",
 CellLabel->"In[35]:=",
 CellID->20609],

Cell[BoxData[
 RowBox[{"MultinomialDistribution", "[", 
  RowBox[{"10", ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{"0.4`", ",", "0.6`"}], "}"}],
    Short]}], "]"}]], "Output",
 ImageSize->{272, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->51575552]
}, Open  ]],

Cell["This gives its probability density function. ", "MathCaption",
 CellID->711734026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdf", "=", 
  RowBox[{"PDF", "[", 
   RowBox[{"mdist", ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[37]:=",
 CellID->29449],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x1", "+", "x2"}], "\[Equal]", "10"}], ",", 
   RowBox[{
    SuperscriptBox["0.4`", "x1"], " ", 
    SuperscriptBox["0.6`", "x2"], " ", 
    RowBox[{"Multinomial", "[", 
     RowBox[{"x1", ",", "x2"}], "]"}]}], ",", "0"}], "]"}]], "Output",
 ImageSize->{333, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->20042507]
}, Open  ]],

Cell["The following visualizes the density of the distribution. ", \
"MathCaption",
 CellID->30000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "10"}], "]"}]}], ";", 
  RowBox[{"t", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "+", ".5"}], ",", "r"}], "}"}], "]"}]}], ";", 
  RowBox[{"ArrayPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{"pdf", ",", 
      RowBox[{"{", 
       RowBox[{"x1", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x2", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"t", ",", "t"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[38]:=",
 CellID->7929],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm82OEkEQxxuGXbx4UGNcFhZXxQcwPIAxJnryavagMZONCRyMZt2bMV44
czfGFzE+BiHG5xAjF8YumA5NVfUH7LBopkjomZ7+/au7a6ZqembZZ+l57/Wb
9Lx/mh4/PUvf9fqn74+fvD3Th5KKUpWe/vYPlN7PlFp84dPX38Uu3ruuy6rG
Wnqb6O2h3tb0tpnXj4BKjJ1MNfLjLUtntzet49XcHjRX83pn3us1KGtLFbVz
aNV1qdqedtjF+gPSQ5OzsELguVIbVUTciZwN7pvrqRY1Amy5wRIA0JZNR8+d
myryKHeOwqM3llqE3N7ouevAvmJ9Vz5zRW1p1NQS9m4jc0eg/zqnRzafiZ0/
8JbzIs4Pxtvm+FG+NbNLMjtvgAl3LuP2ruajfwEX6Lxmj6YW8F2oHvJ90fbu
6qIiM/lPZgLFibRKq7ReWusifZiPWXXueTXzO5v3Xofrm+j38urzC/R7Txft
2WwGlVv/rJ35TVstd7kzwCvxuRVKKKG2QUE8QlzuR9F1RCVRKrANEF7RuUe0
mn1AB1nzIfCTyeRPgLX7eFSIZj/jsxclsdeFEKK8RHzc7CKSIae8BGI0Gv1c
w+qrQjQu31AS+1kIIcpL4JVKXKStpwitc+IUkF8+ADkcDr9H2/5IFOHsQjWu
NRclsceFEEIIf2Rx9+1i4tb99EMzSdj+F13c7na7X1c0CTN6SoayJlXUc8+E
SexlIYQoLxEfk1cQgd/Dxikgm3xe2/Y3XbR19VNmZwguE/KkL5dQhSuXUBL7
VwghykuEni6KUEC8w7IjHJt2ZjB1yD5jIDudTpqFcsmPC5ChmVEF9q8QQpSX
cK1LKBlaOxShwG9ufwExGAweZ7Hx/psoQqOgCpdPKIn9K4QQ5SVcawZK2s8K
KkpRTNyb3+XcAHo8Ht/30nYdiptEFX47w+tc6xuexp4XSiihdke5/u7C06HM
Fa9yZ6+YPrqgmk6n9Z2ofBmP0tx5EEoooYqm1ovLuPVOrM7kswcb9nNyabzP
S8X90n35v0uq8hdogfKE\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 361},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->476610781]
}, Open  ]],

Cell[TextData[{
 "Here is the probability of the distribution in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], "1"], "<", "6", "\[Intersection]", 
    SubscriptBox[
     StyleBox["x", "TI"], "2"], "<", "7"}], TraditionalForm]], 
  "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{"mdist", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->760],

Cell[BoxData["0.7779483648000001`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->131370282]
}, Open  ]],

Cell["\<\
This gives the mean vectors of trivariate versions of the three \
distributions. \
\>", "MathCaption",
 CellID->14993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mean", "[", 
    RowBox[{"MultinomialDistribution", "[", 
     RowBox[{"n", ",", 
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"Mean", "[", 
    RowBox[{"NegativeMultinomialDistribution", "[", 
     RowBox[{"n", ",", 
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"Mean", "[", 
    RowBox[{"MultiPoissonDistribution", "[", 
     RowBox[{"mu0", ",", 
      RowBox[{"{", 
       RowBox[{"mu1", ",", "mu2", ",", "mu3"}], "}"}]}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->8472],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", " ", "p1"}], ",", 
     RowBox[{"n", " ", "p2"}], ",", 
     RowBox[{"n", " ", "p3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"n", " ", "p1"}], 
      RowBox[{"1", "-", "p1", "-", "p2", "-", "p3"}]], ",", 
     FractionBox[
      RowBox[{"n", " ", "p2"}], 
      RowBox[{"1", "-", "p1", "-", "p2", "-", "p3"}]], ",", 
     FractionBox[
      RowBox[{"n", " ", "p3"}], 
      RowBox[{"1", "-", "p1", "-", "p2", "-", "p3"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"mu0", "+", "mu1"}], ",", 
     RowBox[{"mu0", "+", "mu2"}], ",", 
     RowBox[{"mu0", "+", "mu3"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{447, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->187841409]
}, Open  ]],

Cell["Here is a sample from each of the distributions. ", "MathCaption",
 CellID->18634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"MultinomialDistribution", "[", 
     RowBox[{"10", ",", 
      RowBox[{"{", 
       RowBox[{".2", ",", ".3", ",", ".5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"NegativeMultinomialDistribution", "[", 
     RowBox[{"5", ",", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["2", "15"], ",", 
        FractionBox["1", "5"], ",", 
        FractionBox["1", "3"]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"MultiPoissonDistribution", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->16766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->463264433]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Covariance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Covariance"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "covariance matrix of the specified distribution ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Correlation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Correlation"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "correlation matrix of the specified distribution ", "TableText"]},
   {
    RowBox[{
     ButtonBox["MultivariateSkewness",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/MultivariateSkewness"], 
     "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "multivariate coefficient of skewness ", "TableText"]},
   {
    RowBox[{
     ButtonBox["MultivariateKurtosis",
      BaseStyle->"Link",
      ButtonData->"paclet:MultivariateStatistics/ref/MultivariateKurtosis"], 
     "[", 
     StyleBox["dist", "TI"], "]"}], Cell[
    "multivariate kurtosis coefficient ", "TableText"]}
  }]], "DefinitionBox",
 CellID->8853],

Cell["Functions of multivariate statistical distributions.", "Caption",
 CellID->31851],

Cell["\<\
This gives the covariance between coordinates for bivariate versions of the \
distributions. \
\>", "MathCaption",
 CellID->22139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Covariance", "[", 
     RowBox[{"MultinomialDistribution", "[", 
      RowBox[{"n", ",", 
       RowBox[{"{", 
        RowBox[{"p1", ",", "p2"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"Covariance", "[", 
     RowBox[{"NegativeMultinomialDistribution", "[", 
      RowBox[{"n", ",", 
       RowBox[{"{", 
        RowBox[{"p1", ",", "p2"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"Covariance", "[", 
     RowBox[{"MultiPoissonDistribution", "[", 
      RowBox[{"mu0", ",", 
       RowBox[{"{", 
        RowBox[{"mu1", ",", "mu2"}], "}"}]}], "]"}], "]"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "1", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->22275],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "n"}], " ", "p1", " ", "p2"}], ",", 
   FractionBox[
    RowBox[{"n", " ", "p1", " ", "p2"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "p1", "-", "p2"}], ")"}], "2"]], ",", "mu0"}], 
  "}"}]], "Output",
 ImageSize->{194, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->228709574]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Multivariate Statistics Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 51.8380392}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Multivariate Statistics Package Tutorial", "language" -> "en", "paclet" -> 
    "MultivariateStatistics Package", "status" -> "None", "summary" -> 
    "This package contains descriptive statistics for multivariate data, \
distributions derived from the multivariate normal distribution and \
multivariate discrete distributions. Distributions are represented in the \
symbolic form name[param_1, param_2, ... ]. This loads the package. Here is a \
bivariate data set (courtesy of United States Forest Products Laboratory). ", 
    "synonyms" -> {}, "title" -> "Multivariate Statistics Package", "type" -> 
    "Tutorial", "uri" -> 
    "MultivariateStatistics/tutorial/MultivariateStatistics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 6833, 132, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[7458, 159, 64, 1, 70, "Title",
 CellID->29538],
Cell[7525, 162, 650, 22, 70, "Text",
 CellID->19239],
Cell[CellGroupData[{
Cell[8200, 188, 74, 1, 70, "Section",
 CellID->668135853],
Cell[8277, 191, 63, 1, 70, "MathCaption",
 CellID->12105],
Cell[8343, 194, 106, 3, 70, "Input",
 CellID->19556],
Cell[8452, 199, 134, 4, 70, "MathCaption",
 CellID->27000],
Cell[8589, 205, 2309, 68, 70, "Input",
 CellID->9665],
Cell[10901, 275, 153, 4, 70, "MathCaption",
 CellID->247070732],
Cell[CellGroupData[{
Cell[11079, 283, 192, 6, 28, "Input",
 CellID->23647167],
Cell[11274, 291, 1253, 25, 122, "Output",
 CellID->100142765]
}, Open  ]],
Cell[CellGroupData[{
Cell[12564, 321, 59, 1, 70, "Subsection",
 CellID->30082],
Cell[12626, 324, 435, 8, 70, "Text",
 CellID->23142],
Cell[13064, 334, 361, 7, 70, "Text",
 CellID->18466],
Cell[13428, 343, 1410, 40, 70, "DefinitionBox",
 CellID->12195],
Cell[14841, 385, 68, 1, 70, "Caption",
 CellID->5423],
Cell[14912, 388, 587, 19, 70, "Text",
 CellID->17873],
Cell[15502, 409, 1421, 50, 70, "Text",
 CellID->12238],
Cell[16926, 461, 131, 4, 70, "MathCaption",
 CellID->24349],
Cell[CellGroupData[{
Cell[17082, 469, 107, 3, 70, "Input",
 CellID->9869],
Cell[17192, 474, 241, 8, 36, "Output",
 CellID->144618665]
}, Open  ]],
Cell[17448, 485, 151, 4, 70, "MathCaption",
 CellID->20549],
Cell[CellGroupData[{
Cell[17624, 493, 108, 3, 70, "Input",
 CellID->19428],
Cell[17735, 498, 241, 8, 36, "Output",
 CellID->423061781]
}, Open  ]],
Cell[17991, 509, 2994, 105, 70, "DefinitionBox",
 CellID->4048],
Cell[20988, 616, 57, 1, 70, "Caption",
 CellID->18839],
Cell[21048, 619, 1206, 30, 70, "Text",
 CellID->6989],
Cell[22257, 651, 1943, 64, 70, "Text",
 CellID->700],
Cell[24203, 717, 395, 10, 70, "Text",
 CellID->250132332],
Cell[24601, 729, 129, 4, 70, "MathCaption",
 CellID->27054],
Cell[CellGroupData[{
Cell[24755, 737, 499, 16, 70, "Input",
 CellID->1096],
Cell[25257, 755, 335, 11, 36, "Output",
 CellID->360272783]
}, Open  ]],
Cell[25607, 769, 2265, 74, 70, "DefinitionBox",
 CellID->14321],
Cell[27875, 845, 74, 1, 70, "Caption",
 CellID->31475],
Cell[27952, 848, 122, 3, 70, "MathCaption",
 CellID->27921],
Cell[CellGroupData[{
Cell[28099, 855, 504, 18, 70, "Input",
 CellID->29367],
Cell[28606, 875, 322, 11, 36, "Output",
 CellID->49303169]
}, Open  ]],
Cell[28943, 889, 117, 3, 70, "MathCaption",
 CellID->31545],
Cell[CellGroupData[{
Cell[29085, 896, 533, 16, 47, "Input",
 CellID->17716],
Cell[29621, 914, 9495, 160, 368, "Output",
 Evaluatable->False,
 CellID->9951103]
}, Open  ]],
Cell[39131, 1077, 153, 4, 70, "MathCaption",
 CellID->7096],
Cell[CellGroupData[{
Cell[39309, 1085, 533, 16, 70, "Input",
 CellID->26135],
Cell[39845, 1103, 2128, 39, 368, "Output",
 CellID->794083281]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42022, 1148, 61, 1, 70, "Subsection",
 CellID->27754],
Cell[42086, 1151, 590, 17, 70, "Text",
 CellID->8670],
Cell[42679, 1170, 1469, 44, 70, "DefinitionBox",
 CellID->25446],
Cell[44151, 1216, 100, 3, 70, "Caption",
 CellID->4728],
Cell[44254, 1221, 1838, 55, 70, "Text",
 CellID->24864],
Cell[46095, 1278, 277, 8, 70, "MathCaption",
 CellID->3521],
Cell[CellGroupData[{
Cell[46397, 1290, 115, 3, 70, "Input",
 CellID->31109],
Cell[46515, 1295, 179, 5, 36, "Output",
 CellID->38177355]
}, Open  ]],
Cell[46709, 1303, 264, 8, 70, "MathCaption",
 CellID->31603],
Cell[CellGroupData[{
Cell[46998, 1315, 109, 3, 70, "Input",
 CellID->2764],
Cell[47110, 1320, 179, 5, 36, "Output",
 CellID->49212213]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47338, 1331, 62, 1, 70, "Subsection",
 CellID->18752],
Cell[47403, 1334, 602, 16, 70, "Text",
 CellID->4100],
Cell[48008, 1352, 1584, 52, 70, "DefinitionBox",
 CellID->26208],
Cell[49595, 1406, 58, 1, 70, "Caption",
 CellID->9865],
Cell[49656, 1409, 256, 9, 70, "MathCaption",
 CellID->16539],
Cell[CellGroupData[{
Cell[49937, 1422, 324, 10, 70, "Input",
 CellID->9592],
Cell[50264, 1434, 244, 8, 36, "Output",
 CellID->91552971]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50557, 1448, 56, 1, 70, "Subsection",
 CellID->25972],
Cell[50616, 1451, 578, 17, 70, "Text",
 CellID->3922],
Cell[51197, 1470, 2850, 86, 70, "DefinitionBox",
 CellID->21045],
Cell[54050, 1558, 66, 1, 70, "Caption",
 CellID->29064],
Cell[54119, 1561, 163, 6, 70, "MathCaption",
 CellID->22789],
Cell[CellGroupData[{
Cell[54307, 1571, 151, 4, 70, "Input",
 CellID->31613],
Cell[54461, 1577, 176, 5, 36, "Output",
 CellID->59631828]
}, Open  ]],
Cell[54652, 1585, 1243, 44, 70, "Text",
 CellID->96075275],
Cell[55898, 1631, 117, 3, 70, "MathCaption",
 CellID->4623],
Cell[CellGroupData[{
Cell[56040, 1638, 437, 15, 70, "Input",
 CellID->15901],
Cell[56480, 1655, 163, 5, 36, "Output",
 CellID->475960883]
}, Open  ]],
Cell[56658, 1663, 1329, 47, 70, "Text",
 CellID->149228161],
Cell[57990, 1712, 109, 3, 70, "MathCaption",
 CellID->24570],
Cell[CellGroupData[{
Cell[58124, 1719, 150, 4, 70, "Input",
 CellID->1157],
Cell[58277, 1725, 176, 5, 36, "Output",
 CellID->132574427]
}, Open  ]],
Cell[58468, 1733, 134, 4, 70, "MathCaption",
 CellID->22837],
Cell[CellGroupData[{
Cell[58627, 1741, 619, 20, 70, "Input",
 CellID->11891],
Cell[59249, 1763, 163, 5, 36, "Output",
 CellID->533165511]
}, Open  ]],
Cell[59427, 1771, 177, 4, 70, "Text",
 CellID->4390]
}, Open  ]],
Cell[CellGroupData[{
Cell[59641, 1780, 67, 1, 70, "Subsection",
 CellID->98],
Cell[59711, 1783, 549, 12, 70, "Text",
 CellID->27619],
Cell[60263, 1797, 400, 13, 70, "DefinitionBox",
 CellID->27296],
Cell[60666, 1812, 69, 1, 70, "Caption",
 CellID->3764],
Cell[60738, 1815, 113, 3, 70, "MathCaption",
 CellID->18223],
Cell[CellGroupData[{
Cell[60876, 1822, 239, 7, 70, "Input",
 CellID->6607],
Cell[61118, 1831, 378, 12, 39, "Output",
 CellID->252904566]
}, Open  ]],
Cell[61511, 1846, 131, 4, 70, "MathCaption",
 CellID->790],
Cell[CellGroupData[{
Cell[61667, 1854, 346, 11, 70, "Input",
 CellID->22599],
Cell[62016, 1867, 377, 12, 36, "Output",
 CellID->81347043]
}, Open  ]],
Cell[62408, 1882, 160, 4, 70, "MathCaption",
 CellID->4257],
Cell[CellGroupData[{
Cell[62593, 1890, 151, 4, 70, "Input",
 CellID->2216],
Cell[62747, 1896, 431, 14, 39, "Output",
 CellID->87687678]
}, Open  ]],
Cell[63193, 1913, 942, 21, 70, "Text",
 CellID->18037]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64184, 1940, 83, 1, 70, "Section",
 CellID->20994],
Cell[64270, 1943, 1181, 30, 70, "Text",
 CellID->21113],
Cell[65454, 1975, 1260, 38, 70, "Text",
 CellID->2483],
Cell[66717, 2015, 3466, 109, 70, "DefinitionBox",
 CellID->30234],
Cell[70186, 2126, 106, 3, 70, "Caption",
 CellID->1748],
Cell[70295, 2131, 6539, 201, 70, "Text",
 CellID->28228],
Cell[76837, 2334, 6241, 188, 70, "Text",
 CellID->22726],
Cell[83081, 2524, 3544, 118, 70, "Text",
 CellID->11709],
Cell[86628, 2644, 2789, 90, 70, "Text",
 CellID->19601],
Cell[89420, 2736, 3943, 130, 70, "DefinitionBox",
 CellID->17755],
Cell[93366, 2868, 136, 4, 70, "Caption",
 CellID->4061],
Cell[93505, 2874, 1443, 47, 70, "Text",
 CellID->13223],
Cell[94951, 2923, 2134, 68, 70, "Text",
 CellID->6278],
Cell[97088, 2993, 877, 29, 70, "Text",
 CellID->695677167],
Cell[97968, 3024, 88, 1, 70, "MathCaption",
 CellID->10160],
Cell[CellGroupData[{
Cell[98081, 3029, 514, 19, 70, "Input",
 CellID->10883],
Cell[98598, 3050, 557, 21, 55, "Output",
 CellID->220139620]
}, Open  ]],
Cell[99170, 3074, 83, 1, 70, "MathCaption",
 CellID->1404],
Cell[CellGroupData[{
Cell[99278, 3079, 202, 7, 70, "Input",
 CellID->22741],
Cell[99483, 3088, 928, 33, 91, "Output",
 CellID->254524342]
}, Open  ]],
Cell[100426, 3124, 98, 2, 70, "MathCaption",
 CellID->3415],
Cell[CellGroupData[{
Cell[100549, 3130, 300, 10, 28, "Input",
 CellID->714349960],
Cell[100852, 3142, 19030, 316, 158, "Output",
 Evaluatable->False,
 CellID->480102087]
}, Open  ]],
Cell[119897, 3461, 501, 17, 70, "MathCaption",
 CellID->29175],
Cell[CellGroupData[{
Cell[120423, 3482, 195, 7, 70, "Input",
 CellID->31527],
Cell[120621, 3491, 178, 5, 36, "Output",
 CellID->124847979]
}, Open  ]],
Cell[120814, 3499, 724, 22, 70, "Text",
 CellID->453528901],
Cell[121541, 3523, 245, 8, 70, "MathCaption",
 CellID->26614],
Cell[CellGroupData[{
Cell[121811, 3535, 1366, 47, 107, "Input",
 CellID->241750428],
Cell[123180, 3584, 2812, 50, 142, "Output",
 Evaluatable->False,
 CellID->120169904]
}, Open  ]],
Cell[126007, 3637, 235, 8, 70, "MathCaption",
 CellID->11382],
Cell[CellGroupData[{
Cell[126267, 3649, 868, 26, 70, "Input",
 CellID->22849],
Cell[127138, 3677, 178, 5, 36, "Output",
 CellID->313931302]
}, Open  ]],
Cell[127331, 3685, 316, 11, 70, "MathCaption",
 CellID->20212],
Cell[CellGroupData[{
Cell[127672, 3700, 418, 14, 70, "Input",
 CellID->10886],
Cell[128093, 3716, 175, 5, 36, "Output",
 CellID->3695569]
}, Open  ]],
Cell[128283, 3724, 511, 17, 70, "DefinitionBox",
 CellID->31553],
Cell[128797, 3743, 141, 4, 70, "Caption",
 CellID->19548],
Cell[128941, 3749, 1777, 51, 70, "Text",
 CellID->14499],
Cell[130721, 3802, 1851, 55, 70, "DefinitionBox",
 CellID->6900],
Cell[132575, 3859, 87, 1, 70, "Caption",
 CellID->27841],
Cell[132665, 3862, 203, 7, 70, "MathCaption",
 CellID->654],
Cell[CellGroupData[{
Cell[132893, 3873, 168, 5, 70, "Input",
 CellID->32570],
Cell[133064, 3880, 619, 20, 36, "Output",
 CellID->1004537557]
}, Open  ]],
Cell[133698, 3903, 113, 3, 70, "MathCaption",
 CellID->18152],
Cell[CellGroupData[{
Cell[133836, 3910, 146, 4, 70, "Input",
 CellID->28468],
Cell[133985, 3916, 177, 5, 36, "Output",
 CellID->320629128]
}, Open  ]],
Cell[134177, 3924, 467, 16, 70, "MathCaption",
 CellID->4696],
Cell[CellGroupData[{
Cell[134669, 3944, 878, 26, 65, "Input",
 CellID->27036],
Cell[135550, 3972, 5617, 96, 201, "Output",
 Evaluatable->False,
 CellID->41651969]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[141216, 4074, 69, 1, 70, "Section",
 CellID->7373],
Cell[141288, 4077, 208, 5, 70, "Text",
 CellID->397],
Cell[141499, 4084, 1910, 61, 70, "DefinitionBox",
 CellID->15124],
Cell[143412, 4147, 81, 1, 70, "Caption",
 CellID->360],
Cell[143496, 4150, 1085, 38, 70, "Text",
 CellID->14126],
Cell[144584, 4190, 1733, 55, 70, "Text",
 CellID->21640],
Cell[146320, 4247, 1974, 70, 70, "Text",
 CellID->30119],
Cell[148297, 4319, 3628, 119, 70, "DefinitionBox",
 CellID->18228],
Cell[151928, 4440, 124, 4, 70, "Caption",
 CellID->4741],
Cell[152055, 4446, 847, 31, 70, "Text",
 CellID->5271],
Cell[152905, 4479, 548, 19, 70, "Text",
 CellID->13948],
Cell[153456, 4500, 122, 3, 70, "MathCaption",
 CellID->30229],
Cell[CellGroupData[{
Cell[153603, 4507, 272, 9, 70, "Input",
 CellID->20609],
Cell[153878, 4518, 312, 11, 36, "Output",
 CellID->51575552]
}, Open  ]],
Cell[154205, 4532, 88, 1, 70, "MathCaption",
 CellID->711734026],
Cell[CellGroupData[{
Cell[154318, 4537, 202, 7, 70, "Input",
 CellID->29449],
Cell[154523, 4546, 441, 14, 39, "Output",
 CellID->20042507]
}, Open  ]],
Cell[154979, 4563, 99, 2, 70, "MathCaption",
 CellID->30000],
Cell[CellGroupData[{
Cell[155103, 4569, 678, 22, 47, "Input",
 CellID->7929],
Cell[155784, 4593, 1271, 25, 382, "Output",
 Evaluatable->False,
 CellID->476610781]
}, Open  ]],
Cell[157070, 4621, 339, 12, 70, "MathCaption",
 CellID->23808],
Cell[CellGroupData[{
Cell[157434, 4637, 170, 6, 70, "Input",
 CellID->760],
Cell[157607, 4645, 177, 5, 36, "Output",
 CellID->131370282]
}, Open  ]],
Cell[157799, 4653, 128, 4, 70, "MathCaption",
 CellID->14993],
Cell[CellGroupData[{
Cell[157952, 4661, 672, 20, 70, "Input",
 CellID->8472],
Cell[158627, 4683, 869, 28, 75, "Output",
 CellID->187841409]
}, Open  ]],
Cell[159511, 4714, 88, 1, 70, "MathCaption",
 CellID->18634],
Cell[CellGroupData[{
Cell[159624, 4719, 772, 23, 70, "Input",
 CellID->16766],
Cell[160399, 4744, 392, 13, 36, "Output",
 CellID->463264433]
}, Open  ]],
Cell[160806, 4760, 1076, 32, 70, "DefinitionBox",
 CellID->8853],
Cell[161885, 4794, 87, 1, 70, "Caption",
 CellID->31851],
Cell[161975, 4797, 140, 4, 70, "MathCaption",
 CellID->22139],
Cell[CellGroupData[{
Cell[162140, 4805, 757, 22, 70, "Input",
 CellID->22275],
Cell[162900, 4829, 426, 15, 54, "Output",
 CellID->228709574]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[163365, 4849, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

